/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import org.basex.api.client.ClientSession;
import org.basex.api.client.LocalSession;
import org.basex.api.client.Session;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.Exit;
import org.basex.core.parse.CommandParser;
import org.basex.core.parse.PasswordReader;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryException;
import org.basex.util.Main;
import org.basex.util.Util;

public abstract class CLI
extends Main {
    public Context context;
    protected final ArrayList<Map.Entry<String, String>> commands = new ArrayList();
    protected OutputStream out = System.out;
    protected boolean verbose;
    private static final PasswordReader PWREADER = () -> {
        Util.print(Text.PASSWORD + ": ", new Object[0]);
        return Util.password();
    };
    private Session session;

    protected CLI(Context ctx, String ... args) throws IOException {
        super(args);
        this.context = ctx;
        this.parseArgs();
        if (this.context != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(this.context::close));
        }
    }

    protected final boolean execute(Map.Entry<String, String> command) throws IOException {
        CommandParser cp = CommandParser.get(command.getValue(), this.context);
        return this.execute(cp.path(command.getKey()).pwReader(PWREADER));
    }

    protected final boolean execute(CommandParser parser) throws IOException {
        try {
            for (Command cmd : parser.parse()) {
                if (cmd instanceof Exit) {
                    return false;
                }
                this.execute(cmd, this.verbose);
            }
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
        return true;
    }

    protected final void execute(Command cmd, boolean info) throws IOException {
        Session ss = this.session();
        ss.execute(cmd);
        if (info) {
            Util.print(ss.info(), new Object[0]);
        }
    }

    protected final Session session() throws IOException {
        if (this.session == null) {
            this.session = this.init();
        }
        this.session.setOutputStream(this.out);
        return this.session;
    }

    private Session init() throws IOException {
        if (this.local()) {
            return new LocalSession(this.context, this.out);
        }
        String username = this.context.soptions.get(StaticOptions.USER);
        String password = this.context.soptions.get(StaticOptions.PASSWORD);
        while (username.isEmpty()) {
            Util.print(Text.USERNAME + ": ", new Object[0]);
            username = Util.input();
        }
        while (password.isEmpty()) {
            Util.print(Text.PASSWORD + ": ", new Object[0]);
            password = Util.password();
        }
        String host = this.context.soptions.get(StaticOptions.HOST);
        int port = this.context.soptions.get(StaticOptions.PORT);
        try {
            return new ClientSession(host, port, username, password, this.out);
        }
        catch (ConnectException ex) {
            Util.debug(ex);
            throw new BaseXException(Text.CONNECTION_ERROR_X, port);
        }
    }

    protected static Map.Entry<String, String> commands(String input) throws IOException {
        return CLI.isFile(input) ? CLI.script(input) : new AbstractMap.SimpleEntry<String, String>("", input);
    }

    protected static Map.Entry<String, String> script(String input) throws IOException {
        IO io = IO.get(input);
        return new AbstractMap.SimpleEntry<String, String>(io.path(), io.readString());
    }

    protected static boolean isFile(String input) {
        IO io = IO.get(input);
        return !(io instanceof IOContent) && io.exists() && !io.isDir();
    }

    protected boolean local() {
        return true;
    }
}

