/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpHashG;
import org.basex.query.expr.CmpIR;
import org.basex.query.expr.CmpOp;
import org.basex.query.expr.CmpR;
import org.basex.query.expr.CmpRangeG;
import org.basex.query.expr.CmpSR;
import org.basex.query.expr.CmpSimpleG;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.If;
import org.basex.query.expr.List;
import org.basex.query.expr.Range;
import org.basex.query.expr.Single;
import org.basex.query.expr.Union;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.Step;
import org.basex.query.func.Function;
import org.basex.query.func.fn.ContextFn;
import org.basex.query.func.fn.FnTokenize;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.IntObjectMap;

public class CmpG
extends Cmp {
    CmpOp op;
    boolean comparable;

    public CmpG(InputInfo info, Expr expr1, Expr expr2, CmpOp op) {
        super(info, expr1, expr2, Types.BOOLEAN_O);
        this.op = op;
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        Expr expr = this.emptyExpr();
        if (expr != this) {
            return cc.replaceWith(this, cc.function(Function.BOOLEAN, this.info, expr));
        }
        AtomType t1 = this.exprs[0].seqType().type.atomic();
        AtomType t2 = this.exprs[1].seqType().type.atomic();
        if (t1 != null && t2 != null) {
            if (t1.isStringOrUntyped() && t2.isStringOrUntyped()) {
                this.exprs = this.simplifyAll(CompileContext.Simplify.STRING, cc);
            } else if (t1.isNumber() && t2.isNumber()) {
                this.exprs = this.simplifyAll(CompileContext.Simplify.NUMBER, cc);
            }
        }
        this.exprs = this.simplifyAll(CompileContext.Simplify.DISTINCT, cc);
        if (this.swap()) {
            cc.info("swap operands: %", this);
            Collections.reverse(Arrays.asList(this.exprs));
            this.op = this.op.swap();
        }
        expr = this.opt(cc);
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        if (expr == this && expr1 instanceof If) {
            If iff = (If)expr1;
            if (!expr1.has(Flag.NDT)) {
                CmpG thn = new CmpG(this.info, iff.arg(0), expr2, this.op);
                CmpG els = new CmpG(this.info, iff.arg(1), expr2.copy(cc, new IntObjectMap<Var>()), this.op);
                return new If(this.info, iff.cond, ((Expr)thn).optimize(cc), ((Expr)els).optimize(cc)).optimize(cc);
            }
        }
        if (expr == this) {
            expr = this.optArith(cc);
        }
        if (expr == this) {
            expr = CmpIR.get(cc, this, false);
        }
        if (expr == this) {
            expr = CmpR.get(cc, this);
        }
        if (expr == this) {
            expr = CmpSR.get(cc, this);
        }
        if (expr == this) {
            SeqType st1 = expr1.seqType();
            SeqType st2 = expr2.seqType();
            Type type1 = st1.type;
            Type type2 = st2.type;
            if (type1 == type2 && !type1.oneOf(AtomType.ANY_ATOMIC_TYPE, AtomType.ITEM) || type1.isUntyped() || type2.isUntyped() || type1.isNumber() && type2.isNumber() || type1.isStringOrUntyped() && type2.isStringOrUntyped() || type1.instanceOf(AtomType.BINARY) && type2.instanceOf(AtomType.BINARY) || type1.instanceOf(AtomType.DURATION) && type2.instanceOf(AtomType.DURATION)) {
                this.comparable = true;
            }
            if (st1.zeroOrOne() && !st1.mayBeArray() && st2.zeroOrOne() && !st2.mayBeArray()) {
                if (!(this instanceof CmpSimpleG)) {
                    expr = this.copyType(new CmpSimpleG(expr1, expr2, this.op, this.info));
                }
            } else if (this.op == CmpOp.EQ && this.sc().collation == null && !st2.zeroOrOne() && (type1.isNumber() && type2.isNumber() || type1.isStringOrUntyped() && type2.isStringOrUntyped() || type1 == AtomType.BOOLEAN && type2 == AtomType.BOOLEAN)) {
                if (!(this instanceof CmpHashG)) {
                    expr = this.copyType(new CmpHashG(expr1, expr2, this.op, this.info));
                }
            } else if (this.op == CmpOp.EQ && expr2 instanceof Range && type1.isNumberOrUntyped() && !(this instanceof CmpRangeG)) {
                expr = this.copyType(new CmpRangeG(expr1, expr2, this.op, this.info));
            }
            if (this.values(false, cc)) {
                Value ex = cc.preEval(expr);
                if (expr instanceof CmpHashG) {
                    CmpHashG cmp = (CmpHashG)expr;
                    cc.qc.threads.get(cmp, this.info).remove();
                }
                return ex;
            }
        }
        return expr instanceof CmpG ? expr : cc.replaceWith(this, expr);
    }

    private Expr optArith(CompileContext cc) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        Expr ex = null;
        if (expr1 instanceof Arith) {
            Arith arth = (Arith)expr1;
            if (expr2.seqType().instanceOf(Types.NUMERIC_O)) {
                double num12;
                Expr op11 = expr1.arg(0);
                Expr op12 = expr1.arg(1);
                Expr op22 = expr2.arg(1);
                if (op12 instanceof ANum) {
                    ANum num = (ANum)op12;
                    v0 = num.dbl();
                } else {
                    v0 = num12 = Double.NaN;
                }
                if (op12.seqType().instanceOf(Types.NUMERIC_O)) {
                    Calc calc1 = arth.calc;
                    if (calc1 == Calc.SUBTRACT && expr2 == Itr.ZERO) {
                        ex = new CmpG(this.info, op11, op12, this.op);
                    } else if ((Function.POSITION.is(op11) || !Double.isNaN(num12) && (expr2 instanceof ANum || expr2 instanceof Arith && op22 instanceof ANum)) && (calc1.oneOf(Calc.ADD, Calc.SUBTRACT) || calc1.oneOf(Calc.MULTIPLY, Calc.DIVIDE) && num12 != 0.0 && (this.op.oneOf(CmpOp.EQ, CmpOp.NE) || num12 > 0.0))) {
                        Expr arg2 = new Arith(this.info, expr2, op12, calc1.invert()).optimize(cc);
                        ex = new CmpG(this.info, op11, arg2, this.op);
                    }
                }
            }
        }
        return ex != null ? ex.optimize(cc) : this;
    }

    @Override
    public final Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.test(qc, ii, 0L));
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        Iter iter1 = this.exprs[0].atomIter(qc, this.info);
        long size1 = iter1.size();
        if (size1 == 0L) {
            return false;
        }
        Iter iter2 = this.exprs[1].atomIter(qc, this.info);
        long size2 = iter2.size();
        return size2 != 0L && this.compare(iter1, iter2, size1, size2, qc);
    }

    boolean compare(Iter iter1, Iter iter2, long size1, long size2, QueryContext qc) throws QueryException {
        if (size1 < size2 || size2 == -1L) {
            Item item1;
            Iter ir2 = iter2;
            while ((item1 = iter1.next()) != null) {
                Item item2;
                if (ir2 == null) {
                    ir2 = this.exprs[1].atomIter(qc, this.info);
                }
                while ((item2 = qc.next(ir2)) != null) {
                    if (!this.eval(item1, item2)) continue;
                    return true;
                }
                ir2 = null;
            }
        } else {
            Item item2;
            Iter ir1 = iter1;
            while ((item2 = iter2.next()) != null) {
                Item item1;
                if (ir1 == null) {
                    ir1 = this.exprs[0].atomIter(qc, this.info);
                }
                while ((item1 = qc.next(ir1)) != null) {
                    if (!this.eval(item1, item2)) continue;
                    return true;
                }
                ir1 = null;
            }
        }
        return false;
    }

    final boolean eval(Item item1, Item item2) throws QueryException {
        if (this.comparable || item1.comparable(item2) || item1.type.isUntyped() || item2.type.isUntyped()) {
            return this.op.eval(item1.compare(item2, null, false, this.info));
        }
        throw QueryError.compareError(item1, item2, this.info);
    }

    public static boolean compatible(SeqType st1, SeqType st2, CmpOp op) {
        Type type1 = st1.type;
        Type type2 = st2.type;
        return type1 == type2 && !AtomType.ANY_ATOMIC_TYPE.instanceOf(type1) && (type1.isSortable() || !op.oneOf(CmpOp.EQ, CmpOp.NE)) || type1.isStringOrUntyped() && type2.isStringOrUntyped() || type1 == AtomType.QNAME && type2 == AtomType.QNAME || type1.instanceOf(AtomType.NUMERIC) && type2.instanceOf(AtomType.NUMERIC) || type1.instanceOf(AtomType.DURATION) && type2.instanceOf(AtomType.DURATION);
    }

    @Override
    public final CmpG invert() {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        return st1.one() && !st1.mayBeArray() && st2.one() && !st2.mayBeArray() ? new CmpG(this.info, expr1, expr2, this.op.invert()) : null;
    }

    @Override
    public final CmpOp cmpOp() {
        return this.op;
    }

    @Override
    public Expr mergeEbv(Expr expr, boolean or, CompileContext cc) throws QueryException {
        boolean seqR2;
        CmpOp cmpOp;
        Expr expr2;
        if (expr instanceof Single) {
            return expr.mergeEbv(this, or, cc);
        }
        boolean not2 = Function.NOT.is(expr);
        Expr expr3 = expr2 = not2 ? expr.arg(0) : expr;
        if (!(expr2 instanceof CmpG)) {
            return null;
        }
        CmpG cmp2 = (CmpG)expr2;
        CmpOp cmpOp2 = cmpOp = not2 ? cmp2.op.invert() : cmp2.op;
        if (this.op != cmpOp || this.sc().collation != cmp2.sc().collation || !this.exprs[0].equals(cmp2.exprs[0])) {
            return null;
        }
        Expr exprL = this.exprs[0];
        Expr exprR1 = this.exprs[1];
        Expr exprR2 = cmp2.exprs[1];
        QueryFunction<CmpOp, Expr> newList = newOp -> {
            Expr exprR = List.get(cc, this.info, exprR1, exprR2);
            return new CmpG(this.info, exprL, exprR, (CmpOp)((Object)newOp)).optimize(cc);
        };
        boolean seqL = !exprL.seqType().one();
        boolean seqR1 = !exprR1.seqType().one();
        boolean bl = seqR2 = !exprR2.seqType().one();
        if (or) {
            if (not2 && (seqR2 || seqL)) {
                return null;
            }
            expr2 = newList.apply(this.op);
        } else {
            if (seqL || seqR1 || seqR2 && !not2) {
                return null;
            }
            expr2 = cc.function(Function.NOT, this.info, newList.apply(this.op.invert()));
        }
        return expr2;
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        CmpG ex = mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE) ? this.optPred(cc) : this;
        return cc.simplify(this, ex, mode);
    }

    private Expr optPred(CompileContext cc) throws QueryException {
        Value val = cc.qc.focus.value;
        if (val == null) {
            return this;
        }
        Type type = val.seqType().type;
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        if (type instanceof NodeType && type != NodeType.NODE && expr1 instanceof ContextFn) {
            ContextFn fn = (ContextFn)expr1;
            if (expr2 instanceof Value) {
                Value value = (Value)expr2;
                if (this.op == CmpOp.EQ) {
                    if (fn.exprs.length > 0 && !(fn.exprs[0] instanceof ContextValue)) {
                        return this;
                    }
                    ArrayList<QNm> qnames = new ArrayList<QNm>();
                    NameTest.Scope scope = null;
                    if (expr2.seqType().type.isStringOrUntyped()) {
                        if (Function.LOCAL_NAME.is(fn)) {
                            scope = NameTest.Scope.LOCAL;
                            for (Item item : value) {
                                byte[] name = item.string(this.info);
                                if (!XMLToken.isNCName(name)) continue;
                                qnames.add(new QNm(name));
                            }
                        } else if (Function.NAMESPACE_URI.is(fn)) {
                            for (Item item : value) {
                                uri = item.string(this.info);
                                if (!Token.eq(Token.normalize(uri), uri)) continue;
                                qnames.add(new QNm(Token.cpToken(58), (byte[])uri));
                            }
                            if ((long)qnames.size() == value.size()) {
                                scope = NameTest.Scope.URI;
                            }
                        } else if (Function.NAME.is(fn)) {
                            byte[] dataNs;
                            Data data = cc.qc.focus.value.data();
                            byte[] byArray = dataNs = data != null ? data.defaultNs() : null;
                            if (dataNs != null && dataNs.length == 0) {
                                scope = NameTest.Scope.LOCAL;
                                uri = value.iterator();
                                while (uri.hasNext()) {
                                    Item item = (Item)uri.next();
                                    byte[] name = item.string(this.info);
                                    if (!XMLToken.isNCName(name)) continue;
                                    qnames.add(new QNm(name));
                                }
                            }
                        }
                    } else if (Function.NODE_NAME.is(fn) && expr2.seqType().type == AtomType.QNAME) {
                        scope = NameTest.Scope.FULL;
                        for (Item item : value) {
                            qnames.add((QNm)item);
                        }
                    }
                    if (scope != null) {
                        ExprList paths = new ExprList(2L);
                        for (QNm qname : qnames) {
                            NameTest test = new NameTest(qname, scope, (NodeType)type, this.sc().elemNS);
                            Expr step = Step.self(cc, null, this.info, test, new Expr[0]);
                            if (step == Empty.VALUE) continue;
                            paths.add(Path.get(cc, this.info, null, step));
                        }
                        return paths.isEmpty() ? Bln.FALSE : (paths.size() == 1 ? (Expr)paths.get(0) : new Union(this.info, (Expr[])paths.finish()).optimize(cc));
                    }
                }
            }
        }
        return this;
    }

    @Override
    public final boolean indexAccessible(IndexInfo ii) throws QueryException {
        if (this.op != CmpOp.EQ || this.sc().collation != null) {
            return false;
        }
        Expr expr1 = this.exprs[0];
        IndexType type = null;
        if (Function.TOKENIZE.is(expr1)) {
            if (!expr1.arg(0).seqType().zeroOrOne() || !((FnTokenize)expr1).whitespace()) {
                return false;
            }
            expr1 = expr1.arg(0);
            type = IndexType.TOKEN;
        }
        return ii.create(this.exprs[1], ii.type(expr1, type), false, this.info);
    }

    @Override
    public CmpG copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new CmpG(this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.op));
    }

    final CmpG copyType(CmpG cmp) {
        cmp.comparable = this.comparable;
        return super.copyType(cmp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof CmpG)) return false;
        CmpG cmp = (CmpG)obj;
        if (this.op != cmp.op) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public String description() {
        return String.valueOf((Object)this.op) + " comparison";
    }

    @Override
    public final void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[]{"op", this.op}), this.exprs);
    }

    @Override
    public final void toString(QueryString qs) {
        qs.tokens(this.exprs, " " + String.valueOf((Object)this.op) + " ", true);
    }
}

