/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.core.MainOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.NSContext;
import org.basex.query.util.hash.QNmSet;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class Constr {
    public QNm errAtt;
    public QNm duplAtt;
    QNm errNS;
    byte[] duplNS;
    private final FBuilder builder;
    private final QueryContext qc;
    private final InputInfo info;
    private final TokenBuilder text = new TokenBuilder();
    private boolean more;

    public Constr(FBuilder builder, InputInfo info, QueryContext qc) {
        this.builder = builder;
        this.info = info;
        this.qc = qc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constr add(Expr ... exprs) throws QueryException {
        NSContext ns = this.info.sc().ns;
        int size = ns.size();
        try {
            QNmSet qnames = new QNmSet();
            for (Expr expr : exprs) {
                Item item;
                this.more = false;
                Iter iter = expr.iter(this.qc);
                while ((item = this.qc.next(iter)) != null && this.add(item, qnames)) {
                }
            }
            this.builder.add(this.qc.shared.token(this.text.toArray()));
            Constr constr = this;
            return constr;
        }
        finally {
            ns.size(size);
        }
    }

    private boolean add(Item item, QNmSet qnames) throws QueryException {
        if (item instanceof XQArray) {
            XQArray array = (XQArray)item;
            for (Value value : array.iterable()) {
                for (Item it : value) {
                    if (this.add(it, qnames)) continue;
                    return false;
                }
            }
            return true;
        }
        if (item instanceof FItem) {
            throw QueryError.CONSFUNC_X.get(this.info, item);
        }
        if (item instanceof ANode) {
            ANode node = (ANode)item;
            Type type = item.type;
            if (type == NodeType.TEXT) {
                this.text.add(node.string());
            } else if (type == NodeType.ATTRIBUTE) {
                QNm name = node.qname();
                if (!this.text.isEmpty() || this.builder.children != null) {
                    this.errAtt = name;
                    return false;
                }
                if (!qnames.add(name)) {
                    this.duplAtt = name;
                    return false;
                }
                this.builder.add(name, this.qc.shared.token(node.string()));
                if (name.hasURI()) {
                    this.info.sc().ns.add(name.prefix(), name.uri());
                }
            } else if (type == NodeType.NAMESPACE_NODE) {
                byte[] knownUri;
                if (!this.text.isEmpty() || this.builder.children != null) {
                    this.errNS = node.qname();
                    return false;
                }
                byte[] name = node.name();
                byte[] uri = node.string();
                byte[] byArray = knownUri = this.builder.namespaces == null ? null : this.builder.namespaces.value(name);
                if (knownUri == null) {
                    this.builder.addNS(name, uri);
                } else if (!Token.eq(uri, knownUri)) {
                    this.duplNS = name;
                    return false;
                }
            } else if (type == NodeType.DOCUMENT_NODE) {
                Item it;
                BasicNodeIter iter = node.childIter();
                while ((it = this.qc.next(iter)) != null && this.add(it, qnames)) {
                }
            } else {
                this.builder.add(this.qc.shared.token(this.text.next()));
                boolean keep = this.qc.context.options.get(MainOptions.COPYNODE) == false;
                this.builder.add((ANode)node.materialize(n -> keep, this.info, this.qc));
            }
            this.more = false;
        } else {
            if (this.more) {
                this.text.add(32);
            }
            this.text.add(item.string(this.info));
            this.more = true;
        }
        return true;
    }

    void namespaces(Atts staticNs, QNm nm) throws QueryException {
        Atts dynamicNs = this.builder.namespaces;
        int sNs = staticNs.size();
        int dNs = dynamicNs == null ? 0 : dynamicNs.size();
        Atts inscopeNS = new Atts(sNs + dNs);
        for (int n = 0; n < sNs; ++n) {
            this.add(inscopeNS, staticNs.name(n), staticNs.value(n));
        }
        byte[] nmPrefix = nm.prefix();
        byte[] nmUri = nm.uri();
        if (!Token.eq(nmPrefix, Token.XML)) {
            int defaultNS;
            int n = defaultNS = dNs != 0 ? dynamicNs.get(Token.EMPTY) : -1;
            if (defaultNS != -1) {
                if (nm.uri().length == 0) {
                    throw QueryError.EMPTYNSCONS.get(this.info, new Object[0]);
                }
                int scope = inscopeNS.get(Token.EMPTY);
                byte[] scopeUri = scope != -1 ? inscopeNS.value(scope) : this.info.sc().ns.uri(Token.EMPTY);
                byte[] uri = dynamicNs.value(defaultNS);
                if (scopeUri != null && scopeUri.length != 0 && !Token.eq(scopeUri, uri)) {
                    throw QueryError.DUPLNSCONS_X.get(this.info, new Object[]{uri});
                }
            }
            if (nm.hasURI() && !inscopeNS.contains(nmPrefix)) {
                this.add(inscopeNS, nmPrefix, nmUri);
            }
        }
        for (int n = 0; n < dNs; ++n) {
            this.addNS(inscopeNS, dynamicNs.name(n), dynamicNs.value(n));
        }
        ANodeList attributes = this.builder.attributes;
        if (attributes != null) {
            int as = attributes.size();
            for (int a = 0; a < as; ++a) {
                byte[] auri;
                byte[] npref;
                byte[] prefix;
                ANode attr = (ANode)attributes.get(a);
                QNm qnm = attr.qname();
                if (!qnm.hasPrefix() || !qnm.hasURI() || Token.eq(prefix = qnm.prefix(), Token.XML) || (npref = this.addNS(inscopeNS, prefix, auri = qnm.uri())) == null) continue;
                QNm aname = this.qc.shared.qName(Token.concat(npref, Token.cpToken(58), qnm.local()), auri);
                attributes.set(a, new FAttr(aname, this.qc.shared.token(attr.string())));
            }
        }
        this.builder.namespaces = inscopeNS.isEmpty() ? null : inscopeNS;
    }

    private byte[] addNS(Atts inscopeNS, byte[] prefix, byte[] uri) {
        byte[] u = inscopeNS.value(prefix);
        if (u == null) {
            this.add(inscopeNS, prefix, uri);
        } else if (!Token.eq(u, uri)) {
            byte[] pref = null;
            int ns = inscopeNS.size();
            for (int n = 0; n < ns; ++n) {
                if (!Token.eq(inscopeNS.value(n), uri)) continue;
                pref = inscopeNS.name(n);
            }
            if (pref == null) {
                int i = 1;
                while (inscopeNS.contains(pref = Token.concat(prefix, "_", i++))) {
                }
                this.add(inscopeNS, pref, uri);
            }
            return pref;
        }
        return null;
    }

    private void add(Atts inscopeNS, byte[] prefix, byte[] uri) {
        inscopeNS.add(this.qc.shared.token(prefix), this.qc.shared.token(uri));
    }
}

