/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.map;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.HofArgs;
import org.basex.query.func.map.MapMerge;
import org.basex.query.func.map.ValueMerger;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.InputInfo;

public final class MapBuild
extends MapMerge {
    @Override
    public XQMap item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Iter input = this.arg(0).iter(qc);
        FItem keys = this.toFunctionOrNull(this.arg(1), 2, qc);
        FItem value = this.toFunctionOrNull(this.arg(2), 2, qc);
        MapMerge.MergeOptions options = this.toOptions(this.arg(3), new MapMerge.MergeOptions(), qc);
        ValueMerger merger = this.merger(options, qc, MapMerge.Duplicates.COMBINE);
        HofArgs args = new HofArgs(2, keys, value);
        MapBuilder builder = new MapBuilder(input.size());
        while ((item = qc.next(input)) != null) {
            Item key;
            args.set(0, item).inc();
            Iter iter = (keys != null ? this.invoke(keys, args, qc) : item).atomIter(qc, this.info);
            while ((key = qc.next(iter)) != null) {
                Value old = builder.get(key);
                Value val = merger.merge(key, old, value != null ? this.invoke(value, args, qc) : item);
                if (val == null) continue;
                builder.put(key, val);
            }
        }
        return builder.map(this);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        SeqType vt;
        Type kt;
        this.prepareMerge(3, MapMerge.Duplicates.COMBINE, cc);
        Expr input = this.arg(0);
        Expr keys = this.arg(1);
        Expr value = this.arg(2);
        SeqType st = input.seqType();
        SeqType s1t = st.with(Occ.EXACTLY_ONE);
        if (st.zero()) {
            return cc.voidAndReturn(input, XQMap.empty(), this.info);
        }
        boolean noKey = keys.size() == 0L;
        boolean fiKey = keys instanceof FuncItem;
        Type type = kt = noKey || fiKey ? s1t.type : AtomType.ITEM;
        if (fiKey) {
            this.arg(1, arg -> MapBuild.refineFunc(arg, cc, s1t));
            kt = this.arg((int)1).funcType().declType.type;
        }
        kt = kt.atomic();
        boolean noValue = value.size() == 0L;
        boolean fiValue = value instanceof FuncItem;
        SeqType seqType = vt = noValue || fiValue ? s1t : Types.ITEM_ZM;
        if (fiValue) {
            this.arg(2, arg -> MapBuild.refineFunc(arg, cc, s1t));
            vt = this.arg((int)2).funcType().declType;
        }
        this.assignType(kt, vt);
        return this;
    }

    @Override
    public long structSize() {
        Expr input = this.arg(0);
        Expr keys = this.arg(1);
        return input instanceof RangeSeq && keys.size() == 0L ? input.size() : -1L;
    }

    @Override
    public int hofOffsets() {
        return this.defined(3) ? Integer.MAX_VALUE : this.hofOffset(1) | this.hofOffset(2);
    }
}

