/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqparser.v10;

import java.io.CharArrayReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequenceType;
import javax.xml.xquery.XQStaticContext;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.xqitemtype.XQItemTypeFactory;
import net.xqj.core.xqparser.Context;
import net.xqj.core.xqparser.ExternalVariable;
import net.xqj.core.xqparser.XQueryStatement;
import net.xqj.core.xqparser.v10.Node;
import net.xqj.core.xqparser.v10.SimpleNode;
import net.xqj.core.xqparser.v10.XParser;

public class XQueryStatement10
extends XQueryStatement {
    protected static XQueryStatement10 reusableSequenceTypeStatement = null;
    protected static XParser reusableSequenceTypeParser = null;

    public XQueryStatement10(char[] query, XQStaticContext staticContext) throws Exception {
        super(query, staticContext);
        XParser parser = new XParser(new CharArrayReader(query));
        SimpleNode tree = parser.START();
        this.parse(tree);
    }

    public XQueryStatement10() throws Exception {
    }

    public static XQSequenceType parseXQSequenceType(Reader reader) throws Exception {
        if (reusableSequenceTypeStatement == null) {
            reusableSequenceTypeStatement = new XQueryStatement10();
        }
        if (reusableSequenceTypeParser == null) {
            reusableSequenceTypeParser = new XParser(new CharArrayReader(new char[0]));
        }
        reusableSequenceTypeParser.ReInit(reader);
        reusableSequenceTypeParser.SequenceType();
        return reusableSequenceTypeStatement.getXQSequenceTypeFromSequenceType(reusableSequenceTypeParser.getRootNode());
    }

    private void parse(SimpleNode node) throws XQException {
        switch (node.id) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 17: 
            case 20: {
                this.parse(node.children);
                break;
            }
            case 8: {
                this.prologStartIndex = node.beginIndex;
                this.parse(node.children);
                break;
            }
            case 28: {
                this.parseVariable(node);
                this.parse(node.children);
                break;
            }
            case 12: {
                this.parseNamespace(node);
                break;
            }
            case 14: {
                this.parseDefaultNamespaceDecl(node);
                break;
            }
            case 23: {
                this.parseDefaultCollationDecl(node);
                break;
            }
            case 30: {
                this.parseConstructionDecl(node);
                break;
            }
            case 13: {
                this.parseBoundarySpaceDecl(node);
                break;
            }
            case 24: {
                this.parseBaseURIDecl(node);
                break;
            }
            case 21: {
                this.parsePreserveMode(node);
                break;
            }
            case 22: {
                this.parseInheritMode(node);
                break;
            }
            case 15: {
                this.parseOption(node);
                break;
            }
            case 100: {
                this.parseContextItemExpr(node);
                break;
            }
            case 81: 
            case 82: {
                this.parseSlashOrSlashSlashExpr(node);
                break;
            }
            default: {
                this.parse(node.children);
            }
        }
    }

    private void parse(Node[] node) throws XQException {
        if (node == null) {
            return;
        }
        for (int i = 0; i < node.length; ++i) {
            this.parse((SimpleNode)node[i]);
        }
    }

    private static final SimpleNode getChild(SimpleNode node, int childIndex) {
        return (SimpleNode)node.jjtGetChild(childIndex);
    }

    private XQSequenceType getXQSequenceTypeFromSequenceType(SimpleNode SequenceType) throws XQException {
        int children = SequenceType.jjtGetNumChildren();
        XQItemType xqItemType = null;
        int occurrenceIndicator = 2;
        block9: for (int n = children - 1; n >= 0; --n) {
            SimpleNode child = XQueryStatement10.getChild(SequenceType, n);
            switch (child.id) {
                case 166: {
                    xqItemType = this.getXQItemTypeFromItemType(child);
                    continue block9;
                }
                case 165: {
                    switch (child.getValue().charAt(0)) {
                        case '*': {
                            occurrenceIndicator = 3;
                            continue block9;
                        }
                        case '+': {
                            occurrenceIndicator = 4;
                            continue block9;
                        }
                        case '?': {
                            occurrenceIndicator = 1;
                            continue block9;
                        }
                    }
                    occurrenceIndicator = 2;
                }
            }
        }
        return XQItemTypeFactory.createSequenceType(xqItemType, occurrenceIndicator);
    }

    private XQItemType getXQItemTypeFromSchemaElementTest(SimpleNode SchemaElementTest) throws XQException {
        return XQItemTypeFactory.createSchemaElementType(this.resolveQName(XQueryStatement10.getChild(XQueryStatement10.getChild(XQueryStatement10.getChild(SchemaElementTest, 0), 0), 0).getValue()), 3, null);
    }

    private XQItemType getXQItemTypeFromSchemaAttributeTest(SimpleNode SchemaAttributeTest) throws XQException {
        return XQItemTypeFactory.createSchemaAttributeType(this.resolveQName(XQueryStatement10.getChild(XQueryStatement10.getChild(XQueryStatement10.getChild(SchemaAttributeTest, 0), 0), 0).getValue()), 3, null);
    }

    private QName resolveQName(String prefixAndLocalPart) throws XQException {
        String[] arr = prefixAndLocalPart.split(":");
        if (arr.length == 1) {
            return new QName(prefixAndLocalPart);
        }
        String namespaceURI = this.nsContext.getNamespaceURI(arr[0]);
        if (namespaceURI == null && (namespaceURI = this.staticContext.getNamespaceURI(arr[0])) == null) {
            throw new XQExceptionImpl("Namespace URI for prefix \"" + arr[0] + "\" is not defined in either the XQuery Prolog or the XQStaticContext.", "XQJQS002");
        }
        return XQToolkit.getQName(arr[0], arr[1], namespaceURI);
    }

    private XQItemType getXQItemTypeFromElementTest(SimpleNode ElementTest) throws XQException {
        if (ElementTest.jjtGetNumChildren() == 0) {
            return XQItemTypeFactory.createElementType(null, 2);
        }
        QName elementQName = null;
        QName typeName = null;
        block4: for (int n = ElementTest.jjtGetNumChildren() - 1; n >= 0; --n) {
            SimpleNode child = XQueryStatement10.getChild(ElementTest, n);
            switch (child.id) {
                case 183: {
                    typeName = this.resolveQName(XQueryStatement10.getChild(child, 0).getValue());
                    continue block4;
                }
                case 178: {
                    elementQName = child.jjtGetNumChildren() == 0 ? null : this.resolveQName(XQueryStatement10.getChild(XQueryStatement10.getChild(child, 0), 0).getValue());
                }
            }
        }
        return XQItemTypeFactory.createElementType(elementQName, typeName == null ? 4 : XQToolkit.getBaseTypeFromQName(typeName));
    }

    private XQItemType getXQItemTypeFromAttributeTest(SimpleNode AttributeTest) throws XQException {
        if (AttributeTest.jjtGetNumChildren() == 0) {
            return XQItemTypeFactory.createAttributeType(null, 3);
        }
        QName attributeQName = null;
        QName typeName = null;
        block4: for (int n = AttributeTest.jjtGetNumChildren() - 1; n >= 0; --n) {
            SimpleNode child = XQueryStatement10.getChild(AttributeTest, n);
            switch (child.id) {
                case 183: {
                    typeName = this.resolveQName(XQueryStatement10.getChild(child, 0).getValue());
                    continue block4;
                }
                case 174: {
                    attributeQName = child.jjtGetNumChildren() == 0 ? null : this.resolveQName(XQueryStatement10.getChild(XQueryStatement10.getChild(child, 0), 0).getValue());
                }
            }
        }
        return XQItemTypeFactory.createAttributeType(attributeQName, XQToolkit.getBaseTypeFromQName(typeName));
    }

    private XQItemType getXQItemTypeFromItemType(SimpleNode ItemType) throws XQException {
        if (ItemType.jjtGetNumChildren() == 0) {
            return XQItemTypeFactory.createItemType();
        }
        return this.getXQItemTypeFromNodeTestOrAtomicType(XQueryStatement10.getChild(ItemType, 0));
    }

    private XQItemType getAtomicXQItemTypeFromString(String qnString) throws XQException {
        QName qname = this.resolveQName(qnString);
        if ("http://www.w3.org/2001/XMLSchema".equals(qname.getNamespaceURI())) {
            return XQItemTypeFactory.createAtomicType(XQToolkit.getBaseTypeFromQName(qname));
        }
        return XQItemTypeFactory.createAtomicType(4, qname, null);
    }

    private XQItemType getXQItemTypeFromNodeTestOrAtomicType(SimpleNode NodeTestOrAtomicType) throws XQException {
        switch (NodeTestOrAtomicType.id) {
            case 167: {
                return this.getAtomicXQItemTypeFromString(XQueryStatement10.getChild(NodeTestOrAtomicType, 0).getValue());
            }
            case 170: {
                return XQItemTypeFactory.createTextType();
            }
            case 168: {
                return XQItemTypeFactory.createNodeType();
            }
            case 177: {
                return this.getXQItemTypeFromElementTest(NodeTestOrAtomicType);
            }
            case 169: {
                return this.getXQItemTypeFromDocumentTest(NodeTestOrAtomicType);
            }
            case 171: {
                return XQItemTypeFactory.createCommentType();
            }
            case 172: {
                return this.getXQItemTypeFromPITest(NodeTestOrAtomicType);
            }
            case 173: {
                return this.getXQItemTypeFromAttributeTest(NodeTestOrAtomicType);
            }
            case 179: {
                return this.getXQItemTypeFromSchemaElementTest(NodeTestOrAtomicType);
            }
            case 175: {
                return this.getXQItemTypeFromSchemaAttributeTest(NodeTestOrAtomicType);
            }
        }
        return XQItemTypeFactory.createItemType();
    }

    private XQItemType getXQItemTypeFromDocumentTest(SimpleNode DocumentTest) throws XQException {
        if (DocumentTest.jjtGetNumChildren() == 0) {
            return XQItemTypeFactory.createDocumentType();
        }
        SimpleNode child = XQueryStatement10.getChild(DocumentTest, 0);
        return XQItemTypeFactory.createDocumentElementType(this.getXQItemTypeFromNodeTestOrAtomicType(child));
    }

    private XQItemType getXQItemTypeFromPITest(SimpleNode PITest) throws XQException {
        if (PITest.jjtGetNumChildren() == 0) {
            return XQItemTypeFactory.createProcessingInstructionType(null);
        }
        return XQItemTypeFactory.createProcessingInstructionType(XQueryStatement10.getChild(PITest, 0).getValue());
    }

    private final boolean isExternalVariable(SimpleNode VarDecl) {
        for (int n = VarDecl.jjtGetNumChildren() - 1; n >= 0; --n) {
            if (XQueryStatement10.getChild((SimpleNode)VarDecl, (int)n).id != 29) continue;
            return true;
        }
        return false;
    }

    private void parseNamespace(SimpleNode NamespaceDecl) throws XQException {
        String namespaceURI = null;
        String prefix = null;
        block4: for (int n = NamespaceDecl.jjtGetNumChildren() - 1; n >= 0; --n) {
            SimpleNode child = XQueryStatement10.getChild(NamespaceDecl, n);
            switch (child.id) {
                case 184: {
                    namespaceURI = XQToolkit.removeQuotes(XQueryStatement10.getChild(child, 0).getValue());
                    continue block4;
                }
                case 185: {
                    prefix = child.getValue();
                }
            }
        }
        this.nsContext.addNamespace(prefix, namespaceURI);
        this.foundNamespaceDeclaration = true;
    }

    private void parseVariable(SimpleNode varDecl) throws XQException {
        if (!this.isExternalVariable(varDecl)) {
            return;
        }
        QName qname = null;
        XQSequenceType xqSequenceType = null;
        int beginIndex = 0;
        int endIndex = 0;
        for (int i = 0; i < varDecl.jjtGetNumChildren(); ++i) {
            SimpleNode childNode = XQueryStatement10.getChild(varDecl, i);
            if (childNode.id == 186) {
                qname = this.resolveQName(childNode.getValue());
            }
            if (childNode.id == 163) {
                xqSequenceType = this.getXQSequenceTypeFromSequenceType(XQueryStatement10.getChild(childNode, 0));
            }
            if (childNode.id != 29) continue;
            beginIndex = childNode.beginIndex;
            endIndex = childNode.endIndex;
        }
        if (xqSequenceType == null) {
            xqSequenceType = XQItemTypeFactory.createSequenceType(XQItemTypeFactory.createItemType(), 3);
        }
        this.externalVariableTypes.put(qname, xqSequenceType);
        this.tokenSet.add(new ExternalVariable(qname, xqSequenceType, beginIndex, endIndex));
        this.foundExternalVariableDeclaration = true;
    }

    private void parseDefaultNamespaceDecl(SimpleNode DefaultNamespaceDecl) throws XQException {
        if ("element".equals(DefaultNamespaceDecl.getValue())) {
            this.defaultElementTypeNamespace = XQToolkit.removeQuotes(XQueryStatement10.getChild(XQueryStatement10.getChild(DefaultNamespaceDecl, 0), 0).getValue());
        } else if ("function".equals(DefaultNamespaceDecl.getValue())) {
            this.defaultFunctionNamespace = XQToolkit.removeQuotes(XQueryStatement10.getChild(XQueryStatement10.getChild(DefaultNamespaceDecl, 0), 0).getValue());
        }
        this.foundDefaultFunctionNamespace = true;
    }

    private void parseDefaultCollationDecl(SimpleNode DefaultCollationDecl) {
        this.defaultCollation = XQToolkit.removeQuotes(XQueryStatement10.getChild(XQueryStatement10.getChild(DefaultCollationDecl, 0), 0).getValue());
        this.foundDefaultCollation = true;
    }

    private void parseConstructionDecl(SimpleNode ConstructionDecl) {
        if ("strip".equals(ConstructionDecl.getValue())) {
            this.constructionMode = 2;
        } else if ("preserve".equals(ConstructionDecl.getValue())) {
            this.constructionMode = 1;
        }
        this.foundConstructionMode = true;
    }

    private void parseBoundarySpaceDecl(SimpleNode BoundarySpaceDecl) {
        if ("strip".equals(BoundarySpaceDecl.getValue())) {
            this.boundarySpacePolicy = 2;
        } else if ("preserve".equals(BoundarySpaceDecl.getValue())) {
            this.boundarySpacePolicy = 1;
        }
        this.foundBoundarySpacePolicy = true;
    }

    private void parseBaseURIDecl(SimpleNode BaseURIDecl) {
        this.baseUri = XQToolkit.removeQuotes(XQueryStatement10.getChild(XQueryStatement10.getChild(BaseURIDecl, 0), 0).getValue());
        this.foundBaseUri = true;
    }

    private void parsePreserveMode(SimpleNode PreserveMode) {
        if ("preserve".equals(PreserveMode.getValue())) {
            this.copyNamespacesModePreserve = 1;
        } else if ("no-preserve".equals(PreserveMode.getValue())) {
            this.copyNamespacesModePreserve = 2;
        }
        this.foundCopyNamespaces = true;
    }

    private void parseInheritMode(SimpleNode InheritMode) {
        if ("inherit".equals(InheritMode.getValue())) {
            this.copyNamespacesModeInherit = 1;
        } else if ("no-inherit".equals(InheritMode.getValue())) {
            this.copyNamespacesModeInherit = 2;
        }
        this.foundCopyNamespaces = true;
    }

    private void parseOption(SimpleNode OptionDecl) throws XQException {
        QName qname = null;
        String value = null;
        for (int i = 0; i < OptionDecl.jjtGetNumChildren(); ++i) {
            SimpleNode childNode = XQueryStatement10.getChild(OptionDecl, i);
            if (childNode.id == 186) {
                qname = this.resolveQName(childNode.getValue());
                continue;
            }
            if (childNode.id != 4) continue;
            value = XQToolkit.removeQuotes(childNode.getValue());
        }
        this.options.put(qname, value);
        this.foundOption = true;
    }

    private void parseContextItemExpr(SimpleNode ContextItemExpr) {
        SimpleNode node = (SimpleNode)ContextItemExpr.jjtGetParent();
        if (node.id != 83) {
            return;
        }
        SimpleNode parent = (SimpleNode)node.jjtGetParent();
        int beginIndex = 0;
        int endIndex = 0;
        if (parent.id != 80) {
            this.foundContextItem = true;
            beginIndex = ContextItemExpr.beginIndex;
            endIndex = ContextItemExpr.endIndex;
            this.tokenSet.add(new Context(beginIndex, endIndex));
        } else if (node == parent.jjtGetChild(0)) {
            this.foundContextItem = true;
            beginIndex = ContextItemExpr.beginIndex;
            endIndex = ContextItemExpr.endIndex;
            this.tokenSet.add(new Context(beginIndex, endIndex));
        }
    }

    private void parseSlashOrSlashSlashExpr(SimpleNode SlashExpr) {
        SimpleNode parent = (SimpleNode)SlashExpr.jjtGetParent();
        if (parent.id != 80) {
            return;
        }
        if (parent.jjtGetChild(0) == SlashExpr) {
            this.foundContextItem = true;
            int beginIndex = SlashExpr.beginIndex;
            int endIndex = SlashExpr.endIndex - (SlashExpr.id == 81 ? 1 : 2);
            this.tokenSet.add(new Context(beginIndex, endIndex));
        }
    }

    @Override
    public String[] getNamespacePrefixes() {
        return this.nsContext.getNamespacePrefixes();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.nsContext.getNamespaceURI(prefix);
    }

    @Override
    public String getDefaultElementTypeNamespace() {
        return this.defaultElementTypeNamespace;
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    @Override
    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    @Override
    public int getConstructionMode() {
        return this.constructionMode;
    }

    @Override
    public int getOrderingMode() {
        return this.orderingMode;
    }

    @Override
    public int getDefaultOrderForEmptySequences() {
        return this.defaultOrderForEmptySequences;
    }

    @Override
    public int getBoundarySpacePolicy() {
        return this.boundarySpacePolicy;
    }

    @Override
    public int getCopyNamespacesModePreserve() {
        return this.copyNamespacesModePreserve;
    }

    @Override
    public int getCopyNamespacesModeInherit() {
        return this.copyNamespacesModeInherit;
    }

    @Override
    public String getBaseURI() {
        return this.baseUri;
    }

    @Override
    public int getQueryLanguageTypeAndVersion() {
        return 1;
    }

    @Override
    public String getQueryLanguage() {
        return "1.0";
    }

    @Override
    public XQSequenceType getStaticVariableType(QName name) {
        return (XQSequenceType)this.externalVariableTypes.get(name);
    }

    @Override
    public Set getAllExternalVariablesAsSet() {
        return this.externalVariableTypes.keySet();
    }

    @Override
    public QName[] getAllExternalVariables() {
        return this.getAllExternalVariablesAsSet().toArray(new QName[this.getAllExternalVariablesAsSet().size()]);
    }

    @Override
    public boolean isStraightExpression() {
        return !this.foundNamespaceDeclaration && !this.foundExternalVariableDeclaration && !this.foundOption && !this.foundBaseUri && !this.foundDefaultCollation && !this.foundDefaultElementTypeNamespace && !this.foundDefaultFunctionNamespace && !this.foundBoundarySpacePolicy && !this.foundConstructionMode && !this.foundCopyNamespaces && !this.foundDefaultOrderForEmptySequences && !this.foundOrderingMode && !this.foundContextItem;
    }

    @Override
    public int getPrologStartIndex() {
        return this.prologStartIndex;
    }

    @Override
    public boolean foundNamespaceDeclaration() {
        return this.foundNamespaceDeclaration;
    }

    @Override
    public boolean foundExternalVariableDeclaration() {
        return this.foundExternalVariableDeclaration;
    }

    @Override
    public boolean foundOption() {
        return this.foundOption;
    }

    @Override
    public boolean foundBaseUri() {
        return this.foundBaseUri;
    }

    @Override
    public boolean foundDefaultCollation() {
        return this.foundDefaultCollation;
    }

    @Override
    public boolean foundDefaultElementTypeNamespace() {
        return this.foundDefaultElementTypeNamespace;
    }

    @Override
    public boolean foundBoundarySpacePolicy() {
        return this.foundBoundarySpacePolicy;
    }

    @Override
    public boolean foundDefaultFunctionNamespace() {
        return this.foundDefaultFunctionNamespace;
    }

    @Override
    public boolean foundConstructionMode() {
        return this.foundConstructionMode;
    }

    @Override
    public boolean foundCopyNamespaces() {
        return this.foundCopyNamespaces;
    }

    @Override
    public boolean foundDefaultOrderForEmptySequences() {
        return this.foundDefaultOrderForEmptySequences;
    }

    @Override
    public boolean foundOrderingMode() {
        return this.foundOrderingMode;
    }

    @Override
    public boolean foundContextItem() {
        return this.foundContextItem;
    }

    @Override
    public Iterator getTokensInOrder() {
        return this.tokenSet.iterator();
    }

    @Override
    public char[] getQuery() {
        return this.query;
    }
}

