/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="This method uses a pair of parameters as a format string and its arguments, but the enclosing method wasn't annotated @FormatMethod. Doing so gives compile-time rather than run-time protection against malformed format strings.", tags={"FragileCode"}, severity=BugPattern.SeverityLevel.WARNING)
public final class AnnotateFormatMethod
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String REORDER = " (The parameters of this method would need to be reordered to make the format string and arguments the final parameters before the @FormatMethod annotation can be used.)";
    private static final Matcher<ExpressionTree> STRING_FORMAT = MethodMatchers.staticMethod().onClass("java.lang.String").named("format");
    private static final Matcher<ExpressionTree> FORMATTED = MethodMatchers.instanceMethod().onExactClass("java.lang.String").named("formatted");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.VarSymbol formatArgs;
        Symbol.VarSymbol formatString;
        if (STRING_FORMAT.matches((Tree)tree, state)) {
            if (tree.getArguments().size() != 2) {
                return Description.NO_MATCH;
            }
            formatString = AnnotateFormatMethod.asSymbol(tree.getArguments().get(0));
            formatArgs = AnnotateFormatMethod.asSymbol(tree.getArguments().get(1));
        } else if (FORMATTED.matches((Tree)tree, state)) {
            if (tree.getArguments().size() != 1) {
                return Description.NO_MATCH;
            }
            formatString = AnnotateFormatMethod.asSymbol(ASTHelpers.getReceiver((ExpressionTree)tree));
            formatArgs = AnnotateFormatMethod.asSymbol(tree.getArguments().get(0));
        } else {
            return Description.NO_MATCH;
        }
        if (formatString == null || formatArgs == null) {
            return Description.NO_MATCH;
        }
        MethodTree enclosingMethod = (MethodTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), MethodTree.class);
        if (enclosingMethod == null || !ASTHelpers.getSymbol((MethodTree)enclosingMethod).isVarArgs() || ASTHelpers.hasAnnotation((Tree)enclosingMethod, FormatMethod.class, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        List<? extends VariableTree> enclosingParameters = enclosingMethod.getParameters();
        Optional<? extends VariableTree> formatParameter = AnnotateFormatMethod.findParameterWithSymbol(enclosingParameters, formatString);
        Optional<? extends VariableTree> argumentsParameter = AnnotateFormatMethod.findParameterWithSymbol(enclosingParameters, formatArgs);
        if (!formatParameter.isPresent() || !argumentsParameter.isPresent()) {
            return Description.NO_MATCH;
        }
        if (!argumentsParameter.get().equals(Iterables.getLast(enclosingParameters))) {
            return Description.NO_MATCH;
        }
        boolean fixable = formatParameter.get().equals(enclosingParameters.get(enclosingParameters.size() - 2));
        return this.buildDescription(enclosingMethod).setMessage((String)(fixable ? this.message() : this.message() + REORDER)).build();
    }

    private static Optional<? extends VariableTree> findParameterWithSymbol(List<? extends VariableTree> parameters, Symbol symbol) {
        return (Optional)parameters.stream().filter(parameter -> symbol.equals(ASTHelpers.getSymbol((VariableTree)parameter))).collect(MoreCollectors.toOptional());
    }

    private static @Nullable Symbol.VarSymbol asSymbol(ExpressionTree tree) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        return symbol instanceof Symbol.VarSymbol ? (Symbol.VarSymbol)symbol : null;
    }
}

