/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import java.util.List;
import java.util.stream.Collectors;

public class ErrorMessages {
    private ErrorMessages() {
    }

    public static String annotationOnVoid(String annotation, String elementType) {
        return String.format("@%s may not be applied to void-returning %s", annotation, elementType);
    }

    public static String conflictingAnnotations(List<String> annotations, String elementType) {
        return annotations.stream().map(a -> "@" + a).collect(Collectors.joining(" and ")) + " cannot be applied to the same " + elementType;
    }

    public static String invocationResultIgnored(String shortCall, String assignmentToUnused, String apiTrailer) {
        String shortCallWithoutNew = ErrorMessages.removeNewPrefix(shortCall);
        return String.format("The result of `%s` must be used\nIf you really don't want to use the result, then assign it to a variable: `%s`.\n\nIf callers of `%s` shouldn't be required to use its result, then annotate it with `@CanIgnoreReturnValue`.\n%s", shortCall, assignmentToUnused, shortCallWithoutNew, apiTrailer);
    }

    public static String methodReferenceIgnoresResult(String shortCall, String methodReference, String implementedMethod, String assignmentLambda, String apiTrailer) {
        String shortCallWithoutNew = ErrorMessages.removeNewPrefix(shortCall);
        return String.format("The result of `%s` must be used\n`%s` acts as an implementation of `%s` -- which is a `void` method, so it doesn't use the result of `%s`.\n\nTo use the result, you may need to restructure your code.\n\nIf you really don't want to use the result, then switch to a lambda that assigns it to a variable: `%s`.\n\nIf callers of `%s` shouldn't be required to use its result, then annotate it with `@CanIgnoreReturnValue`.\n%s", shortCall, methodReference, implementedMethod, shortCall, assignmentLambda, shortCallWithoutNew, apiTrailer);
    }

    private static String removeNewPrefix(String shortCall) {
        if (shortCall.startsWith("new ")) {
            return shortCall.substring("new ".length());
        }
        return shortCall;
    }
}

