/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.core;

import com.google.caliper.Param;
import com.google.caliper.core.InvalidBenchmarkException;
import com.google.caliper.util.Parser;
import com.google.caliper.util.Parsers;
import com.google.caliper.util.Util;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.text.ParseException;

final class Parameters {
    static final ImmutableSet<String> RESERVED_NAMES = ImmutableSet.of((Object)"benchmark", (Object)"environment", (Object)"instrument", (Object)"measurement", (Object)"run", (Object)"trial", (Object[])new String[]{"vm"});
    private static final ImmutableSet<String> ALL_BOOLEANS = ImmutableSet.of((Object)"true", (Object)"false");

    private Parameters() {
    }

    static ImmutableSet<String> validateAndGetDefaults(Field field) {
        if (Util.isStatic((Member)field)) {
            throw new InvalidBenchmarkException("Parameter field '%s' must not be static", field.getName());
        }
        if (RESERVED_NAMES.contains((Object)field.getName())) {
            throw new InvalidBenchmarkException("Class '%s' uses reserved parameter name '%s'", field.getDeclaringClass(), field.getName());
        }
        field.setAccessible(true);
        ImmutableSet<String> defaults = Parameters.findDefaults(field);
        Parameters.validate(field, defaults);
        return defaults;
    }

    private static Parser<?> getParser(Field field) {
        Class type = Primitives.wrap(field.getType());
        try {
            return Parsers.conventionalParser((Class)type);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidBenchmarkException("Type '%s' of parameter field '%s' has no recognized String-converting method; see <TODO> for details", type.getName(), field.getName());
        }
    }

    static void validate(Field field, Iterable<String> values) {
        Parser<?> parser = Parameters.getParser(field);
        for (String value : values) {
            try {
                parser.parse((CharSequence)value);
            }
            catch (ParseException e) {
                throw new InvalidBenchmarkException("Cannot convert value '%s' to type '%s': %s", value, field.getType(), e.getMessage());
            }
        }
    }

    private static ImmutableSet<String> findDefaults(Field field) {
        Object[] defaultsAsStrings = field.getAnnotation(Param.class).value();
        if (defaultsAsStrings.length > 0) {
            return ImmutableSet.copyOf((Object[])defaultsAsStrings);
        }
        Class<?> type = field.getType();
        if (type == Boolean.TYPE) {
            return ALL_BOOLEANS;
        }
        if (type.isEnum()) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Object enumConstant : type.getEnumConstants()) {
                builder.add((Object)enumConstant.toString());
            }
            return builder.build();
        }
        return ImmutableSet.of();
    }
}

