/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker.instrument;

import com.google.caliper.core.Running;
import com.google.caliper.model.Measurement;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Qualifier;

public abstract class WorkerInstrument {
    @Inject
    @Running.BeforeExperimentMethods
    ImmutableSet<Method> beforeExperimentMethods;
    @Inject
    @Running.AfterExperimentMethods
    ImmutableSet<Method> afterExperimentMethods;
    protected final Method benchmarkMethod;
    protected final Object benchmark;

    protected WorkerInstrument(Object benchmark, Method method) {
        this.benchmark = benchmark;
        this.benchmarkMethod = method;
    }

    public final void setUpBenchmark() throws Exception {
        for (Method method : this.beforeExperimentMethods) {
            method.invoke(this.benchmark, new Object[0]);
        }
    }

    public void bootstrap() throws Exception {
    }

    public void preMeasure(boolean inWarmup) throws Exception {
    }

    public void postMeasure() throws Exception {
    }

    public abstract void dryRun() throws Exception;

    public abstract Iterable<Measurement> measure() throws Exception;

    public final void tearDownBenchmark() throws Exception {
        for (Method method : this.afterExperimentMethods) {
            method.invoke(this.benchmark, new Object[0]);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Qualifier
    public static @interface Options {
    }
}

