/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.caliper.runner.config.InvalidConfigurationException;
import com.google.caliper.runner.config.VmConfig;
import com.google.caliper.runner.config.VmType;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.target.LocalDevice;
import com.google.caliper.runner.target.Vm;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;

final class AndroidDeviceHelper
implements LocalDevice.Helper {
    private final CaliperOptions options;
    @Nullable
    private volatile String androidDataDir = null;

    AndroidDeviceHelper(CaliperOptions options) {
        this.options = (CaliperOptions)Preconditions.checkNotNull((Object)options);
    }

    @Override
    public void setUp() {
        this.androidDataDir = String.valueOf(System.getProperty("java.io.tmpdir")).concat("/data");
        File dalvikCache = new File(String.valueOf(this.androidDataDir).concat("/dalvik-cache"));
        dalvikCache.mkdirs();
    }

    @Override
    public VmType defaultVmType() {
        return VmType.ANDROID;
    }

    @Override
    public void configureDefaultVm(VmConfig.Builder builder) {
        String home = System.getenv("ANDROID_ROOT");
        if (home == null) {
            home = System.getProperty("java.home");
        }
        builder.home(home).executable("app_process");
    }

    @Override
    public File getHomeDir(Vm vm, File baseDirectory) {
        return baseDirectory;
    }

    @Override
    public String getWorkerClasspath(VmType type) {
        if (type.equals((Object)VmType.JVM)) {
            throw new InvalidConfigurationException("can't run a JVM on Android");
        }
        return (String)this.options.workerClasspath(type.toString()).get();
    }

    @Override
    public void addToWorkerProcessEnvironment(Map<String, String> env) {
        env.put("ANDROID_DATA", this.androidDataDir);
    }
}

