/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.value;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.value.JvmValueAbstractState;
import proguard.analysis.cpa.jvm.domain.value.ValueAbstractState;
import proguard.analysis.cpa.jvm.operators.JvmDefaultReduceOperator;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.evaluation.ExecutingInvocationUnit;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.ValueFactory;

public class JvmValueReduceOperator
extends JvmDefaultReduceOperator<ValueAbstractState> {
    private final ValueFactory valueFactory;
    private final ExecutingInvocationUnit executingInvocationUnit;

    public JvmValueReduceOperator(ValueFactory valueFactory, ExecutingInvocationUnit executingInvocationUnit) {
        this(valueFactory, executingInvocationUnit, true);
    }

    public JvmValueReduceOperator(ValueFactory valueFactory, ExecutingInvocationUnit executingInvocationUnit, boolean reduceHeap) {
        super(reduceHeap);
        this.valueFactory = valueFactory;
        this.executingInvocationUnit = executingInvocationUnit;
    }

    @Override
    protected void reduceHeap(JvmHeapAbstractState<ValueAbstractState> heap, JvmFrameAbstractState<ValueAbstractState> frame, MapAbstractState<String, ValueAbstractState> staticFields) {
        heap.reduce(Stream.of(frame.getLocalVariables(), staticFields.values()).flatMap(it -> it.stream().map(ValueAbstractState::getValue)).filter(it -> it instanceof IdentifiedReferenceValue).filter(it -> !"Ljava/lang/String;".equals(it.internalType())).map(it -> ((IdentifiedReferenceValue)it).id).collect(Collectors.toSet()));
    }

    public JvmValueAbstractState createJvmAbstractState(JvmCfaNode programLocation, JvmFrameAbstractState frame, JvmHeapAbstractState heap, MapAbstractState staticFields) {
        return new JvmValueAbstractState(this.valueFactory, this.executingInvocationUnit, programLocation, frame, heap, staticFields);
    }
}

