/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.state.heap.tree;

import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.HeapNode;
import proguard.analysis.cpa.state.MapAbstractStateFactory;

public abstract class JvmTreeHeapAbstractState<StateT extends LatticeAbstractState<StateT>>
implements JvmHeapAbstractState<StateT> {
    protected final MapAbstractState<Reference, HeapNode<StateT>> referenceToObject;
    protected final MapAbstractStateFactory<String, StateT> heapNodeMapAbstractStateFactory;
    protected final MapAbstractStateFactory<Reference, HeapNode<StateT>> heapMapAbstractStateFactory;
    protected final StateT defaultValue;

    protected JvmTreeHeapAbstractState(MapAbstractState<Reference, HeapNode<StateT>> referenceToObject, MapAbstractStateFactory<Reference, HeapNode<StateT>> heapMapAbstractStateFactory, MapAbstractStateFactory<String, StateT> heapNodeMapAbstractStateFactory, StateT defaultValue) {
        this.referenceToObject = referenceToObject;
        this.heapMapAbstractStateFactory = heapMapAbstractStateFactory;
        this.heapNodeMapAbstractStateFactory = heapNodeMapAbstractStateFactory;
        this.defaultValue = defaultValue;
    }

    protected StateT getField(SetAbstractState<Reference> object, String descriptor, StateT defaultValue) {
        return (StateT)object.stream().reduce(this.defaultValue, (result, reference) -> result.join(this.referenceToObject.containsKey(reference) ? ((HeapNode)this.referenceToObject.get(reference)).getOrDefault(descriptor, defaultValue) : defaultValue), LatticeAbstractState::join);
    }

    protected void assignField(SetAbstractState<Reference> object, String descriptor, StateT value) {
        if (object.size() <= 1) {
            this.setField(object, descriptor, value);
        } else {
            this.mergeField(object, descriptor, value);
        }
    }

    protected void mergeField(SetAbstractState<Reference> object, String descriptor, StateT value) {
        object.forEach(reference -> this.referenceToObject.computeIfAbsent(reference, r -> new HeapNode<StateT>(this.heapNodeMapAbstractStateFactory.createMapAbstractState())).merge(descriptor, value));
    }

    @Override
    protected void setField(SetAbstractState<Reference> object, String descriptor, StateT value) {
        object.forEach(reference -> this.referenceToObject.computeIfAbsent(reference, r -> new HeapNode<StateT>(this.heapNodeMapAbstractStateFactory.createMapAbstractState())).put(descriptor, value));
    }

    @Override
    protected StateT getArrayElementOrDefault(SetAbstractState<Reference> array, StateT index, StateT defaultValue) {
        return (StateT)array.stream().reduce(this.defaultValue, (result, reference) -> result.join(this.referenceToObject.containsKey(reference) ? ((HeapNode)this.referenceToObject.get(reference)).getOrDefault("[]", defaultValue) : defaultValue), LatticeAbstractState::join);
    }

    @Override
    protected void setArrayElement(SetAbstractState<Reference> array, StateT index, StateT value) {
        array.forEach(reference -> this.referenceToObject.computeIfAbsent(reference, r -> new HeapNode<StateT>(this.heapNodeMapAbstractStateFactory.createMapAbstractState())).merge("[]", value));
    }

    public HeapNode<StateT> getHeapNode(Reference reference) {
        return (HeapNode)this.referenceToObject.get(reference);
    }

    @Override
    public void expand(JvmHeapAbstractState<StateT> otherState) {
        if (!(otherState instanceof JvmTreeHeapAbstractState)) {
            throw new IllegalArgumentException("The other state should be a JvmTreeHeapAbstractState");
        }
        ((JvmTreeHeapAbstractState)otherState).referenceToObject.forEach(this.referenceToObject::putIfAbsent);
    }

    @Override
    public boolean isLessOrEqual(JvmHeapAbstractState<StateT> abstractState) {
        return abstractState instanceof JvmTreeHeapAbstractState && this.referenceToObject.isLessOrEqual(((JvmTreeHeapAbstractState)abstractState).referenceToObject);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JvmTreeHeapAbstractState)) {
            return false;
        }
        return this.referenceToObject.equals(((JvmTreeHeapAbstractState)obj).referenceToObject);
    }

    @Override
    public int hashCode() {
        return this.referenceToObject.hashCode();
    }
}

