/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodDescriptor;
import proguard.classfile.MethodInfo;
import proguard.classfile.Signature;
import proguard.classfile.util.ClassUtil;

public class MethodSignature
extends Signature
implements MethodInfo {
    public static final MethodSignature UNKNOWN = new MethodSignature(null, null, (MethodDescriptor)null);
    private static final Map<Method, MethodSignature> signatureCache = Collections.synchronizedMap(new IdentityHashMap());
    @Nullable
    public final String method;
    @Nullable
    public final MethodDescriptor descriptor;
    private Method referencedMethod;

    public MethodSignature(@Nullable String internalClassName, @Nullable String method, @Nullable MethodDescriptor descriptor) {
        super(internalClassName, Objects.hash(internalClassName, method, descriptor));
        this.method = method;
        this.descriptor = descriptor;
        this.referencedClass = null;
        this.referencedMethod = null;
    }

    public MethodSignature(@Nullable String internalClassName, @Nullable String method, @Nullable String descriptor) {
        this(internalClassName, method, descriptor == null ? null : new MethodDescriptor(descriptor));
    }

    public MethodSignature(@NotNull Clazz clazz, @NotNull Method method) {
        this(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz));
        this.referencedClass = clazz;
        this.referencedMethod = method;
    }

    public MethodSignature(@NotNull Clazz clazz) {
        this(clazz.getName(), null, (String)null);
        this.referencedClass = clazz;
    }

    public MethodSignature(@Nullable String className) {
        this(className, null, (String)null);
    }

    public Method getReferencedMethod() {
        return this.referencedMethod;
    }

    public static MethodSignature computeIfAbsent(Clazz clazz, Method method) {
        return signatureCache.computeIfAbsent(method, m -> new MethodSignature(clazz, method));
    }

    @Override
    public boolean isIncomplete() {
        return this.className == null || this.method == null || this.descriptor == null || this.descriptor.isIncomplete();
    }

    @Override
    protected String calculateFqn() {
        return String.format("L%s;%s%s", this.className == null ? "?" : this.className, this.method == null ? "?" : this.method, this.descriptor);
    }

    @Override
    protected String calculatePrettyFqn() {
        String result;
        String shortClassName;
        String params = this.descriptor == null ? "?" : this.descriptor.getPrettyArgumentTypes();
        String string = shortClassName = this.className == null ? "?" : ClassUtil.externalShortClassName(ClassUtil.externalClassName(this.className));
        if ("<init>".equals(this.method)) {
            result = String.format("%s(%s)", shortClassName, params);
        } else if ("<clinit>".equals(this.method)) {
            result = String.format("static initializer (%s)", shortClassName);
        } else {
            String returnType = this.descriptor == null ? "?" : this.descriptor.getPrettyReturnType();
            String methodName = this.method == null ? "?" : this.method;
            result = String.format("%s %s.%s(%s)", returnType, shortClassName, methodName, params);
        }
        return result;
    }

    public static void clearCache() {
        signatureCache.clear();
    }

    public static boolean matchesIgnoreNull(MethodSignature signature, MethodSignature wildcard) {
        if (wildcard == null) {
            return true;
        }
        if (signature == null) {
            return false;
        }
        return !(wildcard.className != null && !Objects.equals(signature.className, wildcard.className) || wildcard.method != null && !Objects.equals(signature.method, wildcard.method) || !MethodDescriptor.matchesIgnoreNull(signature.descriptor, wildcard.descriptor));
    }

    public static boolean matchesIgnoreNullAndDollar(MethodSignature signature, MethodSignature wildcard) {
        if (wildcard == null) {
            return true;
        }
        if (signature == null) {
            return false;
        }
        return MethodSignature.checkClassNameIgnoreNullAndDollar(wildcard.className, signature.className) && MethodSignature.checkMethodNameIgnoreNull(wildcard.method, signature.method) && MethodDescriptor.matchesIgnoreNullAndDollar(signature.descriptor, wildcard.descriptor);
    }

    private static boolean checkClassNameIgnoreNullAndDollar(String className, String wildcardClassName) {
        if (wildcardClassName == null) {
            return true;
        }
        if (className == null) {
            return false;
        }
        return Objects.equals(className.replace('$', '/'), wildcardClassName.replace('$', '/'));
    }

    private static boolean checkMethodNameIgnoreNull(String method, String wildcardMethod) {
        if (wildcardMethod == null) {
            return true;
        }
        if (method == null) {
            return false;
        }
        return Objects.equals(method, wildcardMethod);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodSignature that = (MethodSignature)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.descriptor, that.descriptor);
    }

    @Override
    @Nullable
    public String getMethodName() {
        return this.method;
    }

    @Override
    @Nullable
    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }
}

