/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InvalidClassReferenceVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;

public class ClassSuperHierarchyInitializer
implements ClassVisitor,
ConstantVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final InvalidClassReferenceVisitor invalidClassReferenceVisitor;

    public ClassSuperHierarchyInitializer(ClassPool programClassPool, ClassPool libraryClassPool) {
        this(programClassPool, libraryClassPool, null);
    }

    public ClassSuperHierarchyInitializer(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter missingWarningPrinter, WarningPrinter dependencyWarningPrinter) {
        this(programClassPool, libraryClassPool, new InvalidClassReferenceWarningVisitor(missingWarningPrinter, dependencyWarningPrinter));
    }

    public ClassSuperHierarchyInitializer(ClassPool programClassPool, ClassPool libraryClassPool, InvalidClassReferenceVisitor invalidClassReferenceVisitor) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.invalidClassReferenceVisitor = invalidClassReferenceVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.superClassConstantAccept(this);
        programClass.interfaceConstantsAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        String className = libraryClass.getName();
        String superClassName = libraryClass.superClassName;
        if (superClassName != null) {
            libraryClass.superClass = this.findClass(libraryClass, superClassName);
        }
        if (libraryClass.interfaceNames != null) {
            String[] interfaceNames = libraryClass.interfaceNames;
            Clazz[] interfaceClasses = new Clazz[interfaceNames.length];
            for (int index = 0; index < interfaceNames.length; ++index) {
                interfaceClasses[index] = this.findClass(libraryClass, interfaceNames[index]);
            }
            libraryClass.interfaceClasses = interfaceClasses;
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClass = this.findClass(clazz, classConstant.getName(clazz));
    }

    private Clazz findClass(Clazz referencingClass, String name) {
        Clazz clazz = this.programClassPool.getClass(name);
        if (clazz == null) {
            clazz = this.libraryClassPool.getClass(name);
            if (clazz == null && this.invalidClassReferenceVisitor != null) {
                this.invalidClassReferenceVisitor.visitMissingClass(referencingClass, name);
            }
        } else if (this.invalidClassReferenceVisitor != null && referencingClass instanceof LibraryClass) {
            this.invalidClassReferenceVisitor.visitProgramDependency(referencingClass, clazz);
        }
        return clazz;
    }

    private static class InvalidClassReferenceWarningVisitor
    implements InvalidClassReferenceVisitor {
        private final WarningPrinter missingWarningPrinter;
        private final WarningPrinter dependencyWarningPrinter;

        public InvalidClassReferenceWarningVisitor(WarningPrinter missingWarningPrinter, WarningPrinter dependencyWarningPrinter) {
            this.missingWarningPrinter = missingWarningPrinter;
            this.dependencyWarningPrinter = dependencyWarningPrinter;
        }

        @Override
        public void visitMissingClass(Clazz referencingClazz, String reference) {
            if (this.missingWarningPrinter != null) {
                this.missingWarningPrinter.print(referencingClazz.getName(), reference, "Warning: " + ClassUtil.externalClassName(referencingClazz.getName()) + ": can't find superclass or interface " + ClassUtil.externalClassName(reference));
            }
        }

        @Override
        public void visitProgramDependency(Clazz referencingClazz, Clazz dependency) {
            if (this.dependencyWarningPrinter != null) {
                this.dependencyWarningPrinter.print(referencingClazz.getName(), dependency.getName(), "Warning: library class " + ClassUtil.externalClassName(referencingClazz.getName()) + " extends or implements program class " + ClassUtil.externalClassName(dependency.getName()));
            }
        }
    }
}

