/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.SpecificFloatValue;

public final class ParticularFloatValue
extends SpecificFloatValue {
    private final float value;

    public ParticularFloatValue(float value) {
        this.value = value;
    }

    @Override
    public float value() {
        return this.value;
    }

    @Override
    public FloatValue negate() {
        return new ParticularFloatValue(-this.value);
    }

    @Override
    public IntegerValue convertToInteger() {
        return new ParticularIntegerValue((int)this.value);
    }

    @Override
    public LongValue convertToLong() {
        return new ParticularLongValue((long)this.value);
    }

    @Override
    public DoubleValue convertToDouble() {
        return new ParticularDoubleValue(this.value);
    }

    @Override
    public FloatValue generalize(FloatValue other) {
        return other.generalize(this);
    }

    @Override
    public FloatValue add(FloatValue other) {
        return other.add(this);
    }

    @Override
    public FloatValue subtract(FloatValue other) {
        return other.subtractFrom(this);
    }

    @Override
    public FloatValue subtractFrom(FloatValue other) {
        return other.subtract(this);
    }

    @Override
    public FloatValue multiply(FloatValue other) {
        return other.multiply(this);
    }

    @Override
    public FloatValue divide(FloatValue other) {
        return other.divideOf(this);
    }

    @Override
    public FloatValue divideOf(FloatValue other) {
        return other.divide(this);
    }

    @Override
    public FloatValue remainder(FloatValue other) {
        return other.remainderOf(this);
    }

    @Override
    public FloatValue remainderOf(FloatValue other) {
        return other.remainder(this);
    }

    @Override
    public IntegerValue compare(FloatValue other) {
        return other.compareReverse(this);
    }

    @Override
    public FloatValue generalize(ParticularFloatValue other) {
        return Float.floatToRawIntBits(this.value) == Float.floatToRawIntBits(other.value) ? this : BasicValueFactory.FLOAT_VALUE;
    }

    @Override
    public FloatValue add(ParticularFloatValue other) {
        return new ParticularFloatValue(this.value + other.value);
    }

    @Override
    public FloatValue subtract(ParticularFloatValue other) {
        return new ParticularFloatValue(this.value - other.value);
    }

    @Override
    public FloatValue subtractFrom(ParticularFloatValue other) {
        return new ParticularFloatValue(other.value - this.value);
    }

    @Override
    public FloatValue multiply(ParticularFloatValue other) {
        return new ParticularFloatValue(this.value * other.value);
    }

    @Override
    public FloatValue divide(ParticularFloatValue other) {
        return new ParticularFloatValue(this.value / other.value);
    }

    @Override
    public FloatValue divideOf(ParticularFloatValue other) {
        return new ParticularFloatValue(other.value / this.value);
    }

    @Override
    public FloatValue remainder(ParticularFloatValue other) {
        return new ParticularFloatValue(this.value % other.value);
    }

    @Override
    public FloatValue remainderOf(ParticularFloatValue other) {
        return new ParticularFloatValue(other.value % this.value);
    }

    @Override
    public IntegerValue compare(ParticularFloatValue other) {
        return this.value < other.value ? ParticularValueFactory.INTEGER_VALUE_M1 : (this.value == other.value ? ParticularValueFactory.INTEGER_VALUE_0 : ParticularValueFactory.INTEGER_VALUE_1);
    }

    @Override
    public boolean isParticular() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && Float.floatToIntBits(this.value) == Float.floatToIntBits(((ParticularFloatValue)object).value);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Float.floatToIntBits(this.value);
    }

    public String toString() {
        return this.value + "f";
    }
}

