# t00061 - Paths diagram filter test case
## Config
```yaml
diagrams:
  t00061_class:
    type: class
    glob:
      - t00061.cc
    include:
      namespaces:
        - clanguml::t00061
      paths:
        - include/*_a.h
    using_namespace: clanguml::t00061
```
## Source code
File `tests/t00061/t00061.cc`
```cpp
#include "include/t00061_a.h"
#include "include/t00061_b.h"

namespace clanguml {
namespace t00061 {
struct C {
    A *a;
    B *b;
};
}
}
```
File `tests/t00061/include/t00061_a.h`
```cpp
namespace clanguml {
namespace t00061 {
struct A { };
}
}
```
File `tests/t00061/include/t00061_b.h`
```cpp
namespace clanguml {
namespace t00061 {
struct B { };
}
}
```
## Generated PlantUML diagrams
![t00061_class](./t00061_class.svg "Paths diagram filter test case")
## Generated Mermaid diagrams
![t00061_class](./t00061_class_mermaid.svg "Paths diagram filter test case")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "A",
      "id": "8081637823658635385",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00061",
      "source_location": {
        "column": 8,
        "file": "include/t00061_a.h",
        "line": 3,
        "translation_unit": "t00061.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00061_class",
  "package_type": "namespace",
  "relationships": [],
  "using_namespace": "clanguml::t00061"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00061</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
  </node>
 </graph>
</graphml>

```
