# t20005 - Class template basic sequence diagram
## Config
```yaml
diagrams:
  t20005_sequence:
    type: sequence
    glob:
      - t20005.cc
    include:
      namespaces:
        - clanguml::t20005
    using_namespace: clanguml::t20005
    from:
      - function: "clanguml::t20005::C<T>::c(T)"
```
## Source code
File `tests/t20005/t20005.cc`
```cpp
namespace clanguml {
namespace t20005 {

template <typename T> struct A {
    T a(T arg) { return arg; }
};

template <typename T> struct B {
    T b(T arg) { return a_.a(arg); }

    A<T> a_;
};

template <typename T> struct C {
    T c(T arg) { return b_.b(arg); }

    B<T> b_;
};

}
}
```
## Generated PlantUML diagrams
![t20005_sequence](./t20005_sequence.svg "Class template basic sequence diagram")
## Generated Mermaid diagrams
![t20005_sequence](./t20005_sequence_mermaid.svg "Class template basic sequence diagram")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20005_sequence",
  "participants": [
    {
      "activities": [
        {
          "display_name": "c(T)",
          "full_name": "clanguml::t20005::C<T>::c(T)",
          "id": "4629750983723239790",
          "name": "c",
          "namespace": "clanguml::t20005",
          "source_location": {
            "column": 7,
            "file": "t20005.cc",
            "line": 15,
            "translation_unit": "t20005.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "C<T>",
      "full_name": "clanguml::t20005::C<T>",
      "id": "2924553044257020835",
      "name": "C",
      "namespace": "clanguml::t20005",
      "source_location": {
        "column": 30,
        "file": "t20005.cc",
        "line": 14,
        "translation_unit": "t20005.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "b(T)",
          "full_name": "clanguml::t20005::B<T>::b(T)",
          "id": "6963731975199456942",
          "name": "b",
          "namespace": "clanguml::t20005",
          "source_location": {
            "column": 7,
            "file": "t20005.cc",
            "line": 9,
            "translation_unit": "t20005.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B<T>",
      "full_name": "clanguml::t20005::B<T>",
      "id": "5328006636262774803",
      "name": "B",
      "namespace": "clanguml::t20005",
      "source_location": {
        "column": 30,
        "file": "t20005.cc",
        "line": 8,
        "translation_unit": "t20005.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a(T)",
          "full_name": "clanguml::t20005::A<T>::a(T)",
          "id": "998827646515229964",
          "name": "a",
          "namespace": "clanguml::t20005",
          "source_location": {
            "column": 7,
            "file": "t20005.cc",
            "line": 5,
            "translation_unit": "t20005.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A<T>",
      "full_name": "clanguml::t20005::A<T>",
      "id": "10226643645007529481",
      "name": "A",
      "namespace": "clanguml::t20005",
      "source_location": {
        "column": 30,
        "file": "t20005.cc",
        "line": 4,
        "translation_unit": "t20005.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "4629750983723239790",
        "location": "clanguml::t20005::C<T>::c(T)"
      },
      "messages": [
        {
          "from": {
            "activity_id": "4629750983723239790",
            "participant_id": "2924553044257020835"
          },
          "name": "b(T)",
          "return_type": "T",
          "scope": "normal",
          "source_location": {
            "column": 25,
            "file": "t20005.cc",
            "line": 15,
            "translation_unit": "t20005.cc"
          },
          "to": {
            "activity_id": "6963731975199456942",
            "participant_id": "5328006636262774803"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "6963731975199456942",
            "participant_id": "5328006636262774803"
          },
          "name": "a(T)",
          "return_type": "T",
          "scope": "normal",
          "source_location": {
            "column": 25,
            "file": "t20005.cc",
            "line": 9,
            "translation_unit": "t20005.cc"
          },
          "to": {
            "activity_id": "998827646515229964",
            "participant_id": "10226643645007529481"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "998827646515229964",
            "participant_id": "10226643645007529481"
          },
          "name": "",
          "return_type": "T",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20005.cc",
            "line": 5,
            "translation_unit": "t20005.cc"
          },
          "to": {
            "activity_id": "6963731975199456942",
            "participant_id": "5328006636262774803"
          },
          "type": "return"
        },
        {
          "from": {
            "activity_id": "6963731975199456942",
            "participant_id": "5328006636262774803"
          },
          "name": "",
          "return_type": "T",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20005.cc",
            "line": 9,
            "translation_unit": "t20005.cc"
          },
          "to": {
            "activity_id": "4629750983723239790",
            "participant_id": "2924553044257020835"
          },
          "type": "return"
        }
      ],
      "return_type": "T"
    }
  ],
  "using_namespace": "clanguml::t20005"
}
```
## Generated GraphML models
