## 1.31.3 - 2026-01-16
### Extractors
#### Additions
- [booth] add `category` extractor ([#8867](https://github.com/mikf/gallery-dl/issues/8867))
- [thefap] add support ([#8821](https://github.com/mikf/gallery-dl/issues/8821) [#8822](https://github.com/mikf/gallery-dl/issues/8822))
- [xenforo] implement `media` support ([#8785](https://github.com/mikf/gallery-dl/issues/8785))
  - add `media-item`, `media-user`, `media-category` extractors
#### Fixes
- [ahottie:album] support multiple pages ([#8862](https://github.com/mikf/gallery-dl/issues/8862) [#8886](https://github.com/mikf/gallery-dl/issues/8886))
- [bellazon] use `data-full-image` URLs if available ([#8833](https://github.com/mikf/gallery-dl/issues/8833))
- [fanbox] make `comments` extraction non-fatal ([#8814](https://github.com/mikf/gallery-dl/issues/8814))
- [imagevenue] fix `NotFoundError` for valid image links ([#8818](https://github.com/mikf/gallery-dl/issues/8818))
- [xenforo] fix/improve `bb*Wrapper` extraction ([#8868](https://github.com/mikf/gallery-dl/issues/8868))
#### Improvements
- [bellazon] match thread URLs with escaped characters
- [bilibili] add support for Live Photo downloads ([#8860](https://github.com/mikf/gallery-dl/issues/8860))
- [booth:item] support URLs with language codes
- [chevereto] implement password support
- [chevereto:user] support `album` results
- [dankefuerslesen] support `/reader/series` URLs ([#8811](https://github.com/mikf/gallery-dl/issues/8811))
- [furaffinity:favorite] support URLs with custom start position
- [imagetwist:gallery] support multiple pages ([#8826](https://github.com/mikf/gallery-dl/issues/8826))
- [koofr] refactor ([#8803](https://github.com/mikf/gallery-dl/issues/8803))
- [pixeldrain:album] add `zip` option
- [pixeldrain] warn about hotlink-protected files ([#8803](https://github.com/mikf/gallery-dl/issues/8803))
- [pixeldrain] improve `filename` parsing
- [rule34xyz] support URLs with `www` subdomain ([#8875](https://github.com/mikf/gallery-dl/issues/8875))
- [saint] support `turbovid.cr` & `turbo.cr` URLs ([#8851](https://github.com/mikf/gallery-dl/issues/8851) [#8888](https://github.com/mikf/gallery-dl/issues/8888))
- [shopify] support URLs starting with language codes
- [webtoons] extend `bgm` option ([#8733](https://github.com/mikf/gallery-dl/issues/8733))
- [weibo:album] implement `subalbum` support ([#8792](https://github.com/mikf/gallery-dl/issues/8792))
- [wikimedia] use `gallery-dl/<version>` User-Agent ([#8770](https://github.com/mikf/gallery-dl/issues/8770) [#8861](https://github.com/mikf/gallery-dl/issues/8861))
#### Metadata
- [bellazon] unescape `thread[slug]` names
- [imagetwist:gallery] extract `gallery_title` & `gallery_id` metadata
- [motherless] fix gallery media metadata issues ([#8873](https://github.com/mikf/gallery-dl/issues/8873))
- [rule34xyz] recognize `system` & `meta` tag types
- [sexcom] fix `tags` when passing cookies ([#8880](https://github.com/mikf/gallery-dl/issues/8880))
- [tiktok] provide `post_type` metadata ([#8815](https://github.com/mikf/gallery-dl/issues/8815))
- [xenforo] extract `author_slug` metadata ([#8785](https://github.com/mikf/gallery-dl/issues/8785))
### Downloaders
- [ytdl] implement `_ytdl_manifest_remux`
### Miscellaneous
- [common] implement `"user-agent": "+PRESET"`
- [docs/README] add Discord link
- [formatter] overload `.` operator
- [job] fix extractor `kwdict` values being unavailable in filters
- [util] adjust Firefox/Chrome User-Agent versions
- [util] rename `USERAGENT` to `USERAGENT_GALLERYDL` ([#8836](https://github.com/mikf/gallery-dl/issues/8836))
