//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azsystemevents

import (
	"encoding/json"
	"fmt"
	"reflect"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
)

// MarshalJSON implements the json.Marshaller interface for type APICenterAPIDefinitionAddedEventData.
func (a APICenterAPIDefinitionAddedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "specification", a.Specification)
	populate(objectMap, "title", a.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APICenterAPIDefinitionAddedEventData.
func (a *APICenterAPIDefinitionAddedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "specification":
			err = unpopulate(val, "Specification", &a.Specification)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APICenterAPIDefinitionUpdatedEventData.
func (a APICenterAPIDefinitionUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "specification", a.Specification)
	populate(objectMap, "title", a.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APICenterAPIDefinitionUpdatedEventData.
func (a *APICenterAPIDefinitionUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "specification":
			err = unpopulate(val, "Specification", &a.Specification)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APICenterAPISpecification.
func (a APICenterAPISpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APICenterAPISpecification.
func (a *APICenterAPISpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementAPICreatedEventData.
func (a APIManagementAPICreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementAPICreatedEventData.
func (a *APIManagementAPICreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementAPIDeletedEventData.
func (a APIManagementAPIDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementAPIDeletedEventData.
func (a *APIManagementAPIDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementAPIReleaseCreatedEventData.
func (a APIManagementAPIReleaseCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementAPIReleaseCreatedEventData.
func (a *APIManagementAPIReleaseCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementAPIReleaseDeletedEventData.
func (a APIManagementAPIReleaseDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementAPIReleaseDeletedEventData.
func (a *APIManagementAPIReleaseDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementAPIReleaseUpdatedEventData.
func (a APIManagementAPIReleaseUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementAPIReleaseUpdatedEventData.
func (a *APIManagementAPIReleaseUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementAPIUpdatedEventData.
func (a APIManagementAPIUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementAPIUpdatedEventData.
func (a *APIManagementAPIUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementGatewayAPIAddedEventData.
func (a APIManagementGatewayAPIAddedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementGatewayAPIAddedEventData.
func (a *APIManagementGatewayAPIAddedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementGatewayAPIRemovedEventData.
func (a APIManagementGatewayAPIRemovedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementGatewayAPIRemovedEventData.
func (a *APIManagementGatewayAPIRemovedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementGatewayCertificateAuthorityCreatedEventData.
func (a APIManagementGatewayCertificateAuthorityCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementGatewayCertificateAuthorityCreatedEventData.
func (a *APIManagementGatewayCertificateAuthorityCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementGatewayCertificateAuthorityDeletedEventData.
func (a APIManagementGatewayCertificateAuthorityDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementGatewayCertificateAuthorityDeletedEventData.
func (a *APIManagementGatewayCertificateAuthorityDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementGatewayCertificateAuthorityUpdatedEventData.
func (a APIManagementGatewayCertificateAuthorityUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementGatewayCertificateAuthorityUpdatedEventData.
func (a *APIManagementGatewayCertificateAuthorityUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementGatewayCreatedEventData.
func (a APIManagementGatewayCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementGatewayCreatedEventData.
func (a *APIManagementGatewayCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementGatewayDeletedEventData.
func (a APIManagementGatewayDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementGatewayDeletedEventData.
func (a *APIManagementGatewayDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementGatewayHostnameConfigurationCreatedEventData.
func (a APIManagementGatewayHostnameConfigurationCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementGatewayHostnameConfigurationCreatedEventData.
func (a *APIManagementGatewayHostnameConfigurationCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementGatewayHostnameConfigurationDeletedEventData.
func (a APIManagementGatewayHostnameConfigurationDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementGatewayHostnameConfigurationDeletedEventData.
func (a *APIManagementGatewayHostnameConfigurationDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementGatewayHostnameConfigurationUpdatedEventData.
func (a APIManagementGatewayHostnameConfigurationUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementGatewayHostnameConfigurationUpdatedEventData.
func (a *APIManagementGatewayHostnameConfigurationUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementGatewayUpdatedEventData.
func (a APIManagementGatewayUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementGatewayUpdatedEventData.
func (a *APIManagementGatewayUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementProductCreatedEventData.
func (a APIManagementProductCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementProductCreatedEventData.
func (a *APIManagementProductCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementProductDeletedEventData.
func (a APIManagementProductDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementProductDeletedEventData.
func (a *APIManagementProductDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementProductUpdatedEventData.
func (a APIManagementProductUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementProductUpdatedEventData.
func (a *APIManagementProductUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementSubscriptionCreatedEventData.
func (a APIManagementSubscriptionCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementSubscriptionCreatedEventData.
func (a *APIManagementSubscriptionCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementSubscriptionDeletedEventData.
func (a APIManagementSubscriptionDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementSubscriptionDeletedEventData.
func (a *APIManagementSubscriptionDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementSubscriptionUpdatedEventData.
func (a APIManagementSubscriptionUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementSubscriptionUpdatedEventData.
func (a *APIManagementSubscriptionUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementUserCreatedEventData.
func (a APIManagementUserCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementUserCreatedEventData.
func (a *APIManagementUserCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementUserDeletedEventData.
func (a APIManagementUserDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementUserDeletedEventData.
func (a *APIManagementUserDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type APIManagementUserUpdatedEventData.
func (a APIManagementUserUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceUri", a.ResourceURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type APIManagementUserUpdatedEventData.
func (a *APIManagementUserUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &a.ResourceURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSAdvancedMessageButtonContent.
func (a ACSAdvancedMessageButtonContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "payload", a.Payload)
	populate(objectMap, "text", a.Text)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSAdvancedMessageButtonContent.
func (a *ACSAdvancedMessageButtonContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "payload":
			err = unpopulate(val, "Payload", &a.Payload)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &a.Text)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AcsAdvancedMessageChannelEventError.
func (a internalACSAdvancedMessageChannelEventError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelCode", a.ChannelCode)
	populate(objectMap, "channelMessage", a.ChannelMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AcsAdvancedMessageChannelEventError.
func (a *internalACSAdvancedMessageChannelEventError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelCode":
			err = unpopulate(val, "ChannelCode", &a.ChannelCode)
			delete(rawMsg, key)
		case "channelMessage":
			err = unpopulate(val, "ChannelMessage", &a.ChannelMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSAdvancedMessageContext.
func (a ACSAdvancedMessageContext) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "from", a.From)
	populate(objectMap, "id", a.MessageID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSAdvancedMessageContext.
func (a *ACSAdvancedMessageContext) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "from":
			err = unpopulate(val, "From", &a.From)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSAdvancedMessageDeliveryStatusUpdatedEventData.
func (a ACSAdvancedMessageDeliveryStatusUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelType", a.ChannelKind)
	populate(objectMap, "error", a.Error)
	populate(objectMap, "from", a.From)
	populate(objectMap, "messageId", a.MessageID)
	populateDateTimeRFC3339(objectMap, "receivedTimestamp", a.ReceivedTimestamp)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "to", a.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSAdvancedMessageDeliveryStatusUpdatedEventData.
func (a *ACSAdvancedMessageDeliveryStatusUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelType":
			err = unpopulate(val, "ChannelKind", &a.ChannelKind)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "from":
			err = unpopulate(val, "From", &a.From)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "receivedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "ReceivedTimestamp", &a.ReceivedTimestamp)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "to":
			err = unpopulate(val, "To", &a.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSAdvancedMessageEventData.
func (a ACSAdvancedMessageEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", a.Error)
	populate(objectMap, "from", a.From)
	populateDateTimeRFC3339(objectMap, "receivedTimestamp", a.ReceivedTimestamp)
	populate(objectMap, "to", a.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSAdvancedMessageEventData.
func (a *ACSAdvancedMessageEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "from":
			err = unpopulate(val, "From", &a.From)
			delete(rawMsg, key)
		case "receivedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "ReceivedTimestamp", &a.ReceivedTimestamp)
			delete(rawMsg, key)
		case "to":
			err = unpopulate(val, "To", &a.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSAdvancedMessageInteractiveButtonReplyContent.
func (a ACSAdvancedMessageInteractiveButtonReplyContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ButtonID)
	populate(objectMap, "title", a.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSAdvancedMessageInteractiveButtonReplyContent.
func (a *ACSAdvancedMessageInteractiveButtonReplyContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ButtonID", &a.ButtonID)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSAdvancedMessageInteractiveContent.
func (a ACSAdvancedMessageInteractiveContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "buttonReply", a.ButtonReply)
	populate(objectMap, "listReply", a.ListReply)
	populate(objectMap, "type", a.ReplyKind)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSAdvancedMessageInteractiveContent.
func (a *ACSAdvancedMessageInteractiveContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "buttonReply":
			err = unpopulate(val, "ButtonReply", &a.ButtonReply)
			delete(rawMsg, key)
		case "listReply":
			err = unpopulate(val, "ListReply", &a.ListReply)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "ReplyKind", &a.ReplyKind)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSAdvancedMessageInteractiveListReplyContent.
func (a ACSAdvancedMessageInteractiveListReplyContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "id", a.ListItemID)
	populate(objectMap, "title", a.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSAdvancedMessageInteractiveListReplyContent.
func (a *ACSAdvancedMessageInteractiveListReplyContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ListItemID", &a.ListItemID)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSAdvancedMessageMediaContent.
func (a ACSAdvancedMessageMediaContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caption", a.Caption)
	populate(objectMap, "fileName", a.FileName)
	populate(objectMap, "id", a.MediaID)
	populate(objectMap, "mimeType", a.MimeType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSAdvancedMessageMediaContent.
func (a *ACSAdvancedMessageMediaContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caption":
			err = unpopulate(val, "Caption", &a.Caption)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &a.FileName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "MediaID", &a.MediaID)
			delete(rawMsg, key)
		case "mimeType":
			err = unpopulate(val, "MimeType", &a.MimeType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSAdvancedMessageReceivedEventData.
func (a ACSAdvancedMessageReceivedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "button", a.Button)
	populate(objectMap, "channelType", a.ChannelKind)
	populate(objectMap, "content", a.Content)
	populate(objectMap, "context", a.Context)
	populate(objectMap, "error", a.Error)
	populate(objectMap, "from", a.From)
	populate(objectMap, "interactive", a.InteractiveContent)
	populate(objectMap, "media", a.MediaContent)
	populateDateTimeRFC3339(objectMap, "receivedTimestamp", a.ReceivedTimestamp)
	populate(objectMap, "to", a.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSAdvancedMessageReceivedEventData.
func (a *ACSAdvancedMessageReceivedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "button":
			err = unpopulate(val, "Button", &a.Button)
			delete(rawMsg, key)
		case "channelType":
			err = unpopulate(val, "ChannelKind", &a.ChannelKind)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &a.Content)
			delete(rawMsg, key)
		case "context":
			err = unpopulate(val, "Context", &a.Context)
			delete(rawMsg, key)
		case "error":
			err = unmarshalInternalACSAdvancedMessageChannelEventError(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "from":
			err = unpopulate(val, "From", &a.From)
			delete(rawMsg, key)
		case "interactive":
			err = unpopulate(val, "InteractiveContent", &a.InteractiveContent)
			delete(rawMsg, key)
		case "media":
			err = unpopulate(val, "MediaContent", &a.MediaContent)
			delete(rawMsg, key)
		case "receivedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "ReceivedTimestamp", &a.ReceivedTimestamp)
			delete(rawMsg, key)
		case "to":
			err = unpopulate(val, "To", &a.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatEventBaseProperties.
func (a ACSChatEventBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recipientCommunicationIdentifier", a.RecipientCommunicationIdentifier)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatEventBaseProperties.
func (a *ACSChatEventBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recipientCommunicationIdentifier":
			err = unpopulate(val, "RecipientCommunicationIdentifier", &a.RecipientCommunicationIdentifier)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatEventInThreadBaseProperties.
func (a ACSChatEventInThreadBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatEventInThreadBaseProperties.
func (a *ACSChatEventInThreadBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatMessageDeletedEventData.
func (a ACSChatMessageDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "composeTime", a.ComposeTime)
	populateDateTimeRFC3339(objectMap, "deleteTime", a.DeleteTime)
	populate(objectMap, "messageId", a.MessageID)
	populate(objectMap, "recipientCommunicationIdentifier", a.RecipientCommunicationIdentifier)
	populate(objectMap, "senderCommunicationIdentifier", a.SenderCommunicationIdentifier)
	populate(objectMap, "senderDisplayName", a.SenderDisplayName)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatMessageDeletedEventData.
func (a *ACSChatMessageDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "composeTime":
			err = unpopulateDateTimeRFC3339(val, "ComposeTime", &a.ComposeTime)
			delete(rawMsg, key)
		case "deleteTime":
			err = unpopulateDateTimeRFC3339(val, "DeleteTime", &a.DeleteTime)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "recipientCommunicationIdentifier":
			err = unpopulate(val, "RecipientCommunicationIdentifier", &a.RecipientCommunicationIdentifier)
			delete(rawMsg, key)
		case "senderCommunicationIdentifier":
			err = unpopulate(val, "SenderCommunicationIdentifier", &a.SenderCommunicationIdentifier)
			delete(rawMsg, key)
		case "senderDisplayName":
			err = unpopulate(val, "SenderDisplayName", &a.SenderDisplayName)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatMessageDeletedInThreadEventData.
func (a ACSChatMessageDeletedInThreadEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "composeTime", a.ComposeTime)
	populateDateTimeRFC3339(objectMap, "deleteTime", a.DeleteTime)
	populate(objectMap, "messageId", a.MessageID)
	populate(objectMap, "senderCommunicationIdentifier", a.SenderCommunicationIdentifier)
	populate(objectMap, "senderDisplayName", a.SenderDisplayName)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatMessageDeletedInThreadEventData.
func (a *ACSChatMessageDeletedInThreadEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "composeTime":
			err = unpopulateDateTimeRFC3339(val, "ComposeTime", &a.ComposeTime)
			delete(rawMsg, key)
		case "deleteTime":
			err = unpopulateDateTimeRFC3339(val, "DeleteTime", &a.DeleteTime)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "senderCommunicationIdentifier":
			err = unpopulate(val, "SenderCommunicationIdentifier", &a.SenderCommunicationIdentifier)
			delete(rawMsg, key)
		case "senderDisplayName":
			err = unpopulate(val, "SenderDisplayName", &a.SenderDisplayName)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatMessageEditedEventData.
func (a ACSChatMessageEditedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "composeTime", a.ComposeTime)
	populateDateTimeRFC3339(objectMap, "editTime", a.EditTime)
	populate(objectMap, "messageBody", a.MessageBody)
	populate(objectMap, "messageId", a.MessageID)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "recipientCommunicationIdentifier", a.RecipientCommunicationIdentifier)
	populate(objectMap, "senderCommunicationIdentifier", a.SenderCommunicationIdentifier)
	populate(objectMap, "senderDisplayName", a.SenderDisplayName)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatMessageEditedEventData.
func (a *ACSChatMessageEditedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "composeTime":
			err = unpopulateDateTimeRFC3339(val, "ComposeTime", &a.ComposeTime)
			delete(rawMsg, key)
		case "editTime":
			err = unpopulateDateTimeRFC3339(val, "EditTime", &a.EditTime)
			delete(rawMsg, key)
		case "messageBody":
			err = unpopulate(val, "MessageBody", &a.MessageBody)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "recipientCommunicationIdentifier":
			err = unpopulate(val, "RecipientCommunicationIdentifier", &a.RecipientCommunicationIdentifier)
			delete(rawMsg, key)
		case "senderCommunicationIdentifier":
			err = unpopulate(val, "SenderCommunicationIdentifier", &a.SenderCommunicationIdentifier)
			delete(rawMsg, key)
		case "senderDisplayName":
			err = unpopulate(val, "SenderDisplayName", &a.SenderDisplayName)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatMessageEditedInThreadEventData.
func (a ACSChatMessageEditedInThreadEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "composeTime", a.ComposeTime)
	populateDateTimeRFC3339(objectMap, "editTime", a.EditTime)
	populate(objectMap, "messageBody", a.MessageBody)
	populate(objectMap, "messageId", a.MessageID)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "senderCommunicationIdentifier", a.SenderCommunicationIdentifier)
	populate(objectMap, "senderDisplayName", a.SenderDisplayName)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatMessageEditedInThreadEventData.
func (a *ACSChatMessageEditedInThreadEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "composeTime":
			err = unpopulateDateTimeRFC3339(val, "ComposeTime", &a.ComposeTime)
			delete(rawMsg, key)
		case "editTime":
			err = unpopulateDateTimeRFC3339(val, "EditTime", &a.EditTime)
			delete(rawMsg, key)
		case "messageBody":
			err = unpopulate(val, "MessageBody", &a.MessageBody)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "senderCommunicationIdentifier":
			err = unpopulate(val, "SenderCommunicationIdentifier", &a.SenderCommunicationIdentifier)
			delete(rawMsg, key)
		case "senderDisplayName":
			err = unpopulate(val, "SenderDisplayName", &a.SenderDisplayName)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatMessageEventBaseProperties.
func (a ACSChatMessageEventBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "composeTime", a.ComposeTime)
	populate(objectMap, "messageId", a.MessageID)
	populate(objectMap, "recipientCommunicationIdentifier", a.RecipientCommunicationIdentifier)
	populate(objectMap, "senderCommunicationIdentifier", a.SenderCommunicationIdentifier)
	populate(objectMap, "senderDisplayName", a.SenderDisplayName)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatMessageEventBaseProperties.
func (a *ACSChatMessageEventBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "composeTime":
			err = unpopulateDateTimeRFC3339(val, "ComposeTime", &a.ComposeTime)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "recipientCommunicationIdentifier":
			err = unpopulate(val, "RecipientCommunicationIdentifier", &a.RecipientCommunicationIdentifier)
			delete(rawMsg, key)
		case "senderCommunicationIdentifier":
			err = unpopulate(val, "SenderCommunicationIdentifier", &a.SenderCommunicationIdentifier)
			delete(rawMsg, key)
		case "senderDisplayName":
			err = unpopulate(val, "SenderDisplayName", &a.SenderDisplayName)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatMessageEventInThreadBaseProperties.
func (a ACSChatMessageEventInThreadBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "composeTime", a.ComposeTime)
	populate(objectMap, "messageId", a.MessageID)
	populate(objectMap, "senderCommunicationIdentifier", a.SenderCommunicationIdentifier)
	populate(objectMap, "senderDisplayName", a.SenderDisplayName)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatMessageEventInThreadBaseProperties.
func (a *ACSChatMessageEventInThreadBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "composeTime":
			err = unpopulateDateTimeRFC3339(val, "ComposeTime", &a.ComposeTime)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "senderCommunicationIdentifier":
			err = unpopulate(val, "SenderCommunicationIdentifier", &a.SenderCommunicationIdentifier)
			delete(rawMsg, key)
		case "senderDisplayName":
			err = unpopulate(val, "SenderDisplayName", &a.SenderDisplayName)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatMessageReceivedEventData.
func (a ACSChatMessageReceivedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "composeTime", a.ComposeTime)
	populate(objectMap, "messageBody", a.MessageBody)
	populate(objectMap, "messageId", a.MessageID)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "recipientCommunicationIdentifier", a.RecipientCommunicationIdentifier)
	populate(objectMap, "senderCommunicationIdentifier", a.SenderCommunicationIdentifier)
	populate(objectMap, "senderDisplayName", a.SenderDisplayName)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatMessageReceivedEventData.
func (a *ACSChatMessageReceivedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "composeTime":
			err = unpopulateDateTimeRFC3339(val, "ComposeTime", &a.ComposeTime)
			delete(rawMsg, key)
		case "messageBody":
			err = unpopulate(val, "MessageBody", &a.MessageBody)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "recipientCommunicationIdentifier":
			err = unpopulate(val, "RecipientCommunicationIdentifier", &a.RecipientCommunicationIdentifier)
			delete(rawMsg, key)
		case "senderCommunicationIdentifier":
			err = unpopulate(val, "SenderCommunicationIdentifier", &a.SenderCommunicationIdentifier)
			delete(rawMsg, key)
		case "senderDisplayName":
			err = unpopulate(val, "SenderDisplayName", &a.SenderDisplayName)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatMessageReceivedInThreadEventData.
func (a ACSChatMessageReceivedInThreadEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "composeTime", a.ComposeTime)
	populate(objectMap, "messageBody", a.MessageBody)
	populate(objectMap, "messageId", a.MessageID)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "senderCommunicationIdentifier", a.SenderCommunicationIdentifier)
	populate(objectMap, "senderDisplayName", a.SenderDisplayName)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "type", a.Type)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatMessageReceivedInThreadEventData.
func (a *ACSChatMessageReceivedInThreadEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "composeTime":
			err = unpopulateDateTimeRFC3339(val, "ComposeTime", &a.ComposeTime)
			delete(rawMsg, key)
		case "messageBody":
			err = unpopulate(val, "MessageBody", &a.MessageBody)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "senderCommunicationIdentifier":
			err = unpopulate(val, "SenderCommunicationIdentifier", &a.SenderCommunicationIdentifier)
			delete(rawMsg, key)
		case "senderDisplayName":
			err = unpopulate(val, "SenderDisplayName", &a.SenderDisplayName)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatParticipantAddedToThreadEventData.
func (a ACSChatParticipantAddedToThreadEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addedByCommunicationIdentifier", a.AddedByCommunicationIdentifier)
	populate(objectMap, "participantAdded", a.ParticipantAdded)
	populate(objectMap, "threadId", a.ThreadID)
	populateDateTimeRFC3339(objectMap, "time", a.Time)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatParticipantAddedToThreadEventData.
func (a *ACSChatParticipantAddedToThreadEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addedByCommunicationIdentifier":
			err = unpopulate(val, "AddedByCommunicationIdentifier", &a.AddedByCommunicationIdentifier)
			delete(rawMsg, key)
		case "participantAdded":
			err = unpopulate(val, "ParticipantAdded", &a.ParticipantAdded)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "time":
			err = unpopulateDateTimeRFC3339(val, "Time", &a.Time)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatParticipantAddedToThreadWithUserEventData.
func (a ACSChatParticipantAddedToThreadWithUserEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addedByCommunicationIdentifier", a.AddedByCommunicationIdentifier)
	populateDateTimeRFC3339(objectMap, "createTime", a.CreateTime)
	populate(objectMap, "participantAdded", a.ParticipantAdded)
	populate(objectMap, "recipientCommunicationIdentifier", a.RecipientCommunicationIdentifier)
	populate(objectMap, "threadId", a.ThreadID)
	populateDateTimeRFC3339(objectMap, "time", a.Time)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatParticipantAddedToThreadWithUserEventData.
func (a *ACSChatParticipantAddedToThreadWithUserEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addedByCommunicationIdentifier":
			err = unpopulate(val, "AddedByCommunicationIdentifier", &a.AddedByCommunicationIdentifier)
			delete(rawMsg, key)
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &a.CreateTime)
			delete(rawMsg, key)
		case "participantAdded":
			err = unpopulate(val, "ParticipantAdded", &a.ParticipantAdded)
			delete(rawMsg, key)
		case "recipientCommunicationIdentifier":
			err = unpopulate(val, "RecipientCommunicationIdentifier", &a.RecipientCommunicationIdentifier)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "time":
			err = unpopulateDateTimeRFC3339(val, "Time", &a.Time)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatParticipantRemovedFromThreadEventData.
func (a ACSChatParticipantRemovedFromThreadEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "participantRemoved", a.ParticipantRemoved)
	populate(objectMap, "removedByCommunicationIdentifier", a.RemovedByCommunicationIdentifier)
	populate(objectMap, "threadId", a.ThreadID)
	populateDateTimeRFC3339(objectMap, "time", a.Time)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatParticipantRemovedFromThreadEventData.
func (a *ACSChatParticipantRemovedFromThreadEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "participantRemoved":
			err = unpopulate(val, "ParticipantRemoved", &a.ParticipantRemoved)
			delete(rawMsg, key)
		case "removedByCommunicationIdentifier":
			err = unpopulate(val, "RemovedByCommunicationIdentifier", &a.RemovedByCommunicationIdentifier)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "time":
			err = unpopulateDateTimeRFC3339(val, "Time", &a.Time)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatParticipantRemovedFromThreadWithUserEventData.
func (a ACSChatParticipantRemovedFromThreadWithUserEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createTime", a.CreateTime)
	populate(objectMap, "participantRemoved", a.ParticipantRemoved)
	populate(objectMap, "recipientCommunicationIdentifier", a.RecipientCommunicationIdentifier)
	populate(objectMap, "removedByCommunicationIdentifier", a.RemovedByCommunicationIdentifier)
	populate(objectMap, "threadId", a.ThreadID)
	populateDateTimeRFC3339(objectMap, "time", a.Time)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatParticipantRemovedFromThreadWithUserEventData.
func (a *ACSChatParticipantRemovedFromThreadWithUserEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &a.CreateTime)
			delete(rawMsg, key)
		case "participantRemoved":
			err = unpopulate(val, "ParticipantRemoved", &a.ParticipantRemoved)
			delete(rawMsg, key)
		case "recipientCommunicationIdentifier":
			err = unpopulate(val, "RecipientCommunicationIdentifier", &a.RecipientCommunicationIdentifier)
			delete(rawMsg, key)
		case "removedByCommunicationIdentifier":
			err = unpopulate(val, "RemovedByCommunicationIdentifier", &a.RemovedByCommunicationIdentifier)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "time":
			err = unpopulateDateTimeRFC3339(val, "Time", &a.Time)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatThreadCreatedEventData.
func (a ACSChatThreadCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createTime", a.CreateTime)
	populate(objectMap, "createdByCommunicationIdentifier", a.CreatedByCommunicationIdentifier)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "participants", a.Participants)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatThreadCreatedEventData.
func (a *ACSChatThreadCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &a.CreateTime)
			delete(rawMsg, key)
		case "createdByCommunicationIdentifier":
			err = unpopulate(val, "CreatedByCommunicationIdentifier", &a.CreatedByCommunicationIdentifier)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "participants":
			err = unpopulate(val, "Participants", &a.Participants)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatThreadCreatedWithUserEventData.
func (a ACSChatThreadCreatedWithUserEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createTime", a.CreateTime)
	populate(objectMap, "createdByCommunicationIdentifier", a.CreatedByCommunicationIdentifier)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "participants", a.Participants)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "recipientCommunicationIdentifier", a.RecipientCommunicationIdentifier)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatThreadCreatedWithUserEventData.
func (a *ACSChatThreadCreatedWithUserEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &a.CreateTime)
			delete(rawMsg, key)
		case "createdByCommunicationIdentifier":
			err = unpopulate(val, "CreatedByCommunicationIdentifier", &a.CreatedByCommunicationIdentifier)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "participants":
			err = unpopulate(val, "Participants", &a.Participants)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "recipientCommunicationIdentifier":
			err = unpopulate(val, "RecipientCommunicationIdentifier", &a.RecipientCommunicationIdentifier)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatThreadDeletedEventData.
func (a ACSChatThreadDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createTime", a.CreateTime)
	populateDateTimeRFC3339(objectMap, "deleteTime", a.DeleteTime)
	populate(objectMap, "deletedByCommunicationIdentifier", a.DeletedByCommunicationIdentifier)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatThreadDeletedEventData.
func (a *ACSChatThreadDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &a.CreateTime)
			delete(rawMsg, key)
		case "deleteTime":
			err = unpopulateDateTimeRFC3339(val, "DeleteTime", &a.DeleteTime)
			delete(rawMsg, key)
		case "deletedByCommunicationIdentifier":
			err = unpopulate(val, "DeletedByCommunicationIdentifier", &a.DeletedByCommunicationIdentifier)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatThreadEventBaseProperties.
func (a ACSChatThreadEventBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createTime", a.CreateTime)
	populate(objectMap, "recipientCommunicationIdentifier", a.RecipientCommunicationIdentifier)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatThreadEventBaseProperties.
func (a *ACSChatThreadEventBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &a.CreateTime)
			delete(rawMsg, key)
		case "recipientCommunicationIdentifier":
			err = unpopulate(val, "RecipientCommunicationIdentifier", &a.RecipientCommunicationIdentifier)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatThreadEventInThreadBaseProperties.
func (a ACSChatThreadEventInThreadBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createTime", a.CreateTime)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatThreadEventInThreadBaseProperties.
func (a *ACSChatThreadEventInThreadBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &a.CreateTime)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatThreadParticipantProperties.
func (a ACSChatThreadParticipantProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "participantCommunicationIdentifier", a.ParticipantCommunicationIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatThreadParticipantProperties.
func (a *ACSChatThreadParticipantProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "participantCommunicationIdentifier":
			err = unpopulate(val, "ParticipantCommunicationIdentifier", &a.ParticipantCommunicationIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatThreadPropertiesUpdatedEventData.
func (a ACSChatThreadPropertiesUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createTime", a.CreateTime)
	populateDateTimeRFC3339(objectMap, "editTime", a.EditTime)
	populate(objectMap, "editedByCommunicationIdentifier", a.EditedByCommunicationIdentifier)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatThreadPropertiesUpdatedEventData.
func (a *ACSChatThreadPropertiesUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &a.CreateTime)
			delete(rawMsg, key)
		case "editTime":
			err = unpopulateDateTimeRFC3339(val, "EditTime", &a.EditTime)
			delete(rawMsg, key)
		case "editedByCommunicationIdentifier":
			err = unpopulate(val, "EditedByCommunicationIdentifier", &a.EditedByCommunicationIdentifier)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatThreadPropertiesUpdatedPerUserEventData.
func (a ACSChatThreadPropertiesUpdatedPerUserEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createTime", a.CreateTime)
	populateDateTimeRFC3339(objectMap, "editTime", a.EditTime)
	populate(objectMap, "editedByCommunicationIdentifier", a.EditedByCommunicationIdentifier)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "recipientCommunicationIdentifier", a.RecipientCommunicationIdentifier)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatThreadPropertiesUpdatedPerUserEventData.
func (a *ACSChatThreadPropertiesUpdatedPerUserEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &a.CreateTime)
			delete(rawMsg, key)
		case "editTime":
			err = unpopulateDateTimeRFC3339(val, "EditTime", &a.EditTime)
			delete(rawMsg, key)
		case "editedByCommunicationIdentifier":
			err = unpopulate(val, "EditedByCommunicationIdentifier", &a.EditedByCommunicationIdentifier)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "recipientCommunicationIdentifier":
			err = unpopulate(val, "RecipientCommunicationIdentifier", &a.RecipientCommunicationIdentifier)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSChatThreadWithUserDeletedEventData.
func (a ACSChatThreadWithUserDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createTime", a.CreateTime)
	populateDateTimeRFC3339(objectMap, "deleteTime", a.DeleteTime)
	populate(objectMap, "deletedByCommunicationIdentifier", a.DeletedByCommunicationIdentifier)
	populate(objectMap, "recipientCommunicationIdentifier", a.RecipientCommunicationIdentifier)
	populate(objectMap, "threadId", a.ThreadID)
	populate(objectMap, "transactionId", a.TransactionID)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSChatThreadWithUserDeletedEventData.
func (a *ACSChatThreadWithUserDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &a.CreateTime)
			delete(rawMsg, key)
		case "deleteTime":
			err = unpopulateDateTimeRFC3339(val, "DeleteTime", &a.DeleteTime)
			delete(rawMsg, key)
		case "deletedByCommunicationIdentifier":
			err = unpopulate(val, "DeletedByCommunicationIdentifier", &a.DeletedByCommunicationIdentifier)
			delete(rawMsg, key)
		case "recipientCommunicationIdentifier":
			err = unpopulate(val, "RecipientCommunicationIdentifier", &a.RecipientCommunicationIdentifier)
			delete(rawMsg, key)
		case "threadId":
			err = unpopulate(val, "ThreadID", &a.ThreadID)
			delete(rawMsg, key)
		case "transactionId":
			err = unpopulate(val, "TransactionID", &a.TransactionID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSEmailDeliveryReportReceivedEventData.
func (a ACSEmailDeliveryReportReceivedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "deliveryAttemptTimeStamp", a.DeliveryAttemptTimestamp)
	populate(objectMap, "deliveryStatusDetails", a.DeliveryStatusDetails)
	populate(objectMap, "messageId", a.MessageID)
	populate(objectMap, "recipient", a.Recipient)
	populate(objectMap, "sender", a.Sender)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSEmailDeliveryReportReceivedEventData.
func (a *ACSEmailDeliveryReportReceivedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deliveryAttemptTimeStamp":
			err = unpopulateDateTimeRFC3339(val, "DeliveryAttemptTimestamp", &a.DeliveryAttemptTimestamp)
			delete(rawMsg, key)
		case "deliveryStatusDetails":
			err = unpopulate(val, "DeliveryStatusDetails", &a.DeliveryStatusDetails)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "recipient":
			err = unpopulate(val, "Recipient", &a.Recipient)
			delete(rawMsg, key)
		case "sender":
			err = unpopulate(val, "Sender", &a.Sender)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSEmailDeliveryReportStatusDetails.
func (a ACSEmailDeliveryReportStatusDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "statusMessage", a.StatusMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSEmailDeliveryReportStatusDetails.
func (a *ACSEmailDeliveryReportStatusDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "statusMessage":
			err = unpopulate(val, "StatusMessage", &a.StatusMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSEmailEngagementTrackingReportReceivedEventData.
func (a ACSEmailEngagementTrackingReportReceivedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "engagementType", a.Engagement)
	populate(objectMap, "engagementContext", a.EngagementContext)
	populate(objectMap, "messageId", a.MessageID)
	populate(objectMap, "recipient", a.Recipient)
	populate(objectMap, "sender", a.Sender)
	populateDateTimeRFC3339(objectMap, "userActionTimeStamp", a.UserActionTimestamp)
	populate(objectMap, "userAgent", a.UserAgent)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSEmailEngagementTrackingReportReceivedEventData.
func (a *ACSEmailEngagementTrackingReportReceivedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "engagementType":
			err = unpopulate(val, "Engagement", &a.Engagement)
			delete(rawMsg, key)
		case "engagementContext":
			err = unpopulate(val, "EngagementContext", &a.EngagementContext)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "recipient":
			err = unpopulate(val, "Recipient", &a.Recipient)
			delete(rawMsg, key)
		case "sender":
			err = unpopulate(val, "Sender", &a.Sender)
			delete(rawMsg, key)
		case "userActionTimeStamp":
			err = unpopulateDateTimeRFC3339(val, "UserActionTimestamp", &a.UserActionTimestamp)
			delete(rawMsg, key)
		case "userAgent":
			err = unpopulate(val, "UserAgent", &a.UserAgent)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSIncomingCallCustomContext.
func (a ACSIncomingCallCustomContext) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sipHeaders", a.SipHeaders)
	populate(objectMap, "voipHeaders", a.VoipHeaders)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSIncomingCallCustomContext.
func (a *ACSIncomingCallCustomContext) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sipHeaders":
			err = unpopulate(val, "SipHeaders", &a.SipHeaders)
			delete(rawMsg, key)
		case "voipHeaders":
			err = unpopulate(val, "VoipHeaders", &a.VoipHeaders)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSIncomingCallEventData.
func (a ACSIncomingCallEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "callerDisplayName", a.CallerDisplayName)
	populate(objectMap, "correlationId", a.CorrelationID)
	populate(objectMap, "customContext", a.CustomContext)
	populate(objectMap, "from", a.FromCommunicationIdentifier)
	populate(objectMap, "incomingCallContext", a.IncomingCallContext)
	populate(objectMap, "serverCallId", a.ServerCallID)
	populate(objectMap, "to", a.ToCommunicationIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSIncomingCallEventData.
func (a *ACSIncomingCallEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "callerDisplayName":
			err = unpopulate(val, "CallerDisplayName", &a.CallerDisplayName)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &a.CorrelationID)
			delete(rawMsg, key)
		case "customContext":
			err = unpopulate(val, "CustomContext", &a.CustomContext)
			delete(rawMsg, key)
		case "from":
			err = unpopulate(val, "FromCommunicationIdentifier", &a.FromCommunicationIdentifier)
			delete(rawMsg, key)
		case "incomingCallContext":
			err = unpopulate(val, "IncomingCallContext", &a.IncomingCallContext)
			delete(rawMsg, key)
		case "serverCallId":
			err = unpopulate(val, "ServerCallID", &a.ServerCallID)
			delete(rawMsg, key)
		case "to":
			err = unpopulate(val, "ToCommunicationIdentifier", &a.ToCommunicationIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRecordingChunkInfoProperties.
func (a ACSRecordingChunkInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contentLocation", a.ContentLocation)
	populate(objectMap, "deleteLocation", a.DeleteLocation)
	populate(objectMap, "documentId", a.DocumentID)
	populate(objectMap, "endReason", a.EndReason)
	populate(objectMap, "index", a.Index)
	populate(objectMap, "metadataLocation", a.MetadataLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRecordingChunkInfoProperties.
func (a *ACSRecordingChunkInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contentLocation":
			err = unpopulate(val, "ContentLocation", &a.ContentLocation)
			delete(rawMsg, key)
		case "deleteLocation":
			err = unpopulate(val, "DeleteLocation", &a.DeleteLocation)
			delete(rawMsg, key)
		case "documentId":
			err = unpopulate(val, "DocumentID", &a.DocumentID)
			delete(rawMsg, key)
		case "endReason":
			err = unpopulate(val, "EndReason", &a.EndReason)
			delete(rawMsg, key)
		case "index":
			err = unpopulate(val, "Index", &a.Index)
			delete(rawMsg, key)
		case "metadataLocation":
			err = unpopulate(val, "MetadataLocation", &a.MetadataLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRecordingFileStatusUpdatedEventData.
func (a ACSRecordingFileStatusUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recordingChannelType", a.RecordingChannelKind)
	populate(objectMap, "recordingContentType", a.RecordingContentType)
	populate(objectMap, "recordingDurationMs", a.RecordingDurationMs)
	populate(objectMap, "recordingFormatType", a.RecordingFormatType)
	populateDateTimeRFC3339(objectMap, "recordingStartTime", a.RecordingStartTime)
	populate(objectMap, "recordingStorageInfo", a.RecordingStorageInfo)
	populate(objectMap, "sessionEndReason", a.SessionEndReason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRecordingFileStatusUpdatedEventData.
func (a *ACSRecordingFileStatusUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recordingChannelType":
			err = unpopulate(val, "RecordingChannelType", &a.RecordingChannelKind)
			delete(rawMsg, key)
		case "recordingContentType":
			err = unpopulate(val, "RecordingContentType", &a.RecordingContentType)
			delete(rawMsg, key)
		case "recordingDurationMs":
			err = unpopulate(val, "RecordingDurationMs", &a.RecordingDurationMs)
			delete(rawMsg, key)
		case "recordingFormatType":
			err = unpopulate(val, "RecordingFormatType", &a.RecordingFormatType)
			delete(rawMsg, key)
		case "recordingStartTime":
			err = unpopulateDateTimeRFC3339(val, "RecordingStartTime", &a.RecordingStartTime)
			delete(rawMsg, key)
		case "recordingStorageInfo":
			err = unpopulate(val, "RecordingStorageInfo", &a.RecordingStorageInfo)
			delete(rawMsg, key)
		case "sessionEndReason":
			err = unpopulate(val, "SessionEndReason", &a.SessionEndReason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRecordingStorageInfoProperties.
func (a ACSRecordingStorageInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recordingChunks", a.RecordingChunks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRecordingStorageInfoProperties.
func (a *ACSRecordingStorageInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recordingChunks":
			err = unpopulate(val, "RecordingChunks", &a.RecordingChunks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterChannelConfiguration.
func (a ACSRouterChannelConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityCostPerJob", a.CapacityCostPerJob)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "maxNumberOfJobs", a.MaxNumberOfJobs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterChannelConfiguration.
func (a *ACSRouterChannelConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityCostPerJob":
			err = unpopulate(val, "CapacityCostPerJob", &a.CapacityCostPerJob)
			delete(rawMsg, key)
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "maxNumberOfJobs":
			err = unpopulate(val, "MaxNumberOfJobs", &a.MaxNumberOfJobs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AcsRouterCommunicationError.
func (a internalAcsRouterCommunicationError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", a.Code)
	populate(objectMap, "details", a.Details)
	populate(objectMap, "innererror", a.Innererror)
	populate(objectMap, "message", a.Message)
	populate(objectMap, "target", a.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AcsRouterCommunicationError.
func (a *internalAcsRouterCommunicationError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &a.Details)
			delete(rawMsg, key)
		case "innererror":
			err = unpopulate(val, "Innererror", &a.Innererror)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &a.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterEventData.
func (a ACSRouterEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "jobId", a.JobID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterEventData.
func (a *ACSRouterEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobCancelledEventData.
func (a ACSRouterJobCancelledEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "dispositionCode", a.DispositionCode)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "note", a.Note)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobCancelledEventData.
func (a *ACSRouterJobCancelledEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "dispositionCode":
			err = unpopulate(val, "DispositionCode", &a.DispositionCode)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "note":
			err = unpopulate(val, "Note", &a.Note)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobClassificationFailedEventData.
func (a ACSRouterJobClassificationFailedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "classificationPolicyId", a.ClassificationPolicyID)
	populate(objectMap, "errors", a.Errors)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobClassificationFailedEventData.
func (a *ACSRouterJobClassificationFailedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "classificationPolicyId":
			err = unpopulate(val, "ClassificationPolicyID", &a.ClassificationPolicyID)
			delete(rawMsg, key)
		case "errors":
			err = unmarshalInternalACSRouterCommunicationError(val, "Errors", &a.Errors)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobClassifiedEventData.
func (a ACSRouterJobClassifiedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attachedWorkerSelectors", a.AttachedWorkerSelectors)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "classificationPolicyId", a.ClassificationPolicyID)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "priority", a.Priority)
	populate(objectMap, "queueDetails", a.QueueDetails)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobClassifiedEventData.
func (a *ACSRouterJobClassifiedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attachedWorkerSelectors":
			err = unpopulate(val, "AttachedWorkerSelectors", &a.AttachedWorkerSelectors)
			delete(rawMsg, key)
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "classificationPolicyId":
			err = unpopulate(val, "ClassificationPolicyID", &a.ClassificationPolicyID)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &a.Priority)
			delete(rawMsg, key)
		case "queueDetails":
			err = unpopulate(val, "QueueDetails", &a.QueueDetails)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobClosedEventData.
func (a ACSRouterJobClosedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignmentId", a.AssignmentID)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "dispositionCode", a.DispositionCode)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "workerId", a.WorkerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobClosedEventData.
func (a *ACSRouterJobClosedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignmentId":
			err = unpopulate(val, "AssignmentID", &a.AssignmentID)
			delete(rawMsg, key)
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "dispositionCode":
			err = unpopulate(val, "DispositionCode", &a.DispositionCode)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "workerId":
			err = unpopulate(val, "WorkerID", &a.WorkerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobCompletedEventData.
func (a ACSRouterJobCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignmentId", a.AssignmentID)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "workerId", a.WorkerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobCompletedEventData.
func (a *ACSRouterJobCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignmentId":
			err = unpopulate(val, "AssignmentID", &a.AssignmentID)
			delete(rawMsg, key)
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "workerId":
			err = unpopulate(val, "WorkerID", &a.WorkerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobDeletedEventData.
func (a ACSRouterJobDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobDeletedEventData.
func (a *ACSRouterJobDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobEventData.
func (a ACSRouterJobEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobEventData.
func (a *ACSRouterJobEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobExceptionTriggeredEventData.
func (a ACSRouterJobExceptionTriggeredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "exceptionRuleId", a.ExceptionRuleID)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "ruleKey", a.RuleKey)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobExceptionTriggeredEventData.
func (a *ACSRouterJobExceptionTriggeredEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "exceptionRuleId":
			err = unpopulate(val, "ExceptionRuleID", &a.ExceptionRuleID)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "ruleKey":
			err = unpopulate(val, "RuleKey", &a.RuleKey)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobQueuedEventData.
func (a ACSRouterJobQueuedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attachedWorkerSelectors", a.AttachedWorkerSelectors)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "priority", a.Priority)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "requestedWorkerSelectors", a.RequestedWorkerSelectors)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobQueuedEventData.
func (a *ACSRouterJobQueuedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attachedWorkerSelectors":
			err = unpopulate(val, "AttachedWorkerSelectors", &a.AttachedWorkerSelectors)
			delete(rawMsg, key)
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &a.Priority)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "requestedWorkerSelectors":
			err = unpopulate(val, "RequestedWorkerSelectors", &a.RequestedWorkerSelectors)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobReceivedEventData.
func (a ACSRouterJobReceivedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "classificationPolicyId", a.ClassificationPolicyID)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "jobStatus", a.JobStatus)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "priority", a.Priority)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "requestedWorkerSelectors", a.RequestedWorkerSelectors)
	populateDateTimeRFC3339(objectMap, "scheduledOn", a.ScheduledOn)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "unavailableForMatching", a.UnavailableForMatching)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobReceivedEventData.
func (a *ACSRouterJobReceivedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "classificationPolicyId":
			err = unpopulate(val, "ClassificationPolicyID", &a.ClassificationPolicyID)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "jobStatus":
			err = unpopulate(val, "JobStatus", &a.JobStatus)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &a.Priority)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "requestedWorkerSelectors":
			err = unpopulate(val, "RequestedWorkerSelectors", &a.RequestedWorkerSelectors)
			delete(rawMsg, key)
		case "scheduledOn":
			err = unpopulateDateTimeRFC3339(val, "ScheduledOn", &a.ScheduledOn)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "unavailableForMatching":
			err = unpopulate(val, "UnavailableForMatching", &a.UnavailableForMatching)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobSchedulingFailedEventData.
func (a ACSRouterJobSchedulingFailedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "expiredAttachedWorkerSelectors", a.ExpiredAttachedWorkerSelectors)
	populate(objectMap, "expiredRequestedWorkerSelectors", a.ExpiredRequestedWorkerSelectors)
	populate(objectMap, "failureReason", a.FailureReason)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "priority", a.Priority)
	populate(objectMap, "queueId", a.QueueID)
	populateDateTimeRFC3339(objectMap, "scheduledOn", a.ScheduledOn)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobSchedulingFailedEventData.
func (a *ACSRouterJobSchedulingFailedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "expiredAttachedWorkerSelectors":
			err = unpopulate(val, "ExpiredAttachedWorkerSelectors", &a.ExpiredAttachedWorkerSelectors)
			delete(rawMsg, key)
		case "expiredRequestedWorkerSelectors":
			err = unpopulate(val, "ExpiredRequestedWorkerSelectors", &a.ExpiredRequestedWorkerSelectors)
			delete(rawMsg, key)
		case "failureReason":
			err = unpopulate(val, "FailureReason", &a.FailureReason)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &a.Priority)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "scheduledOn":
			err = unpopulateDateTimeRFC3339(val, "ScheduledOn", &a.ScheduledOn)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobUnassignedEventData.
func (a ACSRouterJobUnassignedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignmentId", a.AssignmentID)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "workerId", a.WorkerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobUnassignedEventData.
func (a *ACSRouterJobUnassignedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignmentId":
			err = unpopulate(val, "AssignmentID", &a.AssignmentID)
			delete(rawMsg, key)
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "workerId":
			err = unpopulate(val, "WorkerID", &a.WorkerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobWaitingForActivationEventData.
func (a ACSRouterJobWaitingForActivationEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "expiredAttachedWorkerSelectors", a.ExpiredAttachedWorkerSelectors)
	populate(objectMap, "expiredRequestedWorkerSelectors", a.ExpiredRequestedWorkerSelectors)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "priority", a.Priority)
	populate(objectMap, "queueId", a.QueueID)
	populateDateTimeRFC3339(objectMap, "scheduledOn", a.ScheduledOn)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "unavailableForMatching", a.UnavailableForMatching)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobWaitingForActivationEventData.
func (a *ACSRouterJobWaitingForActivationEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "expiredAttachedWorkerSelectors":
			err = unpopulate(val, "ExpiredAttachedWorkerSelectors", &a.ExpiredAttachedWorkerSelectors)
			delete(rawMsg, key)
		case "expiredRequestedWorkerSelectors":
			err = unpopulate(val, "ExpiredRequestedWorkerSelectors", &a.ExpiredRequestedWorkerSelectors)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &a.Priority)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "scheduledOn":
			err = unpopulateDateTimeRFC3339(val, "ScheduledOn", &a.ScheduledOn)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "unavailableForMatching":
			err = unpopulate(val, "UnavailableForMatching", &a.UnavailableForMatching)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterJobWorkerSelectorsExpiredEventData.
func (a ACSRouterJobWorkerSelectorsExpiredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "expiredAttachedWorkerSelectors", a.ExpiredAttachedWorkerSelectors)
	populate(objectMap, "expiredRequestedWorkerSelectors", a.ExpiredRequestedWorkerSelectors)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterJobWorkerSelectorsExpiredEventData.
func (a *ACSRouterJobWorkerSelectorsExpiredEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "expiredAttachedWorkerSelectors":
			err = unpopulate(val, "ExpiredAttachedWorkerSelectors", &a.ExpiredAttachedWorkerSelectors)
			delete(rawMsg, key)
		case "expiredRequestedWorkerSelectors":
			err = unpopulate(val, "ExpiredRequestedWorkerSelectors", &a.ExpiredRequestedWorkerSelectors)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterQueueDetails.
func (a ACSRouterQueueDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterQueueDetails.
func (a *ACSRouterQueueDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterWorkerDeletedEventData.
func (a ACSRouterWorkerDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "workerId", a.WorkerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterWorkerDeletedEventData.
func (a *ACSRouterWorkerDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "workerId":
			err = unpopulate(val, "WorkerID", &a.WorkerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterWorkerDeregisteredEventData.
func (a ACSRouterWorkerDeregisteredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "workerId", a.WorkerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterWorkerDeregisteredEventData.
func (a *ACSRouterWorkerDeregisteredEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "workerId":
			err = unpopulate(val, "WorkerID", &a.WorkerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterWorkerEventData.
func (a ACSRouterWorkerEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "workerId", a.WorkerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterWorkerEventData.
func (a *ACSRouterWorkerEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "workerId":
			err = unpopulate(val, "WorkerID", &a.WorkerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterWorkerOfferAcceptedEventData.
func (a ACSRouterWorkerOfferAcceptedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignmentId", a.AssignmentID)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "jobLabels", a.JobLabels)
	populate(objectMap, "jobPriority", a.JobPriority)
	populate(objectMap, "jobTags", a.JobTags)
	populate(objectMap, "offerId", a.OfferID)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "workerId", a.WorkerID)
	populate(objectMap, "workerLabels", a.WorkerLabels)
	populate(objectMap, "workerTags", a.WorkerTags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterWorkerOfferAcceptedEventData.
func (a *ACSRouterWorkerOfferAcceptedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignmentId":
			err = unpopulate(val, "AssignmentID", &a.AssignmentID)
			delete(rawMsg, key)
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "jobLabels":
			err = unpopulate(val, "JobLabels", &a.JobLabels)
			delete(rawMsg, key)
		case "jobPriority":
			err = unpopulate(val, "JobPriority", &a.JobPriority)
			delete(rawMsg, key)
		case "jobTags":
			err = unpopulate(val, "JobTags", &a.JobTags)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &a.OfferID)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "workerId":
			err = unpopulate(val, "WorkerID", &a.WorkerID)
			delete(rawMsg, key)
		case "workerLabels":
			err = unpopulate(val, "WorkerLabels", &a.WorkerLabels)
			delete(rawMsg, key)
		case "workerTags":
			err = unpopulate(val, "WorkerTags", &a.WorkerTags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterWorkerOfferDeclinedEventData.
func (a ACSRouterWorkerOfferDeclinedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "offerId", a.OfferID)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "workerId", a.WorkerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterWorkerOfferDeclinedEventData.
func (a *ACSRouterWorkerOfferDeclinedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &a.OfferID)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "workerId":
			err = unpopulate(val, "WorkerID", &a.WorkerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterWorkerOfferExpiredEventData.
func (a ACSRouterWorkerOfferExpiredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "offerId", a.OfferID)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "workerId", a.WorkerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterWorkerOfferExpiredEventData.
func (a *ACSRouterWorkerOfferExpiredEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &a.OfferID)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "workerId":
			err = unpopulate(val, "WorkerID", &a.WorkerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterWorkerOfferIssuedEventData.
func (a ACSRouterWorkerOfferIssuedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populateDateTimeRFC3339(objectMap, "expiresOn", a.ExpiresOn)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "jobLabels", a.JobLabels)
	populate(objectMap, "jobPriority", a.JobPriority)
	populate(objectMap, "jobTags", a.JobTags)
	populate(objectMap, "offerId", a.OfferID)
	populateDateTimeRFC3339(objectMap, "offeredOn", a.OfferedOn)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "workerId", a.WorkerID)
	populate(objectMap, "workerLabels", a.WorkerLabels)
	populate(objectMap, "workerTags", a.WorkerTags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterWorkerOfferIssuedEventData.
func (a *ACSRouterWorkerOfferIssuedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "expiresOn":
			err = unpopulateDateTimeRFC3339(val, "ExpiresOn", &a.ExpiresOn)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "jobLabels":
			err = unpopulate(val, "JobLabels", &a.JobLabels)
			delete(rawMsg, key)
		case "jobPriority":
			err = unpopulate(val, "JobPriority", &a.JobPriority)
			delete(rawMsg, key)
		case "jobTags":
			err = unpopulate(val, "JobTags", &a.JobTags)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &a.OfferID)
			delete(rawMsg, key)
		case "offeredOn":
			err = unpopulateDateTimeRFC3339(val, "OfferedOn", &a.OfferedOn)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "workerId":
			err = unpopulate(val, "WorkerID", &a.WorkerID)
			delete(rawMsg, key)
		case "workerLabels":
			err = unpopulate(val, "WorkerLabels", &a.WorkerLabels)
			delete(rawMsg, key)
		case "workerTags":
			err = unpopulate(val, "WorkerTags", &a.WorkerTags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterWorkerOfferRevokedEventData.
func (a ACSRouterWorkerOfferRevokedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelId", a.ChannelID)
	populate(objectMap, "channelReference", a.ChannelReference)
	populate(objectMap, "jobId", a.JobID)
	populate(objectMap, "offerId", a.OfferID)
	populate(objectMap, "queueId", a.QueueID)
	populate(objectMap, "workerId", a.WorkerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterWorkerOfferRevokedEventData.
func (a *ACSRouterWorkerOfferRevokedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelId":
			err = unpopulate(val, "ChannelID", &a.ChannelID)
			delete(rawMsg, key)
		case "channelReference":
			err = unpopulate(val, "ChannelReference", &a.ChannelReference)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &a.JobID)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &a.OfferID)
			delete(rawMsg, key)
		case "queueId":
			err = unpopulate(val, "QueueID", &a.QueueID)
			delete(rawMsg, key)
		case "workerId":
			err = unpopulate(val, "WorkerID", &a.WorkerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterWorkerRegisteredEventData.
func (a ACSRouterWorkerRegisteredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelConfigurations", a.ChannelConfigurations)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "queueAssignments", a.QueueAssignments)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "totalCapacity", a.TotalCapacity)
	populate(objectMap, "workerId", a.WorkerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterWorkerRegisteredEventData.
func (a *ACSRouterWorkerRegisteredEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelConfigurations":
			err = unpopulate(val, "ChannelConfigurations", &a.ChannelConfigurations)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "queueAssignments":
			err = unpopulate(val, "QueueAssignments", &a.QueueAssignments)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "totalCapacity":
			err = unpopulate(val, "TotalCapacity", &a.TotalCapacity)
			delete(rawMsg, key)
		case "workerId":
			err = unpopulate(val, "WorkerID", &a.WorkerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterWorkerSelector.
func (a ACSRouterWorkerSelector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "expirationTime", a.ExpirationTime)
	populate(objectMap, "key", a.Key)
	populate(objectMap, "labelOperator", a.LabelOperator)
	populateAny(objectMap, "value", a.LabelValue)
	populate(objectMap, "state", a.State)
	populate(objectMap, "ttlSeconds", a.TimeToLive)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterWorkerSelector.
func (a *ACSRouterWorkerSelector) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationTime":
			err = unpopulateDateTimeRFC3339(val, "ExpirationTime", &a.ExpirationTime)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &a.Key)
			delete(rawMsg, key)
		case "labelOperator":
			err = unpopulate(val, "LabelOperator", &a.LabelOperator)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "LabelValue", &a.LabelValue)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "ttlSeconds":
			err = unpopulate(val, "TTLSeconds", &a.TimeToLive)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSRouterWorkerUpdatedEventData.
func (a ACSRouterWorkerUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelConfigurations", a.ChannelConfigurations)
	populate(objectMap, "labels", a.Labels)
	populate(objectMap, "queueAssignments", a.QueueAssignments)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "totalCapacity", a.TotalCapacity)
	populate(objectMap, "updatedWorkerProperties", a.UpdatedWorkerProperties)
	populate(objectMap, "workerId", a.WorkerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSRouterWorkerUpdatedEventData.
func (a *ACSRouterWorkerUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelConfigurations":
			err = unpopulate(val, "ChannelConfigurations", &a.ChannelConfigurations)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &a.Labels)
			delete(rawMsg, key)
		case "queueAssignments":
			err = unpopulate(val, "QueueAssignments", &a.QueueAssignments)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "totalCapacity":
			err = unpopulate(val, "TotalCapacity", &a.TotalCapacity)
			delete(rawMsg, key)
		case "updatedWorkerProperties":
			err = unpopulate(val, "UpdatedWorkerProperties", &a.UpdatedWorkerProperties)
			delete(rawMsg, key)
		case "workerId":
			err = unpopulate(val, "WorkerID", &a.WorkerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSSmsDeliveryAttemptProperties.
func (a ACSSmsDeliveryAttemptProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "segmentsFailed", a.SegmentsFailed)
	populate(objectMap, "segmentsSucceeded", a.SegmentsSucceeded)
	populateDateTimeRFC3339(objectMap, "timestamp", a.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSSmsDeliveryAttemptProperties.
func (a *ACSSmsDeliveryAttemptProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "segmentsFailed":
			err = unpopulate(val, "SegmentsFailed", &a.SegmentsFailed)
			delete(rawMsg, key)
		case "segmentsSucceeded":
			err = unpopulate(val, "SegmentsSucceeded", &a.SegmentsSucceeded)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &a.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSSmsDeliveryReportReceivedEventData.
func (a ACSSmsDeliveryReportReceivedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deliveryAttempts", a.DeliveryAttempts)
	populate(objectMap, "deliveryStatus", a.DeliveryStatus)
	populate(objectMap, "deliveryStatusDetails", a.DeliveryStatusDetails)
	populate(objectMap, "from", a.From)
	populate(objectMap, "messageId", a.MessageID)
	populateDateTimeRFC3339(objectMap, "receivedTimestamp", a.ReceivedTimestamp)
	populate(objectMap, "tag", a.Tag)
	populate(objectMap, "to", a.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSSmsDeliveryReportReceivedEventData.
func (a *ACSSmsDeliveryReportReceivedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deliveryAttempts":
			err = unpopulate(val, "DeliveryAttempts", &a.DeliveryAttempts)
			delete(rawMsg, key)
		case "deliveryStatus":
			err = unpopulate(val, "DeliveryStatus", &a.DeliveryStatus)
			delete(rawMsg, key)
		case "deliveryStatusDetails":
			err = unpopulate(val, "DeliveryStatusDetails", &a.DeliveryStatusDetails)
			delete(rawMsg, key)
		case "from":
			err = unpopulate(val, "From", &a.From)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "receivedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "ReceivedTimestamp", &a.ReceivedTimestamp)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &a.Tag)
			delete(rawMsg, key)
		case "to":
			err = unpopulate(val, "To", &a.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSSmsEventBaseProperties.
func (a ACSSmsEventBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "from", a.From)
	populate(objectMap, "messageId", a.MessageID)
	populate(objectMap, "to", a.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSSmsEventBaseProperties.
func (a *ACSSmsEventBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "from":
			err = unpopulate(val, "From", &a.From)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "to":
			err = unpopulate(val, "To", &a.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSSmsReceivedEventData.
func (a ACSSmsReceivedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "from", a.From)
	populate(objectMap, "message", a.Message)
	populate(objectMap, "messageId", a.MessageID)
	populateDateTimeRFC3339(objectMap, "receivedTimestamp", a.ReceivedTimestamp)
	populate(objectMap, "to", a.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSSmsReceivedEventData.
func (a *ACSSmsReceivedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "from":
			err = unpopulate(val, "From", &a.From)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		case "messageId":
			err = unpopulate(val, "MessageID", &a.MessageID)
			delete(rawMsg, key)
		case "receivedTimestamp":
			err = unpopulateDateTimeRFC3339(val, "ReceivedTimestamp", &a.ReceivedTimestamp)
			delete(rawMsg, key)
		case "to":
			err = unpopulate(val, "To", &a.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ACSUserDisconnectedEventData.
func (a ACSUserDisconnectedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "userCommunicationIdentifier", a.UserCommunicationIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ACSUserDisconnectedEventData.
func (a *ACSUserDisconnectedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "userCommunicationIdentifier":
			err = unpopulate(val, "UserCommunicationIdentifier", &a.UserCommunicationIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppConfigurationKeyValueDeletedEventData.
func (a AppConfigurationKeyValueDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "key", a.Key)
	populate(objectMap, "label", a.Label)
	populate(objectMap, "syncToken", a.SyncToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppConfigurationKeyValueDeletedEventData.
func (a *AppConfigurationKeyValueDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &a.Key)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &a.Label)
			delete(rawMsg, key)
		case "syncToken":
			err = unpopulate(val, "SyncToken", &a.SyncToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppConfigurationKeyValueModifiedEventData.
func (a AppConfigurationKeyValueModifiedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "key", a.Key)
	populate(objectMap, "label", a.Label)
	populate(objectMap, "syncToken", a.SyncToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppConfigurationKeyValueModifiedEventData.
func (a *AppConfigurationKeyValueModifiedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &a.Key)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &a.Label)
			delete(rawMsg, key)
		case "syncToken":
			err = unpopulate(val, "SyncToken", &a.SyncToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppConfigurationSnapshotCreatedEventData.
func (a AppConfigurationSnapshotCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "syncToken", a.SyncToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppConfigurationSnapshotCreatedEventData.
func (a *AppConfigurationSnapshotCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "syncToken":
			err = unpopulate(val, "SyncToken", &a.SyncToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppConfigurationSnapshotEventData.
func (a AppConfigurationSnapshotEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "syncToken", a.SyncToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppConfigurationSnapshotEventData.
func (a *AppConfigurationSnapshotEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "syncToken":
			err = unpopulate(val, "SyncToken", &a.SyncToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppConfigurationSnapshotModifiedEventData.
func (a AppConfigurationSnapshotModifiedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "syncToken", a.SyncToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppConfigurationSnapshotModifiedEventData.
func (a *AppConfigurationSnapshotModifiedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "syncToken":
			err = unpopulate(val, "SyncToken", &a.SyncToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppEventTypeDetail.
func (a AppEventTypeDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", a.Action)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppEventTypeDetail.
func (a *AppEventTypeDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &a.Action)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppServicePlanEventTypeDetail.
func (a AppServicePlanEventTypeDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", a.Action)
	populate(objectMap, "stampKind", a.StampKind)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppServicePlanEventTypeDetail.
func (a *AppServicePlanEventTypeDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &a.Action)
			delete(rawMsg, key)
		case "stampKind":
			err = unpopulate(val, "StampKind", &a.StampKind)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AVSClusterCreatedEventData.
func (a AVSClusterCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addedHostNames", a.AddedHostNames)
	populate(objectMap, "inMaintenanceHostNames", a.InMaintenanceHostNames)
	populate(objectMap, "operationId", a.OperationID)
	populate(objectMap, "removedHostNames", a.RemovedHostNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AVSClusterCreatedEventData.
func (a *AVSClusterCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addedHostNames":
			err = unpopulate(val, "AddedHostNames", &a.AddedHostNames)
			delete(rawMsg, key)
		case "inMaintenanceHostNames":
			err = unpopulate(val, "InMaintenanceHostNames", &a.InMaintenanceHostNames)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		case "removedHostNames":
			err = unpopulate(val, "RemovedHostNames", &a.RemovedHostNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AVSClusterDeletedEventData.
func (a AVSClusterDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addedHostNames", a.AddedHostNames)
	populate(objectMap, "inMaintenanceHostNames", a.InMaintenanceHostNames)
	populate(objectMap, "operationId", a.OperationID)
	populate(objectMap, "removedHostNames", a.RemovedHostNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AVSClusterDeletedEventData.
func (a *AVSClusterDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addedHostNames":
			err = unpopulate(val, "AddedHostNames", &a.AddedHostNames)
			delete(rawMsg, key)
		case "inMaintenanceHostNames":
			err = unpopulate(val, "InMaintenanceHostNames", &a.InMaintenanceHostNames)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		case "removedHostNames":
			err = unpopulate(val, "RemovedHostNames", &a.RemovedHostNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AVSClusterFailedEventData.
func (a AVSClusterFailedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addedHostNames", a.AddedHostNames)
	populate(objectMap, "failureMessage", a.FailureMessage)
	populate(objectMap, "inMaintenanceHostNames", a.InMaintenanceHostNames)
	populate(objectMap, "operationId", a.OperationID)
	populate(objectMap, "removedHostNames", a.RemovedHostNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AVSClusterFailedEventData.
func (a *AVSClusterFailedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addedHostNames":
			err = unpopulate(val, "AddedHostNames", &a.AddedHostNames)
			delete(rawMsg, key)
		case "failureMessage":
			err = unpopulate(val, "FailureMessage", &a.FailureMessage)
			delete(rawMsg, key)
		case "inMaintenanceHostNames":
			err = unpopulate(val, "InMaintenanceHostNames", &a.InMaintenanceHostNames)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		case "removedHostNames":
			err = unpopulate(val, "RemovedHostNames", &a.RemovedHostNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AVSClusterUpdatedEventData.
func (a AVSClusterUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addedHostNames", a.AddedHostNames)
	populate(objectMap, "inMaintenanceHostNames", a.InMaintenanceHostNames)
	populate(objectMap, "operationId", a.OperationID)
	populate(objectMap, "removedHostNames", a.RemovedHostNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AVSClusterUpdatedEventData.
func (a *AVSClusterUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addedHostNames":
			err = unpopulate(val, "AddedHostNames", &a.AddedHostNames)
			delete(rawMsg, key)
		case "inMaintenanceHostNames":
			err = unpopulate(val, "InMaintenanceHostNames", &a.InMaintenanceHostNames)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		case "removedHostNames":
			err = unpopulate(val, "RemovedHostNames", &a.RemovedHostNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AVSClusterUpdatingEventData.
func (a AVSClusterUpdatingEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addedHostNames", a.AddedHostNames)
	populate(objectMap, "inMaintenanceHostNames", a.InMaintenanceHostNames)
	populate(objectMap, "operationId", a.OperationID)
	populate(objectMap, "removedHostNames", a.RemovedHostNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AVSClusterUpdatingEventData.
func (a *AVSClusterUpdatingEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addedHostNames":
			err = unpopulate(val, "AddedHostNames", &a.AddedHostNames)
			delete(rawMsg, key)
		case "inMaintenanceHostNames":
			err = unpopulate(val, "InMaintenanceHostNames", &a.InMaintenanceHostNames)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		case "removedHostNames":
			err = unpopulate(val, "RemovedHostNames", &a.RemovedHostNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AVSPrivateCloudFailedEventData.
func (a AVSPrivateCloudFailedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failureMessage", a.FailureMessage)
	populate(objectMap, "operationId", a.OperationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AVSPrivateCloudFailedEventData.
func (a *AVSPrivateCloudFailedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failureMessage":
			err = unpopulate(val, "FailureMessage", &a.FailureMessage)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AVSPrivateCloudUpdatedEventData.
func (a AVSPrivateCloudUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationId", a.OperationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AVSPrivateCloudUpdatedEventData.
func (a *AVSPrivateCloudUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AVSPrivateCloudUpdatingEventData.
func (a AVSPrivateCloudUpdatingEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationId", a.OperationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AVSPrivateCloudUpdatingEventData.
func (a *AVSPrivateCloudUpdatingEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AVSScriptExecutionCancelledEventData.
func (a AVSScriptExecutionCancelledEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cmdletId", a.CmdletID)
	populate(objectMap, "operationId", a.OperationID)
	populate(objectMap, "output", a.Output)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AVSScriptExecutionCancelledEventData.
func (a *AVSScriptExecutionCancelledEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cmdletId":
			err = unpopulate(val, "CmdletID", &a.CmdletID)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &a.Output)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AVSScriptExecutionFailedEventData.
func (a AVSScriptExecutionFailedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cmdletId", a.CmdletID)
	populate(objectMap, "failureMessage", a.FailureMessage)
	populate(objectMap, "operationId", a.OperationID)
	populate(objectMap, "output", a.Output)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AVSScriptExecutionFailedEventData.
func (a *AVSScriptExecutionFailedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cmdletId":
			err = unpopulate(val, "CmdletID", &a.CmdletID)
			delete(rawMsg, key)
		case "failureMessage":
			err = unpopulate(val, "FailureMessage", &a.FailureMessage)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &a.Output)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AVSScriptExecutionFinishedEventData.
func (a AVSScriptExecutionFinishedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cmdletId", a.CmdletID)
	populate(objectMap, "namedOutputs", a.NamedOutputs)
	populate(objectMap, "operationId", a.OperationID)
	populate(objectMap, "output", a.Output)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AVSScriptExecutionFinishedEventData.
func (a *AVSScriptExecutionFinishedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cmdletId":
			err = unpopulate(val, "CmdletID", &a.CmdletID)
			delete(rawMsg, key)
		case "namedOutputs":
			err = unpopulate(val, "NamedOutputs", &a.NamedOutputs)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &a.Output)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AVSScriptExecutionStartedEventData.
func (a AVSScriptExecutionStartedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cmdletId", a.CmdletID)
	populate(objectMap, "operationId", a.OperationID)
	populate(objectMap, "output", a.Output)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AVSScriptExecutionStartedEventData.
func (a *AVSScriptExecutionStartedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cmdletId":
			err = unpopulate(val, "CmdletID", &a.CmdletID)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &a.Output)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunicationIdentifierModel.
func (c CommunicationIdentifierModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "communicationUser", c.CommunicationUser)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "microsoftTeamsApp", c.MicrosoftTeamsApp)
	populate(objectMap, "microsoftTeamsUser", c.MicrosoftTeamsUser)
	populate(objectMap, "phoneNumber", c.PhoneNumber)
	populate(objectMap, "rawId", c.RawID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunicationIdentifierModel.
func (c *CommunicationIdentifierModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "communicationUser":
			err = unpopulate(val, "CommunicationUser", &c.CommunicationUser)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "microsoftTeamsApp":
			err = unpopulate(val, "MicrosoftTeamsApp", &c.MicrosoftTeamsApp)
			delete(rawMsg, key)
		case "microsoftTeamsUser":
			err = unpopulate(val, "MicrosoftTeamsUser", &c.MicrosoftTeamsUser)
			delete(rawMsg, key)
		case "phoneNumber":
			err = unpopulate(val, "PhoneNumber", &c.PhoneNumber)
			delete(rawMsg, key)
		case "rawId":
			err = unpopulate(val, "RawID", &c.RawID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommunicationUserIdentifierModel.
func (c CommunicationUserIdentifierModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommunicationUserIdentifierModel.
func (c *CommunicationUserIdentifierModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryArtifactEventData.
func (c ContainerRegistryArtifactEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", c.Action)
	populate(objectMap, "connectedRegistry", c.ConnectedRegistry)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "target", c.Target)
	populateDateTimeRFC3339(objectMap, "timestamp", c.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryArtifactEventData.
func (c *ContainerRegistryArtifactEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &c.Action)
			delete(rawMsg, key)
		case "connectedRegistry":
			err = unpopulate(val, "ConnectedRegistry", &c.ConnectedRegistry)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &c.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryArtifactEventTarget.
func (c ContainerRegistryArtifactEventTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "digest", c.Digest)
	populate(objectMap, "mediaType", c.MediaType)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "repository", c.Repository)
	populate(objectMap, "size", c.Size)
	populate(objectMap, "tag", c.Tag)
	populate(objectMap, "version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryArtifactEventTarget.
func (c *ContainerRegistryArtifactEventTarget) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "digest":
			err = unpopulate(val, "Digest", &c.Digest)
			delete(rawMsg, key)
		case "mediaType":
			err = unpopulate(val, "MediaType", &c.MediaType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "repository":
			err = unpopulate(val, "Repository", &c.Repository)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &c.Size)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &c.Tag)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryChartDeletedEventData.
func (c ContainerRegistryChartDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", c.Action)
	populate(objectMap, "connectedRegistry", c.ConnectedRegistry)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "target", c.Target)
	populateDateTimeRFC3339(objectMap, "timestamp", c.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryChartDeletedEventData.
func (c *ContainerRegistryChartDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &c.Action)
			delete(rawMsg, key)
		case "connectedRegistry":
			err = unpopulate(val, "ConnectedRegistry", &c.ConnectedRegistry)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &c.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryChartPushedEventData.
func (c ContainerRegistryChartPushedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", c.Action)
	populate(objectMap, "connectedRegistry", c.ConnectedRegistry)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "target", c.Target)
	populateDateTimeRFC3339(objectMap, "timestamp", c.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryChartPushedEventData.
func (c *ContainerRegistryChartPushedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &c.Action)
			delete(rawMsg, key)
		case "connectedRegistry":
			err = unpopulate(val, "ConnectedRegistry", &c.ConnectedRegistry)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &c.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryEventActor.
func (c ContainerRegistryEventActor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryEventActor.
func (c *ContainerRegistryEventActor) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryEventConnectedRegistry.
func (c ContainerRegistryEventConnectedRegistry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryEventConnectedRegistry.
func (c *ContainerRegistryEventConnectedRegistry) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryEventData.
func (c ContainerRegistryEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", c.Action)
	populate(objectMap, "actor", c.Actor)
	populate(objectMap, "connectedRegistry", c.ConnectedRegistry)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "request", c.Request)
	populate(objectMap, "source", c.Source)
	populate(objectMap, "target", c.Target)
	populateDateTimeRFC3339(objectMap, "timestamp", c.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryEventData.
func (c *ContainerRegistryEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &c.Action)
			delete(rawMsg, key)
		case "actor":
			err = unpopulate(val, "Actor", &c.Actor)
			delete(rawMsg, key)
		case "connectedRegistry":
			err = unpopulate(val, "ConnectedRegistry", &c.ConnectedRegistry)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, "Request", &c.Request)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &c.Source)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &c.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryEventRequest.
func (c ContainerRegistryEventRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addr", c.Addr)
	populate(objectMap, "host", c.Host)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "method", c.Method)
	populate(objectMap, "useragent", c.Useragent)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryEventRequest.
func (c *ContainerRegistryEventRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addr":
			err = unpopulate(val, "Addr", &c.Addr)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &c.Host)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &c.Method)
			delete(rawMsg, key)
		case "useragent":
			err = unpopulate(val, "Useragent", &c.Useragent)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryEventSource.
func (c ContainerRegistryEventSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addr", c.Addr)
	populate(objectMap, "instanceID", c.InstanceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryEventSource.
func (c *ContainerRegistryEventSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addr":
			err = unpopulate(val, "Addr", &c.Addr)
			delete(rawMsg, key)
		case "instanceID":
			err = unpopulate(val, "InstanceID", &c.InstanceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryEventTarget.
func (c ContainerRegistryEventTarget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "digest", c.Digest)
	populate(objectMap, "length", c.Length)
	populate(objectMap, "mediaType", c.MediaType)
	populate(objectMap, "repository", c.Repository)
	populate(objectMap, "size", c.Size)
	populate(objectMap, "tag", c.Tag)
	populate(objectMap, "url", c.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryEventTarget.
func (c *ContainerRegistryEventTarget) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "digest":
			err = unpopulate(val, "Digest", &c.Digest)
			delete(rawMsg, key)
		case "length":
			err = unpopulate(val, "Length", &c.Length)
			delete(rawMsg, key)
		case "mediaType":
			err = unpopulate(val, "MediaType", &c.MediaType)
			delete(rawMsg, key)
		case "repository":
			err = unpopulate(val, "Repository", &c.Repository)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &c.Size)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &c.Tag)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &c.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryImageDeletedEventData.
func (c ContainerRegistryImageDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", c.Action)
	populate(objectMap, "actor", c.Actor)
	populate(objectMap, "connectedRegistry", c.ConnectedRegistry)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "request", c.Request)
	populate(objectMap, "source", c.Source)
	populate(objectMap, "target", c.Target)
	populateDateTimeRFC3339(objectMap, "timestamp", c.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryImageDeletedEventData.
func (c *ContainerRegistryImageDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &c.Action)
			delete(rawMsg, key)
		case "actor":
			err = unpopulate(val, "Actor", &c.Actor)
			delete(rawMsg, key)
		case "connectedRegistry":
			err = unpopulate(val, "ConnectedRegistry", &c.ConnectedRegistry)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, "Request", &c.Request)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &c.Source)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &c.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerRegistryImagePushedEventData.
func (c ContainerRegistryImagePushedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", c.Action)
	populate(objectMap, "actor", c.Actor)
	populate(objectMap, "connectedRegistry", c.ConnectedRegistry)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "request", c.Request)
	populate(objectMap, "source", c.Source)
	populate(objectMap, "target", c.Target)
	populateDateTimeRFC3339(objectMap, "timestamp", c.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerRegistryImagePushedEventData.
func (c *ContainerRegistryImagePushedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &c.Action)
			delete(rawMsg, key)
		case "actor":
			err = unpopulate(val, "Actor", &c.Actor)
			delete(rawMsg, key)
		case "connectedRegistry":
			err = unpopulate(val, "ConnectedRegistry", &c.ConnectedRegistry)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, "Request", &c.Request)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &c.Source)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &c.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerServiceClusterSupportEndedEventData.
func (c ContainerServiceClusterSupportEndedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kubernetesVersion", c.KubernetesVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerServiceClusterSupportEndedEventData.
func (c *ContainerServiceClusterSupportEndedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &c.KubernetesVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerServiceClusterSupportEndingEventData.
func (c ContainerServiceClusterSupportEndingEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kubernetesVersion", c.KubernetesVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerServiceClusterSupportEndingEventData.
func (c *ContainerServiceClusterSupportEndingEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &c.KubernetesVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerServiceClusterSupportEventData.
func (c ContainerServiceClusterSupportEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kubernetesVersion", c.KubernetesVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerServiceClusterSupportEventData.
func (c *ContainerServiceClusterSupportEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &c.KubernetesVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerServiceNewKubernetesVersionAvailableEventData.
func (c ContainerServiceNewKubernetesVersionAvailableEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "latestPreviewKubernetesVersion", c.LatestPreviewKubernetesVersion)
	populate(objectMap, "latestStableKubernetesVersion", c.LatestStableKubernetesVersion)
	populate(objectMap, "latestSupportedKubernetesVersion", c.LatestSupportedKubernetesVersion)
	populate(objectMap, "lowestMinorKubernetesVersion", c.LowestMinorKubernetesVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerServiceNewKubernetesVersionAvailableEventData.
func (c *ContainerServiceNewKubernetesVersionAvailableEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "latestPreviewKubernetesVersion":
			err = unpopulate(val, "LatestPreviewKubernetesVersion", &c.LatestPreviewKubernetesVersion)
			delete(rawMsg, key)
		case "latestStableKubernetesVersion":
			err = unpopulate(val, "LatestStableKubernetesVersion", &c.LatestStableKubernetesVersion)
			delete(rawMsg, key)
		case "latestSupportedKubernetesVersion":
			err = unpopulate(val, "LatestSupportedKubernetesVersion", &c.LatestSupportedKubernetesVersion)
			delete(rawMsg, key)
		case "lowestMinorKubernetesVersion":
			err = unpopulate(val, "LowestMinorKubernetesVersion", &c.LowestMinorKubernetesVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerServiceNodePoolRollingEventData.
func (c ContainerServiceNodePoolRollingEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nodePoolName", c.NodePoolName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerServiceNodePoolRollingEventData.
func (c *ContainerServiceNodePoolRollingEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nodePoolName":
			err = unpopulate(val, "NodePoolName", &c.NodePoolName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerServiceNodePoolRollingFailedEventData.
func (c ContainerServiceNodePoolRollingFailedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nodePoolName", c.NodePoolName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerServiceNodePoolRollingFailedEventData.
func (c *ContainerServiceNodePoolRollingFailedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nodePoolName":
			err = unpopulate(val, "NodePoolName", &c.NodePoolName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerServiceNodePoolRollingStartedEventData.
func (c ContainerServiceNodePoolRollingStartedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nodePoolName", c.NodePoolName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerServiceNodePoolRollingStartedEventData.
func (c *ContainerServiceNodePoolRollingStartedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nodePoolName":
			err = unpopulate(val, "NodePoolName", &c.NodePoolName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerServiceNodePoolRollingSucceededEventData.
func (c ContainerServiceNodePoolRollingSucceededEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nodePoolName", c.NodePoolName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerServiceNodePoolRollingSucceededEventData.
func (c *ContainerServiceNodePoolRollingSucceededEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nodePoolName":
			err = unpopulate(val, "NodePoolName", &c.NodePoolName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataBoxCopyCompletedEventData.
func (d DataBoxCopyCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serialNumber", d.SerialNumber)
	populate(objectMap, "stageName", d.StageName)
	populateDateTimeRFC3339(objectMap, "stageTime", d.StageTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataBoxCopyCompletedEventData.
func (d *DataBoxCopyCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &d.SerialNumber)
			delete(rawMsg, key)
		case "stageName":
			err = unpopulate(val, "StageName", &d.StageName)
			delete(rawMsg, key)
		case "stageTime":
			err = unpopulateDateTimeRFC3339(val, "StageTime", &d.StageTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataBoxCopyStartedEventData.
func (d DataBoxCopyStartedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serialNumber", d.SerialNumber)
	populate(objectMap, "stageName", d.StageName)
	populateDateTimeRFC3339(objectMap, "stageTime", d.StageTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataBoxCopyStartedEventData.
func (d *DataBoxCopyStartedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &d.SerialNumber)
			delete(rawMsg, key)
		case "stageName":
			err = unpopulate(val, "StageName", &d.StageName)
			delete(rawMsg, key)
		case "stageTime":
			err = unpopulateDateTimeRFC3339(val, "StageTime", &d.StageTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataBoxOrderCompletedEventData.
func (d DataBoxOrderCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serialNumber", d.SerialNumber)
	populate(objectMap, "stageName", d.StageName)
	populateDateTimeRFC3339(objectMap, "stageTime", d.StageTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataBoxOrderCompletedEventData.
func (d *DataBoxOrderCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &d.SerialNumber)
			delete(rawMsg, key)
		case "stageName":
			err = unpopulate(val, "StageName", &d.StageName)
			delete(rawMsg, key)
		case "stageTime":
			err = unpopulateDateTimeRFC3339(val, "StageTime", &d.StageTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceConnectionStateEventInfo.
func (d DeviceConnectionStateEventInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sequenceNumber", d.SequenceNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceConnectionStateEventInfo.
func (d *DeviceConnectionStateEventInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sequenceNumber":
			err = unpopulate(val, "SequenceNumber", &d.SequenceNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceConnectionStateEventProperties.
func (d DeviceConnectionStateEventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceConnectionStateEventInfo", d.DeviceConnectionStateEventInfo)
	populate(objectMap, "deviceId", d.DeviceID)
	populate(objectMap, "hubName", d.HubName)
	populate(objectMap, "moduleId", d.ModuleID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceConnectionStateEventProperties.
func (d *DeviceConnectionStateEventProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceConnectionStateEventInfo":
			err = unpopulate(val, "DeviceConnectionStateEventInfo", &d.DeviceConnectionStateEventInfo)
			delete(rawMsg, key)
		case "deviceId":
			err = unpopulate(val, "DeviceID", &d.DeviceID)
			delete(rawMsg, key)
		case "hubName":
			err = unpopulate(val, "HubName", &d.HubName)
			delete(rawMsg, key)
		case "moduleId":
			err = unpopulate(val, "ModuleID", &d.ModuleID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceLifeCycleEventProperties.
func (d DeviceLifeCycleEventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceId", d.DeviceID)
	populate(objectMap, "hubName", d.HubName)
	populate(objectMap, "twin", d.Twin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceLifeCycleEventProperties.
func (d *DeviceLifeCycleEventProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceId":
			err = unpopulate(val, "DeviceID", &d.DeviceID)
			delete(rawMsg, key)
		case "hubName":
			err = unpopulate(val, "HubName", &d.HubName)
			delete(rawMsg, key)
		case "twin":
			err = unpopulate(val, "Twin", &d.Twin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceTelemetryEventProperties.
func (d DeviceTelemetryEventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "body", d.Body)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemProperties", d.SystemProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceTelemetryEventProperties.
func (d *DeviceTelemetryEventProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "body":
			err = unpopulate(val, "Body", &d.Body)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemProperties":
			err = unpopulate(val, "SystemProperties", &d.SystemProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceTwinInfo.
func (d DeviceTwinInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationType", d.AuthenticationType)
	populate(objectMap, "cloudToDeviceMessageCount", d.CloudToDeviceMessageCount)
	populate(objectMap, "connectionState", d.ConnectionState)
	populate(objectMap, "deviceId", d.DeviceID)
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "lastActivityTime", d.LastActivityTime)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "status", d.Status)
	populate(objectMap, "statusUpdateTime", d.StatusUpdateTime)
	populate(objectMap, "version", d.Version)
	populate(objectMap, "x509Thumbprint", d.X509Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceTwinInfo.
func (d *DeviceTwinInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &d.AuthenticationType)
			delete(rawMsg, key)
		case "cloudToDeviceMessageCount":
			err = unpopulate(val, "CloudToDeviceMessageCount", &d.CloudToDeviceMessageCount)
			delete(rawMsg, key)
		case "connectionState":
			err = unpopulate(val, "ConnectionState", &d.ConnectionState)
			delete(rawMsg, key)
		case "deviceId":
			err = unpopulate(val, "DeviceID", &d.DeviceID)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "lastActivityTime":
			err = unpopulate(val, "LastActivityTime", &d.LastActivityTime)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		case "statusUpdateTime":
			err = unpopulate(val, "StatusUpdateTime", &d.StatusUpdateTime)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &d.Version)
			delete(rawMsg, key)
		case "x509Thumbprint":
			err = unpopulate(val, "X509Thumbprint", &d.X509Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceTwinInfoProperties.
func (d DeviceTwinInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "desired", d.Desired)
	populate(objectMap, "reported", d.Reported)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceTwinInfoProperties.
func (d *DeviceTwinInfoProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "desired":
			err = unpopulate(val, "Desired", &d.Desired)
			delete(rawMsg, key)
		case "reported":
			err = unpopulate(val, "Reported", &d.Reported)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceTwinInfoX509Thumbprint.
func (d DeviceTwinInfoX509Thumbprint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primaryThumbprint", d.PrimaryThumbprint)
	populate(objectMap, "secondaryThumbprint", d.SecondaryThumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceTwinInfoX509Thumbprint.
func (d *DeviceTwinInfoX509Thumbprint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primaryThumbprint":
			err = unpopulate(val, "PrimaryThumbprint", &d.PrimaryThumbprint)
			delete(rawMsg, key)
		case "secondaryThumbprint":
			err = unpopulate(val, "SecondaryThumbprint", &d.SecondaryThumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceTwinMetadata.
func (d DeviceTwinMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "lastUpdated", d.LastUpdated)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceTwinMetadata.
func (d *DeviceTwinMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastUpdated":
			err = unpopulate(val, "LastUpdated", &d.LastUpdated)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceTwinProperties.
func (d DeviceTwinProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metadata", d.Metadata)
	populate(objectMap, "version", d.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceTwinProperties.
func (d *DeviceTwinProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metadata":
			err = unpopulate(val, "Metadata", &d.Metadata)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &d.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventGridEvent.
func (e EventGridEvent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "data", e.Data)
	populate(objectMap, "dataVersion", e.DataVersion)
	populateDateTimeRFC3339(objectMap, "eventTime", e.EventTime)
	populate(objectMap, "eventType", e.EventType)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "metadataVersion", e.MetadataVersion)
	populate(objectMap, "subject", e.Subject)
	populate(objectMap, "topic", e.Topic)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventGridEvent.
func (e *EventGridEvent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			e.Data = []byte(val)
			delete(rawMsg, key)
		case "dataVersion":
			err = unpopulate(val, "DataVersion", &e.DataVersion)
			delete(rawMsg, key)
		case "eventTime":
			err = unpopulateDateTimeRFC3339(val, "EventTime", &e.EventTime)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &e.EventType)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "metadataVersion":
			err = unpopulate(val, "MetadataVersion", &e.MetadataVersion)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &e.Subject)
			delete(rawMsg, key)
		case "topic":
			err = unpopulate(val, "Topic", &e.Topic)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventGridMQTTClientCreatedOrUpdatedEventData.
func (e EventGridMQTTClientCreatedOrUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", e.Attributes)
	populate(objectMap, "clientAuthenticationName", e.ClientAuthenticationName)
	populate(objectMap, "clientName", e.ClientName)
	populateDateTimeRFC3339(objectMap, "createdOn", e.CreatedOn)
	populate(objectMap, "namespaceName", e.NamespaceName)
	populate(objectMap, "state", e.State)
	populateDateTimeRFC3339(objectMap, "updatedOn", e.UpdatedOn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventGridMQTTClientCreatedOrUpdatedEventData.
func (e *EventGridMQTTClientCreatedOrUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &e.Attributes)
			delete(rawMsg, key)
		case "clientAuthenticationName":
			err = unpopulate(val, "ClientAuthenticationName", &e.ClientAuthenticationName)
			delete(rawMsg, key)
		case "clientName":
			err = unpopulate(val, "ClientName", &e.ClientName)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &e.CreatedOn)
			delete(rawMsg, key)
		case "namespaceName":
			err = unpopulate(val, "NamespaceName", &e.NamespaceName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		case "updatedOn":
			err = unpopulateDateTimeRFC3339(val, "UpdatedOn", &e.UpdatedOn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventGridMQTTClientDeletedEventData.
func (e EventGridMQTTClientDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientAuthenticationName", e.ClientAuthenticationName)
	populate(objectMap, "clientName", e.ClientName)
	populate(objectMap, "namespaceName", e.NamespaceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventGridMQTTClientDeletedEventData.
func (e *EventGridMQTTClientDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientAuthenticationName":
			err = unpopulate(val, "ClientAuthenticationName", &e.ClientAuthenticationName)
			delete(rawMsg, key)
		case "clientName":
			err = unpopulate(val, "ClientName", &e.ClientName)
			delete(rawMsg, key)
		case "namespaceName":
			err = unpopulate(val, "NamespaceName", &e.NamespaceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventGridMQTTClientEventData.
func (e EventGridMQTTClientEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientAuthenticationName", e.ClientAuthenticationName)
	populate(objectMap, "clientName", e.ClientName)
	populate(objectMap, "namespaceName", e.NamespaceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventGridMQTTClientEventData.
func (e *EventGridMQTTClientEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientAuthenticationName":
			err = unpopulate(val, "ClientAuthenticationName", &e.ClientAuthenticationName)
			delete(rawMsg, key)
		case "clientName":
			err = unpopulate(val, "ClientName", &e.ClientName)
			delete(rawMsg, key)
		case "namespaceName":
			err = unpopulate(val, "NamespaceName", &e.NamespaceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventGridMQTTClientSessionConnectedEventData.
func (e EventGridMQTTClientSessionConnectedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientAuthenticationName", e.ClientAuthenticationName)
	populate(objectMap, "clientName", e.ClientName)
	populate(objectMap, "clientSessionName", e.ClientSessionName)
	populate(objectMap, "namespaceName", e.NamespaceName)
	populate(objectMap, "sequenceNumber", e.SequenceNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventGridMQTTClientSessionConnectedEventData.
func (e *EventGridMQTTClientSessionConnectedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientAuthenticationName":
			err = unpopulate(val, "ClientAuthenticationName", &e.ClientAuthenticationName)
			delete(rawMsg, key)
		case "clientName":
			err = unpopulate(val, "ClientName", &e.ClientName)
			delete(rawMsg, key)
		case "clientSessionName":
			err = unpopulate(val, "ClientSessionName", &e.ClientSessionName)
			delete(rawMsg, key)
		case "namespaceName":
			err = unpopulate(val, "NamespaceName", &e.NamespaceName)
			delete(rawMsg, key)
		case "sequenceNumber":
			err = unpopulate(val, "SequenceNumber", &e.SequenceNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventGridMQTTClientSessionDisconnectedEventData.
func (e EventGridMQTTClientSessionDisconnectedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientAuthenticationName", e.ClientAuthenticationName)
	populate(objectMap, "clientName", e.ClientName)
	populate(objectMap, "clientSessionName", e.ClientSessionName)
	populate(objectMap, "disconnectionReason", e.DisconnectionReason)
	populate(objectMap, "namespaceName", e.NamespaceName)
	populate(objectMap, "sequenceNumber", e.SequenceNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventGridMQTTClientSessionDisconnectedEventData.
func (e *EventGridMQTTClientSessionDisconnectedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientAuthenticationName":
			err = unpopulate(val, "ClientAuthenticationName", &e.ClientAuthenticationName)
			delete(rawMsg, key)
		case "clientName":
			err = unpopulate(val, "ClientName", &e.ClientName)
			delete(rawMsg, key)
		case "clientSessionName":
			err = unpopulate(val, "ClientSessionName", &e.ClientSessionName)
			delete(rawMsg, key)
		case "disconnectionReason":
			err = unpopulate(val, "DisconnectionReason", &e.DisconnectionReason)
			delete(rawMsg, key)
		case "namespaceName":
			err = unpopulate(val, "NamespaceName", &e.NamespaceName)
			delete(rawMsg, key)
		case "sequenceNumber":
			err = unpopulate(val, "SequenceNumber", &e.SequenceNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubCaptureFileCreatedEventData.
func (e EventHubCaptureFileCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eventCount", e.EventCount)
	populate(objectMap, "fileType", e.FileType)
	populate(objectMap, "fileUrl", e.Fileurl)
	populateDateTimeRFC3339(objectMap, "firstEnqueueTime", e.FirstEnqueueTime)
	populate(objectMap, "firstSequenceNumber", e.FirstSequenceNumber)
	populateDateTimeRFC3339(objectMap, "lastEnqueueTime", e.LastEnqueueTime)
	populate(objectMap, "lastSequenceNumber", e.LastSequenceNumber)
	populate(objectMap, "partitionId", e.PartitionID)
	populate(objectMap, "sizeInBytes", e.SizeInBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubCaptureFileCreatedEventData.
func (e *EventHubCaptureFileCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eventCount":
			err = unpopulate(val, "EventCount", &e.EventCount)
			delete(rawMsg, key)
		case "fileType":
			err = unpopulate(val, "FileType", &e.FileType)
			delete(rawMsg, key)
		case "fileUrl":
			err = unpopulate(val, "Fileurl", &e.Fileurl)
			delete(rawMsg, key)
		case "firstEnqueueTime":
			err = unpopulateDateTimeRFC3339(val, "FirstEnqueueTime", &e.FirstEnqueueTime)
			delete(rawMsg, key)
		case "firstSequenceNumber":
			err = unpopulate(val, "FirstSequenceNumber", &e.FirstSequenceNumber)
			delete(rawMsg, key)
		case "lastEnqueueTime":
			err = unpopulateDateTimeRFC3339(val, "LastEnqueueTime", &e.LastEnqueueTime)
			delete(rawMsg, key)
		case "lastSequenceNumber":
			err = unpopulate(val, "LastSequenceNumber", &e.LastSequenceNumber)
			delete(rawMsg, key)
		case "partitionId":
			err = unpopulate(val, "PartitionID", &e.PartitionID)
			delete(rawMsg, key)
		case "sizeInBytes":
			err = unpopulate(val, "SizeInBytes", &e.SizeInBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthcareDicomImageCreatedEventData.
func (h HealthcareDicomImageCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "imageSeriesInstanceUid", h.ImageSeriesInstanceUID)
	populate(objectMap, "imageSopInstanceUid", h.ImageSopInstanceUID)
	populate(objectMap, "imageStudyInstanceUid", h.ImageStudyInstanceUID)
	populate(objectMap, "partitionName", h.PartitionName)
	populate(objectMap, "sequenceNumber", h.SequenceNumber)
	populate(objectMap, "serviceHostName", h.ServiceHostName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthcareDicomImageCreatedEventData.
func (h *HealthcareDicomImageCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "imageSeriesInstanceUid":
			err = unpopulate(val, "ImageSeriesInstanceUID", &h.ImageSeriesInstanceUID)
			delete(rawMsg, key)
		case "imageSopInstanceUid":
			err = unpopulate(val, "ImageSopInstanceUID", &h.ImageSopInstanceUID)
			delete(rawMsg, key)
		case "imageStudyInstanceUid":
			err = unpopulate(val, "ImageStudyInstanceUID", &h.ImageStudyInstanceUID)
			delete(rawMsg, key)
		case "partitionName":
			err = unpopulate(val, "PartitionName", &h.PartitionName)
			delete(rawMsg, key)
		case "sequenceNumber":
			err = unpopulate(val, "SequenceNumber", &h.SequenceNumber)
			delete(rawMsg, key)
		case "serviceHostName":
			err = unpopulate(val, "ServiceHostName", &h.ServiceHostName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthcareDicomImageDeletedEventData.
func (h HealthcareDicomImageDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "imageSeriesInstanceUid", h.ImageSeriesInstanceUID)
	populate(objectMap, "imageSopInstanceUid", h.ImageSopInstanceUID)
	populate(objectMap, "imageStudyInstanceUid", h.ImageStudyInstanceUID)
	populate(objectMap, "partitionName", h.PartitionName)
	populate(objectMap, "sequenceNumber", h.SequenceNumber)
	populate(objectMap, "serviceHostName", h.ServiceHostName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthcareDicomImageDeletedEventData.
func (h *HealthcareDicomImageDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "imageSeriesInstanceUid":
			err = unpopulate(val, "ImageSeriesInstanceUID", &h.ImageSeriesInstanceUID)
			delete(rawMsg, key)
		case "imageSopInstanceUid":
			err = unpopulate(val, "ImageSopInstanceUID", &h.ImageSopInstanceUID)
			delete(rawMsg, key)
		case "imageStudyInstanceUid":
			err = unpopulate(val, "ImageStudyInstanceUID", &h.ImageStudyInstanceUID)
			delete(rawMsg, key)
		case "partitionName":
			err = unpopulate(val, "PartitionName", &h.PartitionName)
			delete(rawMsg, key)
		case "sequenceNumber":
			err = unpopulate(val, "SequenceNumber", &h.SequenceNumber)
			delete(rawMsg, key)
		case "serviceHostName":
			err = unpopulate(val, "ServiceHostName", &h.ServiceHostName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthcareDicomImageUpdatedEventData.
func (h HealthcareDicomImageUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "imageSeriesInstanceUid", h.ImageSeriesInstanceUID)
	populate(objectMap, "imageSopInstanceUid", h.ImageSopInstanceUID)
	populate(objectMap, "imageStudyInstanceUid", h.ImageStudyInstanceUID)
	populate(objectMap, "partitionName", h.PartitionName)
	populate(objectMap, "sequenceNumber", h.SequenceNumber)
	populate(objectMap, "serviceHostName", h.ServiceHostName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthcareDicomImageUpdatedEventData.
func (h *HealthcareDicomImageUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "imageSeriesInstanceUid":
			err = unpopulate(val, "ImageSeriesInstanceUID", &h.ImageSeriesInstanceUID)
			delete(rawMsg, key)
		case "imageSopInstanceUid":
			err = unpopulate(val, "ImageSopInstanceUID", &h.ImageSopInstanceUID)
			delete(rawMsg, key)
		case "imageStudyInstanceUid":
			err = unpopulate(val, "ImageStudyInstanceUID", &h.ImageStudyInstanceUID)
			delete(rawMsg, key)
		case "partitionName":
			err = unpopulate(val, "PartitionName", &h.PartitionName)
			delete(rawMsg, key)
		case "sequenceNumber":
			err = unpopulate(val, "SequenceNumber", &h.SequenceNumber)
			delete(rawMsg, key)
		case "serviceHostName":
			err = unpopulate(val, "ServiceHostName", &h.ServiceHostName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthcareFhirResourceCreatedEventData.
func (h HealthcareFhirResourceCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceFhirId", h.FhirResourceID)
	populate(objectMap, "resourceType", h.FhirResourceType)
	populate(objectMap, "resourceVersionId", h.FhirResourceVersionID)
	populate(objectMap, "resourceFhirAccount", h.FhirServiceHostName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthcareFhirResourceCreatedEventData.
func (h *HealthcareFhirResourceCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceFhirId":
			err = unpopulate(val, "FhirResourceID", &h.FhirResourceID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "FhirResourceType", &h.FhirResourceType)
			delete(rawMsg, key)
		case "resourceVersionId":
			err = unpopulate(val, "FhirResourceVersionID", &h.FhirResourceVersionID)
			delete(rawMsg, key)
		case "resourceFhirAccount":
			err = unpopulate(val, "FhirServiceHostName", &h.FhirServiceHostName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthcareFhirResourceDeletedEventData.
func (h HealthcareFhirResourceDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceFhirId", h.FhirResourceID)
	populate(objectMap, "resourceType", h.FhirResourceType)
	populate(objectMap, "resourceVersionId", h.FhirResourceVersionID)
	populate(objectMap, "resourceFhirAccount", h.FhirServiceHostName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthcareFhirResourceDeletedEventData.
func (h *HealthcareFhirResourceDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceFhirId":
			err = unpopulate(val, "FhirResourceID", &h.FhirResourceID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "FhirResourceType", &h.FhirResourceType)
			delete(rawMsg, key)
		case "resourceVersionId":
			err = unpopulate(val, "FhirResourceVersionID", &h.FhirResourceVersionID)
			delete(rawMsg, key)
		case "resourceFhirAccount":
			err = unpopulate(val, "FhirServiceHostName", &h.FhirServiceHostName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthcareFhirResourceUpdatedEventData.
func (h HealthcareFhirResourceUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceFhirId", h.FhirResourceID)
	populate(objectMap, "resourceType", h.FhirResourceType)
	populate(objectMap, "resourceVersionId", h.FhirResourceVersionID)
	populate(objectMap, "resourceFhirAccount", h.FhirServiceHostName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthcareFhirResourceUpdatedEventData.
func (h *HealthcareFhirResourceUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceFhirId":
			err = unpopulate(val, "FhirResourceID", &h.FhirResourceID)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "FhirResourceType", &h.FhirResourceType)
			delete(rawMsg, key)
		case "resourceVersionId":
			err = unpopulate(val, "FhirResourceVersionID", &h.FhirResourceVersionID)
			delete(rawMsg, key)
		case "resourceFhirAccount":
			err = unpopulate(val, "FhirServiceHostName", &h.FhirServiceHostName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IOTHubDeviceConnectedEventData.
func (i IOTHubDeviceConnectedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceConnectionStateEventInfo", i.DeviceConnectionStateEventInfo)
	populate(objectMap, "deviceId", i.DeviceID)
	populate(objectMap, "hubName", i.HubName)
	populate(objectMap, "moduleId", i.ModuleID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IOTHubDeviceConnectedEventData.
func (i *IOTHubDeviceConnectedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceConnectionStateEventInfo":
			err = unpopulate(val, "DeviceConnectionStateEventInfo", &i.DeviceConnectionStateEventInfo)
			delete(rawMsg, key)
		case "deviceId":
			err = unpopulate(val, "DeviceID", &i.DeviceID)
			delete(rawMsg, key)
		case "hubName":
			err = unpopulate(val, "HubName", &i.HubName)
			delete(rawMsg, key)
		case "moduleId":
			err = unpopulate(val, "ModuleID", &i.ModuleID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IOTHubDeviceCreatedEventData.
func (i IOTHubDeviceCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceId", i.DeviceID)
	populate(objectMap, "hubName", i.HubName)
	populate(objectMap, "twin", i.Twin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IOTHubDeviceCreatedEventData.
func (i *IOTHubDeviceCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceId":
			err = unpopulate(val, "DeviceID", &i.DeviceID)
			delete(rawMsg, key)
		case "hubName":
			err = unpopulate(val, "HubName", &i.HubName)
			delete(rawMsg, key)
		case "twin":
			err = unpopulate(val, "Twin", &i.Twin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IOTHubDeviceDeletedEventData.
func (i IOTHubDeviceDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceId", i.DeviceID)
	populate(objectMap, "hubName", i.HubName)
	populate(objectMap, "twin", i.Twin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IOTHubDeviceDeletedEventData.
func (i *IOTHubDeviceDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceId":
			err = unpopulate(val, "DeviceID", &i.DeviceID)
			delete(rawMsg, key)
		case "hubName":
			err = unpopulate(val, "HubName", &i.HubName)
			delete(rawMsg, key)
		case "twin":
			err = unpopulate(val, "Twin", &i.Twin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IOTHubDeviceDisconnectedEventData.
func (i IOTHubDeviceDisconnectedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceConnectionStateEventInfo", i.DeviceConnectionStateEventInfo)
	populate(objectMap, "deviceId", i.DeviceID)
	populate(objectMap, "hubName", i.HubName)
	populate(objectMap, "moduleId", i.ModuleID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IOTHubDeviceDisconnectedEventData.
func (i *IOTHubDeviceDisconnectedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceConnectionStateEventInfo":
			err = unpopulate(val, "DeviceConnectionStateEventInfo", &i.DeviceConnectionStateEventInfo)
			delete(rawMsg, key)
		case "deviceId":
			err = unpopulate(val, "DeviceID", &i.DeviceID)
			delete(rawMsg, key)
		case "hubName":
			err = unpopulate(val, "HubName", &i.HubName)
			delete(rawMsg, key)
		case "moduleId":
			err = unpopulate(val, "ModuleID", &i.ModuleID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IOTHubDeviceTelemetryEventData.
func (i IOTHubDeviceTelemetryEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "body", i.Body)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemProperties", i.SystemProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IOTHubDeviceTelemetryEventData.
func (i *IOTHubDeviceTelemetryEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "body":
			err = unpopulate(val, "Body", &i.Body)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "systemProperties":
			err = unpopulate(val, "SystemProperties", &i.SystemProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultAccessPolicyChangedEventData.
func (k KeyVaultAccessPolicyChangedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "EXP", k.EXP)
	populate(objectMap, "Id", k.ID)
	populate(objectMap, "NBF", k.NBF)
	populate(objectMap, "ObjectName", k.ObjectName)
	populate(objectMap, "ObjectType", k.ObjectType)
	populate(objectMap, "VaultName", k.VaultName)
	populate(objectMap, "Version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultAccessPolicyChangedEventData.
func (k *KeyVaultAccessPolicyChangedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EXP":
			err = unpopulate(val, "EXP", &k.EXP)
			delete(rawMsg, key)
		case "Id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "NBF":
			err = unpopulate(val, "NBF", &k.NBF)
			delete(rawMsg, key)
		case "ObjectName":
			err = unpopulate(val, "ObjectName", &k.ObjectName)
			delete(rawMsg, key)
		case "ObjectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "VaultName":
			err = unpopulate(val, "VaultName", &k.VaultName)
			delete(rawMsg, key)
		case "Version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultCertificateExpiredEventData.
func (k KeyVaultCertificateExpiredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "EXP", k.EXP)
	populate(objectMap, "Id", k.ID)
	populate(objectMap, "NBF", k.NBF)
	populate(objectMap, "ObjectName", k.ObjectName)
	populate(objectMap, "ObjectType", k.ObjectType)
	populate(objectMap, "VaultName", k.VaultName)
	populate(objectMap, "Version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultCertificateExpiredEventData.
func (k *KeyVaultCertificateExpiredEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EXP":
			err = unpopulate(val, "EXP", &k.EXP)
			delete(rawMsg, key)
		case "Id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "NBF":
			err = unpopulate(val, "NBF", &k.NBF)
			delete(rawMsg, key)
		case "ObjectName":
			err = unpopulate(val, "ObjectName", &k.ObjectName)
			delete(rawMsg, key)
		case "ObjectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "VaultName":
			err = unpopulate(val, "VaultName", &k.VaultName)
			delete(rawMsg, key)
		case "Version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultCertificateNearExpiryEventData.
func (k KeyVaultCertificateNearExpiryEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "EXP", k.EXP)
	populate(objectMap, "Id", k.ID)
	populate(objectMap, "NBF", k.NBF)
	populate(objectMap, "ObjectName", k.ObjectName)
	populate(objectMap, "ObjectType", k.ObjectType)
	populate(objectMap, "VaultName", k.VaultName)
	populate(objectMap, "Version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultCertificateNearExpiryEventData.
func (k *KeyVaultCertificateNearExpiryEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EXP":
			err = unpopulate(val, "EXP", &k.EXP)
			delete(rawMsg, key)
		case "Id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "NBF":
			err = unpopulate(val, "NBF", &k.NBF)
			delete(rawMsg, key)
		case "ObjectName":
			err = unpopulate(val, "ObjectName", &k.ObjectName)
			delete(rawMsg, key)
		case "ObjectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "VaultName":
			err = unpopulate(val, "VaultName", &k.VaultName)
			delete(rawMsg, key)
		case "Version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultCertificateNewVersionCreatedEventData.
func (k KeyVaultCertificateNewVersionCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "EXP", k.EXP)
	populate(objectMap, "Id", k.ID)
	populate(objectMap, "NBF", k.NBF)
	populate(objectMap, "ObjectName", k.ObjectName)
	populate(objectMap, "ObjectType", k.ObjectType)
	populate(objectMap, "VaultName", k.VaultName)
	populate(objectMap, "Version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultCertificateNewVersionCreatedEventData.
func (k *KeyVaultCertificateNewVersionCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EXP":
			err = unpopulate(val, "EXP", &k.EXP)
			delete(rawMsg, key)
		case "Id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "NBF":
			err = unpopulate(val, "NBF", &k.NBF)
			delete(rawMsg, key)
		case "ObjectName":
			err = unpopulate(val, "ObjectName", &k.ObjectName)
			delete(rawMsg, key)
		case "ObjectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "VaultName":
			err = unpopulate(val, "VaultName", &k.VaultName)
			delete(rawMsg, key)
		case "Version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultKeyExpiredEventData.
func (k KeyVaultKeyExpiredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "EXP", k.EXP)
	populate(objectMap, "Id", k.ID)
	populate(objectMap, "NBF", k.NBF)
	populate(objectMap, "ObjectName", k.ObjectName)
	populate(objectMap, "ObjectType", k.ObjectType)
	populate(objectMap, "VaultName", k.VaultName)
	populate(objectMap, "Version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultKeyExpiredEventData.
func (k *KeyVaultKeyExpiredEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EXP":
			err = unpopulate(val, "EXP", &k.EXP)
			delete(rawMsg, key)
		case "Id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "NBF":
			err = unpopulate(val, "NBF", &k.NBF)
			delete(rawMsg, key)
		case "ObjectName":
			err = unpopulate(val, "ObjectName", &k.ObjectName)
			delete(rawMsg, key)
		case "ObjectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "VaultName":
			err = unpopulate(val, "VaultName", &k.VaultName)
			delete(rawMsg, key)
		case "Version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultKeyNearExpiryEventData.
func (k KeyVaultKeyNearExpiryEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "EXP", k.EXP)
	populate(objectMap, "Id", k.ID)
	populate(objectMap, "NBF", k.NBF)
	populate(objectMap, "ObjectName", k.ObjectName)
	populate(objectMap, "ObjectType", k.ObjectType)
	populate(objectMap, "VaultName", k.VaultName)
	populate(objectMap, "Version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultKeyNearExpiryEventData.
func (k *KeyVaultKeyNearExpiryEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EXP":
			err = unpopulate(val, "EXP", &k.EXP)
			delete(rawMsg, key)
		case "Id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "NBF":
			err = unpopulate(val, "NBF", &k.NBF)
			delete(rawMsg, key)
		case "ObjectName":
			err = unpopulate(val, "ObjectName", &k.ObjectName)
			delete(rawMsg, key)
		case "ObjectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "VaultName":
			err = unpopulate(val, "VaultName", &k.VaultName)
			delete(rawMsg, key)
		case "Version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultKeyNewVersionCreatedEventData.
func (k KeyVaultKeyNewVersionCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "EXP", k.EXP)
	populate(objectMap, "Id", k.ID)
	populate(objectMap, "NBF", k.NBF)
	populate(objectMap, "ObjectName", k.ObjectName)
	populate(objectMap, "ObjectType", k.ObjectType)
	populate(objectMap, "VaultName", k.VaultName)
	populate(objectMap, "Version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultKeyNewVersionCreatedEventData.
func (k *KeyVaultKeyNewVersionCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EXP":
			err = unpopulate(val, "EXP", &k.EXP)
			delete(rawMsg, key)
		case "Id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "NBF":
			err = unpopulate(val, "NBF", &k.NBF)
			delete(rawMsg, key)
		case "ObjectName":
			err = unpopulate(val, "ObjectName", &k.ObjectName)
			delete(rawMsg, key)
		case "ObjectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "VaultName":
			err = unpopulate(val, "VaultName", &k.VaultName)
			delete(rawMsg, key)
		case "Version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultSecretExpiredEventData.
func (k KeyVaultSecretExpiredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "EXP", k.EXP)
	populate(objectMap, "Id", k.ID)
	populate(objectMap, "NBF", k.NBF)
	populate(objectMap, "ObjectName", k.ObjectName)
	populate(objectMap, "ObjectType", k.ObjectType)
	populate(objectMap, "VaultName", k.VaultName)
	populate(objectMap, "Version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultSecretExpiredEventData.
func (k *KeyVaultSecretExpiredEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EXP":
			err = unpopulate(val, "EXP", &k.EXP)
			delete(rawMsg, key)
		case "Id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "NBF":
			err = unpopulate(val, "NBF", &k.NBF)
			delete(rawMsg, key)
		case "ObjectName":
			err = unpopulate(val, "ObjectName", &k.ObjectName)
			delete(rawMsg, key)
		case "ObjectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "VaultName":
			err = unpopulate(val, "VaultName", &k.VaultName)
			delete(rawMsg, key)
		case "Version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultSecretNearExpiryEventData.
func (k KeyVaultSecretNearExpiryEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "EXP", k.EXP)
	populate(objectMap, "Id", k.ID)
	populate(objectMap, "NBF", k.NBF)
	populate(objectMap, "ObjectName", k.ObjectName)
	populate(objectMap, "ObjectType", k.ObjectType)
	populate(objectMap, "VaultName", k.VaultName)
	populate(objectMap, "Version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultSecretNearExpiryEventData.
func (k *KeyVaultSecretNearExpiryEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EXP":
			err = unpopulate(val, "EXP", &k.EXP)
			delete(rawMsg, key)
		case "Id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "NBF":
			err = unpopulate(val, "NBF", &k.NBF)
			delete(rawMsg, key)
		case "ObjectName":
			err = unpopulate(val, "ObjectName", &k.ObjectName)
			delete(rawMsg, key)
		case "ObjectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "VaultName":
			err = unpopulate(val, "VaultName", &k.VaultName)
			delete(rawMsg, key)
		case "Version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultSecretNewVersionCreatedEventData.
func (k KeyVaultSecretNewVersionCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "EXP", k.EXP)
	populate(objectMap, "Id", k.ID)
	populate(objectMap, "NBF", k.NBF)
	populate(objectMap, "ObjectName", k.ObjectName)
	populate(objectMap, "ObjectType", k.ObjectType)
	populate(objectMap, "VaultName", k.VaultName)
	populate(objectMap, "Version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultSecretNewVersionCreatedEventData.
func (k *KeyVaultSecretNewVersionCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "EXP":
			err = unpopulate(val, "EXP", &k.EXP)
			delete(rawMsg, key)
		case "Id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "NBF":
			err = unpopulate(val, "NBF", &k.NBF)
			delete(rawMsg, key)
		case "ObjectName":
			err = unpopulate(val, "ObjectName", &k.ObjectName)
			delete(rawMsg, key)
		case "ObjectType":
			err = unpopulate(val, "ObjectType", &k.ObjectType)
			delete(rawMsg, key)
		case "VaultName":
			err = unpopulate(val, "VaultName", &k.VaultName)
			delete(rawMsg, key)
		case "Version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineLearningServicesDatasetDriftDetectedEventData.
func (m MachineLearningServicesDatasetDriftDetectedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "baseDatasetId", m.BaseDatasetID)
	populate(objectMap, "dataDriftId", m.DataDriftID)
	populate(objectMap, "dataDriftName", m.DataDriftName)
	populate(objectMap, "driftCoefficient", m.DriftCoefficient)
	populateDateTimeRFC3339(objectMap, "endTime", m.EndTime)
	populate(objectMap, "runId", m.RunID)
	populateDateTimeRFC3339(objectMap, "startTime", m.StartTime)
	populate(objectMap, "targetDatasetId", m.TargetDatasetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineLearningServicesDatasetDriftDetectedEventData.
func (m *MachineLearningServicesDatasetDriftDetectedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baseDatasetId":
			err = unpopulate(val, "BaseDatasetID", &m.BaseDatasetID)
			delete(rawMsg, key)
		case "dataDriftId":
			err = unpopulate(val, "DataDriftID", &m.DataDriftID)
			delete(rawMsg, key)
		case "dataDriftName":
			err = unpopulate(val, "DataDriftName", &m.DataDriftName)
			delete(rawMsg, key)
		case "driftCoefficient":
			err = unpopulate(val, "DriftCoefficient", &m.DriftCoefficient)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &m.EndTime)
			delete(rawMsg, key)
		case "runId":
			err = unpopulate(val, "RunID", &m.RunID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "targetDatasetId":
			err = unpopulate(val, "TargetDatasetID", &m.TargetDatasetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineLearningServicesModelDeployedEventData.
func (m MachineLearningServicesModelDeployedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "modelIds", m.ModelIDs)
	populate(objectMap, "serviceComputeType", m.ServiceComputeType)
	populate(objectMap, "serviceName", m.ServiceName)
	populateAny(objectMap, "serviceProperties", m.ServiceProperties)
	populateAny(objectMap, "serviceTags", m.ServiceTags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineLearningServicesModelDeployedEventData.
func (m *MachineLearningServicesModelDeployedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "modelIds":
			err = unpopulate(val, "ModelIDs", &m.ModelIDs)
			delete(rawMsg, key)
		case "serviceComputeType":
			err = unpopulate(val, "ServiceComputeType", &m.ServiceComputeType)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &m.ServiceName)
			delete(rawMsg, key)
		case "serviceProperties":
			err = unpopulate(val, "ServiceProperties", &m.ServiceProperties)
			delete(rawMsg, key)
		case "serviceTags":
			err = unpopulate(val, "ServiceTags", &m.ServiceTags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineLearningServicesModelRegisteredEventData.
func (m MachineLearningServicesModelRegisteredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "modelName", m.ModelName)
	populateAny(objectMap, "modelProperties", m.ModelProperties)
	populateAny(objectMap, "modelTags", m.ModelTags)
	populate(objectMap, "modelVersion", m.ModelVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineLearningServicesModelRegisteredEventData.
func (m *MachineLearningServicesModelRegisteredEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "modelName":
			err = unpopulate(val, "ModelName", &m.ModelName)
			delete(rawMsg, key)
		case "modelProperties":
			err = unpopulate(val, "ModelProperties", &m.ModelProperties)
			delete(rawMsg, key)
		case "modelTags":
			err = unpopulate(val, "ModelTags", &m.ModelTags)
			delete(rawMsg, key)
		case "modelVersion":
			err = unpopulate(val, "ModelVersion", &m.ModelVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineLearningServicesRunCompletedEventData.
func (m MachineLearningServicesRunCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "experimentId", m.ExperimentID)
	populate(objectMap, "experimentName", m.ExperimentName)
	populate(objectMap, "runId", m.RunID)
	populateAny(objectMap, "runProperties", m.RunProperties)
	populateAny(objectMap, "runTags", m.RunTags)
	populate(objectMap, "runType", m.RunType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineLearningServicesRunCompletedEventData.
func (m *MachineLearningServicesRunCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "experimentId":
			err = unpopulate(val, "ExperimentID", &m.ExperimentID)
			delete(rawMsg, key)
		case "experimentName":
			err = unpopulate(val, "ExperimentName", &m.ExperimentName)
			delete(rawMsg, key)
		case "runId":
			err = unpopulate(val, "RunID", &m.RunID)
			delete(rawMsg, key)
		case "runProperties":
			err = unpopulate(val, "RunProperties", &m.RunProperties)
			delete(rawMsg, key)
		case "runTags":
			err = unpopulate(val, "RunTags", &m.RunTags)
			delete(rawMsg, key)
		case "runType":
			err = unpopulate(val, "RunType", &m.RunType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineLearningServicesRunStatusChangedEventData.
func (m MachineLearningServicesRunStatusChangedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "experimentId", m.ExperimentID)
	populate(objectMap, "experimentName", m.ExperimentName)
	populate(objectMap, "runId", m.RunID)
	populateAny(objectMap, "runProperties", m.RunProperties)
	populate(objectMap, "runStatus", m.RunStatus)
	populateAny(objectMap, "runTags", m.RunTags)
	populate(objectMap, "runType", m.RunType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineLearningServicesRunStatusChangedEventData.
func (m *MachineLearningServicesRunStatusChangedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "experimentId":
			err = unpopulate(val, "ExperimentID", &m.ExperimentID)
			delete(rawMsg, key)
		case "experimentName":
			err = unpopulate(val, "ExperimentName", &m.ExperimentName)
			delete(rawMsg, key)
		case "runId":
			err = unpopulate(val, "RunID", &m.RunID)
			delete(rawMsg, key)
		case "runProperties":
			err = unpopulate(val, "RunProperties", &m.RunProperties)
			delete(rawMsg, key)
		case "runStatus":
			err = unpopulate(val, "RunStatus", &m.RunStatus)
			delete(rawMsg, key)
		case "runTags":
			err = unpopulate(val, "RunTags", &m.RunTags)
			delete(rawMsg, key)
		case "runType":
			err = unpopulate(val, "RunType", &m.RunType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MapsGeofenceEnteredEventData.
func (m MapsGeofenceEnteredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "expiredGeofenceGeometryId", m.ExpiredGeofenceGeometryID)
	populate(objectMap, "geometries", m.Geometries)
	populate(objectMap, "invalidPeriodGeofenceGeometryId", m.InvalidPeriodGeofenceGeometryID)
	populate(objectMap, "isEventPublished", m.IsEventPublished)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MapsGeofenceEnteredEventData.
func (m *MapsGeofenceEnteredEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiredGeofenceGeometryId":
			err = unpopulate(val, "ExpiredGeofenceGeometryID", &m.ExpiredGeofenceGeometryID)
			delete(rawMsg, key)
		case "geometries":
			err = unpopulate(val, "Geometries", &m.Geometries)
			delete(rawMsg, key)
		case "invalidPeriodGeofenceGeometryId":
			err = unpopulate(val, "InvalidPeriodGeofenceGeometryID", &m.InvalidPeriodGeofenceGeometryID)
			delete(rawMsg, key)
		case "isEventPublished":
			err = unpopulate(val, "IsEventPublished", &m.IsEventPublished)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MapsGeofenceEventProperties.
func (m MapsGeofenceEventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "expiredGeofenceGeometryId", m.ExpiredGeofenceGeometryID)
	populate(objectMap, "geometries", m.Geometries)
	populate(objectMap, "invalidPeriodGeofenceGeometryId", m.InvalidPeriodGeofenceGeometryID)
	populate(objectMap, "isEventPublished", m.IsEventPublished)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MapsGeofenceEventProperties.
func (m *MapsGeofenceEventProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiredGeofenceGeometryId":
			err = unpopulate(val, "ExpiredGeofenceGeometryID", &m.ExpiredGeofenceGeometryID)
			delete(rawMsg, key)
		case "geometries":
			err = unpopulate(val, "Geometries", &m.Geometries)
			delete(rawMsg, key)
		case "invalidPeriodGeofenceGeometryId":
			err = unpopulate(val, "InvalidPeriodGeofenceGeometryID", &m.InvalidPeriodGeofenceGeometryID)
			delete(rawMsg, key)
		case "isEventPublished":
			err = unpopulate(val, "IsEventPublished", &m.IsEventPublished)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MapsGeofenceExitedEventData.
func (m MapsGeofenceExitedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "expiredGeofenceGeometryId", m.ExpiredGeofenceGeometryID)
	populate(objectMap, "geometries", m.Geometries)
	populate(objectMap, "invalidPeriodGeofenceGeometryId", m.InvalidPeriodGeofenceGeometryID)
	populate(objectMap, "isEventPublished", m.IsEventPublished)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MapsGeofenceExitedEventData.
func (m *MapsGeofenceExitedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiredGeofenceGeometryId":
			err = unpopulate(val, "ExpiredGeofenceGeometryID", &m.ExpiredGeofenceGeometryID)
			delete(rawMsg, key)
		case "geometries":
			err = unpopulate(val, "Geometries", &m.Geometries)
			delete(rawMsg, key)
		case "invalidPeriodGeofenceGeometryId":
			err = unpopulate(val, "InvalidPeriodGeofenceGeometryID", &m.InvalidPeriodGeofenceGeometryID)
			delete(rawMsg, key)
		case "isEventPublished":
			err = unpopulate(val, "IsEventPublished", &m.IsEventPublished)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MapsGeofenceGeometry.
func (m MapsGeofenceGeometry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deviceId", m.DeviceID)
	populate(objectMap, "distance", m.Distance)
	populate(objectMap, "geometryId", m.GeometryID)
	populate(objectMap, "nearestLat", m.NearestLat)
	populate(objectMap, "nearestLon", m.NearestLon)
	populate(objectMap, "udId", m.UdID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MapsGeofenceGeometry.
func (m *MapsGeofenceGeometry) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceId":
			err = unpopulate(val, "DeviceID", &m.DeviceID)
			delete(rawMsg, key)
		case "distance":
			err = unpopulate(val, "Distance", &m.Distance)
			delete(rawMsg, key)
		case "geometryId":
			err = unpopulate(val, "GeometryID", &m.GeometryID)
			delete(rawMsg, key)
		case "nearestLat":
			err = unpopulate(val, "NearestLat", &m.NearestLat)
			delete(rawMsg, key)
		case "nearestLon":
			err = unpopulate(val, "NearestLon", &m.NearestLon)
			delete(rawMsg, key)
		case "udId":
			err = unpopulate(val, "UdID", &m.UdID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MapsGeofenceResultEventData.
func (m MapsGeofenceResultEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "expiredGeofenceGeometryId", m.ExpiredGeofenceGeometryID)
	populate(objectMap, "geometries", m.Geometries)
	populate(objectMap, "invalidPeriodGeofenceGeometryId", m.InvalidPeriodGeofenceGeometryID)
	populate(objectMap, "isEventPublished", m.IsEventPublished)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MapsGeofenceResultEventData.
func (m *MapsGeofenceResultEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expiredGeofenceGeometryId":
			err = unpopulate(val, "ExpiredGeofenceGeometryID", &m.ExpiredGeofenceGeometryID)
			delete(rawMsg, key)
		case "geometries":
			err = unpopulate(val, "Geometries", &m.Geometries)
			delete(rawMsg, key)
		case "invalidPeriodGeofenceGeometryId":
			err = unpopulate(val, "InvalidPeriodGeofenceGeometryID", &m.InvalidPeriodGeofenceGeometryID)
			delete(rawMsg, key)
		case "isEventPublished":
			err = unpopulate(val, "IsEventPublished", &m.IsEventPublished)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobCanceledEventData.
func (m MediaJobCanceledEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationData", m.CorrelationData)
	populate(objectMap, "outputs", m.Outputs)
	populate(objectMap, "previousState", m.PreviousState)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobCanceledEventData.
func (m *MediaJobCanceledEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationData":
			err = unpopulate(val, "CorrelationData", &m.CorrelationData)
			delete(rawMsg, key)
		case "outputs":
			m.Outputs, err = unmarshalMediaJobOutputClassificationArray(val)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobCancelingEventData.
func (m MediaJobCancelingEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationData", m.CorrelationData)
	populate(objectMap, "previousState", m.PreviousState)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobCancelingEventData.
func (m *MediaJobCancelingEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationData":
			err = unpopulate(val, "CorrelationData", &m.CorrelationData)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobError.
func (m MediaJobError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", m.Category)
	populate(objectMap, "code", m.Code)
	populate(objectMap, "details", m.Details)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "retry", m.Retry)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobError.
func (m *MediaJobError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &m.Category)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &m.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &m.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "retry":
			err = unpopulate(val, "Retry", &m.Retry)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobErrorDetail.
func (m MediaJobErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", m.Code)
	populate(objectMap, "message", m.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobErrorDetail.
func (m *MediaJobErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &m.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobErroredEventData.
func (m MediaJobErroredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationData", m.CorrelationData)
	populate(objectMap, "outputs", m.Outputs)
	populate(objectMap, "previousState", m.PreviousState)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobErroredEventData.
func (m *MediaJobErroredEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationData":
			err = unpopulate(val, "CorrelationData", &m.CorrelationData)
			delete(rawMsg, key)
		case "outputs":
			m.Outputs, err = unmarshalMediaJobOutputClassificationArray(val)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobFinishedEventData.
func (m MediaJobFinishedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationData", m.CorrelationData)
	populate(objectMap, "outputs", m.Outputs)
	populate(objectMap, "previousState", m.PreviousState)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobFinishedEventData.
func (m *MediaJobFinishedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationData":
			err = unpopulate(val, "CorrelationData", &m.CorrelationData)
			delete(rawMsg, key)
		case "outputs":
			m.Outputs, err = unmarshalMediaJobOutputClassificationArray(val)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobOutput.
func (m MediaJobOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", m.Error)
	populate(objectMap, "label", m.Label)
	objectMap["@odata.type"] = m.ODataType
	populate(objectMap, "progress", m.Progress)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobOutput.
func (m *MediaJobOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &m.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &m.ODataType)
			delete(rawMsg, key)
		case "progress":
			err = unpopulate(val, "Progress", &m.Progress)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobOutputAsset.
func (m MediaJobOutputAsset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assetName", m.AssetName)
	populate(objectMap, "error", m.Error)
	populate(objectMap, "label", m.Label)
	objectMap["@odata.type"] = "#Microsoft.Media.JobOutputAsset"
	populate(objectMap, "progress", m.Progress)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobOutputAsset.
func (m *MediaJobOutputAsset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assetName":
			err = unpopulate(val, "AssetName", &m.AssetName)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &m.Label)
			delete(rawMsg, key)
		case "@odata.type":
			err = unpopulate(val, "ODataType", &m.ODataType)
			delete(rawMsg, key)
		case "progress":
			err = unpopulate(val, "Progress", &m.Progress)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobOutputCanceledEventData.
func (m MediaJobOutputCanceledEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobCorrelationData", m.JobCorrelationData)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "previousState", m.PreviousState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobOutputCanceledEventData.
func (m *MediaJobOutputCanceledEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobCorrelationData":
			err = unpopulate(val, "JobCorrelationData", &m.JobCorrelationData)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMediaJobOutputClassification(val)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobOutputCancelingEventData.
func (m MediaJobOutputCancelingEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobCorrelationData", m.JobCorrelationData)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "previousState", m.PreviousState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobOutputCancelingEventData.
func (m *MediaJobOutputCancelingEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobCorrelationData":
			err = unpopulate(val, "JobCorrelationData", &m.JobCorrelationData)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMediaJobOutputClassification(val)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobOutputErroredEventData.
func (m MediaJobOutputErroredEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobCorrelationData", m.JobCorrelationData)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "previousState", m.PreviousState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobOutputErroredEventData.
func (m *MediaJobOutputErroredEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobCorrelationData":
			err = unpopulate(val, "JobCorrelationData", &m.JobCorrelationData)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMediaJobOutputClassification(val)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobOutputFinishedEventData.
func (m MediaJobOutputFinishedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobCorrelationData", m.JobCorrelationData)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "previousState", m.PreviousState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobOutputFinishedEventData.
func (m *MediaJobOutputFinishedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobCorrelationData":
			err = unpopulate(val, "JobCorrelationData", &m.JobCorrelationData)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMediaJobOutputClassification(val)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobOutputProcessingEventData.
func (m MediaJobOutputProcessingEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobCorrelationData", m.JobCorrelationData)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "previousState", m.PreviousState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobOutputProcessingEventData.
func (m *MediaJobOutputProcessingEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobCorrelationData":
			err = unpopulate(val, "JobCorrelationData", &m.JobCorrelationData)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMediaJobOutputClassification(val)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobOutputProgressEventData.
func (m MediaJobOutputProgressEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobCorrelationData", m.JobCorrelationData)
	populate(objectMap, "label", m.Label)
	populate(objectMap, "progress", m.Progress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobOutputProgressEventData.
func (m *MediaJobOutputProgressEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobCorrelationData":
			err = unpopulate(val, "JobCorrelationData", &m.JobCorrelationData)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &m.Label)
			delete(rawMsg, key)
		case "progress":
			err = unpopulate(val, "Progress", &m.Progress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobOutputScheduledEventData.
func (m MediaJobOutputScheduledEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobCorrelationData", m.JobCorrelationData)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "previousState", m.PreviousState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobOutputScheduledEventData.
func (m *MediaJobOutputScheduledEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobCorrelationData":
			err = unpopulate(val, "JobCorrelationData", &m.JobCorrelationData)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMediaJobOutputClassification(val)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobOutputStateChangeEventData.
func (m MediaJobOutputStateChangeEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobCorrelationData", m.JobCorrelationData)
	populate(objectMap, "output", m.Output)
	populate(objectMap, "previousState", m.PreviousState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobOutputStateChangeEventData.
func (m *MediaJobOutputStateChangeEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobCorrelationData":
			err = unpopulate(val, "JobCorrelationData", &m.JobCorrelationData)
			delete(rawMsg, key)
		case "output":
			m.Output, err = unmarshalMediaJobOutputClassification(val)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobProcessingEventData.
func (m MediaJobProcessingEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationData", m.CorrelationData)
	populate(objectMap, "previousState", m.PreviousState)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobProcessingEventData.
func (m *MediaJobProcessingEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationData":
			err = unpopulate(val, "CorrelationData", &m.CorrelationData)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobScheduledEventData.
func (m MediaJobScheduledEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationData", m.CorrelationData)
	populate(objectMap, "previousState", m.PreviousState)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobScheduledEventData.
func (m *MediaJobScheduledEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationData":
			err = unpopulate(val, "CorrelationData", &m.CorrelationData)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaJobStateChangeEventData.
func (m MediaJobStateChangeEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationData", m.CorrelationData)
	populate(objectMap, "previousState", m.PreviousState)
	populate(objectMap, "state", m.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaJobStateChangeEventData.
func (m *MediaJobStateChangeEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationData":
			err = unpopulate(val, "CorrelationData", &m.CorrelationData)
			delete(rawMsg, key)
		case "previousState":
			err = unpopulate(val, "PreviousState", &m.PreviousState)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaLiveEventChannelArchiveHeartbeatEventData.
func (m MediaLiveEventChannelArchiveHeartbeatEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "channelLatencyMs", m.ChannelLatencyMS)
	populate(objectMap, "latencyResultCode", m.LatencyResultCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaLiveEventChannelArchiveHeartbeatEventData.
func (m *MediaLiveEventChannelArchiveHeartbeatEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelLatencyMs":
			err = unpopulate(val, "ChannelLatencyMs", &m.ChannelLatencyMS)
			fixNAValue(&m.ChannelLatencyMS)
			delete(rawMsg, key)
		case "latencyResultCode":
			err = unpopulate(val, "LatencyResultCode", &m.LatencyResultCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaLiveEventConnectionRejectedEventData.
func (m MediaLiveEventConnectionRejectedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encoderIp", m.EncoderIP)
	populate(objectMap, "encoderPort", m.EncoderPort)
	populate(objectMap, "ingestUrl", m.IngestURL)
	populate(objectMap, "resultCode", m.ResultCode)
	populate(objectMap, "streamId", m.StreamID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaLiveEventConnectionRejectedEventData.
func (m *MediaLiveEventConnectionRejectedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encoderIp":
			err = unpopulate(val, "EncoderIP", &m.EncoderIP)
			delete(rawMsg, key)
		case "encoderPort":
			err = unpopulate(val, "EncoderPort", &m.EncoderPort)
			delete(rawMsg, key)
		case "ingestUrl":
			err = unpopulate(val, "IngestURL", &m.IngestURL)
			delete(rawMsg, key)
		case "resultCode":
			err = unpopulate(val, "ResultCode", &m.ResultCode)
			delete(rawMsg, key)
		case "streamId":
			err = unpopulate(val, "StreamID", &m.StreamID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaLiveEventEncoderConnectedEventData.
func (m MediaLiveEventEncoderConnectedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encoderIp", m.EncoderIP)
	populate(objectMap, "encoderPort", m.EncoderPort)
	populate(objectMap, "ingestUrl", m.IngestURL)
	populate(objectMap, "streamId", m.StreamID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaLiveEventEncoderConnectedEventData.
func (m *MediaLiveEventEncoderConnectedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encoderIp":
			err = unpopulate(val, "EncoderIP", &m.EncoderIP)
			delete(rawMsg, key)
		case "encoderPort":
			err = unpopulate(val, "EncoderPort", &m.EncoderPort)
			delete(rawMsg, key)
		case "ingestUrl":
			err = unpopulate(val, "IngestURL", &m.IngestURL)
			delete(rawMsg, key)
		case "streamId":
			err = unpopulate(val, "StreamID", &m.StreamID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaLiveEventEncoderDisconnectedEventData.
func (m MediaLiveEventEncoderDisconnectedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encoderIp", m.EncoderIP)
	populate(objectMap, "encoderPort", m.EncoderPort)
	populate(objectMap, "ingestUrl", m.IngestURL)
	populate(objectMap, "resultCode", m.ResultCode)
	populate(objectMap, "streamId", m.StreamID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaLiveEventEncoderDisconnectedEventData.
func (m *MediaLiveEventEncoderDisconnectedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encoderIp":
			err = unpopulate(val, "EncoderIP", &m.EncoderIP)
			delete(rawMsg, key)
		case "encoderPort":
			err = unpopulate(val, "EncoderPort", &m.EncoderPort)
			delete(rawMsg, key)
		case "ingestUrl":
			err = unpopulate(val, "IngestURL", &m.IngestURL)
			delete(rawMsg, key)
		case "resultCode":
			err = unpopulate(val, "ResultCode", &m.ResultCode)
			delete(rawMsg, key)
		case "streamId":
			err = unpopulate(val, "StreamID", &m.StreamID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaLiveEventIncomingDataChunkDroppedEventData.
func (m MediaLiveEventIncomingDataChunkDroppedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bitrate", m.Bitrate)
	populate(objectMap, "resultCode", m.ResultCode)
	populate(objectMap, "timescale", m.Timescale)
	populate(objectMap, "timestamp", m.Timestamp)
	populate(objectMap, "trackName", m.TrackName)
	populate(objectMap, "trackType", m.TrackType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaLiveEventIncomingDataChunkDroppedEventData.
func (m *MediaLiveEventIncomingDataChunkDroppedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bitrate":
			err = unpopulate(val, "Bitrate", &m.Bitrate)
			delete(rawMsg, key)
		case "resultCode":
			err = unpopulate(val, "ResultCode", &m.ResultCode)
			delete(rawMsg, key)
		case "timescale":
			err = unpopulate(val, "Timescale", &m.Timescale)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulate(val, "Timestamp", &m.Timestamp)
			delete(rawMsg, key)
		case "trackName":
			err = unpopulate(val, "TrackName", &m.TrackName)
			delete(rawMsg, key)
		case "trackType":
			err = unpopulate(val, "TrackType", &m.TrackType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaLiveEventIncomingStreamReceivedEventData.
func (m MediaLiveEventIncomingStreamReceivedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bitrate", m.Bitrate)
	populate(objectMap, "duration", m.Duration)
	populate(objectMap, "encoderIp", m.EncoderIP)
	populate(objectMap, "encoderPort", m.EncoderPort)
	populate(objectMap, "ingestUrl", m.IngestURL)
	populate(objectMap, "timescale", m.Timescale)
	populate(objectMap, "timestamp", m.Timestamp)
	populate(objectMap, "trackName", m.TrackName)
	populate(objectMap, "trackType", m.TrackType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaLiveEventIncomingStreamReceivedEventData.
func (m *MediaLiveEventIncomingStreamReceivedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bitrate":
			err = unpopulate(val, "Bitrate", &m.Bitrate)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, "Duration", &m.Duration)
			delete(rawMsg, key)
		case "encoderIp":
			err = unpopulate(val, "EncoderIP", &m.EncoderIP)
			delete(rawMsg, key)
		case "encoderPort":
			err = unpopulate(val, "EncoderPort", &m.EncoderPort)
			delete(rawMsg, key)
		case "ingestUrl":
			err = unpopulate(val, "IngestURL", &m.IngestURL)
			delete(rawMsg, key)
		case "timescale":
			err = unpopulate(val, "Timescale", &m.Timescale)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulate(val, "Timestamp", &m.Timestamp)
			delete(rawMsg, key)
		case "trackName":
			err = unpopulate(val, "TrackName", &m.TrackName)
			delete(rawMsg, key)
		case "trackType":
			err = unpopulate(val, "TrackType", &m.TrackType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaLiveEventIncomingStreamsOutOfSyncEventData.
func (m MediaLiveEventIncomingStreamsOutOfSyncEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxLastTimestamp", m.MaxLastTimestamp)
	populate(objectMap, "minLastTimestamp", m.MinLastTimestamp)
	populate(objectMap, "timescaleOfMaxLastTimestamp", m.TimescaleOfMaxLastTimestamp)
	populate(objectMap, "timescaleOfMinLastTimestamp", m.TimescaleOfMinLastTimestamp)
	populate(objectMap, "typeOfStreamWithMaxLastTimestamp", m.TypeOfStreamWithMaxLastTimestamp)
	populate(objectMap, "typeOfStreamWithMinLastTimestamp", m.TypeOfStreamWithMinLastTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaLiveEventIncomingStreamsOutOfSyncEventData.
func (m *MediaLiveEventIncomingStreamsOutOfSyncEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxLastTimestamp":
			err = unpopulate(val, "MaxLastTimestamp", &m.MaxLastTimestamp)
			delete(rawMsg, key)
		case "minLastTimestamp":
			err = unpopulate(val, "MinLastTimestamp", &m.MinLastTimestamp)
			delete(rawMsg, key)
		case "timescaleOfMaxLastTimestamp":
			err = unpopulate(val, "TimescaleOfMaxLastTimestamp", &m.TimescaleOfMaxLastTimestamp)
			delete(rawMsg, key)
		case "timescaleOfMinLastTimestamp":
			err = unpopulate(val, "TimescaleOfMinLastTimestamp", &m.TimescaleOfMinLastTimestamp)
			delete(rawMsg, key)
		case "typeOfStreamWithMaxLastTimestamp":
			err = unpopulate(val, "TypeOfStreamWithMaxLastTimestamp", &m.TypeOfStreamWithMaxLastTimestamp)
			delete(rawMsg, key)
		case "typeOfStreamWithMinLastTimestamp":
			err = unpopulate(val, "TypeOfStreamWithMinLastTimestamp", &m.TypeOfStreamWithMinLastTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaLiveEventIncomingVideoStreamsOutOfSyncEventData.
func (m MediaLiveEventIncomingVideoStreamsOutOfSyncEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "firstDuration", m.FirstDuration)
	populate(objectMap, "firstTimestamp", m.FirstTimestamp)
	populate(objectMap, "secondDuration", m.SecondDuration)
	populate(objectMap, "secondTimestamp", m.SecondTimestamp)
	populate(objectMap, "timescale", m.Timescale)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaLiveEventIncomingVideoStreamsOutOfSyncEventData.
func (m *MediaLiveEventIncomingVideoStreamsOutOfSyncEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "firstDuration":
			err = unpopulate(val, "FirstDuration", &m.FirstDuration)
			delete(rawMsg, key)
		case "firstTimestamp":
			err = unpopulate(val, "FirstTimestamp", &m.FirstTimestamp)
			delete(rawMsg, key)
		case "secondDuration":
			err = unpopulate(val, "SecondDuration", &m.SecondDuration)
			delete(rawMsg, key)
		case "secondTimestamp":
			err = unpopulate(val, "SecondTimestamp", &m.SecondTimestamp)
			delete(rawMsg, key)
		case "timescale":
			err = unpopulate(val, "Timescale", &m.Timescale)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaLiveEventIngestHeartbeatEventData.
func (m MediaLiveEventIngestHeartbeatEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bitrate", m.Bitrate)
	populate(objectMap, "discontinuityCount", m.DiscontinuityCount)
	populate(objectMap, "healthy", m.Healthy)
	populate(objectMap, "incomingBitrate", m.IncomingBitrate)
	populate(objectMap, "ingestDriftValue", m.IngestDriftValue)
	populate(objectMap, "lastFragmentArrivalTime", m.LastFragmentArrivalTime)
	populate(objectMap, "lastTimestamp", m.LastTimestamp)
	populate(objectMap, "nonincreasingCount", m.NonincreasingCount)
	populate(objectMap, "overlapCount", m.OverlapCount)
	populate(objectMap, "state", m.State)
	populate(objectMap, "timescale", m.Timescale)
	populate(objectMap, "trackName", m.TrackName)
	populate(objectMap, "trackType", m.TrackType)
	populate(objectMap, "transcriptionLanguage", m.TranscriptionLanguage)
	populate(objectMap, "transcriptionState", m.TranscriptionState)
	populate(objectMap, "unexpectedBitrate", m.UnexpectedBitrate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaLiveEventIngestHeartbeatEventData.
func (m *MediaLiveEventIngestHeartbeatEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bitrate":
			err = unpopulate(val, "Bitrate", &m.Bitrate)
			delete(rawMsg, key)
		case "discontinuityCount":
			err = unpopulate(val, "DiscontinuityCount", &m.DiscontinuityCount)
			delete(rawMsg, key)
		case "healthy":
			err = unpopulate(val, "Healthy", &m.Healthy)
			delete(rawMsg, key)
		case "incomingBitrate":
			err = unpopulate(val, "IncomingBitrate", &m.IncomingBitrate)
			delete(rawMsg, key)
		case "ingestDriftValue":
			err = unpopulate(val, "IngestDriftValue", &m.IngestDriftValue)
			fixNAValue(&m.IngestDriftValue)
			delete(rawMsg, key)
		case "lastFragmentArrivalTime":
			err = unpopulate(val, "LastFragmentArrivalTime", &m.LastFragmentArrivalTime)
			delete(rawMsg, key)
		case "lastTimestamp":
			err = unpopulate(val, "LastTimestamp", &m.LastTimestamp)
			delete(rawMsg, key)
		case "nonincreasingCount":
			err = unpopulate(val, "NonincreasingCount", &m.NonincreasingCount)
			delete(rawMsg, key)
		case "overlapCount":
			err = unpopulate(val, "OverlapCount", &m.OverlapCount)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &m.State)
			delete(rawMsg, key)
		case "timescale":
			err = unpopulate(val, "Timescale", &m.Timescale)
			delete(rawMsg, key)
		case "trackName":
			err = unpopulate(val, "TrackName", &m.TrackName)
			delete(rawMsg, key)
		case "trackType":
			err = unpopulate(val, "TrackType", &m.TrackType)
			delete(rawMsg, key)
		case "transcriptionLanguage":
			err = unpopulate(val, "TranscriptionLanguage", &m.TranscriptionLanguage)
			delete(rawMsg, key)
		case "transcriptionState":
			err = unpopulate(val, "TranscriptionState", &m.TranscriptionState)
			delete(rawMsg, key)
		case "unexpectedBitrate":
			err = unpopulate(val, "UnexpectedBitrate", &m.UnexpectedBitrate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MediaLiveEventTrackDiscontinuityDetectedEventData.
func (m MediaLiveEventTrackDiscontinuityDetectedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bitrate", m.Bitrate)
	populate(objectMap, "discontinuityGap", m.DiscontinuityGap)
	populate(objectMap, "newTimestamp", m.NewTimestamp)
	populate(objectMap, "previousTimestamp", m.PreviousTimestamp)
	populate(objectMap, "timescale", m.Timescale)
	populate(objectMap, "trackName", m.TrackName)
	populate(objectMap, "trackType", m.TrackType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MediaLiveEventTrackDiscontinuityDetectedEventData.
func (m *MediaLiveEventTrackDiscontinuityDetectedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bitrate":
			err = unpopulate(val, "Bitrate", &m.Bitrate)
			delete(rawMsg, key)
		case "discontinuityGap":
			err = unpopulate(val, "DiscontinuityGap", &m.DiscontinuityGap)
			delete(rawMsg, key)
		case "newTimestamp":
			err = unpopulate(val, "NewTimestamp", &m.NewTimestamp)
			delete(rawMsg, key)
		case "previousTimestamp":
			err = unpopulate(val, "PreviousTimestamp", &m.PreviousTimestamp)
			delete(rawMsg, key)
		case "timescale":
			err = unpopulate(val, "Timescale", &m.Timescale)
			delete(rawMsg, key)
		case "trackName":
			err = unpopulate(val, "TrackName", &m.TrackName)
			delete(rawMsg, key)
		case "trackType":
			err = unpopulate(val, "TrackType", &m.TrackType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MicrosoftTeamsAppIdentifierModel.
func (m MicrosoftTeamsAppIdentifierModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appId", m.AppID)
	populate(objectMap, "cloud", m.Cloud)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MicrosoftTeamsAppIdentifierModel.
func (m *MicrosoftTeamsAppIdentifierModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appId":
			err = unpopulate(val, "AppID", &m.AppID)
			delete(rawMsg, key)
		case "cloud":
			err = unpopulate(val, "Cloud", &m.Cloud)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MicrosoftTeamsUserIdentifierModel.
func (m MicrosoftTeamsUserIdentifierModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cloud", m.Cloud)
	populate(objectMap, "isAnonymous", m.IsAnonymous)
	populate(objectMap, "userId", m.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MicrosoftTeamsUserIdentifierModel.
func (m *MicrosoftTeamsUserIdentifierModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloud":
			err = unpopulate(val, "Cloud", &m.Cloud)
			delete(rawMsg, key)
		case "isAnonymous":
			err = unpopulate(val, "IsAnonymous", &m.IsAnonymous)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &m.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PhoneNumberIdentifierModel.
func (p PhoneNumberIdentifierModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PhoneNumberIdentifierModel.
func (p *PhoneNumberIdentifierModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyInsightsPolicyStateChangedEventData.
func (p PolicyInsightsPolicyStateChangedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "complianceReasonCode", p.ComplianceReasonCode)
	populate(objectMap, "complianceState", p.ComplianceState)
	populate(objectMap, "policyAssignmentId", p.PolicyAssignmentID)
	populate(objectMap, "policyDefinitionId", p.PolicyDefinitionID)
	populate(objectMap, "policyDefinitionReferenceId", p.PolicyDefinitionReferenceID)
	populate(objectMap, "subscriptionId", p.SubscriptionID)
	populateDateTimeRFC3339(objectMap, "timestamp", p.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyInsightsPolicyStateChangedEventData.
func (p *PolicyInsightsPolicyStateChangedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complianceReasonCode":
			err = unpopulate(val, "ComplianceReasonCode", &p.ComplianceReasonCode)
			delete(rawMsg, key)
		case "complianceState":
			err = unpopulate(val, "ComplianceState", &p.ComplianceState)
			delete(rawMsg, key)
		case "policyAssignmentId":
			err = unpopulate(val, "PolicyAssignmentID", &p.PolicyAssignmentID)
			delete(rawMsg, key)
		case "policyDefinitionId":
			err = unpopulate(val, "PolicyDefinitionID", &p.PolicyDefinitionID)
			delete(rawMsg, key)
		case "policyDefinitionReferenceId":
			err = unpopulate(val, "PolicyDefinitionReferenceID", &p.PolicyDefinitionReferenceID)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &p.SubscriptionID)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &p.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyInsightsPolicyStateCreatedEventData.
func (p PolicyInsightsPolicyStateCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "complianceReasonCode", p.ComplianceReasonCode)
	populate(objectMap, "complianceState", p.ComplianceState)
	populate(objectMap, "policyAssignmentId", p.PolicyAssignmentID)
	populate(objectMap, "policyDefinitionId", p.PolicyDefinitionID)
	populate(objectMap, "policyDefinitionReferenceId", p.PolicyDefinitionReferenceID)
	populate(objectMap, "subscriptionId", p.SubscriptionID)
	populateDateTimeRFC3339(objectMap, "timestamp", p.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyInsightsPolicyStateCreatedEventData.
func (p *PolicyInsightsPolicyStateCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complianceReasonCode":
			err = unpopulate(val, "ComplianceReasonCode", &p.ComplianceReasonCode)
			delete(rawMsg, key)
		case "complianceState":
			err = unpopulate(val, "ComplianceState", &p.ComplianceState)
			delete(rawMsg, key)
		case "policyAssignmentId":
			err = unpopulate(val, "PolicyAssignmentID", &p.PolicyAssignmentID)
			delete(rawMsg, key)
		case "policyDefinitionId":
			err = unpopulate(val, "PolicyDefinitionID", &p.PolicyDefinitionID)
			delete(rawMsg, key)
		case "policyDefinitionReferenceId":
			err = unpopulate(val, "PolicyDefinitionReferenceID", &p.PolicyDefinitionReferenceID)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &p.SubscriptionID)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &p.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyInsightsPolicyStateDeletedEventData.
func (p PolicyInsightsPolicyStateDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "complianceReasonCode", p.ComplianceReasonCode)
	populate(objectMap, "complianceState", p.ComplianceState)
	populate(objectMap, "policyAssignmentId", p.PolicyAssignmentID)
	populate(objectMap, "policyDefinitionId", p.PolicyDefinitionID)
	populate(objectMap, "policyDefinitionReferenceId", p.PolicyDefinitionReferenceID)
	populate(objectMap, "subscriptionId", p.SubscriptionID)
	populateDateTimeRFC3339(objectMap, "timestamp", p.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyInsightsPolicyStateDeletedEventData.
func (p *PolicyInsightsPolicyStateDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complianceReasonCode":
			err = unpopulate(val, "ComplianceReasonCode", &p.ComplianceReasonCode)
			delete(rawMsg, key)
		case "complianceState":
			err = unpopulate(val, "ComplianceState", &p.ComplianceState)
			delete(rawMsg, key)
		case "policyAssignmentId":
			err = unpopulate(val, "PolicyAssignmentID", &p.PolicyAssignmentID)
			delete(rawMsg, key)
		case "policyDefinitionId":
			err = unpopulate(val, "PolicyDefinitionID", &p.PolicyDefinitionID)
			delete(rawMsg, key)
		case "policyDefinitionReferenceId":
			err = unpopulate(val, "PolicyDefinitionReferenceID", &p.PolicyDefinitionReferenceID)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &p.SubscriptionID)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &p.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RedisExportRDBCompletedEventData.
func (r RedisExportRDBCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "status", r.Status)
	populateDateTimeRFC3339(objectMap, "timestamp", r.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RedisExportRDBCompletedEventData.
func (r *RedisExportRDBCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &r.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RedisImportRDBCompletedEventData.
func (r RedisImportRDBCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "status", r.Status)
	populateDateTimeRFC3339(objectMap, "timestamp", r.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RedisImportRDBCompletedEventData.
func (r *RedisImportRDBCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &r.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RedisPatchingCompletedEventData.
func (r RedisPatchingCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "status", r.Status)
	populateDateTimeRFC3339(objectMap, "timestamp", r.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RedisPatchingCompletedEventData.
func (r *RedisPatchingCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &r.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RedisScalingCompletedEventData.
func (r RedisScalingCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "status", r.Status)
	populateDateTimeRFC3339(objectMap, "timestamp", r.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RedisScalingCompletedEventData.
func (r *RedisScalingCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &r.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceActionCancelEventData.
func (r ResourceActionCancelEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorization", r.Authorization)
	populate(objectMap, "claims", r.Claims)
	populate(objectMap, "correlationId", r.CorrelationID)
	populate(objectMap, "httpRequest", r.HTTPRequest)
	populate(objectMap, "operationName", r.OperationName)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "resourceProvider", r.ResourceProvider)
	populate(objectMap, "resourceUri", r.ResourceURI)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	populate(objectMap, "tenantId", r.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceActionCancelEventData.
func (r *ResourceActionCancelEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorization":
			err = unpopulate(val, "Authorization", &r.Authorization)
			delete(rawMsg, key)
		case "claims":
			err = unpopulate(val, "Claims", &r.Claims)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &r.CorrelationID)
			delete(rawMsg, key)
		case "httpRequest":
			err = unpopulate(val, "HTTPRequest", &r.HTTPRequest)
			delete(rawMsg, key)
		case "operationName":
			err = unpopulate(val, "OperationName", &r.OperationName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "resourceProvider":
			err = unpopulate(val, "ResourceProvider", &r.ResourceProvider)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &r.ResourceURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceActionFailureEventData.
func (r ResourceActionFailureEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorization", r.Authorization)
	populate(objectMap, "claims", r.Claims)
	populate(objectMap, "correlationId", r.CorrelationID)
	populate(objectMap, "httpRequest", r.HTTPRequest)
	populate(objectMap, "operationName", r.OperationName)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "resourceProvider", r.ResourceProvider)
	populate(objectMap, "resourceUri", r.ResourceURI)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	populate(objectMap, "tenantId", r.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceActionFailureEventData.
func (r *ResourceActionFailureEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorization":
			err = unpopulate(val, "Authorization", &r.Authorization)
			delete(rawMsg, key)
		case "claims":
			err = unpopulate(val, "Claims", &r.Claims)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &r.CorrelationID)
			delete(rawMsg, key)
		case "httpRequest":
			err = unpopulate(val, "HTTPRequest", &r.HTTPRequest)
			delete(rawMsg, key)
		case "operationName":
			err = unpopulate(val, "OperationName", &r.OperationName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "resourceProvider":
			err = unpopulate(val, "ResourceProvider", &r.ResourceProvider)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &r.ResourceURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceActionSuccessEventData.
func (r ResourceActionSuccessEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorization", r.Authorization)
	populate(objectMap, "claims", r.Claims)
	populate(objectMap, "correlationId", r.CorrelationID)
	populate(objectMap, "httpRequest", r.HTTPRequest)
	populate(objectMap, "operationName", r.OperationName)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "resourceProvider", r.ResourceProvider)
	populate(objectMap, "resourceUri", r.ResourceURI)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	populate(objectMap, "tenantId", r.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceActionSuccessEventData.
func (r *ResourceActionSuccessEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorization":
			err = unpopulate(val, "Authorization", &r.Authorization)
			delete(rawMsg, key)
		case "claims":
			err = unpopulate(val, "Claims", &r.Claims)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &r.CorrelationID)
			delete(rawMsg, key)
		case "httpRequest":
			err = unpopulate(val, "HTTPRequest", &r.HTTPRequest)
			delete(rawMsg, key)
		case "operationName":
			err = unpopulate(val, "OperationName", &r.OperationName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "resourceProvider":
			err = unpopulate(val, "ResourceProvider", &r.ResourceProvider)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &r.ResourceURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceAuthorization.
func (r ResourceAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", r.Action)
	populate(objectMap, "evidence", r.Evidence)
	populate(objectMap, "scope", r.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceAuthorization.
func (r *ResourceAuthorization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &r.Action)
			delete(rawMsg, key)
		case "evidence":
			err = unpopulate(val, "Evidence", &r.Evidence)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceDeleteCancelEventData.
func (r ResourceDeleteCancelEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorization", r.Authorization)
	populate(objectMap, "claims", r.Claims)
	populate(objectMap, "correlationId", r.CorrelationID)
	populate(objectMap, "httpRequest", r.HTTPRequest)
	populate(objectMap, "operationName", r.OperationName)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "resourceProvider", r.ResourceProvider)
	populate(objectMap, "resourceUri", r.ResourceURI)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	populate(objectMap, "tenantId", r.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceDeleteCancelEventData.
func (r *ResourceDeleteCancelEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorization":
			err = unpopulate(val, "Authorization", &r.Authorization)
			delete(rawMsg, key)
		case "claims":
			err = unpopulate(val, "Claims", &r.Claims)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &r.CorrelationID)
			delete(rawMsg, key)
		case "httpRequest":
			err = unpopulate(val, "HTTPRequest", &r.HTTPRequest)
			delete(rawMsg, key)
		case "operationName":
			err = unpopulate(val, "OperationName", &r.OperationName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "resourceProvider":
			err = unpopulate(val, "ResourceProvider", &r.ResourceProvider)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &r.ResourceURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceDeleteFailureEventData.
func (r ResourceDeleteFailureEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorization", r.Authorization)
	populate(objectMap, "claims", r.Claims)
	populate(objectMap, "correlationId", r.CorrelationID)
	populate(objectMap, "httpRequest", r.HTTPRequest)
	populate(objectMap, "operationName", r.OperationName)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "resourceProvider", r.ResourceProvider)
	populate(objectMap, "resourceUri", r.ResourceURI)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	populate(objectMap, "tenantId", r.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceDeleteFailureEventData.
func (r *ResourceDeleteFailureEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorization":
			err = unpopulate(val, "Authorization", &r.Authorization)
			delete(rawMsg, key)
		case "claims":
			err = unpopulate(val, "Claims", &r.Claims)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &r.CorrelationID)
			delete(rawMsg, key)
		case "httpRequest":
			err = unpopulate(val, "HTTPRequest", &r.HTTPRequest)
			delete(rawMsg, key)
		case "operationName":
			err = unpopulate(val, "OperationName", &r.OperationName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "resourceProvider":
			err = unpopulate(val, "ResourceProvider", &r.ResourceProvider)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &r.ResourceURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceDeleteSuccessEventData.
func (r ResourceDeleteSuccessEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorization", r.Authorization)
	populate(objectMap, "claims", r.Claims)
	populate(objectMap, "correlationId", r.CorrelationID)
	populate(objectMap, "httpRequest", r.HTTPRequest)
	populate(objectMap, "operationName", r.OperationName)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "resourceProvider", r.ResourceProvider)
	populate(objectMap, "resourceUri", r.ResourceURI)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	populate(objectMap, "tenantId", r.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceDeleteSuccessEventData.
func (r *ResourceDeleteSuccessEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorization":
			err = unpopulate(val, "Authorization", &r.Authorization)
			delete(rawMsg, key)
		case "claims":
			err = unpopulate(val, "Claims", &r.Claims)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &r.CorrelationID)
			delete(rawMsg, key)
		case "httpRequest":
			err = unpopulate(val, "HTTPRequest", &r.HTTPRequest)
			delete(rawMsg, key)
		case "operationName":
			err = unpopulate(val, "OperationName", &r.OperationName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "resourceProvider":
			err = unpopulate(val, "ResourceProvider", &r.ResourceProvider)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &r.ResourceURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceHTTPRequest.
func (r ResourceHTTPRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientIpAddress", r.ClientIPAddress)
	populate(objectMap, "clientRequestId", r.ClientRequestID)
	populate(objectMap, "method", r.Method)
	populate(objectMap, "url", r.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceHTTPRequest.
func (r *ResourceHTTPRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientIpAddress":
			err = unpopulate(val, "ClientIPAddress", &r.ClientIPAddress)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &r.ClientRequestID)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &r.Method)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &r.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNotificationsHealthResourcesAnnotatedEventData.
func (r ResourceNotificationsHealthResourcesAnnotatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersion", r.APIVersion)
	populate(objectMap, "operationalInfo", r.OperationalDetails)
	populate(objectMap, "resourceInfo", r.ResourceDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNotificationsHealthResourcesAnnotatedEventData.
func (r *ResourceNotificationsHealthResourcesAnnotatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersion":
			err = unpopulate(val, "APIVersion", &r.APIVersion)
			delete(rawMsg, key)
		case "operationalInfo":
			err = unpopulate(val, "OperationalDetails", &r.OperationalDetails)
			delete(rawMsg, key)
		case "resourceInfo":
			err = unpopulate(val, "ResourceDetails", &r.ResourceDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNotificationsHealthResourcesAvailabilityStatusChangedEventData.
func (r ResourceNotificationsHealthResourcesAvailabilityStatusChangedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersion", r.APIVersion)
	populate(objectMap, "operationalInfo", r.OperationalDetails)
	populate(objectMap, "resourceInfo", r.ResourceDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNotificationsHealthResourcesAvailabilityStatusChangedEventData.
func (r *ResourceNotificationsHealthResourcesAvailabilityStatusChangedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersion":
			err = unpopulate(val, "APIVersion", &r.APIVersion)
			delete(rawMsg, key)
		case "operationalInfo":
			err = unpopulate(val, "OperationalDetails", &r.OperationalDetails)
			delete(rawMsg, key)
		case "resourceInfo":
			err = unpopulate(val, "ResourceDetails", &r.ResourceDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNotificationsOperationalDetails.
func (r ResourceNotificationsOperationalDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "resourceEventTime", r.ResourceEventTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNotificationsOperationalDetails.
func (r *ResourceNotificationsOperationalDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceEventTime":
			err = unpopulateDateTimeRFC3339(val, "ResourceEventTime", &r.ResourceEventTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNotificationsResourceDeletedDetails.
func (r ResourceNotificationsResourceDeletedDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNotificationsResourceDeletedDetails.
func (r *ResourceNotificationsResourceDeletedDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNotificationsResourceDeletedEventData.
func (r ResourceNotificationsResourceDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationalInfo", r.OperationalDetails)
	populate(objectMap, "resourceInfo", r.ResourceDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNotificationsResourceDeletedEventData.
func (r *ResourceNotificationsResourceDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationalInfo":
			err = unpopulate(val, "OperationalDetails", &r.OperationalDetails)
			delete(rawMsg, key)
		case "resourceInfo":
			err = unpopulate(val, "ResourceDetails", &r.ResourceDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNotificationsResourceManagementCreatedOrUpdatedEventData.
func (r ResourceNotificationsResourceManagementCreatedOrUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersion", r.APIVersion)
	populate(objectMap, "operationalInfo", r.OperationalDetails)
	populate(objectMap, "resourceInfo", r.ResourceDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNotificationsResourceManagementCreatedOrUpdatedEventData.
func (r *ResourceNotificationsResourceManagementCreatedOrUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersion":
			err = unpopulate(val, "APIVersion", &r.APIVersion)
			delete(rawMsg, key)
		case "operationalInfo":
			err = unpopulate(val, "OperationalDetails", &r.OperationalDetails)
			delete(rawMsg, key)
		case "resourceInfo":
			err = unpopulate(val, "ResourceDetails", &r.ResourceDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNotificationsResourceManagementDeletedEventData.
func (r ResourceNotificationsResourceManagementDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationalInfo", r.OperationalDetails)
	populate(objectMap, "resourceInfo", r.ResourceDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNotificationsResourceManagementDeletedEventData.
func (r *ResourceNotificationsResourceManagementDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationalInfo":
			err = unpopulate(val, "OperationalDetails", &r.OperationalDetails)
			delete(rawMsg, key)
		case "resourceInfo":
			err = unpopulate(val, "ResourceDetails", &r.ResourceDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNotificationsResourceUpdatedDetails.
func (r ResourceNotificationsResourceUpdatedDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNotificationsResourceUpdatedDetails.
func (r *ResourceNotificationsResourceUpdatedDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNotificationsResourceUpdatedEventData.
func (r ResourceNotificationsResourceUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersion", r.APIVersion)
	populate(objectMap, "operationalInfo", r.OperationalDetails)
	populate(objectMap, "resourceInfo", r.ResourceDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNotificationsResourceUpdatedEventData.
func (r *ResourceNotificationsResourceUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersion":
			err = unpopulate(val, "APIVersion", &r.APIVersion)
			delete(rawMsg, key)
		case "operationalInfo":
			err = unpopulate(val, "OperationalDetails", &r.OperationalDetails)
			delete(rawMsg, key)
		case "resourceInfo":
			err = unpopulate(val, "ResourceDetails", &r.ResourceDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceWriteCancelEventData.
func (r ResourceWriteCancelEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorization", r.Authorization)
	populate(objectMap, "claims", r.Claims)
	populate(objectMap, "correlationId", r.CorrelationID)
	populate(objectMap, "httpRequest", r.HTTPRequest)
	populate(objectMap, "operationName", r.OperationName)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "resourceProvider", r.ResourceProvider)
	populate(objectMap, "resourceUri", r.ResourceURI)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	populate(objectMap, "tenantId", r.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceWriteCancelEventData.
func (r *ResourceWriteCancelEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorization":
			err = unpopulate(val, "Authorization", &r.Authorization)
			delete(rawMsg, key)
		case "claims":
			err = unpopulate(val, "Claims", &r.Claims)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &r.CorrelationID)
			delete(rawMsg, key)
		case "httpRequest":
			err = unpopulate(val, "HTTPRequest", &r.HTTPRequest)
			delete(rawMsg, key)
		case "operationName":
			err = unpopulate(val, "OperationName", &r.OperationName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "resourceProvider":
			err = unpopulate(val, "ResourceProvider", &r.ResourceProvider)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &r.ResourceURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceWriteFailureEventData.
func (r ResourceWriteFailureEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorization", r.Authorization)
	populate(objectMap, "claims", r.Claims)
	populate(objectMap, "correlationId", r.CorrelationID)
	populate(objectMap, "httpRequest", r.HTTPRequest)
	populate(objectMap, "operationName", r.OperationName)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "resourceProvider", r.ResourceProvider)
	populate(objectMap, "resourceUri", r.ResourceURI)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	populate(objectMap, "tenantId", r.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceWriteFailureEventData.
func (r *ResourceWriteFailureEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorization":
			err = unpopulate(val, "Authorization", &r.Authorization)
			delete(rawMsg, key)
		case "claims":
			err = unpopulate(val, "Claims", &r.Claims)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &r.CorrelationID)
			delete(rawMsg, key)
		case "httpRequest":
			err = unpopulate(val, "HTTPRequest", &r.HTTPRequest)
			delete(rawMsg, key)
		case "operationName":
			err = unpopulate(val, "OperationName", &r.OperationName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "resourceProvider":
			err = unpopulate(val, "ResourceProvider", &r.ResourceProvider)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &r.ResourceURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceWriteSuccessEventData.
func (r ResourceWriteSuccessEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorization", r.Authorization)
	populate(objectMap, "claims", r.Claims)
	populate(objectMap, "correlationId", r.CorrelationID)
	populate(objectMap, "httpRequest", r.HTTPRequest)
	populate(objectMap, "operationName", r.OperationName)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "resourceProvider", r.ResourceProvider)
	populate(objectMap, "resourceUri", r.ResourceURI)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	populate(objectMap, "tenantId", r.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceWriteSuccessEventData.
func (r *ResourceWriteSuccessEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorization":
			err = unpopulate(val, "Authorization", &r.Authorization)
			delete(rawMsg, key)
		case "claims":
			err = unpopulate(val, "Claims", &r.Claims)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &r.CorrelationID)
			delete(rawMsg, key)
		case "httpRequest":
			err = unpopulate(val, "HTTPRequest", &r.HTTPRequest)
			delete(rawMsg, key)
		case "operationName":
			err = unpopulate(val, "OperationName", &r.OperationName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "resourceProvider":
			err = unpopulate(val, "ResourceProvider", &r.ResourceProvider)
			delete(rawMsg, key)
		case "resourceUri":
			err = unpopulate(val, "ResourceURI", &r.ResourceURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusActiveMessagesAvailablePeriodicNotificationsEventData.
func (s ServiceBusActiveMessagesAvailablePeriodicNotificationsEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "entityType", s.EntityType)
	populate(objectMap, "namespaceName", s.NamespaceName)
	populate(objectMap, "queueName", s.QueueName)
	populate(objectMap, "requestUri", s.RequestURI)
	populate(objectMap, "subscriptionName", s.SubscriptionName)
	populate(objectMap, "topicName", s.TopicName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusActiveMessagesAvailablePeriodicNotificationsEventData.
func (s *ServiceBusActiveMessagesAvailablePeriodicNotificationsEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entityType":
			err = unpopulate(val, "EntityType", &s.EntityType)
			delete(rawMsg, key)
		case "namespaceName":
			err = unpopulate(val, "NamespaceName", &s.NamespaceName)
			delete(rawMsg, key)
		case "queueName":
			err = unpopulate(val, "QueueName", &s.QueueName)
			delete(rawMsg, key)
		case "requestUri":
			err = unpopulate(val, "RequestURI", &s.RequestURI)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &s.SubscriptionName)
			delete(rawMsg, key)
		case "topicName":
			err = unpopulate(val, "TopicName", &s.TopicName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusActiveMessagesAvailableWithNoListenersEventData.
func (s ServiceBusActiveMessagesAvailableWithNoListenersEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "entityType", s.EntityType)
	populate(objectMap, "namespaceName", s.NamespaceName)
	populate(objectMap, "queueName", s.QueueName)
	populate(objectMap, "requestUri", s.RequestURI)
	populate(objectMap, "subscriptionName", s.SubscriptionName)
	populate(objectMap, "topicName", s.TopicName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusActiveMessagesAvailableWithNoListenersEventData.
func (s *ServiceBusActiveMessagesAvailableWithNoListenersEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entityType":
			err = unpopulate(val, "EntityType", &s.EntityType)
			delete(rawMsg, key)
		case "namespaceName":
			err = unpopulate(val, "NamespaceName", &s.NamespaceName)
			delete(rawMsg, key)
		case "queueName":
			err = unpopulate(val, "QueueName", &s.QueueName)
			delete(rawMsg, key)
		case "requestUri":
			err = unpopulate(val, "RequestURI", &s.RequestURI)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &s.SubscriptionName)
			delete(rawMsg, key)
		case "topicName":
			err = unpopulate(val, "TopicName", &s.TopicName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusDeadletterMessagesAvailablePeriodicNotificationsEventData.
func (s ServiceBusDeadletterMessagesAvailablePeriodicNotificationsEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "entityType", s.EntityType)
	populate(objectMap, "namespaceName", s.NamespaceName)
	populate(objectMap, "queueName", s.QueueName)
	populate(objectMap, "requestUri", s.RequestURI)
	populate(objectMap, "subscriptionName", s.SubscriptionName)
	populate(objectMap, "topicName", s.TopicName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusDeadletterMessagesAvailablePeriodicNotificationsEventData.
func (s *ServiceBusDeadletterMessagesAvailablePeriodicNotificationsEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entityType":
			err = unpopulate(val, "EntityType", &s.EntityType)
			delete(rawMsg, key)
		case "namespaceName":
			err = unpopulate(val, "NamespaceName", &s.NamespaceName)
			delete(rawMsg, key)
		case "queueName":
			err = unpopulate(val, "QueueName", &s.QueueName)
			delete(rawMsg, key)
		case "requestUri":
			err = unpopulate(val, "RequestURI", &s.RequestURI)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &s.SubscriptionName)
			delete(rawMsg, key)
		case "topicName":
			err = unpopulate(val, "TopicName", &s.TopicName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusDeadletterMessagesAvailableWithNoListenersEventData.
func (s ServiceBusDeadletterMessagesAvailableWithNoListenersEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "entityType", s.EntityType)
	populate(objectMap, "namespaceName", s.NamespaceName)
	populate(objectMap, "queueName", s.QueueName)
	populate(objectMap, "requestUri", s.RequestURI)
	populate(objectMap, "subscriptionName", s.SubscriptionName)
	populate(objectMap, "topicName", s.TopicName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusDeadletterMessagesAvailableWithNoListenersEventData.
func (s *ServiceBusDeadletterMessagesAvailableWithNoListenersEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entityType":
			err = unpopulate(val, "EntityType", &s.EntityType)
			delete(rawMsg, key)
		case "namespaceName":
			err = unpopulate(val, "NamespaceName", &s.NamespaceName)
			delete(rawMsg, key)
		case "queueName":
			err = unpopulate(val, "QueueName", &s.QueueName)
			delete(rawMsg, key)
		case "requestUri":
			err = unpopulate(val, "RequestURI", &s.RequestURI)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &s.SubscriptionName)
			delete(rawMsg, key)
		case "topicName":
			err = unpopulate(val, "TopicName", &s.TopicName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SignalRServiceClientConnectionConnectedEventData.
func (s SignalRServiceClientConnectionConnectedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionId", s.ConnectionID)
	populate(objectMap, "hubName", s.HubName)
	populateDateTimeRFC3339(objectMap, "timestamp", s.Timestamp)
	populate(objectMap, "userId", s.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SignalRServiceClientConnectionConnectedEventData.
func (s *SignalRServiceClientConnectionConnectedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionId":
			err = unpopulate(val, "ConnectionID", &s.ConnectionID)
			delete(rawMsg, key)
		case "hubName":
			err = unpopulate(val, "HubName", &s.HubName)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &s.Timestamp)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &s.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SignalRServiceClientConnectionDisconnectedEventData.
func (s SignalRServiceClientConnectionDisconnectedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectionId", s.ConnectionID)
	populate(objectMap, "errorMessage", s.ErrorMessage)
	populate(objectMap, "hubName", s.HubName)
	populateDateTimeRFC3339(objectMap, "timestamp", s.Timestamp)
	populate(objectMap, "userId", s.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SignalRServiceClientConnectionDisconnectedEventData.
func (s *SignalRServiceClientConnectionDisconnectedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionId":
			err = unpopulate(val, "ConnectionID", &s.ConnectionID)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &s.ErrorMessage)
			delete(rawMsg, key)
		case "hubName":
			err = unpopulate(val, "HubName", &s.HubName)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateDateTimeRFC3339(val, "Timestamp", &s.Timestamp)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &s.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageAsyncOperationInitiatedEventData.
func (s StorageAsyncOperationInitiatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "api", s.API)
	populate(objectMap, "blobType", s.BlobType)
	populate(objectMap, "clientRequestId", s.ClientRequestID)
	populate(objectMap, "contentLength", s.ContentLength)
	populate(objectMap, "contentType", s.ContentType)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "requestId", s.RequestID)
	populate(objectMap, "sequencer", s.Sequencer)
	populateAny(objectMap, "storageDiagnostics", s.StorageDiagnostics)
	populate(objectMap, "url", s.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageAsyncOperationInitiatedEventData.
func (s *StorageAsyncOperationInitiatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "api":
			err = unpopulate(val, "API", &s.API)
			delete(rawMsg, key)
		case "blobType":
			err = unpopulate(val, "BlobType", &s.BlobType)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &s.ClientRequestID)
			delete(rawMsg, key)
		case "contentLength":
			err = unpopulate(val, "ContentLength", &s.ContentLength)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &s.ContentType)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &s.RequestID)
			delete(rawMsg, key)
		case "sequencer":
			err = unpopulate(val, "Sequencer", &s.Sequencer)
			delete(rawMsg, key)
		case "storageDiagnostics":
			err = unpopulate(val, "StorageDiagnostics", &s.StorageDiagnostics)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &s.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageBlobCreatedEventData.
func (s StorageBlobCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "api", s.API)
	populate(objectMap, "blobType", s.BlobType)
	populate(objectMap, "clientRequestId", s.ClientRequestID)
	populate(objectMap, "contentLength", s.ContentLength)
	populate(objectMap, "contentOffset", s.ContentOffset)
	populate(objectMap, "contentType", s.ContentType)
	populate(objectMap, "eTag", s.ETag)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "requestId", s.RequestID)
	populate(objectMap, "sequencer", s.Sequencer)
	populateAny(objectMap, "storageDiagnostics", s.StorageDiagnostics)
	populate(objectMap, "url", s.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageBlobCreatedEventData.
func (s *StorageBlobCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "api":
			err = unpopulate(val, "API", &s.API)
			delete(rawMsg, key)
		case "blobType":
			err = unpopulate(val, "BlobType", &s.BlobType)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &s.ClientRequestID)
			delete(rawMsg, key)
		case "contentLength":
			err = unpopulate(val, "ContentLength", &s.ContentLength)
			delete(rawMsg, key)
		case "contentOffset":
			err = unpopulate(val, "ContentOffset", &s.ContentOffset)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &s.ContentType)
			delete(rawMsg, key)
		case "eTag":
			err = unpopulate(val, "ETag", &s.ETag)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &s.RequestID)
			delete(rawMsg, key)
		case "sequencer":
			err = unpopulate(val, "Sequencer", &s.Sequencer)
			delete(rawMsg, key)
		case "storageDiagnostics":
			err = unpopulate(val, "StorageDiagnostics", &s.StorageDiagnostics)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &s.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageBlobDeletedEventData.
func (s StorageBlobDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "api", s.API)
	populate(objectMap, "blobType", s.BlobType)
	populate(objectMap, "clientRequestId", s.ClientRequestID)
	populate(objectMap, "contentType", s.ContentType)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "requestId", s.RequestID)
	populate(objectMap, "sequencer", s.Sequencer)
	populateAny(objectMap, "storageDiagnostics", s.StorageDiagnostics)
	populate(objectMap, "url", s.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageBlobDeletedEventData.
func (s *StorageBlobDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "api":
			err = unpopulate(val, "API", &s.API)
			delete(rawMsg, key)
		case "blobType":
			err = unpopulate(val, "BlobType", &s.BlobType)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &s.ClientRequestID)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &s.ContentType)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &s.RequestID)
			delete(rawMsg, key)
		case "sequencer":
			err = unpopulate(val, "Sequencer", &s.Sequencer)
			delete(rawMsg, key)
		case "storageDiagnostics":
			err = unpopulate(val, "StorageDiagnostics", &s.StorageDiagnostics)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &s.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageBlobInventoryPolicyCompletedEventData.
func (s StorageBlobInventoryPolicyCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", s.AccountName)
	populate(objectMap, "manifestBlobUrl", s.ManifestBlobURL)
	populate(objectMap, "policyRunId", s.PolicyRunID)
	populate(objectMap, "policyRunStatus", s.PolicyRunStatus)
	populate(objectMap, "policyRunStatusMessage", s.PolicyRunStatusMessage)
	populate(objectMap, "ruleName", s.RuleName)
	populateDateTimeRFC3339(objectMap, "scheduleDateTime", s.ScheduleDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageBlobInventoryPolicyCompletedEventData.
func (s *StorageBlobInventoryPolicyCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &s.AccountName)
			delete(rawMsg, key)
		case "manifestBlobUrl":
			err = unpopulate(val, "ManifestBlobURL", &s.ManifestBlobURL)
			delete(rawMsg, key)
		case "policyRunId":
			err = unpopulate(val, "PolicyRunID", &s.PolicyRunID)
			delete(rawMsg, key)
		case "policyRunStatus":
			err = unpopulate(val, "PolicyRunStatus", &s.PolicyRunStatus)
			delete(rawMsg, key)
		case "policyRunStatusMessage":
			err = unpopulate(val, "PolicyRunStatusMessage", &s.PolicyRunStatusMessage)
			delete(rawMsg, key)
		case "ruleName":
			err = unpopulate(val, "RuleName", &s.RuleName)
			delete(rawMsg, key)
		case "scheduleDateTime":
			err = unpopulateDateTimeRFC3339(val, "ScheduleDateTime", &s.ScheduleDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageBlobRenamedEventData.
func (s StorageBlobRenamedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "api", s.API)
	populate(objectMap, "clientRequestId", s.ClientRequestID)
	populate(objectMap, "destinationUrl", s.DestinationURL)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "requestId", s.RequestID)
	populate(objectMap, "sequencer", s.Sequencer)
	populate(objectMap, "sourceUrl", s.SourceURL)
	populateAny(objectMap, "storageDiagnostics", s.StorageDiagnostics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageBlobRenamedEventData.
func (s *StorageBlobRenamedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "api":
			err = unpopulate(val, "API", &s.API)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &s.ClientRequestID)
			delete(rawMsg, key)
		case "destinationUrl":
			err = unpopulate(val, "DestinationURL", &s.DestinationURL)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &s.RequestID)
			delete(rawMsg, key)
		case "sequencer":
			err = unpopulate(val, "Sequencer", &s.Sequencer)
			delete(rawMsg, key)
		case "sourceUrl":
			err = unpopulate(val, "SourceURL", &s.SourceURL)
			delete(rawMsg, key)
		case "storageDiagnostics":
			err = unpopulate(val, "StorageDiagnostics", &s.StorageDiagnostics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageBlobTierChangedEventData.
func (s StorageBlobTierChangedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "api", s.API)
	populate(objectMap, "blobType", s.BlobType)
	populate(objectMap, "clientRequestId", s.ClientRequestID)
	populate(objectMap, "contentLength", s.ContentLength)
	populate(objectMap, "contentType", s.ContentType)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "requestId", s.RequestID)
	populate(objectMap, "sequencer", s.Sequencer)
	populateAny(objectMap, "storageDiagnostics", s.StorageDiagnostics)
	populate(objectMap, "url", s.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageBlobTierChangedEventData.
func (s *StorageBlobTierChangedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "api":
			err = unpopulate(val, "API", &s.API)
			delete(rawMsg, key)
		case "blobType":
			err = unpopulate(val, "BlobType", &s.BlobType)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &s.ClientRequestID)
			delete(rawMsg, key)
		case "contentLength":
			err = unpopulate(val, "ContentLength", &s.ContentLength)
			delete(rawMsg, key)
		case "contentType":
			err = unpopulate(val, "ContentType", &s.ContentType)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &s.RequestID)
			delete(rawMsg, key)
		case "sequencer":
			err = unpopulate(val, "Sequencer", &s.Sequencer)
			delete(rawMsg, key)
		case "storageDiagnostics":
			err = unpopulate(val, "StorageDiagnostics", &s.StorageDiagnostics)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &s.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageDirectoryCreatedEventData.
func (s StorageDirectoryCreatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "api", s.API)
	populate(objectMap, "clientRequestId", s.ClientRequestID)
	populate(objectMap, "eTag", s.ETag)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "requestId", s.RequestID)
	populate(objectMap, "sequencer", s.Sequencer)
	populateAny(objectMap, "storageDiagnostics", s.StorageDiagnostics)
	populate(objectMap, "url", s.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageDirectoryCreatedEventData.
func (s *StorageDirectoryCreatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "api":
			err = unpopulate(val, "API", &s.API)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &s.ClientRequestID)
			delete(rawMsg, key)
		case "eTag":
			err = unpopulate(val, "ETag", &s.ETag)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &s.RequestID)
			delete(rawMsg, key)
		case "sequencer":
			err = unpopulate(val, "Sequencer", &s.Sequencer)
			delete(rawMsg, key)
		case "storageDiagnostics":
			err = unpopulate(val, "StorageDiagnostics", &s.StorageDiagnostics)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &s.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageDirectoryDeletedEventData.
func (s StorageDirectoryDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "api", s.API)
	populate(objectMap, "clientRequestId", s.ClientRequestID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "recursive", s.Recursive)
	populate(objectMap, "requestId", s.RequestID)
	populate(objectMap, "sequencer", s.Sequencer)
	populateAny(objectMap, "storageDiagnostics", s.StorageDiagnostics)
	populate(objectMap, "url", s.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageDirectoryDeletedEventData.
func (s *StorageDirectoryDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "api":
			err = unpopulate(val, "API", &s.API)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &s.ClientRequestID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &s.Recursive)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &s.RequestID)
			delete(rawMsg, key)
		case "sequencer":
			err = unpopulate(val, "Sequencer", &s.Sequencer)
			delete(rawMsg, key)
		case "storageDiagnostics":
			err = unpopulate(val, "StorageDiagnostics", &s.StorageDiagnostics)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &s.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageDirectoryRenamedEventData.
func (s StorageDirectoryRenamedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "api", s.API)
	populate(objectMap, "clientRequestId", s.ClientRequestID)
	populate(objectMap, "destinationUrl", s.DestinationURL)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "requestId", s.RequestID)
	populate(objectMap, "sequencer", s.Sequencer)
	populate(objectMap, "sourceUrl", s.SourceURL)
	populateAny(objectMap, "storageDiagnostics", s.StorageDiagnostics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageDirectoryRenamedEventData.
func (s *StorageDirectoryRenamedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "api":
			err = unpopulate(val, "API", &s.API)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &s.ClientRequestID)
			delete(rawMsg, key)
		case "destinationUrl":
			err = unpopulate(val, "DestinationURL", &s.DestinationURL)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &s.RequestID)
			delete(rawMsg, key)
		case "sequencer":
			err = unpopulate(val, "Sequencer", &s.Sequencer)
			delete(rawMsg, key)
		case "sourceUrl":
			err = unpopulate(val, "SourceURL", &s.SourceURL)
			delete(rawMsg, key)
		case "storageDiagnostics":
			err = unpopulate(val, "StorageDiagnostics", &s.StorageDiagnostics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageLifecyclePolicyActionSummaryDetail.
func (s StorageLifecyclePolicyActionSummaryDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorList", s.ErrorList)
	populate(objectMap, "successCount", s.SuccessCount)
	populate(objectMap, "totalObjectsCount", s.TotalObjectsCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageLifecyclePolicyActionSummaryDetail.
func (s *StorageLifecyclePolicyActionSummaryDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorList":
			err = unpopulate(val, "ErrorList", &s.ErrorList)
			delete(rawMsg, key)
		case "successCount":
			err = unpopulate(val, "SuccessCount", &s.SuccessCount)
			delete(rawMsg, key)
		case "totalObjectsCount":
			err = unpopulate(val, "TotalObjectsCount", &s.TotalObjectsCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageLifecyclePolicyCompletedEventData.
func (s StorageLifecyclePolicyCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deleteSummary", s.DeleteSummary)
	populate(objectMap, "scheduleTime", s.ScheduleTime)
	populate(objectMap, "tierToArchiveSummary", s.TierToArchiveSummary)
	populate(objectMap, "tierToCoolSummary", s.TierToCoolSummary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageLifecyclePolicyCompletedEventData.
func (s *StorageLifecyclePolicyCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteSummary":
			err = unpopulate(val, "DeleteSummary", &s.DeleteSummary)
			delete(rawMsg, key)
		case "scheduleTime":
			err = unpopulate(val, "ScheduleTime", &s.ScheduleTime)
			delete(rawMsg, key)
		case "tierToArchiveSummary":
			err = unpopulate(val, "TierToArchiveSummary", &s.TierToArchiveSummary)
			delete(rawMsg, key)
		case "tierToCoolSummary":
			err = unpopulate(val, "TierToCoolSummary", &s.TierToCoolSummary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageTaskAssignmentCompletedEventData.
func (s StorageTaskAssignmentCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "completedDateTime", s.CompletedOn)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "summaryReportBlobUrl", s.SummaryReportBlobURI)
	populate(objectMap, "taskExecutionId", s.TaskExecutionID)
	populate(objectMap, "taskName", s.TaskName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageTaskAssignmentCompletedEventData.
func (s *StorageTaskAssignmentCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completedDateTime":
			err = unpopulateDateTimeRFC3339(val, "CompletedOn", &s.CompletedOn)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "summaryReportBlobUrl":
			err = unpopulate(val, "SummaryReportBlobURI", &s.SummaryReportBlobURI)
			delete(rawMsg, key)
		case "taskExecutionId":
			err = unpopulate(val, "TaskExecutionID", &s.TaskExecutionID)
			delete(rawMsg, key)
		case "taskName":
			err = unpopulate(val, "TaskName", &s.TaskName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageTaskAssignmentQueuedEventData.
func (s StorageTaskAssignmentQueuedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "queuedDateTime", s.QueuedOn)
	populate(objectMap, "taskExecutionId", s.TaskExecutionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageTaskAssignmentQueuedEventData.
func (s *StorageTaskAssignmentQueuedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "queuedDateTime":
			err = unpopulateDateTimeRFC3339(val, "QueuedOn", &s.QueuedOn)
			delete(rawMsg, key)
		case "taskExecutionId":
			err = unpopulate(val, "TaskExecutionID", &s.TaskExecutionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageTaskCompletedEventData.
func (s StorageTaskCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "completedDateTime", s.CompletedDateTime)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "summaryReportBlobUrl", s.SummaryReportBlobURL)
	populate(objectMap, "taskExecutionId", s.TaskExecutionID)
	populate(objectMap, "taskName", s.TaskName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageTaskCompletedEventData.
func (s *StorageTaskCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "completedDateTime":
			err = unpopulateDateTimeRFC3339(val, "CompletedDateTime", &s.CompletedDateTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "summaryReportBlobUrl":
			err = unpopulate(val, "SummaryReportBlobURL", &s.SummaryReportBlobURL)
			delete(rawMsg, key)
		case "taskExecutionId":
			err = unpopulate(val, "TaskExecutionID", &s.TaskExecutionID)
			delete(rawMsg, key)
		case "taskName":
			err = unpopulate(val, "TaskName", &s.TaskName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageTaskQueuedEventData.
func (s StorageTaskQueuedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "queuedDateTime", s.QueuedDateTime)
	populate(objectMap, "taskExecutionId", s.TaskExecutionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageTaskQueuedEventData.
func (s *StorageTaskQueuedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "queuedDateTime":
			err = unpopulateDateTimeRFC3339(val, "QueuedDateTime", &s.QueuedDateTime)
			delete(rawMsg, key)
		case "taskExecutionId":
			err = unpopulate(val, "TaskExecutionID", &s.TaskExecutionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionDeletedEventData.
func (s SubscriptionDeletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eventSubscriptionId", s.EventSubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionDeletedEventData.
func (s *SubscriptionDeletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eventSubscriptionId":
			err = unpopulate(val, "EventSubscriptionID", &s.EventSubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionValidationEventData.
func (s SubscriptionValidationEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "validationCode", s.ValidationCode)
	populate(objectMap, "validationUrl", s.ValidationURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionValidationEventData.
func (s *SubscriptionValidationEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "validationCode":
			err = unpopulate(val, "ValidationCode", &s.ValidationCode)
			delete(rawMsg, key)
		case "validationUrl":
			err = unpopulate(val, "ValidationURL", &s.ValidationURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionValidationResponse.
func (s SubscriptionValidationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "validationResponse", s.ValidationResponse)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionValidationResponse.
func (s *SubscriptionValidationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "validationResponse":
			err = unpopulate(val, "ValidationResponse", &s.ValidationResponse)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppServicePlanUpdatedEventData.
func (w WebAppServicePlanUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", w.Address)
	populate(objectMap, "appServicePlanEventTypeDetail", w.AppServicePlanEventTypeDetail)
	populate(objectMap, "clientRequestId", w.ClientRequestID)
	populate(objectMap, "correlationRequestId", w.CorrelationRequestID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "requestId", w.RequestID)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "verb", w.Verb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppServicePlanUpdatedEventData.
func (w *WebAppServicePlanUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &w.Address)
			delete(rawMsg, key)
		case "appServicePlanEventTypeDetail":
			err = unpopulate(val, "AppServicePlanEventTypeDetail", &w.AppServicePlanEventTypeDetail)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &w.ClientRequestID)
			delete(rawMsg, key)
		case "correlationRequestId":
			err = unpopulate(val, "CorrelationRequestID", &w.CorrelationRequestID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &w.RequestID)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &w.SKU)
			delete(rawMsg, key)
		case "verb":
			err = unpopulate(val, "Verb", &w.Verb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppServicePlanUpdatedEventDataSKU.
func (w WebAppServicePlanUpdatedEventDataSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "Capacity", w.Capacity)
	populate(objectMap, "Family", w.Family)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "Size", w.Size)
	populate(objectMap, "Tier", w.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppServicePlanUpdatedEventDataSKU.
func (w *WebAppServicePlanUpdatedEventDataSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "Capacity":
			err = unpopulate(val, "Capacity", &w.Capacity)
			delete(rawMsg, key)
		case "Family":
			err = unpopulate(val, "Family", &w.Family)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "Size":
			err = unpopulate(val, "Size", &w.Size)
			delete(rawMsg, key)
		case "Tier":
			err = unpopulate(val, "Tier", &w.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebAppUpdatedEventData.
func (w WebAppUpdatedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", w.Address)
	populate(objectMap, "appEventTypeDetail", w.AppEventTypeDetail)
	populate(objectMap, "clientRequestId", w.ClientRequestID)
	populate(objectMap, "correlationRequestId", w.CorrelationRequestID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "requestId", w.RequestID)
	populate(objectMap, "verb", w.Verb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppUpdatedEventData.
func (w *WebAppUpdatedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &w.Address)
			delete(rawMsg, key)
		case "appEventTypeDetail":
			err = unpopulate(val, "AppEventTypeDetail", &w.AppEventTypeDetail)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &w.ClientRequestID)
			delete(rawMsg, key)
		case "correlationRequestId":
			err = unpopulate(val, "CorrelationRequestID", &w.CorrelationRequestID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &w.RequestID)
			delete(rawMsg, key)
		case "verb":
			err = unpopulate(val, "Verb", &w.Verb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebBackupOperationCompletedEventData.
func (w WebBackupOperationCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", w.Address)
	populate(objectMap, "appEventTypeDetail", w.AppEventTypeDetail)
	populate(objectMap, "clientRequestId", w.ClientRequestID)
	populate(objectMap, "correlationRequestId", w.CorrelationRequestID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "requestId", w.RequestID)
	populate(objectMap, "verb", w.Verb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebBackupOperationCompletedEventData.
func (w *WebBackupOperationCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &w.Address)
			delete(rawMsg, key)
		case "appEventTypeDetail":
			err = unpopulate(val, "AppEventTypeDetail", &w.AppEventTypeDetail)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &w.ClientRequestID)
			delete(rawMsg, key)
		case "correlationRequestId":
			err = unpopulate(val, "CorrelationRequestID", &w.CorrelationRequestID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &w.RequestID)
			delete(rawMsg, key)
		case "verb":
			err = unpopulate(val, "Verb", &w.Verb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebBackupOperationFailedEventData.
func (w WebBackupOperationFailedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", w.Address)
	populate(objectMap, "appEventTypeDetail", w.AppEventTypeDetail)
	populate(objectMap, "clientRequestId", w.ClientRequestID)
	populate(objectMap, "correlationRequestId", w.CorrelationRequestID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "requestId", w.RequestID)
	populate(objectMap, "verb", w.Verb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebBackupOperationFailedEventData.
func (w *WebBackupOperationFailedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &w.Address)
			delete(rawMsg, key)
		case "appEventTypeDetail":
			err = unpopulate(val, "AppEventTypeDetail", &w.AppEventTypeDetail)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &w.ClientRequestID)
			delete(rawMsg, key)
		case "correlationRequestId":
			err = unpopulate(val, "CorrelationRequestID", &w.CorrelationRequestID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &w.RequestID)
			delete(rawMsg, key)
		case "verb":
			err = unpopulate(val, "Verb", &w.Verb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebBackupOperationStartedEventData.
func (w WebBackupOperationStartedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", w.Address)
	populate(objectMap, "appEventTypeDetail", w.AppEventTypeDetail)
	populate(objectMap, "clientRequestId", w.ClientRequestID)
	populate(objectMap, "correlationRequestId", w.CorrelationRequestID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "requestId", w.RequestID)
	populate(objectMap, "verb", w.Verb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebBackupOperationStartedEventData.
func (w *WebBackupOperationStartedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &w.Address)
			delete(rawMsg, key)
		case "appEventTypeDetail":
			err = unpopulate(val, "AppEventTypeDetail", &w.AppEventTypeDetail)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &w.ClientRequestID)
			delete(rawMsg, key)
		case "correlationRequestId":
			err = unpopulate(val, "CorrelationRequestID", &w.CorrelationRequestID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &w.RequestID)
			delete(rawMsg, key)
		case "verb":
			err = unpopulate(val, "Verb", &w.Verb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebRestoreOperationCompletedEventData.
func (w WebRestoreOperationCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", w.Address)
	populate(objectMap, "appEventTypeDetail", w.AppEventTypeDetail)
	populate(objectMap, "clientRequestId", w.ClientRequestID)
	populate(objectMap, "correlationRequestId", w.CorrelationRequestID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "requestId", w.RequestID)
	populate(objectMap, "verb", w.Verb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebRestoreOperationCompletedEventData.
func (w *WebRestoreOperationCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &w.Address)
			delete(rawMsg, key)
		case "appEventTypeDetail":
			err = unpopulate(val, "AppEventTypeDetail", &w.AppEventTypeDetail)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &w.ClientRequestID)
			delete(rawMsg, key)
		case "correlationRequestId":
			err = unpopulate(val, "CorrelationRequestID", &w.CorrelationRequestID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &w.RequestID)
			delete(rawMsg, key)
		case "verb":
			err = unpopulate(val, "Verb", &w.Verb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebRestoreOperationFailedEventData.
func (w WebRestoreOperationFailedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", w.Address)
	populate(objectMap, "appEventTypeDetail", w.AppEventTypeDetail)
	populate(objectMap, "clientRequestId", w.ClientRequestID)
	populate(objectMap, "correlationRequestId", w.CorrelationRequestID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "requestId", w.RequestID)
	populate(objectMap, "verb", w.Verb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebRestoreOperationFailedEventData.
func (w *WebRestoreOperationFailedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &w.Address)
			delete(rawMsg, key)
		case "appEventTypeDetail":
			err = unpopulate(val, "AppEventTypeDetail", &w.AppEventTypeDetail)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &w.ClientRequestID)
			delete(rawMsg, key)
		case "correlationRequestId":
			err = unpopulate(val, "CorrelationRequestID", &w.CorrelationRequestID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &w.RequestID)
			delete(rawMsg, key)
		case "verb":
			err = unpopulate(val, "Verb", &w.Verb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebRestoreOperationStartedEventData.
func (w WebRestoreOperationStartedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", w.Address)
	populate(objectMap, "appEventTypeDetail", w.AppEventTypeDetail)
	populate(objectMap, "clientRequestId", w.ClientRequestID)
	populate(objectMap, "correlationRequestId", w.CorrelationRequestID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "requestId", w.RequestID)
	populate(objectMap, "verb", w.Verb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebRestoreOperationStartedEventData.
func (w *WebRestoreOperationStartedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &w.Address)
			delete(rawMsg, key)
		case "appEventTypeDetail":
			err = unpopulate(val, "AppEventTypeDetail", &w.AppEventTypeDetail)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &w.ClientRequestID)
			delete(rawMsg, key)
		case "correlationRequestId":
			err = unpopulate(val, "CorrelationRequestID", &w.CorrelationRequestID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &w.RequestID)
			delete(rawMsg, key)
		case "verb":
			err = unpopulate(val, "Verb", &w.Verb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebSlotSwapCompletedEventData.
func (w WebSlotSwapCompletedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", w.Address)
	populate(objectMap, "appEventTypeDetail", w.AppEventTypeDetail)
	populate(objectMap, "clientRequestId", w.ClientRequestID)
	populate(objectMap, "correlationRequestId", w.CorrelationRequestID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "requestId", w.RequestID)
	populate(objectMap, "verb", w.Verb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebSlotSwapCompletedEventData.
func (w *WebSlotSwapCompletedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &w.Address)
			delete(rawMsg, key)
		case "appEventTypeDetail":
			err = unpopulate(val, "AppEventTypeDetail", &w.AppEventTypeDetail)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &w.ClientRequestID)
			delete(rawMsg, key)
		case "correlationRequestId":
			err = unpopulate(val, "CorrelationRequestID", &w.CorrelationRequestID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &w.RequestID)
			delete(rawMsg, key)
		case "verb":
			err = unpopulate(val, "Verb", &w.Verb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebSlotSwapFailedEventData.
func (w WebSlotSwapFailedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", w.Address)
	populate(objectMap, "appEventTypeDetail", w.AppEventTypeDetail)
	populate(objectMap, "clientRequestId", w.ClientRequestID)
	populate(objectMap, "correlationRequestId", w.CorrelationRequestID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "requestId", w.RequestID)
	populate(objectMap, "verb", w.Verb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebSlotSwapFailedEventData.
func (w *WebSlotSwapFailedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &w.Address)
			delete(rawMsg, key)
		case "appEventTypeDetail":
			err = unpopulate(val, "AppEventTypeDetail", &w.AppEventTypeDetail)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &w.ClientRequestID)
			delete(rawMsg, key)
		case "correlationRequestId":
			err = unpopulate(val, "CorrelationRequestID", &w.CorrelationRequestID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &w.RequestID)
			delete(rawMsg, key)
		case "verb":
			err = unpopulate(val, "Verb", &w.Verb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebSlotSwapStartedEventData.
func (w WebSlotSwapStartedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", w.Address)
	populate(objectMap, "appEventTypeDetail", w.AppEventTypeDetail)
	populate(objectMap, "clientRequestId", w.ClientRequestID)
	populate(objectMap, "correlationRequestId", w.CorrelationRequestID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "requestId", w.RequestID)
	populate(objectMap, "verb", w.Verb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebSlotSwapStartedEventData.
func (w *WebSlotSwapStartedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &w.Address)
			delete(rawMsg, key)
		case "appEventTypeDetail":
			err = unpopulate(val, "AppEventTypeDetail", &w.AppEventTypeDetail)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &w.ClientRequestID)
			delete(rawMsg, key)
		case "correlationRequestId":
			err = unpopulate(val, "CorrelationRequestID", &w.CorrelationRequestID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &w.RequestID)
			delete(rawMsg, key)
		case "verb":
			err = unpopulate(val, "Verb", &w.Verb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebSlotSwapWithPreviewCancelledEventData.
func (w WebSlotSwapWithPreviewCancelledEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", w.Address)
	populate(objectMap, "appEventTypeDetail", w.AppEventTypeDetail)
	populate(objectMap, "clientRequestId", w.ClientRequestID)
	populate(objectMap, "correlationRequestId", w.CorrelationRequestID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "requestId", w.RequestID)
	populate(objectMap, "verb", w.Verb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebSlotSwapWithPreviewCancelledEventData.
func (w *WebSlotSwapWithPreviewCancelledEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &w.Address)
			delete(rawMsg, key)
		case "appEventTypeDetail":
			err = unpopulate(val, "AppEventTypeDetail", &w.AppEventTypeDetail)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &w.ClientRequestID)
			delete(rawMsg, key)
		case "correlationRequestId":
			err = unpopulate(val, "CorrelationRequestID", &w.CorrelationRequestID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &w.RequestID)
			delete(rawMsg, key)
		case "verb":
			err = unpopulate(val, "Verb", &w.Verb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebSlotSwapWithPreviewStartedEventData.
func (w WebSlotSwapWithPreviewStartedEventData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", w.Address)
	populate(objectMap, "appEventTypeDetail", w.AppEventTypeDetail)
	populate(objectMap, "clientRequestId", w.ClientRequestID)
	populate(objectMap, "correlationRequestId", w.CorrelationRequestID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "requestId", w.RequestID)
	populate(objectMap, "verb", w.Verb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebSlotSwapWithPreviewStartedEventData.
func (w *WebSlotSwapWithPreviewStartedEventData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &w.Address)
			delete(rawMsg, key)
		case "appEventTypeDetail":
			err = unpopulate(val, "AppEventTypeDetail", &w.AppEventTypeDetail)
			delete(rawMsg, key)
		case "clientRequestId":
			err = unpopulate(val, "ClientRequestID", &w.ClientRequestID)
			delete(rawMsg, key)
		case "correlationRequestId":
			err = unpopulate(val, "CorrelationRequestID", &w.CorrelationRequestID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "requestId":
			err = unpopulate(val, "RequestID", &w.RequestID)
			delete(rawMsg, key)
		case "verb":
			err = unpopulate(val, "Verb", &w.Verb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
