//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appcomplianceautomation/armappcomplianceautomation"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// SnapshotsServer is a fake server for instances of the armappcomplianceautomation.SnapshotsClient type.
type SnapshotsServer struct {
	// NewListPager is the fake for method SnapshotsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(reportName string, options *armappcomplianceautomation.SnapshotsClientListOptions) (resp azfake.PagerResponder[armappcomplianceautomation.SnapshotsClientListResponse])
}

// NewSnapshotsServerTransport creates a new instance of SnapshotsServerTransport with the provided implementation.
// The returned SnapshotsServerTransport instance is connected to an instance of armappcomplianceautomation.SnapshotsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSnapshotsServerTransport(srv *SnapshotsServer) *SnapshotsServerTransport {
	return &SnapshotsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armappcomplianceautomation.SnapshotsClientListResponse]](),
	}
}

// SnapshotsServerTransport connects instances of armappcomplianceautomation.SnapshotsClient to instances of SnapshotsServer.
// Don't use this type directly, use NewSnapshotsServerTransport instead.
type SnapshotsServerTransport struct {
	srv          *SnapshotsServer
	newListPager *tracker[azfake.PagerResponder[armappcomplianceautomation.SnapshotsClientListResponse]]
}

// Do implements the policy.Transporter interface for SnapshotsServerTransport.
func (s *SnapshotsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SnapshotsClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SnapshotsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/providers/Microsoft\.AppComplianceAutomation/reports/(?P<reportName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/snapshots`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		reportNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("reportName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		selectUnescaped, err := url.QueryUnescape(qp.Get("$select"))
		if err != nil {
			return nil, err
		}
		selectParam := getOptional(selectUnescaped)
		reportCreatorTenantIDUnescaped, err := url.QueryUnescape(qp.Get("reportCreatorTenantId"))
		if err != nil {
			return nil, err
		}
		reportCreatorTenantIDParam := getOptional(reportCreatorTenantIDUnescaped)
		offerGUIDUnescaped, err := url.QueryUnescape(qp.Get("offerGuid"))
		if err != nil {
			return nil, err
		}
		offerGUIDParam := getOptional(offerGUIDUnescaped)
		var options *armappcomplianceautomation.SnapshotsClientListOptions
		if skipTokenParam != nil || topParam != nil || selectParam != nil || reportCreatorTenantIDParam != nil || offerGUIDParam != nil {
			options = &armappcomplianceautomation.SnapshotsClientListOptions{
				SkipToken:             skipTokenParam,
				Top:                   topParam,
				Select:                selectParam,
				ReportCreatorTenantID: reportCreatorTenantIDParam,
				OfferGUID:             offerGUIDParam,
			}
		}
		resp := s.srv.NewListPager(reportNameParam, options)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappcomplianceautomation.SnapshotsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}
