//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
	"net/http"
	"net/url"
	"regexp"
)

// SoftwareUpdateConfigurationsServer is a fake server for instances of the armautomation.SoftwareUpdateConfigurationsClient type.
type SoftwareUpdateConfigurationsServer struct {
	// Create is the fake for method SoftwareUpdateConfigurationsClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, automationAccountName string, softwareUpdateConfigurationName string, parameters armautomation.SoftwareUpdateConfiguration, options *armautomation.SoftwareUpdateConfigurationsClientCreateOptions) (resp azfake.Responder[armautomation.SoftwareUpdateConfigurationsClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method SoftwareUpdateConfigurationsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, automationAccountName string, softwareUpdateConfigurationName string, options *armautomation.SoftwareUpdateConfigurationsClientDeleteOptions) (resp azfake.Responder[armautomation.SoftwareUpdateConfigurationsClientDeleteResponse], errResp azfake.ErrorResponder)

	// GetByName is the fake for method SoftwareUpdateConfigurationsClient.GetByName
	// HTTP status codes to indicate success: http.StatusOK
	GetByName func(ctx context.Context, resourceGroupName string, automationAccountName string, softwareUpdateConfigurationName string, options *armautomation.SoftwareUpdateConfigurationsClientGetByNameOptions) (resp azfake.Responder[armautomation.SoftwareUpdateConfigurationsClientGetByNameResponse], errResp azfake.ErrorResponder)

	// List is the fake for method SoftwareUpdateConfigurationsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, automationAccountName string, options *armautomation.SoftwareUpdateConfigurationsClientListOptions) (resp azfake.Responder[armautomation.SoftwareUpdateConfigurationsClientListResponse], errResp azfake.ErrorResponder)
}

// NewSoftwareUpdateConfigurationsServerTransport creates a new instance of SoftwareUpdateConfigurationsServerTransport with the provided implementation.
// The returned SoftwareUpdateConfigurationsServerTransport instance is connected to an instance of armautomation.SoftwareUpdateConfigurationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSoftwareUpdateConfigurationsServerTransport(srv *SoftwareUpdateConfigurationsServer) *SoftwareUpdateConfigurationsServerTransport {
	return &SoftwareUpdateConfigurationsServerTransport{srv: srv}
}

// SoftwareUpdateConfigurationsServerTransport connects instances of armautomation.SoftwareUpdateConfigurationsClient to instances of SoftwareUpdateConfigurationsServer.
// Don't use this type directly, use NewSoftwareUpdateConfigurationsServerTransport instead.
type SoftwareUpdateConfigurationsServerTransport struct {
	srv *SoftwareUpdateConfigurationsServer
}

// Do implements the policy.Transporter interface for SoftwareUpdateConfigurationsServerTransport.
func (s *SoftwareUpdateConfigurationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SoftwareUpdateConfigurationsClient.Create":
		resp, err = s.dispatchCreate(req)
	case "SoftwareUpdateConfigurationsClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "SoftwareUpdateConfigurationsClient.GetByName":
		resp, err = s.dispatchGetByName(req)
	case "SoftwareUpdateConfigurationsClient.List":
		resp, err = s.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SoftwareUpdateConfigurationsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if s.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/softwareUpdateConfigurations/(?P<softwareUpdateConfigurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armautomation.SoftwareUpdateConfiguration](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	softwareUpdateConfigurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("softwareUpdateConfigurationName")])
	if err != nil {
		return nil, err
	}
	clientRequestIDParam := getOptional(getHeaderValue(req.Header, "clientRequestId"))
	var options *armautomation.SoftwareUpdateConfigurationsClientCreateOptions
	if clientRequestIDParam != nil {
		options = &armautomation.SoftwareUpdateConfigurationsClientCreateOptions{
			ClientRequestID: clientRequestIDParam,
		}
	}
	respr, errRespr := s.srv.Create(req.Context(), resourceGroupNameParam, automationAccountNameParam, softwareUpdateConfigurationNameParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SoftwareUpdateConfiguration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SoftwareUpdateConfigurationsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/softwareUpdateConfigurations/(?P<softwareUpdateConfigurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	softwareUpdateConfigurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("softwareUpdateConfigurationName")])
	if err != nil {
		return nil, err
	}
	clientRequestIDParam := getOptional(getHeaderValue(req.Header, "clientRequestId"))
	var options *armautomation.SoftwareUpdateConfigurationsClientDeleteOptions
	if clientRequestIDParam != nil {
		options = &armautomation.SoftwareUpdateConfigurationsClientDeleteOptions{
			ClientRequestID: clientRequestIDParam,
		}
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, automationAccountNameParam, softwareUpdateConfigurationNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SoftwareUpdateConfigurationsServerTransport) dispatchGetByName(req *http.Request) (*http.Response, error) {
	if s.srv.GetByName == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByName not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/softwareUpdateConfigurations/(?P<softwareUpdateConfigurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	softwareUpdateConfigurationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("softwareUpdateConfigurationName")])
	if err != nil {
		return nil, err
	}
	clientRequestIDParam := getOptional(getHeaderValue(req.Header, "clientRequestId"))
	var options *armautomation.SoftwareUpdateConfigurationsClientGetByNameOptions
	if clientRequestIDParam != nil {
		options = &armautomation.SoftwareUpdateConfigurationsClientGetByNameOptions{
			ClientRequestID: clientRequestIDParam,
		}
	}
	respr, errRespr := s.srv.GetByName(req.Context(), resourceGroupNameParam, automationAccountNameParam, softwareUpdateConfigurationNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SoftwareUpdateConfiguration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SoftwareUpdateConfigurationsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if s.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Automation/automationAccounts/(?P<automationAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/softwareUpdateConfigurations`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	automationAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("automationAccountName")])
	if err != nil {
		return nil, err
	}
	clientRequestIDParam := getOptional(getHeaderValue(req.Header, "clientRequestId"))
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	var options *armautomation.SoftwareUpdateConfigurationsClientListOptions
	if clientRequestIDParam != nil || filterParam != nil {
		options = &armautomation.SoftwareUpdateConfigurationsClientListOptions{
			ClientRequestID: clientRequestIDParam,
			Filter:          filterParam,
		}
	}
	respr, errRespr := s.srv.List(req.Context(), resourceGroupNameParam, automationAccountNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SoftwareUpdateConfigurationListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
