//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armazurestackhci

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewGalleryImagesClient creates a new instance of GalleryImagesClient.
func (c *ClientFactory) NewGalleryImagesClient() *GalleryImagesClient {
	subClient, _ := NewGalleryImagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGuestAgentClient creates a new instance of GuestAgentClient.
func (c *ClientFactory) NewGuestAgentClient() *GuestAgentClient {
	subClient, _ := NewGuestAgentClient(c.credential, c.options)
	return subClient
}

// NewGuestAgentsClient creates a new instance of GuestAgentsClient.
func (c *ClientFactory) NewGuestAgentsClient() *GuestAgentsClient {
	subClient, _ := NewGuestAgentsClient(c.credential, c.options)
	return subClient
}

// NewHybridIdentityMetadataClient creates a new instance of HybridIdentityMetadataClient.
func (c *ClientFactory) NewHybridIdentityMetadataClient() *HybridIdentityMetadataClient {
	subClient, _ := NewHybridIdentityMetadataClient(c.credential, c.options)
	return subClient
}

// NewLogicalNetworksClient creates a new instance of LogicalNetworksClient.
func (c *ClientFactory) NewLogicalNetworksClient() *LogicalNetworksClient {
	subClient, _ := NewLogicalNetworksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMarketplaceGalleryImagesClient creates a new instance of MarketplaceGalleryImagesClient.
func (c *ClientFactory) NewMarketplaceGalleryImagesClient() *MarketplaceGalleryImagesClient {
	subClient, _ := NewMarketplaceGalleryImagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNetworkInterfacesClient creates a new instance of NetworkInterfacesClient.
func (c *ClientFactory) NewNetworkInterfacesClient() *NetworkInterfacesClient {
	subClient, _ := NewNetworkInterfacesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewStorageContainersClient creates a new instance of StorageContainersClient.
func (c *ClientFactory) NewStorageContainersClient() *StorageContainersClient {
	subClient, _ := NewStorageContainersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualHardDisksClient creates a new instance of VirtualHardDisksClient.
func (c *ClientFactory) NewVirtualHardDisksClient() *VirtualHardDisksClient {
	subClient, _ := NewVirtualHardDisksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineInstancesClient creates a new instance of VirtualMachineInstancesClient.
func (c *ClientFactory) NewVirtualMachineInstancesClient() *VirtualMachineInstancesClient {
	subClient, _ := NewVirtualMachineInstancesClient(c.credential, c.options)
	return subClient
}
