//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armblueprint_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/blueprint/armblueprint"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/f790e624d0d080b89d962a3bd19c65bc6a6b2f5e/specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/SealedBlueprint_Publish.json
func ExamplePublishedBlueprintsClient_Create_publishedManagementGroupBlueprintPublish() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblueprint.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewPublishedBlueprintsClient().Create(ctx, "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup", "simpleBlueprint", "v2", &armblueprint.PublishedBlueprintsClientCreateOptions{PublishedBlueprint: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/f790e624d0d080b89d962a3bd19c65bc6a6b2f5e/specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/SealedBlueprint_Publish.json
func ExamplePublishedBlueprintsClient_Create_publishedSubscriptionBlueprintPublish() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblueprint.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewPublishedBlueprintsClient().Create(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", "simpleBlueprint", "v2", &armblueprint.PublishedBlueprintsClientCreateOptions{PublishedBlueprint: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/f790e624d0d080b89d962a3bd19c65bc6a6b2f5e/specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/SealedBlueprint_Get.json
func ExamplePublishedBlueprintsClient_Get_publishedManagementGroupBlueprint() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblueprint.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPublishedBlueprintsClient().Get(ctx, "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup", "simpleBlueprint", "v2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PublishedBlueprint = armblueprint.PublishedBlueprint{
	// 	Name: to.Ptr("v2"),
	// 	Type: to.Ptr("Microsoft.Blueprint/blueprints/versions"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint"),
	// 	Properties: &armblueprint.PublishedBlueprintProperties{
	// 		Description: to.Ptr("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}"),
	// 		Parameters: map[string]*armblueprint.ParameterDefinition{
	// 			"costCenter": &armblueprint.ParameterDefinition{
	// 				Type: to.Ptr(armblueprint.TemplateParameterTypeString),
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					DisplayName: to.Ptr("force cost center tag for all resources under given subscription."),
	// 				},
	// 			},
	// 			"owners": &armblueprint.ParameterDefinition{
	// 				Type: to.Ptr(armblueprint.TemplateParameterTypeArray),
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					DisplayName: to.Ptr("assign owners to subscription along with blueprint assignment."),
	// 				},
	// 			},
	// 			"storageAccountType": &armblueprint.ParameterDefinition{
	// 				Type: to.Ptr(armblueprint.TemplateParameterTypeString),
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					DisplayName: to.Ptr("storage account type."),
	// 				},
	// 			},
	// 		},
	// 		ResourceGroups: map[string]*armblueprint.ResourceGroupDefinition{
	// 			"storageRG": &armblueprint.ResourceGroupDefinition{
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					Description: to.Ptr("Contains storageAccounts that collect all shoebox logs."),
	// 					DisplayName: to.Ptr("storage resource group"),
	// 				},
	// 			},
	// 		},
	// 		TargetScope: to.Ptr(armblueprint.BlueprintTargetScopeSubscription),
	// 		BlueprintName: to.Ptr("simpleBlueprint"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/f790e624d0d080b89d962a3bd19c65bc6a6b2f5e/specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/SealedBlueprint_Get.json
func ExamplePublishedBlueprintsClient_Get_publishedSubscriptionBlueprint() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblueprint.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPublishedBlueprintsClient().Get(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", "simpleBlueprint", "v2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PublishedBlueprint = armblueprint.PublishedBlueprint{
	// 	Name: to.Ptr("v2"),
	// 	Type: to.Ptr("Microsoft.Blueprint/blueprints/versions"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Blueprint/blueprints/simpleBlueprint"),
	// 	Properties: &armblueprint.PublishedBlueprintProperties{
	// 		Description: to.Ptr("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}"),
	// 		Parameters: map[string]*armblueprint.ParameterDefinition{
	// 			"costCenter": &armblueprint.ParameterDefinition{
	// 				Type: to.Ptr(armblueprint.TemplateParameterTypeString),
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					DisplayName: to.Ptr("force cost center tag for all resources under given subscription."),
	// 				},
	// 			},
	// 			"owners": &armblueprint.ParameterDefinition{
	// 				Type: to.Ptr(armblueprint.TemplateParameterTypeArray),
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					DisplayName: to.Ptr("assign owners to subscription along with blueprint assignment."),
	// 				},
	// 			},
	// 			"storageAccountType": &armblueprint.ParameterDefinition{
	// 				Type: to.Ptr(armblueprint.TemplateParameterTypeString),
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					DisplayName: to.Ptr("storage account type."),
	// 				},
	// 			},
	// 		},
	// 		ResourceGroups: map[string]*armblueprint.ResourceGroupDefinition{
	// 			"storageRG": &armblueprint.ResourceGroupDefinition{
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					Description: to.Ptr("Contains storageAccounts that collect all shoebox logs."),
	// 					DisplayName: to.Ptr("storage resource group"),
	// 				},
	// 			},
	// 		},
	// 		TargetScope: to.Ptr(armblueprint.BlueprintTargetScopeSubscription),
	// 		BlueprintName: to.Ptr("simpleBlueprint"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/f790e624d0d080b89d962a3bd19c65bc6a6b2f5e/specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/SealedBlueprint_Delete.json
func ExamplePublishedBlueprintsClient_Delete_publishedManagementGroupBlueprint() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblueprint.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPublishedBlueprintsClient().Delete(ctx, "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup", "simpleBlueprint", "v2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PublishedBlueprint = armblueprint.PublishedBlueprint{
	// 	Name: to.Ptr("v2"),
	// 	Type: to.Ptr("Microsoft.Blueprint/blueprints/versions"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint"),
	// 	Properties: &armblueprint.PublishedBlueprintProperties{
	// 		Description: to.Ptr("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}"),
	// 		Parameters: map[string]*armblueprint.ParameterDefinition{
	// 			"costCenter": &armblueprint.ParameterDefinition{
	// 				Type: to.Ptr(armblueprint.TemplateParameterTypeString),
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					DisplayName: to.Ptr("force cost center tag for all resources under given subscription."),
	// 				},
	// 			},
	// 			"owners": &armblueprint.ParameterDefinition{
	// 				Type: to.Ptr(armblueprint.TemplateParameterTypeArray),
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					DisplayName: to.Ptr("assign owners to subscription along with blueprint assignment."),
	// 				},
	// 			},
	// 			"storageAccountType": &armblueprint.ParameterDefinition{
	// 				Type: to.Ptr(armblueprint.TemplateParameterTypeString),
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					DisplayName: to.Ptr("storage account type."),
	// 				},
	// 			},
	// 		},
	// 		ResourceGroups: map[string]*armblueprint.ResourceGroupDefinition{
	// 			"storageRG": &armblueprint.ResourceGroupDefinition{
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					Description: to.Ptr("Contains storageAccounts that collect all shoebox logs."),
	// 					DisplayName: to.Ptr("storage resource group"),
	// 				},
	// 			},
	// 		},
	// 		TargetScope: to.Ptr(armblueprint.BlueprintTargetScopeSubscription),
	// 		BlueprintName: to.Ptr("simpleBlueprint"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/f790e624d0d080b89d962a3bd19c65bc6a6b2f5e/specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/SealedBlueprint_Delete.json
func ExamplePublishedBlueprintsClient_Delete_publishedSubscriptionBlueprint() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblueprint.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewPublishedBlueprintsClient().Delete(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", "simpleBlueprint", "v2", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.PublishedBlueprint = armblueprint.PublishedBlueprint{
	// 	Name: to.Ptr("v2"),
	// 	Type: to.Ptr("Microsoft.Blueprint/blueprints/versions"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Blueprint/blueprints/simpleBlueprint"),
	// 	Properties: &armblueprint.PublishedBlueprintProperties{
	// 		Description: to.Ptr("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}"),
	// 		Parameters: map[string]*armblueprint.ParameterDefinition{
	// 			"costCenter": &armblueprint.ParameterDefinition{
	// 				Type: to.Ptr(armblueprint.TemplateParameterTypeString),
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					DisplayName: to.Ptr("force cost center tag for all resources under given subscription."),
	// 				},
	// 			},
	// 			"owners": &armblueprint.ParameterDefinition{
	// 				Type: to.Ptr(armblueprint.TemplateParameterTypeArray),
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					DisplayName: to.Ptr("assign owners to subscription along with blueprint assignment."),
	// 				},
	// 			},
	// 			"storageAccountType": &armblueprint.ParameterDefinition{
	// 				Type: to.Ptr(armblueprint.TemplateParameterTypeString),
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					DisplayName: to.Ptr("storage account type."),
	// 				},
	// 			},
	// 		},
	// 		ResourceGroups: map[string]*armblueprint.ResourceGroupDefinition{
	// 			"storageRG": &armblueprint.ResourceGroupDefinition{
	// 				Metadata: &armblueprint.ParameterDefinitionMetadata{
	// 					Description: to.Ptr("Contains storageAccounts that collect all shoebox logs."),
	// 					DisplayName: to.Ptr("storage resource group"),
	// 				},
	// 			},
	// 		},
	// 		TargetScope: to.Ptr(armblueprint.BlueprintTargetScopeSubscription),
	// 		BlueprintName: to.Ptr("simpleBlueprint"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/f790e624d0d080b89d962a3bd19c65bc6a6b2f5e/specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/SealedBlueprint_List.json
func ExamplePublishedBlueprintsClient_NewListPager_publishedManagementGroupBlueprint() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblueprint.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPublishedBlueprintsClient().NewListPager("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup", "simpleBlueprint", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PublishedBlueprintList = armblueprint.PublishedBlueprintList{
		// 	Value: []*armblueprint.PublishedBlueprint{
		// 		{
		// 			Name: to.Ptr("v1"),
		// 			Type: to.Ptr("Microsoft.Blueprint/blueprints/versions"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/managementGroups/ContosoOnlineGroup/providers/Microsoft.Blueprint/blueprints/simpleBlueprint/versions/v1"),
		// 			Properties: &armblueprint.PublishedBlueprintProperties{
		// 				Description: to.Ptr("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}"),
		// 				Parameters: map[string]*armblueprint.ParameterDefinition{
		// 					"costCenter": &armblueprint.ParameterDefinition{
		// 						Type: to.Ptr(armblueprint.TemplateParameterTypeString),
		// 						Metadata: &armblueprint.ParameterDefinitionMetadata{
		// 							DisplayName: to.Ptr("force cost center tag for all resources under given subscription."),
		// 						},
		// 					},
		// 					"owners": &armblueprint.ParameterDefinition{
		// 						Type: to.Ptr(armblueprint.TemplateParameterTypeArray),
		// 						Metadata: &armblueprint.ParameterDefinitionMetadata{
		// 							DisplayName: to.Ptr("assign owners to subscription along with blueprint assignment."),
		// 						},
		// 					},
		// 					"storageAccountType": &armblueprint.ParameterDefinition{
		// 						Type: to.Ptr(armblueprint.TemplateParameterTypeString),
		// 						Metadata: &armblueprint.ParameterDefinitionMetadata{
		// 							DisplayName: to.Ptr("storage account type."),
		// 						},
		// 					},
		// 				},
		// 				ResourceGroups: map[string]*armblueprint.ResourceGroupDefinition{
		// 					"storageRG": &armblueprint.ResourceGroupDefinition{
		// 						Metadata: &armblueprint.ParameterDefinitionMetadata{
		// 							Description: to.Ptr("Contains storageAccounts that collect all shoebox logs."),
		// 							DisplayName: to.Ptr("storage resource group"),
		// 						},
		// 					},
		// 				},
		// 				TargetScope: to.Ptr(armblueprint.BlueprintTargetScopeSubscription),
		// 				BlueprintName: to.Ptr("simpleBlueprint"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/f790e624d0d080b89d962a3bd19c65bc6a6b2f5e/specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/SealedBlueprint_List.json
func ExamplePublishedBlueprintsClient_NewListPager_publishedSubscriptionBlueprint() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armblueprint.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPublishedBlueprintsClient().NewListPager("subscriptions/00000000-0000-0000-0000-000000000000", "simpleBlueprint", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PublishedBlueprintList = armblueprint.PublishedBlueprintList{
		// 	Value: []*armblueprint.PublishedBlueprint{
		// 		{
		// 			Name: to.Ptr("v1"),
		// 			Type: to.Ptr("Microsoft.Blueprint/blueprints/versions"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Blueprint/blueprints/simpleBlueprint/versions/v1"),
		// 			Properties: &armblueprint.PublishedBlueprintProperties{
		// 				Description: to.Ptr("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}"),
		// 				Parameters: map[string]*armblueprint.ParameterDefinition{
		// 					"costCenter": &armblueprint.ParameterDefinition{
		// 						Type: to.Ptr(armblueprint.TemplateParameterTypeString),
		// 						Metadata: &armblueprint.ParameterDefinitionMetadata{
		// 							DisplayName: to.Ptr("force cost center tag for all resources under given subscription."),
		// 						},
		// 					},
		// 					"owners": &armblueprint.ParameterDefinition{
		// 						Type: to.Ptr(armblueprint.TemplateParameterTypeArray),
		// 						Metadata: &armblueprint.ParameterDefinitionMetadata{
		// 							DisplayName: to.Ptr("assign owners to subscription along with blueprint assignment."),
		// 						},
		// 					},
		// 					"storageAccountType": &armblueprint.ParameterDefinition{
		// 						Type: to.Ptr(armblueprint.TemplateParameterTypeString),
		// 						Metadata: &armblueprint.ParameterDefinitionMetadata{
		// 							DisplayName: to.Ptr("storage account type."),
		// 						},
		// 					},
		// 				},
		// 				ResourceGroups: map[string]*armblueprint.ResourceGroupDefinition{
		// 					"storageRG": &armblueprint.ResourceGroupDefinition{
		// 						Metadata: &armblueprint.ParameterDefinitionMetadata{
		// 							Description: to.Ptr("Contains storageAccounts that collect all shoebox logs."),
		// 							DisplayName: to.Ptr("storage resource group"),
		// 						},
		// 					},
		// 				},
		// 				TargetScope: to.Ptr(armblueprint.BlueprintTargetScopeSubscription),
		// 				BlueprintName: to.Ptr("simpleBlueprint"),
		// 			},
		// 	}},
		// }
	}
}
