//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by Microsoft (R) AutoRest Code Generator.Changes may cause incorrect behavior and will be lost if the code
// is regenerated.
// Code generated by @autorest/go. DO NOT EDIT.

package armconnectedvmware

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// VMInstanceGuestAgentsClient contains the methods for the VMInstanceGuestAgents group.
// Don't use this type directly, use NewVMInstanceGuestAgentsClient() instead.
type VMInstanceGuestAgentsClient struct {
	internal *arm.Client
}

// NewVMInstanceGuestAgentsClient creates a new instance of VMInstanceGuestAgentsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewVMInstanceGuestAgentsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*VMInstanceGuestAgentsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &VMInstanceGuestAgentsClient{
		internal: cl,
	}
	return client, nil
}

// BeginCreate - Create Or Update GuestAgent.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - resourceURI - The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
//   - body - Request payload.
//   - options - VMInstanceGuestAgentsClientBeginCreateOptions contains the optional parameters for the VMInstanceGuestAgentsClient.BeginCreate
//     method.
func (client *VMInstanceGuestAgentsClient) BeginCreate(ctx context.Context, resourceURI string, body GuestAgent, options *VMInstanceGuestAgentsClientBeginCreateOptions) (*runtime.Poller[VMInstanceGuestAgentsClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceURI, body, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[VMInstanceGuestAgentsClientCreateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[VMInstanceGuestAgentsClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Create Or Update GuestAgent.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
func (client *VMInstanceGuestAgentsClient) create(ctx context.Context, resourceURI string, body GuestAgent, options *VMInstanceGuestAgentsClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "VMInstanceGuestAgentsClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceURI, body, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *VMInstanceGuestAgentsClient) createCreateRequest(ctx context.Context, resourceURI string, body GuestAgent, options *VMInstanceGuestAgentsClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/guestAgents/default"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Implements GuestAgent DELETE method.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - resourceURI - The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
//   - options - VMInstanceGuestAgentsClientBeginDeleteOptions contains the optional parameters for the VMInstanceGuestAgentsClient.BeginDelete
//     method.
func (client *VMInstanceGuestAgentsClient) BeginDelete(ctx context.Context, resourceURI string, options *VMInstanceGuestAgentsClientBeginDeleteOptions) (*runtime.Poller[VMInstanceGuestAgentsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceURI, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[VMInstanceGuestAgentsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[VMInstanceGuestAgentsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Implements GuestAgent DELETE method.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
func (client *VMInstanceGuestAgentsClient) deleteOperation(ctx context.Context, resourceURI string, options *VMInstanceGuestAgentsClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "VMInstanceGuestAgentsClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceURI, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *VMInstanceGuestAgentsClient) deleteCreateRequest(ctx context.Context, resourceURI string, options *VMInstanceGuestAgentsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/guestAgents/default"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Implements GuestAgent GET method.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01
//   - resourceURI - The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
//   - options - VMInstanceGuestAgentsClientGetOptions contains the optional parameters for the VMInstanceGuestAgentsClient.Get
//     method.
func (client *VMInstanceGuestAgentsClient) Get(ctx context.Context, resourceURI string, options *VMInstanceGuestAgentsClientGetOptions) (VMInstanceGuestAgentsClientGetResponse, error) {
	var err error
	const operationName = "VMInstanceGuestAgentsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceURI, options)
	if err != nil {
		return VMInstanceGuestAgentsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VMInstanceGuestAgentsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VMInstanceGuestAgentsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *VMInstanceGuestAgentsClient) getCreateRequest(ctx context.Context, resourceURI string, options *VMInstanceGuestAgentsClientGetOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/guestAgents/default"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VMInstanceGuestAgentsClient) getHandleResponse(resp *http.Response) (VMInstanceGuestAgentsClientGetResponse, error) {
	result := VMInstanceGuestAgentsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GuestAgent); err != nil {
		return VMInstanceGuestAgentsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Returns the list of GuestAgent of the given vm.
//
// Generated from API version 2023-10-01
//   - resourceURI - The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
//   - options - VMInstanceGuestAgentsClientListOptions contains the optional parameters for the VMInstanceGuestAgentsClient.NewListPager
//     method.
func (client *VMInstanceGuestAgentsClient) NewListPager(resourceURI string, options *VMInstanceGuestAgentsClientListOptions) *runtime.Pager[VMInstanceGuestAgentsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[VMInstanceGuestAgentsClientListResponse]{
		More: func(page VMInstanceGuestAgentsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VMInstanceGuestAgentsClientListResponse) (VMInstanceGuestAgentsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VMInstanceGuestAgentsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceURI, options)
			}, nil)
			if err != nil {
				return VMInstanceGuestAgentsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *VMInstanceGuestAgentsClient) listCreateRequest(ctx context.Context, resourceURI string, options *VMInstanceGuestAgentsClientListOptions) (*policy.Request, error) {
	urlPath := "/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/guestAgents"
	urlPath = strings.ReplaceAll(urlPath, "{resourceUri}", resourceURI)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *VMInstanceGuestAgentsClient) listHandleResponse(resp *http.Response) (VMInstanceGuestAgentsClientListResponse, error) {
	result := VMInstanceGuestAgentsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GuestAgentList); err != nil {
		return VMInstanceGuestAgentsClientListResponse{}, err
	}
	return result, nil
}
