//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armconsumption

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type Amount.
func (a Amount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currency", a.Currency)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Amount.
func (a *Amount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currency":
			err = unpopulate(val, "Currency", &a.Currency)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmountWithExchangeRate.
func (a AmountWithExchangeRate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currency", a.Currency)
	populate(objectMap, "exchangeRate", a.ExchangeRate)
	populate(objectMap, "exchangeRateMonth", a.ExchangeRateMonth)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmountWithExchangeRate.
func (a *AmountWithExchangeRate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currency":
			err = unpopulate(val, "Currency", &a.Currency)
			delete(rawMsg, key)
		case "exchangeRate":
			err = unpopulate(val, "ExchangeRate", &a.ExchangeRate)
			delete(rawMsg, key)
		case "exchangeRateMonth":
			err = unpopulate(val, "ExchangeRateMonth", &a.ExchangeRateMonth)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Balance.
func (b Balance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Balance.
func (b *Balance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &b.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BalanceProperties.
func (b BalanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adjustmentDetails", b.AdjustmentDetails)
	populate(objectMap, "adjustments", b.Adjustments)
	populate(objectMap, "azureMarketplaceServiceCharges", b.AzureMarketplaceServiceCharges)
	populate(objectMap, "beginningBalance", b.BeginningBalance)
	populate(objectMap, "billingFrequency", b.BillingFrequency)
	populate(objectMap, "chargesBilledSeparately", b.ChargesBilledSeparately)
	populate(objectMap, "currency", b.Currency)
	populate(objectMap, "endingBalance", b.EndingBalance)
	populate(objectMap, "newPurchases", b.NewPurchases)
	populate(objectMap, "newPurchasesDetails", b.NewPurchasesDetails)
	populate(objectMap, "priceHidden", b.PriceHidden)
	populate(objectMap, "serviceOverage", b.ServiceOverage)
	populate(objectMap, "totalOverage", b.TotalOverage)
	populate(objectMap, "totalUsage", b.TotalUsage)
	populate(objectMap, "utilized", b.Utilized)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BalanceProperties.
func (b *BalanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adjustmentDetails":
			err = unpopulate(val, "AdjustmentDetails", &b.AdjustmentDetails)
			delete(rawMsg, key)
		case "adjustments":
			err = unpopulate(val, "Adjustments", &b.Adjustments)
			delete(rawMsg, key)
		case "azureMarketplaceServiceCharges":
			err = unpopulate(val, "AzureMarketplaceServiceCharges", &b.AzureMarketplaceServiceCharges)
			delete(rawMsg, key)
		case "beginningBalance":
			err = unpopulate(val, "BeginningBalance", &b.BeginningBalance)
			delete(rawMsg, key)
		case "billingFrequency":
			err = unpopulate(val, "BillingFrequency", &b.BillingFrequency)
			delete(rawMsg, key)
		case "chargesBilledSeparately":
			err = unpopulate(val, "ChargesBilledSeparately", &b.ChargesBilledSeparately)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &b.Currency)
			delete(rawMsg, key)
		case "endingBalance":
			err = unpopulate(val, "EndingBalance", &b.EndingBalance)
			delete(rawMsg, key)
		case "newPurchases":
			err = unpopulate(val, "NewPurchases", &b.NewPurchases)
			delete(rawMsg, key)
		case "newPurchasesDetails":
			err = unpopulate(val, "NewPurchasesDetails", &b.NewPurchasesDetails)
			delete(rawMsg, key)
		case "priceHidden":
			err = unpopulate(val, "PriceHidden", &b.PriceHidden)
			delete(rawMsg, key)
		case "serviceOverage":
			err = unpopulate(val, "ServiceOverage", &b.ServiceOverage)
			delete(rawMsg, key)
		case "totalOverage":
			err = unpopulate(val, "TotalOverage", &b.TotalOverage)
			delete(rawMsg, key)
		case "totalUsage":
			err = unpopulate(val, "TotalUsage", &b.TotalUsage)
			delete(rawMsg, key)
		case "utilized":
			err = unpopulate(val, "Utilized", &b.Utilized)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BalancePropertiesAdjustmentDetailsItem.
func (b BalancePropertiesAdjustmentDetailsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BalancePropertiesAdjustmentDetailsItem.
func (b *BalancePropertiesAdjustmentDetailsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BalancePropertiesNewPurchasesDetailsItem.
func (b BalancePropertiesNewPurchasesDetailsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BalancePropertiesNewPurchasesDetailsItem.
func (b *BalancePropertiesNewPurchasesDetailsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Budget.
func (b Budget) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", b.ETag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Budget.
func (b *Budget) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &b.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BudgetComparisonExpression.
func (b BudgetComparisonExpression) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "operator", b.Operator)
	populate(objectMap, "values", b.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BudgetComparisonExpression.
func (b *BudgetComparisonExpression) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &b.Operator)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &b.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BudgetFilter.
func (b BudgetFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "and", b.And)
	populate(objectMap, "dimensions", b.Dimensions)
	populate(objectMap, "tags", b.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BudgetFilter.
func (b *BudgetFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "and":
			err = unpopulate(val, "And", &b.And)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &b.Dimensions)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BudgetFilterProperties.
func (b BudgetFilterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dimensions", b.Dimensions)
	populate(objectMap, "tags", b.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BudgetFilterProperties.
func (b *BudgetFilterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dimensions":
			err = unpopulate(val, "Dimensions", &b.Dimensions)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BudgetProperties.
func (b BudgetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", b.Amount)
	populate(objectMap, "category", b.Category)
	populate(objectMap, "currentSpend", b.CurrentSpend)
	populate(objectMap, "filter", b.Filter)
	populate(objectMap, "forecastSpend", b.ForecastSpend)
	populate(objectMap, "notifications", b.Notifications)
	populate(objectMap, "timeGrain", b.TimeGrain)
	populate(objectMap, "timePeriod", b.TimePeriod)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BudgetProperties.
func (b *BudgetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &b.Amount)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &b.Category)
			delete(rawMsg, key)
		case "currentSpend":
			err = unpopulate(val, "CurrentSpend", &b.CurrentSpend)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &b.Filter)
			delete(rawMsg, key)
		case "forecastSpend":
			err = unpopulate(val, "ForecastSpend", &b.ForecastSpend)
			delete(rawMsg, key)
		case "notifications":
			err = unpopulate(val, "Notifications", &b.Notifications)
			delete(rawMsg, key)
		case "timeGrain":
			err = unpopulate(val, "TimeGrain", &b.TimeGrain)
			delete(rawMsg, key)
		case "timePeriod":
			err = unpopulate(val, "TimePeriod", &b.TimePeriod)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BudgetTimePeriod.
func (b BudgetTimePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "endDate", b.EndDate)
	populateDateTimeRFC3339(objectMap, "startDate", b.StartDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BudgetTimePeriod.
func (b *BudgetTimePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endDate":
			err = unpopulateDateTimeRFC3339(val, "EndDate", &b.EndDate)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateDateTimeRFC3339(val, "StartDate", &b.StartDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BudgetsListResult.
func (b BudgetsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BudgetsListResult.
func (b *BudgetsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChargeSummary.
func (c ChargeSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", c.ETag)
	populate(objectMap, "id", c.ID)
	objectMap["kind"] = c.Kind
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChargeSummary.
func (c *ChargeSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &c.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChargesListResult.
func (c ChargesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChargesListResult.
func (c *ChargesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			c.Value, err = unmarshalChargeSummaryClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreditBalanceSummary.
func (c CreditBalanceSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentBalance", c.CurrentBalance)
	populate(objectMap, "estimatedBalance", c.EstimatedBalance)
	populate(objectMap, "estimatedBalanceInBillingCurrency", c.EstimatedBalanceInBillingCurrency)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreditBalanceSummary.
func (c *CreditBalanceSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentBalance":
			err = unpopulate(val, "CurrentBalance", &c.CurrentBalance)
			delete(rawMsg, key)
		case "estimatedBalance":
			err = unpopulate(val, "EstimatedBalance", &c.EstimatedBalance)
			delete(rawMsg, key)
		case "estimatedBalanceInBillingCurrency":
			err = unpopulate(val, "EstimatedBalanceInBillingCurrency", &c.EstimatedBalanceInBillingCurrency)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreditSummary.
func (c CreditSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreditSummary.
func (c *CreditSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreditSummaryProperties.
func (c CreditSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "balanceSummary", c.BalanceSummary)
	populate(objectMap, "billingCurrency", c.BillingCurrency)
	populate(objectMap, "creditCurrency", c.CreditCurrency)
	populate(objectMap, "eTag", c.ETag)
	populate(objectMap, "expiredCredit", c.ExpiredCredit)
	populate(objectMap, "pendingCreditAdjustments", c.PendingCreditAdjustments)
	populate(objectMap, "pendingEligibleCharges", c.PendingEligibleCharges)
	populate(objectMap, "reseller", c.Reseller)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreditSummaryProperties.
func (c *CreditSummaryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "balanceSummary":
			err = unpopulate(val, "BalanceSummary", &c.BalanceSummary)
			delete(rawMsg, key)
		case "billingCurrency":
			err = unpopulate(val, "BillingCurrency", &c.BillingCurrency)
			delete(rawMsg, key)
		case "creditCurrency":
			err = unpopulate(val, "CreditCurrency", &c.CreditCurrency)
			delete(rawMsg, key)
		case "eTag":
			err = unpopulate(val, "ETag", &c.ETag)
			delete(rawMsg, key)
		case "expiredCredit":
			err = unpopulate(val, "ExpiredCredit", &c.ExpiredCredit)
			delete(rawMsg, key)
		case "pendingCreditAdjustments":
			err = unpopulate(val, "PendingCreditAdjustments", &c.PendingCreditAdjustments)
			delete(rawMsg, key)
		case "pendingEligibleCharges":
			err = unpopulate(val, "PendingEligibleCharges", &c.PendingEligibleCharges)
			delete(rawMsg, key)
		case "reseller":
			err = unpopulate(val, "Reseller", &c.Reseller)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CurrentSpend.
func (c CurrentSpend) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", c.Amount)
	populate(objectMap, "unit", c.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CurrentSpend.
func (c *CurrentSpend) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &c.Amount)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &c.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DownloadProperties.
func (d DownloadProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "downloadUrl", d.DownloadURL)
	populate(objectMap, "validTill", d.ValidTill)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DownloadProperties.
func (d *DownloadProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "downloadUrl":
			err = unpopulate(val, "DownloadURL", &d.DownloadURL)
			delete(rawMsg, key)
		case "validTill":
			err = unpopulate(val, "ValidTill", &d.ValidTill)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetails.
func (e ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetails.
func (e *ErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventProperties.
func (e EventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adjustments", e.Adjustments)
	populate(objectMap, "adjustmentsInBillingCurrency", e.AdjustmentsInBillingCurrency)
	populate(objectMap, "billingCurrency", e.BillingCurrency)
	populate(objectMap, "billingProfileDisplayName", e.BillingProfileDisplayName)
	populate(objectMap, "billingProfileId", e.BillingProfileID)
	populate(objectMap, "canceledCredit", e.CanceledCredit)
	populate(objectMap, "charges", e.Charges)
	populate(objectMap, "chargesInBillingCurrency", e.ChargesInBillingCurrency)
	populate(objectMap, "closedBalance", e.ClosedBalance)
	populate(objectMap, "closedBalanceInBillingCurrency", e.ClosedBalanceInBillingCurrency)
	populate(objectMap, "creditCurrency", e.CreditCurrency)
	populate(objectMap, "creditExpired", e.CreditExpired)
	populate(objectMap, "creditExpiredInBillingCurrency", e.CreditExpiredInBillingCurrency)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "eTag", e.ETag)
	populate(objectMap, "eventType", e.EventType)
	populate(objectMap, "invoiceNumber", e.InvoiceNumber)
	populate(objectMap, "lotId", e.LotID)
	populate(objectMap, "lotSource", e.LotSource)
	populate(objectMap, "newCredit", e.NewCredit)
	populate(objectMap, "newCreditInBillingCurrency", e.NewCreditInBillingCurrency)
	populate(objectMap, "reseller", e.Reseller)
	populateDateTimeRFC3339(objectMap, "transactionDate", e.TransactionDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventProperties.
func (e *EventProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adjustments":
			err = unpopulate(val, "Adjustments", &e.Adjustments)
			delete(rawMsg, key)
		case "adjustmentsInBillingCurrency":
			err = unpopulate(val, "AdjustmentsInBillingCurrency", &e.AdjustmentsInBillingCurrency)
			delete(rawMsg, key)
		case "billingCurrency":
			err = unpopulate(val, "BillingCurrency", &e.BillingCurrency)
			delete(rawMsg, key)
		case "billingProfileDisplayName":
			err = unpopulate(val, "BillingProfileDisplayName", &e.BillingProfileDisplayName)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &e.BillingProfileID)
			delete(rawMsg, key)
		case "canceledCredit":
			err = unpopulate(val, "CanceledCredit", &e.CanceledCredit)
			delete(rawMsg, key)
		case "charges":
			err = unpopulate(val, "Charges", &e.Charges)
			delete(rawMsg, key)
		case "chargesInBillingCurrency":
			err = unpopulate(val, "ChargesInBillingCurrency", &e.ChargesInBillingCurrency)
			delete(rawMsg, key)
		case "closedBalance":
			err = unpopulate(val, "ClosedBalance", &e.ClosedBalance)
			delete(rawMsg, key)
		case "closedBalanceInBillingCurrency":
			err = unpopulate(val, "ClosedBalanceInBillingCurrency", &e.ClosedBalanceInBillingCurrency)
			delete(rawMsg, key)
		case "creditCurrency":
			err = unpopulate(val, "CreditCurrency", &e.CreditCurrency)
			delete(rawMsg, key)
		case "creditExpired":
			err = unpopulate(val, "CreditExpired", &e.CreditExpired)
			delete(rawMsg, key)
		case "creditExpiredInBillingCurrency":
			err = unpopulate(val, "CreditExpiredInBillingCurrency", &e.CreditExpiredInBillingCurrency)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "eTag":
			err = unpopulate(val, "ETag", &e.ETag)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &e.EventType)
			delete(rawMsg, key)
		case "invoiceNumber":
			err = unpopulate(val, "InvoiceNumber", &e.InvoiceNumber)
			delete(rawMsg, key)
		case "lotId":
			err = unpopulate(val, "LotID", &e.LotID)
			delete(rawMsg, key)
		case "lotSource":
			err = unpopulate(val, "LotSource", &e.LotSource)
			delete(rawMsg, key)
		case "newCredit":
			err = unpopulate(val, "NewCredit", &e.NewCredit)
			delete(rawMsg, key)
		case "newCreditInBillingCurrency":
			err = unpopulate(val, "NewCreditInBillingCurrency", &e.NewCreditInBillingCurrency)
			delete(rawMsg, key)
		case "reseller":
			err = unpopulate(val, "Reseller", &e.Reseller)
			delete(rawMsg, key)
		case "transactionDate":
			err = unpopulateDateTimeRFC3339(val, "TransactionDate", &e.TransactionDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSummary.
func (e EventSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", e.ETag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSummary.
func (e *EventSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &e.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Events.
func (e Events) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Events.
func (e *Events) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastSpend.
func (f ForecastSpend) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", f.Amount)
	populate(objectMap, "unit", f.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastSpend.
func (f *ForecastSpend) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &f.Amount)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &f.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HighCasedErrorDetails.
func (h HighCasedErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", h.Code)
	populate(objectMap, "message", h.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HighCasedErrorDetails.
func (h *HighCasedErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &h.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &h.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HighCasedErrorResponse.
func (h HighCasedErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", h.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HighCasedErrorResponse.
func (h *HighCasedErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &h.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegacyChargeSummary.
func (l LegacyChargeSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", l.ETag)
	populate(objectMap, "id", l.ID)
	objectMap["kind"] = ChargeSummaryKindLegacy
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyChargeSummary.
func (l *LegacyChargeSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &l.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &l.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegacyChargeSummaryProperties.
func (l LegacyChargeSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureCharges", l.AzureCharges)
	populate(objectMap, "billingPeriodId", l.BillingPeriodID)
	populate(objectMap, "chargesBilledSeparately", l.ChargesBilledSeparately)
	populate(objectMap, "currency", l.Currency)
	populate(objectMap, "marketplaceCharges", l.MarketplaceCharges)
	populate(objectMap, "usageEnd", l.UsageEnd)
	populate(objectMap, "usageStart", l.UsageStart)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyChargeSummaryProperties.
func (l *LegacyChargeSummaryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureCharges":
			err = unpopulate(val, "AzureCharges", &l.AzureCharges)
			delete(rawMsg, key)
		case "billingPeriodId":
			err = unpopulate(val, "BillingPeriodID", &l.BillingPeriodID)
			delete(rawMsg, key)
		case "chargesBilledSeparately":
			err = unpopulate(val, "ChargesBilledSeparately", &l.ChargesBilledSeparately)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &l.Currency)
			delete(rawMsg, key)
		case "marketplaceCharges":
			err = unpopulate(val, "MarketplaceCharges", &l.MarketplaceCharges)
			delete(rawMsg, key)
		case "usageEnd":
			err = unpopulate(val, "UsageEnd", &l.UsageEnd)
			delete(rawMsg, key)
		case "usageStart":
			err = unpopulate(val, "UsageStart", &l.UsageStart)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegacyReservationRecommendation.
func (l LegacyReservationRecommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "id", l.ID)
	objectMap["kind"] = ReservationRecommendationKindLegacy
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "sku", l.SKU)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyReservationRecommendation.
func (l *LegacyReservationRecommendation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &l.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			l.Properties, err = unmarshalLegacyReservationRecommendationPropertiesClassification(val)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &l.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegacyReservationRecommendationProperties.
func (l LegacyReservationRecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "costWithNoReservedInstances", l.CostWithNoReservedInstances)
	populateDateTimeRFC3339(objectMap, "firstUsageDate", l.FirstUsageDate)
	populate(objectMap, "instanceFlexibilityGroup", l.InstanceFlexibilityGroup)
	populate(objectMap, "instanceFlexibilityRatio", l.InstanceFlexibilityRatio)
	populate(objectMap, "lookBackPeriod", l.LookBackPeriod)
	populate(objectMap, "meterId", l.MeterID)
	populate(objectMap, "netSavings", l.NetSavings)
	populate(objectMap, "normalizedSize", l.NormalizedSize)
	populate(objectMap, "recommendedQuantity", l.RecommendedQuantity)
	populate(objectMap, "recommendedQuantityNormalized", l.RecommendedQuantityNormalized)
	populate(objectMap, "resourceType", l.ResourceType)
	populate(objectMap, "skuProperties", l.SKUProperties)
	objectMap["scope"] = l.Scope
	populate(objectMap, "term", l.Term)
	populate(objectMap, "totalCostWithReservedInstances", l.TotalCostWithReservedInstances)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyReservationRecommendationProperties.
func (l *LegacyReservationRecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "costWithNoReservedInstances":
			err = unpopulate(val, "CostWithNoReservedInstances", &l.CostWithNoReservedInstances)
			delete(rawMsg, key)
		case "firstUsageDate":
			err = unpopulateDateTimeRFC3339(val, "FirstUsageDate", &l.FirstUsageDate)
			delete(rawMsg, key)
		case "instanceFlexibilityGroup":
			err = unpopulate(val, "InstanceFlexibilityGroup", &l.InstanceFlexibilityGroup)
			delete(rawMsg, key)
		case "instanceFlexibilityRatio":
			err = unpopulate(val, "InstanceFlexibilityRatio", &l.InstanceFlexibilityRatio)
			delete(rawMsg, key)
		case "lookBackPeriod":
			err = unpopulate(val, "LookBackPeriod", &l.LookBackPeriod)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &l.MeterID)
			delete(rawMsg, key)
		case "netSavings":
			err = unpopulate(val, "NetSavings", &l.NetSavings)
			delete(rawMsg, key)
		case "normalizedSize":
			err = unpopulate(val, "NormalizedSize", &l.NormalizedSize)
			delete(rawMsg, key)
		case "recommendedQuantity":
			err = unpopulate(val, "RecommendedQuantity", &l.RecommendedQuantity)
			delete(rawMsg, key)
		case "recommendedQuantityNormalized":
			err = unpopulate(val, "RecommendedQuantityNormalized", &l.RecommendedQuantityNormalized)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &l.ResourceType)
			delete(rawMsg, key)
		case "skuProperties":
			err = unpopulate(val, "SKUProperties", &l.SKUProperties)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &l.Scope)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &l.Term)
			delete(rawMsg, key)
		case "totalCostWithReservedInstances":
			err = unpopulate(val, "TotalCostWithReservedInstances", &l.TotalCostWithReservedInstances)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegacyReservationTransaction.
func (l LegacyReservationTransaction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyReservationTransaction.
func (l *LegacyReservationTransaction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegacyReservationTransactionProperties.
func (l LegacyReservationTransactionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", l.AccountName)
	populate(objectMap, "accountOwnerEmail", l.AccountOwnerEmail)
	populate(objectMap, "amount", l.Amount)
	populate(objectMap, "armSkuName", l.ArmSKUName)
	populate(objectMap, "billingFrequency", l.BillingFrequency)
	populate(objectMap, "billingMonth", l.BillingMonth)
	populate(objectMap, "costCenter", l.CostCenter)
	populate(objectMap, "currency", l.Currency)
	populate(objectMap, "currentEnrollment", l.CurrentEnrollment)
	populate(objectMap, "departmentName", l.DepartmentName)
	populate(objectMap, "description", l.Description)
	populateDateTimeRFC3339(objectMap, "eventDate", l.EventDate)
	populate(objectMap, "eventType", l.EventType)
	populate(objectMap, "monetaryCommitment", l.MonetaryCommitment)
	populate(objectMap, "overage", l.Overage)
	populate(objectMap, "purchasingEnrollment", l.PurchasingEnrollment)
	populate(objectMap, "purchasingSubscriptionGuid", l.PurchasingSubscriptionGUID)
	populate(objectMap, "purchasingSubscriptionName", l.PurchasingSubscriptionName)
	populate(objectMap, "quantity", l.Quantity)
	populate(objectMap, "region", l.Region)
	populate(objectMap, "reservationOrderId", l.ReservationOrderID)
	populate(objectMap, "reservationOrderName", l.ReservationOrderName)
	populate(objectMap, "term", l.Term)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyReservationTransactionProperties.
func (l *LegacyReservationTransactionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &l.AccountName)
			delete(rawMsg, key)
		case "accountOwnerEmail":
			err = unpopulate(val, "AccountOwnerEmail", &l.AccountOwnerEmail)
			delete(rawMsg, key)
		case "amount":
			err = unpopulate(val, "Amount", &l.Amount)
			delete(rawMsg, key)
		case "armSkuName":
			err = unpopulate(val, "ArmSKUName", &l.ArmSKUName)
			delete(rawMsg, key)
		case "billingFrequency":
			err = unpopulate(val, "BillingFrequency", &l.BillingFrequency)
			delete(rawMsg, key)
		case "billingMonth":
			err = unpopulate(val, "BillingMonth", &l.BillingMonth)
			delete(rawMsg, key)
		case "costCenter":
			err = unpopulate(val, "CostCenter", &l.CostCenter)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &l.Currency)
			delete(rawMsg, key)
		case "currentEnrollment":
			err = unpopulate(val, "CurrentEnrollment", &l.CurrentEnrollment)
			delete(rawMsg, key)
		case "departmentName":
			err = unpopulate(val, "DepartmentName", &l.DepartmentName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "eventDate":
			err = unpopulateDateTimeRFC3339(val, "EventDate", &l.EventDate)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &l.EventType)
			delete(rawMsg, key)
		case "monetaryCommitment":
			err = unpopulate(val, "MonetaryCommitment", &l.MonetaryCommitment)
			delete(rawMsg, key)
		case "overage":
			err = unpopulate(val, "Overage", &l.Overage)
			delete(rawMsg, key)
		case "purchasingEnrollment":
			err = unpopulate(val, "PurchasingEnrollment", &l.PurchasingEnrollment)
			delete(rawMsg, key)
		case "purchasingSubscriptionGuid":
			err = unpopulate(val, "PurchasingSubscriptionGUID", &l.PurchasingSubscriptionGUID)
			delete(rawMsg, key)
		case "purchasingSubscriptionName":
			err = unpopulate(val, "PurchasingSubscriptionName", &l.PurchasingSubscriptionName)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &l.Quantity)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &l.Region)
			delete(rawMsg, key)
		case "reservationOrderId":
			err = unpopulate(val, "ReservationOrderID", &l.ReservationOrderID)
			delete(rawMsg, key)
		case "reservationOrderName":
			err = unpopulate(val, "ReservationOrderName", &l.ReservationOrderName)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &l.Term)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegacySharedScopeReservationRecommendationProperties.
func (l LegacySharedScopeReservationRecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "costWithNoReservedInstances", l.CostWithNoReservedInstances)
	populateDateTimeRFC3339(objectMap, "firstUsageDate", l.FirstUsageDate)
	populate(objectMap, "instanceFlexibilityGroup", l.InstanceFlexibilityGroup)
	populate(objectMap, "instanceFlexibilityRatio", l.InstanceFlexibilityRatio)
	populate(objectMap, "lookBackPeriod", l.LookBackPeriod)
	populate(objectMap, "meterId", l.MeterID)
	populate(objectMap, "netSavings", l.NetSavings)
	populate(objectMap, "normalizedSize", l.NormalizedSize)
	populate(objectMap, "recommendedQuantity", l.RecommendedQuantity)
	populate(objectMap, "recommendedQuantityNormalized", l.RecommendedQuantityNormalized)
	populate(objectMap, "resourceType", l.ResourceType)
	populate(objectMap, "skuProperties", l.SKUProperties)
	objectMap["scope"] = "Shared"
	populate(objectMap, "term", l.Term)
	populate(objectMap, "totalCostWithReservedInstances", l.TotalCostWithReservedInstances)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacySharedScopeReservationRecommendationProperties.
func (l *LegacySharedScopeReservationRecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "costWithNoReservedInstances":
			err = unpopulate(val, "CostWithNoReservedInstances", &l.CostWithNoReservedInstances)
			delete(rawMsg, key)
		case "firstUsageDate":
			err = unpopulateDateTimeRFC3339(val, "FirstUsageDate", &l.FirstUsageDate)
			delete(rawMsg, key)
		case "instanceFlexibilityGroup":
			err = unpopulate(val, "InstanceFlexibilityGroup", &l.InstanceFlexibilityGroup)
			delete(rawMsg, key)
		case "instanceFlexibilityRatio":
			err = unpopulate(val, "InstanceFlexibilityRatio", &l.InstanceFlexibilityRatio)
			delete(rawMsg, key)
		case "lookBackPeriod":
			err = unpopulate(val, "LookBackPeriod", &l.LookBackPeriod)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &l.MeterID)
			delete(rawMsg, key)
		case "netSavings":
			err = unpopulate(val, "NetSavings", &l.NetSavings)
			delete(rawMsg, key)
		case "normalizedSize":
			err = unpopulate(val, "NormalizedSize", &l.NormalizedSize)
			delete(rawMsg, key)
		case "recommendedQuantity":
			err = unpopulate(val, "RecommendedQuantity", &l.RecommendedQuantity)
			delete(rawMsg, key)
		case "recommendedQuantityNormalized":
			err = unpopulate(val, "RecommendedQuantityNormalized", &l.RecommendedQuantityNormalized)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &l.ResourceType)
			delete(rawMsg, key)
		case "skuProperties":
			err = unpopulate(val, "SKUProperties", &l.SKUProperties)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &l.Scope)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &l.Term)
			delete(rawMsg, key)
		case "totalCostWithReservedInstances":
			err = unpopulate(val, "TotalCostWithReservedInstances", &l.TotalCostWithReservedInstances)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegacySingleScopeReservationRecommendationProperties.
func (l LegacySingleScopeReservationRecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "costWithNoReservedInstances", l.CostWithNoReservedInstances)
	populateDateTimeRFC3339(objectMap, "firstUsageDate", l.FirstUsageDate)
	populate(objectMap, "instanceFlexibilityGroup", l.InstanceFlexibilityGroup)
	populate(objectMap, "instanceFlexibilityRatio", l.InstanceFlexibilityRatio)
	populate(objectMap, "lookBackPeriod", l.LookBackPeriod)
	populate(objectMap, "meterId", l.MeterID)
	populate(objectMap, "netSavings", l.NetSavings)
	populate(objectMap, "normalizedSize", l.NormalizedSize)
	populate(objectMap, "recommendedQuantity", l.RecommendedQuantity)
	populate(objectMap, "recommendedQuantityNormalized", l.RecommendedQuantityNormalized)
	populate(objectMap, "resourceType", l.ResourceType)
	populate(objectMap, "skuProperties", l.SKUProperties)
	objectMap["scope"] = "Single"
	populate(objectMap, "subscriptionId", l.SubscriptionID)
	populate(objectMap, "term", l.Term)
	populate(objectMap, "totalCostWithReservedInstances", l.TotalCostWithReservedInstances)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacySingleScopeReservationRecommendationProperties.
func (l *LegacySingleScopeReservationRecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "costWithNoReservedInstances":
			err = unpopulate(val, "CostWithNoReservedInstances", &l.CostWithNoReservedInstances)
			delete(rawMsg, key)
		case "firstUsageDate":
			err = unpopulateDateTimeRFC3339(val, "FirstUsageDate", &l.FirstUsageDate)
			delete(rawMsg, key)
		case "instanceFlexibilityGroup":
			err = unpopulate(val, "InstanceFlexibilityGroup", &l.InstanceFlexibilityGroup)
			delete(rawMsg, key)
		case "instanceFlexibilityRatio":
			err = unpopulate(val, "InstanceFlexibilityRatio", &l.InstanceFlexibilityRatio)
			delete(rawMsg, key)
		case "lookBackPeriod":
			err = unpopulate(val, "LookBackPeriod", &l.LookBackPeriod)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &l.MeterID)
			delete(rawMsg, key)
		case "netSavings":
			err = unpopulate(val, "NetSavings", &l.NetSavings)
			delete(rawMsg, key)
		case "normalizedSize":
			err = unpopulate(val, "NormalizedSize", &l.NormalizedSize)
			delete(rawMsg, key)
		case "recommendedQuantity":
			err = unpopulate(val, "RecommendedQuantity", &l.RecommendedQuantity)
			delete(rawMsg, key)
		case "recommendedQuantityNormalized":
			err = unpopulate(val, "RecommendedQuantityNormalized", &l.RecommendedQuantityNormalized)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &l.ResourceType)
			delete(rawMsg, key)
		case "skuProperties":
			err = unpopulate(val, "SKUProperties", &l.SKUProperties)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &l.Scope)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &l.SubscriptionID)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &l.Term)
			delete(rawMsg, key)
		case "totalCostWithReservedInstances":
			err = unpopulate(val, "TotalCostWithReservedInstances", &l.TotalCostWithReservedInstances)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegacyUsageDetail.
func (l LegacyUsageDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "id", l.ID)
	objectMap["kind"] = UsageDetailsKindLegacy
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyUsageDetail.
func (l *LegacyUsageDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &l.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LegacyUsageDetailProperties.
func (l LegacyUsageDetailProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", l.AccountName)
	populate(objectMap, "accountOwnerId", l.AccountOwnerID)
	populate(objectMap, "additionalInfo", l.AdditionalInfo)
	populate(objectMap, "benefitId", l.BenefitID)
	populate(objectMap, "benefitName", l.BenefitName)
	populate(objectMap, "billingAccountId", l.BillingAccountID)
	populate(objectMap, "billingAccountName", l.BillingAccountName)
	populate(objectMap, "billingCurrency", l.BillingCurrency)
	populateDateTimeRFC3339(objectMap, "billingPeriodEndDate", l.BillingPeriodEndDate)
	populateDateTimeRFC3339(objectMap, "billingPeriodStartDate", l.BillingPeriodStartDate)
	populate(objectMap, "billingProfileId", l.BillingProfileID)
	populate(objectMap, "billingProfileName", l.BillingProfileName)
	populate(objectMap, "chargeType", l.ChargeType)
	populate(objectMap, "consumedService", l.ConsumedService)
	populate(objectMap, "cost", l.Cost)
	populate(objectMap, "costCenter", l.CostCenter)
	populateDateTimeRFC3339(objectMap, "date", l.Date)
	populate(objectMap, "effectivePrice", l.EffectivePrice)
	populate(objectMap, "frequency", l.Frequency)
	populate(objectMap, "invoiceSection", l.InvoiceSection)
	populate(objectMap, "isAzureCreditEligible", l.IsAzureCreditEligible)
	populate(objectMap, "meterDetails", l.MeterDetails)
	populate(objectMap, "meterId", l.MeterID)
	populate(objectMap, "offerId", l.OfferID)
	populate(objectMap, "partNumber", l.PartNumber)
	populate(objectMap, "payGPrice", l.PayGPrice)
	populate(objectMap, "planName", l.PlanName)
	populate(objectMap, "pricingModel", l.PricingModel)
	populate(objectMap, "product", l.Product)
	populate(objectMap, "productOrderId", l.ProductOrderID)
	populate(objectMap, "productOrderName", l.ProductOrderName)
	populate(objectMap, "publisherName", l.PublisherName)
	populate(objectMap, "publisherType", l.PublisherType)
	populate(objectMap, "quantity", l.Quantity)
	populate(objectMap, "reservationId", l.ReservationID)
	populate(objectMap, "reservationName", l.ReservationName)
	populate(objectMap, "resourceGroup", l.ResourceGroup)
	populate(objectMap, "resourceId", l.ResourceID)
	populate(objectMap, "resourceLocation", l.ResourceLocation)
	populate(objectMap, "resourceName", l.ResourceName)
	populate(objectMap, "serviceInfo1", l.ServiceInfo1)
	populate(objectMap, "serviceInfo2", l.ServiceInfo2)
	populate(objectMap, "subscriptionId", l.SubscriptionID)
	populate(objectMap, "subscriptionName", l.SubscriptionName)
	populate(objectMap, "term", l.Term)
	populate(objectMap, "unitPrice", l.UnitPrice)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LegacyUsageDetailProperties.
func (l *LegacyUsageDetailProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &l.AccountName)
			delete(rawMsg, key)
		case "accountOwnerId":
			err = unpopulate(val, "AccountOwnerID", &l.AccountOwnerID)
			delete(rawMsg, key)
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &l.AdditionalInfo)
			delete(rawMsg, key)
		case "benefitId":
			err = unpopulate(val, "BenefitID", &l.BenefitID)
			delete(rawMsg, key)
		case "benefitName":
			err = unpopulate(val, "BenefitName", &l.BenefitName)
			delete(rawMsg, key)
		case "billingAccountId":
			err = unpopulate(val, "BillingAccountID", &l.BillingAccountID)
			delete(rawMsg, key)
		case "billingAccountName":
			err = unpopulate(val, "BillingAccountName", &l.BillingAccountName)
			delete(rawMsg, key)
		case "billingCurrency":
			err = unpopulate(val, "BillingCurrency", &l.BillingCurrency)
			delete(rawMsg, key)
		case "billingPeriodEndDate":
			err = unpopulateDateTimeRFC3339(val, "BillingPeriodEndDate", &l.BillingPeriodEndDate)
			delete(rawMsg, key)
		case "billingPeriodStartDate":
			err = unpopulateDateTimeRFC3339(val, "BillingPeriodStartDate", &l.BillingPeriodStartDate)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &l.BillingProfileID)
			delete(rawMsg, key)
		case "billingProfileName":
			err = unpopulate(val, "BillingProfileName", &l.BillingProfileName)
			delete(rawMsg, key)
		case "chargeType":
			err = unpopulate(val, "ChargeType", &l.ChargeType)
			delete(rawMsg, key)
		case "consumedService":
			err = unpopulate(val, "ConsumedService", &l.ConsumedService)
			delete(rawMsg, key)
		case "cost":
			err = unpopulate(val, "Cost", &l.Cost)
			delete(rawMsg, key)
		case "costCenter":
			err = unpopulate(val, "CostCenter", &l.CostCenter)
			delete(rawMsg, key)
		case "date":
			err = unpopulateDateTimeRFC3339(val, "Date", &l.Date)
			delete(rawMsg, key)
		case "effectivePrice":
			err = unpopulate(val, "EffectivePrice", &l.EffectivePrice)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &l.Frequency)
			delete(rawMsg, key)
		case "invoiceSection":
			err = unpopulate(val, "InvoiceSection", &l.InvoiceSection)
			delete(rawMsg, key)
		case "isAzureCreditEligible":
			err = unpopulate(val, "IsAzureCreditEligible", &l.IsAzureCreditEligible)
			delete(rawMsg, key)
		case "meterDetails":
			err = unpopulate(val, "MeterDetails", &l.MeterDetails)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &l.MeterID)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &l.OfferID)
			delete(rawMsg, key)
		case "partNumber":
			err = unpopulate(val, "PartNumber", &l.PartNumber)
			delete(rawMsg, key)
		case "payGPrice":
			err = unpopulate(val, "PayGPrice", &l.PayGPrice)
			delete(rawMsg, key)
		case "planName":
			err = unpopulate(val, "PlanName", &l.PlanName)
			delete(rawMsg, key)
		case "pricingModel":
			err = unpopulate(val, "PricingModel", &l.PricingModel)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &l.Product)
			delete(rawMsg, key)
		case "productOrderId":
			err = unpopulate(val, "ProductOrderID", &l.ProductOrderID)
			delete(rawMsg, key)
		case "productOrderName":
			err = unpopulate(val, "ProductOrderName", &l.ProductOrderName)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &l.PublisherName)
			delete(rawMsg, key)
		case "publisherType":
			err = unpopulate(val, "PublisherType", &l.PublisherType)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &l.Quantity)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &l.ReservationID)
			delete(rawMsg, key)
		case "reservationName":
			err = unpopulate(val, "ReservationName", &l.ReservationName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &l.ResourceGroup)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &l.ResourceID)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &l.ResourceLocation)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &l.ResourceName)
			delete(rawMsg, key)
		case "serviceInfo1":
			err = unpopulate(val, "ServiceInfo1", &l.ServiceInfo1)
			delete(rawMsg, key)
		case "serviceInfo2":
			err = unpopulate(val, "ServiceInfo2", &l.ServiceInfo2)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &l.SubscriptionID)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &l.SubscriptionName)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &l.Term)
			delete(rawMsg, key)
		case "unitPrice":
			err = unpopulate(val, "UnitPrice", &l.UnitPrice)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LotProperties.
func (l LotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingCurrency", l.BillingCurrency)
	populate(objectMap, "closedBalance", l.ClosedBalance)
	populate(objectMap, "closedBalanceInBillingCurrency", l.ClosedBalanceInBillingCurrency)
	populate(objectMap, "creditCurrency", l.CreditCurrency)
	populate(objectMap, "eTag", l.ETag)
	populateDateTimeRFC3339(objectMap, "expirationDate", l.ExpirationDate)
	populate(objectMap, "originalAmount", l.OriginalAmount)
	populate(objectMap, "originalAmountInBillingCurrency", l.OriginalAmountInBillingCurrency)
	populate(objectMap, "poNumber", l.PoNumber)
	populateDateTimeRFC3339(objectMap, "purchasedDate", l.PurchasedDate)
	populate(objectMap, "reseller", l.Reseller)
	populate(objectMap, "source", l.Source)
	populateDateTimeRFC3339(objectMap, "startDate", l.StartDate)
	populate(objectMap, "status", l.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LotProperties.
func (l *LotProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingCurrency":
			err = unpopulate(val, "BillingCurrency", &l.BillingCurrency)
			delete(rawMsg, key)
		case "closedBalance":
			err = unpopulate(val, "ClosedBalance", &l.ClosedBalance)
			delete(rawMsg, key)
		case "closedBalanceInBillingCurrency":
			err = unpopulate(val, "ClosedBalanceInBillingCurrency", &l.ClosedBalanceInBillingCurrency)
			delete(rawMsg, key)
		case "creditCurrency":
			err = unpopulate(val, "CreditCurrency", &l.CreditCurrency)
			delete(rawMsg, key)
		case "eTag":
			err = unpopulate(val, "ETag", &l.ETag)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateDateTimeRFC3339(val, "ExpirationDate", &l.ExpirationDate)
			delete(rawMsg, key)
		case "originalAmount":
			err = unpopulate(val, "OriginalAmount", &l.OriginalAmount)
			delete(rawMsg, key)
		case "originalAmountInBillingCurrency":
			err = unpopulate(val, "OriginalAmountInBillingCurrency", &l.OriginalAmountInBillingCurrency)
			delete(rawMsg, key)
		case "poNumber":
			err = unpopulate(val, "PoNumber", &l.PoNumber)
			delete(rawMsg, key)
		case "purchasedDate":
			err = unpopulateDateTimeRFC3339(val, "PurchasedDate", &l.PurchasedDate)
			delete(rawMsg, key)
		case "reseller":
			err = unpopulate(val, "Reseller", &l.Reseller)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &l.Source)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateDateTimeRFC3339(val, "StartDate", &l.StartDate)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &l.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LotSummary.
func (l LotSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", l.ETag)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LotSummary.
func (l *LotSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &l.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Lots.
func (l Lots) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Lots.
func (l *Lots) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementGroupAggregatedCostProperties.
func (m ManagementGroupAggregatedCostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureCharges", m.AzureCharges)
	populate(objectMap, "billingPeriodId", m.BillingPeriodID)
	populate(objectMap, "chargesBilledSeparately", m.ChargesBilledSeparately)
	populate(objectMap, "children", m.Children)
	populate(objectMap, "currency", m.Currency)
	populate(objectMap, "excludedSubscriptions", m.ExcludedSubscriptions)
	populate(objectMap, "includedSubscriptions", m.IncludedSubscriptions)
	populate(objectMap, "marketplaceCharges", m.MarketplaceCharges)
	populateDateTimeRFC3339(objectMap, "usageEnd", m.UsageEnd)
	populateDateTimeRFC3339(objectMap, "usageStart", m.UsageStart)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementGroupAggregatedCostProperties.
func (m *ManagementGroupAggregatedCostProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureCharges":
			err = unpopulate(val, "AzureCharges", &m.AzureCharges)
			delete(rawMsg, key)
		case "billingPeriodId":
			err = unpopulate(val, "BillingPeriodID", &m.BillingPeriodID)
			delete(rawMsg, key)
		case "chargesBilledSeparately":
			err = unpopulate(val, "ChargesBilledSeparately", &m.ChargesBilledSeparately)
			delete(rawMsg, key)
		case "children":
			err = unpopulate(val, "Children", &m.Children)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &m.Currency)
			delete(rawMsg, key)
		case "excludedSubscriptions":
			err = unpopulate(val, "ExcludedSubscriptions", &m.ExcludedSubscriptions)
			delete(rawMsg, key)
		case "includedSubscriptions":
			err = unpopulate(val, "IncludedSubscriptions", &m.IncludedSubscriptions)
			delete(rawMsg, key)
		case "marketplaceCharges":
			err = unpopulate(val, "MarketplaceCharges", &m.MarketplaceCharges)
			delete(rawMsg, key)
		case "usageEnd":
			err = unpopulateDateTimeRFC3339(val, "UsageEnd", &m.UsageEnd)
			delete(rawMsg, key)
		case "usageStart":
			err = unpopulateDateTimeRFC3339(val, "UsageStart", &m.UsageStart)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementGroupAggregatedCostResult.
func (m ManagementGroupAggregatedCostResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementGroupAggregatedCostResult.
func (m *ManagementGroupAggregatedCostResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Marketplace.
func (m Marketplace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Marketplace.
func (m *Marketplace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MarketplaceProperties.
func (m MarketplaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", m.AccountName)
	populate(objectMap, "additionalInfo", m.AdditionalInfo)
	populate(objectMap, "additionalProperties", m.AdditionalProperties)
	populate(objectMap, "billingPeriodId", m.BillingPeriodID)
	populate(objectMap, "consumedQuantity", m.ConsumedQuantity)
	populate(objectMap, "consumedService", m.ConsumedService)
	populate(objectMap, "costCenter", m.CostCenter)
	populate(objectMap, "currency", m.Currency)
	populate(objectMap, "departmentName", m.DepartmentName)
	populate(objectMap, "instanceId", m.InstanceID)
	populate(objectMap, "instanceName", m.InstanceName)
	populate(objectMap, "isEstimated", m.IsEstimated)
	populate(objectMap, "isRecurringCharge", m.IsRecurringCharge)
	populate(objectMap, "meterId", m.MeterID)
	populate(objectMap, "offerName", m.OfferName)
	populate(objectMap, "orderNumber", m.OrderNumber)
	populate(objectMap, "planName", m.PlanName)
	populate(objectMap, "pretaxCost", m.PretaxCost)
	populate(objectMap, "publisherName", m.PublisherName)
	populate(objectMap, "resourceGroup", m.ResourceGroup)
	populate(objectMap, "resourceRate", m.ResourceRate)
	populate(objectMap, "subscriptionGuid", m.SubscriptionGUID)
	populate(objectMap, "subscriptionName", m.SubscriptionName)
	populate(objectMap, "unitOfMeasure", m.UnitOfMeasure)
	populateDateTimeRFC3339(objectMap, "usageEnd", m.UsageEnd)
	populateDateTimeRFC3339(objectMap, "usageStart", m.UsageStart)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MarketplaceProperties.
func (m *MarketplaceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &m.AccountName)
			delete(rawMsg, key)
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &m.AdditionalInfo)
			delete(rawMsg, key)
		case "additionalProperties":
			err = unpopulate(val, "AdditionalProperties", &m.AdditionalProperties)
			delete(rawMsg, key)
		case "billingPeriodId":
			err = unpopulate(val, "BillingPeriodID", &m.BillingPeriodID)
			delete(rawMsg, key)
		case "consumedQuantity":
			err = unpopulate(val, "ConsumedQuantity", &m.ConsumedQuantity)
			delete(rawMsg, key)
		case "consumedService":
			err = unpopulate(val, "ConsumedService", &m.ConsumedService)
			delete(rawMsg, key)
		case "costCenter":
			err = unpopulate(val, "CostCenter", &m.CostCenter)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &m.Currency)
			delete(rawMsg, key)
		case "departmentName":
			err = unpopulate(val, "DepartmentName", &m.DepartmentName)
			delete(rawMsg, key)
		case "instanceId":
			err = unpopulate(val, "InstanceID", &m.InstanceID)
			delete(rawMsg, key)
		case "instanceName":
			err = unpopulate(val, "InstanceName", &m.InstanceName)
			delete(rawMsg, key)
		case "isEstimated":
			err = unpopulate(val, "IsEstimated", &m.IsEstimated)
			delete(rawMsg, key)
		case "isRecurringCharge":
			err = unpopulate(val, "IsRecurringCharge", &m.IsRecurringCharge)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &m.MeterID)
			delete(rawMsg, key)
		case "offerName":
			err = unpopulate(val, "OfferName", &m.OfferName)
			delete(rawMsg, key)
		case "orderNumber":
			err = unpopulate(val, "OrderNumber", &m.OrderNumber)
			delete(rawMsg, key)
		case "planName":
			err = unpopulate(val, "PlanName", &m.PlanName)
			delete(rawMsg, key)
		case "pretaxCost":
			err = unpopulate(val, "PretaxCost", &m.PretaxCost)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &m.PublisherName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &m.ResourceGroup)
			delete(rawMsg, key)
		case "resourceRate":
			err = unpopulate(val, "ResourceRate", &m.ResourceRate)
			delete(rawMsg, key)
		case "subscriptionGuid":
			err = unpopulate(val, "SubscriptionGUID", &m.SubscriptionGUID)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &m.SubscriptionName)
			delete(rawMsg, key)
		case "unitOfMeasure":
			err = unpopulate(val, "UnitOfMeasure", &m.UnitOfMeasure)
			delete(rawMsg, key)
		case "usageEnd":
			err = unpopulateDateTimeRFC3339(val, "UsageEnd", &m.UsageEnd)
			delete(rawMsg, key)
		case "usageStart":
			err = unpopulateDateTimeRFC3339(val, "UsageStart", &m.UsageStart)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MarketplacesListResult.
func (m MarketplacesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MarketplacesListResult.
func (m *MarketplacesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MeterDetails.
func (m MeterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "meterCategory", m.MeterCategory)
	populate(objectMap, "meterLocation", m.MeterLocation)
	populate(objectMap, "meterName", m.MeterName)
	populate(objectMap, "meterSubCategory", m.MeterSubCategory)
	populate(objectMap, "pretaxStandardRate", m.PretaxStandardRate)
	populate(objectMap, "serviceName", m.ServiceName)
	populate(objectMap, "serviceTier", m.ServiceTier)
	populate(objectMap, "totalIncludedQuantity", m.TotalIncludedQuantity)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MeterDetails.
func (m *MeterDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "meterCategory":
			err = unpopulate(val, "MeterCategory", &m.MeterCategory)
			delete(rawMsg, key)
		case "meterLocation":
			err = unpopulate(val, "MeterLocation", &m.MeterLocation)
			delete(rawMsg, key)
		case "meterName":
			err = unpopulate(val, "MeterName", &m.MeterName)
			delete(rawMsg, key)
		case "meterSubCategory":
			err = unpopulate(val, "MeterSubCategory", &m.MeterSubCategory)
			delete(rawMsg, key)
		case "pretaxStandardRate":
			err = unpopulate(val, "PretaxStandardRate", &m.PretaxStandardRate)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &m.ServiceName)
			delete(rawMsg, key)
		case "serviceTier":
			err = unpopulate(val, "ServiceTier", &m.ServiceTier)
			delete(rawMsg, key)
		case "totalIncludedQuantity":
			err = unpopulate(val, "TotalIncludedQuantity", &m.TotalIncludedQuantity)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MeterDetailsResponse.
func (m MeterDetailsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "meterCategory", m.MeterCategory)
	populate(objectMap, "meterName", m.MeterName)
	populate(objectMap, "meterSubCategory", m.MeterSubCategory)
	populate(objectMap, "serviceFamily", m.ServiceFamily)
	populate(objectMap, "unitOfMeasure", m.UnitOfMeasure)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MeterDetailsResponse.
func (m *MeterDetailsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "meterCategory":
			err = unpopulate(val, "MeterCategory", &m.MeterCategory)
			delete(rawMsg, key)
		case "meterName":
			err = unpopulate(val, "MeterName", &m.MeterName)
			delete(rawMsg, key)
		case "meterSubCategory":
			err = unpopulate(val, "MeterSubCategory", &m.MeterSubCategory)
			delete(rawMsg, key)
		case "serviceFamily":
			err = unpopulate(val, "ServiceFamily", &m.ServiceFamily)
			delete(rawMsg, key)
		case "unitOfMeasure":
			err = unpopulate(val, "UnitOfMeasure", &m.UnitOfMeasure)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModernChargeSummary.
func (m ModernChargeSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", m.ETag)
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = ChargeSummaryKindModern
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernChargeSummary.
func (m *ModernChargeSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &m.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModernChargeSummaryProperties.
func (m ModernChargeSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureCharges", m.AzureCharges)
	populate(objectMap, "billingAccountId", m.BillingAccountID)
	populate(objectMap, "billingPeriodId", m.BillingPeriodID)
	populate(objectMap, "billingProfileId", m.BillingProfileID)
	populate(objectMap, "chargesBilledSeparately", m.ChargesBilledSeparately)
	populate(objectMap, "customerId", m.CustomerID)
	populate(objectMap, "invoiceSectionId", m.InvoiceSectionID)
	populate(objectMap, "isInvoiced", m.IsInvoiced)
	populate(objectMap, "marketplaceCharges", m.MarketplaceCharges)
	populate(objectMap, "usageEnd", m.UsageEnd)
	populate(objectMap, "usageStart", m.UsageStart)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernChargeSummaryProperties.
func (m *ModernChargeSummaryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureCharges":
			err = unpopulate(val, "AzureCharges", &m.AzureCharges)
			delete(rawMsg, key)
		case "billingAccountId":
			err = unpopulate(val, "BillingAccountID", &m.BillingAccountID)
			delete(rawMsg, key)
		case "billingPeriodId":
			err = unpopulate(val, "BillingPeriodID", &m.BillingPeriodID)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &m.BillingProfileID)
			delete(rawMsg, key)
		case "chargesBilledSeparately":
			err = unpopulate(val, "ChargesBilledSeparately", &m.ChargesBilledSeparately)
			delete(rawMsg, key)
		case "customerId":
			err = unpopulate(val, "CustomerID", &m.CustomerID)
			delete(rawMsg, key)
		case "invoiceSectionId":
			err = unpopulate(val, "InvoiceSectionID", &m.InvoiceSectionID)
			delete(rawMsg, key)
		case "isInvoiced":
			err = unpopulate(val, "IsInvoiced", &m.IsInvoiced)
			delete(rawMsg, key)
		case "marketplaceCharges":
			err = unpopulate(val, "MarketplaceCharges", &m.MarketplaceCharges)
			delete(rawMsg, key)
		case "usageEnd":
			err = unpopulate(val, "UsageEnd", &m.UsageEnd)
			delete(rawMsg, key)
		case "usageStart":
			err = unpopulate(val, "UsageStart", &m.UsageStart)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModernReservationRecommendation.
func (m ModernReservationRecommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = ReservationRecommendationKindModern
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "sku", m.SKU)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernReservationRecommendation.
func (m *ModernReservationRecommendation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &m.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModernReservationRecommendationProperties.
func (m ModernReservationRecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "costWithNoReservedInstances", m.CostWithNoReservedInstances)
	populateDateTimeRFC3339(objectMap, "firstUsageDate", m.FirstUsageDate)
	populate(objectMap, "instanceFlexibilityGroup", m.InstanceFlexibilityGroup)
	populate(objectMap, "instanceFlexibilityRatio", m.InstanceFlexibilityRatio)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "lookBackPeriod", m.LookBackPeriod)
	populate(objectMap, "meterId", m.MeterID)
	populate(objectMap, "netSavings", m.NetSavings)
	populate(objectMap, "normalizedSize", m.NormalizedSize)
	populate(objectMap, "recommendedQuantity", m.RecommendedQuantity)
	populate(objectMap, "recommendedQuantityNormalized", m.RecommendedQuantityNormalized)
	populate(objectMap, "skuName", m.SKUName)
	populate(objectMap, "skuProperties", m.SKUProperties)
	populate(objectMap, "scope", m.Scope)
	populate(objectMap, "term", m.Term)
	populate(objectMap, "totalCostWithReservedInstances", m.TotalCostWithReservedInstances)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernReservationRecommendationProperties.
func (m *ModernReservationRecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "costWithNoReservedInstances":
			err = unpopulate(val, "CostWithNoReservedInstances", &m.CostWithNoReservedInstances)
			delete(rawMsg, key)
		case "firstUsageDate":
			err = unpopulateDateTimeRFC3339(val, "FirstUsageDate", &m.FirstUsageDate)
			delete(rawMsg, key)
		case "instanceFlexibilityGroup":
			err = unpopulate(val, "InstanceFlexibilityGroup", &m.InstanceFlexibilityGroup)
			delete(rawMsg, key)
		case "instanceFlexibilityRatio":
			err = unpopulate(val, "InstanceFlexibilityRatio", &m.InstanceFlexibilityRatio)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "lookBackPeriod":
			err = unpopulate(val, "LookBackPeriod", &m.LookBackPeriod)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &m.MeterID)
			delete(rawMsg, key)
		case "netSavings":
			err = unpopulate(val, "NetSavings", &m.NetSavings)
			delete(rawMsg, key)
		case "normalizedSize":
			err = unpopulate(val, "NormalizedSize", &m.NormalizedSize)
			delete(rawMsg, key)
		case "recommendedQuantity":
			err = unpopulate(val, "RecommendedQuantity", &m.RecommendedQuantity)
			delete(rawMsg, key)
		case "recommendedQuantityNormalized":
			err = unpopulate(val, "RecommendedQuantityNormalized", &m.RecommendedQuantityNormalized)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &m.SKUName)
			delete(rawMsg, key)
		case "skuProperties":
			err = unpopulate(val, "SKUProperties", &m.SKUProperties)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &m.Scope)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &m.Term)
			delete(rawMsg, key)
		case "totalCostWithReservedInstances":
			err = unpopulate(val, "TotalCostWithReservedInstances", &m.TotalCostWithReservedInstances)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModernReservationTransaction.
func (m ModernReservationTransaction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernReservationTransaction.
func (m *ModernReservationTransaction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModernReservationTransactionProperties.
func (m ModernReservationTransactionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", m.Amount)
	populate(objectMap, "armSkuName", m.ArmSKUName)
	populate(objectMap, "billingFrequency", m.BillingFrequency)
	populate(objectMap, "billingProfileId", m.BillingProfileID)
	populate(objectMap, "billingProfileName", m.BillingProfileName)
	populate(objectMap, "currency", m.Currency)
	populate(objectMap, "description", m.Description)
	populateDateTimeRFC3339(objectMap, "eventDate", m.EventDate)
	populate(objectMap, "eventType", m.EventType)
	populate(objectMap, "invoice", m.Invoice)
	populate(objectMap, "invoiceId", m.InvoiceID)
	populate(objectMap, "invoiceSectionId", m.InvoiceSectionID)
	populate(objectMap, "invoiceSectionName", m.InvoiceSectionName)
	populate(objectMap, "purchasingSubscriptionGuid", m.PurchasingSubscriptionGUID)
	populate(objectMap, "purchasingSubscriptionName", m.PurchasingSubscriptionName)
	populate(objectMap, "quantity", m.Quantity)
	populate(objectMap, "region", m.Region)
	populate(objectMap, "reservationOrderId", m.ReservationOrderID)
	populate(objectMap, "reservationOrderName", m.ReservationOrderName)
	populate(objectMap, "term", m.Term)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernReservationTransactionProperties.
func (m *ModernReservationTransactionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &m.Amount)
			delete(rawMsg, key)
		case "armSkuName":
			err = unpopulate(val, "ArmSKUName", &m.ArmSKUName)
			delete(rawMsg, key)
		case "billingFrequency":
			err = unpopulate(val, "BillingFrequency", &m.BillingFrequency)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &m.BillingProfileID)
			delete(rawMsg, key)
		case "billingProfileName":
			err = unpopulate(val, "BillingProfileName", &m.BillingProfileName)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &m.Currency)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "eventDate":
			err = unpopulateDateTimeRFC3339(val, "EventDate", &m.EventDate)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &m.EventType)
			delete(rawMsg, key)
		case "invoice":
			err = unpopulate(val, "Invoice", &m.Invoice)
			delete(rawMsg, key)
		case "invoiceId":
			err = unpopulate(val, "InvoiceID", &m.InvoiceID)
			delete(rawMsg, key)
		case "invoiceSectionId":
			err = unpopulate(val, "InvoiceSectionID", &m.InvoiceSectionID)
			delete(rawMsg, key)
		case "invoiceSectionName":
			err = unpopulate(val, "InvoiceSectionName", &m.InvoiceSectionName)
			delete(rawMsg, key)
		case "purchasingSubscriptionGuid":
			err = unpopulate(val, "PurchasingSubscriptionGUID", &m.PurchasingSubscriptionGUID)
			delete(rawMsg, key)
		case "purchasingSubscriptionName":
			err = unpopulate(val, "PurchasingSubscriptionName", &m.PurchasingSubscriptionName)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &m.Quantity)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &m.Region)
			delete(rawMsg, key)
		case "reservationOrderId":
			err = unpopulate(val, "ReservationOrderID", &m.ReservationOrderID)
			delete(rawMsg, key)
		case "reservationOrderName":
			err = unpopulate(val, "ReservationOrderName", &m.ReservationOrderName)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &m.Term)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModernReservationTransactionsListResult.
func (m ModernReservationTransactionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernReservationTransactionsListResult.
func (m *ModernReservationTransactionsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModernUsageDetail.
func (m ModernUsageDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "id", m.ID)
	objectMap["kind"] = UsageDetailsKindModern
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernUsageDetail.
func (m *ModernUsageDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &m.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModernUsageDetailProperties.
func (m ModernUsageDetailProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", m.AdditionalInfo)
	populate(objectMap, "benefitId", m.BenefitID)
	populate(objectMap, "benefitName", m.BenefitName)
	populate(objectMap, "billingAccountId", m.BillingAccountID)
	populate(objectMap, "billingAccountName", m.BillingAccountName)
	populate(objectMap, "billingCurrencyCode", m.BillingCurrencyCode)
	populateDateTimeRFC3339(objectMap, "billingPeriodEndDate", m.BillingPeriodEndDate)
	populateDateTimeRFC3339(objectMap, "billingPeriodStartDate", m.BillingPeriodStartDate)
	populate(objectMap, "billingProfileId", m.BillingProfileID)
	populate(objectMap, "billingProfileName", m.BillingProfileName)
	populate(objectMap, "chargeType", m.ChargeType)
	populate(objectMap, "consumedService", m.ConsumedService)
	populate(objectMap, "costAllocationRuleName", m.CostAllocationRuleName)
	populate(objectMap, "costCenter", m.CostCenter)
	populate(objectMap, "costInBillingCurrency", m.CostInBillingCurrency)
	populate(objectMap, "costInPricingCurrency", m.CostInPricingCurrency)
	populate(objectMap, "costInUSD", m.CostInUSD)
	populate(objectMap, "customerName", m.CustomerName)
	populate(objectMap, "customerTenantId", m.CustomerTenantID)
	populateDateTimeRFC3339(objectMap, "date", m.Date)
	populate(objectMap, "effectivePrice", m.EffectivePrice)
	populate(objectMap, "exchangeRate", m.ExchangeRate)
	populateDateTimeRFC3339(objectMap, "exchangeRateDate", m.ExchangeRateDate)
	populate(objectMap, "exchangeRatePricingToBilling", m.ExchangeRatePricingToBilling)
	populate(objectMap, "frequency", m.Frequency)
	populate(objectMap, "instanceName", m.InstanceName)
	populate(objectMap, "invoiceId", m.InvoiceID)
	populate(objectMap, "invoiceSectionId", m.InvoiceSectionID)
	populate(objectMap, "invoiceSectionName", m.InvoiceSectionName)
	populate(objectMap, "isAzureCreditEligible", m.IsAzureCreditEligible)
	populate(objectMap, "marketPrice", m.MarketPrice)
	populate(objectMap, "meterCategory", m.MeterCategory)
	populate(objectMap, "meterId", m.MeterID)
	populate(objectMap, "meterName", m.MeterName)
	populate(objectMap, "meterRegion", m.MeterRegion)
	populate(objectMap, "meterSubCategory", m.MeterSubCategory)
	populate(objectMap, "partnerEarnedCreditApplied", m.PartnerEarnedCreditApplied)
	populate(objectMap, "partnerEarnedCreditRate", m.PartnerEarnedCreditRate)
	populate(objectMap, "partnerName", m.PartnerName)
	populate(objectMap, "partnerTenantId", m.PartnerTenantID)
	populate(objectMap, "payGPrice", m.PayGPrice)
	populate(objectMap, "paygCostInBillingCurrency", m.PaygCostInBillingCurrency)
	populate(objectMap, "paygCostInUSD", m.PaygCostInUSD)
	populate(objectMap, "previousInvoiceId", m.PreviousInvoiceID)
	populate(objectMap, "pricingCurrencyCode", m.PricingCurrencyCode)
	populate(objectMap, "pricingModel", m.PricingModel)
	populate(objectMap, "product", m.Product)
	populate(objectMap, "productIdentifier", m.ProductIdentifier)
	populate(objectMap, "productOrderId", m.ProductOrderID)
	populate(objectMap, "productOrderName", m.ProductOrderName)
	populate(objectMap, "provider", m.Provider)
	populate(objectMap, "publisherId", m.PublisherID)
	populate(objectMap, "publisherName", m.PublisherName)
	populate(objectMap, "publisherType", m.PublisherType)
	populate(objectMap, "quantity", m.Quantity)
	populate(objectMap, "resellerMpnId", m.ResellerMpnID)
	populate(objectMap, "resellerName", m.ResellerName)
	populate(objectMap, "reservationId", m.ReservationID)
	populate(objectMap, "reservationName", m.ReservationName)
	populate(objectMap, "resourceGroup", m.ResourceGroup)
	populate(objectMap, "resourceLocation", m.ResourceLocation)
	populate(objectMap, "resourceLocationNormalized", m.ResourceLocationNormalized)
	populate(objectMap, "serviceFamily", m.ServiceFamily)
	populate(objectMap, "serviceInfo1", m.ServiceInfo1)
	populate(objectMap, "serviceInfo2", m.ServiceInfo2)
	populateDateTimeRFC3339(objectMap, "servicePeriodEndDate", m.ServicePeriodEndDate)
	populateDateTimeRFC3339(objectMap, "servicePeriodStartDate", m.ServicePeriodStartDate)
	populate(objectMap, "subscriptionGuid", m.SubscriptionGUID)
	populate(objectMap, "subscriptionName", m.SubscriptionName)
	populate(objectMap, "term", m.Term)
	populate(objectMap, "unitOfMeasure", m.UnitOfMeasure)
	populate(objectMap, "unitPrice", m.UnitPrice)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModernUsageDetailProperties.
func (m *ModernUsageDetailProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &m.AdditionalInfo)
			delete(rawMsg, key)
		case "benefitId":
			err = unpopulate(val, "BenefitID", &m.BenefitID)
			delete(rawMsg, key)
		case "benefitName":
			err = unpopulate(val, "BenefitName", &m.BenefitName)
			delete(rawMsg, key)
		case "billingAccountId":
			err = unpopulate(val, "BillingAccountID", &m.BillingAccountID)
			delete(rawMsg, key)
		case "billingAccountName":
			err = unpopulate(val, "BillingAccountName", &m.BillingAccountName)
			delete(rawMsg, key)
		case "billingCurrencyCode":
			err = unpopulate(val, "BillingCurrencyCode", &m.BillingCurrencyCode)
			delete(rawMsg, key)
		case "billingPeriodEndDate":
			err = unpopulateDateTimeRFC3339(val, "BillingPeriodEndDate", &m.BillingPeriodEndDate)
			delete(rawMsg, key)
		case "billingPeriodStartDate":
			err = unpopulateDateTimeRFC3339(val, "BillingPeriodStartDate", &m.BillingPeriodStartDate)
			delete(rawMsg, key)
		case "billingProfileId":
			err = unpopulate(val, "BillingProfileID", &m.BillingProfileID)
			delete(rawMsg, key)
		case "billingProfileName":
			err = unpopulate(val, "BillingProfileName", &m.BillingProfileName)
			delete(rawMsg, key)
		case "chargeType":
			err = unpopulate(val, "ChargeType", &m.ChargeType)
			delete(rawMsg, key)
		case "consumedService":
			err = unpopulate(val, "ConsumedService", &m.ConsumedService)
			delete(rawMsg, key)
		case "costAllocationRuleName":
			err = unpopulate(val, "CostAllocationRuleName", &m.CostAllocationRuleName)
			delete(rawMsg, key)
		case "costCenter":
			err = unpopulate(val, "CostCenter", &m.CostCenter)
			delete(rawMsg, key)
		case "costInBillingCurrency":
			err = unpopulate(val, "CostInBillingCurrency", &m.CostInBillingCurrency)
			delete(rawMsg, key)
		case "costInPricingCurrency":
			err = unpopulate(val, "CostInPricingCurrency", &m.CostInPricingCurrency)
			delete(rawMsg, key)
		case "costInUSD":
			err = unpopulate(val, "CostInUSD", &m.CostInUSD)
			delete(rawMsg, key)
		case "customerName":
			err = unpopulate(val, "CustomerName", &m.CustomerName)
			delete(rawMsg, key)
		case "customerTenantId":
			err = unpopulate(val, "CustomerTenantID", &m.CustomerTenantID)
			delete(rawMsg, key)
		case "date":
			err = unpopulateDateTimeRFC3339(val, "Date", &m.Date)
			delete(rawMsg, key)
		case "effectivePrice":
			err = unpopulate(val, "EffectivePrice", &m.EffectivePrice)
			delete(rawMsg, key)
		case "exchangeRate":
			err = unpopulate(val, "ExchangeRate", &m.ExchangeRate)
			delete(rawMsg, key)
		case "exchangeRateDate":
			err = unpopulateDateTimeRFC3339(val, "ExchangeRateDate", &m.ExchangeRateDate)
			delete(rawMsg, key)
		case "exchangeRatePricingToBilling":
			err = unpopulate(val, "ExchangeRatePricingToBilling", &m.ExchangeRatePricingToBilling)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &m.Frequency)
			delete(rawMsg, key)
		case "instanceName":
			err = unpopulate(val, "InstanceName", &m.InstanceName)
			delete(rawMsg, key)
		case "invoiceId":
			err = unpopulate(val, "InvoiceID", &m.InvoiceID)
			delete(rawMsg, key)
		case "invoiceSectionId":
			err = unpopulate(val, "InvoiceSectionID", &m.InvoiceSectionID)
			delete(rawMsg, key)
		case "invoiceSectionName":
			err = unpopulate(val, "InvoiceSectionName", &m.InvoiceSectionName)
			delete(rawMsg, key)
		case "isAzureCreditEligible":
			err = unpopulate(val, "IsAzureCreditEligible", &m.IsAzureCreditEligible)
			delete(rawMsg, key)
		case "marketPrice":
			err = unpopulate(val, "MarketPrice", &m.MarketPrice)
			delete(rawMsg, key)
		case "meterCategory":
			err = unpopulate(val, "MeterCategory", &m.MeterCategory)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &m.MeterID)
			delete(rawMsg, key)
		case "meterName":
			err = unpopulate(val, "MeterName", &m.MeterName)
			delete(rawMsg, key)
		case "meterRegion":
			err = unpopulate(val, "MeterRegion", &m.MeterRegion)
			delete(rawMsg, key)
		case "meterSubCategory":
			err = unpopulate(val, "MeterSubCategory", &m.MeterSubCategory)
			delete(rawMsg, key)
		case "partnerEarnedCreditApplied":
			err = unpopulate(val, "PartnerEarnedCreditApplied", &m.PartnerEarnedCreditApplied)
			delete(rawMsg, key)
		case "partnerEarnedCreditRate":
			err = unpopulate(val, "PartnerEarnedCreditRate", &m.PartnerEarnedCreditRate)
			delete(rawMsg, key)
		case "partnerName":
			err = unpopulate(val, "PartnerName", &m.PartnerName)
			delete(rawMsg, key)
		case "partnerTenantId":
			err = unpopulate(val, "PartnerTenantID", &m.PartnerTenantID)
			delete(rawMsg, key)
		case "payGPrice":
			err = unpopulate(val, "PayGPrice", &m.PayGPrice)
			delete(rawMsg, key)
		case "paygCostInBillingCurrency":
			err = unpopulate(val, "PaygCostInBillingCurrency", &m.PaygCostInBillingCurrency)
			delete(rawMsg, key)
		case "paygCostInUSD":
			err = unpopulate(val, "PaygCostInUSD", &m.PaygCostInUSD)
			delete(rawMsg, key)
		case "previousInvoiceId":
			err = unpopulate(val, "PreviousInvoiceID", &m.PreviousInvoiceID)
			delete(rawMsg, key)
		case "pricingCurrencyCode":
			err = unpopulate(val, "PricingCurrencyCode", &m.PricingCurrencyCode)
			delete(rawMsg, key)
		case "pricingModel":
			err = unpopulate(val, "PricingModel", &m.PricingModel)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &m.Product)
			delete(rawMsg, key)
		case "productIdentifier":
			err = unpopulate(val, "ProductIdentifier", &m.ProductIdentifier)
			delete(rawMsg, key)
		case "productOrderId":
			err = unpopulate(val, "ProductOrderID", &m.ProductOrderID)
			delete(rawMsg, key)
		case "productOrderName":
			err = unpopulate(val, "ProductOrderName", &m.ProductOrderName)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &m.Provider)
			delete(rawMsg, key)
		case "publisherId":
			err = unpopulate(val, "PublisherID", &m.PublisherID)
			delete(rawMsg, key)
		case "publisherName":
			err = unpopulate(val, "PublisherName", &m.PublisherName)
			delete(rawMsg, key)
		case "publisherType":
			err = unpopulate(val, "PublisherType", &m.PublisherType)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &m.Quantity)
			delete(rawMsg, key)
		case "resellerMpnId":
			err = unpopulate(val, "ResellerMpnID", &m.ResellerMpnID)
			delete(rawMsg, key)
		case "resellerName":
			err = unpopulate(val, "ResellerName", &m.ResellerName)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &m.ReservationID)
			delete(rawMsg, key)
		case "reservationName":
			err = unpopulate(val, "ReservationName", &m.ReservationName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &m.ResourceGroup)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &m.ResourceLocation)
			delete(rawMsg, key)
		case "resourceLocationNormalized":
			err = unpopulate(val, "ResourceLocationNormalized", &m.ResourceLocationNormalized)
			delete(rawMsg, key)
		case "serviceFamily":
			err = unpopulate(val, "ServiceFamily", &m.ServiceFamily)
			delete(rawMsg, key)
		case "serviceInfo1":
			err = unpopulate(val, "ServiceInfo1", &m.ServiceInfo1)
			delete(rawMsg, key)
		case "serviceInfo2":
			err = unpopulate(val, "ServiceInfo2", &m.ServiceInfo2)
			delete(rawMsg, key)
		case "servicePeriodEndDate":
			err = unpopulateDateTimeRFC3339(val, "ServicePeriodEndDate", &m.ServicePeriodEndDate)
			delete(rawMsg, key)
		case "servicePeriodStartDate":
			err = unpopulateDateTimeRFC3339(val, "ServicePeriodStartDate", &m.ServicePeriodStartDate)
			delete(rawMsg, key)
		case "subscriptionGuid":
			err = unpopulate(val, "SubscriptionGUID", &m.SubscriptionGUID)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &m.SubscriptionName)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &m.Term)
			delete(rawMsg, key)
		case "unitOfMeasure":
			err = unpopulate(val, "UnitOfMeasure", &m.UnitOfMeasure)
			delete(rawMsg, key)
		case "unitPrice":
			err = unpopulate(val, "UnitPrice", &m.UnitPrice)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Notification.
func (n Notification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contactEmails", n.ContactEmails)
	populate(objectMap, "contactGroups", n.ContactGroups)
	populate(objectMap, "contactRoles", n.ContactRoles)
	populate(objectMap, "enabled", n.Enabled)
	populate(objectMap, "locale", n.Locale)
	populate(objectMap, "operator", n.Operator)
	populate(objectMap, "threshold", n.Threshold)
	populate(objectMap, "thresholdType", n.ThresholdType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Notification.
func (n *Notification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contactEmails":
			err = unpopulate(val, "ContactEmails", &n.ContactEmails)
			delete(rawMsg, key)
		case "contactGroups":
			err = unpopulate(val, "ContactGroups", &n.ContactGroups)
			delete(rawMsg, key)
		case "contactRoles":
			err = unpopulate(val, "ContactRoles", &n.ContactRoles)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &n.Enabled)
			delete(rawMsg, key)
		case "locale":
			err = unpopulate(val, "Locale", &n.Locale)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &n.Operator)
			delete(rawMsg, key)
		case "threshold":
			err = unpopulate(val, "Threshold", &n.Threshold)
			delete(rawMsg, key)
		case "thresholdType":
			err = unpopulate(val, "ThresholdType", &n.ThresholdType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PriceSheetModel.
func (p PriceSheetModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "download", p.Download)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "pricesheets", p.Pricesheets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PriceSheetModel.
func (p *PriceSheetModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "download":
			err = unpopulate(val, "Download", &p.Download)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "pricesheets":
			err = unpopulate(val, "Pricesheets", &p.Pricesheets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PriceSheetProperties.
func (p PriceSheetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingPeriodId", p.BillingPeriodID)
	populate(objectMap, "currencyCode", p.CurrencyCode)
	populate(objectMap, "includedQuantity", p.IncludedQuantity)
	populate(objectMap, "meterDetails", p.MeterDetails)
	populate(objectMap, "meterId", p.MeterID)
	populate(objectMap, "offerId", p.OfferID)
	populate(objectMap, "partNumber", p.PartNumber)
	populate(objectMap, "unitOfMeasure", p.UnitOfMeasure)
	populate(objectMap, "unitPrice", p.UnitPrice)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PriceSheetProperties.
func (p *PriceSheetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingPeriodId":
			err = unpopulate(val, "BillingPeriodID", &p.BillingPeriodID)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &p.CurrencyCode)
			delete(rawMsg, key)
		case "includedQuantity":
			err = unpopulate(val, "IncludedQuantity", &p.IncludedQuantity)
			delete(rawMsg, key)
		case "meterDetails":
			err = unpopulate(val, "MeterDetails", &p.MeterDetails)
			delete(rawMsg, key)
		case "meterId":
			err = unpopulate(val, "MeterID", &p.MeterID)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &p.OfferID)
			delete(rawMsg, key)
		case "partNumber":
			err = unpopulate(val, "PartNumber", &p.PartNumber)
			delete(rawMsg, key)
		case "unitOfMeasure":
			err = unpopulate(val, "UnitOfMeasure", &p.UnitOfMeasure)
			delete(rawMsg, key)
		case "unitPrice":
			err = unpopulate(val, "UnitPrice", &p.UnitPrice)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PriceSheetResult.
func (p PriceSheetResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", p.Etag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PriceSheetResult.
func (p *PriceSheetResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &p.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", p.ETag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &p.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Reseller.
func (r Reseller) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resellerDescription", r.ResellerDescription)
	populate(objectMap, "resellerId", r.ResellerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Reseller.
func (r *Reseller) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resellerDescription":
			err = unpopulate(val, "ResellerDescription", &r.ResellerDescription)
			delete(rawMsg, key)
		case "resellerId":
			err = unpopulate(val, "ResellerID", &r.ResellerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationDetail.
func (r ReservationDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationDetail.
func (r *ReservationDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationDetailProperties.
func (r ReservationDetailProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceFlexibilityGroup", r.InstanceFlexibilityGroup)
	populate(objectMap, "instanceFlexibilityRatio", r.InstanceFlexibilityRatio)
	populate(objectMap, "instanceId", r.InstanceID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "reservationId", r.ReservationID)
	populate(objectMap, "reservationOrderId", r.ReservationOrderID)
	populate(objectMap, "reservedHours", r.ReservedHours)
	populate(objectMap, "skuName", r.SKUName)
	populate(objectMap, "totalReservedQuantity", r.TotalReservedQuantity)
	populateDateTimeRFC3339(objectMap, "usageDate", r.UsageDate)
	populate(objectMap, "usedHours", r.UsedHours)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationDetailProperties.
func (r *ReservationDetailProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceFlexibilityGroup":
			err = unpopulate(val, "InstanceFlexibilityGroup", &r.InstanceFlexibilityGroup)
			delete(rawMsg, key)
		case "instanceFlexibilityRatio":
			err = unpopulate(val, "InstanceFlexibilityRatio", &r.InstanceFlexibilityRatio)
			delete(rawMsg, key)
		case "instanceId":
			err = unpopulate(val, "InstanceID", &r.InstanceID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &r.ReservationID)
			delete(rawMsg, key)
		case "reservationOrderId":
			err = unpopulate(val, "ReservationOrderID", &r.ReservationOrderID)
			delete(rawMsg, key)
		case "reservedHours":
			err = unpopulate(val, "ReservedHours", &r.ReservedHours)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &r.SKUName)
			delete(rawMsg, key)
		case "totalReservedQuantity":
			err = unpopulate(val, "TotalReservedQuantity", &r.TotalReservedQuantity)
			delete(rawMsg, key)
		case "usageDate":
			err = unpopulateDateTimeRFC3339(val, "UsageDate", &r.UsageDate)
			delete(rawMsg, key)
		case "usedHours":
			err = unpopulate(val, "UsedHours", &r.UsedHours)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationDetailsListResult.
func (r ReservationDetailsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationDetailsListResult.
func (r *ReservationDetailsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationRecommendation.
func (r ReservationRecommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	objectMap["kind"] = r.Kind
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationRecommendation.
func (r *ReservationRecommendation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &r.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationRecommendationDetailsCalculatedSavingsProperties.
func (r ReservationRecommendationDetailsCalculatedSavingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "onDemandCost", r.OnDemandCost)
	populate(objectMap, "overageCost", r.OverageCost)
	populate(objectMap, "quantity", r.Quantity)
	populate(objectMap, "reservationCost", r.ReservationCost)
	populate(objectMap, "reservedUnitCount", r.ReservedUnitCount)
	populate(objectMap, "savings", r.Savings)
	populate(objectMap, "totalReservationCost", r.TotalReservationCost)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationRecommendationDetailsCalculatedSavingsProperties.
func (r *ReservationRecommendationDetailsCalculatedSavingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "onDemandCost":
			err = unpopulate(val, "OnDemandCost", &r.OnDemandCost)
			delete(rawMsg, key)
		case "overageCost":
			err = unpopulate(val, "OverageCost", &r.OverageCost)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &r.Quantity)
			delete(rawMsg, key)
		case "reservationCost":
			err = unpopulate(val, "ReservationCost", &r.ReservationCost)
			delete(rawMsg, key)
		case "reservedUnitCount":
			err = unpopulate(val, "ReservedUnitCount", &r.ReservedUnitCount)
			delete(rawMsg, key)
		case "savings":
			err = unpopulate(val, "Savings", &r.Savings)
			delete(rawMsg, key)
		case "totalReservationCost":
			err = unpopulate(val, "TotalReservationCost", &r.TotalReservationCost)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationRecommendationDetailsModel.
func (r ReservationRecommendationDetailsModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationRecommendationDetailsModel.
func (r *ReservationRecommendationDetailsModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &r.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationRecommendationDetailsProperties.
func (r ReservationRecommendationDetailsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currency", r.Currency)
	populate(objectMap, "resource", r.Resource)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "savings", r.Savings)
	populate(objectMap, "scope", r.Scope)
	populate(objectMap, "usage", r.Usage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationRecommendationDetailsProperties.
func (r *ReservationRecommendationDetailsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currency":
			err = unpopulate(val, "Currency", &r.Currency)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &r.Resource)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "savings":
			err = unpopulate(val, "Savings", &r.Savings)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		case "usage":
			err = unpopulate(val, "Usage", &r.Usage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationRecommendationDetailsResourceProperties.
func (r ReservationRecommendationDetailsResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedScopes", r.AppliedScopes)
	populate(objectMap, "onDemandRate", r.OnDemandRate)
	populate(objectMap, "product", r.Product)
	populate(objectMap, "region", r.Region)
	populate(objectMap, "reservationRate", r.ReservationRate)
	populate(objectMap, "resourceType", r.ResourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationRecommendationDetailsResourceProperties.
func (r *ReservationRecommendationDetailsResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedScopes":
			err = unpopulate(val, "AppliedScopes", &r.AppliedScopes)
			delete(rawMsg, key)
		case "onDemandRate":
			err = unpopulate(val, "OnDemandRate", &r.OnDemandRate)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &r.Product)
			delete(rawMsg, key)
		case "region":
			err = unpopulate(val, "Region", &r.Region)
			delete(rawMsg, key)
		case "reservationRate":
			err = unpopulate(val, "ReservationRate", &r.ReservationRate)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &r.ResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationRecommendationDetailsSavingsProperties.
func (r ReservationRecommendationDetailsSavingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "calculatedSavings", r.CalculatedSavings)
	populate(objectMap, "lookBackPeriod", r.LookBackPeriod)
	populate(objectMap, "recommendedQuantity", r.RecommendedQuantity)
	populate(objectMap, "reservationOrderTerm", r.ReservationOrderTerm)
	populate(objectMap, "savingsType", r.SavingsType)
	populate(objectMap, "unitOfMeasure", r.UnitOfMeasure)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationRecommendationDetailsSavingsProperties.
func (r *ReservationRecommendationDetailsSavingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "calculatedSavings":
			err = unpopulate(val, "CalculatedSavings", &r.CalculatedSavings)
			delete(rawMsg, key)
		case "lookBackPeriod":
			err = unpopulate(val, "LookBackPeriod", &r.LookBackPeriod)
			delete(rawMsg, key)
		case "recommendedQuantity":
			err = unpopulate(val, "RecommendedQuantity", &r.RecommendedQuantity)
			delete(rawMsg, key)
		case "reservationOrderTerm":
			err = unpopulate(val, "ReservationOrderTerm", &r.ReservationOrderTerm)
			delete(rawMsg, key)
		case "savingsType":
			err = unpopulate(val, "SavingsType", &r.SavingsType)
			delete(rawMsg, key)
		case "unitOfMeasure":
			err = unpopulate(val, "UnitOfMeasure", &r.UnitOfMeasure)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationRecommendationDetailsUsageProperties.
func (r ReservationRecommendationDetailsUsageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "firstConsumptionDate", r.FirstConsumptionDate)
	populate(objectMap, "lastConsumptionDate", r.LastConsumptionDate)
	populate(objectMap, "lookBackUnitType", r.LookBackUnitType)
	populate(objectMap, "usageData", r.UsageData)
	populate(objectMap, "usageGrain", r.UsageGrain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationRecommendationDetailsUsageProperties.
func (r *ReservationRecommendationDetailsUsageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "firstConsumptionDate":
			err = unpopulate(val, "FirstConsumptionDate", &r.FirstConsumptionDate)
			delete(rawMsg, key)
		case "lastConsumptionDate":
			err = unpopulate(val, "LastConsumptionDate", &r.LastConsumptionDate)
			delete(rawMsg, key)
		case "lookBackUnitType":
			err = unpopulate(val, "LookBackUnitType", &r.LookBackUnitType)
			delete(rawMsg, key)
		case "usageData":
			err = unpopulate(val, "UsageData", &r.UsageData)
			delete(rawMsg, key)
		case "usageGrain":
			err = unpopulate(val, "UsageGrain", &r.UsageGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationRecommendationsListResult.
func (r ReservationRecommendationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "previousLink", r.PreviousLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationRecommendationsListResult.
func (r *ReservationRecommendationsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "previousLink":
			err = unpopulate(val, "PreviousLink", &r.PreviousLink)
			delete(rawMsg, key)
		case "value":
			r.Value, err = unmarshalReservationRecommendationClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationSummariesListResult.
func (r ReservationSummariesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationSummariesListResult.
func (r *ReservationSummariesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationSummary.
func (r ReservationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationSummary.
func (r *ReservationSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationSummaryProperties.
func (r ReservationSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "avgUtilizationPercentage", r.AvgUtilizationPercentage)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "maxUtilizationPercentage", r.MaxUtilizationPercentage)
	populate(objectMap, "minUtilizationPercentage", r.MinUtilizationPercentage)
	populate(objectMap, "purchasedQuantity", r.PurchasedQuantity)
	populate(objectMap, "remainingQuantity", r.RemainingQuantity)
	populate(objectMap, "reservationId", r.ReservationID)
	populate(objectMap, "reservationOrderId", r.ReservationOrderID)
	populate(objectMap, "reservedHours", r.ReservedHours)
	populate(objectMap, "skuName", r.SKUName)
	populate(objectMap, "totalReservedQuantity", r.TotalReservedQuantity)
	populateDateTimeRFC3339(objectMap, "usageDate", r.UsageDate)
	populate(objectMap, "usedHours", r.UsedHours)
	populate(objectMap, "usedQuantity", r.UsedQuantity)
	populate(objectMap, "utilizedPercentage", r.UtilizedPercentage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationSummaryProperties.
func (r *ReservationSummaryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "avgUtilizationPercentage":
			err = unpopulate(val, "AvgUtilizationPercentage", &r.AvgUtilizationPercentage)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "maxUtilizationPercentage":
			err = unpopulate(val, "MaxUtilizationPercentage", &r.MaxUtilizationPercentage)
			delete(rawMsg, key)
		case "minUtilizationPercentage":
			err = unpopulate(val, "MinUtilizationPercentage", &r.MinUtilizationPercentage)
			delete(rawMsg, key)
		case "purchasedQuantity":
			err = unpopulate(val, "PurchasedQuantity", &r.PurchasedQuantity)
			delete(rawMsg, key)
		case "remainingQuantity":
			err = unpopulate(val, "RemainingQuantity", &r.RemainingQuantity)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &r.ReservationID)
			delete(rawMsg, key)
		case "reservationOrderId":
			err = unpopulate(val, "ReservationOrderID", &r.ReservationOrderID)
			delete(rawMsg, key)
		case "reservedHours":
			err = unpopulate(val, "ReservedHours", &r.ReservedHours)
			delete(rawMsg, key)
		case "skuName":
			err = unpopulate(val, "SKUName", &r.SKUName)
			delete(rawMsg, key)
		case "totalReservedQuantity":
			err = unpopulate(val, "TotalReservedQuantity", &r.TotalReservedQuantity)
			delete(rawMsg, key)
		case "usageDate":
			err = unpopulateDateTimeRFC3339(val, "UsageDate", &r.UsageDate)
			delete(rawMsg, key)
		case "usedHours":
			err = unpopulate(val, "UsedHours", &r.UsedHours)
			delete(rawMsg, key)
		case "usedQuantity":
			err = unpopulate(val, "UsedQuantity", &r.UsedQuantity)
			delete(rawMsg, key)
		case "utilizedPercentage":
			err = unpopulate(val, "UtilizedPercentage", &r.UtilizedPercentage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationTransaction.
func (r ReservationTransaction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationTransaction.
func (r *ReservationTransaction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationTransactionResource.
func (r ReservationTransactionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationTransactionResource.
func (r *ReservationTransactionResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationTransactionsListResult.
func (r ReservationTransactionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationTransactionsListResult.
func (r *ReservationTransactionsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceAttributes.
func (r ResourceAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "sku", r.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceAttributes.
func (r *ResourceAttributes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &r.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUProperty.
func (s SKUProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUProperty.
func (s *SKUProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Tag.
func (t Tag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", t.Key)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Tag.
func (t *Tag) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &t.Key)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagProperties.
func (t TagProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "previousLink", t.PreviousLink)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagProperties.
func (t *TagProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "previousLink":
			err = unpopulate(val, "PreviousLink", &t.PreviousLink)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsResult.
func (t TagsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", t.ETag)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsResult.
func (t *TagsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &t.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageDetail.
func (u UsageDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", u.Etag)
	populate(objectMap, "id", u.ID)
	objectMap["kind"] = u.Kind
	populate(objectMap, "name", u.Name)
	populate(objectMap, "tags", u.Tags)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageDetail.
func (u *UsageDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &u.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &u.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageDetailsListResult.
func (u UsageDetailsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageDetailsListResult.
func (u *UsageDetailsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			u.Value, err = unmarshalUsageDetailClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
