//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerinstance/armcontainerinstance/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// ContainersServer is a fake server for instances of the armcontainerinstance.ContainersClient type.
type ContainersServer struct {
	// Attach is the fake for method ContainersClient.Attach
	// HTTP status codes to indicate success: http.StatusOK
	Attach func(ctx context.Context, resourceGroupName string, containerGroupName string, containerName string, options *armcontainerinstance.ContainersClientAttachOptions) (resp azfake.Responder[armcontainerinstance.ContainersClientAttachResponse], errResp azfake.ErrorResponder)

	// ExecuteCommand is the fake for method ContainersClient.ExecuteCommand
	// HTTP status codes to indicate success: http.StatusOK
	ExecuteCommand func(ctx context.Context, resourceGroupName string, containerGroupName string, containerName string, containerExecRequest armcontainerinstance.ContainerExecRequest, options *armcontainerinstance.ContainersClientExecuteCommandOptions) (resp azfake.Responder[armcontainerinstance.ContainersClientExecuteCommandResponse], errResp azfake.ErrorResponder)

	// ListLogs is the fake for method ContainersClient.ListLogs
	// HTTP status codes to indicate success: http.StatusOK
	ListLogs func(ctx context.Context, resourceGroupName string, containerGroupName string, containerName string, options *armcontainerinstance.ContainersClientListLogsOptions) (resp azfake.Responder[armcontainerinstance.ContainersClientListLogsResponse], errResp azfake.ErrorResponder)
}

// NewContainersServerTransport creates a new instance of ContainersServerTransport with the provided implementation.
// The returned ContainersServerTransport instance is connected to an instance of armcontainerinstance.ContainersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewContainersServerTransport(srv *ContainersServer) *ContainersServerTransport {
	return &ContainersServerTransport{srv: srv}
}

// ContainersServerTransport connects instances of armcontainerinstance.ContainersClient to instances of ContainersServer.
// Don't use this type directly, use NewContainersServerTransport instead.
type ContainersServerTransport struct {
	srv *ContainersServer
}

// Do implements the policy.Transporter interface for ContainersServerTransport.
func (c *ContainersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ContainersClient.Attach":
		resp, err = c.dispatchAttach(req)
	case "ContainersClient.ExecuteCommand":
		resp, err = c.dispatchExecuteCommand(req)
	case "ContainersClient.ListLogs":
		resp, err = c.dispatchListLogs(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ContainersServerTransport) dispatchAttach(req *http.Request) (*http.Response, error) {
	if c.srv.Attach == nil {
		return nil, &nonRetriableError{errors.New("fake for method Attach not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerInstance/containerGroups/(?P<containerGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attach`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	containerGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerGroupName")])
	if err != nil {
		return nil, err
	}
	containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Attach(req.Context(), resourceGroupNameParam, containerGroupNameParam, containerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ContainerAttachResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ContainersServerTransport) dispatchExecuteCommand(req *http.Request) (*http.Response, error) {
	if c.srv.ExecuteCommand == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExecuteCommand not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerInstance/containerGroups/(?P<containerGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/exec`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcontainerinstance.ContainerExecRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	containerGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerGroupName")])
	if err != nil {
		return nil, err
	}
	containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.ExecuteCommand(req.Context(), resourceGroupNameParam, containerGroupNameParam, containerNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ContainerExecResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ContainersServerTransport) dispatchListLogs(req *http.Request) (*http.Response, error) {
	if c.srv.ListLogs == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListLogs not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerInstance/containerGroups/(?P<containerGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/logs`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	containerGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerGroupName")])
	if err != nil {
		return nil, err
	}
	containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
	if err != nil {
		return nil, err
	}
	tailUnescaped, err := url.QueryUnescape(qp.Get("tail"))
	if err != nil {
		return nil, err
	}
	tailParam, err := parseOptional(tailUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	timestampsUnescaped, err := url.QueryUnescape(qp.Get("timestamps"))
	if err != nil {
		return nil, err
	}
	timestampsParam, err := parseOptional(timestampsUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	var options *armcontainerinstance.ContainersClientListLogsOptions
	if tailParam != nil || timestampsParam != nil {
		options = &armcontainerinstance.ContainersClientListLogsOptions{
			Tail:       tailParam,
			Timestamps: timestampsParam,
		}
	}
	respr, errRespr := c.srv.ListLogs(req.Context(), resourceGroupNameParam, containerGroupNameParam, containerNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Logs, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
