//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcosmos_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountGet.json
func ExampleDatabaseAccountsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseAccountsClient().Get(ctx, "rg1", "ddb1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseAccountGetResults = armcosmos.DatabaseAccountGetResults{
	// 	Name: to.Ptr("ddb1"),
	// 	Type: to.Ptr("Microsoft.DocumentDB/databaseAccounts"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.DocumentDB/databaseAccounts/ddb1"),
	// 	Identity: &armcosmos.ManagedServiceIdentity{
	// 		Type: to.Ptr(armcosmos.ResourceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("52f4fef3-3c3f-4ff3-b52e-b5c9eeb68656"),
	// 		TenantID: to.Ptr("33e01921-4d64-4f8c-a055-5bdaffd5e33d"),
	// 		UserAssignedIdentities: map[string]*armcosmos.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties{
	// 			"/subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/eu2cgroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armcosmos.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties{
	// 				ClientID: to.Ptr("fbe75b66-01c5-4f87-a220-233af3270436"),
	// 				PrincipalID: to.Ptr("33e01921-4d64-4f8c-a055-5bdaffd5e33d"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Kind: to.Ptr(armcosmos.DatabaseAccountKindGlobalDocumentDB),
	// 	Properties: &armcosmos.DatabaseAccountGetProperties{
	// 		AnalyticalStorageConfiguration: &armcosmos.AnalyticalStorageConfiguration{
	// 			SchemaType: to.Ptr(armcosmos.AnalyticalStorageSchemaTypeWellDefined),
	// 		},
	// 		APIProperties: &armcosmos.APIProperties{
	// 		},
	// 		BackupPolicy: &armcosmos.PeriodicModeBackupPolicy{
	// 			Type: to.Ptr(armcosmos.BackupPolicyTypePeriodic),
	// 			MigrationState: &armcosmos.BackupPolicyMigrationState{
	// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-09T21:07:16.000Z"); return t}()),
	// 				Status: to.Ptr(armcosmos.BackupPolicyMigrationStatusInProgress),
	// 				TargetType: to.Ptr(armcosmos.BackupPolicyTypeContinuous),
	// 			},
	// 			PeriodicModeProperties: &armcosmos.PeriodicModeProperties{
	// 				BackupIntervalInMinutes: to.Ptr[int32](240),
	// 				BackupRetentionIntervalInHours: to.Ptr[int32](8),
	// 				BackupStorageRedundancy: to.Ptr(armcosmos.BackupStorageRedundancyGeo),
	// 			},
	// 		},
	// 		ConsistencyPolicy: &armcosmos.ConsistencyPolicy{
	// 			DefaultConsistencyLevel: to.Ptr(armcosmos.DefaultConsistencyLevelSession),
	// 			MaxIntervalInSeconds: to.Ptr[int32](5),
	// 			MaxStalenessPrefix: to.Ptr[int64](100),
	// 		},
	// 		Cors: []*armcosmos.CorsPolicy{
	// 		},
	// 		CreateMode: to.Ptr(armcosmos.CreateModeDefault),
	// 		DatabaseAccountOfferType: to.Ptr("Standard"),
	// 		DefaultIdentity: to.Ptr("FirstPartyIdentity"),
	// 		DefaultPriorityLevel: to.Ptr(armcosmos.DefaultPriorityLevelLow),
	// 		DiagnosticLogSettings: &armcosmos.DiagnosticLogSettings{
	// 			EnableFullTextQuery: to.Ptr(armcosmos.EnableFullTextQueryFalse),
	// 		},
	// 		DisableKeyBasedMetadataWriteAccess: to.Ptr(false),
	// 		DocumentEndpoint: to.Ptr("https://ddb1.documents.azure.com:443/"),
	// 		EnableAnalyticalStorage: to.Ptr(true),
	// 		EnableBurstCapacity: to.Ptr(true),
	// 		EnableFreeTier: to.Ptr(false),
	// 		EnableMaterializedViews: to.Ptr(false),
	// 		EnablePartitionMerge: to.Ptr(true),
	// 		EnablePerRegionPerPartitionAutoscale: to.Ptr(true),
	// 		EnablePriorityBasedExecution: to.Ptr(true),
	// 		FailoverPolicies: []*armcosmos.FailoverPolicy{
	// 			{
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-eastus"),
	// 				LocationName: to.Ptr("East US"),
	// 		}},
	// 		InstanceID: to.Ptr("d9b26648-2f53-4541-b3d8-3044f4f9810d"),
	// 		IPRules: []*armcosmos.IPAddressOrRange{
	// 		},
	// 		IsVirtualNetworkFilterEnabled: to.Ptr(false),
	// 		KeysMetadata: &armcosmos.DatabaseAccountKeysMetadata{
	// 			PrimaryMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			PrimaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			SecondaryMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			SecondaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 		},
	// 		Locations: []*armcosmos.Location{
	// 			{
	// 				DocumentEndpoint: to.Ptr("https://ddb1-eastus.documents.azure.com:443/"),
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-eastus"),
	// 				LocationName: to.Ptr("East US"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 		}},
	// 		MinimalTLSVersion: to.Ptr(armcosmos.MinimalTLSVersionTLS),
	// 		NetworkACLBypass: to.Ptr(armcosmos.NetworkACLBypassNone),
	// 		NetworkACLBypassResourceIDs: []*string{
	// 		},
	// 		PrivateEndpointConnections: []*armcosmos.PrivateEndpointConnection{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.DocumentDB/databaseAccounts/account1/privateEndpointConnections/pe1"),
	// 				Properties: &armcosmos.PrivateEndpointConnectionProperties{
	// 					PrivateEndpoint: &armcosmos.PrivateEndpointProperty{
	// 						ID: to.Ptr("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/privateEndpoints/pe1"),
	// 					},
	// 					PrivateLinkServiceConnectionState: &armcosmos.PrivateLinkServiceConnectionStateProperty{
	// 						ActionsRequired: to.Ptr("None"),
	// 						Status: to.Ptr("Approved"),
	// 					},
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ReadLocations: []*armcosmos.Location{
	// 			{
	// 				DocumentEndpoint: to.Ptr("https://ddb1-eastus.documents.azure.com:443/"),
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-eastus"),
	// 				LocationName: to.Ptr("East US"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 		}},
	// 		VirtualNetworkRules: []*armcosmos.VirtualNetworkRule{
	// 		},
	// 		WriteLocations: []*armcosmos.Location{
	// 			{
	// 				DocumentEndpoint: to.Ptr("https://ddb1-eastus.documents.azure.com:443/"),
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-eastus"),
	// 				LocationName: to.Ptr("East US"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountPatch.json
func ExampleDatabaseAccountsClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDatabaseAccountsClient().BeginUpdate(ctx, "rg1", "ddb1", armcosmos.DatabaseAccountUpdateParameters{
		Identity: &armcosmos.ManagedServiceIdentity{
			Type: to.Ptr(armcosmos.ResourceIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armcosmos.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties{
				"/subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/eu2cgroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
			},
		},
		Location: to.Ptr("westus"),
		Properties: &armcosmos.DatabaseAccountUpdateProperties{
			AnalyticalStorageConfiguration: &armcosmos.AnalyticalStorageConfiguration{
				SchemaType: to.Ptr(armcosmos.AnalyticalStorageSchemaTypeWellDefined),
			},
			BackupPolicy: &armcosmos.PeriodicModeBackupPolicy{
				Type: to.Ptr(armcosmos.BackupPolicyTypePeriodic),
				PeriodicModeProperties: &armcosmos.PeriodicModeProperties{
					BackupIntervalInMinutes:        to.Ptr[int32](240),
					BackupRetentionIntervalInHours: to.Ptr[int32](720),
					BackupStorageRedundancy:        to.Ptr(armcosmos.BackupStorageRedundancyGeo),
				},
			},
			Capacity: &armcosmos.Capacity{
				TotalThroughputLimit: to.Ptr[int32](2000),
			},
			ConsistencyPolicy: &armcosmos.ConsistencyPolicy{
				DefaultConsistencyLevel: to.Ptr(armcosmos.DefaultConsistencyLevelBoundedStaleness),
				MaxIntervalInSeconds:    to.Ptr[int32](10),
				MaxStalenessPrefix:      to.Ptr[int64](200),
			},
			DefaultIdentity:      to.Ptr("FirstPartyIdentity"),
			DefaultPriorityLevel: to.Ptr(armcosmos.DefaultPriorityLevelLow),
			DiagnosticLogSettings: &armcosmos.DiagnosticLogSettings{
				EnableFullTextQuery: to.Ptr(armcosmos.EnableFullTextQueryTrue),
			},
			EnableAnalyticalStorage:              to.Ptr(true),
			EnableBurstCapacity:                  to.Ptr(true),
			EnableFreeTier:                       to.Ptr(false),
			EnablePartitionMerge:                 to.Ptr(true),
			EnablePerRegionPerPartitionAutoscale: to.Ptr(true),
			EnablePriorityBasedExecution:         to.Ptr(true),
			IPRules: []*armcosmos.IPAddressOrRange{
				{
					IPAddressOrRange: to.Ptr("23.43.230.120"),
				},
				{
					IPAddressOrRange: to.Ptr("110.12.240.0/12"),
				}},
			IsVirtualNetworkFilterEnabled: to.Ptr(true),
			MinimalTLSVersion:             to.Ptr(armcosmos.MinimalTLSVersionTLS),
			NetworkACLBypass:              to.Ptr(armcosmos.NetworkACLBypassAzureServices),
			NetworkACLBypassResourceIDs: []*string{
				to.Ptr("/subscriptions/subId/resourcegroups/rgName/providers/Microsoft.Synapse/workspaces/workspaceName")},
			VirtualNetworkRules: []*armcosmos.VirtualNetworkRule{
				{
					ID:                               to.Ptr("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
					IgnoreMissingVNetServiceEndpoint: to.Ptr(false),
				}},
		},
		Tags: map[string]*string{
			"dept": to.Ptr("finance"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseAccountGetResults = armcosmos.DatabaseAccountGetResults{
	// 	Name: to.Ptr("ddb1"),
	// 	Type: to.Ptr("Microsoft.DocumentDB/databaseAccounts"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.DocumentDB/databaseAccounts/ddb1"),
	// 	Identity: &armcosmos.ManagedServiceIdentity{
	// 		Type: to.Ptr(armcosmos.ResourceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("52f4fef3-3c3f-4ff3-b52e-b5c9eeb68656"),
	// 		TenantID: to.Ptr("33e01921-4d64-4f8c-a055-5bdaffd5e33d"),
	// 		UserAssignedIdentities: map[string]*armcosmos.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties{
	// 			"/subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/eu2cgroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armcosmos.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties{
	// 				ClientID: to.Ptr("fbe75b66-01c5-4f87-a220-233af3270436"),
	// 				PrincipalID: to.Ptr("075a0ca6-43f6-4434-9abf-c9b1b79f9219"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 		"dept": to.Ptr("finance"),
	// 	},
	// 	Kind: to.Ptr(armcosmos.DatabaseAccountKindGlobalDocumentDB),
	// 	Properties: &armcosmos.DatabaseAccountGetProperties{
	// 		AnalyticalStorageConfiguration: &armcosmos.AnalyticalStorageConfiguration{
	// 			SchemaType: to.Ptr(armcosmos.AnalyticalStorageSchemaTypeWellDefined),
	// 		},
	// 		APIProperties: &armcosmos.APIProperties{
	// 		},
	// 		BackupPolicy: &armcosmos.PeriodicModeBackupPolicy{
	// 			Type: to.Ptr(armcosmos.BackupPolicyTypePeriodic),
	// 			PeriodicModeProperties: &armcosmos.PeriodicModeProperties{
	// 				BackupIntervalInMinutes: to.Ptr[int32](240),
	// 				BackupRetentionIntervalInHours: to.Ptr[int32](720),
	// 				BackupStorageRedundancy: to.Ptr(armcosmos.BackupStorageRedundancyGeo),
	// 			},
	// 		},
	// 		Capacity: &armcosmos.Capacity{
	// 			TotalThroughputLimit: to.Ptr[int32](2000),
	// 		},
	// 		ConsistencyPolicy: &armcosmos.ConsistencyPolicy{
	// 			DefaultConsistencyLevel: to.Ptr(armcosmos.DefaultConsistencyLevelBoundedStaleness),
	// 			MaxIntervalInSeconds: to.Ptr[int32](10),
	// 			MaxStalenessPrefix: to.Ptr[int64](200),
	// 		},
	// 		Cors: []*armcosmos.CorsPolicy{
	// 		},
	// 		CreateMode: to.Ptr(armcosmos.CreateModeDefault),
	// 		DatabaseAccountOfferType: to.Ptr("Standard"),
	// 		DefaultIdentity: to.Ptr("FirstPartyIdentity"),
	// 		DefaultPriorityLevel: to.Ptr(armcosmos.DefaultPriorityLevelLow),
	// 		DiagnosticLogSettings: &armcosmos.DiagnosticLogSettings{
	// 			EnableFullTextQuery: to.Ptr(armcosmos.EnableFullTextQueryTrue),
	// 		},
	// 		DisableKeyBasedMetadataWriteAccess: to.Ptr(false),
	// 		DocumentEndpoint: to.Ptr("https://ddb1.documents.azure.com:443/"),
	// 		EnableAnalyticalStorage: to.Ptr(true),
	// 		EnableBurstCapacity: to.Ptr(true),
	// 		EnableFreeTier: to.Ptr(false),
	// 		EnableMaterializedViews: to.Ptr(false),
	// 		EnablePerRegionPerPartitionAutoscale: to.Ptr(true),
	// 		EnablePriorityBasedExecution: to.Ptr(true),
	// 		FailoverPolicies: []*armcosmos.FailoverPolicy{
	// 			{
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-eastus"),
	// 				LocationName: to.Ptr("East US"),
	// 		}},
	// 		InstanceID: to.Ptr("d9b26648-2f53-4541-b3d8-3044f4f9810d"),
	// 		IPRules: []*armcosmos.IPAddressOrRange{
	// 			{
	// 				IPAddressOrRange: to.Ptr("23.43.230.120"),
	// 			},
	// 			{
	// 				IPAddressOrRange: to.Ptr("110.12.240.0/12"),
	// 		}},
	// 		IsVirtualNetworkFilterEnabled: to.Ptr(true),
	// 		KeysMetadata: &armcosmos.DatabaseAccountKeysMetadata{
	// 			PrimaryMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			PrimaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			SecondaryMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			SecondaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 		},
	// 		Locations: []*armcosmos.Location{
	// 			{
	// 				DocumentEndpoint: to.Ptr("https://ddb1-eastus.documents.azure.com:443/"),
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-eastus"),
	// 				LocationName: to.Ptr("East US"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 		}},
	// 		MinimalTLSVersion: to.Ptr(armcosmos.MinimalTLSVersionTLS),
	// 		NetworkACLBypass: to.Ptr(armcosmos.NetworkACLBypassAzureServices),
	// 		NetworkACLBypassResourceIDs: []*string{
	// 			to.Ptr("/subscriptions/subId/resourcegroups/rgName/providers/Microsoft.Synapse/workspaces/workspaceName")},
	// 			PrivateEndpointConnections: []*armcosmos.PrivateEndpointConnection{
	// 				{
	// 					ID: to.Ptr("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.DocumentDB/databaseAccounts/account1/privateEndpointConnections/pe1"),
	// 					Properties: &armcosmos.PrivateEndpointConnectionProperties{
	// 						PrivateEndpoint: &armcosmos.PrivateEndpointProperty{
	// 							ID: to.Ptr("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/privateEndpoints/pe1"),
	// 						},
	// 						PrivateLinkServiceConnectionState: &armcosmos.PrivateLinkServiceConnectionStateProperty{
	// 							ActionsRequired: to.Ptr("None"),
	// 							Status: to.Ptr("Approved"),
	// 						},
	// 					},
	// 			}},
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			ReadLocations: []*armcosmos.Location{
	// 				{
	// 					DocumentEndpoint: to.Ptr("https://ddb1-eastus.documents.azure.com:443/"),
	// 					FailoverPriority: to.Ptr[int32](0),
	// 					ID: to.Ptr("ddb1-eastus"),
	// 					LocationName: to.Ptr("East US"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 			}},
	// 			VirtualNetworkRules: []*armcosmos.VirtualNetworkRule{
	// 				{
	// 					ID: to.Ptr("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
	// 					IgnoreMissingVNetServiceEndpoint: to.Ptr(false),
	// 			}},
	// 			WriteLocations: []*armcosmos.Location{
	// 				{
	// 					DocumentEndpoint: to.Ptr("https://ddb1-eastus.documents.azure.com:443/"),
	// 					FailoverPriority: to.Ptr[int32](0),
	// 					ID: to.Ptr("ddb1-eastus"),
	// 					LocationName: to.Ptr("East US"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 			}},
	// 		},
	// 		SystemData: &armcosmos.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-12T22:05:09.000Z"); return t}()),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountCreateMax.json
func ExampleDatabaseAccountsClient_BeginCreateOrUpdate_cosmosDbDatabaseAccountCreateMax() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDatabaseAccountsClient().BeginCreateOrUpdate(ctx, "rg1", "ddb1", armcosmos.DatabaseAccountCreateUpdateParameters{
		Identity: &armcosmos.ManagedServiceIdentity{
			Type: to.Ptr(armcosmos.ResourceIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armcosmos.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties{
				"/subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/eu2cgroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
			},
		},
		Location: to.Ptr("westus"),
		Tags:     map[string]*string{},
		Kind:     to.Ptr(armcosmos.DatabaseAccountKindMongoDB),
		Properties: &armcosmos.DatabaseAccountCreateUpdateProperties{
			AnalyticalStorageConfiguration: &armcosmos.AnalyticalStorageConfiguration{
				SchemaType: to.Ptr(armcosmos.AnalyticalStorageSchemaTypeWellDefined),
			},
			APIProperties: &armcosmos.APIProperties{
				ServerVersion: to.Ptr(armcosmos.ServerVersionThree2),
			},
			BackupPolicy: &armcosmos.PeriodicModeBackupPolicy{
				Type: to.Ptr(armcosmos.BackupPolicyTypePeriodic),
				PeriodicModeProperties: &armcosmos.PeriodicModeProperties{
					BackupIntervalInMinutes:        to.Ptr[int32](240),
					BackupRetentionIntervalInHours: to.Ptr[int32](8),
					BackupStorageRedundancy:        to.Ptr(armcosmos.BackupStorageRedundancyGeo),
				},
			},
			Capacity: &armcosmos.Capacity{
				TotalThroughputLimit: to.Ptr[int32](2000),
			},
			ConsistencyPolicy: &armcosmos.ConsistencyPolicy{
				DefaultConsistencyLevel: to.Ptr(armcosmos.DefaultConsistencyLevelBoundedStaleness),
				MaxIntervalInSeconds:    to.Ptr[int32](10),
				MaxStalenessPrefix:      to.Ptr[int64](200),
			},
			Cors: []*armcosmos.CorsPolicy{
				{
					AllowedOrigins: to.Ptr("https://test"),
				}},
			CreateMode:                           to.Ptr(armcosmos.CreateModeDefault),
			DatabaseAccountOfferType:             to.Ptr("Standard"),
			DefaultIdentity:                      to.Ptr("FirstPartyIdentity"),
			DefaultPriorityLevel:                 to.Ptr(armcosmos.DefaultPriorityLevelLow),
			EnableAnalyticalStorage:              to.Ptr(true),
			EnableBurstCapacity:                  to.Ptr(true),
			EnableFreeTier:                       to.Ptr(false),
			EnableMaterializedViews:              to.Ptr(false),
			EnablePerRegionPerPartitionAutoscale: to.Ptr(true),
			EnablePriorityBasedExecution:         to.Ptr(true),
			IPRules: []*armcosmos.IPAddressOrRange{
				{
					IPAddressOrRange: to.Ptr("23.43.230.120"),
				},
				{
					IPAddressOrRange: to.Ptr("110.12.240.0/12"),
				}},
			IsVirtualNetworkFilterEnabled: to.Ptr(true),
			KeyVaultKeyURI:                to.Ptr("https://myKeyVault.vault.azure.net"),
			Locations: []*armcosmos.Location{
				{
					FailoverPriority: to.Ptr[int32](0),
					IsZoneRedundant:  to.Ptr(false),
					LocationName:     to.Ptr("southcentralus"),
				},
				{
					FailoverPriority: to.Ptr[int32](1),
					IsZoneRedundant:  to.Ptr(false),
					LocationName:     to.Ptr("eastus"),
				}},
			MinimalTLSVersion: to.Ptr(armcosmos.MinimalTLSVersionTls12),
			NetworkACLBypass:  to.Ptr(armcosmos.NetworkACLBypassAzureServices),
			NetworkACLBypassResourceIDs: []*string{
				to.Ptr("/subscriptions/subId/resourcegroups/rgName/providers/Microsoft.Synapse/workspaces/workspaceName")},
			PublicNetworkAccess: to.Ptr(armcosmos.PublicNetworkAccessEnabled),
			VirtualNetworkRules: []*armcosmos.VirtualNetworkRule{
				{
					ID:                               to.Ptr("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
					IgnoreMissingVNetServiceEndpoint: to.Ptr(false),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseAccountGetResults = armcosmos.DatabaseAccountGetResults{
	// 	Name: to.Ptr("ddb1"),
	// 	Type: to.Ptr("Microsoft.DocumentDB/databaseAccounts"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.DocumentDB/databaseAccounts/ddb1"),
	// 	Identity: &armcosmos.ManagedServiceIdentity{
	// 		Type: to.Ptr(armcosmos.ResourceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("52f4fef3-3c3f-4ff3-b52e-b5c9eeb68656"),
	// 		TenantID: to.Ptr("33e01921-4d64-4f8c-a055-5bdaffd5e33d"),
	// 		UserAssignedIdentities: map[string]*armcosmos.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties{
	// 			"/subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/eu2cgroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armcosmos.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties{
	// 				ClientID: to.Ptr("fbe75b66-01c5-4f87-a220-233af3270436"),
	// 				PrincipalID: to.Ptr("075a0ca6-43f6-4434-9abf-c9b1b79f9219"),
	// 			},
	// 		},
	// 	},
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Kind: to.Ptr(armcosmos.DatabaseAccountKindMongoDB),
	// 	Properties: &armcosmos.DatabaseAccountGetProperties{
	// 		AnalyticalStorageConfiguration: &armcosmos.AnalyticalStorageConfiguration{
	// 			SchemaType: to.Ptr(armcosmos.AnalyticalStorageSchemaTypeWellDefined),
	// 		},
	// 		APIProperties: &armcosmos.APIProperties{
	// 			ServerVersion: to.Ptr(armcosmos.ServerVersionThree2),
	// 		},
	// 		BackupPolicy: &armcosmos.PeriodicModeBackupPolicy{
	// 			Type: to.Ptr(armcosmos.BackupPolicyTypePeriodic),
	// 			PeriodicModeProperties: &armcosmos.PeriodicModeProperties{
	// 				BackupIntervalInMinutes: to.Ptr[int32](240),
	// 				BackupRetentionIntervalInHours: to.Ptr[int32](8),
	// 				BackupStorageRedundancy: to.Ptr(armcosmos.BackupStorageRedundancyGeo),
	// 			},
	// 		},
	// 		Capacity: &armcosmos.Capacity{
	// 			TotalThroughputLimit: to.Ptr[int32](2000),
	// 		},
	// 		ConsistencyPolicy: &armcosmos.ConsistencyPolicy{
	// 			DefaultConsistencyLevel: to.Ptr(armcosmos.DefaultConsistencyLevelBoundedStaleness),
	// 			MaxIntervalInSeconds: to.Ptr[int32](10),
	// 			MaxStalenessPrefix: to.Ptr[int64](200),
	// 		},
	// 		Cors: []*armcosmos.CorsPolicy{
	// 			{
	// 				AllowedOrigins: to.Ptr("https://test"),
	// 		}},
	// 		CreateMode: to.Ptr(armcosmos.CreateModeDefault),
	// 		DatabaseAccountOfferType: to.Ptr("Standard"),
	// 		DefaultIdentity: to.Ptr("FirstPartyIdentity"),
	// 		DefaultPriorityLevel: to.Ptr(armcosmos.DefaultPriorityLevelLow),
	// 		DisableKeyBasedMetadataWriteAccess: to.Ptr(false),
	// 		EnableAnalyticalStorage: to.Ptr(true),
	// 		EnableBurstCapacity: to.Ptr(true),
	// 		EnableFreeTier: to.Ptr(false),
	// 		EnableMaterializedViews: to.Ptr(false),
	// 		EnablePerRegionPerPartitionAutoscale: to.Ptr(true),
	// 		EnablePriorityBasedExecution: to.Ptr(true),
	// 		FailoverPolicies: []*armcosmos.FailoverPolicy{
	// 			{
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-southcentralus"),
	// 				LocationName: to.Ptr("South Central US"),
	// 			},
	// 			{
	// 				FailoverPriority: to.Ptr[int32](1),
	// 				ID: to.Ptr("ddb1-eastus"),
	// 				LocationName: to.Ptr("East US"),
	// 		}},
	// 		InstanceID: to.Ptr("d9b26648-2f53-4541-b3d8-3044f4f9810d"),
	// 		IPRules: []*armcosmos.IPAddressOrRange{
	// 			{
	// 				IPAddressOrRange: to.Ptr("23.43.230.120"),
	// 			},
	// 			{
	// 				IPAddressOrRange: to.Ptr("110.12.240.0/12"),
	// 		}},
	// 		IsVirtualNetworkFilterEnabled: to.Ptr(true),
	// 		KeyVaultKeyURI: to.Ptr("https://myKeyVault.vault.azure.net"),
	// 		KeysMetadata: &armcosmos.DatabaseAccountKeysMetadata{
	// 			PrimaryMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			PrimaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			SecondaryMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			SecondaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 		},
	// 		Locations: []*armcosmos.Location{
	// 			{
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-southcentralus"),
	// 				IsZoneRedundant: to.Ptr(false),
	// 				LocationName: to.Ptr("South Central US"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 			},
	// 			{
	// 				FailoverPriority: to.Ptr[int32](1),
	// 				ID: to.Ptr("ddb1-eastus"),
	// 				IsZoneRedundant: to.Ptr(false),
	// 				LocationName: to.Ptr("East US"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 		}},
	// 		MinimalTLSVersion: to.Ptr(armcosmos.MinimalTLSVersionTls12),
	// 		NetworkACLBypass: to.Ptr(armcosmos.NetworkACLBypassAzureServices),
	// 		NetworkACLBypassResourceIDs: []*string{
	// 			to.Ptr("/subscriptions/subId/resourcegroups/rgName/providers/Microsoft.Synapse/workspaces/workspaceName")},
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			PublicNetworkAccess: to.Ptr(armcosmos.PublicNetworkAccessEnabled),
	// 			ReadLocations: []*armcosmos.Location{
	// 				{
	// 					FailoverPriority: to.Ptr[int32](0),
	// 					ID: to.Ptr("ddb1-southcentralus"),
	// 					IsZoneRedundant: to.Ptr(false),
	// 					LocationName: to.Ptr("South Central US"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 				},
	// 				{
	// 					FailoverPriority: to.Ptr[int32](1),
	// 					ID: to.Ptr("ddb1-eastus"),
	// 					IsZoneRedundant: to.Ptr(false),
	// 					LocationName: to.Ptr("East US"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 			}},
	// 			VirtualNetworkRules: []*armcosmos.VirtualNetworkRule{
	// 				{
	// 					ID: to.Ptr("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
	// 			}},
	// 			WriteLocations: []*armcosmos.Location{
	// 				{
	// 					FailoverPriority: to.Ptr[int32](0),
	// 					ID: to.Ptr("ddb1-southcentralus"),
	// 					IsZoneRedundant: to.Ptr(false),
	// 					LocationName: to.Ptr("South Central US"),
	// 					ProvisioningState: to.Ptr("Succeeded"),
	// 			}},
	// 		},
	// 		SystemData: &armcosmos.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-12T22:05:09.000Z"); return t}()),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountCreateMin.json
func ExampleDatabaseAccountsClient_BeginCreateOrUpdate_cosmosDbDatabaseAccountCreateMin() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDatabaseAccountsClient().BeginCreateOrUpdate(ctx, "rg1", "ddb1", armcosmos.DatabaseAccountCreateUpdateParameters{
		Location: to.Ptr("westus"),
		Properties: &armcosmos.DatabaseAccountCreateUpdateProperties{
			CreateMode:               to.Ptr(armcosmos.CreateModeDefault),
			DatabaseAccountOfferType: to.Ptr("Standard"),
			Locations: []*armcosmos.Location{
				{
					FailoverPriority: to.Ptr[int32](0),
					IsZoneRedundant:  to.Ptr(false),
					LocationName:     to.Ptr("southcentralus"),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseAccountGetResults = armcosmos.DatabaseAccountGetResults{
	// 	Name: to.Ptr("ddb1"),
	// 	Type: to.Ptr("Microsoft.DocumentDB/databaseAccounts"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.DocumentDB/databaseAccounts/ddb1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Kind: to.Ptr(armcosmos.DatabaseAccountKindGlobalDocumentDB),
	// 	Properties: &armcosmos.DatabaseAccountGetProperties{
	// 		APIProperties: &armcosmos.APIProperties{
	// 		},
	// 		BackupPolicy: &armcosmos.PeriodicModeBackupPolicy{
	// 			Type: to.Ptr(armcosmos.BackupPolicyTypePeriodic),
	// 			PeriodicModeProperties: &armcosmos.PeriodicModeProperties{
	// 				BackupIntervalInMinutes: to.Ptr[int32](240),
	// 				BackupRetentionIntervalInHours: to.Ptr[int32](720),
	// 				BackupStorageRedundancy: to.Ptr(armcosmos.BackupStorageRedundancyGeo),
	// 			},
	// 		},
	// 		ConsistencyPolicy: &armcosmos.ConsistencyPolicy{
	// 			DefaultConsistencyLevel: to.Ptr(armcosmos.DefaultConsistencyLevelSession),
	// 			MaxIntervalInSeconds: to.Ptr[int32](5),
	// 			MaxStalenessPrefix: to.Ptr[int64](100),
	// 		},
	// 		Cors: []*armcosmos.CorsPolicy{
	// 		},
	// 		CreateMode: to.Ptr(armcosmos.CreateModeDefault),
	// 		DatabaseAccountOfferType: to.Ptr("Standard"),
	// 		DisableKeyBasedMetadataWriteAccess: to.Ptr(false),
	// 		EnableAnalyticalStorage: to.Ptr(false),
	// 		EnableFreeTier: to.Ptr(false),
	// 		EnableMaterializedViews: to.Ptr(false),
	// 		FailoverPolicies: []*armcosmos.FailoverPolicy{
	// 			{
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-southcentralus"),
	// 				LocationName: to.Ptr("South Central US"),
	// 		}},
	// 		InstanceID: to.Ptr("d9b26648-2f53-4541-b3d8-3044f4f9810d"),
	// 		IPRules: []*armcosmos.IPAddressOrRange{
	// 		},
	// 		KeysMetadata: &armcosmos.DatabaseAccountKeysMetadata{
	// 			PrimaryMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			PrimaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			SecondaryMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			SecondaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 		},
	// 		Locations: []*armcosmos.Location{
	// 			{
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-southcentralus"),
	// 				IsZoneRedundant: to.Ptr(false),
	// 				LocationName: to.Ptr("South Central US"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 		}},
	// 		MinimalTLSVersion: to.Ptr(armcosmos.MinimalTLSVersionTLS),
	// 		NetworkACLBypass: to.Ptr(armcosmos.NetworkACLBypassNone),
	// 		NetworkACLBypassResourceIDs: []*string{
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ReadLocations: []*armcosmos.Location{
	// 			{
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-southcentralus"),
	// 				IsZoneRedundant: to.Ptr(false),
	// 				LocationName: to.Ptr("South Central US"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 		}},
	// 		WriteLocations: []*armcosmos.Location{
	// 			{
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-southcentralus"),
	// 				IsZoneRedundant: to.Ptr(false),
	// 				LocationName: to.Ptr("South Central US"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 		}},
	// 	},
	// 	SystemData: &armcosmos.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-12T22:05:09.000Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBRestoreDatabaseAccountCreateUpdate.json
func ExampleDatabaseAccountsClient_BeginCreateOrUpdate_cosmosDbRestoreDatabaseAccountCreateUpdateJson() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDatabaseAccountsClient().BeginCreateOrUpdate(ctx, "rg1", "ddb1", armcosmos.DatabaseAccountCreateUpdateParameters{
		Location: to.Ptr("westus"),
		Tags:     map[string]*string{},
		Kind:     to.Ptr(armcosmos.DatabaseAccountKindGlobalDocumentDB),
		Properties: &armcosmos.DatabaseAccountCreateUpdateProperties{
			APIProperties: &armcosmos.APIProperties{
				ServerVersion: to.Ptr(armcosmos.ServerVersionThree2),
			},
			BackupPolicy: &armcosmos.ContinuousModeBackupPolicy{
				Type: to.Ptr(armcosmos.BackupPolicyTypeContinuous),
				ContinuousModeProperties: &armcosmos.ContinuousModeProperties{
					Tier: to.Ptr(armcosmos.ContinuousTierContinuous30Days),
				},
			},
			ConsistencyPolicy: &armcosmos.ConsistencyPolicy{
				DefaultConsistencyLevel: to.Ptr(armcosmos.DefaultConsistencyLevelBoundedStaleness),
				MaxIntervalInSeconds:    to.Ptr[int32](10),
				MaxStalenessPrefix:      to.Ptr[int64](200),
			},
			CreateMode:               to.Ptr(armcosmos.CreateModeRestore),
			DatabaseAccountOfferType: to.Ptr("Standard"),
			EnableAnalyticalStorage:  to.Ptr(true),
			EnableFreeTier:           to.Ptr(false),
			EnableMaterializedViews:  to.Ptr(false),
			KeyVaultKeyURI:           to.Ptr("https://myKeyVault.vault.azure.net"),
			Locations: []*armcosmos.Location{
				{
					FailoverPriority: to.Ptr[int32](0),
					IsZoneRedundant:  to.Ptr(false),
					LocationName:     to.Ptr("southcentralus"),
				}},
			MinimalTLSVersion: to.Ptr(armcosmos.MinimalTLSVersionTLS),
			RestoreParameters: &armcosmos.RestoreParameters{
				RestoreSource:          to.Ptr("/subscriptions/subid/providers/Microsoft.DocumentDB/locations/westus/restorableDatabaseAccounts/1a97b4bb-f6a0-430e-ade1-638d781830cc"),
				RestoreTimestampInUTC:  to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-11T22:05:09.000Z"); return t }()),
				RestoreWithTTLDisabled: to.Ptr(false),
				DatabasesToRestore: []*armcosmos.DatabaseRestoreResource{
					{
						CollectionNames: []*string{
							to.Ptr("collection1"),
							to.Ptr("collection2")},
						DatabaseName: to.Ptr("db1"),
					},
					{
						CollectionNames: []*string{
							to.Ptr("collection3"),
							to.Ptr("collection4")},
						DatabaseName: to.Ptr("db2"),
					}},
				RestoreMode:          to.Ptr(armcosmos.RestoreModePointInTime),
				SourceBackupLocation: to.Ptr("westus"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseAccountGetResults = armcosmos.DatabaseAccountGetResults{
	// 	Name: to.Ptr("ddb1"),
	// 	Type: to.Ptr("Microsoft.DocumentDB/databaseAccounts"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.DocumentDB/databaseAccounts/ddb1"),
	// 	Location: to.Ptr("West US"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Kind: to.Ptr(armcosmos.DatabaseAccountKindGlobalDocumentDB),
	// 	Properties: &armcosmos.DatabaseAccountGetProperties{
	// 		APIProperties: &armcosmos.APIProperties{
	// 		},
	// 		BackupPolicy: &armcosmos.ContinuousModeBackupPolicy{
	// 			Type: to.Ptr(armcosmos.BackupPolicyTypeContinuous),
	// 			ContinuousModeProperties: &armcosmos.ContinuousModeProperties{
	// 				Tier: to.Ptr(armcosmos.ContinuousTierContinuous30Days),
	// 			},
	// 		},
	// 		ConsistencyPolicy: &armcosmos.ConsistencyPolicy{
	// 			DefaultConsistencyLevel: to.Ptr(armcosmos.DefaultConsistencyLevelSession),
	// 			MaxIntervalInSeconds: to.Ptr[int32](5),
	// 			MaxStalenessPrefix: to.Ptr[int64](100),
	// 		},
	// 		CreateMode: to.Ptr(armcosmos.CreateModeRestore),
	// 		DatabaseAccountOfferType: to.Ptr("Standard"),
	// 		DisableKeyBasedMetadataWriteAccess: to.Ptr(false),
	// 		EnableAnalyticalStorage: to.Ptr(false),
	// 		EnableFreeTier: to.Ptr(false),
	// 		EnableMaterializedViews: to.Ptr(false),
	// 		FailoverPolicies: []*armcosmos.FailoverPolicy{
	// 			{
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-southcentralus"),
	// 				LocationName: to.Ptr("South Central US"),
	// 		}},
	// 		InstanceID: to.Ptr("d9b26648-2f53-4541-b3d8-3044f4f9810d"),
	// 		IPRules: []*armcosmos.IPAddressOrRange{
	// 		},
	// 		KeysMetadata: &armcosmos.DatabaseAccountKeysMetadata{
	// 			PrimaryMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			PrimaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			SecondaryMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 			SecondaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
	// 				GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
	// 			},
	// 		},
	// 		Locations: []*armcosmos.Location{
	// 			{
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-southcentralus"),
	// 				IsZoneRedundant: to.Ptr(false),
	// 				LocationName: to.Ptr("South Central US"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 		}},
	// 		MinimalTLSVersion: to.Ptr(armcosmos.MinimalTLSVersionTLS),
	// 		NetworkACLBypass: to.Ptr(armcosmos.NetworkACLBypassNone),
	// 		NetworkACLBypassResourceIDs: []*string{
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		ReadLocations: []*armcosmos.Location{
	// 			{
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-southcentralus"),
	// 				IsZoneRedundant: to.Ptr(false),
	// 				LocationName: to.Ptr("South Central US"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 		}},
	// 		WriteLocations: []*armcosmos.Location{
	// 			{
	// 				FailoverPriority: to.Ptr[int32](0),
	// 				ID: to.Ptr("ddb1-southcentralus"),
	// 				IsZoneRedundant: to.Ptr(false),
	// 				LocationName: to.Ptr("South Central US"),
	// 				ProvisioningState: to.Ptr("Succeeded"),
	// 		}},
	// 	},
	// 	SystemData: &armcosmos.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-12T22:05:09.000Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountDelete.json
func ExampleDatabaseAccountsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDatabaseAccountsClient().BeginDelete(ctx, "rg1", "ddb1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountFailoverPriorityChange.json
func ExampleDatabaseAccountsClient_BeginFailoverPriorityChange() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDatabaseAccountsClient().BeginFailoverPriorityChange(ctx, "rg1", "ddb1-failover", armcosmos.FailoverPolicies{
		FailoverPolicies: []*armcosmos.FailoverPolicy{
			{
				FailoverPriority: to.Ptr[int32](0),
				LocationName:     to.Ptr("eastus"),
			},
			{
				FailoverPriority: to.Ptr[int32](1),
				LocationName:     to.Ptr("westus"),
			}},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountList.json
func ExampleDatabaseAccountsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDatabaseAccountsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DatabaseAccountsListResult = armcosmos.DatabaseAccountsListResult{
		// 	Value: []*armcosmos.DatabaseAccountGetResults{
		// 		{
		// 			Name: to.Ptr("ddb1"),
		// 			Type: to.Ptr("Microsoft.DocumentDB/databaseAccounts"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.DocumentDB/databaseAccounts/ddb1"),
		// 			Identity: &armcosmos.ManagedServiceIdentity{
		// 				Type: to.Ptr(armcosmos.ResourceIdentityTypeSystemAssignedUserAssigned),
		// 				PrincipalID: to.Ptr("52f4fef3-3c3f-4ff3-b52e-b5c9eeb68656"),
		// 				TenantID: to.Ptr("33e01921-4d64-4f8c-a055-5bdaffd5e33d"),
		// 				UserAssignedIdentities: map[string]*armcosmos.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties{
		// 					"/subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/eu2cgroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armcosmos.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties{
		// 						ClientID: to.Ptr("fbe75b66-01c5-4f87-a220-233af3270436"),
		// 						PrincipalID: to.Ptr("33e01921-4d64-4f8c-a055-5bdaffd5e33d"),
		// 					},
		// 				},
		// 			},
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Kind: to.Ptr(armcosmos.DatabaseAccountKindGlobalDocumentDB),
		// 			Properties: &armcosmos.DatabaseAccountGetProperties{
		// 				AnalyticalStorageConfiguration: &armcosmos.AnalyticalStorageConfiguration{
		// 					SchemaType: to.Ptr(armcosmos.AnalyticalStorageSchemaTypeWellDefined),
		// 				},
		// 				APIProperties: &armcosmos.APIProperties{
		// 				},
		// 				BackupPolicy: &armcosmos.PeriodicModeBackupPolicy{
		// 					Type: to.Ptr(armcosmos.BackupPolicyTypePeriodic),
		// 					PeriodicModeProperties: &armcosmos.PeriodicModeProperties{
		// 						BackupIntervalInMinutes: to.Ptr[int32](240),
		// 						BackupRetentionIntervalInHours: to.Ptr[int32](720),
		// 						BackupStorageRedundancy: to.Ptr(armcosmos.BackupStorageRedundancyGeo),
		// 					},
		// 				},
		// 				ConsistencyPolicy: &armcosmos.ConsistencyPolicy{
		// 					DefaultConsistencyLevel: to.Ptr(armcosmos.DefaultConsistencyLevelSession),
		// 					MaxIntervalInSeconds: to.Ptr[int32](5),
		// 					MaxStalenessPrefix: to.Ptr[int64](100),
		// 				},
		// 				Cors: []*armcosmos.CorsPolicy{
		// 				},
		// 				CreateMode: to.Ptr(armcosmos.CreateModeDefault),
		// 				DatabaseAccountOfferType: to.Ptr("Standard"),
		// 				DefaultIdentity: to.Ptr("FirstPartyIdentity"),
		// 				DefaultPriorityLevel: to.Ptr(armcosmos.DefaultPriorityLevelLow),
		// 				DisableKeyBasedMetadataWriteAccess: to.Ptr(false),
		// 				DocumentEndpoint: to.Ptr("https://ddb1.documents.azure.com:443/"),
		// 				EnableAnalyticalStorage: to.Ptr(true),
		// 				EnableBurstCapacity: to.Ptr(true),
		// 				EnableFreeTier: to.Ptr(false),
		// 				EnableMaterializedViews: to.Ptr(false),
		// 				EnablePartitionMerge: to.Ptr(true),
		// 				EnablePerRegionPerPartitionAutoscale: to.Ptr(true),
		// 				EnablePriorityBasedExecution: to.Ptr(true),
		// 				FailoverPolicies: []*armcosmos.FailoverPolicy{
		// 					{
		// 						FailoverPriority: to.Ptr[int32](0),
		// 						ID: to.Ptr("ddb1-eastus"),
		// 						LocationName: to.Ptr("East US"),
		// 				}},
		// 				InstanceID: to.Ptr("d9b26648-2f53-4541-b3d8-3044f4f9810d"),
		// 				IPRules: []*armcosmos.IPAddressOrRange{
		// 				},
		// 				KeysMetadata: &armcosmos.DatabaseAccountKeysMetadata{
		// 					PrimaryMasterKey: &armcosmos.AccountKeyMetadata{
		// 						GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
		// 					},
		// 					PrimaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
		// 						GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
		// 					},
		// 					SecondaryMasterKey: &armcosmos.AccountKeyMetadata{
		// 						GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
		// 					},
		// 					SecondaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
		// 						GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
		// 					},
		// 				},
		// 				Locations: []*armcosmos.Location{
		// 					{
		// 						DocumentEndpoint: to.Ptr("https://ddb1-eastus.documents.azure.com:443/"),
		// 						FailoverPriority: to.Ptr[int32](0),
		// 						ID: to.Ptr("ddb1-eastus"),
		// 						LocationName: to.Ptr("East US"),
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 				}},
		// 				MinimalTLSVersion: to.Ptr(armcosmos.MinimalTLSVersionTLS),
		// 				NetworkACLBypass: to.Ptr(armcosmos.NetworkACLBypassNone),
		// 				NetworkACLBypassResourceIDs: []*string{
		// 				},
		// 				PrivateEndpointConnections: []*armcosmos.PrivateEndpointConnection{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.DocumentDB/databaseAccounts/account1/privateEndpointConnections/pe1"),
		// 						Properties: &armcosmos.PrivateEndpointConnectionProperties{
		// 							PrivateEndpoint: &armcosmos.PrivateEndpointProperty{
		// 								ID: to.Ptr("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/privateEndpoints/pe1"),
		// 							},
		// 							PrivateLinkServiceConnectionState: &armcosmos.PrivateLinkServiceConnectionStateProperty{
		// 								ActionsRequired: to.Ptr("None"),
		// 								Status: to.Ptr("Approved"),
		// 							},
		// 						},
		// 				}},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ReadLocations: []*armcosmos.Location{
		// 					{
		// 						DocumentEndpoint: to.Ptr("https://ddb1-eastus.documents.azure.com:443/"),
		// 						FailoverPriority: to.Ptr[int32](0),
		// 						ID: to.Ptr("ddb1-eastus"),
		// 						LocationName: to.Ptr("East US"),
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 				}},
		// 				WriteLocations: []*armcosmos.Location{
		// 					{
		// 						DocumentEndpoint: to.Ptr("https://ddb1-eastus.documents.azure.com:443/"),
		// 						FailoverPriority: to.Ptr[int32](0),
		// 						ID: to.Ptr("ddb1-eastus"),
		// 						LocationName: to.Ptr("East US"),
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 				}},
		// 			},
		// 			SystemData: &armcosmos.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-12T22:05:09.000Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountListByResourceGroup.json
func ExampleDatabaseAccountsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDatabaseAccountsClient().NewListByResourceGroupPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DatabaseAccountsListResult = armcosmos.DatabaseAccountsListResult{
		// 	Value: []*armcosmos.DatabaseAccountGetResults{
		// 		{
		// 			Name: to.Ptr("ddb1"),
		// 			Type: to.Ptr("Microsoft.DocumentDB/databaseAccounts"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.DocumentDB/databaseAccounts/ddb1"),
		// 			Identity: &armcosmos.ManagedServiceIdentity{
		// 				Type: to.Ptr(armcosmos.ResourceIdentityTypeSystemAssignedUserAssigned),
		// 				PrincipalID: to.Ptr("52f4fef3-3c3f-4ff3-b52e-b5c9eeb68656"),
		// 				TenantID: to.Ptr("33e01921-4d64-4f8c-a055-5bdaffd5e33d"),
		// 				UserAssignedIdentities: map[string]*armcosmos.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties{
		// 					"/subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/eu2cgroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armcosmos.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties{
		// 						ClientID: to.Ptr("fbe75b66-01c5-4f87-a220-233af3270436"),
		// 						PrincipalID: to.Ptr("33e01921-4d64-4f8c-a055-5bdaffd5e33d"),
		// 					},
		// 				},
		// 			},
		// 			Location: to.Ptr("West US"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Kind: to.Ptr(armcosmos.DatabaseAccountKindGlobalDocumentDB),
		// 			Properties: &armcosmos.DatabaseAccountGetProperties{
		// 				BackupPolicy: &armcosmos.PeriodicModeBackupPolicy{
		// 					Type: to.Ptr(armcosmos.BackupPolicyTypePeriodic),
		// 					PeriodicModeProperties: &armcosmos.PeriodicModeProperties{
		// 						BackupIntervalInMinutes: to.Ptr[int32](240),
		// 						BackupRetentionIntervalInHours: to.Ptr[int32](720),
		// 						BackupStorageRedundancy: to.Ptr(armcosmos.BackupStorageRedundancyGeo),
		// 					},
		// 				},
		// 				ConsistencyPolicy: &armcosmos.ConsistencyPolicy{
		// 					DefaultConsistencyLevel: to.Ptr(armcosmos.DefaultConsistencyLevelSession),
		// 					MaxIntervalInSeconds: to.Ptr[int32](5),
		// 					MaxStalenessPrefix: to.Ptr[int64](100),
		// 				},
		// 				Cors: []*armcosmos.CorsPolicy{
		// 				},
		// 				CreateMode: to.Ptr(armcosmos.CreateModeDefault),
		// 				DatabaseAccountOfferType: to.Ptr("Standard"),
		// 				DefaultIdentity: to.Ptr("FirstPartyIdentity"),
		// 				DisableKeyBasedMetadataWriteAccess: to.Ptr(false),
		// 				DocumentEndpoint: to.Ptr("https://ddb1.documents.azure.com:443/"),
		// 				EnableFreeTier: to.Ptr(false),
		// 				EnableMaterializedViews: to.Ptr(false),
		// 				FailoverPolicies: []*armcosmos.FailoverPolicy{
		// 					{
		// 						FailoverPriority: to.Ptr[int32](0),
		// 						ID: to.Ptr("ddb1-eastus"),
		// 						LocationName: to.Ptr("East US"),
		// 				}},
		// 				InstanceID: to.Ptr("d9b26648-2f53-4541-b3d8-3044f4f9810d"),
		// 				IPRules: []*armcosmos.IPAddressOrRange{
		// 				},
		// 				KeysMetadata: &armcosmos.DatabaseAccountKeysMetadata{
		// 					PrimaryMasterKey: &armcosmos.AccountKeyMetadata{
		// 						GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
		// 					},
		// 					PrimaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
		// 						GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
		// 					},
		// 					SecondaryMasterKey: &armcosmos.AccountKeyMetadata{
		// 						GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
		// 					},
		// 					SecondaryReadonlyMasterKey: &armcosmos.AccountKeyMetadata{
		// 						GenerationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2022-02-25T20:30:11.000Z"); return t}()),
		// 					},
		// 				},
		// 				Locations: []*armcosmos.Location{
		// 					{
		// 						DocumentEndpoint: to.Ptr("https://ddb1-eastus.documents.azure.com:443/"),
		// 						FailoverPriority: to.Ptr[int32](0),
		// 						ID: to.Ptr("ddb1-eastus"),
		// 						LocationName: to.Ptr("East US"),
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 				}},
		// 				MinimalTLSVersion: to.Ptr(armcosmos.MinimalTLSVersionTLS),
		// 				NetworkACLBypass: to.Ptr(armcosmos.NetworkACLBypassNone),
		// 				NetworkACLBypassResourceIDs: []*string{
		// 				},
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				ReadLocations: []*armcosmos.Location{
		// 					{
		// 						DocumentEndpoint: to.Ptr("https://ddb1-eastus.documents.azure.com:443/"),
		// 						FailoverPriority: to.Ptr[int32](0),
		// 						ID: to.Ptr("ddb1-eastus"),
		// 						LocationName: to.Ptr("East US"),
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 				}},
		// 				WriteLocations: []*armcosmos.Location{
		// 					{
		// 						DocumentEndpoint: to.Ptr("https://ddb1-eastus.documents.azure.com:443/"),
		// 						FailoverPriority: to.Ptr[int32](0),
		// 						ID: to.Ptr("ddb1-eastus"),
		// 						LocationName: to.Ptr("East US"),
		// 						ProvisioningState: to.Ptr("Succeeded"),
		// 				}},
		// 			},
		// 			SystemData: &armcosmos.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-12T22:05:09.000Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountListKeys.json
func ExampleDatabaseAccountsClient_ListKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseAccountsClient().ListKeys(ctx, "rg1", "ddb1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseAccountListKeysResult = armcosmos.DatabaseAccountListKeysResult{
	// 	PrimaryReadonlyMasterKey: to.Ptr("primaryReadonlyMasterKey"),
	// 	SecondaryReadonlyMasterKey: to.Ptr("secondaryReadonlyMasterKey"),
	// 	PrimaryMasterKey: to.Ptr("primaryMasterKey"),
	// 	SecondaryMasterKey: to.Ptr("secondaryMasterKey"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountListConnectionStrings.json
func ExampleDatabaseAccountsClient_ListConnectionStrings_cosmosDbDatabaseAccountListConnectionStrings() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseAccountsClient().ListConnectionStrings(ctx, "rg1", "ddb1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseAccountListConnectionStringsResult = armcosmos.DatabaseAccountListConnectionStringsResult{
	// 	ConnectionStrings: []*armcosmos.DatabaseAccountConnectionString{
	// 		{
	// 			Type: to.Ptr(armcosmos.TypeSQL),
	// 			Description: to.Ptr("Primary SQL Connection String"),
	// 			ConnectionString: to.Ptr("connection-string"),
	// 			KeyKind: to.Ptr(armcosmos.KindPrimary),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountListConnectionStringsMongo.json
func ExampleDatabaseAccountsClient_ListConnectionStrings_cosmosDbDatabaseAccountListConnectionStringsMongo() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseAccountsClient().ListConnectionStrings(ctx, "rg1", "mongo-ddb1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseAccountListConnectionStringsResult = armcosmos.DatabaseAccountListConnectionStringsResult{
	// 	ConnectionStrings: []*armcosmos.DatabaseAccountConnectionString{
	// 		{
	// 			Description: to.Ptr("Name of the connection string"),
	// 			ConnectionString: to.Ptr("connection-string"),
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountOfflineRegion.json
func ExampleDatabaseAccountsClient_BeginOfflineRegion() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDatabaseAccountsClient().BeginOfflineRegion(ctx, "rg1", "ddb1", armcosmos.RegionForOnlineOffline{
		Region: to.Ptr("North Europe"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountOnlineRegion.json
func ExampleDatabaseAccountsClient_BeginOnlineRegion() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDatabaseAccountsClient().BeginOnlineRegion(ctx, "rg1", "ddb1", armcosmos.RegionForOnlineOffline{
		Region: to.Ptr("North Europe"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountListReadOnlyKeys.json
func ExampleDatabaseAccountsClient_GetReadOnlyKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseAccountsClient().GetReadOnlyKeys(ctx, "rg1", "ddb1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseAccountListReadOnlyKeysResult = armcosmos.DatabaseAccountListReadOnlyKeysResult{
	// 	PrimaryReadonlyMasterKey: to.Ptr("primaryReadonlyMasterKey"),
	// 	SecondaryReadonlyMasterKey: to.Ptr("secondaryReadonlyMasterKey"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountRegenerateKey.json
func ExampleDatabaseAccountsClient_BeginRegenerateKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDatabaseAccountsClient().BeginRegenerateKey(ctx, "rg1", "ddb1", armcosmos.DatabaseAccountRegenerateKeyParameters{
		KeyKind: to.Ptr(armcosmos.KeyKindPrimary),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountCheckNameExists.json
func ExampleDatabaseAccountsClient_CheckNameExists() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDatabaseAccountsClient().CheckNameExists(ctx, "ddb1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountGetMetrics.json
func ExampleDatabaseAccountsClient_NewListMetricsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDatabaseAccountsClient().NewListMetricsPager("rg1", "ddb1", "$filter=(name.value eq 'Total Requests') and timeGrain eq duration'PT5M' and startTime eq '2017-11-19T23:53:55.2780000Z' and endTime eq '2017-11-20T00:13:55.2780000Z", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricListResult = armcosmos.MetricListResult{
		// 	Value: []*armcosmos.Metric{
		// 		{
		// 			Name: &armcosmos.MetricName{
		// 				LocalizedValue: to.Ptr("Total Requests"),
		// 				Value: to.Ptr("Total Requests"),
		// 			},
		// 			EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-20T00:13:55.278Z"); return t}()),
		// 			MetricValues: []*armcosmos.MetricValue{
		// 				{
		// 					Count: to.Ptr[int32](0),
		// 					Average: to.Ptr[float64](0),
		// 					Timestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-19T23:53:55.278Z"); return t}()),
		// 					Total: to.Ptr[float64](0),
		// 				},
		// 				{
		// 					Count: to.Ptr[int32](0),
		// 					Average: to.Ptr[float64](0),
		// 					Timestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-19T23:58:55.278Z"); return t}()),
		// 					Total: to.Ptr[float64](0),
		// 				},
		// 				{
		// 					Count: to.Ptr[int32](0),
		// 					Average: to.Ptr[float64](0),
		// 					Timestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-20T00:03:55.278Z"); return t}()),
		// 					Total: to.Ptr[float64](0),
		// 				},
		// 				{
		// 					Count: to.Ptr[int32](0),
		// 					Average: to.Ptr[float64](0),
		// 					Timestamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-20T00:08:55.278Z"); return t}()),
		// 					Total: to.Ptr[float64](0),
		// 			}},
		// 			StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-19T23:53:55.278Z"); return t}()),
		// 			TimeGrain: to.Ptr("PT5M"),
		// 			Unit: to.Ptr(armcosmos.UnitTypeCount),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountGetUsages.json
func ExampleDatabaseAccountsClient_NewListUsagesPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDatabaseAccountsClient().NewListUsagesPager("rg1", "ddb1", &armcosmos.DatabaseAccountsClientListUsagesOptions{Filter: to.Ptr("$filter=name.value eq 'Storage'")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.UsagesResult = armcosmos.UsagesResult{
		// 	Value: []*armcosmos.Usage{
		// 		{
		// 			Name: &armcosmos.MetricName{
		// 				LocalizedValue: to.Ptr("Storage"),
		// 				Value: to.Ptr("Storage"),
		// 			},
		// 			CurrentValue: to.Ptr[int64](0),
		// 			Limit: to.Ptr[int64](10737418240),
		// 			QuotaPeriod: to.Ptr("P1D"),
		// 			Unit: to.Ptr(armcosmos.UnitTypeBytes),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/cosmos-db/resource-manager/Microsoft.DocumentDB/preview/2024-02-15-preview/examples/CosmosDBDatabaseAccountGetMetricDefinitions.json
func ExampleDatabaseAccountsClient_NewListMetricDefinitionsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcosmos.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDatabaseAccountsClient().NewListMetricDefinitionsPager("rg1", "ddb1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MetricDefinitionsListResult = armcosmos.MetricDefinitionsListResult{
		// 	Value: []*armcosmos.MetricDefinition{
		// 		{
		// 			Name: &armcosmos.MetricName{
		// 				LocalizedValue: to.Ptr("Total Requests"),
		// 				Value: to.Ptr("Total Requests"),
		// 			},
		// 			MetricAvailabilities: []*armcosmos.MetricAvailability{
		// 				{
		// 					Retention: to.Ptr("P2D"),
		// 					TimeGrain: to.Ptr("PT5M"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P14D"),
		// 					TimeGrain: to.Ptr("PT1H"),
		// 				},
		// 				{
		// 					Retention: to.Ptr("P60D"),
		// 					TimeGrain: to.Ptr("P1D"),
		// 			}},
		// 			PrimaryAggregationType: to.Ptr(armcosmos.PrimaryAggregationTypeTotal),
		// 			ResourceURI: to.Ptr("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.DocumentDB/databaseAccounts/ddb1"),
		// 			Unit: to.Ptr(armcosmos.UnitTypeCount),
		// 	}},
		// }
	}
}
