//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/costmanagement/armcostmanagement/v2"
	"net/http"
	"net/url"
	"regexp"
)

// GenerateDetailedCostReportOperationStatusServer is a fake server for instances of the armcostmanagement.GenerateDetailedCostReportOperationStatusClient type.
type GenerateDetailedCostReportOperationStatusServer struct {
	// Get is the fake for method GenerateDetailedCostReportOperationStatusClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, operationID string, scope string, options *armcostmanagement.GenerateDetailedCostReportOperationStatusClientGetOptions) (resp azfake.Responder[armcostmanagement.GenerateDetailedCostReportOperationStatusClientGetResponse], errResp azfake.ErrorResponder)
}

// NewGenerateDetailedCostReportOperationStatusServerTransport creates a new instance of GenerateDetailedCostReportOperationStatusServerTransport with the provided implementation.
// The returned GenerateDetailedCostReportOperationStatusServerTransport instance is connected to an instance of armcostmanagement.GenerateDetailedCostReportOperationStatusClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewGenerateDetailedCostReportOperationStatusServerTransport(srv *GenerateDetailedCostReportOperationStatusServer) *GenerateDetailedCostReportOperationStatusServerTransport {
	return &GenerateDetailedCostReportOperationStatusServerTransport{srv: srv}
}

// GenerateDetailedCostReportOperationStatusServerTransport connects instances of armcostmanagement.GenerateDetailedCostReportOperationStatusClient to instances of GenerateDetailedCostReportOperationStatusServer.
// Don't use this type directly, use NewGenerateDetailedCostReportOperationStatusServerTransport instead.
type GenerateDetailedCostReportOperationStatusServerTransport struct {
	srv *GenerateDetailedCostReportOperationStatusServer
}

// Do implements the policy.Transporter interface for GenerateDetailedCostReportOperationStatusServerTransport.
func (g *GenerateDetailedCostReportOperationStatusServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "GenerateDetailedCostReportOperationStatusClient.Get":
		resp, err = g.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (g *GenerateDetailedCostReportOperationStatusServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if g.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/operationStatus/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.Get(req.Context(), operationIDParam, scopeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GenerateDetailedCostReportOperationStatuses, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
