//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/customerlockbox/armcustomerlockbox"
	"net/http"
)

// PostServer is a fake server for instances of the armcustomerlockbox.PostClient type.
type PostServer struct {
	// DisableLockbox is the fake for method PostClient.DisableLockbox
	// HTTP status codes to indicate success: http.StatusOK
	DisableLockbox func(ctx context.Context, options *armcustomerlockbox.PostClientDisableLockboxOptions) (resp azfake.Responder[armcustomerlockbox.PostClientDisableLockboxResponse], errResp azfake.ErrorResponder)

	// EnableLockbox is the fake for method PostClient.EnableLockbox
	// HTTP status codes to indicate success: http.StatusOK
	EnableLockbox func(ctx context.Context, options *armcustomerlockbox.PostClientEnableLockboxOptions) (resp azfake.Responder[armcustomerlockbox.PostClientEnableLockboxResponse], errResp azfake.ErrorResponder)
}

// NewPostServerTransport creates a new instance of PostServerTransport with the provided implementation.
// The returned PostServerTransport instance is connected to an instance of armcustomerlockbox.PostClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPostServerTransport(srv *PostServer) *PostServerTransport {
	return &PostServerTransport{srv: srv}
}

// PostServerTransport connects instances of armcustomerlockbox.PostClient to instances of PostServer.
// Don't use this type directly, use NewPostServerTransport instead.
type PostServerTransport struct {
	srv *PostServer
}

// Do implements the policy.Transporter interface for PostServerTransport.
func (p *PostServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PostClient.DisableLockbox":
		resp, err = p.dispatchDisableLockbox(req)
	case "PostClient.EnableLockbox":
		resp, err = p.dispatchEnableLockbox(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PostServerTransport) dispatchDisableLockbox(req *http.Request) (*http.Response, error) {
	if p.srv.DisableLockbox == nil {
		return nil, &nonRetriableError{errors.New("fake for method DisableLockbox not implemented")}
	}
	respr, errRespr := p.srv.DisableLockbox(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PostServerTransport) dispatchEnableLockbox(req *http.Request) (*http.Response, error) {
	if p.srv.EnableLockbox == nil {
		return nil, &nonRetriableError{errors.New("fake for method EnableLockbox not implemented")}
	}
	respr, errRespr := p.srv.EnableLockbox(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
