//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataprotection

import "encoding/json"

func unmarshalAuthCredentialsClassification(rawMsg json.RawMessage) (AuthCredentialsClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AuthCredentialsClassification
	switch m["objectType"] {
	case "SecretStoreBasedAuthCredentials":
		b = &SecretStoreBasedAuthCredentials{}
	default:
		b = &AuthCredentials{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalAzureBackupRecoveryPointClassification(rawMsg json.RawMessage) (AzureBackupRecoveryPointClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AzureBackupRecoveryPointClassification
	switch m["objectType"] {
	case "AzureBackupDiscreteRecoveryPoint":
		b = &AzureBackupDiscreteRecoveryPoint{}
	default:
		b = &AzureBackupRecoveryPoint{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalAzureBackupRestoreRequestClassification(rawMsg json.RawMessage) (AzureBackupRestoreRequestClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AzureBackupRestoreRequestClassification
	switch m["objectType"] {
	case "AzureBackupRecoveryPointBasedRestoreRequest":
		b = &AzureBackupRecoveryPointBasedRestoreRequest{}
	case "AzureBackupRecoveryTimeBasedRestoreRequest":
		b = &AzureBackupRecoveryTimeBasedRestoreRequest{}
	case "AzureBackupRestoreWithRehydrationRequest":
		b = &AzureBackupRestoreWithRehydrationRequest{}
	default:
		b = &AzureBackupRestoreRequest{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalBackupCriteriaClassification(rawMsg json.RawMessage) (BackupCriteriaClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b BackupCriteriaClassification
	switch m["objectType"] {
	case "ScheduleBasedBackupCriteria":
		b = &ScheduleBasedBackupCriteria{}
	default:
		b = &BackupCriteria{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalBackupCriteriaClassificationArray(rawMsg json.RawMessage) ([]BackupCriteriaClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]BackupCriteriaClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalBackupCriteriaClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalBackupDatasourceParametersClassification(rawMsg json.RawMessage) (BackupDatasourceParametersClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b BackupDatasourceParametersClassification
	switch m["objectType"] {
	case "BlobBackupDatasourceParameters":
		b = &BlobBackupDatasourceParameters{}
	case "KubernetesClusterBackupDatasourceParameters":
		b = &KubernetesClusterBackupDatasourceParameters{}
	default:
		b = &BackupDatasourceParameters{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalBackupDatasourceParametersClassificationArray(rawMsg json.RawMessage) ([]BackupDatasourceParametersClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]BackupDatasourceParametersClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalBackupDatasourceParametersClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalBackupParametersClassification(rawMsg json.RawMessage) (BackupParametersClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b BackupParametersClassification
	switch m["objectType"] {
	case "AzureBackupParams":
		b = &AzureBackupParams{}
	default:
		b = &BackupParameters{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalBaseBackupPolicyClassification(rawMsg json.RawMessage) (BaseBackupPolicyClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b BaseBackupPolicyClassification
	switch m["objectType"] {
	case "BackupPolicy":
		b = &BackupPolicy{}
	default:
		b = &BaseBackupPolicy{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalBasePolicyRuleClassification(rawMsg json.RawMessage) (BasePolicyRuleClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b BasePolicyRuleClassification
	switch m["objectType"] {
	case "AzureBackupRule":
		b = &AzureBackupRule{}
	case "AzureRetentionRule":
		b = &AzureRetentionRule{}
	default:
		b = &BasePolicyRule{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalBasePolicyRuleClassificationArray(rawMsg json.RawMessage) ([]BasePolicyRuleClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]BasePolicyRuleClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalBasePolicyRuleClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalBaseResourcePropertiesClassification(rawMsg json.RawMessage) (BaseResourcePropertiesClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b BaseResourcePropertiesClassification
	switch m["objectType"] {
	case string(ResourcePropertiesObjectTypeDefaultResourceProperties):
		b = &DefaultResourceProperties{}
	default:
		b = &BaseResourceProperties{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalCopyOptionClassification(rawMsg json.RawMessage) (CopyOptionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b CopyOptionClassification
	switch m["objectType"] {
	case "CopyOnExpiryOption":
		b = &CopyOnExpiryOption{}
	case "CustomCopyOption":
		b = &CustomCopyOption{}
	case "ImmediateCopyOption":
		b = &ImmediateCopyOption{}
	default:
		b = &CopyOption{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalDataStoreParametersClassification(rawMsg json.RawMessage) (DataStoreParametersClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b DataStoreParametersClassification
	switch m["objectType"] {
	case "AzureOperationalStoreParameters":
		b = &AzureOperationalStoreParameters{}
	default:
		b = &DataStoreParameters{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalDataStoreParametersClassificationArray(rawMsg json.RawMessage) ([]DataStoreParametersClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]DataStoreParametersClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalDataStoreParametersClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalDeleteOptionClassification(rawMsg json.RawMessage) (DeleteOptionClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b DeleteOptionClassification
	switch m["objectType"] {
	case "AbsoluteDeleteOption":
		b = &AbsoluteDeleteOption{}
	default:
		b = &DeleteOption{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalFeatureValidationResponseBaseClassification(rawMsg json.RawMessage) (FeatureValidationResponseBaseClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b FeatureValidationResponseBaseClassification
	switch m["objectType"] {
	case "FeatureValidationResponse":
		b = &FeatureValidationResponse{}
	default:
		b = &FeatureValidationResponseBase{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalItemLevelRestoreCriteriaClassification(rawMsg json.RawMessage) (ItemLevelRestoreCriteriaClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b ItemLevelRestoreCriteriaClassification
	switch m["objectType"] {
	case "ItemPathBasedRestoreCriteria":
		b = &ItemPathBasedRestoreCriteria{}
	case "KubernetesClusterRestoreCriteria":
		b = &KubernetesClusterRestoreCriteria{}
	case "KubernetesClusterVaultTierRestoreCriteria":
		b = &KubernetesClusterVaultTierRestoreCriteria{}
	case "KubernetesPVRestoreCriteria":
		b = &KubernetesPVRestoreCriteria{}
	case "KubernetesStorageClassRestoreCriteria":
		b = &KubernetesStorageClassRestoreCriteria{}
	case "RangeBasedItemLevelRestoreCriteria":
		b = &RangeBasedItemLevelRestoreCriteria{}
	default:
		b = &ItemLevelRestoreCriteria{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalItemLevelRestoreCriteriaClassificationArray(rawMsg json.RawMessage) ([]ItemLevelRestoreCriteriaClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]ItemLevelRestoreCriteriaClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalItemLevelRestoreCriteriaClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalOperationExtendedInfoClassification(rawMsg json.RawMessage) (OperationExtendedInfoClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b OperationExtendedInfoClassification
	switch m["objectType"] {
	case "OperationJobExtendedInfo":
		b = &OperationJobExtendedInfo{}
	default:
		b = &OperationExtendedInfo{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalRestoreTargetInfoBaseClassification(rawMsg json.RawMessage) (RestoreTargetInfoBaseClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b RestoreTargetInfoBaseClassification
	switch m["objectType"] {
	case "ItemLevelRestoreTargetInfo":
		b = &ItemLevelRestoreTargetInfo{}
	case "RestoreFilesTargetInfo":
		b = &RestoreFilesTargetInfo{}
	case "RestoreTargetInfo":
		b = &RestoreTargetInfo{}
	default:
		b = &RestoreTargetInfoBase{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalTriggerContextClassification(rawMsg json.RawMessage) (TriggerContextClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b TriggerContextClassification
	switch m["objectType"] {
	case "AdhocBasedTriggerContext":
		b = &AdhocBasedTriggerContext{}
	case "ScheduleBasedTriggerContext":
		b = &ScheduleBasedTriggerContext{}
	default:
		b = &TriggerContext{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
