//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdevcenter_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devcenter/armdevcenter/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2024-02-01/examples/ProjectCatalogs_List.json
func ExampleProjectCatalogsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProjectCatalogsClient().NewListPager("rg1", "DevProject", &armdevcenter.ProjectCatalogsClientListOptions{Top: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CatalogListResult = armdevcenter.CatalogListResult{
		// 	Value: []*armdevcenter.Catalog{
		// 		{
		// 			Name: to.Ptr("CentralCatalog"),
		// 			Type: to.Ptr("Microsoft.DevCenter/projects/catalogs"),
		// 			ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/projects/DevProject/Contoso/catalogs"),
		// 			SystemData: &armdevcenter.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
		// 				CreatedBy: to.Ptr("User1"),
		// 				CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("User1"),
		// 				LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
		// 			},
		// 			Properties: &armdevcenter.CatalogProperties{
		// 				GitHub: &armdevcenter.GitCatalog{
		// 					Path: to.Ptr("/templates"),
		// 					Branch: to.Ptr("main"),
		// 					SecretIdentifier: to.Ptr("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
		// 					URI: to.Ptr("https://github.com/Contoso/centralrepo-fake.git"),
		// 				},
		// 				ConnectionState: to.Ptr(armdevcenter.CatalogConnectionStateConnected),
		// 				LastConnectionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:28:00.314Z"); return t}()),
		// 				LastSyncStats: &armdevcenter.SyncStats{
		// 					Added: to.Ptr[int32](1),
		// 					Removed: to.Ptr[int32](1),
		// 					SynchronizationErrors: to.Ptr[int32](1),
		// 					Unchanged: to.Ptr[int32](1),
		// 					Updated: to.Ptr[int32](1),
		// 					ValidationErrors: to.Ptr[int32](1),
		// 				},
		// 				LastSyncTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:28:00.314Z"); return t}()),
		// 				ProvisioningState: to.Ptr(armdevcenter.ProvisioningStateSucceeded),
		// 				SyncState: to.Ptr(armdevcenter.CatalogSyncStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2024-02-01/examples/ProjectCatalogs_Get.json
func ExampleProjectCatalogsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProjectCatalogsClient().Get(ctx, "rg1", "DevProject", "CentralCatalog", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Catalog = armdevcenter.Catalog{
	// 	Name: to.Ptr("CentralCatalog"),
	// 	Type: to.Ptr("Microsoft.DevCenter/projects/catalogs"),
	// 	ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/projects/DevProject/catalogs/CentralCatalog"),
	// 	SystemData: &armdevcenter.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		CreatedBy: to.Ptr("User1"),
	// 		CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("User1"),
	// 		LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdevcenter.CatalogProperties{
	// 		GitHub: &armdevcenter.GitCatalog{
	// 			Path: to.Ptr("/templates"),
	// 			Branch: to.Ptr("main"),
	// 			SecretIdentifier: to.Ptr("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
	// 			URI: to.Ptr("https://github.com/Contoso/centralrepo-fake.git"),
	// 		},
	// 		ConnectionState: to.Ptr(armdevcenter.CatalogConnectionStateConnected),
	// 		LastConnectionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:28:00.314Z"); return t}()),
	// 		LastSyncStats: &armdevcenter.SyncStats{
	// 			Added: to.Ptr[int32](1),
	// 			Removed: to.Ptr[int32](1),
	// 			SyncedCatalogItemTypes: []*armdevcenter.CatalogItemType{
	// 				to.Ptr(armdevcenter.CatalogItemTypeEnvironmentDefinition)},
	// 				SynchronizationErrors: to.Ptr[int32](1),
	// 				Unchanged: to.Ptr[int32](1),
	// 				Updated: to.Ptr[int32](1),
	// 				ValidationErrors: to.Ptr[int32](1),
	// 			},
	// 			LastSyncTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:28:00.314Z"); return t}()),
	// 			ProvisioningState: to.Ptr(armdevcenter.ProvisioningStateSucceeded),
	// 			SyncState: to.Ptr(armdevcenter.CatalogSyncStateSucceeded),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2024-02-01/examples/ProjectCatalogs_CreateAdo.json
func ExampleProjectCatalogsClient_BeginCreateOrUpdate_projectCatalogsCreateOrUpdateAdo() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProjectCatalogsClient().BeginCreateOrUpdate(ctx, "rg1", "DevProject", "CentralCatalog", armdevcenter.Catalog{
		Properties: &armdevcenter.CatalogProperties{
			AdoGit: &armdevcenter.GitCatalog{
				Path:             to.Ptr("/templates"),
				Branch:           to.Ptr("main"),
				SecretIdentifier: to.Ptr("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
				URI:              to.Ptr("https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Catalog = armdevcenter.Catalog{
	// 	Name: to.Ptr("CentralCatalog"),
	// 	Type: to.Ptr("Microsoft.DevCenter/projects/catalogs"),
	// 	ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/projects/DevProject/catalogs/CentralCatalog"),
	// 	SystemData: &armdevcenter.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		CreatedBy: to.Ptr("User1"),
	// 		CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("User1"),
	// 		LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdevcenter.CatalogProperties{
	// 		AdoGit: &armdevcenter.GitCatalog{
	// 			Path: to.Ptr("/templates"),
	// 			Branch: to.Ptr("main"),
	// 			SecretIdentifier: to.Ptr("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
	// 			URI: to.Ptr("https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso"),
	// 		},
	// 		ConnectionState: to.Ptr(armdevcenter.CatalogConnectionStateConnected),
	// 		LastSyncStats: &armdevcenter.SyncStats{
	// 			Added: to.Ptr[int32](0),
	// 			Removed: to.Ptr[int32](0),
	// 			SyncedCatalogItemTypes: []*armdevcenter.CatalogItemType{
	// 				to.Ptr(armdevcenter.CatalogItemTypeEnvironmentDefinition)},
	// 				SynchronizationErrors: to.Ptr[int32](0),
	// 				Unchanged: to.Ptr[int32](0),
	// 				Updated: to.Ptr[int32](0),
	// 				ValidationErrors: to.Ptr[int32](0),
	// 			},
	// 			ProvisioningState: to.Ptr(armdevcenter.ProvisioningStateSucceeded),
	// 			SyncState: to.Ptr(armdevcenter.CatalogSyncStateSucceeded),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2024-02-01/examples/ProjectCatalogs_CreateGitHub.json
func ExampleProjectCatalogsClient_BeginCreateOrUpdate_projectCatalogsCreateOrUpdateGitHub() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProjectCatalogsClient().BeginCreateOrUpdate(ctx, "rg1", "DevProject", "CentralCatalog", armdevcenter.Catalog{
		Properties: &armdevcenter.CatalogProperties{
			GitHub: &armdevcenter.GitCatalog{
				Path:             to.Ptr("/templates"),
				Branch:           to.Ptr("main"),
				SecretIdentifier: to.Ptr("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
				URI:              to.Ptr("https://github.com/Contoso/centralrepo-fake.git"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Catalog = armdevcenter.Catalog{
	// 	Name: to.Ptr("CentralCatalog"),
	// 	Type: to.Ptr("Microsoft.DevCenter/projects/catalogs"),
	// 	ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/projects/DevProject/catalogs/CentralCatalog"),
	// 	SystemData: &armdevcenter.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		CreatedBy: to.Ptr("User1"),
	// 		CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("User1"),
	// 		LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdevcenter.CatalogProperties{
	// 		GitHub: &armdevcenter.GitCatalog{
	// 			Path: to.Ptr("/templates"),
	// 			Branch: to.Ptr("main"),
	// 			SecretIdentifier: to.Ptr("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
	// 			URI: to.Ptr("https://github.com/Contoso/centralrepo-fake.git"),
	// 		},
	// 		ConnectionState: to.Ptr(armdevcenter.CatalogConnectionStateConnected),
	// 		LastSyncStats: &armdevcenter.SyncStats{
	// 			Added: to.Ptr[int32](0),
	// 			Removed: to.Ptr[int32](0),
	// 			SyncedCatalogItemTypes: []*armdevcenter.CatalogItemType{
	// 				to.Ptr(armdevcenter.CatalogItemTypeEnvironmentDefinition)},
	// 				SynchronizationErrors: to.Ptr[int32](0),
	// 				Unchanged: to.Ptr[int32](0),
	// 				Updated: to.Ptr[int32](0),
	// 				ValidationErrors: to.Ptr[int32](0),
	// 			},
	// 			ProvisioningState: to.Ptr(armdevcenter.ProvisioningStateSucceeded),
	// 			SyncState: to.Ptr(armdevcenter.CatalogSyncStateSucceeded),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2024-02-01/examples/ProjectCatalogs_Patch.json
func ExampleProjectCatalogsClient_BeginPatch() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProjectCatalogsClient().BeginPatch(ctx, "rg1", "DevProject", "CentralCatalog", armdevcenter.CatalogUpdate{
		Properties: &armdevcenter.CatalogUpdateProperties{
			GitHub: &armdevcenter.GitCatalog{
				Path: to.Ptr("/environments"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Catalog = armdevcenter.Catalog{
	// 	Name: to.Ptr("CentralCatalog"),
	// 	Type: to.Ptr("Microsoft.DevCenter/projects/catalogs"),
	// 	ID: to.Ptr("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/projects/DevProject/catalogs/CentralCatalog"),
	// 	SystemData: &armdevcenter.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		CreatedBy: to.Ptr("User1"),
	// 		CreatedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:24:24.818Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("User1"),
	// 		LastModifiedByType: to.Ptr(armdevcenter.CreatedByTypeUser),
	// 	},
	// 	Properties: &armdevcenter.CatalogProperties{
	// 		GitHub: &armdevcenter.GitCatalog{
	// 			Path: to.Ptr("/environments"),
	// 			Branch: to.Ptr("main"),
	// 			SecretIdentifier: to.Ptr("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
	// 			URI: to.Ptr("https://github.com/Contoso/centralrepo-fake.git"),
	// 		},
	// 		ConnectionState: to.Ptr(armdevcenter.CatalogConnectionStateConnected),
	// 		LastConnectionTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:28:00.314Z"); return t}()),
	// 		LastSyncStats: &armdevcenter.SyncStats{
	// 			Added: to.Ptr[int32](1),
	// 			Removed: to.Ptr[int32](1),
	// 			SynchronizationErrors: to.Ptr[int32](1),
	// 			Unchanged: to.Ptr[int32](1),
	// 			Updated: to.Ptr[int32](1),
	// 			ValidationErrors: to.Ptr[int32](1),
	// 		},
	// 		LastSyncTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-11-18T18:28:00.314Z"); return t}()),
	// 		ProvisioningState: to.Ptr(armdevcenter.ProvisioningStateSucceeded),
	// 		SyncState: to.Ptr(armdevcenter.CatalogSyncStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2024-02-01/examples/ProjectCatalogs_Delete.json
func ExampleProjectCatalogsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProjectCatalogsClient().BeginDelete(ctx, "rg1", "DevProject", "CentralCatalog", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2024-02-01/examples/ProjectCatalogs_GetSyncErrorDetails.json
func ExampleProjectCatalogsClient_GetSyncErrorDetails() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProjectCatalogsClient().GetSyncErrorDetails(ctx, "rg1", "DevProject", "CentralCatalog", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SyncErrorDetails = armdevcenter.SyncErrorDetails{
	// 	Conflicts: []*armdevcenter.CatalogConflictError{
	// 		{
	// 			Name: to.Ptr("DuplicateEnvironmentName"),
	// 			Path: to.Ptr("/Environments/Duplicate/manifest.yaml"),
	// 	}},
	// 	Errors: []*armdevcenter.CatalogSyncError{
	// 		{
	// 			Path: to.Ptr("/Environments/Invalid/manifest.yaml"),
	// 			ErrorDetails: []*armdevcenter.CatalogErrorDetails{
	// 				{
	// 					Code: to.Ptr("ParseError"),
	// 					Message: to.Ptr("Schema Error Within Catalog Item: Missing Name"),
	// 			}},
	// 	}},
	// 	OperationError: &armdevcenter.CatalogErrorDetails{
	// 		Code: to.Ptr("Conflict"),
	// 		Message: to.Ptr("The source control credentials could not be validated successfully."),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2024-02-01/examples/ProjectCatalogs_Sync.json
func ExampleProjectCatalogsClient_BeginSync() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProjectCatalogsClient().BeginSync(ctx, "rg1", "DevProject", "CentralCatalog", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/92de53a5f1e0e03c94b40475d2135d97148ed014/specification/devcenter/resource-manager/Microsoft.DevCenter/stable/2024-02-01/examples/ProjectCatalogs_Connect.json
func ExampleProjectCatalogsClient_BeginConnect() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdevcenter.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProjectCatalogsClient().BeginConnect(ctx, "rg1", "DevProject", "CentralCatalog", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
