//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by Microsoft (R) AutoRest Code Generator.Changes may cause incorrect behavior and will be lost if the code
// is regenerated.
// Code generated by @autorest/go. DO NOT EDIT.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/elastic/armelastic"
	"net/http"
	"reflect"
	"regexp"
)

// OrganizationsServer is a fake server for instances of the armelastic.OrganizationsClient type.
type OrganizationsServer struct {
	// GetAPIKey is the fake for method OrganizationsClient.GetAPIKey
	// HTTP status codes to indicate success: http.StatusOK
	GetAPIKey func(ctx context.Context, options *armelastic.OrganizationsClientGetAPIKeyOptions) (resp azfake.Responder[armelastic.OrganizationsClientGetAPIKeyResponse], errResp azfake.ErrorResponder)
}

// NewOrganizationsServerTransport creates a new instance of OrganizationsServerTransport with the provided implementation.
// The returned OrganizationsServerTransport instance is connected to an instance of armelastic.OrganizationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewOrganizationsServerTransport(srv *OrganizationsServer) *OrganizationsServerTransport {
	return &OrganizationsServerTransport{srv: srv}
}

// OrganizationsServerTransport connects instances of armelastic.OrganizationsClient to instances of OrganizationsServer.
// Don't use this type directly, use NewOrganizationsServerTransport instead.
type OrganizationsServerTransport struct {
	srv *OrganizationsServer
}

// Do implements the policy.Transporter interface for OrganizationsServerTransport.
func (o *OrganizationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "OrganizationsClient.GetAPIKey":
		resp, err = o.dispatchGetAPIKey(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (o *OrganizationsServerTransport) dispatchGetAPIKey(req *http.Request) (*http.Response, error) {
	if o.srv.GetAPIKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAPIKey not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Elastic/getOrganizationApiKey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armelastic.UserEmailID](req)
	if err != nil {
		return nil, err
	}
	var options *armelastic.OrganizationsClientGetAPIKeyOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armelastic.OrganizationsClientGetAPIKeyOptions{
			Body: &body,
		}
	}
	respr, errRespr := o.srv.GetAPIKey(req.Context(), options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).UserAPIKeyResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
