//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/fluidrelay/armfluidrelay"
	"net/http"
	"net/url"
	"regexp"
)

// ContainersServer is a fake server for instances of the armfluidrelay.ContainersClient type.
type ContainersServer struct {
	// Delete is the fake for method ContainersClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroup string, fluidRelayServerName string, fluidRelayContainerName string, options *armfluidrelay.ContainersClientDeleteOptions) (resp azfake.Responder[armfluidrelay.ContainersClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ContainersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroup string, fluidRelayServerName string, fluidRelayContainerName string, options *armfluidrelay.ContainersClientGetOptions) (resp azfake.Responder[armfluidrelay.ContainersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByFluidRelayServersPager is the fake for method ContainersClient.NewListByFluidRelayServersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByFluidRelayServersPager func(resourceGroup string, fluidRelayServerName string, options *armfluidrelay.ContainersClientListByFluidRelayServersOptions) (resp azfake.PagerResponder[armfluidrelay.ContainersClientListByFluidRelayServersResponse])
}

// NewContainersServerTransport creates a new instance of ContainersServerTransport with the provided implementation.
// The returned ContainersServerTransport instance is connected to an instance of armfluidrelay.ContainersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewContainersServerTransport(srv *ContainersServer) *ContainersServerTransport {
	return &ContainersServerTransport{
		srv:                             srv,
		newListByFluidRelayServersPager: newTracker[azfake.PagerResponder[armfluidrelay.ContainersClientListByFluidRelayServersResponse]](),
	}
}

// ContainersServerTransport connects instances of armfluidrelay.ContainersClient to instances of ContainersServer.
// Don't use this type directly, use NewContainersServerTransport instead.
type ContainersServerTransport struct {
	srv                             *ContainersServer
	newListByFluidRelayServersPager *tracker[azfake.PagerResponder[armfluidrelay.ContainersClientListByFluidRelayServersResponse]]
}

// Do implements the policy.Transporter interface for ContainersServerTransport.
func (c *ContainersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ContainersClient.Delete":
		resp, err = c.dispatchDelete(req)
	case "ContainersClient.Get":
		resp, err = c.dispatchGet(req)
	case "ContainersClient.NewListByFluidRelayServersPager":
		resp, err = c.dispatchNewListByFluidRelayServersPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ContainersServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if c.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroup>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.FluidRelay/fluidRelayServers/(?P<fluidRelayServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fluidRelayContainers/(?P<fluidRelayContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroup")])
	if err != nil {
		return nil, err
	}
	fluidRelayServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fluidRelayServerName")])
	if err != nil {
		return nil, err
	}
	fluidRelayContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fluidRelayContainerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Delete(req.Context(), resourceGroupParam, fluidRelayServerNameParam, fluidRelayContainerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ContainersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroup>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.FluidRelay/fluidRelayServers/(?P<fluidRelayServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fluidRelayContainers/(?P<fluidRelayContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroup")])
	if err != nil {
		return nil, err
	}
	fluidRelayServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fluidRelayServerName")])
	if err != nil {
		return nil, err
	}
	fluidRelayContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fluidRelayContainerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupParam, fluidRelayServerNameParam, fluidRelayContainerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Container, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ContainersServerTransport) dispatchNewListByFluidRelayServersPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByFluidRelayServersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByFluidRelayServersPager not implemented")}
	}
	newListByFluidRelayServersPager := c.newListByFluidRelayServersPager.get(req)
	if newListByFluidRelayServersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroup>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.FluidRelay/fluidRelayServers/(?P<fluidRelayServerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fluidRelayContainers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroup")])
		if err != nil {
			return nil, err
		}
		fluidRelayServerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fluidRelayServerName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByFluidRelayServersPager(resourceGroupParam, fluidRelayServerNameParam, nil)
		newListByFluidRelayServersPager = &resp
		c.newListByFluidRelayServersPager.add(req, newListByFluidRelayServersPager)
		server.PagerResponderInjectNextLinks(newListByFluidRelayServersPager, req, func(page *armfluidrelay.ContainersClientListByFluidRelayServersResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByFluidRelayServersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByFluidRelayServersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByFluidRelayServersPager) {
		c.newListByFluidRelayServersPager.remove(req)
	}
	return resp, nil
}
