//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhdinsight

import "time"

// AaddsResourceDetails - The Azure active directory domain service resource details.
type AaddsResourceDetails struct {
	// The Azure active directory domain service name.
	DomainName *string

	// This indicates whether initial sync complete or not.
	InitialSyncComplete *bool

	// This indicates whether enable ldaps or not.
	LdapsEnabled *bool

	// The base 64 format string of public ldap certificate.
	LdapsPublicCertificateInBase64 *string

	// The resource id of azure active directory domain service.
	ResourceID *string

	// The subnet resource id.
	SubnetID *string

	// The tenant id of azure active directory domain service .
	TenantID *string
}

// Application - The HDInsight cluster application
type Application struct {
	// The ETag for the application
	Etag *string

	// The properties of the application.
	Properties *ApplicationProperties

	// The tags for the application.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ApplicationGetEndpoint - Gets the application SSH endpoint
type ApplicationGetEndpoint struct {
	// The destination port to connect to.
	DestinationPort *int32

	// The location of the endpoint.
	Location *string

	// The private ip address of the endpoint.
	PrivateIPAddress *string

	// The public port to connect to.
	PublicPort *int32
}

// ApplicationGetHTTPSEndpoint - Gets the application HTTP endpoints.
type ApplicationGetHTTPSEndpoint struct {
	// The list of access modes for the application.
	AccessModes []*string

	// The destination port to connect to.
	DestinationPort *int32

	// The value indicates whether to disable GatewayAuth.
	DisableGatewayAuth *bool

	// The private ip address of the endpoint.
	PrivateIPAddress *string

	// The subdomain suffix of the application.
	SubDomainSuffix *string

	// READ-ONLY; The location of the endpoint.
	Location *string

	// READ-ONLY; The public port to connect to.
	PublicPort *int32
}

// ApplicationListResult - Result of the request to list cluster Applications. It contains a list of operations and a URL
// link to get the next set of results.
type ApplicationListResult struct {
	// The list of HDInsight applications installed on HDInsight cluster.
	Value []*Application

	// READ-ONLY; The URL to get the next set of operation list results if there are any.
	NextLink *string
}

// ApplicationProperties - The HDInsight cluster application GET response.
type ApplicationProperties struct {
	// The application type.
	ApplicationType *string

	// The list of roles in the cluster.
	ComputeProfile *ComputeProfile

	// The list of errors.
	Errors []*Errors

	// The list of application HTTPS endpoints.
	HTTPSEndpoints []*ApplicationGetHTTPSEndpoint

	// The list of install script actions.
	InstallScriptActions []*RuntimeScriptAction

	// The private link configurations.
	PrivateLinkConfigurations []*PrivateLinkConfiguration

	// The list of application SSH endpoints.
	SSHEndpoints []*ApplicationGetEndpoint

	// The list of uninstall script actions.
	UninstallScriptActions []*RuntimeScriptAction

	// READ-ONLY; The application state.
	ApplicationState *string

	// READ-ONLY; The application create date time.
	CreatedDate *string

	// READ-ONLY; The marketplace identifier.
	MarketplaceIdentifier *string

	// READ-ONLY; The provisioning state of the application.
	ProvisioningState *string
}

// AsyncOperationResult - The azure async operation response.
type AsyncOperationResult struct {
	// The operation error information.
	Error *Errors

	// The async operation state.
	Status *AsyncOperationState
}

// Autoscale - The autoscale request parameters
type Autoscale struct {
	// Parameters for load-based autoscale
	Capacity *AutoscaleCapacity

	// Parameters for schedule-based autoscale
	Recurrence *AutoscaleRecurrence
}

// AutoscaleCapacity - The load-based autoscale request parameters
type AutoscaleCapacity struct {
	// The maximum instance count of the cluster
	MaxInstanceCount *int32

	// The minimum instance count of the cluster
	MinInstanceCount *int32
}

// AutoscaleConfigurationUpdateParameter - The autoscale configuration update parameter.
type AutoscaleConfigurationUpdateParameter struct {
	// The autoscale configuration.
	Autoscale *Autoscale
}

// AutoscaleRecurrence - Schedule-based autoscale request parameters
type AutoscaleRecurrence struct {
	// Array of schedule-based autoscale rules
	Schedule []*AutoscaleSchedule

	// The time zone for the autoscale schedule times
	TimeZone *string
}

// AutoscaleSchedule - Parameters for a schedule-based autoscale rule, consisting of an array of days + a time and capacity
type AutoscaleSchedule struct {
	// Days of the week for a schedule-based autoscale rule
	Days []*DaysOfWeek

	// Time and capacity for a schedule-based autoscale rule
	TimeAndCapacity *AutoscaleTimeAndCapacity
}

// AutoscaleTimeAndCapacity - Time and capacity request parameters
type AutoscaleTimeAndCapacity struct {
	// The maximum instance count of the cluster
	MaxInstanceCount *int32

	// The minimum instance count of the cluster
	MinInstanceCount *int32

	// 24-hour time in the form xx:xx
	Time *string
}

// AzureMonitorRequest - The azure monitor parameters.
type AzureMonitorRequest struct {
	// The Log Analytics workspace key.
	PrimaryKey *string

	// The selected configurations.
	SelectedConfigurations *AzureMonitorSelectedConfigurations

	// The Log Analytics workspace ID.
	WorkspaceID *string
}

// AzureMonitorResponse - The azure monitor status response.
type AzureMonitorResponse struct {
	// The status of the monitor on the HDInsight cluster.
	ClusterMonitoringEnabled *bool

	// The selected configurations.
	SelectedConfigurations *AzureMonitorSelectedConfigurations

	// The workspace ID of the monitor on the HDInsight cluster.
	WorkspaceID *string
}

// AzureMonitorSelectedConfigurations - The selected configurations for azure monitor.
type AzureMonitorSelectedConfigurations struct {
	// The configuration version.
	ConfigurationVersion *string

	// The global configurations of selected configurations.
	GlobalConfigurations map[string]*string

	// The table list.
	TableList []*AzureMonitorTableConfiguration
}

// AzureMonitorTableConfiguration - The table configuration for the Log Analytics integration.
type AzureMonitorTableConfiguration struct {
	// The name.
	Name *string
}

// BillingMeters - The billing meters.
type BillingMeters struct {
	// The HDInsight meter guid.
	Meter *string

	// The virtual machine sizes.
	MeterParameter *string

	// The unit of meter, VMHours or CoreHours.
	Unit *string
}

// BillingResources - The billing resources.
type BillingResources struct {
	// The billing meter information.
	BillingMeters []*BillingMeters

	// The managed disk billing information.
	DiskBillingMeters []*DiskBillingMeters

	// The region or location.
	Region *string
}

// BillingResponseListResult - The response for the operation to get regional billingSpecs for a subscription.
type BillingResponseListResult struct {
	// The billing and managed disk billing resources for a region.
	BillingResources []*BillingResources

	// The virtual machine filtering mode. Effectively this can enabling or disabling the virtual machine sizes in a particular
	// set.
	VMSizeFilters []*VMSizeCompatibilityFilterV2

	// The virtual machine sizes to include or exclude.
	VMSizes []*string

	// The vm sizes which enable encryption at host.
	VMSizesWithEncryptionAtHost []*string

	// READ-ONLY; The vm size properties.
	VMSizeProperties []*VMSizeProperty
}

// CapabilitiesResult - The Get Capabilities operation response.
type CapabilitiesResult struct {
	// The capability features.
	Features []*string

	// The virtual machine size compatibility features.
	Regions map[string]*RegionsCapability

	// The version capability.
	Versions map[string]*VersionsCapability

	// READ-ONLY; The quota capability.
	Quota *QuotaCapability
}

// ClientGroupInfo - The information of AAD security group.
type ClientGroupInfo struct {
	// The AAD security group id.
	GroupID *string

	// The AAD security group name.
	GroupName *string
}

// Cluster - The HDInsight cluster.
type Cluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The ETag for the resource
	Etag *string

	// The identity of the cluster, if configured.
	Identity *ClusterIdentity

	// The properties of the cluster.
	Properties *ClusterGetProperties

	// Resource tags.
	Tags map[string]*string

	// The availability zones.
	Zones []*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterConfigurations - The configuration object for the specified cluster.
type ClusterConfigurations struct {
	// The configuration object for the specified configuration for the specified cluster.
	Configurations map[string]map[string]*string
}

// ClusterCreateParametersExtended - The CreateCluster request parameters.
type ClusterCreateParametersExtended struct {
	// The identity of the cluster, if configured.
	Identity *ClusterIdentity

	// The location of the cluster.
	Location *string

	// The cluster create parameters.
	Properties *ClusterCreateProperties

	// The resource tags.
	Tags map[string]*string

	// The availability zones.
	Zones []*string
}

// ClusterCreateProperties - The cluster create parameters.
type ClusterCreateProperties struct {
	// The cluster definition.
	ClusterDefinition *ClusterDefinition

	// The version of the cluster.
	ClusterVersion *string

	// The compute isolation properties.
	ComputeIsolationProperties *ComputeIsolationProperties

	// The compute profile.
	ComputeProfile *ComputeProfile

	// The disk encryption properties.
	DiskEncryptionProperties *DiskEncryptionProperties

	// The encryption-in-transit properties.
	EncryptionInTransitProperties *EncryptionInTransitProperties

	// The cluster kafka rest proxy configuration.
	KafkaRestProperties *KafkaRestProperties

	// The minimal supported tls version.
	MinSupportedTLSVersion *string

	// The network properties.
	NetworkProperties *NetworkProperties

	// The type of operating system.
	OSType *OSType

	// The private link configurations.
	PrivateLinkConfigurations []*PrivateLinkConfiguration

	// The security profile.
	SecurityProfile *SecurityProfile

	// The storage profile.
	StorageProfile *StorageProfile

	// The cluster tier.
	Tier *Tier
}

// ClusterCreateRequestValidationParameters - The cluster create request specification.
type ClusterCreateRequestValidationParameters struct {
	// This indicates whether fetch Aadds resource or not.
	FetchAaddsResource *bool

	// The identity of the cluster, if configured.
	Identity *ClusterIdentity

	// The location of the cluster.
	Location *string

	// The cluster name.
	Name *string

	// The cluster create parameters.
	Properties *ClusterCreateProperties

	// The resource tags.
	Tags map[string]*string

	// The tenant id.
	TenantID *string

	// The resource type.
	Type *string

	// The availability zones.
	Zones []*string
}

// ClusterCreateValidationResult - The response of cluster create request validation.
type ClusterCreateValidationResult struct {
	// The Azure active directory domain service resource details.
	AaddsResourcesDetails []*AaddsResourceDetails

	// The estimated creation duration.
	EstimatedCreationDuration *string

	// The validation errors.
	ValidationErrors []*ValidationErrorInfo

	// The validation warnings.
	ValidationWarnings []*ValidationErrorInfo
}

// ClusterDefinition - The cluster definition.
type ClusterDefinition struct {
	// The link to the blueprint.
	Blueprint *string

	// The versions of different services in the cluster.
	ComponentVersion map[string]*string

	// The cluster configurations.
	Configurations any

	// The type of cluster.
	Kind *string
}

// ClusterDiskEncryptionParameters - The Disk Encryption Cluster request parameters.
type ClusterDiskEncryptionParameters struct {
	// Key name that is used for enabling disk encryption.
	KeyName *string

	// Specific key version that is used for enabling disk encryption.
	KeyVersion *string

	// Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
	VaultURI *string
}

// ClusterGetProperties - The properties of cluster.
type ClusterGetProperties struct {
	// REQUIRED; The cluster definition.
	ClusterDefinition *ClusterDefinition

	// The hdp version of the cluster.
	ClusterHdpVersion *string

	// The cluster id.
	ClusterID *string

	// The state of the cluster.
	ClusterState *string

	// The version of the cluster.
	ClusterVersion *string

	// The compute isolation properties.
	ComputeIsolationProperties *ComputeIsolationProperties

	// The compute profile.
	ComputeProfile *ComputeProfile

	// The list of connectivity endpoints.
	ConnectivityEndpoints []*ConnectivityEndpoint

	// The date on which the cluster was created.
	CreatedDate *string

	// The disk encryption properties.
	DiskEncryptionProperties *DiskEncryptionProperties

	// The encryption-in-transit properties.
	EncryptionInTransitProperties *EncryptionInTransitProperties

	// The list of errors.
	Errors []*Errors

	// The excluded services config.
	ExcludedServicesConfig *ExcludedServicesConfig

	// The cluster kafka rest proxy configuration.
	KafkaRestProperties *KafkaRestProperties

	// The minimal supported tls version.
	MinSupportedTLSVersion *string

	// The network properties.
	NetworkProperties *NetworkProperties

	// The type of operating system.
	OSType *OSType

	// The private link configurations.
	PrivateLinkConfigurations []*PrivateLinkConfiguration

	// The provisioning state, which only appears in the response.
	ProvisioningState *HDInsightClusterProvisioningState

	// The quota information.
	QuotaInfo *QuotaInfo

	// The security profile.
	SecurityProfile *SecurityProfile

	// The storage profile.
	StorageProfile *StorageProfile

	// The cluster tier.
	Tier *Tier

	// READ-ONLY; The list of private endpoint connections.
	PrivateEndpointConnections []*PrivateEndpointConnection
}

// ClusterIdentity - Identity for the cluster.
type ClusterIdentity struct {
	// The type of identity used for the cluster. The type 'SystemAssigned, UserAssigned' includes both an implicitly created
	// identity and a set of user assigned identities.
	Type *ResourceIdentityType

	// The list of user identities associated with the cluster. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The principal id of cluster identity. This property will only be provided for a system assigned identity.
	PrincipalID *string

	// READ-ONLY; The tenant id associated with the cluster. This property will only be provided for a system assigned identity.
	TenantID *string
}

// ClusterListPersistedScriptActionsResult - The ListPersistedScriptActions operation response.
type ClusterListPersistedScriptActionsResult struct {
	// The list of Persisted Script Actions.
	Value []*RuntimeScriptAction

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string
}

// ClusterListResult - The List Cluster operation response.
type ClusterListResult struct {
	// The list of Clusters.
	Value []*Cluster

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string
}

// ClusterMonitoringRequest - The cluster monitor parameters.
type ClusterMonitoringRequest struct {
	// The cluster monitor workspace key.
	PrimaryKey *string

	// The cluster monitor workspace ID.
	WorkspaceID *string
}

// ClusterMonitoringResponse - The cluster monitoring status response.
type ClusterMonitoringResponse struct {
	// The status of the monitor on the HDInsight cluster.
	ClusterMonitoringEnabled *bool

	// The workspace ID of the monitor on the HDInsight cluster.
	WorkspaceID *string
}

// ClusterPatchParameters - The PatchCluster request parameters
type ClusterPatchParameters struct {
	// The resource tags.
	Tags map[string]*string
}

// ClusterResizeParameters - The Resize Cluster request parameters.
type ClusterResizeParameters struct {
	// The target instance count for the operation.
	TargetInstanceCount *int32
}

// ComputeIsolationProperties - The compute isolation properties.
type ComputeIsolationProperties struct {
	// The flag indicates whether enable compute isolation or not.
	EnableComputeIsolation *bool

	// The host sku.
	HostSKU *string
}

// ComputeProfile - Describes the compute profile.
type ComputeProfile struct {
	// The list of roles in the cluster.
	Roles []*Role
}

// ConnectivityEndpoint - The connectivity properties
type ConnectivityEndpoint struct {
	// The location of the endpoint.
	Location *string

	// The name of the endpoint.
	Name *string

	// The port to connect to.
	Port *int32

	// The private ip address of the endpoint.
	PrivateIPAddress *string

	// The protocol of the endpoint.
	Protocol *string
}

// DataDisksGroups - The data disks groups for the role.
type DataDisksGroups struct {
	// The number of disks per node.
	DisksPerNode *int32

	// READ-ONLY; ReadOnly. The DiskSize in GB. Do not set this value.
	DiskSizeGB *int32

	// READ-ONLY; ReadOnly. The storage account type. Do not set this value.
	StorageAccountType *string
}

// Dimension - The definition of Dimension.
type Dimension struct {
	// The display name of the dimension.
	DisplayName *string

	// The display name of the dimension.
	InternalName *string

	// The name of the dimension.
	Name *string

	// The flag indicates whether the metric will be exported for shoebox or not.
	ToBeExportedForShoebox *bool
}

// DiskBillingMeters - The disk billing meters.
type DiskBillingMeters struct {
	// The managed disk meter guid.
	DiskRpMeter *string

	// The managed disk billing sku, P30 or S30.
	SKU *string

	// The managed disk billing tier, Standard or Premium.
	Tier *Tier
}

// DiskEncryptionProperties - The disk encryption properties
type DiskEncryptionProperties struct {
	// Algorithm identifier for encryption, default RSA-OAEP.
	EncryptionAlgorithm *JSONWebKeyEncryptionAlgorithm

	// Indicates whether or not resource disk encryption is enabled.
	EncryptionAtHost *bool

	// Key name that is used for enabling disk encryption.
	KeyName *string

	// Specific key version that is used for enabling disk encryption.
	KeyVersion *string

	// Resource ID of Managed Identity that is used to access the key vault.
	MsiResourceID *string

	// Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
	VaultURI *string
}

// EncryptionInTransitProperties - The encryption-in-transit properties.
type EncryptionInTransitProperties struct {
	// Indicates whether or not inter cluster node communication is encrypted in transit.
	IsEncryptionInTransitEnabled *bool
}

// ErrorResponse - Describes the format of Error response.
type ErrorResponse struct {
	// Error code
	Code *string

	// Error message indicating why the operation failed.
	Message *string
}

// Errors - The error message associated with the cluster creation.
type Errors struct {
	// The error code.
	Code *string

	// The error message.
	Message *string
}

// ExcludedServicesConfig - The configuration that services will be excluded when creating cluster.
type ExcludedServicesConfig struct {
	// The config id of excluded services.
	ExcludedServicesConfigID *string

	// The list of excluded services.
	ExcludedServicesList *string
}

// ExecuteScriptActionParameters - The parameters for the script actions to execute on a running cluster.
type ExecuteScriptActionParameters struct {
	// REQUIRED; Gets or sets if the scripts needs to be persisted.
	PersistOnSuccess *bool

	// The list of run time script actions.
	ScriptActions []*RuntimeScriptAction
}

// Extension - Cluster monitoring extensions.
type Extension struct {
	// The certificate for the cluster monitoring extensions.
	PrimaryKey *string

	// The workspace ID for the cluster monitoring extension.
	WorkspaceID *string
}

// GatewaySettings - Gateway settings.
type GatewaySettings struct {
	// READ-ONLY; Indicates whether or not the gateway settings based authorization is enabled.
	IsCredentialEnabled *string

	// READ-ONLY; The gateway settings user password.
	Password *string

	// READ-ONLY; The gateway settings user name.
	UserName *string
}

// HardwareProfile - The hardware profile.
type HardwareProfile struct {
	// The size of the VM
	VMSize *string
}

// HostInfo - The cluster host information.
type HostInfo struct {
	// The effective disk encryption key URL used by the host
	EffectiveDiskEncryptionKeyURL *string

	// The Fully Qualified Domain Name of host
	Fqdn *string

	// The host name
	Name *string
}

// IPConfiguration - The ip configurations for the private link service.
type IPConfiguration struct {
	// REQUIRED; The name of private link IP configuration.
	Name *string

	// The private link ip configuration properties.
	Properties *IPConfigurationProperties

	// READ-ONLY; The private link IP configuration id.
	ID *string

	// READ-ONLY; The type of the private link IP configuration.
	Type *string
}

// IPConfigurationProperties - The private link ip configuration properties.
type IPConfigurationProperties struct {
	// Indicates whether this IP configuration is primary for the corresponding NIC.
	Primary *bool

	// The IP address.
	PrivateIPAddress *string

	// The method that private IP address is allocated.
	PrivateIPAllocationMethod *PrivateIPAllocationMethod

	// The subnet resource id.
	Subnet *ResourceID

	// READ-ONLY; The private link configuration provisioning state, which only appears in the response.
	ProvisioningState *PrivateLinkConfigurationProvisioningState
}

// KafkaRestProperties - The kafka rest proxy configuration which contains AAD security group information.
type KafkaRestProperties struct {
	// The information of AAD security group.
	ClientGroupInfo *ClientGroupInfo

	// The configurations that need to be overriden.
	ConfigurationOverride map[string]*string
}

// LinuxOperatingSystemProfile - The ssh username, password, and ssh public key.
type LinuxOperatingSystemProfile struct {
	// The password.
	Password *string

	// The SSH profile.
	SSHProfile *SSHProfile

	// The username.
	Username *string
}

// LocalizedName - The details about the localizable name of a type of usage.
type LocalizedName struct {
	// The localized name of the used resource.
	LocalizedValue *string

	// The name of the used resource.
	Value *string
}

// MetricSpecifications - The details of metric specifications.
type MetricSpecifications struct {
	// The aggregation type of the metric specification.
	AggregationType *string

	// The category of the metric.
	Category *string

	// The override name of delegate metric.
	DelegateMetricNameOverride *string

	// The dimensions of the metric specification.
	Dimensions []*Dimension

	// The display description of the metric specification.
	DisplayDescription *string

	// The display name of the metric specification.
	DisplayName *string

	// The flag indicates whether enable regional mdm account or not.
	EnableRegionalMdmAccount *bool

	// The flag indicates whether filling gap with zero.
	FillGapWithZero *bool

	// The flag indicates whether the metric is internal or not.
	IsInternal *bool

	// The metric filter pattern.
	MetricFilterPattern *string

	// The name of the metric specification.
	Name *string

	// The override name of resource id dimension name.
	ResourceIDDimensionNameOverride *string

	// The source mdm account.
	SourceMdmAccount *string

	// The source mdm namespace.
	SourceMdmNamespace *string

	// The supported aggregation types of the metric specification.
	SupportedAggregationTypes []*string

	// The supported time grain types of the metric specification.
	SupportedTimeGrainTypes []*string

	// The unit of the metric specification.
	Unit *string
}

// NameAvailabilityCheckRequestParameters - The request spec of checking name availability.
type NameAvailabilityCheckRequestParameters struct {
	// The resource name.
	Name *string

	// The resource type
	Type *string
}

// NameAvailabilityCheckResult - The response spec of checking name availability.
type NameAvailabilityCheckResult struct {
	// This indicates whether the name is available.
	NameAvailable *bool

	// READ-ONLY; The related message.
	Message *string

	// READ-ONLY; The reason of the result.
	Reason *string
}

// NetworkProperties - The network properties.
type NetworkProperties struct {
	// Indicates whether or not private link is enabled.
	PrivateLink *PrivateLink

	// The direction for the resource provider connection.
	ResourceProviderConnection *ResourceProviderConnection
}

// Operation - The HDInsight REST API operation.
type Operation struct {
	// The display of operation.
	Display *OperationDisplay

	// The operation name: {provider}/{resource}/{operation}
	Name *string

	// The operation properties.
	Properties *OperationProperties
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Localized friendly description for the operation
	Description *string

	// The operation type: read, write, delete, etc.
	Operation *string

	// The service provider: Microsoft.HDInsight
	Provider *string

	// The resource on which the operation is performed: Cluster, Applications, etc.
	Resource *string
}

// OperationListResult - Result of the request to list HDInsight operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// The URL to get the next set of operation list results if there are any.
	NextLink *string

	// The list of HDInsight operations supported by the HDInsight resource provider.
	Value []*Operation
}

// OperationProperties - The details of operation.
type OperationProperties struct {
	// The specification of the service.
	ServiceSpecification *ServiceSpecification
}

// OsProfile - The Linux operation systems profile.
type OsProfile struct {
	// The Linux OS profile.
	LinuxOperatingSystemProfile *LinuxOperatingSystemProfile
}

// PrivateEndpoint - The private endpoint.
type PrivateEndpoint struct {
	// The private endpoint id.
	ID *string
}

// PrivateEndpointConnection - The private endpoint connection.
type PrivateEndpointConnection struct {
	// REQUIRED; The private endpoint connection properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - The list private endpoint connections response.
type PrivateEndpointConnectionListResult struct {
	// The list of private endpoint connections.
	Value []*PrivateEndpointConnection

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string
}

// PrivateEndpointConnectionProperties - The private endpoint connection properties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; The private link service connection state.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// READ-ONLY; The link identifier.
	LinkIdentifier *string

	// READ-ONLY; The private endpoint of the private endpoint connection
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkConfiguration - The private link configuration.
type PrivateLinkConfiguration struct {
	// REQUIRED; The name of private link configuration.
	Name *string

	// REQUIRED; The private link configuration properties.
	Properties *PrivateLinkConfigurationProperties

	// READ-ONLY; The private link configuration id.
	ID *string

	// READ-ONLY; The type of the private link configuration.
	Type *string
}

// PrivateLinkConfigurationProperties - The private link configuration properties.
type PrivateLinkConfigurationProperties struct {
	// REQUIRED; The HDInsight private linkable sub-resource name to apply the private link configuration to. For example, 'headnode',
	// 'gateway', 'edgenode'.
	GroupID *string

	// REQUIRED; The IP configurations for the private link service.
	IPConfigurations []*IPConfiguration

	// READ-ONLY; The private link configuration provisioning state, which only appears in the response.
	ProvisioningState *PrivateLinkConfigurationProvisioningState
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - The private link service connection state.
type PrivateLinkServiceConnectionState struct {
	// REQUIRED; The concrete private link service connection.
	Status *PrivateLinkServiceConnectionStatus

	// Whether there is further actions.
	ActionsRequired *string

	// The optional description of the status.
	Description *string
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// QuotaCapability - The regional quota capability.
type QuotaCapability struct {
	// The number of cores used in the subscription.
	CoresUsed *int64

	// The number of cores that the subscription allowed.
	MaxCoresAllowed *int64

	// The list of region quota capabilities.
	RegionalQuotas []*RegionalQuotaCapability
}

// QuotaInfo - The quota properties for the cluster.
type QuotaInfo struct {
	// The cores used by the cluster.
	CoresUsed *int32
}

// RegionalQuotaCapability - The regional quota capacity.
type RegionalQuotaCapability struct {
	// The number of cores available in the region.
	CoresAvailable *int64

	// The number of cores used in the region.
	CoresUsed *int64

	// The region name.
	RegionName *string
}

// RegionsCapability - The regions capability.
type RegionsCapability struct {
	// The list of region capabilities.
	Available []*string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceID - The azure resource id.
type ResourceID struct {
	// The azure resource id.
	ID *string
}

// Role - Describes a role on the cluster.
type Role struct {
	// The autoscale configurations.
	AutoscaleConfiguration *Autoscale

	// The data disks groups for the role.
	DataDisksGroups []*DataDisksGroups

	// Indicates whether encrypt the data disks.
	EncryptDataDisks *bool

	// The hardware profile.
	HardwareProfile *HardwareProfile

	// The minimum instance count of the cluster.
	MinInstanceCount *int32

	// The name of the role.
	Name *string

	// The operating system profile.
	OSProfile *OsProfile

	// The list of script actions on the role.
	ScriptActions []*ScriptAction

	// The instance count of the cluster.
	TargetInstanceCount *int32

	// The name of the virtual machine group.
	VMGroupName *string

	// The virtual network profile.
	VirtualNetworkProfile *VirtualNetworkProfile
}

// RuntimeScriptAction - Describes a script action on a running cluster.
type RuntimeScriptAction struct {
	// REQUIRED; The name of the script action.
	Name *string

	// REQUIRED; The list of roles where script will be executed.
	Roles []*string

	// REQUIRED; The URI to the script.
	URI *string

	// The parameters for the script
	Parameters *string

	// READ-ONLY; The application name of the script action, if any.
	ApplicationName *string
}

// RuntimeScriptActionDetail - The execution details of a script action.
type RuntimeScriptActionDetail struct {
	// REQUIRED; The name of the script action.
	Name *string

	// REQUIRED; The list of roles where script will be executed.
	Roles []*string

	// REQUIRED; The URI to the script.
	URI *string

	// The parameters for the script
	Parameters *string

	// READ-ONLY; The application name of the script action, if any.
	ApplicationName *string

	// READ-ONLY; The script action execution debug information.
	DebugInformation *string

	// READ-ONLY; The end time of script action execution.
	EndTime *string

	// READ-ONLY; The summary of script action execution result.
	ExecutionSummary []*ScriptActionExecutionSummary

	// READ-ONLY; The reason why the script action was executed.
	Operation *string

	// READ-ONLY; The execution id of the script action.
	ScriptExecutionID *int64

	// READ-ONLY; The start time of script action execution.
	StartTime *string

	// READ-ONLY; The current execution status of the script action.
	Status *string
}

// SSHProfile - The list of SSH public keys.
type SSHProfile struct {
	// The list of SSH public keys.
	PublicKeys []*SSHPublicKey
}

// SSHPublicKey - The SSH public key for the cluster nodes.
type SSHPublicKey struct {
	// The certificate for SSH.
	CertificateData *string
}

// ScriptAction - Describes a script action on role on the cluster.
type ScriptAction struct {
	// REQUIRED; The name of the script action.
	Name *string

	// REQUIRED; The parameters for the script provided.
	Parameters *string

	// REQUIRED; The URI to the script.
	URI *string
}

// ScriptActionExecutionHistoryList - The list script execution history response.
type ScriptActionExecutionHistoryList struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of persisted script action details for the cluster.
	Value []*RuntimeScriptActionDetail
}

// ScriptActionExecutionSummary - The execution summary of a script action.
type ScriptActionExecutionSummary struct {
	// READ-ONLY; The instance count for a given script action execution status.
	InstanceCount *int32

	// READ-ONLY; The status of script action execution.
	Status *string
}

// ScriptActionPersistedGetResponseSpec - The persisted script action for cluster.
type ScriptActionPersistedGetResponseSpec struct {
	// The application name for the script action.
	ApplicationName *string

	// The name of script action.
	Name *string

	// The parameters for the script provided.
	Parameters *string

	// The list of roles where script will be executed.
	Roles []*string

	// The URI to the script.
	URI *string
}

// ScriptActionsList - The persisted script action for the cluster.
type ScriptActionsList struct {
	// The list of persisted script action details for the cluster.
	Value []*RuntimeScriptActionDetail

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string
}

// SecurityProfile - The security profile which contains Ssh public key for the HDInsight cluster.
type SecurityProfile struct {
	// The resource ID of the user's Azure Active Directory Domain Service.
	AaddsResourceID *string

	// Optional. The Distinguished Names for cluster user groups
	ClusterUsersGroupDNs []*string

	// The directory type.
	DirectoryType *DirectoryType

	// The organization's active directory domain.
	Domain *string

	// The domain admin password.
	DomainUserPassword *string

	// The domain user account that will have admin privileges on the cluster.
	DomainUsername *string

	// The LDAPS protocol URLs to communicate with the Active Directory.
	LdapsUrls []*string

	// User assigned identity that has permissions to read and create cluster-related artifacts in the user's AADDS.
	MsiResourceID *string

	// The organizational unit within the Active Directory to place the cluster and service accounts.
	OrganizationalUnitDN *string
}

// ServiceSpecification - The specification of the service.
type ServiceSpecification struct {
	// The metric specifications.
	MetricSpecifications []*MetricSpecifications
}

// StorageAccount - The storage Account.
type StorageAccount struct {
	// The container in the storage account, only to be specified for WASB storage accounts.
	Container *string

	// Enable secure channel or not, it's an optional field. Default value is false when cluster version < 5.1 and true when cluster
	// version >= 5.1 ,
	EnableSecureChannel *bool

	// The filesystem, only to be specified for Azure Data Lake Storage Gen 2.
	FileSystem *string

	// The file share name.
	Fileshare *string

	// Whether or not the storage account is the default storage account.
	IsDefault *bool

	// The storage account access key.
	Key *string

	// The managed identity (MSI) that is allowed to access the storage account, only to be specified for Azure Data Lake Storage
	// Gen 2.
	MsiResourceID *string

	// The name of the storage account.
	Name *string

	// The resource ID of storage account, only to be specified for Azure Data Lake Storage Gen 2.
	ResourceID *string

	// The shared access signature key.
	Saskey *string
}

// StorageProfile - The storage profile.
type StorageProfile struct {
	// The list of storage accounts in the cluster.
	Storageaccounts []*StorageAccount
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// UpdateClusterIdentityCertificateParameters - The update cluster identity certificate request parameters.
type UpdateClusterIdentityCertificateParameters struct {
	// The application id.
	ApplicationID *string

	// The certificate in base64 encoded format.
	Certificate *string

	// The password of the certificate.
	CertificatePassword *string
}

// UpdateGatewaySettingsParameters - The update gateway settings request parameters.
type UpdateGatewaySettingsParameters struct {
	// Indicates whether or not the gateway settings based authorization is enabled.
	IsCredentialEnabled *bool

	// The gateway settings user password.
	Password *string

	// The gateway settings user name.
	UserName *string
}

// Usage - The details about the usage of a particular limited resource.
type Usage struct {
	// The current usage.
	CurrentValue *int64

	// The maximum allowed usage.
	Limit *int64

	// The type of measurement for usage.
	Unit *string

	// READ-ONLY; The details about the localizable name of the used resource.
	Name *LocalizedName
}

// UsagesListResult - The response for the operation to get regional usages for a subscription.
type UsagesListResult struct {
	// The list of usages.
	Value []*Usage
}

// UserAssignedIdentity - The User Assigned Identity
type UserAssignedIdentity struct {
	// The tenant id of user assigned identity.
	TenantID *string

	// READ-ONLY; The client id of user assigned identity.
	ClientID *string

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string
}

// VMSizeCompatibilityFilterV2 - This class represent a single filter object that defines a multidimensional set. The dimensions
// of this set are Regions, ClusterFlavors, NodeTypes and ClusterVersions. The constraint should be defined
// based on the following: FilterMode (Exclude vs Include), VMSizes (the vm sizes in affect of exclusion/inclusion) and the
// ordering of the Filters. Later filters override previous settings if
// conflicted.
type VMSizeCompatibilityFilterV2 struct {
	// The list of cluster flavors under the effect of the filter.
	ClusterFlavors []*string

	// The list of cluster versions affected in Major.Minor format.
	ClusterVersions []*string

	// Whether support compute isolation. 'true' means only for ComputeIsolationEnabled, 'false' means only for regular cluster.
	ComputeIsolationSupported *string

	// Whether apply for ESP cluster. 'true' means only for ESP, 'false' means only for non-ESP, null or empty string or others
	// mean for both.
	EspApplied *string

	// The filtering mode. Effectively this can enabling or disabling the VM sizes in a particular set.
	FilterMode *FilterMode

	// The list of node types affected by the filter.
	NodeTypes []*string

	// The OSType affected, Windows or Linux.
	OSType []*OSType

	// The list of regions under the effect of the filter.
	Regions []*string

	// The list of virtual machine sizes to include or exclude.
	VMSizes []*string
}

// VMSizeProperty - The vm size property
type VMSizeProperty struct {
	// The number of cores that the vm size has.
	Cores *int32

	// The data disk storage tier of the vm size.
	DataDiskStorageTier *string

	// The label of the vm size.
	Label *string

	// The max data disk count of the vm size.
	MaxDataDiskCount *int64

	// The memory whose unit is MB of the vm size.
	MemoryInMb *int64

	// The vm size name.
	Name *string

	// This indicates this vm size is supported by virtual machines or not
	SupportedByVirtualMachines *bool

	// The indicates this vm size is supported by web worker roles or not
	SupportedByWebWorkerRoles *bool

	// The virtual machine resource disk size whose unit is MB of the vm size.
	VirtualMachineResourceDiskSizeInMb *int64

	// The web worker resource disk size whose unit is MB of the vm size.
	WebWorkerResourceDiskSizeInMb *int64
}

// ValidationErrorInfo - The validation error information.
type ValidationErrorInfo struct {
	// The error code.
	Code *string

	// The error resource.
	ErrorResource *string

	// The error message.
	Message *string

	// The message arguments
	MessageArguments []*string
}

// VersionSpec - The version properties.
type VersionSpec struct {
	// The component version property.
	ComponentVersions map[string]*string

	// The display name
	DisplayName *string

	// The friendly name
	FriendlyName *string

	// Whether or not the version is the default version.
	IsDefault *bool
}

// VersionsCapability - The version capability.
type VersionsCapability struct {
	// The list of version capabilities.
	Available []*VersionSpec
}

// VirtualNetworkProfile - The virtual network properties.
type VirtualNetworkProfile struct {
	// The ID of the virtual network.
	ID *string

	// The name of the subnet.
	Subnet *string
}
