//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armhybridcontainerservice_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybridcontainerservice/armhybridcontainerservice"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/hybridaks/resource-manager/Microsoft.HybridContainerService/stable/2024-01-01/examples/GetKubernetesVersions.json
func ExampleClient_GetKubernetesVersions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().GetKubernetesVersions(ctx, "subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.KubernetesVersionProfile = armhybridcontainerservice.KubernetesVersionProfile{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("microsoft.hybridcontainerservice/kubernetesVersions"),
	// 	ID: to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation/providers/Microsoft.HybridContainerService/kubernetesVersions/default"),
	// 	ExtendedLocation: &armhybridcontainerservice.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
	// 		Type: to.Ptr(armhybridcontainerservice.ExtendedLocationTypesCustomLocation),
	// 	},
	// 	Properties: &armhybridcontainerservice.KubernetesVersionProfileProperties{
	// 		ProvisioningState: to.Ptr(armhybridcontainerservice.ResourceProvisioningStateSucceeded),
	// 		Values: []*armhybridcontainerservice.KubernetesVersionProperties{
	// 			{
	// 				IsPreview: to.Ptr(false),
	// 				PatchVersions: map[string]*armhybridcontainerservice.KubernetesPatchVersions{
	// 					"1.23.12": &armhybridcontainerservice.KubernetesPatchVersions{
	// 						Readiness: []*armhybridcontainerservice.KubernetesVersionReadiness{
	// 							{
	// 								OSSKU: to.Ptr(armhybridcontainerservice.OSSKUCBLMariner),
	// 								OSType: to.Ptr(armhybridcontainerservice.OsTypeLinux),
	// 								Ready: to.Ptr(true),
	// 							},
	// 							{
	// 								OSSKU: to.Ptr(armhybridcontainerservice.OSSKU("Windows")),
	// 								OSType: to.Ptr(armhybridcontainerservice.OsTypeWindows),
	// 								Ready: to.Ptr(true),
	// 							},
	// 							{
	// 								ErrorMessage: to.Ptr("Not Ready. Reasons: Failed to find proudct stream windoes2022 in release aks-hybrid-catalog-stable-int"),
	// 								OSSKU: to.Ptr(armhybridcontainerservice.OSSKUWindows2022),
	// 								OSType: to.Ptr(armhybridcontainerservice.OsTypeWindows),
	// 								Ready: to.Ptr(false),
	// 						}},
	// 						Upgrades: []*string{
	// 							to.Ptr("1.23.13")},
	// 						},
	// 						"1.23.13": &armhybridcontainerservice.KubernetesPatchVersions{
	// 							Readiness: []*armhybridcontainerservice.KubernetesVersionReadiness{
	// 								{
	// 									OSSKU: to.Ptr(armhybridcontainerservice.OSSKUCBLMariner),
	// 									OSType: to.Ptr(armhybridcontainerservice.OsTypeLinux),
	// 									Ready: to.Ptr(true),
	// 								},
	// 								{
	// 									OSSKU: to.Ptr(armhybridcontainerservice.OSSKUWindows2019),
	// 									OSType: to.Ptr(armhybridcontainerservice.OsTypeWindows),
	// 									Ready: to.Ptr(true),
	// 								},
	// 								{
	// 									OSSKU: to.Ptr(armhybridcontainerservice.OSSKUWindows2022),
	// 									OSType: to.Ptr(armhybridcontainerservice.OsTypeWindows),
	// 									Ready: to.Ptr(true),
	// 							}},
	// 							Upgrades: []*string{
	// 							},
	// 						},
	// 					},
	// 					Version: to.Ptr("1.23"),
	// 			}},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/hybridaks/resource-manager/Microsoft.HybridContainerService/stable/2024-01-01/examples/PutKubernetesVersions.json
func ExampleClient_BeginPutKubernetesVersions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginPutKubernetesVersions(ctx, "subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation", armhybridcontainerservice.KubernetesVersionProfile{
		ExtendedLocation: &armhybridcontainerservice.ExtendedLocation{
			Name: to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
			Type: to.Ptr(armhybridcontainerservice.ExtendedLocationTypesCustomLocation),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.KubernetesVersionProfile = armhybridcontainerservice.KubernetesVersionProfile{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("microsoft.hybridcontainerservice/kubernetesVersions"),
	// 	ID: to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/kubernetesVersions/default"),
	// 	Properties: &armhybridcontainerservice.KubernetesVersionProfileProperties{
	// 		ProvisioningState: to.Ptr(armhybridcontainerservice.ResourceProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/hybridaks/resource-manager/Microsoft.HybridContainerService/stable/2024-01-01/examples/DeleteKubernetesVersions.json
func ExampleClient_BeginDeleteKubernetesVersions() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginDeleteKubernetesVersions(ctx, "subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/hybridaks/resource-manager/Microsoft.HybridContainerService/stable/2024-01-01/examples/GetVmSkus.json
func ExampleClient_GetVMSKUs() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().GetVMSKUs(ctx, "subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VMSKUProfile = armhybridcontainerservice.VMSKUProfile{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("microsoft.hybridcontainerservice/skus"),
	// 	ID: to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation/providers/Microsoft.HybridContainerService/skus/default"),
	// 	ExtendedLocation: &armhybridcontainerservice.ExtendedLocation{
	// 		Name: to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
	// 		Type: to.Ptr(armhybridcontainerservice.ExtendedLocationTypesCustomLocation),
	// 	},
	// 	Properties: &armhybridcontainerservice.VMSKUProfileProperties{
	// 		ProvisioningState: to.Ptr(armhybridcontainerservice.ResourceProvisioningStateSucceeded),
	// 		Values: []*armhybridcontainerservice.VMSKUProperties{
	// 			{
	// 				Name: to.Ptr("Standard_A0"),
	// 				Capabilities: []*armhybridcontainerservice.VMSKUCapabilities{
	// 					{
	// 						Name: to.Ptr("vCpu"),
	// 						Value: to.Ptr("2"),
	// 					},
	// 					{
	// 						Name: to.Ptr("MemoryMb"),
	// 						Value: to.Ptr("2345"),
	// 					},
	// 					{
	// 						Name: to.Ptr("DiskSizeGb"),
	// 						Value: to.Ptr("128"),
	// 					},
	// 					{
	// 						Name: to.Ptr("GpuCount"),
	// 						Value: to.Ptr("1"),
	// 					},
	// 					{
	// 						Name: to.Ptr("GpuNameType"),
	// 						Value: to.Ptr("NVIDIA Tesla T4"),
	// 					},
	// 					{
	// 						Name: to.Ptr("GpuAssignMode"),
	// 						Value: to.Ptr("1"),
	// 					},
	// 					{
	// 						Name: to.Ptr("Provider"),
	// 						Value: to.Ptr("HCI"),
	// 				}},
	// 				ResourceType: to.Ptr("VirtualMachines"),
	// 				Size: to.Ptr("A0"),
	// 				Tier: to.Ptr("Standard"),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/hybridaks/resource-manager/Microsoft.HybridContainerService/stable/2024-01-01/examples/PutVmSkus.json
func ExampleClient_BeginPutVMSKUs() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginPutVMSKUs(ctx, "subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation", armhybridcontainerservice.VMSKUProfile{
		ExtendedLocation: &armhybridcontainerservice.ExtendedLocation{
			Name: to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourcegroups/test-arcappliance-resgrp/providers/microsoft.extendedlocation/customlocations/testcustomlocation"),
			Type: to.Ptr(armhybridcontainerservice.ExtendedLocationTypesCustomLocation),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VMSKUProfile = armhybridcontainerservice.VMSKUProfile{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("microsoft.hybridcontainerservice/skus"),
	// 	ID: to.Ptr("/subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.HybridContainerService/skus/default"),
	// 	Properties: &armhybridcontainerservice.VMSKUProfileProperties{
	// 		ProvisioningState: to.Ptr(armhybridcontainerservice.ResourceProvisioningStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/41e4538ed7bb3ceac3c1322c9455a0812ed110ac/specification/hybridaks/resource-manager/Microsoft.HybridContainerService/stable/2024-01-01/examples/DeleteVmSkus.json
func ExampleClient_BeginDeleteVMSKUs() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armhybridcontainerservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginDeleteVMSKUs(ctx, "subscriptions/a3e42606-29b1-4d7d-b1d9-9ff6b9d3c71b/resourceGroups/test-arcappliance-resgrp/providers/Microsoft.ExtendedLocation/customLocations/testcustomlocation", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
