//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/integrationspaces/armintegrationspaces"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// BusinessProcessVersionsServer is a fake server for instances of the armintegrationspaces.BusinessProcessVersionsClient type.
type BusinessProcessVersionsServer struct {
	// Get is the fake for method BusinessProcessVersionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, businessProcessName string, businessProcessVersion string, options *armintegrationspaces.BusinessProcessVersionsClientGetOptions) (resp azfake.Responder[armintegrationspaces.BusinessProcessVersionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByBusinessProcessPager is the fake for method BusinessProcessVersionsClient.NewListByBusinessProcessPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBusinessProcessPager func(resourceGroupName string, spaceName string, applicationName string, businessProcessName string, options *armintegrationspaces.BusinessProcessVersionsClientListByBusinessProcessOptions) (resp azfake.PagerResponder[armintegrationspaces.BusinessProcessVersionsClientListByBusinessProcessResponse])
}

// NewBusinessProcessVersionsServerTransport creates a new instance of BusinessProcessVersionsServerTransport with the provided implementation.
// The returned BusinessProcessVersionsServerTransport instance is connected to an instance of armintegrationspaces.BusinessProcessVersionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBusinessProcessVersionsServerTransport(srv *BusinessProcessVersionsServer) *BusinessProcessVersionsServerTransport {
	return &BusinessProcessVersionsServerTransport{
		srv:                           srv,
		newListByBusinessProcessPager: newTracker[azfake.PagerResponder[armintegrationspaces.BusinessProcessVersionsClientListByBusinessProcessResponse]](),
	}
}

// BusinessProcessVersionsServerTransport connects instances of armintegrationspaces.BusinessProcessVersionsClient to instances of BusinessProcessVersionsServer.
// Don't use this type directly, use NewBusinessProcessVersionsServerTransport instead.
type BusinessProcessVersionsServerTransport struct {
	srv                           *BusinessProcessVersionsServer
	newListByBusinessProcessPager *tracker[azfake.PagerResponder[armintegrationspaces.BusinessProcessVersionsClientListByBusinessProcessResponse]]
}

// Do implements the policy.Transporter interface for BusinessProcessVersionsServerTransport.
func (b *BusinessProcessVersionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BusinessProcessVersionsClient.Get":
		resp, err = b.dispatchGet(req)
	case "BusinessProcessVersionsClient.NewListByBusinessProcessPager":
		resp, err = b.dispatchNewListByBusinessProcessPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BusinessProcessVersionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if b.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IntegrationSpaces/spaces/(?P<spaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/businessProcesses/(?P<businessProcessName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<businessProcessVersion>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	spaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("spaceName")])
	if err != nil {
		return nil, err
	}
	applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
	if err != nil {
		return nil, err
	}
	businessProcessNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("businessProcessName")])
	if err != nil {
		return nil, err
	}
	businessProcessVersionParam, err := url.PathUnescape(matches[regex.SubexpIndex("businessProcessVersion")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.Get(req.Context(), resourceGroupNameParam, spaceNameParam, applicationNameParam, businessProcessNameParam, businessProcessVersionParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BusinessProcessVersion, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BusinessProcessVersionsServerTransport) dispatchNewListByBusinessProcessPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewListByBusinessProcessPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBusinessProcessPager not implemented")}
	}
	newListByBusinessProcessPager := b.newListByBusinessProcessPager.get(req)
	if newListByBusinessProcessPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IntegrationSpaces/spaces/(?P<spaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/businessProcesses/(?P<businessProcessName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		maxpagesizeUnescaped, err := url.QueryUnescape(qp.Get("maxpagesize"))
		if err != nil {
			return nil, err
		}
		maxpagesizeParam, err := parseOptional(maxpagesizeUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		selectEscaped := qp["select"]
		selectParam := make([]string, len(selectEscaped))
		for i, v := range selectEscaped {
			u, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return nil, unescapeErr
			}
			selectParam[i] = u
		}
		expandEscaped := qp["expand"]
		expandParam := make([]string, len(expandEscaped))
		for i, v := range expandEscaped {
			u, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return nil, unescapeErr
			}
			expandParam[i] = u
		}
		orderbyEscaped := qp["orderby"]
		orderbyParam := make([]string, len(orderbyEscaped))
		for i, v := range orderbyEscaped {
			u, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return nil, unescapeErr
			}
			orderbyParam[i] = u
		}
		spaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("spaceName")])
		if err != nil {
			return nil, err
		}
		applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
		if err != nil {
			return nil, err
		}
		businessProcessNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("businessProcessName")])
		if err != nil {
			return nil, err
		}
		var options *armintegrationspaces.BusinessProcessVersionsClientListByBusinessProcessOptions
		if topParam != nil || skipParam != nil || maxpagesizeParam != nil || filterParam != nil || len(selectParam) > 0 || len(expandParam) > 0 || len(orderbyParam) > 0 {
			options = &armintegrationspaces.BusinessProcessVersionsClientListByBusinessProcessOptions{
				Top:         topParam,
				Skip:        skipParam,
				Maxpagesize: maxpagesizeParam,
				Filter:      filterParam,
				Select:      selectParam,
				Expand:      expandParam,
				Orderby:     orderbyParam,
			}
		}
		resp := b.srv.NewListByBusinessProcessPager(resourceGroupNameParam, spaceNameParam, applicationNameParam, businessProcessNameParam, options)
		newListByBusinessProcessPager = &resp
		b.newListByBusinessProcessPager.add(req, newListByBusinessProcessPager)
		server.PagerResponderInjectNextLinks(newListByBusinessProcessPager, req, func(page *armintegrationspaces.BusinessProcessVersionsClientListByBusinessProcessResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBusinessProcessPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newListByBusinessProcessPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBusinessProcessPager) {
		b.newListByBusinessProcessPager.remove(req)
	}
	return resp, nil
}
