//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iotsecurity/armiotsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// DevicesServer is a fake server for instances of the armiotsecurity.DevicesClient type.
type DevicesServer struct {
	// Get is the fake for method DevicesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, iotDefenderLocation string, deviceGroupName string, deviceID string, options *armiotsecurity.DevicesClientGetOptions) (resp azfake.Responder[armiotsecurity.DevicesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method DevicesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(iotDefenderLocation string, deviceGroupName string, options *armiotsecurity.DevicesClientListOptions) (resp azfake.PagerResponder[armiotsecurity.DevicesClientListResponse])
}

// NewDevicesServerTransport creates a new instance of DevicesServerTransport with the provided implementation.
// The returned DevicesServerTransport instance is connected to an instance of armiotsecurity.DevicesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDevicesServerTransport(srv *DevicesServer) *DevicesServerTransport {
	return &DevicesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armiotsecurity.DevicesClientListResponse]](),
	}
}

// DevicesServerTransport connects instances of armiotsecurity.DevicesClient to instances of DevicesServer.
// Don't use this type directly, use NewDevicesServerTransport instead.
type DevicesServerTransport struct {
	srv          *DevicesServer
	newListPager *tracker[azfake.PagerResponder[armiotsecurity.DevicesClientListResponse]]
}

// Do implements the policy.Transporter interface for DevicesServerTransport.
func (d *DevicesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DevicesClient.Get":
		resp, err = d.dispatchGet(req)
	case "DevicesClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DevicesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/locations/(?P<iotDefenderLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deviceGroups/(?P<deviceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices/(?P<deviceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	iotDefenderLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("iotDefenderLocation")])
	if err != nil {
		return nil, err
	}
	deviceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceGroupName")])
	if err != nil {
		return nil, err
	}
	deviceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), iotDefenderLocationParam, deviceGroupNameParam, deviceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeviceModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DevicesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/locations/(?P<iotDefenderLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deviceGroups/(?P<deviceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/devices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		iotDefenderLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("iotDefenderLocation")])
		if err != nil {
			return nil, err
		}
		deviceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deviceGroupName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armiotsecurity.DevicesClientListOptions
		if skipTokenParam != nil {
			options = &armiotsecurity.DevicesClientListOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := d.srv.NewListPager(iotDefenderLocationParam, deviceGroupNameParam, options)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armiotsecurity.DevicesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}
