//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlogz

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SubAccountClient contains the methods for the SubAccount group.
// Don't use this type directly, use NewSubAccountClient() instead.
type SubAccountClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewSubAccountClient creates a new instance of SubAccountClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSubAccountClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SubAccountClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SubAccountClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreate - Create sub account under a given monitor resource. This create operation can take upto 10 minutes to complete.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-10-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - monitorName - Monitor resource name
//   - subAccountName - Sub Account resource name
//   - options - SubAccountClientBeginCreateOptions contains the optional parameters for the SubAccountClient.BeginCreate method.
func (client *SubAccountClient) BeginCreate(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientBeginCreateOptions) (*runtime.Poller[SubAccountClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, monitorName, subAccountName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SubAccountClientCreateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SubAccountClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Create sub account under a given monitor resource. This create operation can take upto 10 minutes to complete.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-10-01
func (client *SubAccountClient) create(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "SubAccountClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *SubAccountClient) createCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		if err := runtime.MarshalAsJSON(req, *options.Body); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// BeginDelete - Delete a sub account resource. This delete operation can take upto 10 minutes to complete.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-10-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - monitorName - Monitor resource name
//   - subAccountName - Sub Account resource name
//   - options - SubAccountClientBeginDeleteOptions contains the optional parameters for the SubAccountClient.BeginDelete method.
func (client *SubAccountClient) BeginDelete(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientBeginDeleteOptions) (*runtime.Poller[SubAccountClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, monitorName, subAccountName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SubAccountClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SubAccountClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Delete a sub account resource. This delete operation can take upto 10 minutes to complete.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-10-01
func (client *SubAccountClient) deleteOperation(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "SubAccountClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *SubAccountClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a sub account under a given monitor resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-10-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - monitorName - Monitor resource name
//   - subAccountName - Sub Account resource name
//   - options - SubAccountClientGetOptions contains the optional parameters for the SubAccountClient.Get method.
func (client *SubAccountClient) Get(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientGetOptions) (SubAccountClientGetResponse, error) {
	var err error
	const operationName = "SubAccountClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
	if err != nil {
		return SubAccountClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SubAccountClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SubAccountClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SubAccountClient) getCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SubAccountClient) getHandleResponse(resp *http.Response) (SubAccountClientGetResponse, error) {
	result := SubAccountClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MonitorResource); err != nil {
		return SubAccountClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - List the sub account under a given monitor resource.
//
// Generated from API version 2020-10-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - monitorName - Monitor resource name
//   - options - SubAccountClientListOptions contains the optional parameters for the SubAccountClient.NewListPager method.
func (client *SubAccountClient) NewListPager(resourceGroupName string, monitorName string, options *SubAccountClientListOptions) *runtime.Pager[SubAccountClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubAccountClientListResponse]{
		More: func(page SubAccountClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubAccountClientListResponse) (SubAccountClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SubAccountClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, monitorName, options)
			}, nil)
			if err != nil {
				return SubAccountClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *SubAccountClient) listCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, options *SubAccountClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *SubAccountClient) listHandleResponse(resp *http.Response) (SubAccountClientListResponse, error) {
	result := SubAccountClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MonitorResourceListResponse); err != nil {
		return SubAccountClientListResponse{}, err
	}
	return result, nil
}

// NewListMonitoredResourcesPager - List the resources currently being monitored by the Logz sub account resource.
//
// Generated from API version 2020-10-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - monitorName - Monitor resource name
//   - subAccountName - Sub Account resource name
//   - options - SubAccountClientListMonitoredResourcesOptions contains the optional parameters for the SubAccountClient.NewListMonitoredResourcesPager
//     method.
func (client *SubAccountClient) NewListMonitoredResourcesPager(resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientListMonitoredResourcesOptions) *runtime.Pager[SubAccountClientListMonitoredResourcesResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubAccountClientListMonitoredResourcesResponse]{
		More: func(page SubAccountClientListMonitoredResourcesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubAccountClientListMonitoredResourcesResponse) (SubAccountClientListMonitoredResourcesResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SubAccountClient.NewListMonitoredResourcesPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listMonitoredResourcesCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
			}, nil)
			if err != nil {
				return SubAccountClientListMonitoredResourcesResponse{}, err
			}
			return client.listMonitoredResourcesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listMonitoredResourcesCreateRequest creates the ListMonitoredResources request.
func (client *SubAccountClient) listMonitoredResourcesCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientListMonitoredResourcesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}/listMonitoredResources"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMonitoredResourcesHandleResponse handles the ListMonitoredResources response.
func (client *SubAccountClient) listMonitoredResourcesHandleResponse(resp *http.Response) (SubAccountClientListMonitoredResourcesResponse, error) {
	result := SubAccountClientListMonitoredResourcesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MonitoredResourceListResponse); err != nil {
		return SubAccountClientListMonitoredResourcesResponse{}, err
	}
	return result, nil
}

// NewListVMHostUpdatePager - Sending request to update the collection when Logz.io agent has been installed on a VM for a
// given monitor.
//
// Generated from API version 2020-10-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - monitorName - Monitor resource name
//   - subAccountName - Sub Account resource name
//   - options - SubAccountClientListVMHostUpdateOptions contains the optional parameters for the SubAccountClient.NewListVMHostUpdatePager
//     method.
func (client *SubAccountClient) NewListVMHostUpdatePager(resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientListVMHostUpdateOptions) *runtime.Pager[SubAccountClientListVMHostUpdateResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubAccountClientListVMHostUpdateResponse]{
		More: func(page SubAccountClientListVMHostUpdateResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubAccountClientListVMHostUpdateResponse) (SubAccountClientListVMHostUpdateResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SubAccountClient.NewListVMHostUpdatePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listVMHostUpdateCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
			}, nil)
			if err != nil {
				return SubAccountClientListVMHostUpdateResponse{}, err
			}
			return client.listVMHostUpdateHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listVMHostUpdateCreateRequest creates the ListVMHostUpdate request.
func (client *SubAccountClient) listVMHostUpdateCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientListVMHostUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}/vmHostUpdate"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		if err := runtime.MarshalAsJSON(req, *options.Body); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// listVMHostUpdateHandleResponse handles the ListVMHostUpdate response.
func (client *SubAccountClient) listVMHostUpdateHandleResponse(resp *http.Response) (SubAccountClientListVMHostUpdateResponse, error) {
	result := SubAccountClientListVMHostUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMResourcesListResponse); err != nil {
		return SubAccountClientListVMHostUpdateResponse{}, err
	}
	return result, nil
}

// NewListVMHostsPager - List the compute resources currently being monitored by the Logz sub account resource.
//
// Generated from API version 2020-10-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - monitorName - Monitor resource name
//   - subAccountName - Sub Account resource name
//   - options - SubAccountClientListVMHostsOptions contains the optional parameters for the SubAccountClient.NewListVMHostsPager
//     method.
func (client *SubAccountClient) NewListVMHostsPager(resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientListVMHostsOptions) *runtime.Pager[SubAccountClientListVMHostsResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubAccountClientListVMHostsResponse]{
		More: func(page SubAccountClientListVMHostsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubAccountClientListVMHostsResponse) (SubAccountClientListVMHostsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SubAccountClient.NewListVMHostsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listVMHostsCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
			}, nil)
			if err != nil {
				return SubAccountClientListVMHostsResponse{}, err
			}
			return client.listVMHostsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listVMHostsCreateRequest creates the ListVMHosts request.
func (client *SubAccountClient) listVMHostsCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientListVMHostsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}/listVMHosts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listVMHostsHandleResponse handles the ListVMHosts response.
func (client *SubAccountClient) listVMHostsHandleResponse(resp *http.Response) (SubAccountClientListVMHostsResponse, error) {
	result := SubAccountClientListVMHostsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMResourcesListResponse); err != nil {
		return SubAccountClientListVMHostsResponse{}, err
	}
	return result, nil
}

// Update - Update a monitor resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-10-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - monitorName - Monitor resource name
//   - subAccountName - Sub Account resource name
//   - options - SubAccountClientUpdateOptions contains the optional parameters for the SubAccountClient.Update method.
func (client *SubAccountClient) Update(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientUpdateOptions) (SubAccountClientUpdateResponse, error) {
	var err error
	const operationName = "SubAccountClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
	if err != nil {
		return SubAccountClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SubAccountClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SubAccountClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *SubAccountClient) updateCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.Body != nil {
		if err := runtime.MarshalAsJSON(req, *options.Body); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *SubAccountClient) updateHandleResponse(resp *http.Response) (SubAccountClientUpdateResponse, error) {
	result := SubAccountClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MonitorResource); err != nil {
		return SubAccountClientUpdateResponse{}, err
	}
	return result, nil
}

// VMHostPayload - Returns the payload that needs to be passed as a request for installing Logz.io agent on a VM.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-10-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - monitorName - Monitor resource name
//   - subAccountName - Sub Account resource name
//   - options - SubAccountClientVMHostPayloadOptions contains the optional parameters for the SubAccountClient.VMHostPayload
//     method.
func (client *SubAccountClient) VMHostPayload(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientVMHostPayloadOptions) (SubAccountClientVMHostPayloadResponse, error) {
	var err error
	const operationName = "SubAccountClient.VMHostPayload"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.vmHostPayloadCreateRequest(ctx, resourceGroupName, monitorName, subAccountName, options)
	if err != nil {
		return SubAccountClientVMHostPayloadResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SubAccountClientVMHostPayloadResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SubAccountClientVMHostPayloadResponse{}, err
	}
	resp, err := client.vmHostPayloadHandleResponse(httpResp)
	return resp, err
}

// vmHostPayloadCreateRequest creates the VMHostPayload request.
func (client *SubAccountClient) vmHostPayloadCreateRequest(ctx context.Context, resourceGroupName string, monitorName string, subAccountName string, options *SubAccountClientVMHostPayloadOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}/vmHostPayload"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if monitorName == "" {
		return nil, errors.New("parameter monitorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{monitorName}", url.PathEscape(monitorName))
	if subAccountName == "" {
		return nil, errors.New("parameter subAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subAccountName}", url.PathEscape(subAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// vmHostPayloadHandleResponse handles the VMHostPayload response.
func (client *SubAccountClient) vmHostPayloadHandleResponse(resp *http.Response) (SubAccountClientVMHostPayloadResponse, error) {
	result := SubAccountClientVMHostPayloadResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VMExtensionPayload); err != nil {
		return SubAccountClientVMHostPayloadResponse{}, err
	}
	return result, nil
}
