//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagednetworkfabric

import "time"

// AccessControlList - The Access Control List resource definition.
type AccessControlList struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *AccessControlListProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AccessControlListAction - Action that need to performed.
type AccessControlListAction struct {
	// Name of the counter block to get match count information.
	CounterName *string

	// Type of actions that can be performed.
	Type *ACLActionType
}

// AccessControlListMatchCondition - Defines the match condition that is supported to filter the traffic.
type AccessControlListMatchCondition struct {
	// List of DSCP Markings that needs to be matched.
	DscpMarkings []*string

	// List of ether type values that needs to be matched.
	EtherTypes []*string

	// List of IP fragment packets that needs to be matched.
	Fragments []*string

	// IP condition that needs to be matched.
	IPCondition *IPMatchCondition

	// List of IP Lengths that needs to be matched.
	IPLengths []*string

	// Defines the port condition that needs to be matched.
	PortCondition *AccessControlListPortCondition

	// List of the protocols that need to be matched.
	ProtocolTypes []*string

	// List of TTL [Time To Live] values that needs to be matched.
	TTLValues []*string

	// Vlan match condition that needs to be matched.
	VlanMatchCondition *VlanMatchCondition
}

// AccessControlListMatchConfiguration - Defines the match configuration that are supported to filter the traffic.
type AccessControlListMatchConfiguration struct {
	// List of actions that need to be performed for the matched conditions.
	Actions []*AccessControlListAction

	// Type of IP Address. IPv4 or IPv6
	IPAddressType *IPAddressType

	// List of the match conditions.
	MatchConditions []*AccessControlListMatchCondition

	// The name of the match configuration.
	MatchConfigurationName *string

	// Sequence Number of the match configuration.
	SequenceNumber *int64
}

// AccessControlListPatch - The Access Control Lists patch resource definition.
type AccessControlListPatch struct {
	// Access Control Lists patch properties.
	Properties *AccessControlListPatchProperties

	// Resource tags
	Tags map[string]*string
}

// AccessControlListPatchProperties - Access Control Lists patch properties.
type AccessControlListPatchProperties struct {
	// Access Control List file URL.
	ACLsURL *string

	// Switch configuration description.
	Annotation *string

	// Input method to configure Access Control List.
	ConfigurationType *ConfigurationType

	// List of dynamic match configurations.
	DynamicMatchConfigurations []*CommonDynamicMatchConfiguration

	// List of match configurations.
	MatchConfigurations []*AccessControlListMatchConfiguration
}

// AccessControlListPortCondition - Defines the port condition that needs to be matched.
type AccessControlListPortCondition struct {
	// REQUIRED; Layer4 protocol type that needs to be matched.
	Layer4Protocol *Layer4Protocol

	// List of protocol flags that needs to be matched.
	Flags []*string

	// List of the port Group Names that to be matched.
	PortGroupNames []*string

	// Port type that needs to be matched.
	PortType *PortType

	// List of the Ports that need to be matched.
	Ports []*string
}

// AccessControlListProperties - Access Control List Properties defines the resource properties.
type AccessControlListProperties struct {
	// Access Control List file URL.
	ACLsURL *string

	// Switch configuration description.
	Annotation *string

	// Input method to configure Access Control List.
	ConfigurationType *ConfigurationType

	// List of dynamic match configurations.
	DynamicMatchConfigurations []*CommonDynamicMatchConfiguration

	// List of match configurations.
	MatchConfigurations []*AccessControlListMatchConfiguration

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; The last synced timestamp.
	LastSyncedTime *time.Time

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// AccessControlListsListResult - List of Access Control Lists.
type AccessControlListsListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of Access Control List resources.
	Value []*AccessControlList
}

// ActionIPCommunityProperties - IP Community Properties.
type ActionIPCommunityProperties struct {
	// List of IP Community IDs.
	Add *IPCommunityIDList

	// List of IP Community IDs.
	Delete *IPCommunityIDList

	// List of IP Community IDs.
	Set *IPCommunityIDList
}

// ActionIPExtendedCommunityProperties - IP Extended Community Properties.
type ActionIPExtendedCommunityProperties struct {
	// List of IP Extended Community IDs.
	Add *IPExtendedCommunityIDList

	// List of IP Extended Community IDs.
	Delete *IPExtendedCommunityIDList

	// List of IP Extended Community IDs.
	Set *IPExtendedCommunityIDList
}

// AggregateRoute - aggregateIpv4Route model.
type AggregateRoute struct {
	// REQUIRED; IPv4 Prefix of the aggregate Ipv4Route.
	Prefix *string
}

// AggregateRouteConfiguration - List of IPv4 and IPv6 aggregate routes.
type AggregateRouteConfiguration struct {
	// List of IPv4 Route prefixes.
	IPv4Routes []*AggregateRoute

	// List of Ipv6Routes prefixes.
	IPv6Routes []*AggregateRoute
}

// BfdConfiguration - BFD configuration properties
type BfdConfiguration struct {
	// Interval in milliseconds. Example: 300.
	IntervalInMilliSeconds *int32

	// Multiplier for the Bfd Configuration. Example: 5.
	Multiplier *int32

	// READ-ONLY; Administrative state of the BfdConfiguration. Example: Enabled | Disabled.
	AdministrativeState *BfdAdministrativeState
}

// BgpConfiguration - BGP configuration properties
type BgpConfiguration struct {
	// Allows for routes to be received and processed even if the router detects its own ASN in the AS-Path. 0 is disable, Possible
	// values are 1-10, default is 2.
	AllowAS *int32

	// Enable Or Disable state.
	AllowASOverride *AllowASOverride

	// Switch configuration description.
	Annotation *string

	// BFD configuration properties
	BfdConfiguration *BfdConfiguration

	// Originate a defaultRoute. Ex: "True" | "False".
	DefaultRouteOriginate *BooleanEnumProperty

	// List of BGP IPv4 Listen Range prefixes.
	IPv4ListenRangePrefixes []*string

	// List with stringified IPv4 Neighbor Addresses.
	IPv4NeighborAddress []*NeighborAddress

	// List of BGP IPv6 Listen Ranges prefixes.
	IPv6ListenRangePrefixes []*string

	// List with stringified IPv6 Neighbor Address.
	IPv6NeighborAddress []*NeighborAddress

	// Peer ASN. Example: 65047.
	PeerASN *int64

	// READ-ONLY; ASN of Network Fabric. Example: 65048.
	FabricASN *int64
}

// CommonDynamicMatchConfiguration - Dynamic match configuration object.
type CommonDynamicMatchConfiguration struct {
	// List of IP Groups.
	IPGroups []*IPGroupProperties

	// List of the port group.
	PortGroups []*PortGroupProperties

	// List of vlan groups.
	VlanGroups []*VlanGroupProperties
}

// CommonPostActionResponseForDeviceUpdate - Common response for device updates.
type CommonPostActionResponseForDeviceUpdate struct {
	// The error object.
	Error *ErrorDetail

	// List of ARM Resource IDs for which the given action failed to apply.
	FailedDevices []*string

	// List of ARM Resource IDs for which the given action applied successfully.
	SuccessfulDevices []*string

	// READ-ONLY; Gets the configuration state.
	ConfigurationState *ConfigurationState
}

// CommonPostActionResponseForStateUpdate - Common response for the state updates.
type CommonPostActionResponseForStateUpdate struct {
	// The error object.
	Error *ErrorDetail

	// READ-ONLY; Gets the configuration state.
	ConfigurationState *ConfigurationState
}

// ConnectedSubnet - Connected Subnet properties.
type ConnectedSubnet struct {
	// REQUIRED; Prefix of the Connected Subnet.
	Prefix *string

	// Switch configuration description.
	Annotation *string
}

// ConnectedSubnetRoutePolicy - Connected Subnet Route Policy properties.
type ConnectedSubnetRoutePolicy struct {
	// Array of ARM Resource ID of the RoutePolicies.
	ExportRoutePolicy *L3ExportRoutePolicy

	// ARM Resource ID of the Route Policy. This is used for the backward compatibility.
	ExportRoutePolicyID *string
}

// ControllerServices - Network Fabric Controller services.
type ControllerServices struct {
	// The IPv4 Address space is optional, if the value is not defined at the time of NFC creation, then the default value 10.0.0.0/19
	// is considered. The IPV4 address subnet is an optional attribute.
	IPv4AddressSpaces []*string

	// The IPv6 is not supported right now.
	IPv6AddressSpaces []*string
}

// DeviceInterfaceProperties - Network device interface properties.
type DeviceInterfaceProperties struct {
	// Interface identifier. Example: HundredGigE0/0.
	Identifier *string

	// Interface type.
	InterfaceType *string

	// List of supported connector types.
	SupportedConnectorTypes []*SupportedConnectorProperties
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ExportRoutePolicy - Export Route Policy either IPv4 or IPv6.
type ExportRoutePolicy struct {
	// ARM resource ID of RoutePolicy.
	ExportIPv4RoutePolicyID *string

	// ARM resource ID of RoutePolicy.
	ExportIPv6RoutePolicyID *string
}

// ExportRoutePolicyInformation - Export Route Policy Configuration.
type ExportRoutePolicyInformation struct {
	// Export IPv4 Route Policy Id.
	ExportIPv4RoutePolicyID *string

	// Export IPv6 Route Policy Id.
	ExportIPv6RoutePolicyID *string
}

// ExpressRouteConnectionInformation - The ExpressRoute circuit ID and the Auth Key are required for you to successfully deploy
// NFC service.
type ExpressRouteConnectionInformation struct {
	// REQUIRED; Authorization key for the circuit, must be of type Microsoft.Network/expressRouteCircuits/authorizations. The
	// Auth Key is a mandatory attribute.
	ExpressRouteAuthorizationKey *string

	// REQUIRED; The express route circuit Azure resource ID, must be of type Microsoft.Network/expressRouteCircuits/circuitName.
	// The ExpressRoute Circuit is a mandatory attribute.
	ExpressRouteCircuitID *string
}

// ExternalNetwork - Defines the External Network resource.
type ExternalNetwork struct {
	// REQUIRED; Resource properties.
	Properties *ExternalNetworkProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ExternalNetworkPatch - The ExternalNetwork patch resource definition.
type ExternalNetworkPatch struct {
	// External Network Patch properties.
	Properties *ExternalNetworkPatchProperties
}

// ExternalNetworkPatchProperties - External Network Patch properties.
type ExternalNetworkPatchProperties struct {
	// Switch configuration description.
	Annotation *string

	// Export Route Policy either IPv4 or IPv6.
	ExportRoutePolicy *ExportRoutePolicy

	// ARM Resource ID of the RoutePolicy. This is used for the backward compatibility.
	ExportRoutePolicyID *string

	// Import Route Policy either IPv4 or IPv6.
	ImportRoutePolicy *ImportRoutePolicy

	// ARM Resource ID of the RoutePolicy. This is used for the backward compatibility.
	ImportRoutePolicyID *string

	// option A properties object
	OptionAProperties *ExternalNetworkPatchPropertiesOptionAProperties

	// option B properties object
	OptionBProperties *L3OptionBProperties

	// Peering option list.
	PeeringOption *PeeringOption
}

// ExternalNetworkPatchPropertiesOptionAProperties - option A properties object
type ExternalNetworkPatchPropertiesOptionAProperties struct {
	// BFD configuration properties
	BfdConfiguration *BfdConfiguration

	// Egress Acl. ARM resource ID of Access Control Lists.
	EgressACLID *string

	// Ingress Acl. ARM resource ID of Access Control Lists.
	IngressACLID *string

	// MTU to use for option A peering.
	Mtu *int32

	// Peer ASN number.Example : 28
	PeerASN *int64

	// IPv4 Address Prefix.
	PrimaryIPv4Prefix *string

	// IPv6 Address Prefix.
	PrimaryIPv6Prefix *string

	// Secondary IPv4 Address Prefix.
	SecondaryIPv4Prefix *string

	// Secondary IPv6 Address Prefix.
	SecondaryIPv6Prefix *string

	// Vlan identifier. Example : 501
	VlanID *int32

	// READ-ONLY; Fabric ASN number. Example 65001
	FabricASN *int64
}

// ExternalNetworkProperties - External Network Properties.
type ExternalNetworkProperties struct {
	// REQUIRED; Peering option list.
	PeeringOption *PeeringOption

	// Switch configuration description.
	Annotation *string

	// Export Route Policy either IPv4 or IPv6.
	ExportRoutePolicy *ExportRoutePolicy

	// ARM Resource ID of the RoutePolicy. This is used for the backward compatibility.
	ExportRoutePolicyID *string

	// Import Route Policy either IPv4 or IPv6.
	ImportRoutePolicy *ImportRoutePolicy

	// ARM Resource ID of the RoutePolicy. This is used for the backward compatibility.
	ImportRoutePolicyID *string

	// option A properties object
	OptionAProperties *ExternalNetworkPropertiesOptionAProperties

	// option B properties object
	OptionBProperties *L3OptionBProperties

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; Gets the networkToNetworkInterconnectId of the resource.
	NetworkToNetworkInterconnectID *string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// ExternalNetworkPropertiesOptionAProperties - option A properties object
type ExternalNetworkPropertiesOptionAProperties struct {
	// BFD configuration properties
	BfdConfiguration *BfdConfiguration

	// Egress Acl. ARM resource ID of Access Control Lists.
	EgressACLID *string

	// Ingress Acl. ARM resource ID of Access Control Lists.
	IngressACLID *string

	// MTU to use for option A peering.
	Mtu *int32

	// Peer ASN number.Example : 28
	PeerASN *int64

	// IPv4 Address Prefix.
	PrimaryIPv4Prefix *string

	// IPv6 Address Prefix.
	PrimaryIPv6Prefix *string

	// Secondary IPv4 Address Prefix.
	SecondaryIPv4Prefix *string

	// Secondary IPv6 Address Prefix.
	SecondaryIPv6Prefix *string

	// Vlan identifier. Example : 501
	VlanID *int32

	// READ-ONLY; Fabric ASN number. Example 65001
	FabricASN *int64
}

// ExternalNetworksList - List of External Networks.
type ExternalNetworksList struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of External Network resources.
	Value []*ExternalNetwork
}

// IPCommunitiesListResult - List of IP Communities.
type IPCommunitiesListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of IP Community resources.
	Value []*IPCommunity
}

// IPCommunity - The IP Community resource definition.
type IPCommunity struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *IPCommunityProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// IPCommunityIDList - IP Community ID list properties.
type IPCommunityIDList struct {
	// List of IP Community resource IDs.
	IPCommunityIDs []*string
}

// IPCommunityPatch - The IP Community patch resource definition.
type IPCommunityPatch struct {
	// IP Community patchable properties.
	Properties *IPCommunityPatchableProperties

	// Resource tags
	Tags map[string]*string
}

// IPCommunityPatchableProperties - IP Community patchable properties.
type IPCommunityPatchableProperties struct {
	// List of IP Community Rules.
	IPCommunityRules []*IPCommunityRule
}

// IPCommunityProperties - IP Community Properties defines the resource properties.
type IPCommunityProperties struct {
	// Switch configuration description.
	Annotation *string

	// List of IP Community Rules.
	IPCommunityRules []*IPCommunityRule

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// IPCommunityRule - IP Community patchable properties.
type IPCommunityRule struct {
	// REQUIRED; Action to be taken on the configuration. Example: Permit | Deny.
	Action *CommunityActionTypes

	// REQUIRED; List the community members of IP Community.
	CommunityMembers []*string

	// REQUIRED; Sequence to insert to/delete from existing route. Prefix lists are evaluated starting with the lowest sequence
	// number and continue down the list until a match is made. Once a match is made, the permit
	// or deny statement is applied to that network and the rest of the list is ignored.
	SequenceNumber *int64

	// Supported well known Community List.
	WellKnownCommunities []*WellKnownCommunities
}

// IPExtendedCommunity - The IP Extended Community resource definition.
type IPExtendedCommunity struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *IPExtendedCommunityProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// IPExtendedCommunityIDList - IP Extended Community Id list properties.
type IPExtendedCommunityIDList struct {
	// List of IP Extended Community resource IDs.
	IPExtendedCommunityIDs []*string
}

// IPExtendedCommunityListResult - List of IP Extended Communities.
type IPExtendedCommunityListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of IP Extended Communities resources.
	Value []*IPExtendedCommunity
}

// IPExtendedCommunityPatch - The IP Extended Communities patch resource definition.
type IPExtendedCommunityPatch struct {
	// IP Extended Community patchable properties.
	Properties *IPExtendedCommunityPatchProperties

	// Resource tags
	Tags map[string]*string
}

// IPExtendedCommunityPatchProperties - IP Extended Community patchable properties.
type IPExtendedCommunityPatchProperties struct {
	// REQUIRED; List of IP Extended Community Rules.
	IPExtendedCommunityRules []*IPExtendedCommunityRule

	// Switch configuration description.
	Annotation *string
}

// IPExtendedCommunityProperties - IP Extended Community Properties defines the resource properties.
type IPExtendedCommunityProperties struct {
	// REQUIRED; List of IP Extended Community Rules.
	IPExtendedCommunityRules []*IPExtendedCommunityRule

	// Switch configuration description.
	Annotation *string

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// IPExtendedCommunityRule - List of IP Extended Community Rules.
type IPExtendedCommunityRule struct {
	// REQUIRED; Action to be taken on the configuration. Example: Permit | Deny.
	Action *CommunityActionTypes

	// REQUIRED; Route Target List.The expected formats are ASN(plain):NN >> example 4294967294:50, ASN.ASN:NN >> example 65533.65333:40,
	// IP-address:NN >> example 10.10.10.10:65535. The possible values of ASN,NN are
	// in range of 0-65535, ASN(plain) is in range of 0-4294967295.
	RouteTargets []*string

	// REQUIRED; Sequence to insert to/delete from existing route. Prefix lists are evaluated starting with the lowest sequence
	// number and continue down the list until a match is made. Once a match is made, the permit
	// or deny statement is applied to that network and the rest of the list is ignored.
	SequenceNumber *int64
}

// IPGroupProperties - IP Group properties.
type IPGroupProperties struct {
	// IP Address type.
	IPAddressType *IPAddressType

	// List of IP Prefixes.
	IPPrefixes []*string

	// IP Group name.
	Name *string
}

// IPMatchCondition - Defines the condition that can be filtered using the selected IPs.
type IPMatchCondition struct {
	// The List of IP Group Names that need to be matched.
	IPGroupNames []*string

	// The list of IP Prefixes.
	IPPrefixValues []*string

	// IP Prefix Type.
	PrefixType *PrefixType

	// IP Address type.
	Type *SourceDestinationType
}

// IPPrefix - The IP Prefix resource definition.
type IPPrefix struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *IPPrefixProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// IPPrefixPatch - The IP Prefix patch resource definition.
type IPPrefixPatch struct {
	// IP Prefix patchable properties.
	Properties *IPPrefixPatchProperties

	// Resource tags
	Tags map[string]*string
}

// IPPrefixPatchProperties - IP Prefix patchable properties.
type IPPrefixPatchProperties struct {
	// Switch configuration description.
	Annotation *string

	// The list of IP Prefix Rules.
	IPPrefixRules []*IPPrefixRule
}

// IPPrefixProperties - IP Prefix Properties defines the properties of the resource.
type IPPrefixProperties struct {
	// Switch configuration description.
	Annotation *string

	// The list of IP Prefix Rules.
	IPPrefixRules []*IPPrefixRule

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// IPPrefixRule - IP Prefix Rule properties.
type IPPrefixRule struct {
	// REQUIRED; Action to be taken on the configuration. Example: Permit | Deny.
	Action *CommunityActionTypes

	// REQUIRED; Network Prefix specifying IPv4/IPv6 packets to be permitted or denied. Example: 1.1.1.0/24 | 3FFE:FFFF:0:CD30::/126
	NetworkPrefix *string

	// REQUIRED; Sequence to insert to/delete from existing route. Prefix lists are evaluated starting with the lowest sequence
	// number and continue down the list until a match is made. Once a match is made, the permit
	// or deny statement is applied to that network and the rest of the list is ignored.
	SequenceNumber *int64

	// Specify prefix-list bounds.
	Condition *Condition

	// SubnetMaskLength gives the minimum NetworkPrefix length to be matched. Possible values for IPv4 are 1 - 32 . Possible values
	// of IPv6 are 1 - 128.
	SubnetMaskLength *string
}

// IPPrefixesListResult - List of IP Prefixes.
type IPPrefixesListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of IP Prefix resources.
	Value []*IPPrefix
}

// ImportRoutePolicy - Import Route Policy either IPv4 or IPv6.
type ImportRoutePolicy struct {
	// ARM resource ID of RoutePolicy.
	ImportIPv4RoutePolicyID *string

	// ARM resource ID of RoutePolicy.
	ImportIPv6RoutePolicyID *string
}

// ImportRoutePolicyInformation - Import Route Policy Configuration.
type ImportRoutePolicyInformation struct {
	// Import IPv4 Route Policy Id.
	ImportIPv4RoutePolicyID *string

	// Import IPv6 Route Policy Id.
	ImportIPv6RoutePolicyID *string
}

// InternalNetwork - Defines the Internal Network resource.
type InternalNetwork struct {
	// REQUIRED; Resource properties.
	Properties *InternalNetworkProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// InternalNetworkPatch - The InternalNetwork patch resource definition.
type InternalNetworkPatch struct {
	// InternalNetwork Patch properties.
	Properties *InternalNetworkPatchProperties
}

// InternalNetworkPatchProperties - InternalNetwork Patch properties.
type InternalNetworkPatchProperties struct {
	// Switch configuration description.
	Annotation *string

	// BGP configuration properties.
	BgpConfiguration *BgpConfiguration

	// List of Connected IPv4 Subnets.
	ConnectedIPv4Subnets []*ConnectedSubnet

	// List of connected IPv6 Subnets.
	ConnectedIPv6Subnets []*ConnectedSubnet

	// Egress Acl. ARM resource ID of Access Control Lists.
	EgressACLID *string

	// Export Route Policy either IPv4 or IPv6.
	ExportRoutePolicy *ExportRoutePolicy

	// ARM Resource ID of the RoutePolicy. This is used for the backward compatibility.
	ExportRoutePolicyID *string

	// Import Route Policy either IPv4 or IPv6.
	ImportRoutePolicy *ImportRoutePolicy

	// ARM Resource ID of the RoutePolicy. This is used for the backward compatibility.
	ImportRoutePolicyID *string

	// Ingress Acl. ARM resource ID of Access Control Lists.
	IngressACLID *string

	// To check whether monitoring of internal network is enabled or not.
	IsMonitoringEnabled *IsMonitoringEnabled

	// Maximum transmission unit. Default value is 1500.
	Mtu *int32

	// Static Route Configuration properties.
	StaticRouteConfiguration *StaticRouteConfiguration
}

// InternalNetworkProperties - Internal Network Properties defines the properties of the resource.
type InternalNetworkProperties struct {
	// REQUIRED; Vlan identifier. Example: 1001.
	VlanID *int32

	// Switch configuration description.
	Annotation *string

	// BGP configuration properties.
	BgpConfiguration *InternalNetworkPropertiesBgpConfiguration

	// List of Connected IPv4 Subnets.
	ConnectedIPv4Subnets []*ConnectedSubnet

	// List of connected IPv6 Subnets.
	ConnectedIPv6Subnets []*ConnectedSubnet

	// Egress Acl. ARM resource ID of Access Control Lists.
	EgressACLID *string

	// Export Route Policy either IPv4 or IPv6.
	ExportRoutePolicy *ExportRoutePolicy

	// ARM Resource ID of the RoutePolicy. This is used for the backward compatibility.
	ExportRoutePolicyID *string

	// Extension. Example: NoExtension | NPB.
	Extension *Extension

	// Import Route Policy either IPv4 or IPv6.
	ImportRoutePolicy *ImportRoutePolicy

	// ARM Resource ID of the RoutePolicy. This is used for the backward compatibility.
	ImportRoutePolicyID *string

	// Ingress Acl. ARM resource ID of Access Control Lists.
	IngressACLID *string

	// To check whether monitoring of internal network is enabled or not.
	IsMonitoringEnabled *IsMonitoringEnabled

	// Maximum transmission unit. Default value is 1500.
	Mtu *int32

	// Static Route Configuration properties.
	StaticRouteConfiguration *InternalNetworkPropertiesStaticRouteConfiguration

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// InternalNetworkPropertiesBgpConfiguration - BGP configuration properties.
type InternalNetworkPropertiesBgpConfiguration struct {
	// Allows for routes to be received and processed even if the router detects its own ASN in the AS-Path. 0 is disable, Possible
	// values are 1-10, default is 2.
	AllowAS *int32

	// Enable Or Disable state.
	AllowASOverride *AllowASOverride

	// Switch configuration description.
	Annotation *string

	// BFD configuration properties
	BfdConfiguration *BfdConfiguration

	// Originate a defaultRoute. Ex: "True" | "False".
	DefaultRouteOriginate *BooleanEnumProperty

	// List of BGP IPv4 Listen Range prefixes.
	IPv4ListenRangePrefixes []*string

	// List with stringified IPv4 Neighbor Addresses.
	IPv4NeighborAddress []*NeighborAddress

	// List of BGP IPv6 Listen Ranges prefixes.
	IPv6ListenRangePrefixes []*string

	// List with stringified IPv6 Neighbor Address.
	IPv6NeighborAddress []*NeighborAddress

	// Peer ASN. Example: 65047.
	PeerASN *int64

	// READ-ONLY; ASN of Network Fabric. Example: 65048.
	FabricASN *int64
}

// InternalNetworkPropertiesStaticRouteConfiguration - Static Route Configuration properties.
type InternalNetworkPropertiesStaticRouteConfiguration struct {
	// BFD configuration properties
	BfdConfiguration *BfdConfiguration

	// Extension. Example: NoExtension | NPB.
	Extension *Extension

	// List of IPv4 Routes.
	IPv4Routes []*StaticRouteProperties

	// List of IPv6 Routes.
	IPv6Routes []*StaticRouteProperties
}

// InternalNetworksList - List of Internal Networks.
type InternalNetworksList struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of Internal Network resources.
	Value []*InternalNetwork
}

// InternetGateway - The Internet Gateway resource definition.
type InternetGateway struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *InternetGatewayProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// InternetGatewayPatch - The Internet Gateway patch resource definition.
type InternetGatewayPatch struct {
	// Resource properties.
	Properties *InternetGatewayPatchableProperties

	// Resource tags
	Tags map[string]*string
}

// InternetGatewayPatchableProperties - Internet Gateway Patchable Properties defines the patchable properties of the resource.
type InternetGatewayPatchableProperties struct {
	// ARM Resource ID of the Internet Gateway Rule.
	InternetGatewayRuleID *string
}

// InternetGatewayProperties - Internet Gateway Properties defines the properties of the resource.
type InternetGatewayProperties struct {
	// REQUIRED; ARM Resource ID of the Network Fabric Controller.
	NetworkFabricControllerID *string

	// REQUIRED; Gateway Type of the resource.
	Type *GatewayType

	// Switch configuration description.
	Annotation *string

	// ARM Resource ID of the Internet Gateway Rule.
	InternetGatewayRuleID *string

	// READ-ONLY; IPv4 Address of Internet Gateway.
	IPv4Address *string

	// READ-ONLY; Port number of Internet Gateway.
	Port *int32

	// READ-ONLY; Provisioning state of resource.
	ProvisioningState *ProvisioningState
}

// InternetGatewayRule - The Internet Gateway Rule resource definition.
type InternetGatewayRule struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *InternetGatewayRuleProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// InternetGatewayRulePatch - The Internet Gateway Rules patch resource definition.
type InternetGatewayRulePatch struct {
	// Resource tags
	Tags map[string]*string
}

// InternetGatewayRuleProperties - Internet Gateway Rule Properties defines the resource properties.
type InternetGatewayRuleProperties struct {
	// REQUIRED; Rules for the InternetGateways
	RuleProperties *RuleProperties

	// Switch configuration description.
	Annotation *string

	// READ-ONLY; List of Internet Gateway resource Id.
	InternetGatewayIDs []*string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// InternetGatewayRulesListResult - List of Internet Gateway Rules.
type InternetGatewayRulesListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of Internet Gateway Rule resources.
	Value []*InternetGatewayRule
}

// InternetGatewaysListResult - List of InternetGateways.
type InternetGatewaysListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// Displays list of Internet Gateway resources.
	Value []*InternetGateway
}

// IsolationDomainProperties - Isolation Domain Properties.
type IsolationDomainProperties struct {
	// Type of encapsulation.
	Encapsulation *Encapsulation

	// List of Neighbor Group IDs.
	NeighborGroupIDs []*string
}

// L2IsolationDomain - The L2 Isolation Domain resource definition.
type L2IsolationDomain struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *L2IsolationDomainProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// L2IsolationDomainPatch - The L2 Isolation Domain patch resource definition.
type L2IsolationDomainPatch struct {
	// Resource properties.
	Properties *L2IsolationDomainPatchProperties

	// Resource tags
	Tags map[string]*string
}

// L2IsolationDomainPatchProperties - L2 Isolation Domain Patch Properties defines the patchable properties of the resource.
type L2IsolationDomainPatchProperties struct {
	// Switch configuration description.
	Annotation *string

	// Maximum transmission unit. Default value is 1500.
	Mtu *int32
}

// L2IsolationDomainProperties - L2Isolation Domain Properties defines the properties of the resource.
type L2IsolationDomainProperties struct {
	// REQUIRED; ARM Resource ID of the Network Fabric.
	NetworkFabricID *string

	// REQUIRED; Vlan Identifier of the Network Fabric. Example: 501.
	VlanID *int32

	// Switch configuration description.
	Annotation *string

	// Maximum transmission unit. Default value is 1500.
	Mtu *int32

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// L2IsolationDomainsListResult - List of L2 Isolation Domains.
type L2IsolationDomainsListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// Displays list of L2 Isolation Domain resources.
	Value []*L2IsolationDomain
}

// L3ExportRoutePolicy - Array of ARM Resource ID of the RoutePolicies.
type L3ExportRoutePolicy struct {
	// ARM Resource ID of the RoutePolicy.
	ExportIPv4RoutePolicyID *string

	// ARM Resource ID of the RoutePolicy.
	ExportIPv6RoutePolicyID *string
}

// L3IsolationDomain - The L3 Isolation Domain resource definition.
type L3IsolationDomain struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *L3IsolationDomainProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// L3IsolationDomainPatch - The L3 Isolation Domain patch resource definition.
type L3IsolationDomainPatch struct {
	// Resource properties.
	Properties *L3IsolationDomainPatchProperties

	// Resource tags
	Tags map[string]*string
}

// L3IsolationDomainPatchProperties - Resource properties.
type L3IsolationDomainPatchProperties struct {
	// Aggregate route configurations.
	AggregateRouteConfiguration *AggregateRouteConfiguration

	// Switch configuration description.
	Annotation *string

	// Connected Subnet RoutePolicy
	ConnectedSubnetRoutePolicy *ConnectedSubnetRoutePolicy

	// Advertise Connected Subnets. Ex: "True" | "False".
	RedistributeConnectedSubnets *RedistributeConnectedSubnets

	// Advertise Static Routes. Ex: "True" | "False".
	RedistributeStaticRoutes *RedistributeStaticRoutes
}

// L3IsolationDomainProperties - L3 Isolation Domain Properties defines the properties of the resource.
type L3IsolationDomainProperties struct {
	// REQUIRED; ARM Resource ID of the Network Fabric.
	NetworkFabricID *string

	// Aggregate route configurations.
	AggregateRouteConfiguration *AggregateRouteConfiguration

	// Switch configuration description.
	Annotation *string

	// Connected Subnet RoutePolicy
	ConnectedSubnetRoutePolicy *ConnectedSubnetRoutePolicy

	// Advertise Connected Subnets. Ex: "True" | "False".
	RedistributeConnectedSubnets *RedistributeConnectedSubnets

	// Advertise Static Routes. Ex: "True" | "False".
	RedistributeStaticRoutes *RedistributeStaticRoutes

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// L3IsolationDomainsListResult - List of L3 Isolation Domains.
type L3IsolationDomainsListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of L3 Isolation Domain resources.
	Value []*L3IsolationDomain
}

// L3OptionBProperties - Option B configuration.
type L3OptionBProperties struct {
	// RouteTargets to be applied. This is used for the backward compatibility.
	ExportRouteTargets []*string

	// RouteTargets to be applied. This is used for the backward compatibility.
	ImportRouteTargets []*string

	// RouteTargets to be applied.
	RouteTargets *RouteTargetInformation
}

// Layer2Configuration - Common properties for Layer2 Configuration.
type Layer2Configuration struct {
	// List of network device interfaces resource IDs.
	Interfaces []*string

	// MTU of the packets between PE & CE.
	Mtu *int32
}

// ManagedResourceGroupConfiguration - Managed Resource Group configuration properties.
type ManagedResourceGroupConfiguration struct {
	// Managed resource group location.
	Location *string

	// The NFC service will be hosted in a Managed resource group.
	Name *string
}

// ManagementNetworkConfigurationPatchableProperties - Configuration to be used to setup the management network.
type ManagementNetworkConfigurationPatchableProperties struct {
	// VPN Configuration properties.
	InfrastructureVPNConfiguration *VPNConfigurationPatchableProperties

	// VPN Configuration properties.
	WorkloadVPNConfiguration *VPNConfigurationPatchableProperties
}

// ManagementNetworkConfigurationProperties - Configuration to be used to setup the management network.
type ManagementNetworkConfigurationProperties struct {
	// REQUIRED; VPN Configuration properties.
	InfrastructureVPNConfiguration *VPNConfigurationProperties

	// REQUIRED; VPN Configuration properties.
	WorkloadVPNConfiguration *VPNConfigurationProperties
}

// NeighborAddress - Neighbor Address properties.
type NeighborAddress struct {
	// IP Address.
	Address *string

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState
}

// NeighborGroup - Defines the Neighbor Group.
type NeighborGroup struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *NeighborGroupProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NeighborGroupDestination - An array of destination IPv4 Addresses or IPv6 Addresses.
type NeighborGroupDestination struct {
	// Array of IPv4 Addresses.
	IPv4Addresses []*string

	// Array of IPv6 Addresses.
	IPv6Addresses []*string
}

// NeighborGroupPatch - The Neighbor Group Patch definition.
type NeighborGroupPatch struct {
	// Neighbor Group Patch properties.
	Properties *NeighborGroupPatchProperties

	// Resource tags
	Tags map[string]*string
}

// NeighborGroupPatchProperties - Neighbor Group Patch properties.
type NeighborGroupPatchProperties struct {
	// Switch configuration description.
	Annotation *string

	// An array of destination IPv4 Addresses or IPv6 Addresses.
	Destination *NeighborGroupDestination
}

// NeighborGroupProperties - Neighbor Group Properties defines the properties of the resource.
type NeighborGroupProperties struct {
	// Switch configuration description.
	Annotation *string

	// An array of destination IPv4 Addresses or IPv6 Addresses.
	Destination *NeighborGroupDestination

	// READ-ONLY; List of NetworkTap IDs where neighbor group is associated.
	NetworkTapIDs []*string

	// READ-ONLY; List of Network Tap Rule IDs where neighbor group is associated.
	NetworkTapRuleIDs []*string

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// NeighborGroupsListResult - List of Neighbor Group.
type NeighborGroupsListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of Neighbor Group resources.
	Value []*NeighborGroup
}

// NetworkDevice - The Network Device resource definition.
type NetworkDevice struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *NetworkDeviceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkDevicePatchParameters - The Network Device Patch Parameters defines the patch parameters of the resource.
type NetworkDevicePatchParameters struct {
	// Network Device Patch properties.
	Properties *NetworkDevicePatchParametersProperties

	// Resource tags
	Tags map[string]*string
}

// NetworkDevicePatchParametersProperties - Network Device Patch properties.
type NetworkDevicePatchParametersProperties struct {
	// Switch configuration description.
	Annotation *string

	// The host name of the device.
	HostName *string

	// Serial number of the device. Format of serial Number - Make;Model;HardwareRevisionId;SerialNumber.
	SerialNumber *string
}

// NetworkDeviceProperties - Network Device Properties defines the properties of the resource.
type NetworkDeviceProperties struct {
	// Switch configuration description.
	Annotation *string

	// The host name of the device.
	HostName *string

	// Network Device SKU name.
	NetworkDeviceSKU *string

	// Serial number of the device. Format of serial Number - Make;Model;HardwareRevisionId;SerialNumber.
	SerialNumber *string

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; Management IPv4 Address.
	ManagementIPv4Address *string

	// READ-ONLY; Management IPv6 Address.
	ManagementIPv6Address *string

	// READ-ONLY; NetworkDeviceRole is the device role: Example: CE | ToR.
	NetworkDeviceRole *NetworkDeviceRole

	// READ-ONLY; Reference to network rack resource id.
	NetworkRackID *string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Current version of the device as defined in SKU.
	Version *string
}

// NetworkDeviceSKU - The NetworkDeviceSku resource definition.
type NetworkDeviceSKU struct {
	// REQUIRED; Resource properties.
	Properties *NetworkDeviceSKUProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkDeviceSKUProperties - Network Device SKU Properties defines the properties of the resource.
type NetworkDeviceSKUProperties struct {
	// REQUIRED; Model of the network device.
	Model *string

	// List of network device interfaces.
	Interfaces []*DeviceInterfaceProperties

	// Manufacturer of the network device.
	Manufacturer *string

	// Available roles for the network device.
	SupportedRoleTypes []*NetworkDeviceRoleName

	// List of supported version details of network device.
	SupportedVersions []*SupportedVersionProperties

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// NetworkDeviceSKUsListResult - List of Network Device SKUs.
type NetworkDeviceSKUsListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of Network Device SKU resources.
	Value []*NetworkDeviceSKU
}

// NetworkDevicesListResult - List of NetworkDevices.
type NetworkDevicesListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of NetworkDevice resources.
	Value []*NetworkDevice
}

// NetworkFabric - The Network Fabric resource definition.
type NetworkFabric struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *NetworkFabricProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkFabricController - The Network Fabric Controller resource definition.
type NetworkFabricController struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *NetworkFabricControllerProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkFabricControllerPatch - The Network Fabric Controller Patch payload definition.
type NetworkFabricControllerPatch struct {
	// Network Fabric Controller patch properties.
	Properties *NetworkFabricControllerPatchableProperties

	// Resource tags
	Tags map[string]*string
}

// NetworkFabricControllerPatchableProperties - Network Fabric Controller updatable properties
type NetworkFabricControllerPatchableProperties struct {
	// As part of an update, the Infrastructure ExpressRoute CircuitID should be provided to create and Provision a NFC. This
	// Express route is dedicated for Infrastructure services. (This is a Mandatory
	// attribute)
	InfrastructureExpressRouteConnections []*ExpressRouteConnectionInformation

	// As part of an update, the workload ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express
	// route is dedicated for Workload services. (This is a Mandatory attribute).
	WorkloadExpressRouteConnections []*ExpressRouteConnectionInformation
}

// NetworkFabricControllerProperties defines the resource properties.
type NetworkFabricControllerProperties struct {
	// Switch configuration description.
	Annotation *string

	// IPv4 Network Fabric Controller Address Space.
	IPv4AddressSpace *string

	// IPv6 Network Fabric Controller Address Space.
	IPv6AddressSpace *string

	// As part of an update, the Infrastructure ExpressRoute CircuitID should be provided to create and Provision a NFC. This
	// Express route is dedicated for Infrastructure services. (This is a Mandatory
	// attribute)
	InfrastructureExpressRouteConnections []*ExpressRouteConnectionInformation

	// A workload management network is required for all the tenant (workload) traffic. This traffic is only dedicated for Tenant
	// workloads which are required to access internet or any other MSFT/Public
	// endpoints.
	IsWorkloadManagementNetworkEnabled *IsWorkloadManagementNetworkEnabled

	// Managed Resource Group configuration properties.
	ManagedResourceGroupConfiguration *ManagedResourceGroupConfiguration

	// Network Fabric Controller SKU.
	NfcSKU *NfcSKU

	// As part of an update, the workload ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express
	// route is dedicated for Workload services. (This is a Mandatory attribute).
	WorkloadExpressRouteConnections []*ExpressRouteConnectionInformation

	// READ-ONLY; InfrastructureServices IP ranges.
	InfrastructureServices *ControllerServices

	// READ-ONLY; The NF-ID will be an input parameter used by the NF to link and get associated with the parent NFC Service.
	NetworkFabricIDs []*string

	// READ-ONLY; Provides you the latest status of the NFC service, whether it is Accepted, updating, Succeeded or Failed. During
	// this process, the states keep changing based on the status of NFC provisioning.
	ProvisioningState *ProvisioningState

	// READ-ONLY; List of tenant InternetGateway resource IDs
	TenantInternetGatewayIDs []*string

	// READ-ONLY; A workload management network is required for all the tenant (workload) traffic. This traffic is only dedicated
	// for Tenant workloads which are required to access internet or any other MSFT/Public
	// endpoints. This is used for the backward compatibility.
	WorkloadManagementNetwork *bool

	// READ-ONLY; WorkloadServices IP ranges.
	WorkloadServices *ControllerServices
}

// NetworkFabricControllersListResult - List of Network Fabric Controllers.
type NetworkFabricControllersListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of Network Fabric Controller resources.
	Value []*NetworkFabricController
}

// NetworkFabricPatch - The Network Fabric resource definition.
type NetworkFabricPatch struct {
	// Network Fabric Patch properties.
	Properties *NetworkFabricPatchProperties

	// Resource tags
	Tags map[string]*string
}

// NetworkFabricPatchProperties - Network Fabric Patch properties.
type NetworkFabricPatchProperties struct {
	// Switch configuration description.
	Annotation *string

	// ASN of CE devices for CE/PE connectivity.
	FabricASN *int64

	// IPv4Prefix for Management Network. Example: 10.1.0.0/19.
	IPv4Prefix *string

	// IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59.
	IPv6Prefix *string

	// Configuration to be used to setup the management network.
	ManagementNetworkConfiguration *ManagementNetworkConfigurationPatchableProperties

	// Number of compute racks associated to Network Fabric.
	RackCount *int32

	// Number of servers.Possible values are from 1-16.
	ServerCountPerRack *int32

	// Network and credentials configuration already applied to terminal server.
	TerminalServerConfiguration *NetworkFabricPatchablePropertiesTerminalServerConfiguration
}

// NetworkFabricPatchablePropertiesTerminalServerConfiguration - Network and credentials configuration already applied to
// terminal server.
type NetworkFabricPatchablePropertiesTerminalServerConfiguration struct {
	// Password for the terminal server connection.
	Password *string

	// IPv4 Address Prefix.
	PrimaryIPv4Prefix *string

	// IPv6 Address Prefix.
	PrimaryIPv6Prefix *string

	// Secondary IPv4 Address Prefix.
	SecondaryIPv4Prefix *string

	// Secondary IPv6 Address Prefix.
	SecondaryIPv6Prefix *string

	// Serial Number of Terminal server.
	SerialNumber *string

	// Username for the terminal server connection.
	Username *string
}

// NetworkFabricProperties - Network Fabric Properties defines the properties of the resource.
type NetworkFabricProperties struct {
	// REQUIRED; ASN of CE devices for CE/PE connectivity.
	FabricASN *int64

	// REQUIRED; IPv4Prefix for Management Network. Example: 10.1.0.0/19.
	IPv4Prefix *string

	// REQUIRED; Configuration to be used to setup the management network.
	ManagementNetworkConfiguration *ManagementNetworkConfigurationProperties

	// REQUIRED; Azure resource ID for the NetworkFabricController the NetworkFabric belongs.
	NetworkFabricControllerID *string

	// REQUIRED; Supported Network Fabric SKU.Example: Compute / Aggregate racks. Once the user chooses a particular SKU, only
	// supported racks can be added to the Network Fabric. The SKU determines whether it is a
	// single / multi rack Network Fabric.
	NetworkFabricSKU *string

	// REQUIRED; Number of servers.Possible values are from 1-16.
	ServerCountPerRack *int32

	// REQUIRED; Network and credentials configuration currently applied to terminal server.
	TerminalServerConfiguration *TerminalServerConfiguration

	// Switch configuration description.
	Annotation *string

	// IPv6Prefix for Management Network. Example: 3FFE:FFFF:0:CD40::/59
	IPv6Prefix *string

	// Number of compute racks associated to Network Fabric.
	RackCount *int32

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; The version of Network Fabric.
	FabricVersion *string

	// READ-ONLY; List of L2 Isolation Domain resource IDs under the Network Fabric.
	L2IsolationDomains []*string

	// READ-ONLY; List of L3 Isolation Domain resource IDs under the Network Fabric.
	L3IsolationDomains []*string

	// READ-ONLY; Provides you the latest status of the NFC service, whether it is Accepted, updating, Succeeded or Failed. During
	// this process, the states keep changing based on the status of NFC provisioning.
	ProvisioningState *ProvisioningState

	// READ-ONLY; List of NetworkRack resource IDs under the Network Fabric. The number of racks allowed depends on the Network
	// Fabric SKU.
	Racks []*string

	// READ-ONLY; Array of router IDs.
	RouterIDs []*string
}

// NetworkFabricSKU - The Network Fabric SKU resource definition.
type NetworkFabricSKU struct {
	// REQUIRED; Resource properties.
	Properties *NetworkFabricSKUProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkFabricSKUProperties - Network Fabric SKU Properties define properties of the resource.
type NetworkFabricSKUProperties struct {
	// Maximum number of compute racks available for this Network Fabric SKU. The value of max count racks is 4 for 4 rack SKU
	// and 8 for 8 rack SKU.
	MaxComputeRacks *int32

	// Maximum number of servers available for this Network Fabric SKU.
	MaximumServerCount *int32

	// READ-ONLY; URL providing detailed configuration of the fabric SKU.
	Details *string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; List of supported Network Fabric SKU versions.
	SupportedVersions []*string

	// READ-ONLY; Type of Network Fabric SKU.
	Type *FabricSKUType
}

// NetworkFabricSKUsListResult - List of Network Fabric SKUs.
type NetworkFabricSKUsListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of Network Fabric SKU resources.
	Value []*NetworkFabricSKU
}

// NetworkFabricsListResult - List of Network Fabrics.
type NetworkFabricsListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of Network Fabric resources.
	Value []*NetworkFabric
}

// NetworkInterface - Defines the NetworkInterface resource.
type NetworkInterface struct {
	// REQUIRED; Resource properties.
	Properties *NetworkInterfaceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkInterfacePatch - The NetworkInterfacePatch resource definition.
type NetworkInterfacePatch struct {
	// Network Interface Patch properties.
	Properties *NetworkInterfacePatchProperties
}

// NetworkInterfacePatchProperties - Network Interface Patch properties.
type NetworkInterfacePatchProperties struct {
	// Switch configuration description.
	Annotation *string
}

// NetworkInterfaceProperties - Network Interface Properties defines the properties of the resource.
type NetworkInterfaceProperties struct {
	// Switch configuration description.
	Annotation *string

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; The ARM resource id of the interface or compute server its connected to.
	ConnectedTo *string

	// READ-ONLY; IPv4Address of the interface.
	IPv4Address *string

	// READ-ONLY; IPv6Address of the interface.
	IPv6Address *string

	// READ-ONLY; The Interface Type. Example: Management/Data
	InterfaceType *InterfaceType

	// READ-ONLY; Physical Identifier of the network interface.
	PhysicalIdentifier *string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// NetworkInterfacesList - List of NetworkInterfaces.
type NetworkInterfacesList struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of NetworkInterfaces resources.
	Value []*NetworkInterface
}

// NetworkPacketBroker - The NetworkPacketBroker resource definition.
type NetworkPacketBroker struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *NetworkPacketBrokerProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkPacketBrokerPatch - The NetworkPacketBroker patch resource definition.
type NetworkPacketBrokerPatch struct {
	// Resource tags
	Tags map[string]*string
}

// NetworkPacketBrokerProperties - Network Packet Broker Properties defines the properties of the resource.
type NetworkPacketBrokerProperties struct {
	// REQUIRED; ARM resource ID of the Network Fabric.
	NetworkFabricID *string

	// READ-ONLY; List of neighbor group IDs configured on NPB.
	NeighborGroupIDs []*string

	// READ-ONLY; List of ARM resource IDs of Network Devices [NPB].
	NetworkDeviceIDs []*string

	// READ-ONLY; List of network Tap IDs configured on NPB.
	NetworkTapIDs []*string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; List of network interfaces across NPB devices that are used to mirror source traffic.
	SourceInterfaceIDs []*string
}

// NetworkPacketBrokersListResult - List of NetworkPacketBrokers.
type NetworkPacketBrokersListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of NetworkPacketBroker resources.
	Value []*NetworkPacketBroker
}

// NetworkRack - The Network Rack resource definition.
type NetworkRack struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *NetworkRackProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkRackProperties - Network Rack Properties defines the properties of the resource.
type NetworkRackProperties struct {
	// REQUIRED; ARM resource ID of the Network Fabric.
	NetworkFabricID *string

	// Switch configuration description.
	Annotation *string

	// Network Rack SKU name.
	NetworkRackType *NetworkRackType

	// READ-ONLY; List of network device ARM resource IDs.
	NetworkDevices []*string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// NetworkRacksListResult - List of Network Racks.
type NetworkRacksListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of Network Rack resources.
	Value []*NetworkRack
}

// NetworkTap - The Network Tap resource definition.
type NetworkTap struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *NetworkTapProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkTapPatch - The NetworkFabric resource definition.
type NetworkTapPatch struct {
	// Resource properties.
	Properties *NetworkTapPatchableParameters

	// Resource tags
	Tags map[string]*string
}

// NetworkTapPatchableParameters - The Network Tap resource patch definition.
type NetworkTapPatchableParameters struct {
	// Switch configuration description.
	Annotation *string

	// List of destination properties to send the filter traffic.
	Destinations []*NetworkTapPatchableParametersDestinationsItem

	// Polling type.
	PollingType *PollingType
}

// NetworkTapPatchableParametersDestinationsItem - Destination.
type NetworkTapPatchableParametersDestinationsItem struct {
	// The destination Id. ARM Resource ID of either NNI or Internal Networks.
	DestinationID *string

	// ARM Resource ID of destination Tap Rule that contains match configurations.
	DestinationTapRuleID *string

	// Type of destination. Input can be IsolationDomain or Direct.
	DestinationType *DestinationType

	// Isolation Domain Properties.
	IsolationDomainProperties *IsolationDomainProperties

	// Destination name.
	Name *string
}

// NetworkTapProperties - Network Tap Properties defines the properties of the resource.
type NetworkTapProperties struct {
	// REQUIRED; List of destinations to send the filter traffic.
	Destinations []*NetworkTapPropertiesDestinationsItem

	// REQUIRED; ARM resource ID of the Network Packet Broker.
	NetworkPacketBrokerID *string

	// Switch configuration description.
	Annotation *string

	// Polling type.
	PollingType *PollingType

	// READ-ONLY; Administrative state of the resource. Example -Enabled/Disabled
	AdministrativeState *AdministrativeState

	// READ-ONLY; Gets the configurations state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; Provides you the latest status of the NFC service, whether it is Accepted, updating, Succeeded or Failed. During
	// this process, the states keep changing based on the status of Network Tap provisioning.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Source Tap Rule Id. ARM Resource ID of the Network Tap Rule.
	SourceTapRuleID *string
}

// NetworkTapPropertiesDestinationsItem - Destination.
type NetworkTapPropertiesDestinationsItem struct {
	// The destination Id. ARM Resource ID of either NNI or Internal Networks.
	DestinationID *string

	// ARM Resource ID of destination Tap Rule that contains match configurations.
	DestinationTapRuleID *string

	// Type of destination. Input can be IsolationDomain or Direct.
	DestinationType *DestinationType

	// Isolation Domain Properties.
	IsolationDomainProperties *IsolationDomainProperties

	// Destination name.
	Name *string
}

// NetworkTapRule - The NetworkTapRule resource definition.
type NetworkTapRule struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *NetworkTapRuleProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkTapRuleAction - Action that need to performed.
type NetworkTapRuleAction struct {
	// Destination Id. The ARM resource Id may be either Network To Network Interconnect or NeighborGroup.
	DestinationID *string

	// The parameter to enable or disable the timestamp.
	IsTimestampEnabled *BooleanEnumProperty

	// The name of the match configuration. This is used when Goto type is provided. If Goto type is selected and no match configuration
	// name is provided. It goes to next configuration.
	MatchConfigurationName *string

	// Truncate. 0 indicates do not truncate.
	Truncate *string

	// Type of actions that can be performed.
	Type *TapRuleActionType
}

// NetworkTapRuleMatchCondition - Defines the match condition that is supported to filter the traffic.
type NetworkTapRuleMatchCondition struct {
	// Encapsulation Type.
	EncapsulationType *EncapsulationType

	// IP condition that needs to be matched.
	IPCondition *IPMatchCondition

	// Defines the port condition that needs to be matched.
	PortCondition *PortCondition

	// List of the protocols that need to be matched.
	ProtocolTypes []*string

	// Vlan match condition that needs to be matched.
	VlanMatchCondition *VlanMatchCondition
}

// NetworkTapRuleMatchConfiguration - Defines the match configuration that are supported to filter the traffic.
type NetworkTapRuleMatchConfiguration struct {
	// List of actions that need to be performed for the matched conditions.
	Actions []*NetworkTapRuleAction

	// Type of IP Address. IPv4 or IPv6
	IPAddressType *IPAddressType

	// List of the match conditions.
	MatchConditions []*NetworkTapRuleMatchCondition

	// The name of the match configuration.
	MatchConfigurationName *string

	// Sequence Number of the match configuration..
	SequenceNumber *int64
}

// NetworkTapRulePatch - The NetworkTapRule resource definition.
type NetworkTapRulePatch struct {
	// Network Tap Rule Patch properties.
	Properties *NetworkTapRulePatchProperties

	// Resource tags
	Tags map[string]*string
}

// NetworkTapRulePatchProperties - Network Tap Rule Patch properties.
type NetworkTapRulePatchProperties struct {
	// Switch configuration description.
	Annotation *string

	// Input method to configure Network Tap Rule.
	ConfigurationType *ConfigurationType

	// List of dynamic match configurations.
	DynamicMatchConfigurations []*CommonDynamicMatchConfiguration

	// List of match configurations.
	MatchConfigurations []*NetworkTapRuleMatchConfiguration

	// Network Tap Rules file URL.
	TapRulesURL *string
}

// NetworkTapRuleProperties - Network Tap Rule Properties defines the resource properties.
type NetworkTapRuleProperties struct {
	// Switch configuration description.
	Annotation *string

	// Input method to configure Network Tap Rule.
	ConfigurationType *ConfigurationType

	// List of dynamic match configurations.
	DynamicMatchConfigurations []*CommonDynamicMatchConfiguration

	// List of match configurations.
	MatchConfigurations []*NetworkTapRuleMatchConfiguration

	// Polling interval in seconds.
	PollingIntervalInSeconds *PollingIntervalInSeconds

	// Network Tap Rules file URL.
	TapRulesURL *string

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; The last sync timestamp.
	LastSyncedTime *time.Time

	// READ-ONLY; The ARM resource Id of the NetworkTap.
	NetworkTapID *string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// NetworkTapRulesListResult - List of NetworkTapRules.
type NetworkTapRulesListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of NetworkTapRule resources.
	Value []*NetworkTapRule
}

// NetworkTapsListResult - List of NetworkTaps.
type NetworkTapsListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of NetworkTap resources.
	Value []*NetworkTap
}

// NetworkToNetworkInterconnect - The Network To Network Interconnect resource definition.
type NetworkToNetworkInterconnect struct {
	// REQUIRED; Resource properties.
	Properties *NetworkToNetworkInterconnectProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkToNetworkInterconnectPatch - The Network To Network Interconnect resource patch definition.
type NetworkToNetworkInterconnectPatch struct {
	// Resource properties.
	Properties *NetworkToNetworkInterconnectPatchableProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkToNetworkInterconnectPatchableProperties - Network to Network Interconnect patchable properties.
type NetworkToNetworkInterconnectPatchableProperties struct {
	// Egress Acl. ARM resource ID of Access Control Lists.
	EgressACLID *string

	// Export Route Policy information
	ExportRoutePolicy *ExportRoutePolicyInformation

	// Import Route Policy information.
	ImportRoutePolicy *ImportRoutePolicyInformation

	// Ingress Acl. ARM resource ID of Access Control Lists.
	IngressACLID *string

	// Common properties for Layer2Configuration.
	Layer2Configuration *Layer2Configuration

	// NPB Static Route Configuration properties.
	NpbStaticRouteConfiguration *NpbStaticRouteConfiguration

	// Common properties for Layer3Configuration.
	OptionBLayer3Configuration *OptionBLayer3Configuration
}

// NetworkToNetworkInterconnectProperties - Configuration used to setup CE-PE connectivity.
type NetworkToNetworkInterconnectProperties struct {
	// REQUIRED; Based on this option layer3 parameters are mandatory. Example: True/False
	UseOptionB *BooleanEnumProperty

	// Egress Acl. ARM resource ID of Access Control Lists.
	EgressACLID *string

	// Export Route Policy configuration.
	ExportRoutePolicy *ExportRoutePolicyInformation

	// Import Route Policy configuration.
	ImportRoutePolicy *ImportRoutePolicyInformation

	// Ingress Acl. ARM resource ID of Access Control Lists.
	IngressACLID *string

	// Configuration to use NNI for Infrastructure Management. Example: True/False.
	IsManagementType *IsManagementType

	// Common properties for Layer2 Configuration.
	Layer2Configuration *Layer2Configuration

	// Type of NNI used. Example: CE | NPB
	NniType *NniType

	// NPB Static Route Configuration properties.
	NpbStaticRouteConfiguration *NpbStaticRouteConfiguration

	// Common properties for Layer3Configuration.
	OptionBLayer3Configuration *NetworkToNetworkInterconnectPropertiesOptionBLayer3Configuration

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// NetworkToNetworkInterconnectPropertiesOptionBLayer3Configuration - Common properties for Layer3Configuration.
type NetworkToNetworkInterconnectPropertiesOptionBLayer3Configuration struct {
	// ASN of PE devices for CE/PE connectivity.Example : 28
	PeerASN *int64

	// IPv4 Address Prefix.
	PrimaryIPv4Prefix *string

	// IPv6 Address Prefix.
	PrimaryIPv6Prefix *string

	// Secondary IPv4 Address Prefix.
	SecondaryIPv4Prefix *string

	// Secondary IPv6 Address Prefix.
	SecondaryIPv6Prefix *string

	// VLAN for CE/PE Layer 3 connectivity.Example : 501
	VlanID *int32

	// READ-ONLY; ASN of CE devices for CE/PE connectivity.
	FabricASN *int64
}

// NetworkToNetworkInterconnectsList - List of Network To Network Interconnects.
type NetworkToNetworkInterconnectsList struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of NetworkToNetworkInterconnects resources.
	Value []*NetworkToNetworkInterconnect
}

// NpbStaticRouteConfiguration - NPB Static Route Configuration properties.
type NpbStaticRouteConfiguration struct {
	// BFD Configuration properties.
	BfdConfiguration *BfdConfiguration

	// List of IPv4 Routes.
	IPv4Routes []*StaticRouteProperties

	// List of IPv6 Routes.
	IPv6Routes []*StaticRouteProperties
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// OptionBLayer3Configuration - OptionB Layer3 Configuration properties.
type OptionBLayer3Configuration struct {
	// ASN of PE devices for CE/PE connectivity.Example : 28
	PeerASN *int64

	// IPv4 Address Prefix.
	PrimaryIPv4Prefix *string

	// IPv6 Address Prefix.
	PrimaryIPv6Prefix *string

	// Secondary IPv4 Address Prefix.
	SecondaryIPv4Prefix *string

	// Secondary IPv6 Address Prefix.
	SecondaryIPv6Prefix *string

	// VLAN for CE/PE Layer 3 connectivity.Example : 501
	VlanID *int32

	// READ-ONLY; ASN of CE devices for CE/PE connectivity.
	FabricASN *int64
}

// OptionBProperties - Option B configuration to be used for Management VPN.
type OptionBProperties struct {
	// Route Targets to be applied for outgoing routes from CE. This is for backward compatibility.
	ExportRouteTargets []*string

	// Route Targets to be applied for incoming routes into CE. This is for backward compatibility.
	ImportRouteTargets []*string

	// Route Targets to be applied.
	RouteTargets *RouteTargetInformation
}

// PortCondition - Port condition that needs to be matched.
type PortCondition struct {
	// REQUIRED; Layer4 protocol type that needs to be matched.
	Layer4Protocol *Layer4Protocol

	// List of the port Group Names that to be matched.
	PortGroupNames []*string

	// Port type that needs to be matched.
	PortType *PortType

	// List of the Ports that need to be matched.
	Ports []*string
}

// PortGroupProperties - Port Group properties.
type PortGroupProperties struct {
	// The name of the port group.
	Name *string

	// List of the ports that needs to be matched.
	Ports []*string
}

// RebootProperties - Reboot properties.
type RebootProperties struct {
	// Type of reboot to be performed. Example: GracefulRebootWithZTP
	RebootType *RebootType
}

// RoutePoliciesListResult - List of RoutePolicies.
type RoutePoliciesListResult struct {
	// Url to follow for getting next page of resources.
	NextLink *string

	// List of RoutePolicy resources.
	Value []*RoutePolicy
}

// RoutePolicy - The RoutePolicy resource definition.
type RoutePolicy struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Resource properties.
	Properties *RoutePolicyProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RoutePolicyPatch - The Route Policy patch resource definition.
type RoutePolicyPatch struct {
	// The RoutePolicy patchable properties.
	Properties *RoutePolicyPatchableProperties

	// Resource tags
	Tags map[string]*string
}

// RoutePolicyPatchableProperties - Route Policy patchable properties.
type RoutePolicyPatchableProperties struct {
	// Route Policy statements.
	Statements []*RoutePolicyStatementProperties
}

// RoutePolicyProperties defines the resource properties.
type RoutePolicyProperties struct {
	// REQUIRED; Arm Resource ID of Network Fabric.
	NetworkFabricID *string

	// AddressFamilyType. This parameter decides whether the given ipv4 or ipv6 route policy.
	AddressFamilyType *AddressFamilyType

	// Switch configuration description.
	Annotation *string

	// Route Policy statements.
	Statements []*RoutePolicyStatementProperties

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState

	// READ-ONLY; Configuration state of the resource.
	ConfigurationState *ConfigurationState

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// RoutePolicyStatementProperties - Route Policy Statement properties.
type RoutePolicyStatementProperties struct {
	// REQUIRED; Route policy action properties.
	Action *StatementActionProperties

	// REQUIRED; Route policy condition properties.
	Condition *StatementConditionProperties

	// REQUIRED; Sequence to insert to/delete from existing route.
	SequenceNumber *int64

	// Switch configuration description.
	Annotation *string
}

// RouteTargetInformation - Route Target Configuration.
type RouteTargetInformation struct {
	// Route Targets to be applied for outgoing routes into CE.
	ExportIPv4RouteTargets []*string

	// Route Targets to be applied for outgoing routes from CE.
	ExportIPv6RouteTargets []*string

	// Route Targets to be applied for incoming routes into CE.
	ImportIPv4RouteTargets []*string

	// Route Targets to be applied for incoming routes from CE.
	ImportIPv6RouteTargets []*string
}

// RuleProperties - Rules for the InternetGateways
type RuleProperties struct {
	// REQUIRED; Specify action.
	Action *Action

	// REQUIRED; List of Addresses to be allowed or denied.
	AddressList []*string
}

// StatementActionProperties - Route policy action properties.
type StatementActionProperties struct {
	// REQUIRED; Action type. Example: Permit | Deny | Continue.
	ActionType *RoutePolicyActionType

	// IP Community Properties.
	IPCommunityProperties *ActionIPCommunityProperties

	// IP Extended Community Properties.
	IPExtendedCommunityProperties *ActionIPExtendedCommunityProperties

	// Local Preference of the route policy.
	LocalPreference *int64
}

// StatementConditionProperties - Route policy statement condition properties.
type StatementConditionProperties struct {
	// List of IP Community resource IDs.
	IPCommunityIDs []*string

	// List of IP Extended Community resource IDs.
	IPExtendedCommunityIDs []*string

	// Arm Resource Id of IpPrefix.
	IPPrefixID *string

	// Type of the condition used.
	Type *RoutePolicyConditionType
}

// StaticRouteConfiguration - Static Route Configuration properties.
type StaticRouteConfiguration struct {
	// BFD configuration properties
	BfdConfiguration *BfdConfiguration

	// List of IPv4 Routes.
	IPv4Routes []*StaticRouteProperties

	// List of IPv6 Routes.
	IPv6Routes []*StaticRouteProperties
}

// StaticRouteProperties - Route Properties.
type StaticRouteProperties struct {
	// REQUIRED; List of next hop addresses.
	NextHop []*string

	// REQUIRED; Prefix of the route.
	Prefix *string
}

// SupportedConnectorProperties - Supported connector properties.
type SupportedConnectorProperties struct {
	// Type of connector used. Example: Optical.
	ConnectorType *string

	// Maximum speed of the connector in Mbps.
	MaxSpeedInMbps *int32
}

// SupportedVersionProperties - Supported version details of the network device.
type SupportedVersionProperties struct {
	// If true newly provisioned Fabric will use this device version by default to bootstrap the network devices for the first
	// time.
	IsDefault *BooleanEnumProperty

	// Firmware version.
	VendorFirmwareVersion *string

	// Operating system version.
	VendorOsVersion *string

	// Operating system and firmware combined versions.
	Version *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagsUpdate - Base tracked resource type for PATCH updates.
type TagsUpdate struct {
	// Resource tags
	Tags map[string]*string
}

// TerminalServerConfiguration - Network and credentials configuration currently applied to terminal server.
type TerminalServerConfiguration struct {
	// Password for the terminal server connection.
	Password *string

	// IPv4 Address Prefix.
	PrimaryIPv4Prefix *string

	// IPv6 Address Prefix.
	PrimaryIPv6Prefix *string

	// Secondary IPv4 Address Prefix.
	SecondaryIPv4Prefix *string

	// Secondary IPv6 Address Prefix.
	SecondaryIPv6Prefix *string

	// Serial Number of Terminal server.
	SerialNumber *string

	// Username for the terminal server connection.
	Username *string

	// READ-ONLY; ARM Resource ID used for the NetworkDevice.
	NetworkDeviceID *string
}

// UpdateAdministrativeState - Update administrative state on list of resources.
type UpdateAdministrativeState struct {
	// Network Fabrics or Network Rack resource Id.
	ResourceIDs []*string

	// Administrative state.
	State *EnableDisableState
}

// UpdateDeviceAdministrativeState - Update the administrative state on list of resources.
type UpdateDeviceAdministrativeState struct {
	// Network Fabrics or Network Rack resource Id.
	ResourceIDs []*string

	// Administrative state.
	State *DeviceAdministrativeState
}

// UpdateVersion - Update version properties.
type UpdateVersion struct {
	// Specify the version.
	Version *string
}

// VPNConfigurationPatchableProperties - Network and credential configuration currently applied on terminal server.
type VPNConfigurationPatchableProperties struct {
	// ARM Resource ID of the Network To Network Interconnect.
	NetworkToNetworkInterconnectID *string

	// option A properties
	OptionAProperties *VPNConfigurationPatchablePropertiesOptionAProperties

	// option B properties
	OptionBProperties *OptionBProperties

	// Peering option list.
	PeeringOption *PeeringOption
}

// VPNConfigurationPatchablePropertiesOptionAProperties - option A properties
type VPNConfigurationPatchablePropertiesOptionAProperties struct {
	// BFD Configuration properties.
	BfdConfiguration *BfdConfiguration

	// MTU to use for option A peering.
	Mtu *int32

	// Peer ASN number.Example : 28
	PeerASN *int64

	// IPv4 Address Prefix.
	PrimaryIPv4Prefix *string

	// IPv6 Address Prefix.
	PrimaryIPv6Prefix *string

	// Secondary IPv4 Address Prefix.
	SecondaryIPv4Prefix *string

	// Secondary IPv6 Address Prefix.
	SecondaryIPv6Prefix *string

	// Vlan Id.Example : 501
	VlanID *int32
}

// VPNConfigurationProperties - Network and credential configuration currently applied on terminal server.
type VPNConfigurationProperties struct {
	// REQUIRED; Peering option list.
	PeeringOption *PeeringOption

	// ARM Resource ID of the Network To Network Interconnect.
	NetworkToNetworkInterconnectID *string

	// option A properties
	OptionAProperties *VPNConfigurationPropertiesOptionAProperties

	// option B properties
	OptionBProperties *OptionBProperties

	// READ-ONLY; Administrative state of the resource.
	AdministrativeState *AdministrativeState
}

// VPNConfigurationPropertiesOptionAProperties - option A properties
type VPNConfigurationPropertiesOptionAProperties struct {
	// BFD Configuration properties.
	BfdConfiguration *BfdConfiguration

	// MTU to use for option A peering.
	Mtu *int32

	// Peer ASN number.Example : 28
	PeerASN *int64

	// IPv4 Address Prefix.
	PrimaryIPv4Prefix *string

	// IPv6 Address Prefix.
	PrimaryIPv6Prefix *string

	// Secondary IPv4 Address Prefix.
	SecondaryIPv4Prefix *string

	// Secondary IPv6 Address Prefix.
	SecondaryIPv6Prefix *string

	// Vlan Id.Example : 501
	VlanID *int32
}

// ValidateConfigurationProperties - Validation configuration properties.
type ValidateConfigurationProperties struct {
	// Validate action that to be performed
	ValidateAction *ValidateAction
}

// ValidateConfigurationResponse - The response of the action validate configuration.
type ValidateConfigurationResponse struct {
	// The error object.
	Error *ErrorDetail

	// URL for the details of the response.
	URL *string

	// READ-ONLY; Gets the configuration state.
	ConfigurationState *ConfigurationState
}

// VlanGroupProperties - Vlan group properties.
type VlanGroupProperties struct {
	// Vlan group name.
	Name *string

	// List of vlans.
	Vlans []*string
}

// VlanMatchCondition - The vlan match conditions that needs to be matched.
type VlanMatchCondition struct {
	// List of inner vlans that needs to be matched.
	InnerVlans []*string

	// List of vlan group names that to be matched.
	VlanGroupNames []*string

	// List of vlans that needs to be matched.
	Vlans []*string
}
