//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armmigrate.ClientFactory type.
type ServerFactory struct {
	AssessedMachinesServer          AssessedMachinesServer
	AssessmentsServer               AssessmentsServer
	GroupsServer                    GroupsServer
	HyperVCollectorsServer          HyperVCollectorsServer
	ImportCollectorsServer          ImportCollectorsServer
	MachinesServer                  MachinesServer
	OperationsServer                OperationsServer
	PrivateEndpointConnectionServer PrivateEndpointConnectionServer
	PrivateLinkResourceServer       PrivateLinkResourceServer
	ProjectsServer                  ProjectsServer
	ServerCollectorsServer          ServerCollectorsServer
	VMwareCollectorsServer          VMwareCollectorsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armmigrate.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armmigrate.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                               *ServerFactory
	trMu                              sync.Mutex
	trAssessedMachinesServer          *AssessedMachinesServerTransport
	trAssessmentsServer               *AssessmentsServerTransport
	trGroupsServer                    *GroupsServerTransport
	trHyperVCollectorsServer          *HyperVCollectorsServerTransport
	trImportCollectorsServer          *ImportCollectorsServerTransport
	trMachinesServer                  *MachinesServerTransport
	trOperationsServer                *OperationsServerTransport
	trPrivateEndpointConnectionServer *PrivateEndpointConnectionServerTransport
	trPrivateLinkResourceServer       *PrivateLinkResourceServerTransport
	trProjectsServer                  *ProjectsServerTransport
	trServerCollectorsServer          *ServerCollectorsServerTransport
	trVMwareCollectorsServer          *VMwareCollectorsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AssessedMachinesClient":
		initServer(s, &s.trAssessedMachinesServer, func() *AssessedMachinesServerTransport {
			return NewAssessedMachinesServerTransport(&s.srv.AssessedMachinesServer)
		})
		resp, err = s.trAssessedMachinesServer.Do(req)
	case "AssessmentsClient":
		initServer(s, &s.trAssessmentsServer, func() *AssessmentsServerTransport { return NewAssessmentsServerTransport(&s.srv.AssessmentsServer) })
		resp, err = s.trAssessmentsServer.Do(req)
	case "GroupsClient":
		initServer(s, &s.trGroupsServer, func() *GroupsServerTransport { return NewGroupsServerTransport(&s.srv.GroupsServer) })
		resp, err = s.trGroupsServer.Do(req)
	case "HyperVCollectorsClient":
		initServer(s, &s.trHyperVCollectorsServer, func() *HyperVCollectorsServerTransport {
			return NewHyperVCollectorsServerTransport(&s.srv.HyperVCollectorsServer)
		})
		resp, err = s.trHyperVCollectorsServer.Do(req)
	case "ImportCollectorsClient":
		initServer(s, &s.trImportCollectorsServer, func() *ImportCollectorsServerTransport {
			return NewImportCollectorsServerTransport(&s.srv.ImportCollectorsServer)
		})
		resp, err = s.trImportCollectorsServer.Do(req)
	case "MachinesClient":
		initServer(s, &s.trMachinesServer, func() *MachinesServerTransport { return NewMachinesServerTransport(&s.srv.MachinesServer) })
		resp, err = s.trMachinesServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PrivateEndpointConnectionClient":
		initServer(s, &s.trPrivateEndpointConnectionServer, func() *PrivateEndpointConnectionServerTransport {
			return NewPrivateEndpointConnectionServerTransport(&s.srv.PrivateEndpointConnectionServer)
		})
		resp, err = s.trPrivateEndpointConnectionServer.Do(req)
	case "PrivateLinkResourceClient":
		initServer(s, &s.trPrivateLinkResourceServer, func() *PrivateLinkResourceServerTransport {
			return NewPrivateLinkResourceServerTransport(&s.srv.PrivateLinkResourceServer)
		})
		resp, err = s.trPrivateLinkResourceServer.Do(req)
	case "ProjectsClient":
		initServer(s, &s.trProjectsServer, func() *ProjectsServerTransport { return NewProjectsServerTransport(&s.srv.ProjectsServer) })
		resp, err = s.trProjectsServer.Do(req)
	case "ServerCollectorsClient":
		initServer(s, &s.trServerCollectorsServer, func() *ServerCollectorsServerTransport {
			return NewServerCollectorsServerTransport(&s.srv.ServerCollectorsServer)
		})
		resp, err = s.trServerCollectorsServer.Do(req)
	case "VMwareCollectorsClient":
		initServer(s, &s.trVMwareCollectorsServer, func() *VMwareCollectorsServerTransport {
			return NewVMwareCollectorsServerTransport(&s.srv.VMwareCollectorsServer)
		})
		resp, err = s.trVMwareCollectorsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
