//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/networkanalytics/armnetworkanalytics"
	"net/http"
	"net/url"
	"regexp"
)

// DataTypesServer is a fake server for instances of the armnetworkanalytics.DataTypesClient type.
type DataTypesServer struct {
	// BeginCreate is the fake for method DataTypesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, resource armnetworkanalytics.DataType, options *armnetworkanalytics.DataTypesClientBeginCreateOptions) (resp azfake.PollerResponder[armnetworkanalytics.DataTypesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method DataTypesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, options *armnetworkanalytics.DataTypesClientBeginDeleteOptions) (resp azfake.PollerResponder[armnetworkanalytics.DataTypesClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDeleteData is the fake for method DataTypesClient.BeginDeleteData
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteData func(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, body any, options *armnetworkanalytics.DataTypesClientBeginDeleteDataOptions) (resp azfake.PollerResponder[armnetworkanalytics.DataTypesClientDeleteDataResponse], errResp azfake.ErrorResponder)

	// GenerateStorageContainerSasToken is the fake for method DataTypesClient.GenerateStorageContainerSasToken
	// HTTP status codes to indicate success: http.StatusOK
	GenerateStorageContainerSasToken func(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, body armnetworkanalytics.ContainerSaS, options *armnetworkanalytics.DataTypesClientGenerateStorageContainerSasTokenOptions) (resp azfake.Responder[armnetworkanalytics.DataTypesClientGenerateStorageContainerSasTokenResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DataTypesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, options *armnetworkanalytics.DataTypesClientGetOptions) (resp azfake.Responder[armnetworkanalytics.DataTypesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDataProductPager is the fake for method DataTypesClient.NewListByDataProductPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDataProductPager func(resourceGroupName string, dataProductName string, options *armnetworkanalytics.DataTypesClientListByDataProductOptions) (resp azfake.PagerResponder[armnetworkanalytics.DataTypesClientListByDataProductResponse])

	// BeginUpdate is the fake for method DataTypesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, dataProductName string, dataTypeName string, properties armnetworkanalytics.DataTypeUpdate, options *armnetworkanalytics.DataTypesClientBeginUpdateOptions) (resp azfake.PollerResponder[armnetworkanalytics.DataTypesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewDataTypesServerTransport creates a new instance of DataTypesServerTransport with the provided implementation.
// The returned DataTypesServerTransport instance is connected to an instance of armnetworkanalytics.DataTypesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDataTypesServerTransport(srv *DataTypesServer) *DataTypesServerTransport {
	return &DataTypesServerTransport{
		srv:                       srv,
		beginCreate:               newTracker[azfake.PollerResponder[armnetworkanalytics.DataTypesClientCreateResponse]](),
		beginDelete:               newTracker[azfake.PollerResponder[armnetworkanalytics.DataTypesClientDeleteResponse]](),
		beginDeleteData:           newTracker[azfake.PollerResponder[armnetworkanalytics.DataTypesClientDeleteDataResponse]](),
		newListByDataProductPager: newTracker[azfake.PagerResponder[armnetworkanalytics.DataTypesClientListByDataProductResponse]](),
		beginUpdate:               newTracker[azfake.PollerResponder[armnetworkanalytics.DataTypesClientUpdateResponse]](),
	}
}

// DataTypesServerTransport connects instances of armnetworkanalytics.DataTypesClient to instances of DataTypesServer.
// Don't use this type directly, use NewDataTypesServerTransport instead.
type DataTypesServerTransport struct {
	srv                       *DataTypesServer
	beginCreate               *tracker[azfake.PollerResponder[armnetworkanalytics.DataTypesClientCreateResponse]]
	beginDelete               *tracker[azfake.PollerResponder[armnetworkanalytics.DataTypesClientDeleteResponse]]
	beginDeleteData           *tracker[azfake.PollerResponder[armnetworkanalytics.DataTypesClientDeleteDataResponse]]
	newListByDataProductPager *tracker[azfake.PagerResponder[armnetworkanalytics.DataTypesClientListByDataProductResponse]]
	beginUpdate               *tracker[azfake.PollerResponder[armnetworkanalytics.DataTypesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for DataTypesServerTransport.
func (d *DataTypesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DataTypesClient.BeginCreate":
		resp, err = d.dispatchBeginCreate(req)
	case "DataTypesClient.BeginDelete":
		resp, err = d.dispatchBeginDelete(req)
	case "DataTypesClient.BeginDeleteData":
		resp, err = d.dispatchBeginDeleteData(req)
	case "DataTypesClient.GenerateStorageContainerSasToken":
		resp, err = d.dispatchGenerateStorageContainerSasToken(req)
	case "DataTypesClient.Get":
		resp, err = d.dispatchGet(req)
	case "DataTypesClient.NewListByDataProductPager":
		resp, err = d.dispatchNewListByDataProductPager(req)
	case "DataTypesClient.BeginUpdate":
		resp, err = d.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DataTypesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := d.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkAnalytics/dataProducts/(?P<dataProductName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataTypes/(?P<dataTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkanalytics.DataType](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataProductNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataProductName")])
		if err != nil {
			return nil, err
		}
		dataTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataTypeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreate(req.Context(), resourceGroupNameParam, dataProductNameParam, dataTypeNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		d.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		d.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		d.beginCreate.remove(req)
	}

	return resp, nil
}

func (d *DataTypesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := d.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkAnalytics/dataProducts/(?P<dataProductName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataTypes/(?P<dataTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataProductNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataProductName")])
		if err != nil {
			return nil, err
		}
		dataTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataTypeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDelete(req.Context(), resourceGroupNameParam, dataProductNameParam, dataTypeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		d.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		d.beginDelete.remove(req)
	}

	return resp, nil
}

func (d *DataTypesServerTransport) dispatchBeginDeleteData(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDeleteData == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteData not implemented")}
	}
	beginDeleteData := d.beginDeleteData.get(req)
	if beginDeleteData == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkAnalytics/dataProducts/(?P<dataProductName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataTypes/(?P<dataTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deleteData`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[any](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataProductNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataProductName")])
		if err != nil {
			return nil, err
		}
		dataTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataTypeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDeleteData(req.Context(), resourceGroupNameParam, dataProductNameParam, dataTypeNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteData = &respr
		d.beginDeleteData.add(req, beginDeleteData)
	}

	resp, err := server.PollerResponderNext(beginDeleteData, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDeleteData.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteData) {
		d.beginDeleteData.remove(req)
	}

	return resp, nil
}

func (d *DataTypesServerTransport) dispatchGenerateStorageContainerSasToken(req *http.Request) (*http.Response, error) {
	if d.srv.GenerateStorageContainerSasToken == nil {
		return nil, &nonRetriableError{errors.New("fake for method GenerateStorageContainerSasToken not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkAnalytics/dataProducts/(?P<dataProductName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataTypes/(?P<dataTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateStorageContainerSasToken`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetworkanalytics.ContainerSaS](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dataProductNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataProductName")])
	if err != nil {
		return nil, err
	}
	dataTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataTypeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GenerateStorageContainerSasToken(req.Context(), resourceGroupNameParam, dataProductNameParam, dataTypeNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ContainerSasToken, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataTypesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkAnalytics/dataProducts/(?P<dataProductName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataTypes/(?P<dataTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dataProductNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataProductName")])
	if err != nil {
		return nil, err
	}
	dataTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataTypeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, dataProductNameParam, dataTypeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataType, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataTypesServerTransport) dispatchNewListByDataProductPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByDataProductPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDataProductPager not implemented")}
	}
	newListByDataProductPager := d.newListByDataProductPager.get(req)
	if newListByDataProductPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkAnalytics/dataProducts/(?P<dataProductName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataTypes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataProductNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataProductName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByDataProductPager(resourceGroupNameParam, dataProductNameParam, nil)
		newListByDataProductPager = &resp
		d.newListByDataProductPager.add(req, newListByDataProductPager)
		server.PagerResponderInjectNextLinks(newListByDataProductPager, req, func(page *armnetworkanalytics.DataTypesClientListByDataProductResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDataProductPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByDataProductPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDataProductPager) {
		d.newListByDataProductPager.remove(req)
	}
	return resp, nil
}

func (d *DataTypesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := d.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkAnalytics/dataProducts/(?P<dataProductName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataTypes/(?P<dataTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkanalytics.DataTypeUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataProductNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataProductName")])
		if err != nil {
			return nil, err
		}
		dataTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataTypeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginUpdate(req.Context(), resourceGroupNameParam, dataProductNameParam, dataTypeNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		d.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		d.beginUpdate.remove(req)
	}

	return resp, nil
}
