//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/paloaltonetworksngfw/armpanngfw"
	"net/http"
	"net/url"
	"regexp"
)

// CertificateObjectGlobalRulestackServer is a fake server for instances of the armpanngfw.CertificateObjectGlobalRulestackClient type.
type CertificateObjectGlobalRulestackServer struct {
	// BeginCreateOrUpdate is the fake for method CertificateObjectGlobalRulestackClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, globalRulestackName string, name string, resource armpanngfw.CertificateObjectGlobalRulestackResource, options *armpanngfw.CertificateObjectGlobalRulestackClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armpanngfw.CertificateObjectGlobalRulestackClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method CertificateObjectGlobalRulestackClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, globalRulestackName string, name string, options *armpanngfw.CertificateObjectGlobalRulestackClientBeginDeleteOptions) (resp azfake.PollerResponder[armpanngfw.CertificateObjectGlobalRulestackClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method CertificateObjectGlobalRulestackClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, globalRulestackName string, name string, options *armpanngfw.CertificateObjectGlobalRulestackClientGetOptions) (resp azfake.Responder[armpanngfw.CertificateObjectGlobalRulestackClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method CertificateObjectGlobalRulestackClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(globalRulestackName string, options *armpanngfw.CertificateObjectGlobalRulestackClientListOptions) (resp azfake.PagerResponder[armpanngfw.CertificateObjectGlobalRulestackClientListResponse])
}

// NewCertificateObjectGlobalRulestackServerTransport creates a new instance of CertificateObjectGlobalRulestackServerTransport with the provided implementation.
// The returned CertificateObjectGlobalRulestackServerTransport instance is connected to an instance of armpanngfw.CertificateObjectGlobalRulestackClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCertificateObjectGlobalRulestackServerTransport(srv *CertificateObjectGlobalRulestackServer) *CertificateObjectGlobalRulestackServerTransport {
	return &CertificateObjectGlobalRulestackServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armpanngfw.CertificateObjectGlobalRulestackClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armpanngfw.CertificateObjectGlobalRulestackClientDeleteResponse]](),
		newListPager:        newTracker[azfake.PagerResponder[armpanngfw.CertificateObjectGlobalRulestackClientListResponse]](),
	}
}

// CertificateObjectGlobalRulestackServerTransport connects instances of armpanngfw.CertificateObjectGlobalRulestackClient to instances of CertificateObjectGlobalRulestackServer.
// Don't use this type directly, use NewCertificateObjectGlobalRulestackServerTransport instead.
type CertificateObjectGlobalRulestackServerTransport struct {
	srv                 *CertificateObjectGlobalRulestackServer
	beginCreateOrUpdate *tracker[azfake.PollerResponder[armpanngfw.CertificateObjectGlobalRulestackClientCreateOrUpdateResponse]]
	beginDelete         *tracker[azfake.PollerResponder[armpanngfw.CertificateObjectGlobalRulestackClientDeleteResponse]]
	newListPager        *tracker[azfake.PagerResponder[armpanngfw.CertificateObjectGlobalRulestackClientListResponse]]
}

// Do implements the policy.Transporter interface for CertificateObjectGlobalRulestackServerTransport.
func (c *CertificateObjectGlobalRulestackServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CertificateObjectGlobalRulestackClient.BeginCreateOrUpdate":
		resp, err = c.dispatchBeginCreateOrUpdate(req)
	case "CertificateObjectGlobalRulestackClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "CertificateObjectGlobalRulestackClient.Get":
		resp, err = c.dispatchGet(req)
	case "CertificateObjectGlobalRulestackClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CertificateObjectGlobalRulestackServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := c.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armpanngfw.CertificateObjectGlobalRulestackResource](req)
		if err != nil {
			return nil, err
		}
		globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateOrUpdate(req.Context(), globalRulestackNameParam, nameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		c.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		c.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (c *CertificateObjectGlobalRulestackServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
		if err != nil {
			return nil, err
		}
		nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), globalRulestackNameParam, nameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *CertificateObjectGlobalRulestackServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
	if err != nil {
		return nil, err
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), globalRulestackNameParam, nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CertificateObjectGlobalRulestackResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CertificateObjectGlobalRulestackServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/providers/PaloAltoNetworks\.Cloudngfw/globalRulestacks/(?P<globalRulestackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/certificates`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		globalRulestackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("globalRulestackName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListPager(globalRulestackNameParam, nil)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armpanngfw.CertificateObjectGlobalRulestackClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}
