//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpostgresqlhsc_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/postgresqlhsc/armpostgresqlhsc"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupList.json
func ExampleServerGroupsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServerGroupsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServerGroupListResult = armpostgresqlhsc.ServerGroupListResult{
		// 	Value: []*armpostgresqlhsc.ServerGroup{
		// 		{
		// 			Name: to.Ptr("hsctestsg1"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg1"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"additionalProp1": to.Ptr("string"),
		// 			},
		// 			Properties: &armpostgresqlhsc.ServerGroupProperties{
		// 				AdministratorLogin: to.Ptr("citus"),
		// 				AvailabilityZone: to.Ptr("1"),
		// 				CitusVersion: to.Ptr(armpostgresqlhsc.CitusVersionNine5),
		// 				DelegatedSubnetArguments: &armpostgresqlhsc.ServerGroupPropertiesDelegatedSubnetArguments{
		// 					SubnetArmResourceID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet"),
		// 				},
		// 				EarliestRestoreTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-09-14T00:00:37.467Z"); return t}()),
		// 				EnableMx: to.Ptr(true),
		// 				EnableZfs: to.Ptr(false),
		// 				PostgresqlVersion: to.Ptr(armpostgresqlhsc.PostgreSQLVersionTwelve),
		// 				PrivateDNSZoneArguments: &armpostgresqlhsc.ServerGroupPropertiesPrivateDNSZoneArguments{
		// 					PrivateDNSZoneArmResourceID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone"),
		// 				},
		// 				ReadReplicas: []*string{
		// 					to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg2")},
		// 					ResourceProviderType: to.Ptr(armpostgresqlhsc.ResourceProviderTypeMeru),
		// 					ServerRoleGroups: []*armpostgresqlhsc.ServerRoleGroup{
		// 						{
		// 							EnableHa: to.Ptr(true),
		// 							EnablePublicIP: to.Ptr(true),
		// 							ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionMemoryOptimized),
		// 							StorageQuotaInMb: to.Ptr[int64](10000),
		// 							VCores: to.Ptr[int64](4),
		// 							Name: to.Ptr(""),
		// 							Role: to.Ptr(armpostgresqlhsc.ServerRoleCoordinator),
		// 							ServerCount: to.Ptr[int32](1),
		// 							ServerNames: []*armpostgresqlhsc.ServerNameItem{
		// 								{
		// 									Name: to.Ptr("hsctestsg1-c"),
		// 									FullyQualifiedDomainName: to.Ptr("hsctestsg1-c.postgres.database.azure.com"),
		// 							}},
		// 						},
		// 						{
		// 							EnableHa: to.Ptr(false),
		// 							EnablePublicIP: to.Ptr(false),
		// 							ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionGeneralPurpose),
		// 							StorageQuotaInMb: to.Ptr[int64](10000),
		// 							VCores: to.Ptr[int64](8),
		// 							Name: to.Ptr(""),
		// 							Role: to.Ptr(armpostgresqlhsc.ServerRoleWorker),
		// 							ServerCount: to.Ptr[int32](3),
		// 							ServerNames: []*armpostgresqlhsc.ServerNameItem{
		// 								{
		// 									Name: to.Ptr("hsctestsg1-w0"),
		// 									FullyQualifiedDomainName: to.Ptr("hsctestsg1-w0.postgres.database.azure.com"),
		// 								},
		// 								{
		// 									Name: to.Ptr("hsctestsg1-w1"),
		// 									FullyQualifiedDomainName: to.Ptr("hsctestsg1-w1.postgres.database.azure.com"),
		// 								},
		// 								{
		// 									Name: to.Ptr("hsctestsg1-w2"),
		// 									FullyQualifiedDomainName: to.Ptr("hsctestsg1-w2.postgres.database.azure.com"),
		// 							}},
		// 					}},
		// 					StandbyAvailabilityZone: to.Ptr("2"),
		// 					State: to.Ptr(armpostgresqlhsc.ServerStateReady),
		// 				},
		// 				SystemData: &armpostgresqlhsc.SystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
		// 					CreatedBy: to.Ptr("user1"),
		// 					CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
		// 					LastModifiedBy: to.Ptr("user2"),
		// 					LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("hsctestsg2"),
		// 				Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
		// 				ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg2"),
		// 				Location: to.Ptr("eastus"),
		// 				Tags: map[string]*string{
		// 					"additionalProp2": to.Ptr("string"),
		// 				},
		// 				Properties: &armpostgresqlhsc.ServerGroupProperties{
		// 					AdministratorLogin: to.Ptr("citus"),
		// 					AvailabilityZone: to.Ptr("1"),
		// 					CitusVersion: to.Ptr(armpostgresqlhsc.CitusVersionNine5),
		// 					EarliestRestoreTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-09-14T00:00:37.467Z"); return t}()),
		// 					EnableMx: to.Ptr(true),
		// 					EnableZfs: to.Ptr(false),
		// 					PostgresqlVersion: to.Ptr(armpostgresqlhsc.PostgreSQLVersionTwelve),
		// 					ResourceProviderType: to.Ptr(armpostgresqlhsc.ResourceProviderTypeMeru),
		// 					ServerRoleGroups: []*armpostgresqlhsc.ServerRoleGroup{
		// 						{
		// 							EnableHa: to.Ptr(true),
		// 							EnablePublicIP: to.Ptr(true),
		// 							ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionMemoryOptimized),
		// 							StorageQuotaInMb: to.Ptr[int64](10000),
		// 							VCores: to.Ptr[int64](8),
		// 							Name: to.Ptr(""),
		// 							Role: to.Ptr(armpostgresqlhsc.ServerRoleCoordinator),
		// 							ServerCount: to.Ptr[int32](1),
		// 							ServerNames: []*armpostgresqlhsc.ServerNameItem{
		// 								{
		// 									Name: to.Ptr("hsctestsg2-c"),
		// 									FullyQualifiedDomainName: to.Ptr("hsctestsg2-c.postgres.database.azure.com"),
		// 							}},
		// 						},
		// 						{
		// 							EnableHa: to.Ptr(false),
		// 							EnablePublicIP: to.Ptr(false),
		// 							ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionGeneralPurpose),
		// 							StorageQuotaInMb: to.Ptr[int64](10000),
		// 							VCores: to.Ptr[int64](4),
		// 							Name: to.Ptr(""),
		// 							Role: to.Ptr(armpostgresqlhsc.ServerRoleWorker),
		// 							ServerCount: to.Ptr[int32](2),
		// 							ServerNames: []*armpostgresqlhsc.ServerNameItem{
		// 								{
		// 									Name: to.Ptr("hsctestsg2-w0"),
		// 									FullyQualifiedDomainName: to.Ptr("hsctestsg2-w0.postgres.database.azure.com"),
		// 								},
		// 								{
		// 									Name: to.Ptr("hsctestsg2-w1"),
		// 									FullyQualifiedDomainName: to.Ptr("hsctestsg2-w1.postgres.database.azure.com"),
		// 							}},
		// 					}},
		// 					SourceServerGroup: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg1"),
		// 					StandbyAvailabilityZone: to.Ptr("2"),
		// 					State: to.Ptr(armpostgresqlhsc.ServerStateReady),
		// 				},
		// 				SystemData: &armpostgresqlhsc.SystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
		// 					CreatedBy: to.Ptr("user1"),
		// 					CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
		// 					LastModifiedBy: to.Ptr("user2"),
		// 					LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("hsctestsg3"),
		// 				Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
		// 				ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg3"),
		// 				Location: to.Ptr("eastus"),
		// 				Tags: map[string]*string{
		// 					"additionalProp3": to.Ptr("string"),
		// 				},
		// 				Properties: &armpostgresqlhsc.ServerGroupProperties{
		// 					AdministratorLogin: to.Ptr("citus"),
		// 					AvailabilityZone: to.Ptr("1"),
		// 					CitusVersion: to.Ptr(armpostgresqlhsc.CitusVersionNine5),
		// 					DelegatedSubnetArguments: &armpostgresqlhsc.ServerGroupPropertiesDelegatedSubnetArguments{
		// 						SubnetArmResourceID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet"),
		// 					},
		// 					EarliestRestoreTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-09-14T00:00:37.467Z"); return t}()),
		// 					EnableMx: to.Ptr(true),
		// 					EnableZfs: to.Ptr(false),
		// 					PostgresqlVersion: to.Ptr(armpostgresqlhsc.PostgreSQLVersionTwelve),
		// 					PrivateDNSZoneArguments: &armpostgresqlhsc.ServerGroupPropertiesPrivateDNSZoneArguments{
		// 						PrivateDNSZoneArmResourceID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone"),
		// 					},
		// 					ResourceProviderType: to.Ptr(armpostgresqlhsc.ResourceProviderTypeMeru),
		// 					ServerRoleGroups: []*armpostgresqlhsc.ServerRoleGroup{
		// 						{
		// 							EnableHa: to.Ptr(true),
		// 							EnablePublicIP: to.Ptr(true),
		// 							ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionMemoryOptimized),
		// 							StorageQuotaInMb: to.Ptr[int64](10000),
		// 							VCores: to.Ptr[int64](4),
		// 							Name: to.Ptr(""),
		// 							Role: to.Ptr(armpostgresqlhsc.ServerRoleCoordinator),
		// 							ServerCount: to.Ptr[int32](1),
		// 							ServerNames: []*armpostgresqlhsc.ServerNameItem{
		// 								{
		// 									Name: to.Ptr("hsctestsg3-c"),
		// 									FullyQualifiedDomainName: to.Ptr("hsctestsg3-c.postgres.database.azure.com"),
		// 							}},
		// 						},
		// 						{
		// 							EnableHa: to.Ptr(false),
		// 							EnablePublicIP: to.Ptr(false),
		// 							ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionGeneralPurpose),
		// 							StorageQuotaInMb: to.Ptr[int64](10000),
		// 							VCores: to.Ptr[int64](8),
		// 							Name: to.Ptr(""),
		// 							Role: to.Ptr(armpostgresqlhsc.ServerRoleWorker),
		// 							ServerCount: to.Ptr[int32](3),
		// 							ServerNames: []*armpostgresqlhsc.ServerNameItem{
		// 								{
		// 									Name: to.Ptr("hsctestsg3-w0"),
		// 									FullyQualifiedDomainName: to.Ptr("hsctestsg3-w0.postgres.database.azure.com"),
		// 								},
		// 								{
		// 									Name: to.Ptr("hsctestsg3-w1"),
		// 									FullyQualifiedDomainName: to.Ptr("hsctestsg3-w1.postgres.database.azure.com"),
		// 								},
		// 								{
		// 									Name: to.Ptr("hsctestsg3-w2"),
		// 									FullyQualifiedDomainName: to.Ptr("hsctestsg3-w2.postgres.database.azure.com"),
		// 							}},
		// 					}},
		// 					StandbyAvailabilityZone: to.Ptr("2"),
		// 					State: to.Ptr(armpostgresqlhsc.ServerStateReady),
		// 				},
		// 				SystemData: &armpostgresqlhsc.SystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
		// 					CreatedBy: to.Ptr("user1"),
		// 					CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
		// 					LastModifiedBy: to.Ptr("user2"),
		// 					LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupListByResourceGroup.json
func ExampleServerGroupsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServerGroupsClient().NewListByResourceGroupPager("TestGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServerGroupListResult = armpostgresqlhsc.ServerGroupListResult{
		// 	Value: []*armpostgresqlhsc.ServerGroup{
		// 		{
		// 			Name: to.Ptr("hsctestsg1"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg1"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"additionalProp1": to.Ptr("string"),
		// 			},
		// 			Properties: &armpostgresqlhsc.ServerGroupProperties{
		// 				AdministratorLogin: to.Ptr("citus"),
		// 				AvailabilityZone: to.Ptr("1"),
		// 				CitusVersion: to.Ptr(armpostgresqlhsc.CitusVersionNine5),
		// 				DelegatedSubnetArguments: &armpostgresqlhsc.ServerGroupPropertiesDelegatedSubnetArguments{
		// 					SubnetArmResourceID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet"),
		// 				},
		// 				EarliestRestoreTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-09-14T00:00:37.467Z"); return t}()),
		// 				EnableMx: to.Ptr(true),
		// 				EnableZfs: to.Ptr(false),
		// 				PostgresqlVersion: to.Ptr(armpostgresqlhsc.PostgreSQLVersionTwelve),
		// 				PrivateDNSZoneArguments: &armpostgresqlhsc.ServerGroupPropertiesPrivateDNSZoneArguments{
		// 					PrivateDNSZoneArmResourceID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone"),
		// 				},
		// 				ResourceProviderType: to.Ptr(armpostgresqlhsc.ResourceProviderTypeMeru),
		// 				ServerRoleGroups: []*armpostgresqlhsc.ServerRoleGroup{
		// 					{
		// 						EnableHa: to.Ptr(true),
		// 						EnablePublicIP: to.Ptr(true),
		// 						ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionMemoryOptimized),
		// 						StorageQuotaInMb: to.Ptr[int64](10000),
		// 						VCores: to.Ptr[int64](4),
		// 						Name: to.Ptr(""),
		// 						Role: to.Ptr(armpostgresqlhsc.ServerRoleCoordinator),
		// 						ServerCount: to.Ptr[int32](1),
		// 						ServerNames: []*armpostgresqlhsc.ServerNameItem{
		// 							{
		// 								Name: to.Ptr("hsctestsg1-c"),
		// 								FullyQualifiedDomainName: to.Ptr("hsctestsg1-c.postgres.database.azure.com"),
		// 						}},
		// 					},
		// 					{
		// 						EnableHa: to.Ptr(false),
		// 						EnablePublicIP: to.Ptr(false),
		// 						ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionGeneralPurpose),
		// 						StorageQuotaInMb: to.Ptr[int64](10000),
		// 						VCores: to.Ptr[int64](8),
		// 						Name: to.Ptr(""),
		// 						Role: to.Ptr(armpostgresqlhsc.ServerRoleWorker),
		// 						ServerCount: to.Ptr[int32](3),
		// 						ServerNames: []*armpostgresqlhsc.ServerNameItem{
		// 							{
		// 								Name: to.Ptr("hsctestsg1-w0"),
		// 								FullyQualifiedDomainName: to.Ptr("hsctestsg1-w0.postgres.database.azure.com"),
		// 							},
		// 							{
		// 								Name: to.Ptr("hsctestsg1-w1"),
		// 								FullyQualifiedDomainName: to.Ptr("hsctestsg1-w1.postgres.database.azure.com"),
		// 							},
		// 							{
		// 								Name: to.Ptr("hsctestsg1-w2"),
		// 								FullyQualifiedDomainName: to.Ptr("hsctestsg1-w2.postgres.database.azure.com"),
		// 						}},
		// 				}},
		// 				StandbyAvailabilityZone: to.Ptr("2"),
		// 				State: to.Ptr(armpostgresqlhsc.ServerStateReady),
		// 			},
		// 			SystemData: &armpostgresqlhsc.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("hsctestsg2"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg2"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"additionalProp2": to.Ptr("string"),
		// 			},
		// 			Properties: &armpostgresqlhsc.ServerGroupProperties{
		// 				AdministratorLogin: to.Ptr("citus"),
		// 				AvailabilityZone: to.Ptr("1"),
		// 				CitusVersion: to.Ptr(armpostgresqlhsc.CitusVersionNine5),
		// 				EarliestRestoreTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-09-14T00:00:37.467Z"); return t}()),
		// 				EnableMx: to.Ptr(true),
		// 				EnableZfs: to.Ptr(false),
		// 				PostgresqlVersion: to.Ptr(armpostgresqlhsc.PostgreSQLVersionTwelve),
		// 				ResourceProviderType: to.Ptr(armpostgresqlhsc.ResourceProviderTypeMeru),
		// 				ServerRoleGroups: []*armpostgresqlhsc.ServerRoleGroup{
		// 					{
		// 						EnableHa: to.Ptr(true),
		// 						EnablePublicIP: to.Ptr(true),
		// 						ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionMemoryOptimized),
		// 						StorageQuotaInMb: to.Ptr[int64](10000),
		// 						VCores: to.Ptr[int64](8),
		// 						Name: to.Ptr(""),
		// 						Role: to.Ptr(armpostgresqlhsc.ServerRoleCoordinator),
		// 						ServerCount: to.Ptr[int32](1),
		// 						ServerNames: []*armpostgresqlhsc.ServerNameItem{
		// 							{
		// 								Name: to.Ptr("hsctestsg2-c"),
		// 								FullyQualifiedDomainName: to.Ptr("hsctestsg2-c.postgres.database.azure.com"),
		// 						}},
		// 					},
		// 					{
		// 						EnableHa: to.Ptr(false),
		// 						EnablePublicIP: to.Ptr(false),
		// 						ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionGeneralPurpose),
		// 						StorageQuotaInMb: to.Ptr[int64](10000),
		// 						VCores: to.Ptr[int64](4),
		// 						Name: to.Ptr(""),
		// 						Role: to.Ptr(armpostgresqlhsc.ServerRoleWorker),
		// 						ServerCount: to.Ptr[int32](2),
		// 						ServerNames: []*armpostgresqlhsc.ServerNameItem{
		// 							{
		// 								Name: to.Ptr("hsctestsg2-w0"),
		// 								FullyQualifiedDomainName: to.Ptr("hsctestsg2-w0.postgres.database.azure.com"),
		// 							},
		// 							{
		// 								Name: to.Ptr("hsctestsg2-w1"),
		// 								FullyQualifiedDomainName: to.Ptr("hsctestsg2-w1.postgres.database.azure.com"),
		// 						}},
		// 				}},
		// 				StandbyAvailabilityZone: to.Ptr("2"),
		// 				State: to.Ptr(armpostgresqlhsc.ServerStateReady),
		// 			},
		// 			SystemData: &armpostgresqlhsc.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("hsctestsg3"),
		// 			Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
		// 			ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg3"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"additionalProp3": to.Ptr("string"),
		// 			},
		// 			Properties: &armpostgresqlhsc.ServerGroupProperties{
		// 				AdministratorLogin: to.Ptr("citus"),
		// 				AvailabilityZone: to.Ptr("1"),
		// 				CitusVersion: to.Ptr(armpostgresqlhsc.CitusVersionNine5),
		// 				DelegatedSubnetArguments: &armpostgresqlhsc.ServerGroupPropertiesDelegatedSubnetArguments{
		// 					SubnetArmResourceID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet"),
		// 				},
		// 				EarliestRestoreTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-09-14T00:00:37.467Z"); return t}()),
		// 				EnableMx: to.Ptr(true),
		// 				EnableZfs: to.Ptr(false),
		// 				PostgresqlVersion: to.Ptr(armpostgresqlhsc.PostgreSQLVersionTwelve),
		// 				PrivateDNSZoneArguments: &armpostgresqlhsc.ServerGroupPropertiesPrivateDNSZoneArguments{
		// 					PrivateDNSZoneArmResourceID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone"),
		// 				},
		// 				ResourceProviderType: to.Ptr(armpostgresqlhsc.ResourceProviderTypeMeru),
		// 				ServerRoleGroups: []*armpostgresqlhsc.ServerRoleGroup{
		// 					{
		// 						EnableHa: to.Ptr(true),
		// 						EnablePublicIP: to.Ptr(true),
		// 						ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionMemoryOptimized),
		// 						StorageQuotaInMb: to.Ptr[int64](10000),
		// 						VCores: to.Ptr[int64](4),
		// 						Name: to.Ptr(""),
		// 						Role: to.Ptr(armpostgresqlhsc.ServerRoleCoordinator),
		// 						ServerCount: to.Ptr[int32](1),
		// 						ServerNames: []*armpostgresqlhsc.ServerNameItem{
		// 							{
		// 								Name: to.Ptr("hsctestsg3-c"),
		// 								FullyQualifiedDomainName: to.Ptr("hsctestsg3-c.postgres.database.azure.com"),
		// 						}},
		// 					},
		// 					{
		// 						EnableHa: to.Ptr(false),
		// 						EnablePublicIP: to.Ptr(false),
		// 						ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionGeneralPurpose),
		// 						StorageQuotaInMb: to.Ptr[int64](10000),
		// 						VCores: to.Ptr[int64](8),
		// 						Name: to.Ptr(""),
		// 						Role: to.Ptr(armpostgresqlhsc.ServerRoleWorker),
		// 						ServerCount: to.Ptr[int32](3),
		// 						ServerNames: []*armpostgresqlhsc.ServerNameItem{
		// 							{
		// 								Name: to.Ptr("hsctestsg3-w0"),
		// 								FullyQualifiedDomainName: to.Ptr("hsctestsg3-w0.postgres.database.azure.com"),
		// 							},
		// 							{
		// 								Name: to.Ptr("hsctestsg3-w1"),
		// 								FullyQualifiedDomainName: to.Ptr("hsctestsg3-w1.postgres.database.azure.com"),
		// 							},
		// 							{
		// 								Name: to.Ptr("hsctestsg3-w2"),
		// 								FullyQualifiedDomainName: to.Ptr("hsctestsg3-w2.postgres.database.azure.com"),
		// 						}},
		// 				}},
		// 				StandbyAvailabilityZone: to.Ptr("2"),
		// 				State: to.Ptr(armpostgresqlhsc.ServerStateReady),
		// 			},
		// 			SystemData: &armpostgresqlhsc.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
		// 				CreatedBy: to.Ptr("user1"),
		// 				CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user2"),
		// 				LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupCreate.json
func ExampleServerGroupsClient_BeginCreateOrUpdate_createANewServerGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServerGroupsClient().BeginCreateOrUpdate(ctx, "TestGroup", "hsctestsg", armpostgresqlhsc.ServerGroup{
		Location: to.Ptr("westus"),
		Tags: map[string]*string{
			"ElasticServer": to.Ptr("1"),
		},
		Properties: &armpostgresqlhsc.ServerGroupProperties{
			AdministratorLogin:         to.Ptr("citus"),
			AdministratorLoginPassword: to.Ptr("password"),
			AvailabilityZone:           to.Ptr("1"),
			BackupRetentionDays:        to.Ptr[int32](35),
			CitusVersion:               to.Ptr(armpostgresqlhsc.CitusVersionNine5),
			DelegatedSubnetArguments: &armpostgresqlhsc.ServerGroupPropertiesDelegatedSubnetArguments{
				SubnetArmResourceID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet"),
			},
			EnableMx:          to.Ptr(true),
			EnableZfs:         to.Ptr(false),
			PostgresqlVersion: to.Ptr(armpostgresqlhsc.PostgreSQLVersionTwelve),
			PrivateDNSZoneArguments: &armpostgresqlhsc.ServerGroupPropertiesPrivateDNSZoneArguments{
				PrivateDNSZoneArmResourceID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone"),
			},
			ServerRoleGroups: []*armpostgresqlhsc.ServerRoleGroup{
				{
					EnableHa:         to.Ptr(true),
					ServerEdition:    to.Ptr(armpostgresqlhsc.ServerEditionGeneralPurpose),
					StorageQuotaInMb: to.Ptr[int64](524288),
					VCores:           to.Ptr[int64](4),
					Name:             to.Ptr(""),
					Role:             to.Ptr(armpostgresqlhsc.ServerRoleCoordinator),
					ServerCount:      to.Ptr[int32](1),
				},
				{
					EnableHa:         to.Ptr(false),
					ServerEdition:    to.Ptr(armpostgresqlhsc.ServerEditionMemoryOptimized),
					StorageQuotaInMb: to.Ptr[int64](524288),
					VCores:           to.Ptr[int64](4),
					Name:             to.Ptr(""),
					Role:             to.Ptr(armpostgresqlhsc.ServerRoleWorker),
					ServerCount:      to.Ptr[int32](3),
				}},
			StandbyAvailabilityZone: to.Ptr("2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerGroup = armpostgresqlhsc.ServerGroup{
	// 	Name: to.Ptr("hsctestsg"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg"),
	// 	Location: to.Ptr("westus2"),
	// 	Properties: &armpostgresqlhsc.ServerGroupProperties{
	// 	},
	// 	SystemData: &armpostgresqlhsc.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupCreatePITR.json
func ExampleServerGroupsClient_BeginCreateOrUpdate_createANewServerGroupAsAPointInTimeRestore() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServerGroupsClient().BeginCreateOrUpdate(ctx, "TestGroup", "hsctestsg", armpostgresqlhsc.ServerGroup{
		Location: to.Ptr("westus"),
		Properties: &armpostgresqlhsc.ServerGroupProperties{
			CreateMode:              to.Ptr(armpostgresqlhsc.CreateModePointInTimeRestore),
			EnableMx:                to.Ptr(true),
			EnableZfs:               to.Ptr(false),
			PointInTimeUTC:          to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-14T00:00:37.467Z"); return t }()),
			SourceLocation:          to.Ptr("eastus"),
			SourceResourceGroupName: to.Ptr("SourceGroup"),
			SourceServerGroupName:   to.Ptr("pgtests-source-server-group"),
			SourceSubscriptionID:    to.Ptr("dddddddd-dddd-dddd-dddd-dddddddddddd"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerGroup = armpostgresqlhsc.ServerGroup{
	// 	Name: to.Ptr("hsctestsg"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg"),
	// 	Location: to.Ptr("westus2"),
	// 	Properties: &armpostgresqlhsc.ServerGroupProperties{
	// 	},
	// 	SystemData: &armpostgresqlhsc.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupCreateReadReplica.json
func ExampleServerGroupsClient_BeginCreateOrUpdate_createANewServerGroupAsAReadReplica() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServerGroupsClient().BeginCreateOrUpdate(ctx, "TestGroup", "hsctestsg", armpostgresqlhsc.ServerGroup{
		Location: to.Ptr("westus"),
		Properties: &armpostgresqlhsc.ServerGroupProperties{
			CreateMode:              to.Ptr(armpostgresqlhsc.CreateModeReadReplica),
			SourceLocation:          to.Ptr("eastus"),
			SourceResourceGroupName: to.Ptr("SourceGroup"),
			SourceServerGroupName:   to.Ptr("pgtests-source-server-group"),
			SourceSubscriptionID:    to.Ptr("dddddddd-dddd-dddd-dddd-dddddddddddd"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerGroup = armpostgresqlhsc.ServerGroup{
	// 	Name: to.Ptr("hsctestsg"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg"),
	// 	Location: to.Ptr("westus2"),
	// 	Properties: &armpostgresqlhsc.ServerGroupProperties{
	// 	},
	// 	SystemData: &armpostgresqlhsc.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupGet.json
func ExampleServerGroupsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServerGroupsClient().Get(ctx, "TestGroup", "hsctestsg1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerGroup = armpostgresqlhsc.ServerGroup{
	// 	Name: to.Ptr("hsctestsg1"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg1"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"additionalProp1": to.Ptr("string"),
	// 		"additionalProp2": to.Ptr("string"),
	// 		"additionalProp3": to.Ptr("string"),
	// 	},
	// 	Properties: &armpostgresqlhsc.ServerGroupProperties{
	// 		AdministratorLogin: to.Ptr("citus"),
	// 		AvailabilityZone: to.Ptr("1"),
	// 		CitusVersion: to.Ptr(armpostgresqlhsc.CitusVersionNine5),
	// 		DelegatedSubnetArguments: &armpostgresqlhsc.ServerGroupPropertiesDelegatedSubnetArguments{
	// 			SubnetArmResourceID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/test-vnet-subnet"),
	// 		},
	// 		EarliestRestoreTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-09-14T00:00:37.467Z"); return t}()),
	// 		EnableMx: to.Ptr(true),
	// 		EnableZfs: to.Ptr(false),
	// 		MaintenanceWindow: &armpostgresqlhsc.MaintenanceWindow{
	// 			CustomWindow: to.Ptr("Disabled"),
	// 			DayOfWeek: to.Ptr[int32](0),
	// 			StartHour: to.Ptr[int32](0),
	// 			StartMinute: to.Ptr[int32](0),
	// 		},
	// 		PostgresqlVersion: to.Ptr(armpostgresqlhsc.PostgreSQLVersionTwelve),
	// 		PrivateDNSZoneArguments: &armpostgresqlhsc.ServerGroupPropertiesPrivateDNSZoneArguments{
	// 			PrivateDNSZoneArmResourceID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.Network/privateDnsZones/test-private-dns-zone"),
	// 		},
	// 		ReadReplicas: []*string{
	// 			to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSQL/serverGroupsv2/hsctestreadreplica-01"),
	// 			to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testrg/providers/Microsoft.DBForPostgreSQL/serverGroupsv2/hsctestreadreplica-02")},
	// 			ResourceProviderType: to.Ptr(armpostgresqlhsc.ResourceProviderTypeMeru),
	// 			ServerRoleGroups: []*armpostgresqlhsc.ServerRoleGroup{
	// 				{
	// 					EnableHa: to.Ptr(true),
	// 					EnablePublicIP: to.Ptr(true),
	// 					ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionMemoryOptimized),
	// 					StorageQuotaInMb: to.Ptr[int64](10000),
	// 					VCores: to.Ptr[int64](4),
	// 					Name: to.Ptr(""),
	// 					Role: to.Ptr(armpostgresqlhsc.ServerRoleCoordinator),
	// 					ServerCount: to.Ptr[int32](1),
	// 					ServerNames: []*armpostgresqlhsc.ServerNameItem{
	// 						{
	// 							Name: to.Ptr("hsctestsg1-c"),
	// 							FullyQualifiedDomainName: to.Ptr("hsctestsg1-c.postgres.database.azure.com"),
	// 					}},
	// 				},
	// 				{
	// 					EnableHa: to.Ptr(false),
	// 					EnablePublicIP: to.Ptr(false),
	// 					ServerEdition: to.Ptr(armpostgresqlhsc.ServerEditionGeneralPurpose),
	// 					StorageQuotaInMb: to.Ptr[int64](10000),
	// 					VCores: to.Ptr[int64](8),
	// 					Name: to.Ptr(""),
	// 					Role: to.Ptr(armpostgresqlhsc.ServerRoleWorker),
	// 					ServerCount: to.Ptr[int32](3),
	// 					ServerNames: []*armpostgresqlhsc.ServerNameItem{
	// 						{
	// 							Name: to.Ptr("hsctestsg1-w0"),
	// 							FullyQualifiedDomainName: to.Ptr("hsctestsg1-w0.postgres.database.azure.com"),
	// 						},
	// 						{
	// 							Name: to.Ptr("hsctestsg1-w1"),
	// 							FullyQualifiedDomainName: to.Ptr("hsctestsg1-w1.postgres.database.azure.com"),
	// 						},
	// 						{
	// 							Name: to.Ptr("hsctestsg1-w2"),
	// 							FullyQualifiedDomainName: to.Ptr("hsctestsg1-w2.postgres.database.azure.com"),
	// 					}},
	// 			}},
	// 			StandbyAvailabilityZone: to.Ptr("2"),
	// 			State: to.Ptr(armpostgresqlhsc.ServerStateReady),
	// 		},
	// 		SystemData: &armpostgresqlhsc.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
	// 			CreatedBy: to.Ptr("user1"),
	// 			CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("user2"),
	// 			LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupDelete.json
func ExampleServerGroupsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServerGroupsClient().BeginDelete(ctx, "TestGroup", "testservergroup", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupAddNode.json
func ExampleServerGroupsClient_BeginUpdate_addNewWorkerNodes() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServerGroupsClient().BeginUpdate(ctx, "TestGroup", "hsctestsg", armpostgresqlhsc.ServerGroupForUpdate{
		Location: to.Ptr("westus"),
		Properties: &armpostgresqlhsc.ServerGroupPropertiesForUpdate{
			ServerRoleGroups: []*armpostgresqlhsc.ServerRoleGroup{
				{
					Name:        to.Ptr(""),
					Role:        to.Ptr(armpostgresqlhsc.ServerRoleWorker),
					ServerCount: to.Ptr[int32](10),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerGroup = armpostgresqlhsc.ServerGroup{
	// 	Name: to.Ptr("hsctestsg"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg"),
	// 	Location: to.Ptr("westus2"),
	// 	Properties: &armpostgresqlhsc.ServerGroupProperties{
	// 	},
	// 	SystemData: &armpostgresqlhsc.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupScaleCompute.json
func ExampleServerGroupsClient_BeginUpdate_scaleCompute() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServerGroupsClient().BeginUpdate(ctx, "TestGroup", "hsctestsg", armpostgresqlhsc.ServerGroupForUpdate{
		Location: to.Ptr("westus"),
		Properties: &armpostgresqlhsc.ServerGroupPropertiesForUpdate{
			ServerRoleGroups: []*armpostgresqlhsc.ServerRoleGroup{
				{
					VCores: to.Ptr[int64](16),
					Name:   to.Ptr(""),
					Role:   to.Ptr(armpostgresqlhsc.ServerRoleCoordinator),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerGroup = armpostgresqlhsc.ServerGroup{
	// 	Name: to.Ptr("hsctestsg"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg"),
	// 	Location: to.Ptr("westus2"),
	// 	Properties: &armpostgresqlhsc.ServerGroupProperties{
	// 	},
	// 	SystemData: &armpostgresqlhsc.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupScaleStorage.json
func ExampleServerGroupsClient_BeginUpdate_scaleStorage() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServerGroupsClient().BeginUpdate(ctx, "TestGroup", "hsctestsg", armpostgresqlhsc.ServerGroupForUpdate{
		Location: to.Ptr("westus"),
		Properties: &armpostgresqlhsc.ServerGroupPropertiesForUpdate{
			ServerRoleGroups: []*armpostgresqlhsc.ServerRoleGroup{
				{
					StorageQuotaInMb: to.Ptr[int64](8388608),
					Name:             to.Ptr(""),
					Role:             to.Ptr(armpostgresqlhsc.ServerRoleWorker),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerGroup = armpostgresqlhsc.ServerGroup{
	// 	Name: to.Ptr("hsctestsg"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg"),
	// 	Location: to.Ptr("westus2"),
	// 	Properties: &armpostgresqlhsc.ServerGroupProperties{
	// 	},
	// 	SystemData: &armpostgresqlhsc.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupUpdateMaintenanceWindow.json
func ExampleServerGroupsClient_BeginUpdate_updateCustomerMaintenanceWindow() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServerGroupsClient().BeginUpdate(ctx, "TestGroup", "hsctestsg", armpostgresqlhsc.ServerGroupForUpdate{
		Properties: &armpostgresqlhsc.ServerGroupPropertiesForUpdate{
			MaintenanceWindow: &armpostgresqlhsc.MaintenanceWindow{
				CustomWindow: to.Ptr("Enabled"),
				DayOfWeek:    to.Ptr[int32](0),
				StartHour:    to.Ptr[int32](8),
				StartMinute:  to.Ptr[int32](0),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerGroup = armpostgresqlhsc.ServerGroup{
	// 	Name: to.Ptr("hsctestsg"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg"),
	// 	Location: to.Ptr("westus2"),
	// 	Properties: &armpostgresqlhsc.ServerGroupProperties{
	// 	},
	// 	SystemData: &armpostgresqlhsc.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupUpdate.json
func ExampleServerGroupsClient_BeginUpdate_updateTheServerGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServerGroupsClient().BeginUpdate(ctx, "TestGroup", "hsctestsg", armpostgresqlhsc.ServerGroupForUpdate{
		Properties: &armpostgresqlhsc.ServerGroupPropertiesForUpdate{
			AdministratorLoginPassword: to.Ptr("secret"),
			BackupRetentionDays:        to.Ptr[int32](30),
			PostgresqlVersion:          to.Ptr(armpostgresqlhsc.PostgreSQLVersionTwelve),
			ServerRoleGroups: []*armpostgresqlhsc.ServerRoleGroup{
				{
					EnableHa:         to.Ptr(false),
					ServerEdition:    to.Ptr(armpostgresqlhsc.ServerEditionGeneralPurpose),
					StorageQuotaInMb: to.Ptr[int64](1048576),
					VCores:           to.Ptr[int64](8),
					Name:             to.Ptr(""),
					Role:             to.Ptr(armpostgresqlhsc.ServerRoleCoordinator),
					ServerCount:      to.Ptr[int32](1),
				},
				{
					EnableHa:         to.Ptr(true),
					ServerEdition:    to.Ptr(armpostgresqlhsc.ServerEditionMemoryOptimized),
					StorageQuotaInMb: to.Ptr[int64](524288),
					VCores:           to.Ptr[int64](4),
					Name:             to.Ptr(""),
					Role:             to.Ptr(armpostgresqlhsc.ServerRoleWorker),
					ServerCount:      to.Ptr[int32](4),
				}},
		},
		Tags: map[string]*string{
			"ElasticServer": to.Ptr("2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerGroup = armpostgresqlhsc.ServerGroup{
	// 	Name: to.Ptr("hsctestsg"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
	// 	ID: to.Ptr("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/hsctestsg"),
	// 	Location: to.Ptr("westus2"),
	// 	Properties: &armpostgresqlhsc.ServerGroupProperties{
	// 	},
	// 	SystemData: &armpostgresqlhsc.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-01T17:18:19.1234567Z"); return t}()),
	// 		CreatedBy: to.Ptr("user1"),
	// 		CreatedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-01-02T17:18:19.1234567Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user2"),
	// 		LastModifiedByType: to.Ptr(armpostgresqlhsc.CreatedByTypeUser),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupRestart.json
func ExampleServerGroupsClient_BeginRestart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServerGroupsClient().BeginRestart(ctx, "TestGroup", "hsctestsg1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupStart.json
func ExampleServerGroupsClient_BeginStart() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServerGroupsClient().BeginStart(ctx, "TestGroup", "hsctestsg1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/ServerGroupStop.json
func ExampleServerGroupsClient_BeginStop() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewServerGroupsClient().BeginStop(ctx, "TestGroup", "hsctestsg1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/postgresqlhsc/resource-manager/Microsoft.DBforPostgreSQL/preview/2020-10-05-privatepreview/examples/CheckNameAvailability.json
func ExampleServerGroupsClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpostgresqlhsc.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServerGroupsClient().CheckNameAvailability(ctx, armpostgresqlhsc.NameAvailabilityRequest{
		Name: to.Ptr("name1"),
		Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NameAvailability = armpostgresqlhsc.NameAvailability{
	// 	Name: to.Ptr("name1"),
	// 	Type: to.Ptr("Microsoft.DBforPostgreSQL/serverGroupsv2"),
	// 	Message: to.Ptr(""),
	// 	NameAvailable: to.Ptr(true),
	// }
}
