//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/quantum/armquantum"
	"net/http"
	"net/url"
	"regexp"
)

// OfferingsServer is a fake server for instances of the armquantum.OfferingsClient type.
type OfferingsServer struct {
	// NewListPager is the fake for method OfferingsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(locationName string, options *armquantum.OfferingsClientListOptions) (resp azfake.PagerResponder[armquantum.OfferingsClientListResponse])
}

// NewOfferingsServerTransport creates a new instance of OfferingsServerTransport with the provided implementation.
// The returned OfferingsServerTransport instance is connected to an instance of armquantum.OfferingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewOfferingsServerTransport(srv *OfferingsServer) *OfferingsServerTransport {
	return &OfferingsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armquantum.OfferingsClientListResponse]](),
	}
}

// OfferingsServerTransport connects instances of armquantum.OfferingsClient to instances of OfferingsServer.
// Don't use this type directly, use NewOfferingsServerTransport instead.
type OfferingsServerTransport struct {
	srv          *OfferingsServer
	newListPager *tracker[azfake.PagerResponder[armquantum.OfferingsClientListResponse]]
}

// Do implements the policy.Transporter interface for OfferingsServerTransport.
func (o *OfferingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "OfferingsClient.NewListPager":
		resp, err = o.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (o *OfferingsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if o.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := o.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Quantum/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/offerings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		resp := o.srv.NewListPager(locationNameParam, nil)
		newListPager = &resp
		o.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armquantum.OfferingsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		o.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		o.newListPager.remove(req)
	}
	return resp, nil
}
