//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armrecoveryservicesbackup_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/AzureIaasVm/GetBackupStatus.json
func ExampleBackupStatusClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBackupStatusClient().Get(ctx, "southeastasia", armrecoveryservicesbackup.BackupStatusRequest{
		ResourceID:   to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRg/providers/Microsoft.Compute/VirtualMachines/testVm"),
		ResourceType: to.Ptr(armrecoveryservicesbackup.DataSourceTypeVM),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BackupStatusResponse = armrecoveryservicesbackup.BackupStatusResponse{
	// 	ContainerName: to.Ptr("iaasvmcontainer;iaasvmcontainerv2;testRg;testVm"),
	// 	ErrorCode: to.Ptr("Success"),
	// 	ErrorMessage: to.Ptr("ErrorMessage"),
	// 	FabricName: to.Ptr(armrecoveryservicesbackup.FabricNameAzure),
	// 	PolicyName: to.Ptr("myPolicy"),
	// 	ProtectedItemName: to.Ptr("vm;iaasvmcontainerv2;testRg;testVm"),
	// 	ProtectionStatus: to.Ptr(armrecoveryservicesbackup.ProtectionStatusProtected),
	// 	VaultID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRg/providers/Microsoft.RecoveryServices/Vaults/testVault"),
	// }
}
