//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup/v4"
	"net/http"
	"net/url"
	"regexp"
)

// ValidateOperationServer is a fake server for instances of the armrecoveryservicesbackup.ValidateOperationClient type.
type ValidateOperationServer struct {
	// BeginTrigger is the fake for method ValidateOperationClient.BeginTrigger
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginTrigger func(ctx context.Context, vaultName string, resourceGroupName string, parameters armrecoveryservicesbackup.ValidateOperationRequestResource, options *armrecoveryservicesbackup.ValidateOperationClientBeginTriggerOptions) (resp azfake.PollerResponder[armrecoveryservicesbackup.ValidateOperationClientTriggerResponse], errResp azfake.ErrorResponder)
}

// NewValidateOperationServerTransport creates a new instance of ValidateOperationServerTransport with the provided implementation.
// The returned ValidateOperationServerTransport instance is connected to an instance of armrecoveryservicesbackup.ValidateOperationClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewValidateOperationServerTransport(srv *ValidateOperationServer) *ValidateOperationServerTransport {
	return &ValidateOperationServerTransport{
		srv:          srv,
		beginTrigger: newTracker[azfake.PollerResponder[armrecoveryservicesbackup.ValidateOperationClientTriggerResponse]](),
	}
}

// ValidateOperationServerTransport connects instances of armrecoveryservicesbackup.ValidateOperationClient to instances of ValidateOperationServer.
// Don't use this type directly, use NewValidateOperationServerTransport instead.
type ValidateOperationServerTransport struct {
	srv          *ValidateOperationServer
	beginTrigger *tracker[azfake.PollerResponder[armrecoveryservicesbackup.ValidateOperationClientTriggerResponse]]
}

// Do implements the policy.Transporter interface for ValidateOperationServerTransport.
func (v *ValidateOperationServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ValidateOperationClient.BeginTrigger":
		resp, err = v.dispatchBeginTrigger(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *ValidateOperationServerTransport) dispatchBeginTrigger(req *http.Request) (*http.Response, error) {
	if v.srv.BeginTrigger == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTrigger not implemented")}
	}
	beginTrigger := v.beginTrigger.get(req)
	if beginTrigger == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupTriggerValidateOperation`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicesbackup.ValidateOperationRequestResource](req)
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginTrigger(req.Context(), vaultNameParam, resourceGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTrigger = &respr
		v.beginTrigger.add(req, beginTrigger)
	}

	resp, err := server.PollerResponderNext(beginTrigger, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		v.beginTrigger.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTrigger) {
		v.beginTrigger.remove(req)
	}

	return resp, nil
}
