//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicesbackup

import "time"

// AzureBackupGoalFeatureSupportRequest - Azure backup goal feature specific request.
type AzureBackupGoalFeatureSupportRequest struct {
	// REQUIRED; backup support feature type.
	FeatureType *string
}

// GetFeatureSupportRequest implements the FeatureSupportRequestClassification interface for type AzureBackupGoalFeatureSupportRequest.
func (a *AzureBackupGoalFeatureSupportRequest) GetFeatureSupportRequest() *FeatureSupportRequest {
	return &FeatureSupportRequest{
		FeatureType: a.FeatureType,
	}
}

// AzureBackupServerContainer - AzureBackupServer (DPMVenus) workload-specific protection container.
type AzureBackupServerContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Specifies whether the container is re-registrable.
	CanReRegister *bool

	// ID of container.
	ContainerID *string

	// Backup engine Agent version
	DpmAgentVersion *string

	// List of BackupEngines protecting the container
	DpmServers []*string

	// Extended Info of the container.
	ExtendedInfo *DPMContainerExtendedInfo

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string

	// Type of the protectable object associated with this container
	ProtectableObjectType *string

	// Number of protected items in the BackupEngine
	ProtectedItemCount *int64

	// Protection status of the container.
	ProtectionStatus *string

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string

	// To check if upgrade available
	UpgradeAvailable *bool
}

// GetDpmContainer implements the DpmContainerClassification interface for type AzureBackupServerContainer.
func (a *AzureBackupServerContainer) GetDpmContainer() *DpmContainer {
	return &DpmContainer{
		BackupManagementType:  a.BackupManagementType,
		CanReRegister:         a.CanReRegister,
		ContainerID:           a.ContainerID,
		ContainerType:         a.ContainerType,
		DpmAgentVersion:       a.DpmAgentVersion,
		DpmServers:            a.DpmServers,
		ExtendedInfo:          a.ExtendedInfo,
		FriendlyName:          a.FriendlyName,
		HealthStatus:          a.HealthStatus,
		ProtectableObjectType: a.ProtectableObjectType,
		ProtectedItemCount:    a.ProtectedItemCount,
		ProtectionStatus:      a.ProtectionStatus,
		RegistrationStatus:    a.RegistrationStatus,
		UpgradeAvailable:      a.UpgradeAvailable,
	}
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureBackupServerContainer.
func (a *AzureBackupServerContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		BackupManagementType:  a.BackupManagementType,
		ContainerType:         a.ContainerType,
		FriendlyName:          a.FriendlyName,
		HealthStatus:          a.HealthStatus,
		ProtectableObjectType: a.ProtectableObjectType,
		RegistrationStatus:    a.RegistrationStatus,
	}
}

// AzureBackupServerEngine - Backup engine type when Azure Backup Server is used to manage the backups.
type AzureBackupServerEngine struct {
	// REQUIRED; Type of the backup engine.
	BackupEngineType *BackupEngineType

	// Backup agent version
	AzureBackupAgentVersion *string

	// ID of the backup engine.
	BackupEngineID *string

	// Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}
	BackupEngineState *string

	// Type of backup management for the backup engine.
	BackupManagementType *BackupManagementType

	// Flag indicating if the backup engine be registered, once already registered.
	CanReRegister *bool

	// Backup engine version
	DpmVersion *string

	// Extended info of the backupengine
	ExtendedInfo *BackupEngineExtendedInfo

	// Friendly name of the backup engine.
	FriendlyName *string

	// Backup status of the backup engine.
	HealthStatus *string

	// To check if backup agent upgrade available
	IsAzureBackupAgentUpgradeAvailable *bool

	// To check if backup engine upgrade available
	IsDpmUpgradeAvailable *bool

	// Registration status of the backup engine with the Recovery Services Vault.
	RegistrationStatus *string
}

// GetBackupEngineBase implements the BackupEngineBaseClassification interface for type AzureBackupServerEngine.
func (a *AzureBackupServerEngine) GetBackupEngineBase() *BackupEngineBase {
	return &BackupEngineBase{
		AzureBackupAgentVersion:            a.AzureBackupAgentVersion,
		BackupEngineID:                     a.BackupEngineID,
		BackupEngineState:                  a.BackupEngineState,
		BackupEngineType:                   a.BackupEngineType,
		BackupManagementType:               a.BackupManagementType,
		CanReRegister:                      a.CanReRegister,
		DpmVersion:                         a.DpmVersion,
		ExtendedInfo:                       a.ExtendedInfo,
		FriendlyName:                       a.FriendlyName,
		HealthStatus:                       a.HealthStatus,
		IsAzureBackupAgentUpgradeAvailable: a.IsAzureBackupAgentUpgradeAvailable,
		IsDpmUpgradeAvailable:              a.IsDpmUpgradeAvailable,
		RegistrationStatus:                 a.RegistrationStatus,
	}
}

// AzureFileShareBackupRequest - AzureFileShare workload-specific backup request.
type AzureFileShareBackupRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Backup copy will expire after the time specified (UTC).
	RecoveryPointExpiryTimeInUTC *time.Time
}

// GetBackupRequest implements the BackupRequestClassification interface for type AzureFileShareBackupRequest.
func (a *AzureFileShareBackupRequest) GetBackupRequest() *BackupRequest {
	return &BackupRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureFileShareProtectableItem - Protectable item for Azure Fileshare workloads.
type AzureFileShareProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// File Share type XSync or XSMB.
	AzureFileShareType *AzureFileShareType

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Full Fabric ID of container to which this protectable item belongs. For example, ARM ID.
	ParentContainerFabricID *string

	// Friendly name of container to which this protectable item belongs.
	ParentContainerFriendlyName *string

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Type of workload for the backup management
	WorkloadType *string
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureFileShareProtectableItem.
func (a *AzureFileShareProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectableItemType:  a.ProtectableItemType,
		ProtectionState:      a.ProtectionState,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureFileShareProtectionPolicy - AzureStorage backup policy.
type AzureFileShareProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string

	// Number of items associated with this policy.
	ProtectedItemsCount *int32

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string

	// Retention policy with the details on backup copy retention ranges.
	RetentionPolicy RetentionPolicyClassification

	// Backup schedule specified as part of backup policy.
	SchedulePolicy SchedulePolicyClassification

	// TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
	TimeZone *string

	// Retention policy with the details on hardened backup copy retention ranges.
	VaultRetentionPolicy *VaultRetentionPolicy

	// Type of workload for the backup management
	WorkLoadType *WorkloadType
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type AzureFileShareProtectionPolicy.
func (a *AzureFileShareProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy {
	return &ProtectionPolicy{
		BackupManagementType:           a.BackupManagementType,
		ProtectedItemsCount:            a.ProtectedItemsCount,
		ResourceGuardOperationRequests: a.ResourceGuardOperationRequests,
	}
}

// AzureFileShareProvisionILRRequest - Update snapshot Uri with the correct friendly Name of the source Azure file share.
type AzureFileShareProvisionILRRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Recovery point ID.
	RecoveryPointID *string

	// Source Storage account ARM Id
	SourceResourceID *string
}

// GetILRRequest implements the ILRRequestClassification interface for type AzureFileShareProvisionILRRequest.
func (a *AzureFileShareProvisionILRRequest) GetILRRequest() *ILRRequest {
	return &ILRRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureFileShareRecoveryPoint - Azure File Share workload specific backup copy.
type AzureFileShareRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Contains Url to the snapshot of fileshare, if applicable
	FileShareSnapshotURI *string

	// Properties of Recovery Point
	RecoveryPointProperties *RecoveryPointProperties

	// Contains recovery point size
	RecoveryPointSizeInGB *int32

	// Time at which this backup copy was created.
	RecoveryPointTime *time.Time

	// Type of the backup copy. Specifies whether it is a crash consistent backup or app consistent.
	RecoveryPointType *string
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureFileShareRecoveryPoint.
func (a *AzureFileShareRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureFileShareRestoreRequest - AzureFileShare Restore Request
type AzureFileShareRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Options to resolve copy conflicts.
	CopyOptions *CopyOptions

	// Type of this recovery.
	RecoveryType *RecoveryType

	// List of Source Files/Folders(which need to recover) and TargetFolderPath details
	RestoreFileSpecs []*RestoreFileSpecs

	// Restore Type (FullShareRestore or ItemLevelRestore)
	RestoreRequestType *RestoreRequestType

	// Source storage account ARM Id
	SourceResourceID *string

	// Target File Share Details
	TargetDetails *TargetAFSRestoreInfo
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureFileShareRestoreRequest.
func (a *AzureFileShareRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureFileshareProtectedItem - Azure File Share workload-specific backup item.
type AzureFileshareProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Additional information with this backup item.
	ExtendedInfo *AzureFileshareProtectedItemExtendedInfo

	// Friendly name of the fileshare represented by this backup item.
	FriendlyName *string

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails

	// Last backup operation status. Possible values: Healthy, Unhealthy.
	LastBackupStatus *string

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// Backup state of this backup item.
	ProtectionState *ProtectionState

	// Backup status of this backup item.
	ProtectionStatus *string

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureFileshareProtectedItem.
func (a *AzureFileshareProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemType:                a.ProtectedItemType,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// AzureFileshareProtectedItemExtendedInfo - Additional information about Azure File Share backup item.
type AzureFileshareProtectedItemExtendedInfo struct {
	// The oldest backup copy available for this item in the service.
	OldestRecoveryPoint *time.Time

	// Indicates consistency of policy object and policy applied to this backup item.
	PolicyState *string

	// Number of available backup copies associated with this backup item.
	RecoveryPointCount *int32

	// READ-ONLY; Indicates the state of this resource. Possible values are from enum ResourceState {Invalid, Active, SoftDeleted,
	// Deleted}
	ResourceState *string

	// READ-ONLY; The resource state sync time for this backup item.
	ResourceStateSyncTime *time.Time
}

// AzureIaaSClassicComputeVMContainer - IaaS VM workload-specific backup item representing a classic virtual machine.
type AzureIaaSClassicComputeVMContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string

	// Type of the protectable object associated with this container
	ProtectableObjectType *string

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string

	// Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string

	// Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string
}

// GetIaaSVMContainer implements the IaaSVMContainerClassification interface for type AzureIaaSClassicComputeVMContainer.
func (a *AzureIaaSClassicComputeVMContainer) GetIaaSVMContainer() *IaaSVMContainer {
	return &IaaSVMContainer{
		BackupManagementType:  a.BackupManagementType,
		ContainerType:         a.ContainerType,
		FriendlyName:          a.FriendlyName,
		HealthStatus:          a.HealthStatus,
		ProtectableObjectType: a.ProtectableObjectType,
		RegistrationStatus:    a.RegistrationStatus,
		ResourceGroup:         a.ResourceGroup,
		VirtualMachineID:      a.VirtualMachineID,
		VirtualMachineVersion: a.VirtualMachineVersion,
	}
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureIaaSClassicComputeVMContainer.
func (a *AzureIaaSClassicComputeVMContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		BackupManagementType:  a.BackupManagementType,
		ContainerType:         a.ContainerType,
		FriendlyName:          a.FriendlyName,
		HealthStatus:          a.HealthStatus,
		ProtectableObjectType: a.ProtectableObjectType,
		RegistrationStatus:    a.RegistrationStatus,
	}
}

// AzureIaaSClassicComputeVMProtectableItem - IaaS VM workload-specific backup item representing the Classic Compute VM.
type AzureIaaSClassicComputeVMProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string

	// Fully qualified ARM ID of the virtual machine.
	VirtualMachineID *string

	// Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string

	// Type of workload for the backup management
	WorkloadType *string
}

// GetIaaSVMProtectableItem implements the IaaSVMProtectableItemClassification interface for type AzureIaaSClassicComputeVMProtectableItem.
func (a *AzureIaaSClassicComputeVMProtectableItem) GetIaaSVMProtectableItem() *IaaSVMProtectableItem {
	return &IaaSVMProtectableItem{
		BackupManagementType:  a.BackupManagementType,
		FriendlyName:          a.FriendlyName,
		ProtectableItemType:   a.ProtectableItemType,
		ProtectionState:       a.ProtectionState,
		ResourceGroup:         a.ResourceGroup,
		VirtualMachineID:      a.VirtualMachineID,
		VirtualMachineVersion: a.VirtualMachineVersion,
		WorkloadType:          a.WorkloadType,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureIaaSClassicComputeVMProtectableItem.
func (a *AzureIaaSClassicComputeVMProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectableItemType:  a.ProtectableItemType,
		ProtectionState:      a.ProtectionState,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureIaaSClassicComputeVMProtectedItem - IaaS VM workload-specific backup item representing the Classic Compute VM.
type AzureIaaSClassicComputeVMProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Additional information for this backup item.
	ExtendedInfo *AzureIaaSVMProtectedItemExtendedInfo

	// Extended Properties for Azure IaasVM Backup.
	ExtendedProperties *ExtendedProperties

	// Health details on this backup item.
	HealthDetails []*AzureIaaSVMHealthDetails

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails

	// Last backup operation status.
	LastBackupStatus *string

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// Backup state of this backup item.
	ProtectionState *ProtectionState

	// Backup status of this backup item.
	ProtectionStatus *string

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; Friendly name of the VM represented by this backup item.
	FriendlyName *string

	// READ-ONLY; Health status of protected item.
	HealthStatus *HealthStatus

	// READ-ONLY; Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time

	// READ-ONLY; Data ID of the protected item.
	ProtectedItemDataID *string

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Fully qualified ARM ID of the virtual machine represented by this item.
	VirtualMachineID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetAzureIaaSVMProtectedItem implements the AzureIaaSVMProtectedItemClassification interface for type AzureIaaSClassicComputeVMProtectedItem.
func (a *AzureIaaSClassicComputeVMProtectedItem) GetAzureIaaSVMProtectedItem() *AzureIaaSVMProtectedItem {
	return &AzureIaaSVMProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		ExtendedInfo:                     a.ExtendedInfo,
		ExtendedProperties:               a.ExtendedProperties,
		FriendlyName:                     a.FriendlyName,
		HealthDetails:                    a.HealthDetails,
		HealthStatus:                     a.HealthStatus,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		KpisHealths:                      a.KpisHealths,
		LastBackupStatus:                 a.LastBackupStatus,
		LastBackupTime:                   a.LastBackupTime,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemDataID:              a.ProtectedItemDataID,
		ProtectedItemType:                a.ProtectedItemType,
		ProtectionState:                  a.ProtectionState,
		ProtectionStatus:                 a.ProtectionStatus,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		VirtualMachineID:                 a.VirtualMachineID,
		WorkloadType:                     a.WorkloadType,
	}
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureIaaSClassicComputeVMProtectedItem.
func (a *AzureIaaSClassicComputeVMProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemType:                a.ProtectedItemType,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// AzureIaaSComputeVMContainer - IaaS VM workload-specific backup item representing an Azure Resource Manager virtual machine.
type AzureIaaSComputeVMContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string

	// Type of the protectable object associated with this container
	ProtectableObjectType *string

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string

	// Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string

	// Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string
}

// GetIaaSVMContainer implements the IaaSVMContainerClassification interface for type AzureIaaSComputeVMContainer.
func (a *AzureIaaSComputeVMContainer) GetIaaSVMContainer() *IaaSVMContainer {
	return &IaaSVMContainer{
		BackupManagementType:  a.BackupManagementType,
		ContainerType:         a.ContainerType,
		FriendlyName:          a.FriendlyName,
		HealthStatus:          a.HealthStatus,
		ProtectableObjectType: a.ProtectableObjectType,
		RegistrationStatus:    a.RegistrationStatus,
		ResourceGroup:         a.ResourceGroup,
		VirtualMachineID:      a.VirtualMachineID,
		VirtualMachineVersion: a.VirtualMachineVersion,
	}
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureIaaSComputeVMContainer.
func (a *AzureIaaSComputeVMContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		BackupManagementType:  a.BackupManagementType,
		ContainerType:         a.ContainerType,
		FriendlyName:          a.FriendlyName,
		HealthStatus:          a.HealthStatus,
		ProtectableObjectType: a.ProtectableObjectType,
		RegistrationStatus:    a.RegistrationStatus,
	}
}

// AzureIaaSComputeVMProtectableItem - IaaS VM workload-specific backup item representing the Azure Resource Manager VM.
type AzureIaaSComputeVMProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string

	// Fully qualified ARM ID of the virtual machine.
	VirtualMachineID *string

	// Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string

	// Type of workload for the backup management
	WorkloadType *string
}

// GetIaaSVMProtectableItem implements the IaaSVMProtectableItemClassification interface for type AzureIaaSComputeVMProtectableItem.
func (a *AzureIaaSComputeVMProtectableItem) GetIaaSVMProtectableItem() *IaaSVMProtectableItem {
	return &IaaSVMProtectableItem{
		BackupManagementType:  a.BackupManagementType,
		FriendlyName:          a.FriendlyName,
		ProtectableItemType:   a.ProtectableItemType,
		ProtectionState:       a.ProtectionState,
		ResourceGroup:         a.ResourceGroup,
		VirtualMachineID:      a.VirtualMachineID,
		VirtualMachineVersion: a.VirtualMachineVersion,
		WorkloadType:          a.WorkloadType,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureIaaSComputeVMProtectableItem.
func (a *AzureIaaSComputeVMProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectableItemType:  a.ProtectableItemType,
		ProtectionState:      a.ProtectionState,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureIaaSComputeVMProtectedItem - IaaS VM workload-specific backup item representing the Azure Resource Manager VM.
type AzureIaaSComputeVMProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Additional information for this backup item.
	ExtendedInfo *AzureIaaSVMProtectedItemExtendedInfo

	// Extended Properties for Azure IaasVM Backup.
	ExtendedProperties *ExtendedProperties

	// Health details on this backup item.
	HealthDetails []*AzureIaaSVMHealthDetails

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails

	// Last backup operation status.
	LastBackupStatus *string

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// Backup state of this backup item.
	ProtectionState *ProtectionState

	// Backup status of this backup item.
	ProtectionStatus *string

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; Friendly name of the VM represented by this backup item.
	FriendlyName *string

	// READ-ONLY; Health status of protected item.
	HealthStatus *HealthStatus

	// READ-ONLY; Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time

	// READ-ONLY; Data ID of the protected item.
	ProtectedItemDataID *string

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Fully qualified ARM ID of the virtual machine represented by this item.
	VirtualMachineID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetAzureIaaSVMProtectedItem implements the AzureIaaSVMProtectedItemClassification interface for type AzureIaaSComputeVMProtectedItem.
func (a *AzureIaaSComputeVMProtectedItem) GetAzureIaaSVMProtectedItem() *AzureIaaSVMProtectedItem {
	return &AzureIaaSVMProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		ExtendedInfo:                     a.ExtendedInfo,
		ExtendedProperties:               a.ExtendedProperties,
		FriendlyName:                     a.FriendlyName,
		HealthDetails:                    a.HealthDetails,
		HealthStatus:                     a.HealthStatus,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		KpisHealths:                      a.KpisHealths,
		LastBackupStatus:                 a.LastBackupStatus,
		LastBackupTime:                   a.LastBackupTime,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemDataID:              a.ProtectedItemDataID,
		ProtectedItemType:                a.ProtectedItemType,
		ProtectionState:                  a.ProtectionState,
		ProtectionStatus:                 a.ProtectionStatus,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		VirtualMachineID:                 a.VirtualMachineID,
		WorkloadType:                     a.WorkloadType,
	}
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureIaaSComputeVMProtectedItem.
func (a *AzureIaaSComputeVMProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemType:                a.ProtectedItemType,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// AzureIaaSVMErrorInfo - Azure IaaS VM workload-specific error information.
type AzureIaaSVMErrorInfo struct {
	// READ-ONLY; Error code.
	ErrorCode *int32

	// READ-ONLY; Localized error string.
	ErrorString *string

	// READ-ONLY; Title: Typically, the entity that the error pertains to.
	ErrorTitle *string

	// READ-ONLY; List of localized recommendations for above error code.
	Recommendations []*string
}

// AzureIaaSVMHealthDetails - Azure IaaS VM workload-specific Health Details.
type AzureIaaSVMHealthDetails struct {
	// READ-ONLY; Health Code
	Code *int32

	// READ-ONLY; Health Message
	Message *string

	// READ-ONLY; Health Recommended Actions
	Recommendations []*string

	// READ-ONLY; Health Title
	Title *string
}

// AzureIaaSVMJob - Azure IaaS VM workload-specific job object.
type AzureIaaSVMJob struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string

	// Gets or sets the state/actions applicable on this job like cancel/retry.
	ActionsInfo []*JobSupportedAction

	// ActivityId of job.
	ActivityID *string

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType

	// Container name of the entity on which the current job is executing.
	ContainerName *string

	// Time elapsed during the execution of this job.
	Duration *string

	// The end time.
	EndTime *time.Time

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string

	// Error details on execution of this job.
	ErrorDetails []*AzureIaaSVMErrorInfo

	// Additional information for this job.
	ExtendedInfo *AzureIaaSVMJobExtendedInfo

	// Indicated that whether the job is adhoc(true) or scheduled(false)
	IsUserTriggered *bool

	// The operation name.
	Operation *string

	// The start time.
	StartTime *time.Time

	// Job status.
	Status *string

	// Specifies whether the backup item is a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string
}

// GetJob implements the JobClassification interface for type AzureIaaSVMJob.
func (a *AzureIaaSVMJob) GetJob() *Job {
	return &Job{
		ActivityID:           a.ActivityID,
		BackupManagementType: a.BackupManagementType,
		EndTime:              a.EndTime,
		EntityFriendlyName:   a.EntityFriendlyName,
		JobType:              a.JobType,
		Operation:            a.Operation,
		StartTime:            a.StartTime,
		Status:               a.Status,
	}
}

// AzureIaaSVMJobExtendedInfo - Azure IaaS VM workload-specific additional information for job.
type AzureIaaSVMJobExtendedInfo struct {
	// Non localized error message on job execution.
	DynamicErrorMessage *string

	// Time remaining for execution of this job.
	EstimatedRemainingDuration *string

	// Job internal properties.
	InternalPropertyBag map[string]*string

	// Indicates progress of the job. Null if it has not started or completed.
	ProgressPercentage *float64

	// Job properties.
	PropertyBag map[string]*string

	// List of tasks associated with this job.
	TasksList []*AzureIaaSVMJobTaskDetails
}

// AzureIaaSVMJobTaskDetails - Azure IaaS VM workload-specific job task details.
type AzureIaaSVMJobTaskDetails struct {
	// Time elapsed for task.
	Duration *string

	// The end time.
	EndTime *time.Time

	// The instanceId.
	InstanceID *string

	// Progress of the task.
	ProgressPercentage *float64

	// The start time.
	StartTime *time.Time

	// The status.
	Status *string

	// Details about execution of the task. eg: number of bytes transferred etc
	TaskExecutionDetails *string

	// The task display name.
	TaskID *string
}

// AzureIaaSVMJobV2 - Azure IaaS VM workload-specific job object.
type AzureIaaSVMJobV2 struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string

	// Gets or sets the state/actions applicable on this job like cancel/retry.
	ActionsInfo []*JobSupportedAction

	// ActivityId of job.
	ActivityID *string

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType

	// Container name of the entity on which the current job is executing.
	ContainerName *string

	// Time elapsed during the execution of this job.
	Duration *string

	// The end time.
	EndTime *time.Time

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string

	// Error details on execution of this job.
	ErrorDetails []*AzureIaaSVMErrorInfo

	// Additional information for this job.
	ExtendedInfo *AzureIaaSVMJobExtendedInfo

	// The operation name.
	Operation *string

	// The start time.
	StartTime *time.Time

	// Job status.
	Status *string

	// Specifies whether the backup item is a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string
}

// GetJob implements the JobClassification interface for type AzureIaaSVMJobV2.
func (a *AzureIaaSVMJobV2) GetJob() *Job {
	return &Job{
		ActivityID:           a.ActivityID,
		BackupManagementType: a.BackupManagementType,
		EndTime:              a.EndTime,
		EntityFriendlyName:   a.EntityFriendlyName,
		JobType:              a.JobType,
		Operation:            a.Operation,
		StartTime:            a.StartTime,
		Status:               a.Status,
	}
}

// AzureIaaSVMProtectedItem - IaaS VM workload-specific backup item.
type AzureIaaSVMProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Additional information for this backup item.
	ExtendedInfo *AzureIaaSVMProtectedItemExtendedInfo

	// Extended Properties for Azure IaasVM Backup.
	ExtendedProperties *ExtendedProperties

	// Health details on this backup item.
	HealthDetails []*AzureIaaSVMHealthDetails

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails

	// Last backup operation status.
	LastBackupStatus *string

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// Backup state of this backup item.
	ProtectionState *ProtectionState

	// Backup status of this backup item.
	ProtectionStatus *string

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; Friendly name of the VM represented by this backup item.
	FriendlyName *string

	// READ-ONLY; Health status of protected item.
	HealthStatus *HealthStatus

	// READ-ONLY; Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time

	// READ-ONLY; Data ID of the protected item.
	ProtectedItemDataID *string

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Fully qualified ARM ID of the virtual machine represented by this item.
	VirtualMachineID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetAzureIaaSVMProtectedItem implements the AzureIaaSVMProtectedItemClassification interface for type AzureIaaSVMProtectedItem.
func (a *AzureIaaSVMProtectedItem) GetAzureIaaSVMProtectedItem() *AzureIaaSVMProtectedItem { return a }

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureIaaSVMProtectedItem.
func (a *AzureIaaSVMProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemType:                a.ProtectedItemType,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// AzureIaaSVMProtectedItemExtendedInfo - Additional information on Azure IaaS VM specific backup item.
type AzureIaaSVMProtectedItemExtendedInfo struct {
	// The latest backup copy available for this backup item in archive tier
	NewestRecoveryPointInArchive *time.Time

	// The oldest backup copy available for this backup item across all tiers.
	OldestRecoveryPoint *time.Time

	// The oldest backup copy available for this backup item in archive tier
	OldestRecoveryPointInArchive *time.Time

	// The oldest backup copy available for this backup item in vault tier
	OldestRecoveryPointInVault *time.Time

	// Specifies if backup policy associated with the backup item is inconsistent.
	PolicyInconsistent *bool

	// Number of backup copies available for this backup item.
	RecoveryPointCount *int32
}

// AzureIaaSVMProtectionPolicy - IaaS VM workload-specific backup policy.
type AzureIaaSVMProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string
	InstantRPDetails     *InstantRPAdditionalDetails

	// Instant RP retention policy range in days
	InstantRpRetentionRangeInDays *int32
	PolicyType                    *IAASVMPolicyType

	// Number of items associated with this policy.
	ProtectedItemsCount *int32

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string

	// Retention policy with the details on backup copy retention ranges.
	RetentionPolicy RetentionPolicyClassification

	// Backup schedule specified as part of backup policy.
	SchedulePolicy SchedulePolicyClassification

	// Tiering policy to automatically move RPs to another tier Key is Target Tier, defined in RecoveryPointTierType enum. Tiering
	// policy specifies the criteria to move RP to the target tier.
	TieringPolicy map[string]*TieringPolicy

	// TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
	TimeZone *string
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type AzureIaaSVMProtectionPolicy.
func (a *AzureIaaSVMProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy {
	return &ProtectionPolicy{
		BackupManagementType:           a.BackupManagementType,
		ProtectedItemsCount:            a.ProtectedItemsCount,
		ResourceGuardOperationRequests: a.ResourceGuardOperationRequests,
	}
}

// AzureRecoveryServiceVaultProtectionIntent - Azure Recovery Services Vault specific protection intent item.
type AzureRecoveryServiceVaultProtectionIntent struct {
	// REQUIRED; backup protectionIntent type.
	ProtectionIntentItemType *ProtectionIntentItemType

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Backup state of this backup item.
	ProtectionState *ProtectionStatus

	// ARM ID of the resource to be backed up.
	SourceResourceID *string
}

// GetAzureRecoveryServiceVaultProtectionIntent implements the AzureRecoveryServiceVaultProtectionIntentClassification interface
// for type AzureRecoveryServiceVaultProtectionIntent.
func (a *AzureRecoveryServiceVaultProtectionIntent) GetAzureRecoveryServiceVaultProtectionIntent() *AzureRecoveryServiceVaultProtectionIntent {
	return a
}

// GetProtectionIntent implements the ProtectionIntentClassification interface for type AzureRecoveryServiceVaultProtectionIntent.
func (a *AzureRecoveryServiceVaultProtectionIntent) GetProtectionIntent() *ProtectionIntent {
	return &ProtectionIntent{
		BackupManagementType:     a.BackupManagementType,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		ProtectionState:          a.ProtectionState,
		SourceResourceID:         a.SourceResourceID,
	}
}

// AzureResourceProtectionIntent - IaaS VM specific backup protection intent item.
type AzureResourceProtectionIntent struct {
	// REQUIRED; backup protectionIntent type.
	ProtectionIntentItemType *ProtectionIntentItemType

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// Friendly name of the VM represented by this backup item.
	FriendlyName *string

	// ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Backup state of this backup item.
	ProtectionState *ProtectionStatus

	// ARM ID of the resource to be backed up.
	SourceResourceID *string
}

// GetProtectionIntent implements the ProtectionIntentClassification interface for type AzureResourceProtectionIntent.
func (a *AzureResourceProtectionIntent) GetProtectionIntent() *ProtectionIntent {
	return &ProtectionIntent{
		BackupManagementType:     a.BackupManagementType,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		ProtectionState:          a.ProtectionState,
		SourceResourceID:         a.SourceResourceID,
	}
}

// AzureSQLAGWorkloadContainerProtectionContainer - Container for SQL workloads under SQL Availability Group.
type AzureSQLAGWorkloadContainerProtectionContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Additional details of a workload container.
	ExtendedInfo *AzureWorkloadContainerExtendedInfo

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string

	// Time stamp when this container was updated.
	LastUpdatedTime *time.Time

	// Re-Do Operation
	OperationType *OperationType

	// Type of the protectable object associated with this container
	ProtectableObjectType *string

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string

	// ARM ID of the virtual machine represented by this Azure Workload Container
	SourceResourceID *string

	// Workload type for which registration was sent.
	WorkloadType *WorkloadType
}

// GetAzureWorkloadContainer implements the AzureWorkloadContainerClassification interface for type AzureSQLAGWorkloadContainerProtectionContainer.
func (a *AzureSQLAGWorkloadContainerProtectionContainer) GetAzureWorkloadContainer() *AzureWorkloadContainer {
	return &AzureWorkloadContainer{
		BackupManagementType:  a.BackupManagementType,
		ContainerType:         a.ContainerType,
		ExtendedInfo:          a.ExtendedInfo,
		FriendlyName:          a.FriendlyName,
		HealthStatus:          a.HealthStatus,
		LastUpdatedTime:       a.LastUpdatedTime,
		OperationType:         a.OperationType,
		ProtectableObjectType: a.ProtectableObjectType,
		RegistrationStatus:    a.RegistrationStatus,
		SourceResourceID:      a.SourceResourceID,
		WorkloadType:          a.WorkloadType,
	}
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureSQLAGWorkloadContainerProtectionContainer.
func (a *AzureSQLAGWorkloadContainerProtectionContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		BackupManagementType:  a.BackupManagementType,
		ContainerType:         a.ContainerType,
		FriendlyName:          a.FriendlyName,
		HealthStatus:          a.HealthStatus,
		ProtectableObjectType: a.ProtectableObjectType,
		RegistrationStatus:    a.RegistrationStatus,
	}
}

// AzureSQLContainer - Azure Sql workload-specific container.
type AzureSQLContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string

	// Type of the protectable object associated with this container
	ProtectableObjectType *string

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureSQLContainer.
func (a *AzureSQLContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		BackupManagementType:  a.BackupManagementType,
		ContainerType:         a.ContainerType,
		FriendlyName:          a.FriendlyName,
		HealthStatus:          a.HealthStatus,
		ProtectableObjectType: a.ProtectableObjectType,
		RegistrationStatus:    a.RegistrationStatus,
	}
}

// AzureSQLProtectedItem - Azure SQL workload-specific backup item.
type AzureSQLProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Additional information for this backup item.
	ExtendedInfo *AzureSQLProtectedItemExtendedInfo

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// Internal ID of a backup item. Used by Azure SQL Backup engine to contact Recovery Services.
	ProtectedItemDataID *string

	// Backup state of the backed up item.
	ProtectionState *ProtectedItemState

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureSQLProtectedItem.
func (a *AzureSQLProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemType:                a.ProtectedItemType,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// AzureSQLProtectedItemExtendedInfo - Additional information on Azure Sql specific protected item.
type AzureSQLProtectedItemExtendedInfo struct {
	// The oldest backup copy available for this item in the service.
	OldestRecoveryPoint *time.Time

	// State of the backup policy associated with this backup item.
	PolicyState *string

	// Number of available backup copies associated with this backup item.
	RecoveryPointCount *int32
}

// AzureSQLProtectionPolicy - Azure SQL workload-specific backup policy.
type AzureSQLProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string

	// Number of items associated with this policy.
	ProtectedItemsCount *int32

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string

	// Retention policy details.
	RetentionPolicy RetentionPolicyClassification
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type AzureSQLProtectionPolicy.
func (a *AzureSQLProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy {
	return &ProtectionPolicy{
		BackupManagementType:           a.BackupManagementType,
		ProtectedItemsCount:            a.ProtectedItemsCount,
		ResourceGuardOperationRequests: a.ResourceGuardOperationRequests,
	}
}

// AzureStorageContainer - Azure Storage Account workload-specific container.
type AzureStorageContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ProtectableContainerType

	// Whether storage account lock is to be acquired for this container or not.
	AcquireStorageAccountLock *AcquireStorageAccountLock

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string

	// Type of the protectable object associated with this container
	ProtectableObjectType *string

	// Number of items backed up in this container.
	ProtectedItemCount *int64

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string

	// Fully qualified ARM url.
	SourceResourceID *string

	// Storage account version.
	StorageAccountVersion *string
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureStorageContainer.
func (a *AzureStorageContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		BackupManagementType:  a.BackupManagementType,
		ContainerType:         a.ContainerType,
		FriendlyName:          a.FriendlyName,
		HealthStatus:          a.HealthStatus,
		ProtectableObjectType: a.ProtectableObjectType,
		RegistrationStatus:    a.RegistrationStatus,
	}
}

// AzureStorageErrorInfo - Azure storage specific error information
type AzureStorageErrorInfo struct {
	// Error code.
	ErrorCode *int32

	// Localized error string.
	ErrorString *string

	// List of localized recommendations for above error code.
	Recommendations []*string
}

// AzureStorageJob - Azure storage specific job.
type AzureStorageJob struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string

	// Gets or sets the state/actions applicable on this job like cancel/retry.
	ActionsInfo []*JobSupportedAction

	// ActivityId of job.
	ActivityID *string

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType

	// Time elapsed during the execution of this job.
	Duration *string

	// The end time.
	EndTime *time.Time

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string

	// Error details on execution of this job.
	ErrorDetails []*AzureStorageErrorInfo

	// Additional information about the job.
	ExtendedInfo *AzureStorageJobExtendedInfo

	// Indicated that whether the job is adhoc(true) or scheduled(false)
	IsUserTriggered *bool

	// The operation name.
	Operation *string

	// The start time.
	StartTime *time.Time

	// Job status.
	Status *string

	// Specifies friendly name of the storage account.
	StorageAccountName *string

	// Specifies whether the Storage account is a Classic or an Azure Resource Manager Storage account.
	StorageAccountVersion *string
}

// GetJob implements the JobClassification interface for type AzureStorageJob.
func (a *AzureStorageJob) GetJob() *Job {
	return &Job{
		ActivityID:           a.ActivityID,
		BackupManagementType: a.BackupManagementType,
		EndTime:              a.EndTime,
		EntityFriendlyName:   a.EntityFriendlyName,
		JobType:              a.JobType,
		Operation:            a.Operation,
		StartTime:            a.StartTime,
		Status:               a.Status,
	}
}

// AzureStorageJobExtendedInfo - Azure Storage workload-specific additional information for job.
type AzureStorageJobExtendedInfo struct {
	// Non localized error message on job execution.
	DynamicErrorMessage *string

	// Job properties.
	PropertyBag map[string]*string

	// List of tasks for this job
	TasksList []*AzureStorageJobTaskDetails
}

// AzureStorageJobTaskDetails - Azure storage workload specific job task details.
type AzureStorageJobTaskDetails struct {
	// The status.
	Status *string

	// The task display name.
	TaskID *string
}

// AzureStorageProtectableContainer - Azure Storage-specific protectable containers
type AzureStorageProtectableContainer struct {
	// REQUIRED; Type of the container. The value of this property for
	// 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines
	ProtectableContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Fabric Id of the container such as ARM Id.
	ContainerID *string

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string
}

// GetProtectableContainer implements the ProtectableContainerClassification interface for type AzureStorageProtectableContainer.
func (a *AzureStorageProtectableContainer) GetProtectableContainer() *ProtectableContainer {
	return &ProtectableContainer{
		BackupManagementType:     a.BackupManagementType,
		ContainerID:              a.ContainerID,
		FriendlyName:             a.FriendlyName,
		HealthStatus:             a.HealthStatus,
		ProtectableContainerType: a.ProtectableContainerType,
	}
}

// AzureVMAppContainerProtectableContainer - Azure workload-specific container
type AzureVMAppContainerProtectableContainer struct {
	// REQUIRED; Type of the container. The value of this property for
	// 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines
	ProtectableContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Fabric Id of the container such as ARM Id.
	ContainerID *string

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string
}

// GetProtectableContainer implements the ProtectableContainerClassification interface for type AzureVMAppContainerProtectableContainer.
func (a *AzureVMAppContainerProtectableContainer) GetProtectableContainer() *ProtectableContainer {
	return &ProtectableContainer{
		BackupManagementType:     a.BackupManagementType,
		ContainerID:              a.ContainerID,
		FriendlyName:             a.FriendlyName,
		HealthStatus:             a.HealthStatus,
		ProtectableContainerType: a.ProtectableContainerType,
	}
}

// AzureVMAppContainerProtectionContainer - Container for SQL workloads under Azure Virtual Machines.
type AzureVMAppContainerProtectionContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Additional details of a workload container.
	ExtendedInfo *AzureWorkloadContainerExtendedInfo

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string

	// Time stamp when this container was updated.
	LastUpdatedTime *time.Time

	// Re-Do Operation
	OperationType *OperationType

	// Type of the protectable object associated with this container
	ProtectableObjectType *string

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string

	// ARM ID of the virtual machine represented by this Azure Workload Container
	SourceResourceID *string

	// Workload type for which registration was sent.
	WorkloadType *WorkloadType
}

// GetAzureWorkloadContainer implements the AzureWorkloadContainerClassification interface for type AzureVMAppContainerProtectionContainer.
func (a *AzureVMAppContainerProtectionContainer) GetAzureWorkloadContainer() *AzureWorkloadContainer {
	return &AzureWorkloadContainer{
		BackupManagementType:  a.BackupManagementType,
		ContainerType:         a.ContainerType,
		ExtendedInfo:          a.ExtendedInfo,
		FriendlyName:          a.FriendlyName,
		HealthStatus:          a.HealthStatus,
		LastUpdatedTime:       a.LastUpdatedTime,
		OperationType:         a.OperationType,
		ProtectableObjectType: a.ProtectableObjectType,
		RegistrationStatus:    a.RegistrationStatus,
		SourceResourceID:      a.SourceResourceID,
		WorkloadType:          a.WorkloadType,
	}
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureVMAppContainerProtectionContainer.
func (a *AzureVMAppContainerProtectionContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		BackupManagementType:  a.BackupManagementType,
		ContainerType:         a.ContainerType,
		FriendlyName:          a.FriendlyName,
		HealthStatus:          a.HealthStatus,
		ProtectableObjectType: a.ProtectableObjectType,
		RegistrationStatus:    a.RegistrationStatus,
	}
}

// AzureVMResourceFeatureSupportRequest - AzureResource(IaaS VM) Specific feature support request
type AzureVMResourceFeatureSupportRequest struct {
	// REQUIRED; backup support feature type.
	FeatureType *string

	// SKUs (Premium/Managed etc) in case of IaasVM
	VMSKU *string

	// Size of the resource: VM size(A/D series etc) in case of IaasVM
	VMSize *string
}

// GetFeatureSupportRequest implements the FeatureSupportRequestClassification interface for type AzureVMResourceFeatureSupportRequest.
func (a *AzureVMResourceFeatureSupportRequest) GetFeatureSupportRequest() *FeatureSupportRequest {
	return &FeatureSupportRequest{
		FeatureType: a.FeatureType,
	}
}

// AzureVMResourceFeatureSupportResponse - Response for feature support requests for Azure IaasVm
type AzureVMResourceFeatureSupportResponse struct {
	// Support status of feature
	SupportStatus *SupportStatus
}

// AzureVMWorkloadItem - Azure VM workload-specific workload item.
type AzureVMWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool

	// Name for instance or AG
	ParentName *string

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadItem.
func (a *AzureVMWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem { return a }

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadItem.
func (a *AzureVMWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
		WorkloadItemType:     a.WorkloadItemType,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadProtectableItem - Azure VM workload-specific protectable item.
type AzureVMWorkloadProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool

	// Indicates if item is protectable
	IsProtectable *bool

	// Name for instance or AG
	ParentName *string

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadProtectableItem.
func (a *AzureVMWorkloadProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return a
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadProtectableItem.
func (a *AzureVMWorkloadProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectableItemType:  a.ProtectableItemType,
		ProtectionState:      a.ProtectionState,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadProtectedItem - Azure VM workload-specific protected item.
type AzureVMWorkloadProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Additional information for this backup item.
	ExtendedInfo *AzureVMWorkloadProtectedItemExtendedInfo

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails

	// Error details in last backup
	LastBackupErrorDetail *ErrorDetail

	// Last backup operation status. Possible values: Healthy, Unhealthy.
	LastBackupStatus *LastBackupStatus

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// List of the nodes in case of distributed container.
	NodesList []*DistributedNodesInfo

	// Parent name of the DB such as Instance or Availability Group.
	ParentName *string

	// Parent type of protected item, example: for a DB, standalone server or distributed
	ParentType *string

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// Data ID of the protected item.
	ProtectedItemDataSourceID *string

	// Health status of the backup item, evaluated based on last heartbeat received
	ProtectedItemHealthStatus *ProtectedItemHealthStatus

	// Backup state of this backup item.
	ProtectionState *ProtectionState

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Host/Cluster Name for instance or AG
	ServerName *string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; Friendly name of the DB represented by this backup item.
	FriendlyName *string

	// READ-ONLY; Backup status of this backup item.
	ProtectionStatus *string

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetAzureVMWorkloadProtectedItem implements the AzureVMWorkloadProtectedItemClassification interface for type AzureVMWorkloadProtectedItem.
func (a *AzureVMWorkloadProtectedItem) GetAzureVMWorkloadProtectedItem() *AzureVMWorkloadProtectedItem {
	return a
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureVMWorkloadProtectedItem.
func (a *AzureVMWorkloadProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemType:                a.ProtectedItemType,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// AzureVMWorkloadProtectedItemExtendedInfo - Additional information on Azure Workload for SQL specific backup item.
type AzureVMWorkloadProtectedItemExtendedInfo struct {
	// The latest backup copy available for this backup item in archive tier
	NewestRecoveryPointInArchive *time.Time

	// The oldest backup copy available for this backup item across all tiers.
	OldestRecoveryPoint *time.Time

	// The oldest backup copy available for this backup item in archive tier
	OldestRecoveryPointInArchive *time.Time

	// The oldest backup copy available for this backup item in vault tier
	OldestRecoveryPointInVault *time.Time

	// Indicates consistency of policy object and policy applied to this backup item.
	PolicyState *string

	// Indicates consistency of policy object and policy applied to this backup item.
	RecoveryModel *string

	// Number of backup copies available for this backup item.
	RecoveryPointCount *int32
}

// AzureVMWorkloadProtectionPolicy - Azure VM (Mercury) workload-specific backup policy.
type AzureVMWorkloadProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string

	// Fix the policy inconsistency
	MakePolicyConsistent *bool

	// Number of items associated with this policy.
	ProtectedItemsCount *int32

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string

	// Common settings for the backup management
	Settings *Settings

	// List of sub-protection policies which includes schedule and retention
	SubProtectionPolicy []*SubProtectionPolicy

	// Type of workload for the backup management
	WorkLoadType *WorkloadType
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type AzureVMWorkloadProtectionPolicy.
func (a *AzureVMWorkloadProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy {
	return &ProtectionPolicy{
		BackupManagementType:           a.BackupManagementType,
		ProtectedItemsCount:            a.ProtectedItemsCount,
		ResourceGuardOperationRequests: a.ResourceGuardOperationRequests,
	}
}

// AzureVMWorkloadSAPAseDatabaseProtectedItem - Azure VM workload-specific protected item representing SAP ASE Database.
type AzureVMWorkloadSAPAseDatabaseProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Additional information for this backup item.
	ExtendedInfo *AzureVMWorkloadProtectedItemExtendedInfo

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails

	// Error details in last backup
	LastBackupErrorDetail *ErrorDetail

	// Last backup operation status. Possible values: Healthy, Unhealthy.
	LastBackupStatus *LastBackupStatus

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// List of the nodes in case of distributed container.
	NodesList []*DistributedNodesInfo

	// Parent name of the DB such as Instance or Availability Group.
	ParentName *string

	// Parent type of protected item, example: for a DB, standalone server or distributed
	ParentType *string

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// Data ID of the protected item.
	ProtectedItemDataSourceID *string

	// Health status of the backup item, evaluated based on last heartbeat received
	ProtectedItemHealthStatus *ProtectedItemHealthStatus

	// Backup state of this backup item.
	ProtectionState *ProtectionState

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Host/Cluster Name for instance or AG
	ServerName *string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; Friendly name of the DB represented by this backup item.
	FriendlyName *string

	// READ-ONLY; Backup status of this backup item.
	ProtectionStatus *string

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetAzureVMWorkloadProtectedItem implements the AzureVMWorkloadProtectedItemClassification interface for type AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (a *AzureVMWorkloadSAPAseDatabaseProtectedItem) GetAzureVMWorkloadProtectedItem() *AzureVMWorkloadProtectedItem {
	return &AzureVMWorkloadProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		ExtendedInfo:                     a.ExtendedInfo,
		FriendlyName:                     a.FriendlyName,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		KpisHealths:                      a.KpisHealths,
		LastBackupErrorDetail:            a.LastBackupErrorDetail,
		LastBackupStatus:                 a.LastBackupStatus,
		LastBackupTime:                   a.LastBackupTime,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		NodesList:                        a.NodesList,
		ParentName:                       a.ParentName,
		ParentType:                       a.ParentType,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemDataSourceID:        a.ProtectedItemDataSourceID,
		ProtectedItemHealthStatus:        a.ProtectedItemHealthStatus,
		ProtectedItemType:                a.ProtectedItemType,
		ProtectionState:                  a.ProtectionState,
		ProtectionStatus:                 a.ProtectionStatus,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		ServerName:                       a.ServerName,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureVMWorkloadSAPAseDatabaseProtectedItem.
func (a *AzureVMWorkloadSAPAseDatabaseProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemType:                a.ProtectedItemType,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// AzureVMWorkloadSAPAseDatabaseWorkloadItem - Azure VM workload-specific workload item representing SAP ASE Database.
type AzureVMWorkloadSAPAseDatabaseWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool

	// Name for instance or AG
	ParentName *string

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (a *AzureVMWorkloadSAPAseDatabaseWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem {
	return &AzureVMWorkloadItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		IsAutoProtectable:    a.IsAutoProtectable,
		ParentName:           a.ParentName,
		ProtectionState:      a.ProtectionState,
		ServerName:           a.ServerName,
		SubWorkloadItemCount: a.SubWorkloadItemCount,
		Subinquireditemcount: a.Subinquireditemcount,
		WorkloadItemType:     a.WorkloadItemType,
		WorkloadType:         a.WorkloadType,
	}
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadSAPAseDatabaseWorkloadItem.
func (a *AzureVMWorkloadSAPAseDatabaseWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
		WorkloadItemType:     a.WorkloadItemType,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadSAPAseSystemProtectableItem - Azure VM workload-specific protectable item representing SAP ASE System.
type AzureVMWorkloadSAPAseSystemProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool

	// Indicates if item is protectable
	IsProtectable *bool

	// Name for instance or AG
	ParentName *string

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPAseSystemProtectableItem.
func (a *AzureVMWorkloadSAPAseSystemProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		BackupManagementType:    a.BackupManagementType,
		FriendlyName:            a.FriendlyName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		IsProtectable:           a.IsProtectable,
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		Prebackupvalidation:     a.Prebackupvalidation,
		ProtectableItemType:     a.ProtectableItemType,
		ProtectionState:         a.ProtectionState,
		ServerName:              a.ServerName,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		WorkloadType:            a.WorkloadType,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPAseSystemProtectableItem.
func (a *AzureVMWorkloadSAPAseSystemProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectableItemType:  a.ProtectableItemType,
		ProtectionState:      a.ProtectionState,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadSAPAseSystemWorkloadItem - Azure VM workload-specific workload item representing SAP ASE System.
type AzureVMWorkloadSAPAseSystemWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool

	// Name for instance or AG
	ParentName *string

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadSAPAseSystemWorkloadItem.
func (a *AzureVMWorkloadSAPAseSystemWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem {
	return &AzureVMWorkloadItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		IsAutoProtectable:    a.IsAutoProtectable,
		ParentName:           a.ParentName,
		ProtectionState:      a.ProtectionState,
		ServerName:           a.ServerName,
		SubWorkloadItemCount: a.SubWorkloadItemCount,
		Subinquireditemcount: a.Subinquireditemcount,
		WorkloadItemType:     a.WorkloadItemType,
		WorkloadType:         a.WorkloadType,
	}
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadSAPAseSystemWorkloadItem.
func (a *AzureVMWorkloadSAPAseSystemWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
		WorkloadItemType:     a.WorkloadItemType,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadSAPHanaDBInstance - Azure VM workload-specific protectable item representing SAP HANA Dbinstance.
type AzureVMWorkloadSAPHanaDBInstance struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool

	// Indicates if item is protectable
	IsProtectable *bool

	// Name for instance or AG
	ParentName *string

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPHanaDBInstance.
func (a *AzureVMWorkloadSAPHanaDBInstance) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		BackupManagementType:    a.BackupManagementType,
		FriendlyName:            a.FriendlyName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		IsProtectable:           a.IsProtectable,
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		Prebackupvalidation:     a.Prebackupvalidation,
		ProtectableItemType:     a.ProtectableItemType,
		ProtectionState:         a.ProtectionState,
		ServerName:              a.ServerName,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		WorkloadType:            a.WorkloadType,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPHanaDBInstance.
func (a *AzureVMWorkloadSAPHanaDBInstance) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectableItemType:  a.ProtectableItemType,
		ProtectionState:      a.ProtectionState,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadSAPHanaDBInstanceProtectedItem - Azure VM workload-specific protected item representing SAP HANA DBInstance.
type AzureVMWorkloadSAPHanaDBInstanceProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Additional information for this backup item.
	ExtendedInfo *AzureVMWorkloadProtectedItemExtendedInfo

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails

	// Error details in last backup
	LastBackupErrorDetail *ErrorDetail

	// Last backup operation status. Possible values: Healthy, Unhealthy.
	LastBackupStatus *LastBackupStatus

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// List of the nodes in case of distributed container.
	NodesList []*DistributedNodesInfo

	// Parent name of the DB such as Instance or Availability Group.
	ParentName *string

	// Parent type of protected item, example: for a DB, standalone server or distributed
	ParentType *string

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// Data ID of the protected item.
	ProtectedItemDataSourceID *string

	// Health status of the backup item, evaluated based on last heartbeat received
	ProtectedItemHealthStatus *ProtectedItemHealthStatus

	// Backup state of this backup item.
	ProtectionState *ProtectionState

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Host/Cluster Name for instance or AG
	ServerName *string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; Friendly name of the DB represented by this backup item.
	FriendlyName *string

	// READ-ONLY; Backup status of this backup item.
	ProtectionStatus *string

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetAzureVMWorkloadProtectedItem implements the AzureVMWorkloadProtectedItemClassification interface for type AzureVMWorkloadSAPHanaDBInstanceProtectedItem.
func (a *AzureVMWorkloadSAPHanaDBInstanceProtectedItem) GetAzureVMWorkloadProtectedItem() *AzureVMWorkloadProtectedItem {
	return &AzureVMWorkloadProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		ExtendedInfo:                     a.ExtendedInfo,
		FriendlyName:                     a.FriendlyName,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		KpisHealths:                      a.KpisHealths,
		LastBackupErrorDetail:            a.LastBackupErrorDetail,
		LastBackupStatus:                 a.LastBackupStatus,
		LastBackupTime:                   a.LastBackupTime,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		NodesList:                        a.NodesList,
		ParentName:                       a.ParentName,
		ParentType:                       a.ParentType,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemDataSourceID:        a.ProtectedItemDataSourceID,
		ProtectedItemHealthStatus:        a.ProtectedItemHealthStatus,
		ProtectedItemType:                a.ProtectedItemType,
		ProtectionState:                  a.ProtectionState,
		ProtectionStatus:                 a.ProtectionStatus,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		ServerName:                       a.ServerName,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureVMWorkloadSAPHanaDBInstanceProtectedItem.
func (a *AzureVMWorkloadSAPHanaDBInstanceProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemType:                a.ProtectedItemType,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// AzureVMWorkloadSAPHanaDatabaseProtectableItem - Azure VM workload-specific protectable item representing SAP HANA Database.
type AzureVMWorkloadSAPHanaDatabaseProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool

	// Indicates if item is protectable
	IsProtectable *bool

	// Name for instance or AG
	ParentName *string

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (a *AzureVMWorkloadSAPHanaDatabaseProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		BackupManagementType:    a.BackupManagementType,
		FriendlyName:            a.FriendlyName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		IsProtectable:           a.IsProtectable,
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		Prebackupvalidation:     a.Prebackupvalidation,
		ProtectableItemType:     a.ProtectableItemType,
		ProtectionState:         a.ProtectionState,
		ServerName:              a.ServerName,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		WorkloadType:            a.WorkloadType,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPHanaDatabaseProtectableItem.
func (a *AzureVMWorkloadSAPHanaDatabaseProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectableItemType:  a.ProtectableItemType,
		ProtectionState:      a.ProtectionState,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadSAPHanaDatabaseProtectedItem - Azure VM workload-specific protected item representing SAP HANA Database.
type AzureVMWorkloadSAPHanaDatabaseProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Additional information for this backup item.
	ExtendedInfo *AzureVMWorkloadProtectedItemExtendedInfo

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails

	// Error details in last backup
	LastBackupErrorDetail *ErrorDetail

	// Last backup operation status. Possible values: Healthy, Unhealthy.
	LastBackupStatus *LastBackupStatus

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// List of the nodes in case of distributed container.
	NodesList []*DistributedNodesInfo

	// Parent name of the DB such as Instance or Availability Group.
	ParentName *string

	// Parent type of protected item, example: for a DB, standalone server or distributed
	ParentType *string

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// Data ID of the protected item.
	ProtectedItemDataSourceID *string

	// Health status of the backup item, evaluated based on last heartbeat received
	ProtectedItemHealthStatus *ProtectedItemHealthStatus

	// Backup state of this backup item.
	ProtectionState *ProtectionState

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Host/Cluster Name for instance or AG
	ServerName *string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; Friendly name of the DB represented by this backup item.
	FriendlyName *string

	// READ-ONLY; Backup status of this backup item.
	ProtectionStatus *string

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetAzureVMWorkloadProtectedItem implements the AzureVMWorkloadProtectedItemClassification interface for type AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (a *AzureVMWorkloadSAPHanaDatabaseProtectedItem) GetAzureVMWorkloadProtectedItem() *AzureVMWorkloadProtectedItem {
	return &AzureVMWorkloadProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		ExtendedInfo:                     a.ExtendedInfo,
		FriendlyName:                     a.FriendlyName,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		KpisHealths:                      a.KpisHealths,
		LastBackupErrorDetail:            a.LastBackupErrorDetail,
		LastBackupStatus:                 a.LastBackupStatus,
		LastBackupTime:                   a.LastBackupTime,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		NodesList:                        a.NodesList,
		ParentName:                       a.ParentName,
		ParentType:                       a.ParentType,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemDataSourceID:        a.ProtectedItemDataSourceID,
		ProtectedItemHealthStatus:        a.ProtectedItemHealthStatus,
		ProtectedItemType:                a.ProtectedItemType,
		ProtectionState:                  a.ProtectionState,
		ProtectionStatus:                 a.ProtectionStatus,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		ServerName:                       a.ServerName,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureVMWorkloadSAPHanaDatabaseProtectedItem.
func (a *AzureVMWorkloadSAPHanaDatabaseProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemType:                a.ProtectedItemType,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// AzureVMWorkloadSAPHanaDatabaseWorkloadItem - Azure VM workload-specific workload item representing SAP HANA Database.
type AzureVMWorkloadSAPHanaDatabaseWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool

	// Name for instance or AG
	ParentName *string

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (a *AzureVMWorkloadSAPHanaDatabaseWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem {
	return &AzureVMWorkloadItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		IsAutoProtectable:    a.IsAutoProtectable,
		ParentName:           a.ParentName,
		ProtectionState:      a.ProtectionState,
		ServerName:           a.ServerName,
		SubWorkloadItemCount: a.SubWorkloadItemCount,
		Subinquireditemcount: a.Subinquireditemcount,
		WorkloadItemType:     a.WorkloadItemType,
		WorkloadType:         a.WorkloadType,
	}
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadSAPHanaDatabaseWorkloadItem.
func (a *AzureVMWorkloadSAPHanaDatabaseWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
		WorkloadItemType:     a.WorkloadItemType,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadSAPHanaHSRProtectableItem - Azure VM workload-specific protectable item representing HANA HSR.
type AzureVMWorkloadSAPHanaHSRProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool

	// Indicates if item is protectable
	IsProtectable *bool

	// Name for instance or AG
	ParentName *string

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPHanaHSRProtectableItem.
func (a *AzureVMWorkloadSAPHanaHSRProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		BackupManagementType:    a.BackupManagementType,
		FriendlyName:            a.FriendlyName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		IsProtectable:           a.IsProtectable,
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		Prebackupvalidation:     a.Prebackupvalidation,
		ProtectableItemType:     a.ProtectableItemType,
		ProtectionState:         a.ProtectionState,
		ServerName:              a.ServerName,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		WorkloadType:            a.WorkloadType,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPHanaHSRProtectableItem.
func (a *AzureVMWorkloadSAPHanaHSRProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectableItemType:  a.ProtectableItemType,
		ProtectionState:      a.ProtectionState,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadSAPHanaSystemProtectableItem - Azure VM workload-specific protectable item representing SAP HANA System.
type AzureVMWorkloadSAPHanaSystemProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool

	// Indicates if item is protectable
	IsProtectable *bool

	// Name for instance or AG
	ParentName *string

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPHanaSystemProtectableItem.
func (a *AzureVMWorkloadSAPHanaSystemProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		BackupManagementType:    a.BackupManagementType,
		FriendlyName:            a.FriendlyName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		IsProtectable:           a.IsProtectable,
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		Prebackupvalidation:     a.Prebackupvalidation,
		ProtectableItemType:     a.ProtectableItemType,
		ProtectionState:         a.ProtectionState,
		ServerName:              a.ServerName,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		WorkloadType:            a.WorkloadType,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSAPHanaSystemProtectableItem.
func (a *AzureVMWorkloadSAPHanaSystemProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectableItemType:  a.ProtectableItemType,
		ProtectionState:      a.ProtectionState,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadSAPHanaSystemWorkloadItem - Azure VM workload-specific workload item representing SAP HANA System.
type AzureVMWorkloadSAPHanaSystemWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool

	// Name for instance or AG
	ParentName *string

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (a *AzureVMWorkloadSAPHanaSystemWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem {
	return &AzureVMWorkloadItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		IsAutoProtectable:    a.IsAutoProtectable,
		ParentName:           a.ParentName,
		ProtectionState:      a.ProtectionState,
		ServerName:           a.ServerName,
		SubWorkloadItemCount: a.SubWorkloadItemCount,
		Subinquireditemcount: a.Subinquireditemcount,
		WorkloadItemType:     a.WorkloadItemType,
		WorkloadType:         a.WorkloadType,
	}
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadSAPHanaSystemWorkloadItem.
func (a *AzureVMWorkloadSAPHanaSystemWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
		WorkloadItemType:     a.WorkloadItemType,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadSQLAvailabilityGroupProtectableItem - Azure VM workload-specific protectable item representing SQL Availability
// Group.
type AzureVMWorkloadSQLAvailabilityGroupProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool

	// Indicates if item is protectable
	IsProtectable *bool

	// List of the nodes in case of distributed container.
	NodesList []*DistributedNodesInfo

	// Name for instance or AG
	ParentName *string

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (a *AzureVMWorkloadSQLAvailabilityGroupProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		BackupManagementType:    a.BackupManagementType,
		FriendlyName:            a.FriendlyName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		IsProtectable:           a.IsProtectable,
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		Prebackupvalidation:     a.Prebackupvalidation,
		ProtectableItemType:     a.ProtectableItemType,
		ProtectionState:         a.ProtectionState,
		ServerName:              a.ServerName,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		WorkloadType:            a.WorkloadType,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSQLAvailabilityGroupProtectableItem.
func (a *AzureVMWorkloadSQLAvailabilityGroupProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectableItemType:  a.ProtectableItemType,
		ProtectionState:      a.ProtectionState,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadSQLDatabaseProtectableItem - Azure VM workload-specific protectable item representing SQL Database.
type AzureVMWorkloadSQLDatabaseProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool

	// Indicates if item is protectable
	IsProtectable *bool

	// Name for instance or AG
	ParentName *string

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSQLDatabaseProtectableItem.
func (a *AzureVMWorkloadSQLDatabaseProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		BackupManagementType:    a.BackupManagementType,
		FriendlyName:            a.FriendlyName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		IsProtectable:           a.IsProtectable,
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		Prebackupvalidation:     a.Prebackupvalidation,
		ProtectableItemType:     a.ProtectableItemType,
		ProtectionState:         a.ProtectionState,
		ServerName:              a.ServerName,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		WorkloadType:            a.WorkloadType,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSQLDatabaseProtectableItem.
func (a *AzureVMWorkloadSQLDatabaseProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectableItemType:  a.ProtectableItemType,
		ProtectionState:      a.ProtectionState,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadSQLDatabaseProtectedItem - Azure VM workload-specific protected item representing SQL Database.
type AzureVMWorkloadSQLDatabaseProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Additional information for this backup item.
	ExtendedInfo *AzureVMWorkloadProtectedItemExtendedInfo

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Health details of different KPIs
	KpisHealths map[string]*KPIResourceHealthDetails

	// Error details in last backup
	LastBackupErrorDetail *ErrorDetail

	// Last backup operation status. Possible values: Healthy, Unhealthy.
	LastBackupStatus *LastBackupStatus

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// List of the nodes in case of distributed container.
	NodesList []*DistributedNodesInfo

	// Parent name of the DB such as Instance or Availability Group.
	ParentName *string

	// Parent type of protected item, example: for a DB, standalone server or distributed
	ParentType *string

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// Data ID of the protected item.
	ProtectedItemDataSourceID *string

	// Health status of the backup item, evaluated based on last heartbeat received
	ProtectedItemHealthStatus *ProtectedItemHealthStatus

	// Backup state of this backup item.
	ProtectionState *ProtectionState

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Host/Cluster Name for instance or AG
	ServerName *string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; Friendly name of the DB represented by this backup item.
	FriendlyName *string

	// READ-ONLY; Backup status of this backup item.
	ProtectionStatus *string

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetAzureVMWorkloadProtectedItem implements the AzureVMWorkloadProtectedItemClassification interface for type AzureVMWorkloadSQLDatabaseProtectedItem.
func (a *AzureVMWorkloadSQLDatabaseProtectedItem) GetAzureVMWorkloadProtectedItem() *AzureVMWorkloadProtectedItem {
	return &AzureVMWorkloadProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		ExtendedInfo:                     a.ExtendedInfo,
		FriendlyName:                     a.FriendlyName,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		KpisHealths:                      a.KpisHealths,
		LastBackupErrorDetail:            a.LastBackupErrorDetail,
		LastBackupStatus:                 a.LastBackupStatus,
		LastBackupTime:                   a.LastBackupTime,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		NodesList:                        a.NodesList,
		ParentName:                       a.ParentName,
		ParentType:                       a.ParentType,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemDataSourceID:        a.ProtectedItemDataSourceID,
		ProtectedItemHealthStatus:        a.ProtectedItemHealthStatus,
		ProtectedItemType:                a.ProtectedItemType,
		ProtectionState:                  a.ProtectionState,
		ProtectionStatus:                 a.ProtectionStatus,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		ServerName:                       a.ServerName,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// GetProtectedItem implements the ProtectedItemClassification interface for type AzureVMWorkloadSQLDatabaseProtectedItem.
func (a *AzureVMWorkloadSQLDatabaseProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		BackupManagementType:             a.BackupManagementType,
		BackupSetName:                    a.BackupSetName,
		ContainerName:                    a.ContainerName,
		CreateMode:                       a.CreateMode,
		DeferredDeleteTimeInUTC:          a.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      a.DeferredDeleteTimeRemaining,
		IsArchiveEnabled:                 a.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: a.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      a.IsRehydrate,
		IsScheduledForDeferredDelete:     a.IsScheduledForDeferredDelete,
		LastRecoveryPoint:                a.LastRecoveryPoint,
		PolicyID:                         a.PolicyID,
		PolicyName:                       a.PolicyName,
		ProtectedItemType:                a.ProtectedItemType,
		ResourceGuardOperationRequests:   a.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  a.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 a.SourceResourceID,
		VaultID:                          a.VaultID,
		WorkloadType:                     a.WorkloadType,
	}
}

// AzureVMWorkloadSQLDatabaseWorkloadItem - Azure VM workload-specific workload item representing SQL Database.
type AzureVMWorkloadSQLDatabaseWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool

	// Name for instance or AG
	ParentName *string

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadSQLDatabaseWorkloadItem.
func (a *AzureVMWorkloadSQLDatabaseWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem {
	return &AzureVMWorkloadItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		IsAutoProtectable:    a.IsAutoProtectable,
		ParentName:           a.ParentName,
		ProtectionState:      a.ProtectionState,
		ServerName:           a.ServerName,
		SubWorkloadItemCount: a.SubWorkloadItemCount,
		Subinquireditemcount: a.Subinquireditemcount,
		WorkloadItemType:     a.WorkloadItemType,
		WorkloadType:         a.WorkloadType,
	}
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadSQLDatabaseWorkloadItem.
func (a *AzureVMWorkloadSQLDatabaseWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
		WorkloadItemType:     a.WorkloadItemType,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadSQLInstanceProtectableItem - Azure VM workload-specific protectable item representing SQL Instance.
type AzureVMWorkloadSQLInstanceProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if protectable item is auto-protectable
	IsAutoProtectable *bool

	// Indicates if protectable item is auto-protected
	IsAutoProtected *bool

	// Indicates if item is protectable
	IsProtectable *bool

	// Name for instance or AG
	ParentName *string

	// Parent Unique Name is added to provide the service formatted URI Name of the Parent Only Applicable for data bases where
	// the parent would be either Instance or a SQL AG.
	ParentUniqueName *string

	// Pre-backup validation for protectable objects
	Prebackupvalidation *PreBackupValidation

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// For instance or AG, indicates number of DB's to be protected
	Subprotectableitemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadProtectableItem implements the AzureVMWorkloadProtectableItemClassification interface for type AzureVMWorkloadSQLInstanceProtectableItem.
func (a *AzureVMWorkloadSQLInstanceProtectableItem) GetAzureVMWorkloadProtectableItem() *AzureVMWorkloadProtectableItem {
	return &AzureVMWorkloadProtectableItem{
		BackupManagementType:    a.BackupManagementType,
		FriendlyName:            a.FriendlyName,
		IsAutoProtectable:       a.IsAutoProtectable,
		IsAutoProtected:         a.IsAutoProtected,
		IsProtectable:           a.IsProtectable,
		ParentName:              a.ParentName,
		ParentUniqueName:        a.ParentUniqueName,
		Prebackupvalidation:     a.Prebackupvalidation,
		ProtectableItemType:     a.ProtectableItemType,
		ProtectionState:         a.ProtectionState,
		ServerName:              a.ServerName,
		Subinquireditemcount:    a.Subinquireditemcount,
		Subprotectableitemcount: a.Subprotectableitemcount,
		WorkloadType:            a.WorkloadType,
	}
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type AzureVMWorkloadSQLInstanceProtectableItem.
func (a *AzureVMWorkloadSQLInstanceProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectableItemType:  a.ProtectableItemType,
		ProtectionState:      a.ProtectionState,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureVMWorkloadSQLInstanceWorkloadItem - Azure VM workload-specific workload item representing SQL Instance.
type AzureVMWorkloadSQLInstanceWorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Data Directory Paths for default directories
	DataDirectoryPaths []*SQLDataDirectory

	// Friendly name of the backup item.
	FriendlyName *string

	// Indicates if workload item is auto-protectable
	IsAutoProtectable *bool

	// Name for instance or AG
	ParentName *string

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Host/Cluster Name for instance or AG
	ServerName *string

	// For instance or AG, indicates number of DB's to be protected
	SubWorkloadItemCount *int32

	// For instance or AG, indicates number of DB's present
	Subinquireditemcount *int32

	// Type of workload for the backup management
	WorkloadType *string
}

// GetAzureVMWorkloadItem implements the AzureVMWorkloadItemClassification interface for type AzureVMWorkloadSQLInstanceWorkloadItem.
func (a *AzureVMWorkloadSQLInstanceWorkloadItem) GetAzureVMWorkloadItem() *AzureVMWorkloadItem {
	return &AzureVMWorkloadItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		IsAutoProtectable:    a.IsAutoProtectable,
		ParentName:           a.ParentName,
		ProtectionState:      a.ProtectionState,
		ServerName:           a.ServerName,
		SubWorkloadItemCount: a.SubWorkloadItemCount,
		Subinquireditemcount: a.Subinquireditemcount,
		WorkloadItemType:     a.WorkloadItemType,
		WorkloadType:         a.WorkloadType,
	}
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type AzureVMWorkloadSQLInstanceWorkloadItem.
func (a *AzureVMWorkloadSQLInstanceWorkloadItem) GetWorkloadItem() *WorkloadItem {
	return &WorkloadItem{
		BackupManagementType: a.BackupManagementType,
		FriendlyName:         a.FriendlyName,
		ProtectionState:      a.ProtectionState,
		WorkloadItemType:     a.WorkloadItemType,
		WorkloadType:         a.WorkloadType,
	}
}

// AzureWorkloadAutoProtectionIntent - Azure Recovery Services Vault specific protection intent item.
type AzureWorkloadAutoProtectionIntent struct {
	// REQUIRED; backup protectionIntent type.
	ProtectionIntentItemType *ProtectionIntentItemType

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Backup state of this backup item.
	ProtectionState *ProtectionStatus

	// ARM ID of the resource to be backed up.
	SourceResourceID *string
}

// GetAzureRecoveryServiceVaultProtectionIntent implements the AzureRecoveryServiceVaultProtectionIntentClassification interface
// for type AzureWorkloadAutoProtectionIntent.
func (a *AzureWorkloadAutoProtectionIntent) GetAzureRecoveryServiceVaultProtectionIntent() *AzureRecoveryServiceVaultProtectionIntent {
	return &AzureRecoveryServiceVaultProtectionIntent{
		BackupManagementType:     a.BackupManagementType,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		ProtectionState:          a.ProtectionState,
		SourceResourceID:         a.SourceResourceID,
	}
}

// GetAzureWorkloadAutoProtectionIntent implements the AzureWorkloadAutoProtectionIntentClassification interface for type
// AzureWorkloadAutoProtectionIntent.
func (a *AzureWorkloadAutoProtectionIntent) GetAzureWorkloadAutoProtectionIntent() *AzureWorkloadAutoProtectionIntent {
	return a
}

// GetProtectionIntent implements the ProtectionIntentClassification interface for type AzureWorkloadAutoProtectionIntent.
func (a *AzureWorkloadAutoProtectionIntent) GetProtectionIntent() *ProtectionIntent {
	return &ProtectionIntent{
		BackupManagementType:     a.BackupManagementType,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		ProtectionState:          a.ProtectionState,
		SourceResourceID:         a.SourceResourceID,
	}
}

// AzureWorkloadBackupRequest - AzureWorkload workload-specific backup request.
type AzureWorkloadBackupRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Type of backup, viz. Full, Differential, Log or CopyOnlyFull
	BackupType *BackupType

	// Bool for Compression setting
	EnableCompression *bool

	// Backup copy will expire after the time specified (UTC).
	RecoveryPointExpiryTimeInUTC *time.Time
}

// GetBackupRequest implements the BackupRequestClassification interface for type AzureWorkloadBackupRequest.
func (a *AzureWorkloadBackupRequest) GetBackupRequest() *BackupRequest {
	return &BackupRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadContainer - Container for the workloads running inside Azure Compute or Classic Compute.
type AzureWorkloadContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Additional details of a workload container.
	ExtendedInfo *AzureWorkloadContainerExtendedInfo

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string

	// Time stamp when this container was updated.
	LastUpdatedTime *time.Time

	// Re-Do Operation
	OperationType *OperationType

	// Type of the protectable object associated with this container
	ProtectableObjectType *string

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string

	// ARM ID of the virtual machine represented by this Azure Workload Container
	SourceResourceID *string

	// Workload type for which registration was sent.
	WorkloadType *WorkloadType
}

// GetAzureWorkloadContainer implements the AzureWorkloadContainerClassification interface for type AzureWorkloadContainer.
func (a *AzureWorkloadContainer) GetAzureWorkloadContainer() *AzureWorkloadContainer { return a }

// GetProtectionContainer implements the ProtectionContainerClassification interface for type AzureWorkloadContainer.
func (a *AzureWorkloadContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		BackupManagementType:  a.BackupManagementType,
		ContainerType:         a.ContainerType,
		FriendlyName:          a.FriendlyName,
		HealthStatus:          a.HealthStatus,
		ProtectableObjectType: a.ProtectableObjectType,
		RegistrationStatus:    a.RegistrationStatus,
	}
}

// AzureWorkloadContainerAutoProtectionIntent - Azure workload specific protection intent item.
type AzureWorkloadContainerAutoProtectionIntent struct {
	// REQUIRED; backup protectionIntent type.
	ProtectionIntentItemType *ProtectionIntentItemType

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Backup state of this backup item.
	ProtectionState *ProtectionStatus

	// ARM ID of the resource to be backed up.
	SourceResourceID *string
}

// GetProtectionIntent implements the ProtectionIntentClassification interface for type AzureWorkloadContainerAutoProtectionIntent.
func (a *AzureWorkloadContainerAutoProtectionIntent) GetProtectionIntent() *ProtectionIntent {
	return &ProtectionIntent{
		BackupManagementType:     a.BackupManagementType,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		ProtectionState:          a.ProtectionState,
		SourceResourceID:         a.SourceResourceID,
	}
}

// AzureWorkloadContainerExtendedInfo - Extended information of the container.
type AzureWorkloadContainerExtendedInfo struct {
	// Host Os Name in case of Stand Alone and Cluster Name in case of distributed container.
	HostServerName *string

	// Inquiry Status for the container.
	InquiryInfo *InquiryInfo

	// List of the nodes in case of distributed container.
	NodesList []*DistributedNodesInfo
}

// AzureWorkloadErrorInfo - Azure storage specific error information
type AzureWorkloadErrorInfo struct {
	// Additional details for above error code.
	AdditionalDetails *string

	// Error code.
	ErrorCode *int32

	// Localized error string.
	ErrorString *string

	// Title: Typically, the entity that the error pertains to.
	ErrorTitle *string

	// List of localized recommendations for above error code.
	Recommendations []*string
}

// AzureWorkloadJob - Azure storage specific job.
type AzureWorkloadJob struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string

	// Gets or sets the state/actions applicable on this job like cancel/retry.
	ActionsInfo []*JobSupportedAction

	// ActivityId of job.
	ActivityID *string

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType

	// Time elapsed during the execution of this job.
	Duration *string

	// The end time.
	EndTime *time.Time

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string

	// Error details on execution of this job.
	ErrorDetails []*AzureWorkloadErrorInfo

	// Additional information about the job.
	ExtendedInfo *AzureWorkloadJobExtendedInfo

	// The operation name.
	Operation *string

	// The start time.
	StartTime *time.Time

	// Job status.
	Status *string

	// Workload type of the job
	WorkloadType *string
}

// GetJob implements the JobClassification interface for type AzureWorkloadJob.
func (a *AzureWorkloadJob) GetJob() *Job {
	return &Job{
		ActivityID:           a.ActivityID,
		BackupManagementType: a.BackupManagementType,
		EndTime:              a.EndTime,
		EntityFriendlyName:   a.EntityFriendlyName,
		JobType:              a.JobType,
		Operation:            a.Operation,
		StartTime:            a.StartTime,
		Status:               a.Status,
	}
}

// AzureWorkloadJobExtendedInfo - Azure VM workload-specific additional information for job.
type AzureWorkloadJobExtendedInfo struct {
	// Non localized error message on job execution.
	DynamicErrorMessage *string

	// Job properties.
	PropertyBag map[string]*string

	// List of tasks for this job
	TasksList []*AzureWorkloadJobTaskDetails
}

// AzureWorkloadJobTaskDetails - Azure VM workload specific job task details.
type AzureWorkloadJobTaskDetails struct {
	// The status.
	Status *string

	// The task display name.
	TaskID *string
}

// AzureWorkloadPointInTimeRecoveryPoint - Recovery point specific to PointInTime
type AzureWorkloadPointInTimeRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo

	// Properties of Recovery Point
	RecoveryPointProperties *RecoveryPointProperties

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2

	// UTC time at which recovery point was created
	RecoveryPointTimeInUTC *time.Time

	// List of log ranges
	TimeRanges []*PointInTimeRange

	// Type of restore point
	Type *RestorePointType
}

// GetAzureWorkloadPointInTimeRecoveryPoint implements the AzureWorkloadPointInTimeRecoveryPointClassification interface for
// type AzureWorkloadPointInTimeRecoveryPoint.
func (a *AzureWorkloadPointInTimeRecoveryPoint) GetAzureWorkloadPointInTimeRecoveryPoint() *AzureWorkloadPointInTimeRecoveryPoint {
	return a
}

// GetAzureWorkloadRecoveryPoint implements the AzureWorkloadRecoveryPointClassification interface for type AzureWorkloadPointInTimeRecoveryPoint.
func (a *AzureWorkloadPointInTimeRecoveryPoint) GetAzureWorkloadRecoveryPoint() *AzureWorkloadRecoveryPoint {
	return &AzureWorkloadRecoveryPoint{
		ObjectType:                     a.ObjectType,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		RecoveryPointProperties:        a.RecoveryPointProperties,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		Type:                           a.Type,
	}
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureWorkloadPointInTimeRecoveryPoint.
func (a *AzureWorkloadPointInTimeRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadPointInTimeRestoreRequest - AzureWorkload SAP Hana -specific restore. Specifically for PointInTime/Log restore
type AzureWorkloadPointInTimeRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// PointInTime value
	PointInTime *time.Time

	// Workload specific property bag.
	PropertyBag map[string]*string

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode

	// Type of this recovery.
	RecoveryType *RecoveryType

	// Additional details for snapshot recovery Currently used for snapshot for SAP Hana.
	SnapshotRestoreParameters *SnapshotRestoreParameters

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string

	// Details of target database
	TargetInfo *TargetRestoreInfo

	// Defines the Resource group of the Target VM
	TargetResourceGroupName *string

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string

	// User Assigned managed identity details Currently used for snapshot.
	UserAssignedManagedIdentityDetails *UserAssignedManagedIdentityDetails
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadPointInTimeRestoreRequest.
func (a *AzureWorkloadPointInTimeRestoreRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadPointInTimeRestoreRequest.
func (a *AzureWorkloadPointInTimeRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadRecoveryPoint - Workload specific recovery point, specifically encapsulates full/diff recovery point
type AzureWorkloadRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo

	// Properties of Recovery Point
	RecoveryPointProperties *RecoveryPointProperties

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2

	// UTC time at which recovery point was created
	RecoveryPointTimeInUTC *time.Time

	// Type of restore point
	Type *RestorePointType
}

// GetAzureWorkloadRecoveryPoint implements the AzureWorkloadRecoveryPointClassification interface for type AzureWorkloadRecoveryPoint.
func (a *AzureWorkloadRecoveryPoint) GetAzureWorkloadRecoveryPoint() *AzureWorkloadRecoveryPoint {
	return a
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureWorkloadRecoveryPoint.
func (a *AzureWorkloadRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadRestoreRequest - AzureWorkload-specific restore.
type AzureWorkloadRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Workload specific property bag.
	PropertyBag map[string]*string

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode

	// Type of this recovery.
	RecoveryType *RecoveryType

	// Additional details for snapshot recovery Currently used for snapshot for SAP Hana.
	SnapshotRestoreParameters *SnapshotRestoreParameters

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string

	// Details of target database
	TargetInfo *TargetRestoreInfo

	// Defines the Resource group of the Target VM
	TargetResourceGroupName *string

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string

	// User Assigned managed identity details Currently used for snapshot.
	UserAssignedManagedIdentityDetails *UserAssignedManagedIdentityDetails
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadRestoreRequest.
func (a *AzureWorkloadRestoreRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return a
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadRestoreRequest.
func (a *AzureWorkloadRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSAPHanaPointInTimeRecoveryPoint - Recovery point specific to PointInTime in SAPHana
type AzureWorkloadSAPHanaPointInTimeRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo

	// Properties of Recovery Point
	RecoveryPointProperties *RecoveryPointProperties

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2

	// UTC time at which recovery point was created
	RecoveryPointTimeInUTC *time.Time

	// List of log ranges
	TimeRanges []*PointInTimeRange

	// Type of restore point
	Type *RestorePointType
}

// GetAzureWorkloadPointInTimeRecoveryPoint implements the AzureWorkloadPointInTimeRecoveryPointClassification interface for
// type AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (a *AzureWorkloadSAPHanaPointInTimeRecoveryPoint) GetAzureWorkloadPointInTimeRecoveryPoint() *AzureWorkloadPointInTimeRecoveryPoint {
	return &AzureWorkloadPointInTimeRecoveryPoint{
		ObjectType:                     a.ObjectType,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		RecoveryPointProperties:        a.RecoveryPointProperties,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		TimeRanges:                     a.TimeRanges,
		Type:                           a.Type,
	}
}

// GetAzureWorkloadRecoveryPoint implements the AzureWorkloadRecoveryPointClassification interface for type AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (a *AzureWorkloadSAPHanaPointInTimeRecoveryPoint) GetAzureWorkloadRecoveryPoint() *AzureWorkloadRecoveryPoint {
	return &AzureWorkloadRecoveryPoint{
		ObjectType:                     a.ObjectType,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		RecoveryPointProperties:        a.RecoveryPointProperties,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		Type:                           a.Type,
	}
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureWorkloadSAPHanaPointInTimeRecoveryPoint.
func (a *AzureWorkloadSAPHanaPointInTimeRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSAPHanaPointInTimeRestoreRequest - AzureWorkload SAP Hana -specific restore. Specifically for PointInTime/Log
// restore
type AzureWorkloadSAPHanaPointInTimeRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// PointInTime value
	PointInTime *time.Time

	// Workload specific property bag.
	PropertyBag map[string]*string

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode

	// Type of this recovery.
	RecoveryType *RecoveryType

	// Additional details for snapshot recovery Currently used for snapshot for SAP Hana.
	SnapshotRestoreParameters *SnapshotRestoreParameters

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string

	// Details of target database
	TargetInfo *TargetRestoreInfo

	// Defines the Resource group of the Target VM
	TargetResourceGroupName *string

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string

	// User Assigned managed identity details Currently used for snapshot.
	UserAssignedManagedIdentityDetails *UserAssignedManagedIdentityDetails
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetAzureWorkloadSAPHanaPointInTimeRestoreRequest implements the AzureWorkloadSAPHanaPointInTimeRestoreRequestClassification
// interface for type AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreRequest) GetAzureWorkloadSAPHanaPointInTimeRestoreRequest() *AzureWorkloadSAPHanaPointInTimeRestoreRequest {
	return a
}

// GetAzureWorkloadSAPHanaRestoreRequest implements the AzureWorkloadSAPHanaRestoreRequestClassification interface for type
// AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreRequest) GetAzureWorkloadSAPHanaRestoreRequest() *AzureWorkloadSAPHanaRestoreRequest {
	return &AzureWorkloadSAPHanaRestoreRequest{
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSAPHanaPointInTimeRestoreRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest - AzureWorkload SAP Hana-specific restore with integrated rehydration
// of recovery point.
type AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// PointInTime value
	PointInTime *time.Time

	// Workload specific property bag.
	PropertyBag map[string]*string

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode

	// RP Rehydration Info
	RecoveryPointRehydrationInfo *RecoveryPointRehydrationInfo

	// Type of this recovery.
	RecoveryType *RecoveryType

	// Additional details for snapshot recovery Currently used for snapshot for SAP Hana.
	SnapshotRestoreParameters *SnapshotRestoreParameters

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string

	// Details of target database
	TargetInfo *TargetRestoreInfo

	// Defines the Resource group of the Target VM
	TargetResourceGroupName *string

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string

	// User Assigned managed identity details Currently used for snapshot.
	UserAssignedManagedIdentityDetails *UserAssignedManagedIdentityDetails
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetAzureWorkloadSAPHanaPointInTimeRestoreRequest implements the AzureWorkloadSAPHanaPointInTimeRestoreRequestClassification
// interface for type AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest) GetAzureWorkloadSAPHanaPointInTimeRestoreRequest() *AzureWorkloadSAPHanaPointInTimeRestoreRequest {
	return &AzureWorkloadSAPHanaPointInTimeRestoreRequest{
		ObjectType:                         a.ObjectType,
		PointInTime:                        a.PointInTime,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetAzureWorkloadSAPHanaRestoreRequest implements the AzureWorkloadSAPHanaRestoreRequestClassification interface for type
// AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest) GetAzureWorkloadSAPHanaRestoreRequest() *AzureWorkloadSAPHanaRestoreRequest {
	return &AzureWorkloadSAPHanaRestoreRequest{
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSAPHanaRecoveryPoint - SAPHana specific recoverypoint, specifically encapsulates full/diff recoverypoints
type AzureWorkloadSAPHanaRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo

	// Properties of Recovery Point
	RecoveryPointProperties *RecoveryPointProperties

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2

	// UTC time at which recovery point was created
	RecoveryPointTimeInUTC *time.Time

	// Type of restore point
	Type *RestorePointType
}

// GetAzureWorkloadRecoveryPoint implements the AzureWorkloadRecoveryPointClassification interface for type AzureWorkloadSAPHanaRecoveryPoint.
func (a *AzureWorkloadSAPHanaRecoveryPoint) GetAzureWorkloadRecoveryPoint() *AzureWorkloadRecoveryPoint {
	return &AzureWorkloadRecoveryPoint{
		ObjectType:                     a.ObjectType,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		RecoveryPointProperties:        a.RecoveryPointProperties,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		Type:                           a.Type,
	}
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureWorkloadSAPHanaRecoveryPoint.
func (a *AzureWorkloadSAPHanaRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSAPHanaRestoreRequest - AzureWorkload SAP Hana-specific restore.
type AzureWorkloadSAPHanaRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Workload specific property bag.
	PropertyBag map[string]*string

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode

	// Type of this recovery.
	RecoveryType *RecoveryType

	// Additional details for snapshot recovery Currently used for snapshot for SAP Hana.
	SnapshotRestoreParameters *SnapshotRestoreParameters

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string

	// Details of target database
	TargetInfo *TargetRestoreInfo

	// Defines the Resource group of the Target VM
	TargetResourceGroupName *string

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string

	// User Assigned managed identity details Currently used for snapshot.
	UserAssignedManagedIdentityDetails *UserAssignedManagedIdentityDetails
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSAPHanaRestoreRequest.
func (a *AzureWorkloadSAPHanaRestoreRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetAzureWorkloadSAPHanaRestoreRequest implements the AzureWorkloadSAPHanaRestoreRequestClassification interface for type
// AzureWorkloadSAPHanaRestoreRequest.
func (a *AzureWorkloadSAPHanaRestoreRequest) GetAzureWorkloadSAPHanaRestoreRequest() *AzureWorkloadSAPHanaRestoreRequest {
	return a
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSAPHanaRestoreRequest.
func (a *AzureWorkloadSAPHanaRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSAPHanaRestoreWithRehydrateRequest - AzureWorkload SAP Hana-specific restore with integrated rehydration of
// recovery point.
type AzureWorkloadSAPHanaRestoreWithRehydrateRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Workload specific property bag.
	PropertyBag map[string]*string

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode

	// RP Rehydration Info
	RecoveryPointRehydrationInfo *RecoveryPointRehydrationInfo

	// Type of this recovery.
	RecoveryType *RecoveryType

	// Additional details for snapshot recovery Currently used for snapshot for SAP Hana.
	SnapshotRestoreParameters *SnapshotRestoreParameters

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string

	// Details of target database
	TargetInfo *TargetRestoreInfo

	// Defines the Resource group of the Target VM
	TargetResourceGroupName *string

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string

	// User Assigned managed identity details Currently used for snapshot.
	UserAssignedManagedIdentityDetails *UserAssignedManagedIdentityDetails
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSAPHanaRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaRestoreWithRehydrateRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetAzureWorkloadSAPHanaRestoreRequest implements the AzureWorkloadSAPHanaRestoreRequestClassification interface for type
// AzureWorkloadSAPHanaRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaRestoreWithRehydrateRequest) GetAzureWorkloadSAPHanaRestoreRequest() *AzureWorkloadSAPHanaRestoreRequest {
	return &AzureWorkloadSAPHanaRestoreRequest{
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSAPHanaRestoreWithRehydrateRequest.
func (a *AzureWorkloadSAPHanaRestoreWithRehydrateRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSQLAutoProtectionIntent - Azure Workload SQL Auto Protection intent item.
type AzureWorkloadSQLAutoProtectionIntent struct {
	// REQUIRED; backup protectionIntent type.
	ProtectionIntentItemType *ProtectionIntentItemType

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Backup state of this backup item.
	ProtectionState *ProtectionStatus

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// Workload item type of the item for which intent is to be set
	WorkloadItemType *WorkloadItemType
}

// GetAzureRecoveryServiceVaultProtectionIntent implements the AzureRecoveryServiceVaultProtectionIntentClassification interface
// for type AzureWorkloadSQLAutoProtectionIntent.
func (a *AzureWorkloadSQLAutoProtectionIntent) GetAzureRecoveryServiceVaultProtectionIntent() *AzureRecoveryServiceVaultProtectionIntent {
	return &AzureRecoveryServiceVaultProtectionIntent{
		BackupManagementType:     a.BackupManagementType,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		ProtectionState:          a.ProtectionState,
		SourceResourceID:         a.SourceResourceID,
	}
}

// GetAzureWorkloadAutoProtectionIntent implements the AzureWorkloadAutoProtectionIntentClassification interface for type
// AzureWorkloadSQLAutoProtectionIntent.
func (a *AzureWorkloadSQLAutoProtectionIntent) GetAzureWorkloadAutoProtectionIntent() *AzureWorkloadAutoProtectionIntent {
	return &AzureWorkloadAutoProtectionIntent{
		BackupManagementType:     a.BackupManagementType,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		ProtectionState:          a.ProtectionState,
		SourceResourceID:         a.SourceResourceID,
	}
}

// GetProtectionIntent implements the ProtectionIntentClassification interface for type AzureWorkloadSQLAutoProtectionIntent.
func (a *AzureWorkloadSQLAutoProtectionIntent) GetProtectionIntent() *ProtectionIntent {
	return &ProtectionIntent{
		BackupManagementType:     a.BackupManagementType,
		ItemID:                   a.ItemID,
		PolicyID:                 a.PolicyID,
		ProtectionIntentItemType: a.ProtectionIntentItemType,
		ProtectionState:          a.ProtectionState,
		SourceResourceID:         a.SourceResourceID,
	}
}

// AzureWorkloadSQLPointInTimeRecoveryPoint - Recovery point specific to PointInTime
type AzureWorkloadSQLPointInTimeRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Extended Info that provides data directory details. Will be populated in two cases: When a specific recovery point is accessed
	// using GetRecoveryPoint Or when ListRecoveryPoints is called for Log RP
	// only with ExtendedInfo query filter
	ExtendedInfo *AzureWorkloadSQLRecoveryPointExtendedInfo

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo

	// Properties of Recovery Point
	RecoveryPointProperties *RecoveryPointProperties

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2

	// UTC time at which recovery point was created
	RecoveryPointTimeInUTC *time.Time

	// List of log ranges
	TimeRanges []*PointInTimeRange

	// Type of restore point
	Type *RestorePointType
}

// GetAzureWorkloadRecoveryPoint implements the AzureWorkloadRecoveryPointClassification interface for type AzureWorkloadSQLPointInTimeRecoveryPoint.
func (a *AzureWorkloadSQLPointInTimeRecoveryPoint) GetAzureWorkloadRecoveryPoint() *AzureWorkloadRecoveryPoint {
	return &AzureWorkloadRecoveryPoint{
		ObjectType:                     a.ObjectType,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		RecoveryPointProperties:        a.RecoveryPointProperties,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		Type:                           a.Type,
	}
}

// GetAzureWorkloadSQLRecoveryPoint implements the AzureWorkloadSQLRecoveryPointClassification interface for type AzureWorkloadSQLPointInTimeRecoveryPoint.
func (a *AzureWorkloadSQLPointInTimeRecoveryPoint) GetAzureWorkloadSQLRecoveryPoint() *AzureWorkloadSQLRecoveryPoint {
	return &AzureWorkloadSQLRecoveryPoint{
		ExtendedInfo:                   a.ExtendedInfo,
		ObjectType:                     a.ObjectType,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		RecoveryPointProperties:        a.RecoveryPointProperties,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		Type:                           a.Type,
	}
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureWorkloadSQLPointInTimeRecoveryPoint.
func (a *AzureWorkloadSQLPointInTimeRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSQLPointInTimeRestoreRequest - AzureWorkload SQL -specific restore. Specifically for PointInTime/Log restore
type AzureWorkloadSQLPointInTimeRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Data directory details
	AlternateDirectoryPaths []*SQLDataDirectoryMapping

	// SQL specific property where user can chose to set no-recovery when restore operation is tried
	IsNonRecoverable *bool

	// PointInTime value
	PointInTime *time.Time

	// Workload specific property bag.
	PropertyBag map[string]*string

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode

	// Type of this recovery.
	RecoveryType *RecoveryType

	// Default option set to true. If this is set to false, alternate data directory must be provided
	ShouldUseAlternateTargetLocation *bool

	// Additional details for snapshot recovery Currently used for snapshot for SAP Hana.
	SnapshotRestoreParameters *SnapshotRestoreParameters

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string

	// Details of target database
	TargetInfo *TargetRestoreInfo

	// Defines the Resource group of the Target VM
	TargetResourceGroupName *string

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string

	// User Assigned managed identity details Currently used for snapshot.
	UserAssignedManagedIdentityDetails *UserAssignedManagedIdentityDetails
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSQLPointInTimeRestoreRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetAzureWorkloadSQLPointInTimeRestoreRequest implements the AzureWorkloadSQLPointInTimeRestoreRequestClassification interface
// for type AzureWorkloadSQLPointInTimeRestoreRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreRequest) GetAzureWorkloadSQLPointInTimeRestoreRequest() *AzureWorkloadSQLPointInTimeRestoreRequest {
	return a
}

// GetAzureWorkloadSQLRestoreRequest implements the AzureWorkloadSQLRestoreRequestClassification interface for type AzureWorkloadSQLPointInTimeRestoreRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreRequest) GetAzureWorkloadSQLRestoreRequest() *AzureWorkloadSQLRestoreRequest {
	return &AzureWorkloadSQLRestoreRequest{
		AlternateDirectoryPaths:            a.AlternateDirectoryPaths,
		IsNonRecoverable:                   a.IsNonRecoverable,
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		ShouldUseAlternateTargetLocation:   a.ShouldUseAlternateTargetLocation,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSQLPointInTimeRestoreRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest - AzureWorkload SQL-specific restore with integrated rehydration
// of recovery point.
type AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Data directory details
	AlternateDirectoryPaths []*SQLDataDirectoryMapping

	// SQL specific property where user can chose to set no-recovery when restore operation is tried
	IsNonRecoverable *bool

	// PointInTime value
	PointInTime *time.Time

	// Workload specific property bag.
	PropertyBag map[string]*string

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode

	// RP Rehydration Info
	RecoveryPointRehydrationInfo *RecoveryPointRehydrationInfo

	// Type of this recovery.
	RecoveryType *RecoveryType

	// Default option set to true. If this is set to false, alternate data directory must be provided
	ShouldUseAlternateTargetLocation *bool

	// Additional details for snapshot recovery Currently used for snapshot for SAP Hana.
	SnapshotRestoreParameters *SnapshotRestoreParameters

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string

	// Details of target database
	TargetInfo *TargetRestoreInfo

	// Defines the Resource group of the Target VM
	TargetResourceGroupName *string

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string

	// User Assigned managed identity details Currently used for snapshot.
	UserAssignedManagedIdentityDetails *UserAssignedManagedIdentityDetails
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetAzureWorkloadSQLPointInTimeRestoreRequest implements the AzureWorkloadSQLPointInTimeRestoreRequestClassification interface
// for type AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest) GetAzureWorkloadSQLPointInTimeRestoreRequest() *AzureWorkloadSQLPointInTimeRestoreRequest {
	return &AzureWorkloadSQLPointInTimeRestoreRequest{
		AlternateDirectoryPaths:            a.AlternateDirectoryPaths,
		IsNonRecoverable:                   a.IsNonRecoverable,
		ObjectType:                         a.ObjectType,
		PointInTime:                        a.PointInTime,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		ShouldUseAlternateTargetLocation:   a.ShouldUseAlternateTargetLocation,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetAzureWorkloadSQLRestoreRequest implements the AzureWorkloadSQLRestoreRequestClassification interface for type AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest) GetAzureWorkloadSQLRestoreRequest() *AzureWorkloadSQLRestoreRequest {
	return &AzureWorkloadSQLRestoreRequest{
		AlternateDirectoryPaths:            a.AlternateDirectoryPaths,
		IsNonRecoverable:                   a.IsNonRecoverable,
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		ShouldUseAlternateTargetLocation:   a.ShouldUseAlternateTargetLocation,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSQLRecoveryPoint - SQL specific recoverypoint, specifically encapsulates full/diff recoverypoint along with
// extended info
type AzureWorkloadSQLRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Extended Info that provides data directory details. Will be populated in two cases: When a specific recovery point is accessed
	// using GetRecoveryPoint Or when ListRecoveryPoints is called for Log RP
	// only with ExtendedInfo query filter
	ExtendedInfo *AzureWorkloadSQLRecoveryPointExtendedInfo

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo

	// Properties of Recovery Point
	RecoveryPointProperties *RecoveryPointProperties

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2

	// UTC time at which recovery point was created
	RecoveryPointTimeInUTC *time.Time

	// Type of restore point
	Type *RestorePointType
}

// GetAzureWorkloadRecoveryPoint implements the AzureWorkloadRecoveryPointClassification interface for type AzureWorkloadSQLRecoveryPoint.
func (a *AzureWorkloadSQLRecoveryPoint) GetAzureWorkloadRecoveryPoint() *AzureWorkloadRecoveryPoint {
	return &AzureWorkloadRecoveryPoint{
		ObjectType:                     a.ObjectType,
		RecoveryPointMoveReadinessInfo: a.RecoveryPointMoveReadinessInfo,
		RecoveryPointProperties:        a.RecoveryPointProperties,
		RecoveryPointTierDetails:       a.RecoveryPointTierDetails,
		RecoveryPointTimeInUTC:         a.RecoveryPointTimeInUTC,
		Type:                           a.Type,
	}
}

// GetAzureWorkloadSQLRecoveryPoint implements the AzureWorkloadSQLRecoveryPointClassification interface for type AzureWorkloadSQLRecoveryPoint.
func (a *AzureWorkloadSQLRecoveryPoint) GetAzureWorkloadSQLRecoveryPoint() *AzureWorkloadSQLRecoveryPoint {
	return a
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type AzureWorkloadSQLRecoveryPoint.
func (a *AzureWorkloadSQLRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSQLRecoveryPointExtendedInfo - Extended info class details
type AzureWorkloadSQLRecoveryPointExtendedInfo struct {
	// List of data directory paths during restore operation.
	DataDirectoryPaths []*SQLDataDirectory

	// UTC time at which data directory info was captured
	DataDirectoryTimeInUTC *time.Time
}

// AzureWorkloadSQLRestoreRequest - AzureWorkload SQL -specific restore. Specifically for full/diff restore
type AzureWorkloadSQLRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Data directory details
	AlternateDirectoryPaths []*SQLDataDirectoryMapping

	// SQL specific property where user can chose to set no-recovery when restore operation is tried
	IsNonRecoverable *bool

	// Workload specific property bag.
	PropertyBag map[string]*string

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode

	// Type of this recovery.
	RecoveryType *RecoveryType

	// Default option set to true. If this is set to false, alternate data directory must be provided
	ShouldUseAlternateTargetLocation *bool

	// Additional details for snapshot recovery Currently used for snapshot for SAP Hana.
	SnapshotRestoreParameters *SnapshotRestoreParameters

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string

	// Details of target database
	TargetInfo *TargetRestoreInfo

	// Defines the Resource group of the Target VM
	TargetResourceGroupName *string

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string

	// User Assigned managed identity details Currently used for snapshot.
	UserAssignedManagedIdentityDetails *UserAssignedManagedIdentityDetails
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSQLRestoreRequest.
func (a *AzureWorkloadSQLRestoreRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetAzureWorkloadSQLRestoreRequest implements the AzureWorkloadSQLRestoreRequestClassification interface for type AzureWorkloadSQLRestoreRequest.
func (a *AzureWorkloadSQLRestoreRequest) GetAzureWorkloadSQLRestoreRequest() *AzureWorkloadSQLRestoreRequest {
	return a
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSQLRestoreRequest.
func (a *AzureWorkloadSQLRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// AzureWorkloadSQLRestoreWithRehydrateRequest - AzureWorkload SQL-specific restore with integrated rehydration of recovery
// point
type AzureWorkloadSQLRestoreWithRehydrateRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Data directory details
	AlternateDirectoryPaths []*SQLDataDirectoryMapping

	// SQL specific property where user can chose to set no-recovery when restore operation is tried
	IsNonRecoverable *bool

	// Workload specific property bag.
	PropertyBag map[string]*string

	// Defines whether the current recovery mode is file restore or database restore
	RecoveryMode *RecoveryMode

	// RP Rehydration Info
	RecoveryPointRehydrationInfo *RecoveryPointRehydrationInfo

	// Type of this recovery.
	RecoveryType *RecoveryType

	// Default option set to true. If this is set to false, alternate data directory must be provided
	ShouldUseAlternateTargetLocation *bool

	// Additional details for snapshot recovery Currently used for snapshot for SAP Hana.
	SnapshotRestoreParameters *SnapshotRestoreParameters

	// Fully qualified ARM ID of the VM on which workload that was running is being recovered.
	SourceResourceID *string

	// Details of target database
	TargetInfo *TargetRestoreInfo

	// Defines the Resource group of the Target VM
	TargetResourceGroupName *string

	// This is the complete ARM Id of the target VM For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string

	// User Assigned managed identity details Currently used for snapshot.
	UserAssignedManagedIdentityDetails *UserAssignedManagedIdentityDetails
}

// GetAzureWorkloadRestoreRequest implements the AzureWorkloadRestoreRequestClassification interface for type AzureWorkloadSQLRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLRestoreWithRehydrateRequest) GetAzureWorkloadRestoreRequest() *AzureWorkloadRestoreRequest {
	return &AzureWorkloadRestoreRequest{
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetAzureWorkloadSQLRestoreRequest implements the AzureWorkloadSQLRestoreRequestClassification interface for type AzureWorkloadSQLRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLRestoreWithRehydrateRequest) GetAzureWorkloadSQLRestoreRequest() *AzureWorkloadSQLRestoreRequest {
	return &AzureWorkloadSQLRestoreRequest{
		AlternateDirectoryPaths:            a.AlternateDirectoryPaths,
		IsNonRecoverable:                   a.IsNonRecoverable,
		ObjectType:                         a.ObjectType,
		PropertyBag:                        a.PropertyBag,
		RecoveryMode:                       a.RecoveryMode,
		RecoveryType:                       a.RecoveryType,
		ShouldUseAlternateTargetLocation:   a.ShouldUseAlternateTargetLocation,
		SnapshotRestoreParameters:          a.SnapshotRestoreParameters,
		SourceResourceID:                   a.SourceResourceID,
		TargetInfo:                         a.TargetInfo,
		TargetResourceGroupName:            a.TargetResourceGroupName,
		TargetVirtualMachineID:             a.TargetVirtualMachineID,
		UserAssignedManagedIdentityDetails: a.UserAssignedManagedIdentityDetails,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type AzureWorkloadSQLRestoreWithRehydrateRequest.
func (a *AzureWorkloadSQLRestoreWithRehydrateRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: a.ObjectType,
	}
}

// BEKDetails - BEK is bitlocker encryption key.
type BEKDetails struct {
	// BEK data.
	SecretData *string

	// Secret is BEK.
	SecretURL *string

	// ID of the Key Vault where this Secret is stored.
	SecretVaultID *string
}

// BMSBackupEngineQueryObject - Query parameters to fetch list of backup engines.
type BMSBackupEngineQueryObject struct {
	// attribute to add extended info
	Expand *string
}

// BMSBackupEnginesQueryObject - Query parameters to fetch list of backup engines.
type BMSBackupEnginesQueryObject struct {
	// Backup management type for the backup engine.
	BackupManagementType *BackupManagementType

	// Attribute to add extended info.
	Expand *string

	// Friendly name of the backup engine.
	FriendlyName *string
}

// BMSBackupSummariesQueryObject - Query parameters to fetch backup summaries.
type BMSBackupSummariesQueryObject struct {
	// Backup management type for this container.
	Type *Type
}

// BMSContainerQueryObject - The query filters that can be used with the list containers API.
type BMSContainerQueryObject struct {
	// REQUIRED; Backup management type for this container.
	BackupManagementType *BackupManagementType

	// Backup engine name
	BackupEngineName *string

	// Type of container for filter
	ContainerType *ContainerType

	// Fabric name for filter
	FabricName *string

	// Friendly name of this container.
	FriendlyName *string

	// Status of registration of this container with the Recovery Services Vault.
	Status *string
}

// BMSContainersInquiryQueryObject - The query filters that can be used with the inquire container API.
type BMSContainersInquiryQueryObject struct {
	// Backup management type for this container.
	BackupManagementType *BackupManagementType

	// Workload type for this container.
	WorkloadType *WorkloadType
}

// BMSPOQueryObject - Filters to list items that can be backed up.
type BMSPOQueryObject struct {
	// Backup management type.
	BackupManagementType *BackupManagementType

	// Full name of the container whose Protectable Objects should be returned.
	ContainerName *string

	// Friendly name.
	FriendlyName *string

	// Backup status query parameter.
	Status *string

	// Workload type
	WorkloadType *WorkloadType
}

// BMSRPQueryObject - Filters to list backup copies.
type BMSRPQueryObject struct {
	// Backup copies created before this time.
	EndDate *time.Time

	// In Get Recovery Point, it tells whether extended information about recovery point is asked.
	ExtendedInfo *bool

	// Flag to indicate whether Soft Deleted RPs should be included/excluded from result.
	IncludeSoftDeletedRP *bool

	// Whether the RP can be moved to another tier
	MoveReadyRPOnly *bool

	// RestorePoint type
	RestorePointQueryType *RestorePointQueryType

	// Backup copies created after this time.
	StartDate *time.Time
}

// BMSRefreshContainersQueryObject - The query filters that can be used with the refresh container API.
type BMSRefreshContainersQueryObject struct {
	// Backup management type for this container.
	BackupManagementType *BackupManagementType
}

// BMSWorkloadItemQueryObject - Filters to list items that can be backed up.
type BMSWorkloadItemQueryObject struct {
	// Backup management type.
	BackupManagementType *BackupManagementType

	// Backup status query parameter.
	ProtectionStatus *ProtectionStatus

	// Workload Item type
	WorkloadItemType *WorkloadItemType

	// Workload type
	WorkloadType *WorkloadType
}

// BackupEngineBase - The base backup engine class. All workload specific backup engines derive from this class.
type BackupEngineBase struct {
	// REQUIRED; Type of the backup engine.
	BackupEngineType *BackupEngineType

	// Backup agent version
	AzureBackupAgentVersion *string

	// ID of the backup engine.
	BackupEngineID *string

	// Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}
	BackupEngineState *string

	// Type of backup management for the backup engine.
	BackupManagementType *BackupManagementType

	// Flag indicating if the backup engine be registered, once already registered.
	CanReRegister *bool

	// Backup engine version
	DpmVersion *string

	// Extended info of the backupengine
	ExtendedInfo *BackupEngineExtendedInfo

	// Friendly name of the backup engine.
	FriendlyName *string

	// Backup status of the backup engine.
	HealthStatus *string

	// To check if backup agent upgrade available
	IsAzureBackupAgentUpgradeAvailable *bool

	// To check if backup engine upgrade available
	IsDpmUpgradeAvailable *bool

	// Registration status of the backup engine with the Recovery Services Vault.
	RegistrationStatus *string
}

// GetBackupEngineBase implements the BackupEngineBaseClassification interface for type BackupEngineBase.
func (b *BackupEngineBase) GetBackupEngineBase() *BackupEngineBase { return b }

// BackupEngineBaseResource - The base backup engine class. All workload specific backup engines derive from this class.
type BackupEngineBaseResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// BackupEngineBaseResource properties
	Properties BackupEngineBaseClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// BackupEngineBaseResourceList - List of BackupEngineBase resources
type BackupEngineBaseResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*BackupEngineBaseResource
}

// BackupEngineExtendedInfo - Additional information on backup engine.
type BackupEngineExtendedInfo struct {
	// Disk space currently available in the backup engine.
	AvailableDiskSpace *float64

	// Protected instances in the backup engine.
	AzureProtectedInstances *int32

	// Database name of backup engine.
	DatabaseName *string

	// Number of disks in the backup engine.
	DiskCount *int32

	// Number of protected items in the backup engine.
	ProtectedItemsCount *int32

	// Number of protected servers in the backup engine.
	ProtectedServersCount *int32

	// Last refresh time in the backup engine.
	RefreshedAt *time.Time

	// Disk space used in the backup engine.
	UsedDiskSpace *float64
}

// BackupManagementUsage - Backup management usages of a vault.
type BackupManagementUsage struct {
	// Current value of usage.
	CurrentValue *int64

	// Limit of usage.
	Limit *int64

	// Name of usage.
	Name *NameInfo

	// Next reset time of usage.
	NextResetTime *time.Time

	// Quota period of usage.
	QuotaPeriod *string

	// Unit of the usage.
	Unit *UsagesUnit
}

// BackupManagementUsageList - Backup management usage for vault.
type BackupManagementUsageList struct {
	// The list of backup management usages for the given vault.
	Value []*BackupManagementUsage
}

// BackupRequest - Base class for backup request. Workload-specific backup requests are derived from this class.
type BackupRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string
}

// GetBackupRequest implements the BackupRequestClassification interface for type BackupRequest.
func (b *BackupRequest) GetBackupRequest() *BackupRequest { return b }

// BackupRequestResource - Base class for backup request. Workload-specific backup requests are derived from this class.
type BackupRequestResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// BackupRequestResource properties
	Properties BackupRequestClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// BackupResourceConfig - The resource storage details.
type BackupResourceConfig struct {
	// Opt in details of Cross Region Restore feature.
	CrossRegionRestoreFlag *bool

	// Vault Dedup state
	DedupState *DedupState

	// Storage type
	StorageModelType *StorageType

	// Storage type.
	StorageType *StorageType

	// Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is always Locked.
	StorageTypeState *StorageTypeState

	// Vault x-cool state
	XcoolState *XcoolState
}

// BackupResourceConfigResource - The resource storage details.
type BackupResourceConfigResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// BackupResourceConfigResource properties
	Properties *BackupResourceConfig

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

type BackupResourceEncryptionConfig struct {
	// Encryption At Rest Type
	EncryptionAtRestType          *EncryptionAtRestType
	InfrastructureEncryptionState *InfrastructureEncryptionState

	// Key Vault Key URI
	KeyURI           *string
	LastUpdateStatus *LastUpdateStatus

	// Key Vault Subscription Id
	SubscriptionID *string
}

type BackupResourceEncryptionConfigExtended struct {
	// Encryption At Rest Type
	EncryptionAtRestType          *EncryptionAtRestType
	InfrastructureEncryptionState *InfrastructureEncryptionState

	// Key Vault Key URI
	KeyURI           *string
	LastUpdateStatus *LastUpdateStatus

	// Key Vault Subscription Id
	SubscriptionID *string

	// bool to indicate whether to use system Assigned Identity or not
	UseSystemAssignedIdentity *bool

	// User Assigned Identity Id
	UserAssignedIdentity *string
}

type BackupResourceEncryptionConfigExtendedResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// BackupResourceEncryptionConfigExtendedResource properties
	Properties *BackupResourceEncryptionConfigExtended

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

type BackupResourceEncryptionConfigResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// BackupResourceEncryptionConfigResource properties
	Properties *BackupResourceEncryptionConfig

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// BackupResourceVaultConfig - Backup resource vault config details.
type BackupResourceVaultConfig struct {
	// Enabled or Disabled.
	EnhancedSecurityState *EnhancedSecurityState

	// This flag is no longer in use. Please use 'softDeleteFeatureState' to set the soft delete state for the vault
	IsSoftDeleteFeatureStateEditable *bool

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string

	// Soft Delete feature state
	SoftDeleteFeatureState *SoftDeleteFeatureState

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// Storage type.
	StorageModelType *StorageType

	// Storage type.
	StorageType *StorageType

	// Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is always Locked.
	StorageTypeState *StorageTypeState
}

// BackupResourceVaultConfigResource - Backup resource vault config details.
type BackupResourceVaultConfigResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// BackupResourceVaultConfigResource properties
	Properties *BackupResourceVaultConfig

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// BackupStatusRequest - BackupStatus request.
type BackupStatusRequest struct {
	// Protectable Item Logical Name
	PoLogicalName *string

	// Entire ARM resource id of the resource
	ResourceID *string

	// Container Type - VM, SQLPaaS, DPM, AzureFileShare…
	ResourceType *DataSourceType
}

// BackupStatusResponse - BackupStatus response.
type BackupStatusResponse struct {
	// Specifies whether the storage account lock has been acquired or not
	AcquireStorageAccountLock *AcquireStorageAccountLock

	// Specifies the product specific container name. E.g. iaasvmcontainer;iaasvmcontainer;csname;vmname.
	ContainerName *string

	// ErrorCode in case of intent failed
	ErrorCode *string

	// ErrorMessage in case of intent failed.
	ErrorMessage *string

	// Specifies the fabric name - Azure or AD
	FabricName *FabricName

	// Specifies the policy name which is used for protection
	PolicyName *string

	// Specifies the product specific ds name. E.g. vm;iaasvmcontainer;csname;vmname.
	ProtectedItemName *string

	// Number of protected items
	ProtectedItemsCount *int32

	// Specifies whether the container is registered or not
	ProtectionStatus *ProtectionStatus

	// Container registration status
	RegistrationStatus *string

	// Specifies the arm resource id of the vault
	VaultID *string
}

// ClientDiscoveryDisplay - Localized display information of an operation.
type ClientDiscoveryDisplay struct {
	// Description of the operation having details of what operation is about.
	Description *string

	// Operations Name itself.
	Operation *string

	// Name of the provider for display purposes
	Provider *string

	// ResourceType for which this Operation can be performed.
	Resource *string
}

// ClientDiscoveryForLogSpecification - Class to represent shoebox log specification in json client discovery.
type ClientDiscoveryForLogSpecification struct {
	// blob duration of shoebox log specification
	BlobDuration *string

	// Localized display name
	DisplayName *string

	// Name for shoebox log specification.
	Name *string
}

// ClientDiscoveryForProperties - Class to represent shoebox properties in json client discovery.
type ClientDiscoveryForProperties struct {
	// Operation properties.
	ServiceSpecification *ClientDiscoveryForServiceSpecification
}

// ClientDiscoveryForServiceSpecification - Class to represent shoebox service specification in json client discovery.
type ClientDiscoveryForServiceSpecification struct {
	// List of log specifications of this operation.
	LogSpecifications []*ClientDiscoveryForLogSpecification
}

// ClientDiscoveryResponse - Operations List response which contains list of available APIs.
type ClientDiscoveryResponse struct {
	// Link to the next chunk of Response.
	NextLink *string

	// List of available operations.
	Value []*ClientDiscoveryValueForSingleAPI
}

// ClientDiscoveryValueForSingleAPI - Available operation details.
type ClientDiscoveryValueForSingleAPI struct {
	// Contains the localized display information for this particular operation
	Display *ClientDiscoveryDisplay

	// Name of the Operation.
	Name *string

	// The intended executor of the operation;governs the display of the operation in the RBAC UX and the audit logs UX
	Origin *string

	// ShoeBox properties for the given operation.
	Properties *ClientDiscoveryForProperties
}

// ClientScriptForConnect - Client script details for file / folder restore.
type ClientScriptForConnect struct {
	// OS type - Windows, Linux etc. for which this file / folder restore client script works.
	OSType *string

	// File content of the client script for file / folder restore.
	ScriptContent *string

	// File extension of the client script for file / folder restore - .ps1 , .sh , etc.
	ScriptExtension *string

	// Mandatory suffix that should be added to the name of script that is given for download to user. If its null or empty then
	// , ignore it.
	ScriptNameSuffix *string

	// URL of Executable from where to source the content. If this is not null then ScriptContent should not be used
	URL *string
}

// ContainerIdentityInfo - Container identity information
type ContainerIdentityInfo struct {
	// Protection container identity - AAD Tenant
	AADTenantID *string

	// Protection container identity - Audience
	Audience *string

	// Protection container identity - AAD Service Principal
	ServicePrincipalClientID *string

	// Unique name of the container
	UniqueName *string
}

// DPMContainerExtendedInfo - Additional information of the DPMContainer.
type DPMContainerExtendedInfo struct {
	// Last refresh time of the DPMContainer.
	LastRefreshedAt *time.Time
}

// DPMProtectedItem - Additional information on Backup engine specific backup item.
type DPMProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Backup Management server protecting this backup item
	BackupEngineName *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Extended info of the backup item.
	ExtendedInfo *DPMProtectedItemExtendedInfo

	// Friendly name of the managed item
	FriendlyName *string

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// Protection state of the backup engine
	ProtectionState *ProtectedItemState

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetProtectedItem implements the ProtectedItemClassification interface for type DPMProtectedItem.
func (d *DPMProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		BackupManagementType:             d.BackupManagementType,
		BackupSetName:                    d.BackupSetName,
		ContainerName:                    d.ContainerName,
		CreateMode:                       d.CreateMode,
		DeferredDeleteTimeInUTC:          d.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      d.DeferredDeleteTimeRemaining,
		IsArchiveEnabled:                 d.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: d.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      d.IsRehydrate,
		IsScheduledForDeferredDelete:     d.IsScheduledForDeferredDelete,
		LastRecoveryPoint:                d.LastRecoveryPoint,
		PolicyID:                         d.PolicyID,
		PolicyName:                       d.PolicyName,
		ProtectedItemType:                d.ProtectedItemType,
		ResourceGuardOperationRequests:   d.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  d.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 d.SourceResourceID,
		VaultID:                          d.VaultID,
		WorkloadType:                     d.WorkloadType,
	}
}

// DPMProtectedItemExtendedInfo - Additional information of DPM Protected item.
type DPMProtectedItemExtendedInfo struct {
	// Used Disk storage in bytes.
	DiskStorageUsedInBytes *string

	// To check if backup item is collocated.
	IsCollocated *bool

	// To check if backup item is cloud protected.
	IsPresentOnCloud *bool

	// Last backup status information on backup item.
	LastBackupStatus *string

	// Last refresh time on backup item.
	LastRefreshedAt *time.Time

	// Oldest cloud recovery point time.
	OldestRecoveryPoint *time.Time

	// latest disk recovery point time.
	OnPremiseLatestRecoveryPoint *time.Time

	// Oldest disk recovery point time.
	OnPremiseOldestRecoveryPoint *time.Time

	// disk recovery point count.
	OnPremiseRecoveryPointCount *int32

	// Attribute to provide information on various DBs.
	ProtectableObjectLoadPath map[string]*string

	// To check if backup item is disk protected.
	Protected *bool

	// Protection group name of the backup item.
	ProtectionGroupName *string

	// cloud recovery point count.
	RecoveryPointCount *int32

	// total Disk storage in bytes.
	TotalDiskStorageSizeInBytes *string
}

// DailyRetentionFormat - Daily retention format.
type DailyRetentionFormat struct {
	// List of days of the month.
	DaysOfTheMonth []*Day
}

// DailyRetentionSchedule - Daily retention schedule.
type DailyRetentionSchedule struct {
	// Retention duration of retention Policy.
	RetentionDuration *RetentionDuration

	// Retention times of retention policy.
	RetentionTimes []*time.Time
}

type DailySchedule struct {
	// List of times of day this schedule has to be run.
	ScheduleRunTimes []*time.Time
}

// Day of the week.
type Day struct {
	// Date of the month
	Date *int32

	// Whether Date is last date of month
	IsLast *bool
}

type DiskExclusionProperties struct {
	// List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
	DiskLunList []*int32

	// Flag to indicate whether DiskLunList is to be included/ excluded from backup.
	IsInclusionList *bool
}

// DiskInformation - Disk information
type DiskInformation struct {
	Lun  *int32
	Name *string
}

// DistributedNodesInfo - This is used to represent the various nodes of the distributed container.
type DistributedNodesInfo struct {
	// Error Details if the Status is non-success.
	ErrorDetail *ErrorDetail

	// Name of the node under a distributed container.
	NodeName *string

	// ARM resource id of the node
	SourceResourceID *string

	// Status of this Node. Failed | Succeeded
	Status *string
}

// DpmBackupEngine - Data Protection Manager (DPM) specific backup engine.
type DpmBackupEngine struct {
	// REQUIRED; Type of the backup engine.
	BackupEngineType *BackupEngineType

	// Backup agent version
	AzureBackupAgentVersion *string

	// ID of the backup engine.
	BackupEngineID *string

	// Status of the backup engine with the Recovery Services Vault. = {Active/Deleting/DeleteFailed}
	BackupEngineState *string

	// Type of backup management for the backup engine.
	BackupManagementType *BackupManagementType

	// Flag indicating if the backup engine be registered, once already registered.
	CanReRegister *bool

	// Backup engine version
	DpmVersion *string

	// Extended info of the backupengine
	ExtendedInfo *BackupEngineExtendedInfo

	// Friendly name of the backup engine.
	FriendlyName *string

	// Backup status of the backup engine.
	HealthStatus *string

	// To check if backup agent upgrade available
	IsAzureBackupAgentUpgradeAvailable *bool

	// To check if backup engine upgrade available
	IsDpmUpgradeAvailable *bool

	// Registration status of the backup engine with the Recovery Services Vault.
	RegistrationStatus *string
}

// GetBackupEngineBase implements the BackupEngineBaseClassification interface for type DpmBackupEngine.
func (d *DpmBackupEngine) GetBackupEngineBase() *BackupEngineBase {
	return &BackupEngineBase{
		AzureBackupAgentVersion:            d.AzureBackupAgentVersion,
		BackupEngineID:                     d.BackupEngineID,
		BackupEngineState:                  d.BackupEngineState,
		BackupEngineType:                   d.BackupEngineType,
		BackupManagementType:               d.BackupManagementType,
		CanReRegister:                      d.CanReRegister,
		DpmVersion:                         d.DpmVersion,
		ExtendedInfo:                       d.ExtendedInfo,
		FriendlyName:                       d.FriendlyName,
		HealthStatus:                       d.HealthStatus,
		IsAzureBackupAgentUpgradeAvailable: d.IsAzureBackupAgentUpgradeAvailable,
		IsDpmUpgradeAvailable:              d.IsDpmUpgradeAvailable,
		RegistrationStatus:                 d.RegistrationStatus,
	}
}

// DpmContainer - DPM workload-specific protection container.
type DpmContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Specifies whether the container is re-registrable.
	CanReRegister *bool

	// ID of container.
	ContainerID *string

	// Backup engine Agent version
	DpmAgentVersion *string

	// List of BackupEngines protecting the container
	DpmServers []*string

	// Extended Info of the container.
	ExtendedInfo *DPMContainerExtendedInfo

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string

	// Type of the protectable object associated with this container
	ProtectableObjectType *string

	// Number of protected items in the BackupEngine
	ProtectedItemCount *int64

	// Protection status of the container.
	ProtectionStatus *string

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string

	// To check if upgrade available
	UpgradeAvailable *bool
}

// GetDpmContainer implements the DpmContainerClassification interface for type DpmContainer.
func (d *DpmContainer) GetDpmContainer() *DpmContainer { return d }

// GetProtectionContainer implements the ProtectionContainerClassification interface for type DpmContainer.
func (d *DpmContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		BackupManagementType:  d.BackupManagementType,
		ContainerType:         d.ContainerType,
		FriendlyName:          d.FriendlyName,
		HealthStatus:          d.HealthStatus,
		ProtectableObjectType: d.ProtectableObjectType,
		RegistrationStatus:    d.RegistrationStatus,
	}
}

// DpmErrorInfo - DPM workload-specific error information.
type DpmErrorInfo struct {
	// Localized error string.
	ErrorString *string

	// List of localized recommendations for above error code.
	Recommendations []*string
}

// DpmJob - DPM workload-specific job object.
type DpmJob struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string

	// The state/actions applicable on this job like cancel/retry.
	ActionsInfo []*JobSupportedAction

	// ActivityId of job.
	ActivityID *string

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType

	// Name of cluster/server protecting current backup item, if any.
	ContainerName *string

	// Type of container.
	ContainerType *string

	// DPM server name managing the backup item or backup job.
	DpmServerName *string

	// Time elapsed for job.
	Duration *string

	// The end time.
	EndTime *time.Time

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string

	// The errors.
	ErrorDetails []*DpmErrorInfo

	// Additional information for this job.
	ExtendedInfo *DpmJobExtendedInfo

	// The operation name.
	Operation *string

	// The start time.
	StartTime *time.Time

	// Job status.
	Status *string

	// Type of backup item.
	WorkloadType *string
}

// GetJob implements the JobClassification interface for type DpmJob.
func (d *DpmJob) GetJob() *Job {
	return &Job{
		ActivityID:           d.ActivityID,
		BackupManagementType: d.BackupManagementType,
		EndTime:              d.EndTime,
		EntityFriendlyName:   d.EntityFriendlyName,
		JobType:              d.JobType,
		Operation:            d.Operation,
		StartTime:            d.StartTime,
		Status:               d.Status,
	}
}

// DpmJobExtendedInfo - Additional information on the DPM workload-specific job.
type DpmJobExtendedInfo struct {
	// Non localized error message on job execution.
	DynamicErrorMessage *string

	// The job properties.
	PropertyBag map[string]*string

	// List of tasks associated with this job.
	TasksList []*DpmJobTaskDetails
}

// DpmJobTaskDetails - DPM workload-specific job task details.
type DpmJobTaskDetails struct {
	// Time elapsed for task.
	Duration *string

	// The end time.
	EndTime *time.Time

	// The start time.
	StartTime *time.Time

	// The status.
	Status *string

	// The task display name.
	TaskID *string
}

// EncryptionDetails - Details needed if the VM was encrypted at the time of backup.
type EncryptionDetails struct {
	// Identifies whether this backup copy represents an encrypted VM at the time of backup.
	EncryptionEnabled *bool

	// Key Url.
	KekURL *string

	// ID of Key Vault where KEK is stored.
	KekVaultID *string

	// Secret Url.
	SecretKeyURL *string

	// ID of Key Vault where Secret is stored.
	SecretKeyVaultID *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - Error Detail class which encapsulates Code, Message and Recommendations.
type ErrorDetail struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error Message related to the Code.
	Message *string

	// READ-ONLY; List of recommendation strings.
	Recommendations []*string
}

// ExportJobsOperationResultInfo - This class is used to send blob details after exporting jobs.
type ExportJobsOperationResultInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// SAS key to access the blob. It expires in 15 mins.
	BlobSasKey *string

	// URL of the blob into which the serialized string of list of jobs is exported.
	BlobURL *string

	// SAS key to access the blob. It expires in 15 mins.
	ExcelFileBlobSasKey *string

	// URL of the blob into which the ExcelFile is uploaded.
	ExcelFileBlobURL *string
}

// GetOperationResultInfoBase implements the OperationResultInfoBaseClassification interface for type ExportJobsOperationResultInfo.
func (e *ExportJobsOperationResultInfo) GetOperationResultInfoBase() *OperationResultInfoBase {
	return &OperationResultInfoBase{
		ObjectType: e.ObjectType,
	}
}

// ExtendedLocation - The extended location of Recovery point where VM was present.
type ExtendedLocation struct {
	// Name of the extended location.
	Name *string

	// Type of the extended location. Possible values include: 'EdgeZone'
	Type *string
}

// ExtendedProperties - Extended Properties for Azure IaasVM Backup.
type ExtendedProperties struct {
	// Extended Properties for Disk Exclusion.
	DiskExclusionProperties *DiskExclusionProperties

	// Linux VM name
	LinuxVMApplicationName *string
}

// FeatureSupportRequest - Base class for feature request
type FeatureSupportRequest struct {
	// REQUIRED; backup support feature type.
	FeatureType *string
}

// GetFeatureSupportRequest implements the FeatureSupportRequestClassification interface for type FeatureSupportRequest.
func (f *FeatureSupportRequest) GetFeatureSupportRequest() *FeatureSupportRequest { return f }

// FetchTieringCostInfoForRehydrationRequest - Request parameters for fetching cost info of rehydration
type FetchTieringCostInfoForRehydrationRequest struct {
	// REQUIRED; Name of the protected item container
	ContainerName *string

	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// REQUIRED; Name of the protectedItemName
	ProtectedItemName *string

	// REQUIRED; ID of the backup copy for rehydration cost info needs to be fetched.
	RecoveryPointID *string

	// REQUIRED; Rehydration Priority
	RehydrationPriority *RehydrationPriority

	// REQUIRED; Source tier for the request
	SourceTierType *RecoveryPointTierType

	// REQUIRED; target tier for the request
	TargetTierType *RecoveryPointTierType
}

// GetFetchTieringCostInfoRequest implements the FetchTieringCostInfoRequestClassification interface for type FetchTieringCostInfoForRehydrationRequest.
func (f *FetchTieringCostInfoForRehydrationRequest) GetFetchTieringCostInfoRequest() *FetchTieringCostInfoRequest {
	return &FetchTieringCostInfoRequest{
		ObjectType:     f.ObjectType,
		SourceTierType: f.SourceTierType,
		TargetTierType: f.TargetTierType,
	}
}

// FetchTieringCostInfoRequest - Base class for tiering cost request. Specific cost request types are derived from this class.
type FetchTieringCostInfoRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// REQUIRED; Source tier for the request
	SourceTierType *RecoveryPointTierType

	// REQUIRED; target tier for the request
	TargetTierType *RecoveryPointTierType
}

// GetFetchTieringCostInfoRequest implements the FetchTieringCostInfoRequestClassification interface for type FetchTieringCostInfoRequest.
func (f *FetchTieringCostInfoRequest) GetFetchTieringCostInfoRequest() *FetchTieringCostInfoRequest {
	return f
}

// FetchTieringCostSavingsInfoForPolicyRequest - Request parameters for tiering cost info for policy
type FetchTieringCostSavingsInfoForPolicyRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// REQUIRED; Name of the backup policy for which the cost savings information is requested
	PolicyName *string

	// REQUIRED; Source tier for the request
	SourceTierType *RecoveryPointTierType

	// REQUIRED; target tier for the request
	TargetTierType *RecoveryPointTierType
}

// GetFetchTieringCostInfoRequest implements the FetchTieringCostInfoRequestClassification interface for type FetchTieringCostSavingsInfoForPolicyRequest.
func (f *FetchTieringCostSavingsInfoForPolicyRequest) GetFetchTieringCostInfoRequest() *FetchTieringCostInfoRequest {
	return &FetchTieringCostInfoRequest{
		ObjectType:     f.ObjectType,
		SourceTierType: f.SourceTierType,
		TargetTierType: f.TargetTierType,
	}
}

// FetchTieringCostSavingsInfoForProtectedItemRequest - Request parameters for tiering cost info for protected item
type FetchTieringCostSavingsInfoForProtectedItemRequest struct {
	// REQUIRED; Name of the protected item container
	ContainerName *string

	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// REQUIRED; Name of the protectedItemName
	ProtectedItemName *string

	// REQUIRED; Source tier for the request
	SourceTierType *RecoveryPointTierType

	// REQUIRED; target tier for the request
	TargetTierType *RecoveryPointTierType
}

// GetFetchTieringCostInfoRequest implements the FetchTieringCostInfoRequestClassification interface for type FetchTieringCostSavingsInfoForProtectedItemRequest.
func (f *FetchTieringCostSavingsInfoForProtectedItemRequest) GetFetchTieringCostInfoRequest() *FetchTieringCostInfoRequest {
	return &FetchTieringCostInfoRequest{
		ObjectType:     f.ObjectType,
		SourceTierType: f.SourceTierType,
		TargetTierType: f.TargetTierType,
	}
}

// FetchTieringCostSavingsInfoForVaultRequest - Request parameters for tiering cost info for vault
type FetchTieringCostSavingsInfoForVaultRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// REQUIRED; Source tier for the request
	SourceTierType *RecoveryPointTierType

	// REQUIRED; target tier for the request
	TargetTierType *RecoveryPointTierType
}

// GetFetchTieringCostInfoRequest implements the FetchTieringCostInfoRequestClassification interface for type FetchTieringCostSavingsInfoForVaultRequest.
func (f *FetchTieringCostSavingsInfoForVaultRequest) GetFetchTieringCostInfoRequest() *FetchTieringCostInfoRequest {
	return &FetchTieringCostInfoRequest{
		ObjectType:     f.ObjectType,
		SourceTierType: f.SourceTierType,
		TargetTierType: f.TargetTierType,
	}
}

// GenericContainer - Base class for generic container of backup items
type GenericContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Extended information (not returned in List container API calls)
	ExtendedInformation *GenericContainerExtendedInfo

	// Name of the container's fabric
	FabricName *string

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string

	// Type of the protectable object associated with this container
	ProtectableObjectType *string

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type GenericContainer.
func (g *GenericContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		BackupManagementType:  g.BackupManagementType,
		ContainerType:         g.ContainerType,
		FriendlyName:          g.FriendlyName,
		HealthStatus:          g.HealthStatus,
		ProtectableObjectType: g.ProtectableObjectType,
		RegistrationStatus:    g.RegistrationStatus,
	}
}

// GenericContainerExtendedInfo - Container extended information
type GenericContainerExtendedInfo struct {
	// Container identity information
	ContainerIdentityInfo *ContainerIdentityInfo

	// Public key of container cert
	RawCertData *string

	// Azure Backup Service Endpoints for the container
	ServiceEndpoints map[string]*string
}

// GenericProtectedItem - Base class for backup items.
type GenericProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Name of this backup item's fabric.
	FabricName *string

	// Friendly name of the container.
	FriendlyName *string

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// Indicates consistency of policy object and policy applied to this backup item.
	PolicyState *string

	// Data Plane Service ID of the protected item.
	ProtectedItemID *int64

	// Backup state of this backup item.
	ProtectionState *ProtectionState

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// Loosely coupled (type, value) associations (example - parent of a protected item)
	SourceAssociations map[string]*string

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetProtectedItem implements the ProtectedItemClassification interface for type GenericProtectedItem.
func (g *GenericProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		BackupManagementType:             g.BackupManagementType,
		BackupSetName:                    g.BackupSetName,
		ContainerName:                    g.ContainerName,
		CreateMode:                       g.CreateMode,
		DeferredDeleteTimeInUTC:          g.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      g.DeferredDeleteTimeRemaining,
		IsArchiveEnabled:                 g.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: g.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      g.IsRehydrate,
		IsScheduledForDeferredDelete:     g.IsScheduledForDeferredDelete,
		LastRecoveryPoint:                g.LastRecoveryPoint,
		PolicyID:                         g.PolicyID,
		PolicyName:                       g.PolicyName,
		ProtectedItemType:                g.ProtectedItemType,
		ResourceGuardOperationRequests:   g.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  g.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 g.SourceResourceID,
		VaultID:                          g.VaultID,
		WorkloadType:                     g.WorkloadType,
	}
}

// GenericProtectionPolicy - Azure VM (Mercury) workload-specific backup policy.
type GenericProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string

	// Name of this policy's fabric.
	FabricName *string

	// Number of items associated with this policy.
	ProtectedItemsCount *int32

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string

	// List of sub-protection policies which includes schedule and retention
	SubProtectionPolicy []*SubProtectionPolicy

	// TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
	TimeZone *string
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type GenericProtectionPolicy.
func (g *GenericProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy {
	return &ProtectionPolicy{
		BackupManagementType:           g.BackupManagementType,
		ProtectedItemsCount:            g.ProtectedItemsCount,
		ResourceGuardOperationRequests: g.ResourceGuardOperationRequests,
	}
}

// GenericRecoveryPoint - Generic backup copy.
type GenericRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Friendly name of the backup copy.
	FriendlyName *string

	// Additional information associated with this backup copy.
	RecoveryPointAdditionalInfo *string

	// Properties of Recovery Point
	RecoveryPointProperties *RecoveryPointProperties

	// Time at which this backup copy was created.
	RecoveryPointTime *time.Time

	// Type of the backup copy.
	RecoveryPointType *string
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type GenericRecoveryPoint.
func (g *GenericRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: g.ObjectType,
	}
}

// GetProtectedItemQueryObject - Filters to list backup items.
type GetProtectedItemQueryObject struct {
	// Specifies if the additional information should be provided for this item.
	Expand *string
}

type HourlySchedule struct {
	// Interval at which backup needs to be triggered. For hourly the value can be 4/6/8/12
	Interval *int32

	// To specify duration of the backup window
	ScheduleWindowDuration *int32

	// To specify start time of the backup window
	ScheduleWindowStartTime *time.Time
}

// ILRRequest - Parameters to Provision ILR API.
type ILRRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string
}

// GetILRRequest implements the ILRRequestClassification interface for type ILRRequest.
func (i *ILRRequest) GetILRRequest() *ILRRequest { return i }

// ILRRequestResource - Parameters to Provision ILR API.
type ILRRequestResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// ILRRequestResource properties
	Properties ILRRequestClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// IaaSVMContainer - IaaS VM workload-specific container.
type IaaSVMContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string

	// Type of the protectable object associated with this container
	ProtectableObjectType *string

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string

	// Fully qualified ARM url of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string

	// Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string
}

// GetIaaSVMContainer implements the IaaSVMContainerClassification interface for type IaaSVMContainer.
func (i *IaaSVMContainer) GetIaaSVMContainer() *IaaSVMContainer { return i }

// GetProtectionContainer implements the ProtectionContainerClassification interface for type IaaSVMContainer.
func (i *IaaSVMContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		BackupManagementType:  i.BackupManagementType,
		ContainerType:         i.ContainerType,
		FriendlyName:          i.FriendlyName,
		HealthStatus:          i.HealthStatus,
		ProtectableObjectType: i.ProtectableObjectType,
		RegistrationStatus:    i.RegistrationStatus,
	}
}

// IaaSVMProtectableItem - IaaS VM workload-specific backup item.
type IaaSVMProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Resource group name of Recovery Services Vault.
	ResourceGroup *string

	// Fully qualified ARM ID of the virtual machine.
	VirtualMachineID *string

	// Specifies whether the container represents a Classic or an Azure Resource Manager VM.
	VirtualMachineVersion *string

	// Type of workload for the backup management
	WorkloadType *string
}

// GetIaaSVMProtectableItem implements the IaaSVMProtectableItemClassification interface for type IaaSVMProtectableItem.
func (i *IaaSVMProtectableItem) GetIaaSVMProtectableItem() *IaaSVMProtectableItem { return i }

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type IaaSVMProtectableItem.
func (i *IaaSVMProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem {
	return &WorkloadProtectableItem{
		BackupManagementType: i.BackupManagementType,
		FriendlyName:         i.FriendlyName,
		ProtectableItemType:  i.ProtectableItemType,
		ProtectionState:      i.ProtectionState,
		WorkloadType:         i.WorkloadType,
	}
}

// IaasVMBackupRequest - IaaS VM workload-specific backup request.
type IaasVMBackupRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Backup copy will expire after the time specified (UTC).
	RecoveryPointExpiryTimeInUTC *time.Time
}

// GetBackupRequest implements the BackupRequestClassification interface for type IaasVMBackupRequest.
func (i *IaasVMBackupRequest) GetBackupRequest() *BackupRequest {
	return &BackupRequest{
		ObjectType: i.ObjectType,
	}
}

// IaasVMILRRegistrationRequest - Restore files/folders from a backup copy of IaaS VM.
type IaasVMILRRegistrationRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// iSCSI initiator name.
	InitiatorName *string

	// ID of the IaaS VM backup copy from where the files/folders have to be restored.
	RecoveryPointID *string

	// Whether to renew existing registration with the iSCSI server.
	RenewExistingRegistration *bool

	// Fully qualified ARM ID of the virtual machine whose the files / folders have to be restored.
	VirtualMachineID *string
}

// GetILRRequest implements the ILRRequestClassification interface for type IaasVMILRRegistrationRequest.
func (i *IaasVMILRRegistrationRequest) GetILRRequest() *ILRRequest {
	return &ILRRequest{
		ObjectType: i.ObjectType,
	}
}

// IaasVMRecoveryPoint - IaaS VM workload specific backup copy.
type IaasVMRecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Extended location of the VM recovery point, should be null if VM is in public cloud
	ExtendedLocation *ExtendedLocation

	// Is the session to recover items from this backup copy still active.
	IsInstantIlrSessionActive *bool

	// Whether VM is with Managed Disks
	IsManagedVirtualMachine *bool

	// This flag denotes if any of the disks in the VM are using Private access network setting
	IsPrivateAccessEnabledOnAnyDisk *bool

	// Identifies whether the VM was encrypted when the backup copy is created.
	IsSourceVMEncrypted *bool

	// Required details for recovering an encrypted VM. Applicable only when IsSourceVMEncrypted is true.
	KeyAndSecret *KeyAndSecretDetails

	// OS type
	OSType *string

	// Original Storage Account Option
	OriginalStorageAccountOption *bool

	// Additional information associated with this backup copy.
	RecoveryPointAdditionalInfo *string

	// Disk configuration
	RecoveryPointDiskConfiguration *RecoveryPointDiskConfiguration

	// Eligibility of RP to be moved to another tier
	RecoveryPointMoveReadinessInfo map[string]*RecoveryPointMoveReadinessInfo

	// Properties of Recovery Point
	RecoveryPointProperties *RecoveryPointProperties

	// Recovery point tier information.
	RecoveryPointTierDetails []*RecoveryPointTierInformationV2

	// Time at which this backup copy was created.
	RecoveryPointTime *time.Time

	// Type of the backup copy.
	RecoveryPointType *string

	// Security Type of the Disk
	SecurityType *string

	// Storage type of the VM whose backup copy is created.
	SourceVMStorageType *string

	// Virtual Machine Size
	VirtualMachineSize *string

	// Identifies the zone of the VM at the time of backup. Applicable only for zone-pinned Vms
	Zones []*string
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type IaasVMRecoveryPoint.
func (i *IaasVMRecoveryPoint) GetRecoveryPoint() *RecoveryPoint {
	return &RecoveryPoint{
		ObjectType: i.ObjectType,
	}
}

// IaasVMRestoreRequest - IaaS VM workload-specific restore.
type IaasVMRestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Affinity group associated to VM to be restored. Used only for Classic Compute Virtual Machines.
	AffinityGroup *string

	// Should a new cloud service be created while restoring the VM. If this is false, VM will be restored to the same cloud service
	// as it was at the time of backup.
	CreateNewCloudService *bool

	// DiskEncryptionSet's ID - needed if the VM needs to be encrypted at rest during restore with customer managed key.
	DiskEncryptionSetID *string

	// Details needed if the VM was encrypted at the time of backup.
	EncryptionDetails *EncryptionDetails

	// Target extended location where the VM should be restored, should be null if restore is to be done in public cloud
	ExtendedLocation *ExtendedLocation

	// IaaS VM workload specific restore details for restores using managed identity.
	IdentityBasedRestoreDetails *IdentityBasedRestoreDetails

	// Managed Identity information required to access customer storage account.
	IdentityInfo *IdentityInfo

	// Original Storage Account Option
	OriginalStorageAccountOption *bool

	// ID of the backup copy to be recovered.
	RecoveryPointID *string

	// Type of this recovery.
	RecoveryType *RecoveryType

	// Region in which the virtual machine is restored.
	Region *string

	// List of Disk LUNs for partial restore
	RestoreDiskLunList []*int32

	// Flag to denote of an Unmanaged disk VM should be restored with Managed disks.
	RestoreWithManagedDisks *bool

	// Stores Secured VM Details
	SecuredVMDetails *SecuredVMDetails

	// Fully qualified ARM ID of the VM which is being recovered.
	SourceResourceID *string

	// Fully qualified ARM ID of the storage account to which the VM has to be restored.
	StorageAccountID *string

	// Subnet ID, is the subnet ID associated with the to be restored VM. For Classic VMs it would be {VnetID}/Subnet/{SubnetName}
	// and, for the Azure Resource Manager VMs it would be ARM resource ID used to
	// represent the subnet.
	SubnetID *string

	// Specifies target network access settings for disks of VM to be restored,
	TargetDiskNetworkAccessSettings *TargetDiskNetworkAccessSettings

	// Fully qualified ARM ID of the domain name to be associated to the VM being restored. This applies only to Classic Virtual
	// Machines.
	TargetDomainNameID *string

	// This is the ARM Id of the resource group that you want to create for this Virtual machine and other artifacts. For e.g.
	// /subscriptions/{subId}/resourcegroups/{rg}
	TargetResourceGroupID *string

	// This is the complete ARM Id of the VM that will be created. For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string

	// This is the virtual network Id of the vnet that will be attached to the virtual machine. User will be validated for join
	// action permissions in the linked access.
	VirtualNetworkID *string

	// Target zone where the VM and its disks should be restored.
	Zones []*string
}

// GetIaasVMRestoreRequest implements the IaasVMRestoreRequestClassification interface for type IaasVMRestoreRequest.
func (i *IaasVMRestoreRequest) GetIaasVMRestoreRequest() *IaasVMRestoreRequest { return i }

// GetRestoreRequest implements the RestoreRequestClassification interface for type IaasVMRestoreRequest.
func (i *IaasVMRestoreRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: i.ObjectType,
	}
}

// IaasVMRestoreWithRehydrationRequest - IaaS VM workload-specific restore with integrated rehydration of recovery point.
type IaasVMRestoreWithRehydrationRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Affinity group associated to VM to be restored. Used only for Classic Compute Virtual Machines.
	AffinityGroup *string

	// Should a new cloud service be created while restoring the VM. If this is false, VM will be restored to the same cloud service
	// as it was at the time of backup.
	CreateNewCloudService *bool

	// DiskEncryptionSet's ID - needed if the VM needs to be encrypted at rest during restore with customer managed key.
	DiskEncryptionSetID *string

	// Details needed if the VM was encrypted at the time of backup.
	EncryptionDetails *EncryptionDetails

	// Target extended location where the VM should be restored, should be null if restore is to be done in public cloud
	ExtendedLocation *ExtendedLocation

	// IaaS VM workload specific restore details for restores using managed identity.
	IdentityBasedRestoreDetails *IdentityBasedRestoreDetails

	// Managed Identity information required to access customer storage account.
	IdentityInfo *IdentityInfo

	// Original Storage Account Option
	OriginalStorageAccountOption *bool

	// ID of the backup copy to be recovered.
	RecoveryPointID *string

	// RP Rehydration Info
	RecoveryPointRehydrationInfo *RecoveryPointRehydrationInfo

	// Type of this recovery.
	RecoveryType *RecoveryType

	// Region in which the virtual machine is restored.
	Region *string

	// List of Disk LUNs for partial restore
	RestoreDiskLunList []*int32

	// Flag to denote of an Unmanaged disk VM should be restored with Managed disks.
	RestoreWithManagedDisks *bool

	// Stores Secured VM Details
	SecuredVMDetails *SecuredVMDetails

	// Fully qualified ARM ID of the VM which is being recovered.
	SourceResourceID *string

	// Fully qualified ARM ID of the storage account to which the VM has to be restored.
	StorageAccountID *string

	// Subnet ID, is the subnet ID associated with the to be restored VM. For Classic VMs it would be {VnetID}/Subnet/{SubnetName}
	// and, for the Azure Resource Manager VMs it would be ARM resource ID used to
	// represent the subnet.
	SubnetID *string

	// Specifies target network access settings for disks of VM to be restored,
	TargetDiskNetworkAccessSettings *TargetDiskNetworkAccessSettings

	// Fully qualified ARM ID of the domain name to be associated to the VM being restored. This applies only to Classic Virtual
	// Machines.
	TargetDomainNameID *string

	// This is the ARM Id of the resource group that you want to create for this Virtual machine and other artifacts. For e.g.
	// /subscriptions/{subId}/resourcegroups/{rg}
	TargetResourceGroupID *string

	// This is the complete ARM Id of the VM that will be created. For e.g. /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string

	// This is the virtual network Id of the vnet that will be attached to the virtual machine. User will be validated for join
	// action permissions in the linked access.
	VirtualNetworkID *string

	// Target zone where the VM and its disks should be restored.
	Zones []*string
}

// GetIaasVMRestoreRequest implements the IaasVMRestoreRequestClassification interface for type IaasVMRestoreWithRehydrationRequest.
func (i *IaasVMRestoreWithRehydrationRequest) GetIaasVMRestoreRequest() *IaasVMRestoreRequest {
	return &IaasVMRestoreRequest{
		AffinityGroup:                   i.AffinityGroup,
		CreateNewCloudService:           i.CreateNewCloudService,
		DiskEncryptionSetID:             i.DiskEncryptionSetID,
		EncryptionDetails:               i.EncryptionDetails,
		ExtendedLocation:                i.ExtendedLocation,
		IdentityBasedRestoreDetails:     i.IdentityBasedRestoreDetails,
		IdentityInfo:                    i.IdentityInfo,
		ObjectType:                      i.ObjectType,
		OriginalStorageAccountOption:    i.OriginalStorageAccountOption,
		RecoveryPointID:                 i.RecoveryPointID,
		RecoveryType:                    i.RecoveryType,
		Region:                          i.Region,
		RestoreDiskLunList:              i.RestoreDiskLunList,
		RestoreWithManagedDisks:         i.RestoreWithManagedDisks,
		SecuredVMDetails:                i.SecuredVMDetails,
		SourceResourceID:                i.SourceResourceID,
		StorageAccountID:                i.StorageAccountID,
		SubnetID:                        i.SubnetID,
		TargetDiskNetworkAccessSettings: i.TargetDiskNetworkAccessSettings,
		TargetDomainNameID:              i.TargetDomainNameID,
		TargetResourceGroupID:           i.TargetResourceGroupID,
		TargetVirtualMachineID:          i.TargetVirtualMachineID,
		VirtualNetworkID:                i.VirtualNetworkID,
		Zones:                           i.Zones,
	}
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type IaasVMRestoreWithRehydrationRequest.
func (i *IaasVMRestoreWithRehydrationRequest) GetRestoreRequest() *RestoreRequest {
	return &RestoreRequest{
		ObjectType: i.ObjectType,
	}
}

// IdentityBasedRestoreDetails - IaaS VM workload specific restore details for restores using managed identity
type IdentityBasedRestoreDetails struct {
	// Gets the class type.
	ObjectType *string

	// Fully qualified ARM ID of the target storage account.
	TargetStorageAccountID *string
}

// IdentityInfo - Encapsulates Managed Identity related information
type IdentityInfo struct {
	// To differentiate if the managed identity is system assigned or user assigned
	IsSystemAssignedIdentity *bool

	// Managed Identity Resource Id Optional: Might not be required in the case of system assigned managed identity
	ManagedIdentityResourceID *string
}

// InquiryInfo - Details about inquired protectable items under a given container.
type InquiryInfo struct {
	// Error Details if the Status is non-success.
	ErrorDetail *ErrorDetail

	// Inquiry Details which will have workload specific details. For e.g. - For SQL and oracle this will contain different details.
	InquiryDetails []*WorkloadInquiryDetails

	// Inquiry Status for this container such as InProgress | Failed | Succeeded
	Status *string
}

// InquiryValidation - Validation for inquired protectable items under a given container.
type InquiryValidation struct {
	// Error Detail in case the status is non-success.
	ErrorDetail *ErrorDetail

	// Status for the Inquiry Validation.
	Status *string

	// READ-ONLY; Error Additional Detail in case the status is non-success.
	AdditionalDetail *string

	// READ-ONLY; Dictionary to store the count of ProtectableItems with key POType.
	ProtectableItemCount any
}

// InstantItemRecoveryTarget - Target details for file / folder restore.
type InstantItemRecoveryTarget struct {
	// List of client scripts.
	ClientScripts []*ClientScriptForConnect
}

type InstantRPAdditionalDetails struct {
	AzureBackupRGNamePrefix *string
	AzureBackupRGNameSuffix *string
}

// Job - Defines workload agnostic properties for a job.
type Job struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string

	// ActivityId of job.
	ActivityID *string

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType

	// The end time.
	EndTime *time.Time

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string

	// The operation name.
	Operation *string

	// The start time.
	StartTime *time.Time

	// Job status.
	Status *string
}

// GetJob implements the JobClassification interface for type Job.
func (j *Job) GetJob() *Job { return j }

// JobQueryObject - Filters to list the jobs.
type JobQueryObject struct {
	// Type of backup management for the job.
	BackupManagementType *BackupManagementType

	// Job has ended at this time. Value is in UTC.
	EndTime *time.Time

	// JobID represents the job uniquely.
	JobID *string

	// Type of operation.
	Operation *JobOperationType

	// Job has started at this time. Value is in UTC.
	StartTime *time.Time

	// Status of the job.
	Status *JobStatus
}

// JobResource - Defines workload agnostic properties for a job.
type JobResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// JobResource properties
	Properties JobClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// JobResourceList - List of Job resources
type JobResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*JobResource
}

// KEKDetails - KEK is encryption key for BEK.
type KEKDetails struct {
	// KEK data.
	KeyBackupData *string

	// Key is KEK.
	KeyURL *string

	// Key Vault ID where this Key is stored.
	KeyVaultID *string
}

// KPIResourceHealthDetails - KPI Resource Health Details
type KPIResourceHealthDetails struct {
	// Resource Health Status
	ResourceHealthDetails []*ResourceHealthDetails

	// Resource Health Status
	ResourceHealthStatus *ResourceHealthStatus
}

// KeyAndSecretDetails - BEK is bitlocker key. KEK is encryption key for BEK If the VM was encrypted then we will store following
// details :
// 1. Secret(BEK) - Url + Backup Data + vaultId.
// 2. Key(KEK) - Url + Backup Data + vaultId.
// 3. EncryptionMechanism BEK and KEK can potentially have different vault ids.
type KeyAndSecretDetails struct {
	// BEK is bitlocker encryption key.
	BekDetails *BEKDetails

	// Encryption mechanism: None/ SinglePass/ DoublePass
	EncryptionMechanism *string

	// KEK is encryption key for BEK.
	KekDetails *KEKDetails
}

// ListRecoveryPointsRecommendedForMoveRequest Request
type ListRecoveryPointsRecommendedForMoveRequest struct {
	// List of Recovery Points excluded from Move
	ExcludedRPList []*string

	// Gets the class type.
	ObjectType *string
}

// LogSchedulePolicy - Log policy schedule.
type LogSchedulePolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	SchedulePolicyType *string

	// Frequency of the log schedule operation of this policy in minutes.
	ScheduleFrequencyInMins *int32
}

// GetSchedulePolicy implements the SchedulePolicyClassification interface for type LogSchedulePolicy.
func (l *LogSchedulePolicy) GetSchedulePolicy() *SchedulePolicy {
	return &SchedulePolicy{
		SchedulePolicyType: l.SchedulePolicyType,
	}
}

// LongTermRetentionPolicy - Long term retention policy.
type LongTermRetentionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	RetentionPolicyType *string

	// Daily retention schedule of the protection policy.
	DailySchedule *DailyRetentionSchedule

	// Monthly retention schedule of the protection policy.
	MonthlySchedule *MonthlyRetentionSchedule

	// Weekly retention schedule of the protection policy.
	WeeklySchedule *WeeklyRetentionSchedule

	// Yearly retention schedule of the protection policy.
	YearlySchedule *YearlyRetentionSchedule
}

// GetRetentionPolicy implements the RetentionPolicyClassification interface for type LongTermRetentionPolicy.
func (l *LongTermRetentionPolicy) GetRetentionPolicy() *RetentionPolicy {
	return &RetentionPolicy{
		RetentionPolicyType: l.RetentionPolicyType,
	}
}

// LongTermSchedulePolicy - Long term policy schedule.
type LongTermSchedulePolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	SchedulePolicyType *string
}

// GetSchedulePolicy implements the SchedulePolicyClassification interface for type LongTermSchedulePolicy.
func (l *LongTermSchedulePolicy) GetSchedulePolicy() *SchedulePolicy {
	return &SchedulePolicy{
		SchedulePolicyType: l.SchedulePolicyType,
	}
}

// MABContainerHealthDetails - MAB workload-specific Health Details.
type MABContainerHealthDetails struct {
	// Health Code
	Code *int32

	// Health Message
	Message *string

	// Health Recommended Actions
	Recommendations []*string

	// Health Title
	Title *string
}

// MabContainer - Container with items backed up using MAB backup engine.
type MabContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ProtectableContainerType

	// Agent version of this container.
	AgentVersion *string

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Can the container be registered one more time.
	CanReRegister *bool

	// Health state of mab container.
	ContainerHealthState *string

	// ContainerID represents the container.
	ContainerID *int64

	// Additional information for this container
	ExtendedInfo *MabContainerExtendedInfo

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string

	// Health details on this mab container.
	MabContainerHealthDetails []*MABContainerHealthDetails

	// Type of the protectable object associated with this container
	ProtectableObjectType *string

	// Number of items backed up in this container.
	ProtectedItemCount *int64

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type MabContainer.
func (m *MabContainer) GetProtectionContainer() *ProtectionContainer {
	return &ProtectionContainer{
		BackupManagementType:  m.BackupManagementType,
		ContainerType:         m.ContainerType,
		FriendlyName:          m.FriendlyName,
		HealthStatus:          m.HealthStatus,
		ProtectableObjectType: m.ProtectableObjectType,
		RegistrationStatus:    m.RegistrationStatus,
	}
}

// MabContainerExtendedInfo - Additional information of the container.
type MabContainerExtendedInfo struct {
	// Type of backup items associated with this container.
	BackupItemType *BackupItemType

	// List of backup items associated with this container.
	BackupItems []*string

	// Latest backup status of this container.
	LastBackupStatus *string

	// Time stamp when this container was refreshed.
	LastRefreshedAt *time.Time

	// Backup policy associated with this container.
	PolicyName *string
}

// MabErrorInfo - MAB workload-specific error information.
type MabErrorInfo struct {
	// READ-ONLY; Localized error string.
	ErrorString *string

	// READ-ONLY; List of localized recommendations.
	Recommendations []*string
}

// MabFileFolderProtectedItem - MAB workload-specific backup item.
type MabFileFolderProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Name of the computer associated with this backup item.
	ComputerName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Sync time for deferred deletion in UTC
	DeferredDeleteSyncTimeInUTC *int64

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Additional information with this backup item.
	ExtendedInfo *MabFileFolderProtectedItemExtendedInfo

	// Friendly name of this backup item.
	FriendlyName *string

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Status of last backup operation.
	LastBackupStatus *string

	// Timestamp of the last backup operation on this backup item.
	LastBackupTime *time.Time

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// Protected, ProtectionStopped, IRPending or ProtectionError
	ProtectionState *string

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetProtectedItem implements the ProtectedItemClassification interface for type MabFileFolderProtectedItem.
func (m *MabFileFolderProtectedItem) GetProtectedItem() *ProtectedItem {
	return &ProtectedItem{
		BackupManagementType:             m.BackupManagementType,
		BackupSetName:                    m.BackupSetName,
		ContainerName:                    m.ContainerName,
		CreateMode:                       m.CreateMode,
		DeferredDeleteTimeInUTC:          m.DeferredDeleteTimeInUTC,
		DeferredDeleteTimeRemaining:      m.DeferredDeleteTimeRemaining,
		IsArchiveEnabled:                 m.IsArchiveEnabled,
		IsDeferredDeleteScheduleUpcoming: m.IsDeferredDeleteScheduleUpcoming,
		IsRehydrate:                      m.IsRehydrate,
		IsScheduledForDeferredDelete:     m.IsScheduledForDeferredDelete,
		LastRecoveryPoint:                m.LastRecoveryPoint,
		PolicyID:                         m.PolicyID,
		PolicyName:                       m.PolicyName,
		ProtectedItemType:                m.ProtectedItemType,
		ResourceGuardOperationRequests:   m.ResourceGuardOperationRequests,
		SoftDeleteRetentionPeriodInDays:  m.SoftDeleteRetentionPeriodInDays,
		SourceResourceID:                 m.SourceResourceID,
		VaultID:                          m.VaultID,
		WorkloadType:                     m.WorkloadType,
	}
}

// MabFileFolderProtectedItemExtendedInfo - Additional information on the backed up item.
type MabFileFolderProtectedItemExtendedInfo struct {
	// Last time when the agent data synced to service.
	LastRefreshedAt *time.Time

	// The oldest backup copy available.
	OldestRecoveryPoint *time.Time

	// Number of backup copies associated with the backup item.
	RecoveryPointCount *int32
}

// MabJob - MAB workload-specific job.
type MabJob struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string

	// The state/actions applicable on jobs like cancel/retry.
	ActionsInfo []*JobSupportedAction

	// ActivityId of job.
	ActivityID *string

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType

	// Time taken by job to run.
	Duration *string

	// The end time.
	EndTime *time.Time

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string

	// The errors.
	ErrorDetails []*MabErrorInfo

	// Additional information on the job.
	ExtendedInfo *MabJobExtendedInfo

	// Name of server protecting the DS.
	MabServerName *string

	// Server type of MAB container.
	MabServerType *MabServerType

	// The operation name.
	Operation *string

	// The start time.
	StartTime *time.Time

	// Job status.
	Status *string

	// Workload type of backup item.
	WorkloadType *WorkloadType
}

// GetJob implements the JobClassification interface for type MabJob.
func (m *MabJob) GetJob() *Job {
	return &Job{
		ActivityID:           m.ActivityID,
		BackupManagementType: m.BackupManagementType,
		EndTime:              m.EndTime,
		EntityFriendlyName:   m.EntityFriendlyName,
		JobType:              m.JobType,
		Operation:            m.Operation,
		StartTime:            m.StartTime,
		Status:               m.Status,
	}
}

// MabJobExtendedInfo - Additional information for the MAB workload-specific job.
type MabJobExtendedInfo struct {
	// Non localized error message specific to this job.
	DynamicErrorMessage *string

	// The job properties.
	PropertyBag map[string]*string

	// List of tasks for this job.
	TasksList []*MabJobTaskDetails
}

// MabJobTaskDetails - MAB workload-specific job task details.
type MabJobTaskDetails struct {
	// Time elapsed for task.
	Duration *string

	// The end time.
	EndTime *time.Time

	// The start time.
	StartTime *time.Time

	// The status.
	Status *string

	// The task display name.
	TaskID *string
}

// MabProtectionPolicy - Mab container-specific backup policy.
type MabProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string

	// Number of items associated with this policy.
	ProtectedItemsCount *int32

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string

	// Retention policy details.
	RetentionPolicy RetentionPolicyClassification

	// Backup schedule of backup policy.
	SchedulePolicy SchedulePolicyClassification
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type MabProtectionPolicy.
func (m *MabProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy {
	return &ProtectionPolicy{
		BackupManagementType:           m.BackupManagementType,
		ProtectedItemsCount:            m.ProtectedItemsCount,
		ResourceGuardOperationRequests: m.ResourceGuardOperationRequests,
	}
}

// MonthlyRetentionSchedule - Monthly retention schedule.
type MonthlyRetentionSchedule struct {
	// Retention duration of retention Policy.
	RetentionDuration *RetentionDuration

	// Daily retention format for monthly retention policy.
	RetentionScheduleDaily *DailyRetentionFormat

	// Retention schedule format type for monthly retention policy.
	RetentionScheduleFormatType *RetentionScheduleFormat

	// Weekly retention format for monthly retention policy.
	RetentionScheduleWeekly *WeeklyRetentionFormat

	// Retention times of retention policy.
	RetentionTimes []*time.Time
}

type MoveRPAcrossTiersRequest struct {
	// Gets the class type.
	ObjectType *string

	// Source tier from where RP needs to be moved
	SourceTierType *RecoveryPointTierType

	// Target tier where RP needs to be moved
	TargetTierType *RecoveryPointTierType
}

// NameInfo - The name of usage.
type NameInfo struct {
	// Localized value of usage.
	LocalizedValue *string

	// Value of usage.
	Value *string
}

// NewErrorResponse - The resource management error response.
type NewErrorResponse struct {
	// The error object.
	Error *NewErrorResponseError
}

// NewErrorResponseError - The error object.
type NewErrorResponseError struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*NewErrorResponse

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// OperationResultInfo - Operation result info.
type OperationResultInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// List of jobs created by this operation.
	JobList []*string
}

// GetOperationResultInfoBase implements the OperationResultInfoBaseClassification interface for type OperationResultInfo.
func (o *OperationResultInfo) GetOperationResultInfoBase() *OperationResultInfoBase {
	return &OperationResultInfoBase{
		ObjectType: o.ObjectType,
	}
}

// OperationResultInfoBase - Base class for operation result info.
type OperationResultInfoBase struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string
}

// GetOperationResultInfoBase implements the OperationResultInfoBaseClassification interface for type OperationResultInfoBase.
func (o *OperationResultInfoBase) GetOperationResultInfoBase() *OperationResultInfoBase { return o }

// OperationResultInfoBaseResource - Base class for operation result info.
type OperationResultInfoBaseResource struct {
	// HTTP headers associated with this operation.
	Headers map[string][]*string

	// OperationResultInfoBaseResource operation
	Operation OperationResultInfoBaseClassification

	// HTTP Status Code of the operation.
	StatusCode *HTTPStatusCode
}

// OperationStatus - Operation status.
type OperationStatus struct {
	// Operation end time. Format: ISO-8601.
	EndTime *time.Time

	// Error information related to this operation.
	Error *OperationStatusError

	// ID of the operation.
	ID *string

	// Name of the operation.
	Name *string

	// Additional information associated with this operation.
	Properties OperationStatusExtendedInfoClassification

	// Operation start time. Format: ISO-8601.
	StartTime *time.Time

	// Operation status.
	Status *OperationStatusValues
}

// OperationStatusError - Error information associated with operation status call.
type OperationStatusError struct {
	// Error code of the operation failure.
	Code *string

	// Error message displayed if the operation failure.
	Message *string
}

// OperationStatusExtendedInfo - Base class for additional information of operation status.
type OperationStatusExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string
}

// GetOperationStatusExtendedInfo implements the OperationStatusExtendedInfoClassification interface for type OperationStatusExtendedInfo.
func (o *OperationStatusExtendedInfo) GetOperationStatusExtendedInfo() *OperationStatusExtendedInfo {
	return o
}

// OperationStatusJobExtendedInfo - Operation status job extended info.
type OperationStatusJobExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// ID of the job created for this protected item.
	JobID *string
}

// GetOperationStatusExtendedInfo implements the OperationStatusExtendedInfoClassification interface for type OperationStatusJobExtendedInfo.
func (o *OperationStatusJobExtendedInfo) GetOperationStatusExtendedInfo() *OperationStatusExtendedInfo {
	return &OperationStatusExtendedInfo{
		ObjectType: o.ObjectType,
	}
}

// OperationStatusJobsExtendedInfo - Operation status extended info for list of jobs.
type OperationStatusJobsExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Stores all the failed jobs along with the corresponding error codes.
	FailedJobsError map[string]*string

	// IDs of the jobs created for the protected item.
	JobIDs []*string
}

// GetOperationStatusExtendedInfo implements the OperationStatusExtendedInfoClassification interface for type OperationStatusJobsExtendedInfo.
func (o *OperationStatusJobsExtendedInfo) GetOperationStatusExtendedInfo() *OperationStatusExtendedInfo {
	return &OperationStatusExtendedInfo{
		ObjectType: o.ObjectType,
	}
}

// OperationStatusProvisionILRExtendedInfo - Operation status extended info for ILR provision action.
type OperationStatusProvisionILRExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Target details for file / folder restore.
	RecoveryTarget *InstantItemRecoveryTarget
}

// GetOperationStatusExtendedInfo implements the OperationStatusExtendedInfoClassification interface for type OperationStatusProvisionILRExtendedInfo.
func (o *OperationStatusProvisionILRExtendedInfo) GetOperationStatusExtendedInfo() *OperationStatusExtendedInfo {
	return &OperationStatusExtendedInfo{
		ObjectType: o.ObjectType,
	}
}

// OperationStatusValidateOperationExtendedInfo - Operation status extended info for ValidateOperation action.
type OperationStatusValidateOperationExtendedInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Gets the validation operation response
	ValidateOperationResponse *ValidateOperationResponse
}

// GetOperationStatusExtendedInfo implements the OperationStatusExtendedInfoClassification interface for type OperationStatusValidateOperationExtendedInfo.
func (o *OperationStatusValidateOperationExtendedInfo) GetOperationStatusExtendedInfo() *OperationStatusExtendedInfo {
	return &OperationStatusExtendedInfo{
		ObjectType: o.ObjectType,
	}
}

// OperationWorkerResponse - This is the base class for operation result responses.
type OperationWorkerResponse struct {
	// HTTP headers associated with this operation.
	Headers map[string][]*string

	// HTTP Status Code of the operation.
	StatusCode *HTTPStatusCode
}

// PointInTimeRange - Provides details for log ranges
type PointInTimeRange struct {
	// End time of the time range for log recovery.
	EndTime *time.Time

	// Start time of the time range for log recovery.
	StartTime *time.Time
}

// PreBackupValidation - Pre-backup validation for Azure VM Workload provider.
type PreBackupValidation struct {
	// Error code of protectable item
	Code *string

	// Message corresponding to the error code for the protectable item
	Message *string

	// Status of protectable item, i.e. InProgress,Succeeded,Failed
	Status *InquiryStatus
}

// PreValidateEnableBackupRequest - Contract to validate if backup can be enabled on the given resource in a given vault and
// given configuration. It will validate followings
// 1. Vault capacity
// 2. VM is already protected
// 3. Any VM related configuration passed in properties.
type PreValidateEnableBackupRequest struct {
	// Configuration of VM if any needs to be validated like OS type etc
	Properties *string

	// ARM Virtual Machine Id
	ResourceID *string

	// ProtectedItem Type- VM, SqlDataBase, AzureFileShare etc
	ResourceType *DataSourceType

	// ARM id of the Recovery Services Vault
	VaultID *string
}

// PreValidateEnableBackupResponse - Response contract for enable backup validation request
type PreValidateEnableBackupResponse struct {
	// Specifies the product specific container name. E.g. iaasvmcontainer;iaasvmcontainer;rgname;vmname. This is required for
	// portal
	ContainerName *string

	// Response error code
	ErrorCode *string

	// Response error message
	ErrorMessage *string

	// Specifies the product specific ds name. E.g. vm;iaasvmcontainer;rgname;vmname. This is required for portal
	ProtectedItemName *string

	// Recommended action for user
	Recommendation *string

	// Validation Status
	Status *ValidationStatus
}

// PrepareDataMoveRequest - Prepare DataMove Request
type PrepareDataMoveRequest struct {
	// REQUIRED; DataMove Level
	DataMoveLevel *DataMoveLevel

	// REQUIRED; Target Region
	TargetRegion *string

	// REQUIRED; ARM Id of target vault
	TargetResourceID *string

	// Ignore the artifacts which are already moved.
	IgnoreMoved *bool

	// Source Container ArmIds This needs to be populated only if DataMoveLevel is set to container
	SourceContainerArmIDs []*string
}

// PrepareDataMoveResponse - Prepare DataMove Response
type PrepareDataMoveResponse struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Co-relationId for move operation
	CorrelationID *string

	// Source Vault Properties
	SourceVaultProperties map[string]*string
}

// GetVaultStorageConfigOperationResultResponse implements the VaultStorageConfigOperationResultResponseClassification interface
// for type PrepareDataMoveResponse.
func (p *PrepareDataMoveResponse) GetVaultStorageConfigOperationResultResponse() *VaultStorageConfigOperationResultResponse {
	return &VaultStorageConfigOperationResultResponse{
		ObjectType: p.ObjectType,
	}
}

// PrivateEndpoint - The Private Endpoint network resource that is linked to the Private Endpoint connection
type PrivateEndpoint struct {
	// Gets or sets id
	ID *string
}

// PrivateEndpointConnection - Private Endpoint Connection Response Properties
type PrivateEndpointConnection struct {
	// Group Ids for the Private Endpoint
	GroupIDs []*VaultSubResourceType

	// Gets or sets private endpoint associated with the private endpoint connection
	PrivateEndpoint *PrivateEndpoint

	// Gets or sets private link service connection state
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// Gets or sets provisioning state of the private endpoint connection
	ProvisioningState *ProvisioningState
}

// PrivateEndpointConnectionResource - Private Endpoint Connection Response Properties
type PrivateEndpointConnectionResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// PrivateEndpointConnectionResource properties
	Properties *PrivateEndpointConnection

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// PrivateLinkServiceConnectionState - Private Link Service Connection State
type PrivateLinkServiceConnectionState struct {
	// Gets or sets actions required
	ActionsRequired *string

	// Gets or sets description
	Description *string

	// Gets or sets the status
	Status *PrivateEndpointConnectionStatus
}

// ProtectableContainer - Protectable Container Class.
type ProtectableContainer struct {
	// REQUIRED; Type of the container. The value of this property for
	// 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines
	ProtectableContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Fabric Id of the container such as ARM Id.
	ContainerID *string

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string
}

// GetProtectableContainer implements the ProtectableContainerClassification interface for type ProtectableContainer.
func (p *ProtectableContainer) GetProtectableContainer() *ProtectableContainer { return p }

// ProtectableContainerResource - Protectable Container Class.
type ProtectableContainerResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// ProtectableContainerResource properties
	Properties ProtectableContainerClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// ProtectableContainerResourceList - List of ProtectableContainer resources
type ProtectableContainerResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*ProtectableContainerResource
}

// ProtectedItem - Base class for backup items.
type ProtectedItem struct {
	// REQUIRED; backup item type.
	ProtectedItemType *string

	// Name of the backup set the backup item belongs to
	BackupSetName *string

	// Unique name of container
	ContainerName *string

	// Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
	CreateMode *CreateMode

	// Time for deferred deletion in UTC
	DeferredDeleteTimeInUTC *time.Time

	// Time remaining before the DS marked for deferred delete is permanently deleted
	DeferredDeleteTimeRemaining *string

	// Flag to identify whether datasource is protected in archive
	IsArchiveEnabled *bool

	// Flag to identify whether the deferred deleted DS is to be purged soon
	IsDeferredDeleteScheduleUpcoming *bool

	// Flag to identify that deferred deleted DS is to be moved into Pause state
	IsRehydrate *bool

	// Flag to identify whether the DS is scheduled for deferred delete
	IsScheduledForDeferredDelete *bool

	// Timestamp when the last (latest) backup copy was created for this backup item.
	LastRecoveryPoint *time.Time

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Name of the policy used for protection
	PolicyName *string

	// ResourceGuardOperationRequests on which LAC check will be performed
	ResourceGuardOperationRequests []*string

	// Soft delete retention period in days
	SoftDeleteRetentionPeriodInDays *int32

	// ARM ID of the resource to be backed up.
	SourceResourceID *string

	// READ-ONLY; Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// READ-ONLY; ID of the vault which protects this item
	VaultID *string

	// READ-ONLY; Type of workload this item represents.
	WorkloadType *DataSourceType
}

// GetProtectedItem implements the ProtectedItemClassification interface for type ProtectedItem.
func (p *ProtectedItem) GetProtectedItem() *ProtectedItem { return p }

// ProtectedItemQueryObject - Filters to list backup items.
type ProtectedItemQueryObject struct {
	// Backup Engine name
	BackupEngineName *string

	// Backup management type for the backed up item.
	BackupManagementType *BackupManagementType

	// Name of the backup set.
	BackupSetName *string

	// Name of the container.
	ContainerName *string

	// Name of the fabric.
	FabricName *string

	// Friendly name of protected item
	FriendlyName *string

	// Health State for the backed up item.
	HealthState *HealthState

	// Type of workload this item represents.
	ItemType *DataSourceType

	// Backup policy name associated with the backup item.
	PolicyName *string
}

// ProtectedItemResource - Base class for backup items.
type ProtectedItemResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// ProtectedItemResource properties
	Properties ProtectedItemClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// ProtectedItemResourceList - List of ProtectedItem resources
type ProtectedItemResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*ProtectedItemResource
}

// ProtectionContainer - Base class for container with backup items. Containers with specific workloads are derived from this
// class.
type ProtectionContainer struct {
	// REQUIRED; Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines
	// 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows
	// machines (like MAB, DPM etc) is Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
	// 6. Azure workload Backup is VMAppContainer
	ContainerType *ProtectableContainerType

	// Type of backup management for the container.
	BackupManagementType *BackupManagementType

	// Friendly name of the container.
	FriendlyName *string

	// Status of health of the container.
	HealthStatus *string

	// Type of the protectable object associated with this container
	ProtectableObjectType *string

	// Status of registration of the container with the Recovery Services Vault.
	RegistrationStatus *string
}

// GetProtectionContainer implements the ProtectionContainerClassification interface for type ProtectionContainer.
func (p *ProtectionContainer) GetProtectionContainer() *ProtectionContainer { return p }

// ProtectionContainerResource - Base class for container with backup items. Containers with specific workloads are derived
// from this class.
type ProtectionContainerResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// ProtectionContainerResource properties
	Properties ProtectionContainerClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// ProtectionContainerResourceList - List of ProtectionContainer resources
type ProtectionContainerResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*ProtectionContainerResource
}

// ProtectionIntent - Base class for backup ProtectionIntent.
type ProtectionIntent struct {
	// REQUIRED; backup protectionIntent type.
	ProtectionIntentItemType *ProtectionIntentItemType

	// Type of backup management for the backed up item.
	BackupManagementType *BackupManagementType

	// ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
	ItemID *string

	// ID of the backup policy with which this item is backed up.
	PolicyID *string

	// Backup state of this backup item.
	ProtectionState *ProtectionStatus

	// ARM ID of the resource to be backed up.
	SourceResourceID *string
}

// GetProtectionIntent implements the ProtectionIntentClassification interface for type ProtectionIntent.
func (p *ProtectionIntent) GetProtectionIntent() *ProtectionIntent { return p }

// ProtectionIntentQueryObject - Filters to list protection intent.
type ProtectionIntentQueryObject struct {
	// Backup management type for the backed up item
	BackupManagementType *BackupManagementType

	// Item name of the intent
	ItemName *string

	// Type of workload this item represents
	ItemType *IntentItemType

	// Parent name of the intent
	ParentName *string
}

// ProtectionIntentResource - Base class for backup ProtectionIntent.
type ProtectionIntentResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// ProtectionIntentResource properties
	Properties ProtectionIntentClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// ProtectionIntentResourceList - List of ProtectionIntent resources
type ProtectionIntentResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*ProtectionIntentResource
}

// ProtectionPolicy - Base class for backup policy. Workload-specific backup policies are derived from this class.
type ProtectionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	BackupManagementType *string

	// Number of items associated with this policy.
	ProtectedItemsCount *int32

	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string
}

// GetProtectionPolicy implements the ProtectionPolicyClassification interface for type ProtectionPolicy.
func (p *ProtectionPolicy) GetProtectionPolicy() *ProtectionPolicy { return p }

// ProtectionPolicyQueryObject - Filters the list backup policies API.
type ProtectionPolicyQueryObject struct {
	// Backup management type for the backup policy.
	BackupManagementType *BackupManagementType

	// Fabric name for filter
	FabricName *string

	// Workload type for the backup policy.
	WorkloadType *WorkloadType
}

// ProtectionPolicyResource - Base class for backup policy. Workload-specific backup policies are derived from this class.
type ProtectionPolicyResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// ProtectionPolicyResource properties
	Properties ProtectionPolicyClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// ProtectionPolicyResourceList - List of ProtectionPolicy resources
type ProtectionPolicyResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*ProtectionPolicyResource
}

// RecoveryPoint - Base class for backup copies. Workload-specific backup copies are derived from this class.
type RecoveryPoint struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string
}

// GetRecoveryPoint implements the RecoveryPointClassification interface for type RecoveryPoint.
func (r *RecoveryPoint) GetRecoveryPoint() *RecoveryPoint { return r }

// RecoveryPointDiskConfiguration - Disk configuration
type RecoveryPointDiskConfiguration struct {
	// Information of disks excluded from backup
	ExcludedDiskList []*DiskInformation

	// Information of disks included in backup
	IncludedDiskList []*DiskInformation

	// Number of disks attached to the VM
	NumberOfDisksAttachedToVM *int32

	// Number of disks included in backup
	NumberOfDisksIncludedInBackup *int32
}

type RecoveryPointMoveReadinessInfo struct {
	AdditionalInfo *string
	IsReadyForMove *bool
}

// RecoveryPointProperties - Properties of Recovery Point
type RecoveryPointProperties struct {
	// Expiry time of Recovery Point in UTC.
	ExpiryTime *string

	// Bool to indicate whether RP is in soft delete state or not
	IsSoftDeleted *bool

	// Rule name tagged on Recovery Point that governs life cycle
	RuleName *string
}

// RecoveryPointRehydrationInfo - RP Rehydration Info
type RecoveryPointRehydrationInfo struct {
	// Rehydration Priority
	RehydrationPriority *RehydrationPriority

	// How long the rehydrated RP should be kept Should be ISO8601 Duration format e.g. "P7D"
	RehydrationRetentionDuration *string
}

// RecoveryPointResource - Base class for backup copies. Workload-specific backup copies are derived from this class.
type RecoveryPointResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// RecoveryPointResource properties
	Properties RecoveryPointClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// RecoveryPointResourceList - List of RecoveryPoint resources
type RecoveryPointResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*RecoveryPointResource
}

// RecoveryPointTierInformation - Recovery point tier information.
type RecoveryPointTierInformation struct {
	// Recovery point tier status.
	ExtendedInfo map[string]*string

	// Recovery point tier status.
	Status *RecoveryPointTierStatus

	// Recovery point tier type.
	Type *RecoveryPointTierType
}

// RecoveryPointTierInformationV2 - RecoveryPoint Tier Information V2
type RecoveryPointTierInformationV2 struct {
	// Recovery point tier status.
	ExtendedInfo map[string]*string

	// Recovery point tier status.
	Status *RecoveryPointTierStatus

	// Recovery point tier type.
	Type *RecoveryPointTierType
}

// Resource - ARM Resource.
type Resource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

type ResourceGuardOperationDetail struct {
	DefaultResourceRequest *string
	VaultCriticalOperation *string
}

type ResourceGuardProxyBase struct {
	// REQUIRED
	ResourceGuardResourceID       *string
	Description                   *string
	LastUpdatedTime               *string
	ResourceGuardOperationDetails []*ResourceGuardOperationDetail
}

type ResourceGuardProxyBaseResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// ResourceGuardProxyBaseResource properties
	Properties *ResourceGuardProxyBase

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// ResourceGuardProxyBaseResourceList - List of ResourceGuardProxyBase resources
type ResourceGuardProxyBaseResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*ResourceGuardProxyBaseResource
}

// ResourceHealthDetails - Health Details for backup items.
type ResourceHealthDetails struct {
	// READ-ONLY; Health Code
	Code *int32

	// READ-ONLY; Health Message
	Message *string

	// READ-ONLY; Health Recommended Actions
	Recommendations []*string

	// READ-ONLY; Health Title
	Title *string
}

// ResourceList - Base for all lists of resources.
type ResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string
}

// RestoreFileSpecs - Restore file specs like file path, type and target folder path info.
type RestoreFileSpecs struct {
	// Indicates what the Path variable stands for
	FileSpecType *string

	// Source File/Folder path
	Path *string

	// Destination folder path in target FileShare
	TargetFolderPath *string
}

// RestoreRequest - Base class for restore request. Workload-specific restore requests are derived from this class.
type RestoreRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string
}

// GetRestoreRequest implements the RestoreRequestClassification interface for type RestoreRequest.
func (r *RestoreRequest) GetRestoreRequest() *RestoreRequest { return r }

// RestoreRequestResource - Base class for restore request. Workload-specific restore requests are derived from this class.
type RestoreRequestResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// RestoreRequestResource properties
	Properties RestoreRequestClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// RetentionDuration - Retention duration.
type RetentionDuration struct {
	// Count of duration types. Retention duration is obtained by the counting the duration type Count times. For example, when
	// Count = 3 and DurationType = Weeks, retention duration will be three weeks.
	Count *int32

	// Retention duration type of retention policy.
	DurationType *RetentionDurationType
}

// RetentionPolicy - Base class for retention policy.
type RetentionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	RetentionPolicyType *string
}

// GetRetentionPolicy implements the RetentionPolicyClassification interface for type RetentionPolicy.
func (r *RetentionPolicy) GetRetentionPolicy() *RetentionPolicy { return r }

// SQLDataDirectory info
type SQLDataDirectory struct {
	// Logical name of the file
	LogicalName *string

	// File path
	Path *string

	// Type of data directory mapping
	Type *SQLDataDirectoryType
}

// SQLDataDirectoryMapping - Encapsulates information regarding data directory
type SQLDataDirectoryMapping struct {
	// Type of data directory mapping
	MappingType *SQLDataDirectoryType

	// Restore source logical name path
	SourceLogicalName *string

	// Restore source path
	SourcePath *string

	// Target path
	TargetPath *string
}

// SchedulePolicy - Base class for backup schedule.
type SchedulePolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	SchedulePolicyType *string
}

// GetSchedulePolicy implements the SchedulePolicyClassification interface for type SchedulePolicy.
func (s *SchedulePolicy) GetSchedulePolicy() *SchedulePolicy { return s }

// SecuredVMDetails - Restore request parameters for Secured VMs
type SecuredVMDetails struct {
	// Gets or Sets Disk Encryption Set Id for Secured VM OS Disk
	SecuredVMOsDiskEncryptionSetID *string
}

// SecurityPinBase - Base class for get security pin request body
type SecurityPinBase struct {
	// ResourceGuard Operation Requests
	ResourceGuardOperationRequests []*string
}

// Settings - Common settings field for backup management
type Settings struct {
	// Workload compression flag. This has been added so that 'isSqlCompression' will be deprecated once clients upgrade to consider
	// this flag.
	IsCompression *bool

	// SQL compression flag
	Issqlcompression *bool

	// TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
	TimeZone *string
}

// SimpleRetentionPolicy - Simple policy retention.
type SimpleRetentionPolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	RetentionPolicyType *string

	// Retention duration of the protection policy.
	RetentionDuration *RetentionDuration
}

// GetRetentionPolicy implements the RetentionPolicyClassification interface for type SimpleRetentionPolicy.
func (s *SimpleRetentionPolicy) GetRetentionPolicy() *RetentionPolicy {
	return &RetentionPolicy{
		RetentionPolicyType: s.RetentionPolicyType,
	}
}

// SimpleSchedulePolicy - Simple policy schedule.
type SimpleSchedulePolicy struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	SchedulePolicyType *string

	// Hourly Schedule of this Policy
	HourlySchedule *HourlySchedule

	// List of days of week this schedule has to be run.
	ScheduleRunDays []*DayOfWeek

	// Frequency of the schedule operation of this policy.
	ScheduleRunFrequency *ScheduleRunType

	// List of times of day this schedule has to be run.
	ScheduleRunTimes []*time.Time

	// At every number weeks this schedule has to be run.
	ScheduleWeeklyFrequency *int32
}

// GetSchedulePolicy implements the SchedulePolicyClassification interface for type SimpleSchedulePolicy.
func (s *SimpleSchedulePolicy) GetSchedulePolicy() *SchedulePolicy {
	return &SchedulePolicy{
		SchedulePolicyType: s.SchedulePolicyType,
	}
}

// SimpleSchedulePolicyV2 - The V2 policy schedule for IaaS that supports hourly backups.
type SimpleSchedulePolicyV2 struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	SchedulePolicyType *string

	// Daily schedule of this policy
	DailySchedule *DailySchedule

	// hourly schedule of this policy
	HourlySchedule *HourlySchedule

	// Frequency of the schedule operation of this policy.
	ScheduleRunFrequency *ScheduleRunType

	// Weekly schedule of this policy
	WeeklySchedule *WeeklySchedule
}

// GetSchedulePolicy implements the SchedulePolicyClassification interface for type SimpleSchedulePolicyV2.
func (s *SimpleSchedulePolicyV2) GetSchedulePolicy() *SchedulePolicy {
	return &SchedulePolicy{
		SchedulePolicyType: s.SchedulePolicyType,
	}
}

// SnapshotBackupAdditionalDetails - Snapshot Backup related fields for WorkloadType SaPHanaSystem
type SnapshotBackupAdditionalDetails struct {
	InstantRPDetails              *string
	InstantRpRetentionRangeInDays *int32

	// User assigned managed identity details
	UserAssignedManagedIdentityDetails *UserAssignedManagedIdentityDetails
}

// SnapshotRestoreParameters - Encapsulates information regarding snapshot recovery for SAP Hana
type SnapshotRestoreParameters struct {
	LogPointInTimeForDBRecovery *string
	SkipAttachAndMount          *bool
}

// SubProtectionPolicy - Sub-protection policy which includes schedule and retention
type SubProtectionPolicy struct {
	// Type of backup policy type
	PolicyType *PolicyType

	// Retention policy with the details on backup copy retention ranges.
	RetentionPolicy RetentionPolicyClassification

	// Backup schedule specified as part of backup policy.
	SchedulePolicy SchedulePolicyClassification

	// Snapshot Backup related fields for WorkloadType SaPHanaSystem
	SnapshotBackupAdditionalDetails *SnapshotBackupAdditionalDetails

	// Tiering policy to automatically move RPs to another tier. Key is Target Tier, defined in RecoveryPointTierType enum. Tiering
	// policy specifies the criteria to move RP to the target tier.
	TieringPolicy map[string]*TieringPolicy
}

// TargetAFSRestoreInfo - Target Azure File Share Info.
type TargetAFSRestoreInfo struct {
	// File share name
	Name *string

	// Target file share resource ARM ID
	TargetResourceID *string
}

// TargetDiskNetworkAccessSettings - Specifies target network access settings for disks of VM to be restored.
type TargetDiskNetworkAccessSettings struct {
	// Gets or sets the ARM resource ID of the target disk access to be used when TargetDiskNetworkAccessOption is set to TargetDiskNetworkAccessOption.UseNew
	TargetDiskAccessID *string

	// Network access settings to be used for restored disks
	TargetDiskNetworkAccessOption *TargetDiskNetworkAccessOption
}

// TargetRestoreInfo - Details about target workload during restore operation.
type TargetRestoreInfo struct {
	// Resource Id name of the container in which Target DataBase resides
	ContainerID *string

	// Database name InstanceName/DataBaseName for SQL or System/DbName for SAP Hana
	DatabaseName *string

	// Can Overwrite if Target DataBase already exists
	OverwriteOption *OverwriteOptions

	// Target directory location for restore as files.
	TargetDirectoryForFileRestore *string
}

// TieringCostInfo - Base class for tiering cost response
type TieringCostInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string
}

// GetTieringCostInfo implements the TieringCostInfoClassification interface for type TieringCostInfo.
func (t *TieringCostInfo) GetTieringCostInfo() *TieringCostInfo { return t }

// TieringCostRehydrationInfo - Response parameters for tiering cost info for rehydration
type TieringCostRehydrationInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// REQUIRED; Rehydration size in bytes
	RehydrationSizeInBytes *int64

	// REQUIRED; Source tier to target tier rehydration cost per GB per month
	RetailRehydrationCostPerGBPerMonth *float64
}

// GetTieringCostInfo implements the TieringCostInfoClassification interface for type TieringCostRehydrationInfo.
func (t *TieringCostRehydrationInfo) GetTieringCostInfo() *TieringCostInfo {
	return &TieringCostInfo{
		ObjectType: t.ObjectType,
	}
}

// TieringCostSavingInfo - Response parameters for tiering cost info for savings
type TieringCostSavingInfo struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// REQUIRED; Source tier retail cost per GB per month
	RetailSourceTierCostPerGBPerMonth *float64

	// REQUIRED; Target tier retail cost per GB per month
	RetailTargetTierCostPerGBPerMonth *float64

	// REQUIRED; Source tier size reduction in bytes after moving all the recommended backup points to target tier
	SourceTierSizeReductionInBytes *int64

	// REQUIRED; Target tier size increase in bytes after moving all the recommended backup points to target tier
	TargetTierSizeIncreaseInBytes *int64
}

// GetTieringCostInfo implements the TieringCostInfoClassification interface for type TieringCostSavingInfo.
func (t *TieringCostSavingInfo) GetTieringCostInfo() *TieringCostInfo {
	return &TieringCostInfo{
		ObjectType: t.ObjectType,
	}
}

// TieringPolicy - Tiering Policy for a target tier. If the policy is not specified for a given target tier, service retains
// the existing configured tiering policy for that tier
type TieringPolicy struct {
	// Number of days/weeks/months/years to retain backups in current tier before tiering. Used only if TieringMode is set to
	// TierAfter
	Duration *int32

	// Retention duration type: days/weeks/months/years Used only if TieringMode is set to TierAfter
	DurationType *RetentionDurationType

	// Tiering Mode to control automatic tiering of recovery points. Supported values are:
	// 1. TierRecommended: Tier all recovery points recommended to be tiered
	// 2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
	// 3. DoNotTier: Do not tier any recovery points
	TieringMode *TieringMode
}

// TokenInformation - The token information details.
type TokenInformation struct {
	// Expiry time of token.
	ExpiryTimeInUTCTicks *int64

	// Security PIN
	SecurityPIN *string

	// Token value.
	Token *string
}

// TriggerDataMoveRequest - Trigger DataMove Request
type TriggerDataMoveRequest struct {
	// REQUIRED; Correlation Id
	CorrelationID *string

	// REQUIRED; DataMove Level
	DataMoveLevel *DataMoveLevel

	// REQUIRED; Source Region
	SourceRegion *string

	// REQUIRED; ARM Id of source vault
	SourceResourceID *string

	// Pause GC
	PauseGC *bool

	// Source Container ArmIds
	SourceContainerArmIDs []*string
}

// UnlockDeleteRequest - Request body of unlock delete API.
type UnlockDeleteRequest struct {
	ResourceGuardOperationRequests []*string
	ResourceToBeDeleted            *string
}

// UnlockDeleteResponse - Response of Unlock Delete API.
type UnlockDeleteResponse struct {
	// This is the time when unlock delete privileges will get expired.
	UnlockDeleteExpiryTime *string
}

// UserAssignedIdentityProperties - User assigned managed identity properties
type UserAssignedIdentityProperties struct {
	// The client ID of the assigned identity.
	ClientID *string

	// The principal ID of the assigned identity.
	PrincipalID *string
}

// UserAssignedManagedIdentityDetails - User assigned managed identity details
type UserAssignedManagedIdentityDetails struct {
	// The ARM id of the assigned identity.
	IdentityArmID *string

	// The name of the assigned identity.
	IdentityName *string

	// User assigned managed identity properties
	UserAssignedIdentityProperties *UserAssignedIdentityProperties
}

// ValidateIaasVMRestoreOperationRequest - AzureRestoreValidation request.
type ValidateIaasVMRestoreOperationRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Sets restore request to be validated
	RestoreRequest RestoreRequestClassification
}

// GetValidateOperationRequest implements the ValidateOperationRequestClassification interface for type ValidateIaasVMRestoreOperationRequest.
func (v *ValidateIaasVMRestoreOperationRequest) GetValidateOperationRequest() *ValidateOperationRequest {
	return &ValidateOperationRequest{
		ObjectType: v.ObjectType,
	}
}

// GetValidateRestoreOperationRequest implements the ValidateRestoreOperationRequestClassification interface for type ValidateIaasVMRestoreOperationRequest.
func (v *ValidateIaasVMRestoreOperationRequest) GetValidateRestoreOperationRequest() *ValidateRestoreOperationRequest {
	return &ValidateRestoreOperationRequest{
		ObjectType:     v.ObjectType,
		RestoreRequest: v.RestoreRequest,
	}
}

// ValidateOperationRequest - Base class for validate operation request.
type ValidateOperationRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string
}

// GetValidateOperationRequest implements the ValidateOperationRequestClassification interface for type ValidateOperationRequest.
func (v *ValidateOperationRequest) GetValidateOperationRequest() *ValidateOperationRequest { return v }

// ValidateOperationRequestResource - Base class for validate operation request.
type ValidateOperationRequestResource struct {
	// REQUIRED; Recovery point ID.
	ID *string

	// REQUIRED; ValidateOperationRequestResource properties
	Properties ValidateOperationRequestClassification
}

// ValidateOperationResponse - Base class for validate operation response.
type ValidateOperationResponse struct {
	// Gets the validation result
	ValidationResults []*ErrorDetail
}

type ValidateOperationsResponse struct {
	// Base class for validate operation response.
	ValidateOperationResponse *ValidateOperationResponse
}

// ValidateRestoreOperationRequest - AzureRestoreValidation request.
type ValidateRestoreOperationRequest struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string

	// Sets restore request to be validated
	RestoreRequest RestoreRequestClassification
}

// GetValidateOperationRequest implements the ValidateOperationRequestClassification interface for type ValidateRestoreOperationRequest.
func (v *ValidateRestoreOperationRequest) GetValidateOperationRequest() *ValidateOperationRequest {
	return &ValidateOperationRequest{
		ObjectType: v.ObjectType,
	}
}

// GetValidateRestoreOperationRequest implements the ValidateRestoreOperationRequestClassification interface for type ValidateRestoreOperationRequest.
func (v *ValidateRestoreOperationRequest) GetValidateRestoreOperationRequest() *ValidateRestoreOperationRequest {
	return v
}

// VaultJob - Vault level Job
type VaultJob struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	JobType *string

	// Gets or sets the state/actions applicable on this job like cancel/retry.
	ActionsInfo []*JobSupportedAction

	// ActivityId of job.
	ActivityID *string

	// Backup management type to execute the current job.
	BackupManagementType *BackupManagementType

	// Time elapsed during the execution of this job.
	Duration *string

	// The end time.
	EndTime *time.Time

	// Friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string

	// Error details on execution of this job.
	ErrorDetails []*VaultJobErrorInfo

	// Additional information about the job.
	ExtendedInfo *VaultJobExtendedInfo

	// The operation name.
	Operation *string

	// The start time.
	StartTime *time.Time

	// Job status.
	Status *string
}

// GetJob implements the JobClassification interface for type VaultJob.
func (v *VaultJob) GetJob() *Job {
	return &Job{
		ActivityID:           v.ActivityID,
		BackupManagementType: v.BackupManagementType,
		EndTime:              v.EndTime,
		EntityFriendlyName:   v.EntityFriendlyName,
		JobType:              v.JobType,
		Operation:            v.Operation,
		StartTime:            v.StartTime,
		Status:               v.Status,
	}
}

// VaultJobErrorInfo - Vault Job specific error information
type VaultJobErrorInfo struct {
	// Error code.
	ErrorCode *int32

	// Localized error string.
	ErrorString *string

	// List of localized recommendations for above error code.
	Recommendations []*string
}

// VaultJobExtendedInfo - Vault Job for CMK - has CMK specific info.
type VaultJobExtendedInfo struct {
	// Job properties.
	PropertyBag map[string]*string
}

// VaultRetentionPolicy - Vault retention policy for AzureFileShare
type VaultRetentionPolicy struct {
	// REQUIRED
	SnapshotRetentionInDays *int32

	// REQUIRED; Base class for retention policy.
	VaultRetention RetentionPolicyClassification
}

// VaultStorageConfigOperationResultResponse - Operation result response for Vault Storage Config
type VaultStorageConfigOperationResultResponse struct {
	// REQUIRED; This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
	ObjectType *string
}

// GetVaultStorageConfigOperationResultResponse implements the VaultStorageConfigOperationResultResponseClassification interface
// for type VaultStorageConfigOperationResultResponse.
func (v *VaultStorageConfigOperationResultResponse) GetVaultStorageConfigOperationResultResponse() *VaultStorageConfigOperationResultResponse {
	return v
}

// WeeklyRetentionFormat - Weekly retention format.
type WeeklyRetentionFormat struct {
	// List of days of the week.
	DaysOfTheWeek []*DayOfWeek

	// List of weeks of month.
	WeeksOfTheMonth []*WeekOfMonth
}

// WeeklyRetentionSchedule - Weekly retention schedule.
type WeeklyRetentionSchedule struct {
	// List of days of week for weekly retention policy.
	DaysOfTheWeek []*DayOfWeek

	// Retention duration of retention Policy.
	RetentionDuration *RetentionDuration

	// Retention times of retention policy.
	RetentionTimes []*time.Time
}

type WeeklySchedule struct {
	ScheduleRunDays []*DayOfWeek

	// List of times of day this schedule has to be run.
	ScheduleRunTimes []*time.Time
}

// WorkloadInquiryDetails - Details of an inquired protectable item.
type WorkloadInquiryDetails struct {
	// Inquiry validation such as permissions and other backup validations.
	InquiryValidation *InquiryValidation

	// Contains the protectable item Count inside this Container.
	ItemCount *int64

	// Type of the Workload such as SQL, Oracle etc.
	Type *string
}

// WorkloadItem - Base class for backup item. Workload-specific backup items are derived from this class.
type WorkloadItem struct {
	// REQUIRED; Type of the backup item.
	WorkloadItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Type of workload for the backup management
	WorkloadType *string
}

// GetWorkloadItem implements the WorkloadItemClassification interface for type WorkloadItem.
func (w *WorkloadItem) GetWorkloadItem() *WorkloadItem { return w }

// WorkloadItemResource - Base class for backup item. Workload-specific backup items are derived from this class.
type WorkloadItemResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// WorkloadItemResource properties
	Properties WorkloadItemClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// WorkloadItemResourceList - List of WorkloadItem resources
type WorkloadItemResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*WorkloadItemResource
}

// WorkloadProtectableItem - Base class for backup item. Workload-specific backup items are derived from this class.
type WorkloadProtectableItem struct {
	// REQUIRED; Type of the backup item.
	ProtectableItemType *string

	// Type of backup management to backup an item.
	BackupManagementType *string

	// Friendly name of the backup item.
	FriendlyName *string

	// State of the back up item.
	ProtectionState *ProtectionStatus

	// Type of workload for the backup management
	WorkloadType *string
}

// GetWorkloadProtectableItem implements the WorkloadProtectableItemClassification interface for type WorkloadProtectableItem.
func (w *WorkloadProtectableItem) GetWorkloadProtectableItem() *WorkloadProtectableItem { return w }

// WorkloadProtectableItemResource - Base class for backup item. Workload-specific backup items are derived from this class.
type WorkloadProtectableItemResource struct {
	// Optional ETag.
	ETag *string

	// Resource location.
	Location *string

	// WorkloadProtectableItemResource properties
	Properties WorkloadProtectableItemClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource Id represents the complete path to the resource.
	ID *string

	// READ-ONLY; Resource name associated with the resource.
	Name *string

	// READ-ONLY; Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/…
	Type *string
}

// WorkloadProtectableItemResourceList - List of WorkloadProtectableItem resources
type WorkloadProtectableItemResourceList struct {
	// The uri to fetch the next page of resources. Call ListNext() fetches next page of resources.
	NextLink *string

	// List of resources.
	Value []*WorkloadProtectableItemResource
}

// YearlyRetentionSchedule - Yearly retention schedule.
type YearlyRetentionSchedule struct {
	// List of months of year of yearly retention policy.
	MonthsOfYear []*MonthOfYear

	// Retention duration of retention Policy.
	RetentionDuration *RetentionDuration

	// Daily retention format for yearly retention policy.
	RetentionScheduleDaily *DailyRetentionFormat

	// Retention schedule format for yearly retention policy.
	RetentionScheduleFormatType *RetentionScheduleFormat

	// Weekly retention format for yearly retention policy.
	RetentionScheduleWeekly *WeeklyRetentionFormat

	// Retention times of retention policy.
	RetentionTimes []*time.Time
}
