//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armresourceconnector

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resourceconnector/armresourceconnector"
	moduleVersion = "v1.1.0"
)

// AccessProfileType - Name which contains the role of the kubeconfig.
type AccessProfileType string

const (
	AccessProfileTypeClusterCustomerUser AccessProfileType = "clusterCustomerUser"
	AccessProfileTypeClusterUser         AccessProfileType = "clusterUser"
)

// PossibleAccessProfileTypeValues returns the possible values for the AccessProfileType const type.
func PossibleAccessProfileTypeValues() []AccessProfileType {
	return []AccessProfileType{
		AccessProfileTypeClusterCustomerUser,
		AccessProfileTypeClusterUser,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// Distro - Represents a supported Fabric/Infra. (AKSEdge etc…).
type Distro string

const (
	DistroAKSEdge Distro = "AKSEdge"
)

// PossibleDistroValues returns the possible values for the Distro const type.
func PossibleDistroValues() []Distro {
	return []Distro{
		DistroAKSEdge,
	}
}

// Provider - Information about the connected appliance.
type Provider string

const (
	ProviderHCI    Provider = "HCI"
	ProviderSCVMM  Provider = "SCVMM"
	ProviderVMWare Provider = "VMWare"
)

// PossibleProviderValues returns the possible values for the Provider const type.
func PossibleProviderValues() []Provider {
	return []Provider{
		ProviderHCI,
		ProviderSCVMM,
		ProviderVMWare,
	}
}

// ResourceIdentityType - The identity type.
type ResourceIdentityType string

const (
	ResourceIdentityTypeNone           ResourceIdentityType = "None"
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns the possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{
		ResourceIdentityTypeNone,
		ResourceIdentityTypeSystemAssigned,
	}
}

// Status - Appliance’s health and state of connection to on-prem
type Status string

const (
	StatusConnected                             Status = "Connected"
	StatusConnecting                            Status = "Connecting"
	StatusETCDSnapshotFailed                    Status = "ETCDSnapshotFailed"
	StatusImageDeprovisioning                   Status = "ImageDeprovisioning"
	StatusImageDownloaded                       Status = "ImageDownloaded"
	StatusImageDownloading                      Status = "ImageDownloading"
	StatusImagePending                          Status = "ImagePending"
	StatusImageProvisioned                      Status = "ImageProvisioned"
	StatusImageProvisioning                     Status = "ImageProvisioning"
	StatusImageUnknown                          Status = "ImageUnknown"
	StatusNone                                  Status = "None"
	StatusOffline                               Status = "Offline"
	StatusPostUpgrade                           Status = "PostUpgrade"
	StatusPreUpgrade                            Status = "PreUpgrade"
	StatusPreparingForUpgrade                   Status = "PreparingForUpgrade"
	StatusRunning                               Status = "Running"
	StatusUpdatingCAPI                          Status = "UpdatingCAPI"
	StatusUpdatingCloudOperator                 Status = "UpdatingCloudOperator"
	StatusUpdatingCluster                       Status = "UpdatingCluster"
	StatusUpgradeClusterExtensionFailedToDelete Status = "UpgradeClusterExtensionFailedToDelete"
	StatusUpgradeComplete                       Status = "UpgradeComplete"
	StatusUpgradeFailed                         Status = "UpgradeFailed"
	StatusUpgradePrerequisitesCompleted         Status = "UpgradePrerequisitesCompleted"
	StatusUpgradingKVAIO                        Status = "UpgradingKVAIO"
	StatusValidating                            Status = "Validating"
	StatusValidatingETCDHealth                  Status = "ValidatingETCDHealth"
	StatusValidatingImageDownload               Status = "ValidatingImageDownload"
	StatusValidatingImageUpload                 Status = "ValidatingImageUpload"
	StatusValidatingSFSConnectivity             Status = "ValidatingSFSConnectivity"
	StatusWaitingForCloudOperator               Status = "WaitingForCloudOperator"
	StatusWaitingForHeartbeat                   Status = "WaitingForHeartbeat"
	StatusWaitingForKVAIO                       Status = "WaitingForKVAIO"
)

// PossibleStatusValues returns the possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{
		StatusConnected,
		StatusConnecting,
		StatusETCDSnapshotFailed,
		StatusImageDeprovisioning,
		StatusImageDownloaded,
		StatusImageDownloading,
		StatusImagePending,
		StatusImageProvisioned,
		StatusImageProvisioning,
		StatusImageUnknown,
		StatusNone,
		StatusOffline,
		StatusPostUpgrade,
		StatusPreUpgrade,
		StatusPreparingForUpgrade,
		StatusRunning,
		StatusUpdatingCAPI,
		StatusUpdatingCloudOperator,
		StatusUpdatingCluster,
		StatusUpgradeClusterExtensionFailedToDelete,
		StatusUpgradeComplete,
		StatusUpgradeFailed,
		StatusUpgradePrerequisitesCompleted,
		StatusUpgradingKVAIO,
		StatusValidating,
		StatusValidatingETCDHealth,
		StatusValidatingImageDownload,
		StatusValidatingImageUpload,
		StatusValidatingSFSConnectivity,
		StatusWaitingForCloudOperator,
		StatusWaitingForHeartbeat,
		StatusWaitingForKVAIO,
	}
}
