//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resourcehealth/armresourcehealth"
	"net/http"
	"net/url"
	"regexp"
)

// EventServer is a fake server for instances of the armresourcehealth.EventClient type.
type EventServer struct {
	// FetchDetailsBySubscriptionIDAndTrackingID is the fake for method EventClient.FetchDetailsBySubscriptionIDAndTrackingID
	// HTTP status codes to indicate success: http.StatusOK
	FetchDetailsBySubscriptionIDAndTrackingID func(ctx context.Context, eventTrackingID string, options *armresourcehealth.EventClientFetchDetailsBySubscriptionIDAndTrackingIDOptions) (resp azfake.Responder[armresourcehealth.EventClientFetchDetailsBySubscriptionIDAndTrackingIDResponse], errResp azfake.ErrorResponder)

	// FetchDetailsByTenantIDAndTrackingID is the fake for method EventClient.FetchDetailsByTenantIDAndTrackingID
	// HTTP status codes to indicate success: http.StatusOK
	FetchDetailsByTenantIDAndTrackingID func(ctx context.Context, eventTrackingID string, options *armresourcehealth.EventClientFetchDetailsByTenantIDAndTrackingIDOptions) (resp azfake.Responder[armresourcehealth.EventClientFetchDetailsByTenantIDAndTrackingIDResponse], errResp azfake.ErrorResponder)

	// GetBySubscriptionIDAndTrackingID is the fake for method EventClient.GetBySubscriptionIDAndTrackingID
	// HTTP status codes to indicate success: http.StatusOK
	GetBySubscriptionIDAndTrackingID func(ctx context.Context, eventTrackingID string, options *armresourcehealth.EventClientGetBySubscriptionIDAndTrackingIDOptions) (resp azfake.Responder[armresourcehealth.EventClientGetBySubscriptionIDAndTrackingIDResponse], errResp azfake.ErrorResponder)

	// GetByTenantIDAndTrackingID is the fake for method EventClient.GetByTenantIDAndTrackingID
	// HTTP status codes to indicate success: http.StatusOK
	GetByTenantIDAndTrackingID func(ctx context.Context, eventTrackingID string, options *armresourcehealth.EventClientGetByTenantIDAndTrackingIDOptions) (resp azfake.Responder[armresourcehealth.EventClientGetByTenantIDAndTrackingIDResponse], errResp azfake.ErrorResponder)
}

// NewEventServerTransport creates a new instance of EventServerTransport with the provided implementation.
// The returned EventServerTransport instance is connected to an instance of armresourcehealth.EventClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEventServerTransport(srv *EventServer) *EventServerTransport {
	return &EventServerTransport{srv: srv}
}

// EventServerTransport connects instances of armresourcehealth.EventClient to instances of EventServer.
// Don't use this type directly, use NewEventServerTransport instead.
type EventServerTransport struct {
	srv *EventServer
}

// Do implements the policy.Transporter interface for EventServerTransport.
func (e *EventServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "EventClient.FetchDetailsBySubscriptionIDAndTrackingID":
		resp, err = e.dispatchFetchDetailsBySubscriptionIDAndTrackingID(req)
	case "EventClient.FetchDetailsByTenantIDAndTrackingID":
		resp, err = e.dispatchFetchDetailsByTenantIDAndTrackingID(req)
	case "EventClient.GetBySubscriptionIDAndTrackingID":
		resp, err = e.dispatchGetBySubscriptionIDAndTrackingID(req)
	case "EventClient.GetByTenantIDAndTrackingID":
		resp, err = e.dispatchGetByTenantIDAndTrackingID(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *EventServerTransport) dispatchFetchDetailsBySubscriptionIDAndTrackingID(req *http.Request) (*http.Response, error) {
	if e.srv.FetchDetailsBySubscriptionIDAndTrackingID == nil {
		return nil, &nonRetriableError{errors.New("fake for method FetchDetailsBySubscriptionIDAndTrackingID not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ResourceHealth/events/(?P<eventTrackingId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fetchEventDetails`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	eventTrackingIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventTrackingId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.FetchDetailsBySubscriptionIDAndTrackingID(req.Context(), eventTrackingIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Event, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EventServerTransport) dispatchFetchDetailsByTenantIDAndTrackingID(req *http.Request) (*http.Response, error) {
	if e.srv.FetchDetailsByTenantIDAndTrackingID == nil {
		return nil, &nonRetriableError{errors.New("fake for method FetchDetailsByTenantIDAndTrackingID not implemented")}
	}
	const regexStr = `/providers/Microsoft\.ResourceHealth/events/(?P<eventTrackingId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fetchEventDetails`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	eventTrackingIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventTrackingId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.FetchDetailsByTenantIDAndTrackingID(req.Context(), eventTrackingIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Event, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EventServerTransport) dispatchGetBySubscriptionIDAndTrackingID(req *http.Request) (*http.Response, error) {
	if e.srv.GetBySubscriptionIDAndTrackingID == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBySubscriptionIDAndTrackingID not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ResourceHealth/events/(?P<eventTrackingId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	queryStartTimeUnescaped, err := url.QueryUnescape(qp.Get("queryStartTime"))
	if err != nil {
		return nil, err
	}
	queryStartTimeParam := getOptional(queryStartTimeUnescaped)
	eventTrackingIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventTrackingId")])
	if err != nil {
		return nil, err
	}
	var options *armresourcehealth.EventClientGetBySubscriptionIDAndTrackingIDOptions
	if filterParam != nil || queryStartTimeParam != nil {
		options = &armresourcehealth.EventClientGetBySubscriptionIDAndTrackingIDOptions{
			Filter:         filterParam,
			QueryStartTime: queryStartTimeParam,
		}
	}
	respr, errRespr := e.srv.GetBySubscriptionIDAndTrackingID(req.Context(), eventTrackingIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Event, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EventServerTransport) dispatchGetByTenantIDAndTrackingID(req *http.Request) (*http.Response, error) {
	if e.srv.GetByTenantIDAndTrackingID == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByTenantIDAndTrackingID not implemented")}
	}
	const regexStr = `/providers/Microsoft\.ResourceHealth/events/(?P<eventTrackingId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
	if err != nil {
		return nil, err
	}
	filterParam := getOptional(filterUnescaped)
	queryStartTimeUnescaped, err := url.QueryUnescape(qp.Get("queryStartTime"))
	if err != nil {
		return nil, err
	}
	queryStartTimeParam := getOptional(queryStartTimeUnescaped)
	eventTrackingIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventTrackingId")])
	if err != nil {
		return nil, err
	}
	var options *armresourcehealth.EventClientGetByTenantIDAndTrackingIDOptions
	if filterParam != nil || queryStartTimeParam != nil {
		options = &armresourcehealth.EventClientGetByTenantIDAndTrackingIDOptions{
			Filter:         filterParam,
			QueryStartTime: queryStartTimeParam,
		}
	}
	respr, errRespr := e.srv.GetByTenantIDAndTrackingID(req.Context(), eventTrackingIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Event, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
