//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armscvmm

import "encoding/json"

func unmarshalInventoryItemPropertiesClassification(rawMsg json.RawMessage) (InventoryItemPropertiesClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b InventoryItemPropertiesClassification
	switch m["inventoryType"] {
	case string(InventoryTypeCloud):
		b = &CloudInventoryItem{}
	case string(InventoryTypeVirtualMachine):
		b = &VirtualMachineInventoryItem{}
	case string(InventoryTypeVirtualMachineTemplate):
		b = &VirtualMachineTemplateInventoryItem{}
	case string(InventoryTypeVirtualNetwork):
		b = &VirtualNetworkInventoryItem{}
	default:
		b = &InventoryItemProperties{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
